#include <qapplication.h>
#include <qgl.h>

class MyWindow : public QGLWidget
{
  public:
    MyWindow() : QGLWidget() { }
  protected:
    void initializeGL();
    void paintGL();
    void resizeGL(int w, int h);
};

// Set up the OpenGL rendering
void MyWindow::initializeGL()
{
  // black background
  glClearColor(0.0, 0.0, 0.0, 0.0);

  // setup viewing projection
  glMatrixMode(GL_PROJECTION);  

  // start with identity matrix
  glLoadIdentity();

  // setup a 10x10x2 viewing world
  glOrtho(0.0, 10.0, 0.0, 10.0, -1.0, 1.0); 
}


void MyWindow::paintGL()
{
  glClear(GL_COLOR_BUFFER_BIT);

  // The upper, filled, triangle
  glBegin(GL_POLYGON);
  glVertex3f(3.0, 6.0, 0.0);
  glVertex3f(5.0, 8.0, 0.0);
  glVertex3f(7.0, 6.0, 0.0);
  glEnd();

  // The lower triangle
  glBegin(GL_LINE_LOOP);
  glVertex3f(3.0, 4.0, 0.0);
  glVertex3f(5.0, 2.0, 0.0);
  glVertex3f(7.0, 4.0, 0.0);
  glEnd();

  glFlush();
}


// Resize
void MyWindow::resizeGL(int w, int h)
{
  glViewport( 0, 0, (GLint)w, (GLint)h );
}


int main(int argc, char **argv)
{
  QApplication app(argc, argv);
  MyWindow window;
  window.setGeometry(100,100,300,200);
  window.setCaption("OpenGL extension");
  app.setMainWidget(&window);
  window.show();
  return app.exec();
}