#include <stdio.h>

#include <qlabel.h>

#include <kabapi.h>

#include "kabdemo.h"


KabDemo::KabDemo (QWidget *parent, const char *name=0) :
  QLabel ("", parent, name)
{
  KabAPI kabapi (this);

  if (kabapi.init()!=AddressBook::NoError)
    {
      printf ("Error\n");
      exit (0);
    }

  AddressBook::Entry entry;
  KabKey key;
  if (kabapi.exec())
    {
      switch (kabapi.getEntry(entry, key))
	{
	case AddressBook::NoEntry:
	  printf ("Nothing selected.\n");
	  break;
	case AddressBook::NoError:
	  {
	    QString name;
	    kabapi.addressbook()->literalName(entry, name);
	    setText ("Name: "+name +"\nEmail: "+entry.emails[0]);
	  }
	  break;
	default:
	  printf ("Internal error.\n");
	}
    }
}



