/*
    Copyright (C) 2010  Bertjan Broeksema b.broeksema@home.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#ifndef COMBINEDINCIDENCEEDITOR_H
#define COMBINEDINCIDENCEEDITOR_H

#include "incidenceeditor-ng.h"
#include "../incidenceeditors_export.h"

namespace IncidenceEditorsNG {

/**
 * The CombinedIncidenceEditor combines optional widgets with zero or more
 * IncidenceEditors. The CombinedIncidenceEditor keeps track of the dirty state
 * of the IncidenceEditors that where combined.
 */
class INCIDENCEEDITORS_EXPORT CombinedIncidenceEditor : public IncidenceEditor
{
  Q_OBJECT
  public:
    CombinedIncidenceEditor( QWidget *parent = 0 );

    void combine( IncidenceEditor *other );
    
    /**
     * Returns wether or not the current values in the editor differ from the
     * initial values or if one of the combined editors is dirty.
     */
    virtual bool isDirty() const;
    virtual bool isValid();

    /**
     * Loads all data from @param inicidence into the combined editors. Note, if
     * you reimplement the load method in a subclass, make sure to call this
     * implementation too.
     */
    virtual void load( KCal::Incidence::ConstPtr incidence );
    virtual void save( KCal::Incidence::Ptr incidence );


  private slots:
    void handleDirtyStatusChange( bool isDirty );
    
  private:
    QVector<IncidenceEditor*> mCombinedEditors;
    int mDirtyEditorCount;
};

} // IncidenceEditorsNG

#endif // COMBINEDINCIDENCEEDITOR_H
