/* Background.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Background.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-background.h>
#include <gee.h>
#include <gio/gio.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/meta-background-image.h>
#include <mtk/mtk.h>

#define GALA_BACKGROUND_ANIMATION_OPACITY_STEP_INCREMENT 4.0
#define GALA_BACKGROUND_ANIMATION_MIN_WAKEUP_INTERVAL 1.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND (gala_background_get_type ())
#define GALA_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND, GalaBackground))
#define GALA_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND, GalaBackgroundClass))
#define GALA_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND))
#define GALA_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND))
#define GALA_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND, GalaBackgroundClass))

typedef struct _GalaBackground GalaBackground;
typedef struct _GalaBackgroundClass GalaBackgroundClass;
typedef struct _GalaBackgroundPrivate GalaBackgroundPrivate;

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;

#define GALA_TYPE_ANIMATION (gala_animation_get_type ())
#define GALA_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ANIMATION, GalaAnimation))
#define GALA_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ANIMATION, GalaAnimationClass))
#define GALA_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ANIMATION))
#define GALA_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ANIMATION))
#define GALA_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ANIMATION, GalaAnimationClass))

typedef struct _GalaAnimation GalaAnimation;
typedef struct _GalaAnimationClass GalaAnimationClass;
enum  {
	GALA_BACKGROUND_0_PROPERTY,
	GALA_BACKGROUND_DISPLAY_PROPERTY,
	GALA_BACKGROUND_MONITOR_INDEX_PROPERTY,
	GALA_BACKGROUND_BACKGROUND_SOURCE_PROPERTY,
	GALA_BACKGROUND_IS_LOADED_PROPERTY,
	GALA_BACKGROUND_STYLE_PROPERTY,
	GALA_BACKGROUND_FILENAME_PROPERTY,
	GALA_BACKGROUND_BACKGROUND_PROPERTY,
	GALA_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* gala_background_properties[GALA_BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_TYPE_BACKGROUND_CACHE (gala_background_cache_get_type ())
#define GALA_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache))
#define GALA_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))
#define GALA_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))

typedef struct _GalaBackgroundCache GalaBackgroundCache;
typedef struct _GalaBackgroundCacheClass GalaBackgroundCacheClass;
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
typedef struct _Block35Data Block35Data;
typedef struct _Block36Data Block36Data;
typedef struct _Block37Data Block37Data;
typedef struct _Block38Data Block38Data;
typedef struct _GalaBackgroundLoadAnimationData GalaBackgroundLoadAnimationData;
typedef struct _Block39Data Block39Data;
typedef struct _Block40Data Block40Data;
enum  {
	GALA_BACKGROUND_CHANGED_SIGNAL,
	GALA_BACKGROUND_LOADED_SIGNAL,
	GALA_BACKGROUND_NUM_SIGNALS
};
static guint gala_background_signals[GALA_BACKGROUND_NUM_SIGNALS] = {0};

struct _GalaBackground {
	GObject parent_instance;
	GalaBackgroundPrivate * priv;
};

struct _GalaBackgroundClass {
	GObjectClass parent_class;
};

struct _GalaBackgroundPrivate {
	MetaDisplay* _display;
	gint _monitor_index;
	GalaBackgroundSource* _background_source;
	gboolean _is_loaded;
	GDesktopBackgroundStyle _style;
	gchar* _filename;
	MetaBackground* _background;
	GalaAnimation* animation;
	GeeHashMap* file_watches;
	GCancellable* cancellable;
	guint update_animation_timeout_id;
	GnomeWallClock* clock;
	gulong clock_timezone_handler;
};

struct _Block35Data {
	int _ref_count_;
	GalaBackground* self;
	gchar* filename;
};

struct _Block36Data {
	int _ref_count_;
	GalaBackground* self;
	gchar** files;
	gint files_length1;
	gint _files_size_;
	gint num_pending_images;
};

struct _Block37Data {
	int _ref_count_;
	Block36Data * _data36_;
	MetaBackgroundImage* image;
};

struct _Block38Data {
	int _ref_count_;
	Block37Data * _data37_;
	gulong handler;
};

struct _GalaBackgroundLoadAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaBackground* self;
	gchar* filename;
	GalaBackgroundCache* _tmp0_;
	GalaAnimation* _tmp1_;
	gboolean _tmp2_;
	GalaAnimation* _tmp3_;
	GCancellable* _tmp4_;
};

struct _Block39Data {
	int _ref_count_;
	GalaBackground* self;
	MetaBackgroundImage* image;
};

struct _Block40Data {
	int _ref_count_;
	Block39Data * _data39_;
	gulong handler;
};

static gint GalaBackground_private_offset;
static gpointer gala_background_parent_class = NULL;

VALA_EXTERN GType gala_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackground, g_object_unref)
VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GType gala_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAnimation, g_object_unref)
VALA_EXTERN GalaBackground* gala_background_new (MetaDisplay* display,
                                     gint monitor_index,
                                     const gchar* filename,
                                     GalaBackgroundSource* background_source,
                                     GDesktopBackgroundStyle style);
VALA_EXTERN GalaBackground* gala_background_construct (GType object_type,
                                           MetaDisplay* display,
                                           gint monitor_index,
                                           const gchar* filename,
                                           GalaBackgroundSource* background_source,
                                           GDesktopBackgroundStyle style);
VALA_EXTERN void gala_background_destroy (GalaBackground* self);
static void gala_background_remove_animation_timeout (GalaBackground* self);
VALA_EXTERN GType gala_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundCache, g_object_unref)
VALA_EXTERN GalaBackgroundCache* gala_background_cache_get_default (void);
VALA_EXTERN GalaBackgroundSource* gala_background_get_background_source (GalaBackground* self);
static void gala_background_settings_changed (GalaBackground* self);
static void _gala_background_settings_changed_gala_background_source_changed (GalaBackgroundSource* _sender,
                                                                       gpointer self);
VALA_EXTERN void gala_background_update_resolution (GalaBackground* self);
static void gala_background_update_animation (GalaBackground* self);
static void gala_background_set_loaded (GalaBackground* self);
VALA_EXTERN gboolean gala_background_get_is_loaded (GalaBackground* self);
static void gala_background_set_is_loaded (GalaBackground* self,
                                    gboolean value);
static gboolean __lambda24_ (GalaBackground* self);
static gboolean ___lambda24__gsource_func (gpointer self);
static void gala_background_load_pattern (GalaBackground* self);
VALA_EXTERN GSettings* gala_background_source_get_gnome_background_settings (GalaBackgroundSource* self);
static void _vala_ClutterColor_free (ClutterColor* self);
VALA_EXTERN MetaBackground* gala_background_get_background (GalaBackground* self);
static void gala_background_watch_file (GalaBackground* self,
                                 const gchar* filename);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
VALA_EXTERN void gala_background_cache_monitor_file (GalaBackgroundCache* self,
                                         const gchar* filename);
static void __lambda23_ (Block35Data* _data35_,
                  const gchar* changed_file);
static void ___lambda23__gala_background_cache_file_changed (GalaBackgroundCache* _sender,
                                                      const gchar* filename,
                                                      gpointer self);
static void gala_background_finish_animation (GalaBackground* self,
                                       gchar** files,
                                       gint files_length1);
VALA_EXTERN gdouble gala_animation_get_transition_progress (GalaAnimation* self);
VALA_EXTERN GDesktopBackgroundStyle gala_background_get_style (GalaBackground* self);
static void gala_background_queue_update_animation (GalaBackground* self);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
VALA_EXTERN void gala_animation_update (GalaAnimation* self,
                            MtkRectangle* monitor);
VALA_EXTERN MetaDisplay* gala_background_get_display (GalaBackground* self);
VALA_EXTERN gint gala_background_get_monitor_index (GalaBackground* self);
VALA_EXTERN gchar** gala_animation_get_key_frame_files (GalaAnimation* self,
                                            gint* result_length1);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void ______lambda26_ (Block38Data* _data38_);
static void _______lambda26__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                                    gpointer self);
VALA_EXTERN gdouble gala_animation_get_transition_duration (GalaAnimation* self);
static gboolean __lambda25_ (GalaBackground* self);
static gboolean ___lambda25__gsource_func (gpointer self);
static void gala_background_load_animation_data_free (gpointer _data);
static void gala_background_load_animation (GalaBackground* self,
                                     const gchar* filename,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void gala_background_load_animation_finish (GalaBackground* self,
                                            GAsyncResult* _res_);
static gboolean gala_background_load_animation_co (GalaBackgroundLoadAnimationData* _data_);
VALA_EXTERN void gala_background_cache_get_animation (GalaBackgroundCache* self,
                                          const gchar* filename,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN GalaAnimation* gala_background_cache_get_animation_finish (GalaBackgroundCache* self,
                                                           GAsyncResult* _res_);
static void gala_background_load_animation_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void gala_background_load_image (GalaBackground* self,
                                 const gchar* filename);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static void ___lambda28_ (Block40Data* _data40_);
static void ____lambda28__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                                 gpointer self);
static void gala_background_load_file (GalaBackground* self,
                                const gchar* filename);
static void gala_background_load (GalaBackground* self);
VALA_EXTERN const gchar* gala_background_get_filename (GalaBackground* self);
static void gala_background_set_display (GalaBackground* self,
                                  MetaDisplay* value);
static void gala_background_set_monitor_index (GalaBackground* self,
                                        gint value);
static void gala_background_set_background_source (GalaBackground* self,
                                            GalaBackgroundSource* value);
static void gala_background_set_style (GalaBackground* self,
                                GDesktopBackgroundStyle value);
static void gala_background_set_filename (GalaBackground* self,
                                   const gchar* value);
static void gala_background_set_background (GalaBackground* self,
                                     MetaBackground* value);
static GObject * gala_background_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _gala_background___lambda29_ (GalaBackground* self);
VALA_EXTERN const gchar* gala_animation_get_filename (GalaAnimation* self);
static void __gala_background___lambda29__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void gala_background_finalize (GObject * obj);
static GType gala_background_get_type_once (void);
static void _vala_gala_background_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gala_background_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gala_background_get_instance_private (GalaBackground* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackground_private_offset);
}

GalaBackground*
gala_background_construct (GType object_type,
                           MetaDisplay* display,
                           gint monitor_index,
                           const gchar* filename,
                           GalaBackgroundSource* background_source,
                           GDesktopBackgroundStyle style)
{
	GalaBackground * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (background_source != NULL, NULL);
	self = (GalaBackground*) g_object_new (object_type, "display", display, "monitor-index", monitor_index, "background-source", background_source, "style", style, "filename", filename, NULL);
	return self;
}

GalaBackground*
gala_background_new (MetaDisplay* display,
                     gint monitor_index,
                     const gchar* filename,
                     GalaBackgroundSource* background_source,
                     GDesktopBackgroundStyle style)
{
	return gala_background_construct (GALA_TYPE_BACKGROUND, display, monitor_index, filename, background_source, style);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_background_settings_changed_gala_background_source_changed (GalaBackgroundSource* _sender,
                                                                  gpointer self)
{
	gala_background_settings_changed ((GalaBackground*) self);
}

void
gala_background_destroy (GalaBackground* self)
{
	GCancellable* _tmp0_;
	GalaBackgroundCache* cache = NULL;
	GalaBackgroundCache* _tmp1_;
	GalaBackgroundCache* _tmp2_;
	GalaBackgroundSource* _tmp13_;
	guint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	gala_background_remove_animation_timeout (self);
	_tmp1_ = gala_background_cache_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cache = _tmp2_;
	{
		GeeIterator* _watch_it = NULL;
		GeeHashMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp3_ = self->priv->file_watches;
		_tmp4_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_watch_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			gulong watch = 0UL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GalaBackgroundCache* _tmp12_;
			_tmp9_ = _watch_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _watch_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			watch = (gulong) ((guintptr) _tmp11_);
			_tmp12_ = cache;
			g_signal_handler_disconnect ((GObject*) _tmp12_, watch);
		}
		_g_object_unref0 (_watch_it);
	}
	_tmp13_ = self->priv->_background_source;
	g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND_SOURCE, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _gala_background_settings_changed_gala_background_source_changed, self);
	if (self->priv->clock_timezone_handler != ((gulong) 0)) {
		GnomeWallClock* _tmp15_;
		_tmp15_ = self->priv->clock;
		g_signal_handler_disconnect ((GObject*) _tmp15_, self->priv->clock_timezone_handler);
	}
	_g_object_unref0 (cache);
}

void
gala_background_update_resolution (GalaBackground* self)
{
	GalaAnimation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animation;
	if (_tmp0_ != NULL) {
		gala_background_remove_animation_timeout (self);
		gala_background_update_animation (self);
	}
}

static gboolean
__lambda24_ (GalaBackground* self)
{
	gboolean result;
	g_signal_emit (self, gala_background_signals[GALA_BACKGROUND_LOADED_SIGNAL], 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda24__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda24_ ((GalaBackground*) self);
	return result;
}

static void
gala_background_set_loaded (GalaBackground* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_loaded;
	if (_tmp0_) {
		return;
	}
	gala_background_set_is_loaded (self, TRUE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda24__gsource_func, g_object_ref (self), g_object_unref);
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static void
gala_background_load_pattern (GalaBackground* self)
{
	gchar* color_string = NULL;
	GSettings* settings = NULL;
	GalaBackgroundSource* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	ClutterColor* color = NULL;
	const gchar* _tmp6_;
	ClutterColor* _tmp7_;
	ClutterColor* _tmp8_;
	gint shading_type = 0;
	GSettings* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background_source;
	_tmp1_ = gala_background_source_get_gnome_background_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	settings = _tmp3_;
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "primary-color");
	_g_free0 (color_string);
	color_string = _tmp5_;
	_tmp6_ = color_string;
	_tmp7_ = _vala_clutter_color_from_string (_tmp6_);
	color = _tmp7_;
	_tmp8_ = color;
	if (_tmp8_ == NULL) {
		ClutterColor* _tmp9_;
		_tmp9_ = _vala_clutter_color_from_string ("black");
		__vala_ClutterColor_free0 (color);
		color = _tmp9_;
	}
	_tmp10_ = settings;
	shading_type = g_settings_get_enum (_tmp10_, "color-shading-type");
	if (shading_type == ((gint) G_DESKTOP_BACKGROUND_SHADING_SOLID)) {
		MetaBackground* _tmp11_;
		ClutterColor* _tmp12_;
		ClutterColor _tmp13_;
		_tmp11_ = self->priv->_background;
		_tmp12_ = color;
		_tmp13_ = *_tmp12_;
		meta_background_set_color (_tmp11_, &_tmp13_);
	} else {
		GSettings* _tmp14_;
		gchar* _tmp15_;
		ClutterColor* second_color = NULL;
		const gchar* _tmp16_;
		ClutterColor* _tmp17_;
		ClutterColor* _tmp18_;
		MetaBackground* _tmp20_;
		ClutterColor* _tmp21_;
		ClutterColor* _tmp22_;
		ClutterColor _tmp23_;
		ClutterColor _tmp24_;
		_tmp14_ = settings;
		_tmp15_ = g_settings_get_string (_tmp14_, "secondary-color");
		_g_free0 (color_string);
		color_string = _tmp15_;
		_tmp16_ = color_string;
		_tmp17_ = _vala_clutter_color_from_string (_tmp16_);
		second_color = _tmp17_;
		_tmp18_ = second_color;
		if (_tmp18_ == NULL) {
			ClutterColor* _tmp19_;
			_tmp19_ = _vala_clutter_color_from_string ("black");
			__vala_ClutterColor_free0 (second_color);
			second_color = _tmp19_;
		}
		_tmp20_ = self->priv->_background;
		_tmp21_ = color;
		_tmp22_ = second_color;
		_tmp23_ = *_tmp21_;
		_tmp24_ = *_tmp22_;
		meta_background_set_gradient (_tmp20_, (GDesktopBackgroundShading) shading_type, &_tmp23_, &_tmp24_);
		__vala_ClutterColor_free0 (second_color);
	}
	__vala_ClutterColor_free0 (color);
	_g_object_unref0 (settings);
	_g_free0 (color_string);
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		GalaBackground* self;
		self = _data35_->self;
		_g_free0 (_data35_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static void
__lambda23_ (Block35Data* _data35_,
             const gchar* changed_file)
{
	GalaBackground* self;
	self = _data35_->self;
	g_return_if_fail (changed_file != NULL);
	if (g_strcmp0 (changed_file, _data35_->filename) == 0) {
		MetaBackgroundImageCache* image_cache = NULL;
		MetaBackgroundImageCache* _tmp0_;
		MetaBackgroundImageCache* _tmp1_;
		MetaBackgroundImageCache* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp0_ = meta_background_image_cache_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		image_cache = _tmp1_;
		_tmp2_ = image_cache;
		_tmp3_ = g_file_new_for_path (changed_file);
		_tmp4_ = _tmp3_;
		meta_background_image_cache_purge (_tmp2_, _tmp4_);
		_g_object_unref0 (_tmp4_);
		g_signal_emit (self, gala_background_signals[GALA_BACKGROUND_CHANGED_SIGNAL], 0);
		_g_object_unref0 (image_cache);
	}
}

static void
___lambda23__gala_background_cache_file_changed (GalaBackgroundCache* _sender,
                                                 const gchar* filename,
                                                 gpointer self)
{
	__lambda23_ (self, filename);
}

static void
gala_background_watch_file (GalaBackground* self,
                            const gchar* filename)
{
	Block35Data* _data35_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GalaBackgroundCache* cache = NULL;
	GalaBackgroundCache* _tmp2_;
	GalaBackgroundCache* _tmp3_;
	GalaBackgroundCache* _tmp4_;
	GeeHashMap* _tmp5_;
	GalaBackgroundCache* _tmp6_;
	gulong _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data35_->filename);
	_data35_->filename = _tmp0_;
	_tmp1_ = self->priv->file_watches;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _data35_->filename)) {
		block35_data_unref (_data35_);
		_data35_ = NULL;
		return;
	}
	_tmp2_ = gala_background_cache_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	cache = _tmp3_;
	_tmp4_ = cache;
	gala_background_cache_monitor_file (_tmp4_, _data35_->filename);
	_tmp5_ = self->priv->file_watches;
	_tmp6_ = cache;
	_tmp7_ = g_signal_connect_data (_tmp6_, "file-changed", (GCallback) ___lambda23__gala_background_cache_file_changed, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _data35_->filename, (gpointer) ((guintptr) _tmp7_));
	_g_object_unref0 (cache);
	block35_data_unref (_data35_);
	_data35_ = NULL;
}

static void
gala_background_remove_animation_timeout (GalaBackground* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_animation_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->update_animation_timeout_id);
		self->priv->update_animation_timeout_id = (guint) 0;
	}
}

static void
gala_background_finish_animation (GalaBackground* self,
                                  gchar** files,
                                  gint files_length1)
{
	g_return_if_fail (self != NULL);
	gala_background_set_loaded (self);
	if (files_length1 > 1) {
		MetaBackground* _tmp0_;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GalaAnimation* _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		GDesktopBackgroundStyle _tmp10_;
		_tmp0_ = self->priv->_background;
		_tmp1_ = files[0];
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = files[1];
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->animation;
		_tmp8_ = gala_animation_get_transition_progress (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_style;
		meta_background_set_blend (_tmp0_, _tmp3_, _tmp6_, _tmp9_, _tmp10_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp3_);
	} else {
		if (files_length1 > 0) {
			MetaBackground* _tmp11_;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			GDesktopBackgroundStyle _tmp15_;
			_tmp11_ = self->priv->_background;
			_tmp12_ = files[0];
			_tmp13_ = g_file_new_for_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_style;
			meta_background_set_file (_tmp11_, _tmp14_, _tmp15_);
			_g_object_unref0 (_tmp14_);
		} else {
			MetaBackground* _tmp16_;
			GDesktopBackgroundStyle _tmp17_;
			_tmp16_ = self->priv->_background;
			_tmp17_ = self->priv->_style;
			meta_background_set_file (_tmp16_, NULL, _tmp17_);
		}
	}
	gala_background_queue_update_animation (self);
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		GalaBackground* self;
		self = _data36_->self;
		_data36_->files = (_vala_array_free (_data36_->files, _data36_->files_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		GalaBackground* self;
		self = _data37_->_data36_->self;
		_g_object_unref0 (_data37_->image);
		block36_data_unref (_data37_->_data36_);
		_data37_->_data36_ = NULL;
		g_slice_free (Block37Data, _data37_);
	}
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		GalaBackground* self;
		self = _data38_->_data37_->_data36_->self;
		block37_data_unref (_data38_->_data37_);
		_data38_->_data37_ = NULL;
		g_slice_free (Block38Data, _data38_);
	}
}

static void
______lambda26_ (Block38Data* _data38_)
{
	Block37Data* _data37_;
	Block36Data* _data36_;
	GalaBackground* self;
	MetaBackgroundImage* _tmp0_;
	gint _tmp1_;
	_data37_ = _data38_->_data37_;
	_data36_ = _data37_->_data36_;
	self = _data36_->self;
	_tmp0_ = _data37_->image;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data38_->handler);
	_data36_->num_pending_images = _data36_->num_pending_images - 1;
	_tmp1_ = _data36_->num_pending_images;
	if (_tmp1_ == 0) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = _data36_->files;
		_tmp2__length1 = _data36_->files_length1;
		gala_background_finish_animation (self, _tmp2_, (gint) _tmp2__length1);
	}
}

static void
_______lambda26__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                               gpointer self)
{
	______lambda26_ (self);
}

static void
gala_background_update_animation (GalaBackground* self)
{
	Block36Data* _data36_;
	GalaAnimation* _tmp0_;
	MetaDisplay* _tmp1_;
	gint _tmp2_;
	MtkRectangle _tmp3_ = {0};
	GalaAnimation* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	MetaBackgroundImageCache* cache = NULL;
	MetaBackgroundImageCache* _tmp9_;
	MetaBackgroundImageCache* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	self->priv->update_animation_timeout_id = (guint) 0;
	_tmp0_ = self->priv->animation;
	_tmp1_ = self->priv->_display;
	_tmp2_ = self->priv->_monitor_index;
	meta_display_get_monitor_geometry (_tmp1_, _tmp2_, &_tmp3_);
	gala_animation_update (_tmp0_, &_tmp3_);
	_tmp4_ = self->priv->animation;
	_tmp5_ = gala_animation_get_key_frame_files (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup4 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_data36_->files = _tmp8_;
	_data36_->files_length1 = _tmp8__length1;
	_data36_->_files_size_ = _data36_->files_length1;
	_tmp9_ = meta_background_image_cache_get_default ();
	_tmp10_ = _g_object_ref0 (_tmp9_);
	cache = _tmp10_;
	_tmp11_ = _data36_->files;
	_tmp11__length1 = _data36_->files_length1;
	_data36_->num_pending_images = _tmp11__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				Block37Data* _data37_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				MetaBackgroundImageCache* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				GFile* _tmp20_;
				GFile* _tmp21_;
				MetaBackgroundImage* _tmp22_;
				MetaBackgroundImage* _tmp23_;
				MetaBackgroundImage* _tmp24_;
				_data37_ = g_slice_new0 (Block37Data);
				_data37_->_ref_count_ = 1;
				_data37_->_data36_ = block36_data_ref (_data36_);
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = _data36_->files;
				_tmp14__length1 = _data36_->files_length1;
				if (!(i < _tmp14__length1)) {
					block37_data_unref (_data37_);
					_data37_ = NULL;
					break;
				}
				_tmp15_ = _data36_->files;
				_tmp15__length1 = _data36_->files_length1;
				_tmp16_ = _tmp15_[i];
				gala_background_watch_file (self, _tmp16_);
				_tmp17_ = cache;
				_tmp18_ = _data36_->files;
				_tmp18__length1 = _data36_->files_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = g_file_new_for_path (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = meta_background_image_cache_load (_tmp17_, _tmp21_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp21_);
				_data37_->image = _tmp23_;
				_tmp24_ = _data37_->image;
				if (meta_background_image_is_loaded (_tmp24_)) {
					gint _tmp25_;
					_tmp25_ = _data36_->num_pending_images;
					_data36_->num_pending_images = _tmp25_ - 1;
					if (_data36_->num_pending_images == 0) {
						gchar** _tmp26_;
						gint _tmp26__length1;
						_tmp26_ = _data36_->files;
						_tmp26__length1 = _data36_->files_length1;
						gala_background_finish_animation (self, _tmp26_, (gint) _tmp26__length1);
					}
				} else {
					Block38Data* _data38_;
					MetaBackgroundImage* _tmp27_;
					gulong _tmp28_;
					_data38_ = g_slice_new0 (Block38Data);
					_data38_->_ref_count_ = 1;
					_data38_->_data37_ = block37_data_ref (_data37_);
					_data38_->handler = (gulong) 0;
					_tmp27_ = _data37_->image;
					_tmp28_ = g_signal_connect_data (_tmp27_, "loaded", (GCallback) _______lambda26__meta_background_image_loaded, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
					_data38_->handler = _tmp28_;
					block38_data_unref (_data38_);
					_data38_ = NULL;
				}
				block37_data_unref (_data37_);
				_data37_ = NULL;
			}
		}
	}
	_g_object_unref0 (cache);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}

static gboolean
__lambda25_ (GalaBackground* self)
{
	gboolean result;
	self->priv->update_animation_timeout_id = (guint) 0;
	gala_background_update_animation (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda25_ ((GalaBackground*) self);
	return result;
}

static void
gala_background_queue_update_animation (GalaBackground* self)
{
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	GalaAnimation* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble n_steps = 0.0;
	gdouble time_per_step = 0.0;
	GalaAnimation* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	guint32 interval = 0U;
	g_return_if_fail (self != NULL);
	if (self->priv->update_animation_timeout_id != ((guint) 0)) {
		return;
	}
	_tmp1_ = self->priv->cancellable;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_;
		_tmp2_ = self->priv->cancellable;
		_tmp0_ = g_cancellable_is_cancelled (_tmp2_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->animation;
	_tmp4_ = gala_animation_get_transition_duration (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == ((gdouble) 0)) {
		return;
	}
	n_steps = 255.0 / GALA_BACKGROUND_ANIMATION_OPACITY_STEP_INCREMENT;
	_tmp6_ = self->priv->animation;
	_tmp7_ = gala_animation_get_transition_duration (_tmp6_);
	_tmp8_ = _tmp7_;
	time_per_step = (_tmp8_ * 1000) / n_steps;
	interval = (guint32) fmax (GALA_BACKGROUND_ANIMATION_MIN_WAKEUP_INTERVAL * 1000, time_per_step);
	if (interval > G_MAXUINT32) {
		return;
	}
	self->priv->update_animation_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) interval, ___lambda25__gsource_func, g_object_ref (self), g_object_unref);
}

static void
gala_background_load_animation_data_free (gpointer _data)
{
	GalaBackgroundLoadAnimationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaBackgroundLoadAnimationData, _data_);
}

static void
gala_background_load_animation (GalaBackground* self,
                                const gchar* filename,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GalaBackgroundLoadAnimationData* _data_;
	GalaBackground* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (GalaBackgroundLoadAnimationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_background_load_animation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	gala_background_load_animation_co (_data_);
}

static void
gala_background_load_animation_finish (GalaBackground* self,
                                       GAsyncResult* _res_)
{
	GalaBackgroundLoadAnimationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_background_load_animation_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GalaBackgroundLoadAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_background_load_animation_co (_data_);
}

static gboolean
gala_background_load_animation_co (GalaBackgroundLoadAnimationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gala_background_cache_get_default ();
	_data_->_state_ = 1;
	gala_background_cache_get_animation (_data_->_tmp0_, _data_->filename, gala_background_load_animation_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = gala_background_cache_get_animation_finish (_data_->_tmp0_, _data_->_res_);
	_g_object_unref0 (_data_->self->priv->animation);
	_data_->self->priv->animation = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->animation;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->cancellable;
		_data_->_tmp2_ = g_cancellable_is_cancelled (_data_->_tmp4_);
	}
	if (_data_->_tmp2_) {
		gala_background_set_loaded (_data_->self);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gala_background_update_animation (_data_->self);
	gala_background_watch_file (_data_->self, _data_->filename);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		GalaBackground* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->image);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		GalaBackground* self;
		self = _data40_->_data39_->self;
		block39_data_unref (_data40_->_data39_);
		_data40_->_data39_ = NULL;
		g_slice_free (Block40Data, _data40_);
	}
}

static void
___lambda28_ (Block40Data* _data40_)
{
	Block39Data* _data39_;
	GalaBackground* self;
	MetaBackgroundImage* _tmp0_;
	_data39_ = _data40_->_data39_;
	self = _data39_->self;
	gala_background_set_loaded (self);
	_tmp0_ = _data39_->image;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data40_->handler);
}

static void
____lambda28__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                            gpointer self)
{
	___lambda28_ (self);
}

static void
gala_background_load_image (GalaBackground* self,
                            const gchar* filename)
{
	Block39Data* _data39_;
	MetaBackground* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GDesktopBackgroundStyle _tmp3_;
	MetaBackgroundImageCache* cache = NULL;
	MetaBackgroundImageCache* _tmp4_;
	MetaBackgroundImageCache* _tmp5_;
	MetaBackgroundImageCache* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	MetaBackgroundImage* _tmp9_;
	MetaBackgroundImage* _tmp10_;
	MetaBackgroundImage* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = self->priv->_background;
	_tmp1_ = g_file_new_for_path (filename);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_style;
	meta_background_set_file (_tmp0_, _tmp2_, _tmp3_);
	_g_object_unref0 (_tmp2_);
	gala_background_watch_file (self, filename);
	_tmp4_ = meta_background_image_cache_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	cache = _tmp5_;
	_tmp6_ = cache;
	_tmp7_ = g_file_new_for_path (filename);
	_tmp8_ = _tmp7_;
	_tmp9_ = meta_background_image_cache_load (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_data39_->image = _tmp10_;
	_tmp11_ = _data39_->image;
	if (meta_background_image_is_loaded (_tmp11_)) {
		gala_background_set_loaded (self);
	} else {
		Block40Data* _data40_;
		MetaBackgroundImage* _tmp12_;
		gulong _tmp13_;
		_data40_ = g_slice_new0 (Block40Data);
		_data40_->_ref_count_ = 1;
		_data40_->_data39_ = block39_data_ref (_data39_);
		_data40_->handler = (gulong) 0;
		_tmp12_ = _data39_->image;
		_tmp13_ = g_signal_connect_data (_tmp12_, "loaded", (GCallback) ____lambda28__meta_background_image_loaded, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
		_data40_->handler = _tmp13_;
		block40_data_unref (_data40_);
		_data40_ = NULL;
	}
	_g_object_unref0 (cache);
	block39_data_unref (_data39_);
	_data39_ = NULL;
}

static void
gala_background_load_file (GalaBackground* self,
                           const gchar* filename)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	if (g_str_has_suffix (filename, ".xml")) {
		gala_background_load_animation (self, filename, NULL, NULL);
	} else {
		gala_background_load_image (self, filename);
	}
}

static void
gala_background_load (GalaBackground* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	gala_background_load_pattern (self);
	_tmp0_ = self->priv->_filename;
	if (_tmp0_ == NULL) {
		gala_background_set_loaded (self);
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_filename;
		gala_background_load_file (self, _tmp1_);
	}
}

static void
gala_background_settings_changed (GalaBackground* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, gala_background_signals[GALA_BACKGROUND_CHANGED_SIGNAL], 0);
}

MetaDisplay*
gala_background_get_display (GalaBackground* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_background_set_display (GalaBackground* self,
                             MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_DISPLAY_PROPERTY]);
	}
}

gint
gala_background_get_monitor_index (GalaBackground* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor_index;
	return result;
}

static void
gala_background_set_monitor_index (GalaBackground* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_monitor_index (self);
	if (old_value != value) {
		self->priv->_monitor_index = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_MONITOR_INDEX_PROPERTY]);
	}
}

GalaBackgroundSource*
gala_background_get_background_source (GalaBackground* self)
{
	GalaBackgroundSource* result;
	GalaBackgroundSource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background_source;
	result = _tmp0_;
	return result;
}

static void
gala_background_set_background_source (GalaBackground* self,
                                       GalaBackgroundSource* value)
{
	GalaBackgroundSource* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_background_source (self);
	if (old_value != value) {
		GalaBackgroundSource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background_source);
		self->priv->_background_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_BACKGROUND_SOURCE_PROPERTY]);
	}
}

gboolean
gala_background_get_is_loaded (GalaBackground* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_loaded;
	return result;
}

static void
gala_background_set_is_loaded (GalaBackground* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_is_loaded (self);
	if (old_value != value) {
		self->priv->_is_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_IS_LOADED_PROPERTY]);
	}
}

GDesktopBackgroundStyle
gala_background_get_style (GalaBackground* self)
{
	GDesktopBackgroundStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_style;
	return result;
}

static void
gala_background_set_style (GalaBackground* self,
                           GDesktopBackgroundStyle value)
{
	GDesktopBackgroundStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_style (self);
	if (old_value != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_STYLE_PROPERTY]);
	}
}

const gchar*
gala_background_get_filename (GalaBackground* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
gala_background_set_filename (GalaBackground* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_FILENAME_PROPERTY]);
	}
}

MetaBackground*
gala_background_get_background (GalaBackground* self)
{
	MetaBackground* result;
	MetaBackground* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background;
	result = _tmp0_;
	return result;
}

static void
gala_background_set_background (GalaBackground* self,
                                MetaBackground* value)
{
	MetaBackground* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_get_background (self);
	if (old_value != value) {
		MetaBackground* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background);
		self->priv->_background = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_properties[GALA_BACKGROUND_BACKGROUND_PROPERTY]);
	}
}

static void
_gala_background___lambda29_ (GalaBackground* self)
{
	GalaAnimation* _tmp0_;
	_tmp0_ = self->priv->animation;
	if (_tmp0_ != NULL) {
		GalaAnimation* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->animation;
		_tmp2_ = gala_animation_get_filename (_tmp1_);
		_tmp3_ = _tmp2_;
		gala_background_load_animation (self, _tmp3_, NULL, NULL);
	}
}

static void
__gala_background___lambda29__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_gala_background___lambda29_ ((GalaBackground*) self);
}

static GObject *
gala_background_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackground * self;
	MetaDisplay* _tmp0_;
	MetaBackground* _tmp1_;
	MetaBackground* _tmp2_;
	MetaBackground* _tmp3_;
	GeeHashMap* _tmp4_;
	GCancellable* _tmp5_;
	GalaBackgroundSource* _tmp6_;
	GnomeWallClock* _tmp7_;
	GnomeWallClock* _tmp8_;
	gulong _tmp9_;
	parent_class = G_OBJECT_CLASS (gala_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND, GalaBackground);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_background_new (_tmp0_);
	_tmp2_ = _tmp1_;
	gala_background_set_background (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_background;
	g_object_set_data_full ((GObject*) _tmp3_, "delegate", self, NULL);
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_watches);
	self->priv->file_watches = _tmp4_;
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp5_;
	_tmp6_ = self->priv->_background_source;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _gala_background_settings_changed_gala_background_source_changed, self, 0);
	_tmp7_ = gnome_wall_clock_new ();
	_g_object_unref0 (self->priv->clock);
	self->priv->clock = _tmp7_;
	_tmp8_ = self->priv->clock;
	_tmp9_ = g_signal_connect_object ((GObject*) _tmp8_, "notify::timezone", (GCallback) __gala_background___lambda29__g_object_notify, self, 0);
	self->priv->clock_timezone_handler = _tmp9_;
	gala_background_load (self);
	return obj;
}

static void
gala_background_class_init (GalaBackgroundClass * klass,
                            gpointer klass_data)
{
	gala_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackground_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_DISPLAY_PROPERTY, gala_background_properties[GALA_BACKGROUND_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MONITOR_INDEX_PROPERTY, gala_background_properties[GALA_BACKGROUND_MONITOR_INDEX_PROPERTY] = g_param_spec_int ("monitor-index", "monitor-index", "monitor-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_BACKGROUND_SOURCE_PROPERTY, gala_background_properties[GALA_BACKGROUND_BACKGROUND_SOURCE_PROPERTY] = g_param_spec_object ("background-source", "background-source", "background-source", GALA_TYPE_BACKGROUND_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_IS_LOADED_PROPERTY, gala_background_properties[GALA_BACKGROUND_IS_LOADED_PROPERTY] = g_param_spec_boolean ("is-loaded", "is-loaded", "is-loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_STYLE_PROPERTY, gala_background_properties[GALA_BACKGROUND_STYLE_PROPERTY] = g_param_spec_int ("style", "style", "style", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_FILENAME_PROPERTY, gala_background_properties[GALA_BACKGROUND_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_BACKGROUND_PROPERTY, gala_background_properties[GALA_BACKGROUND_BACKGROUND_PROPERTY] = g_param_spec_object ("background", "background", "background", meta_background_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_background_signals[GALA_BACKGROUND_CHANGED_SIGNAL] = g_signal_new ("changed", GALA_TYPE_BACKGROUND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_background_signals[GALA_BACKGROUND_LOADED_SIGNAL] = g_signal_new ("loaded", GALA_TYPE_BACKGROUND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_background_instance_init (GalaBackground * self,
                               gpointer klass)
{
	self->priv = gala_background_get_instance_private (self);
	self->priv->_is_loaded = FALSE;
	self->priv->animation = NULL;
	self->priv->update_animation_timeout_id = (guint) 0;
	self->priv->clock_timezone_handler = (gulong) 0;
}

static void
gala_background_finalize (GObject * obj)
{
	GalaBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND, GalaBackground);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_background_source);
	_g_free0 (self->priv->_filename);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->animation);
	_g_object_unref0 (self->priv->file_watches);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->clock);
	G_OBJECT_CLASS (gala_background_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackground), 0, (GInstanceInitFunc) gala_background_instance_init, NULL };
	GType gala_background_type_id;
	gala_background_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaBackground", &g_define_type_info, 0);
	GalaBackground_private_offset = g_type_add_instance_private (gala_background_type_id, sizeof (GalaBackgroundPrivate));
	return gala_background_type_id;
}

GType
gala_background_get_type (void)
{
	static gsize gala_background_type_id__once = 0;
	if (g_once_init_enter (&gala_background_type_id__once)) {
		GType gala_background_type_id;
		gala_background_type_id = gala_background_get_type_once ();
		g_once_init_leave (&gala_background_type_id__once, gala_background_type_id);
	}
	return gala_background_type_id__once;
}

static void
_vala_gala_background_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GalaBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND, GalaBackground);
	switch (property_id) {
		case GALA_BACKGROUND_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_background_get_display (self));
		break;
		case GALA_BACKGROUND_MONITOR_INDEX_PROPERTY:
		g_value_set_int (value, gala_background_get_monitor_index (self));
		break;
		case GALA_BACKGROUND_BACKGROUND_SOURCE_PROPERTY:
		g_value_set_object (value, gala_background_get_background_source (self));
		break;
		case GALA_BACKGROUND_IS_LOADED_PROPERTY:
		g_value_set_boolean (value, gala_background_get_is_loaded (self));
		break;
		case GALA_BACKGROUND_STYLE_PROPERTY:
		g_value_set_int (value, gala_background_get_style (self));
		break;
		case GALA_BACKGROUND_FILENAME_PROPERTY:
		g_value_set_string (value, gala_background_get_filename (self));
		break;
		case GALA_BACKGROUND_BACKGROUND_PROPERTY:
		g_value_set_object (value, gala_background_get_background (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GalaBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND, GalaBackground);
	switch (property_id) {
		case GALA_BACKGROUND_DISPLAY_PROPERTY:
		gala_background_set_display (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_MONITOR_INDEX_PROPERTY:
		gala_background_set_monitor_index (self, g_value_get_int (value));
		break;
		case GALA_BACKGROUND_BACKGROUND_SOURCE_PROPERTY:
		gala_background_set_background_source (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_IS_LOADED_PROPERTY:
		gala_background_set_is_loaded (self, g_value_get_boolean (value));
		break;
		case GALA_BACKGROUND_STYLE_PROPERTY:
		gala_background_set_style (self, g_value_get_int (value));
		break;
		case GALA_BACKGROUND_FILENAME_PROPERTY:
		gala_background_set_filename (self, g_value_get_string (value));
		break;
		case GALA_BACKGROUND_BACKGROUND_PROPERTY:
		gala_background_set_background (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

