/* WindowSwitcher.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowSwitcher.vala, do not modify */

/*
 * Copyright 2021 Aral Balkan <mail@ar.al>
 * Copyright 2020 Mark Story <mark@mark-story.com>
 * Copyright 2017 Popye <sailor3101@gmail.com>
 * Copyright 2014 Tom Beckmann
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <mtk/mtk.h>
#include <gdk/gdk.h>
#include <meta/window.h>
#include <meta/keybindings.h>
#include <meta/workspace.h>
#include <meta/meta-workspace-manager.h>
#include <atk/atk.h>
#include <meta/prefs.h>
#include <meta/meta-cursor-tracker.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_WINDOW_SWITCHER_ICON_SIZE 64
#define GALA_WINDOW_SWITCHER_WRAPPER_PADDING 12
#define GALA_WINDOW_SWITCHER_CAPTION_FONT_NAME "Inter"
#define GALA_WINDOW_SWITCHER_MIN_OFFSET 64
#define GALA_WINDOW_SWITCHER_ANIMATION_DURATION 200
#define GALA_WINDOW_SWITCHER_GESTURE_STEP 0.1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ROOT_TARGET (gala_root_target_get_type ())
#define GALA_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTarget))
#define GALA_IS_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ROOT_TARGET))
#define GALA_ROOT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTargetIface))

typedef struct _GalaRootTarget GalaRootTarget;
typedef struct _GalaRootTargetIface GalaRootTargetIface;

#define GALA_TYPE_WINDOW_SWITCHER (gala_window_switcher_get_type ())
#define GALA_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher))
#define GALA_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))
#define GALA_IS_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_IS_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_WINDOW_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))

typedef struct _GalaWindowSwitcher GalaWindowSwitcher;
typedef struct _GalaWindowSwitcherClass GalaWindowSwitcherClass;
typedef struct _GalaWindowSwitcherPrivate GalaWindowSwitcherPrivate;

#define GALA_TYPE_GESTURE_CONTROLLER (gala_gesture_controller_get_type ())
#define GALA_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController))
#define GALA_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))
#define GALA_IS_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_IS_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_GESTURE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))

typedef struct _GalaGestureController GalaGestureController;
typedef struct _GalaGestureControllerClass GalaGestureControllerClass;

#define GALA_TYPE_WINDOW_SWITCHER_ICON (gala_window_switcher_icon_get_type ())
#define GALA_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon))
#define GALA_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))
#define GALA_IS_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_IS_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_WINDOW_SWITCHER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))

typedef struct _GalaWindowSwitcherIcon GalaWindowSwitcherIcon;
typedef struct _GalaWindowSwitcherIconClass GalaWindowSwitcherIconClass;
enum  {
	GALA_WINDOW_SWITCHER_0_PROPERTY,
	GALA_WINDOW_SWITCHER_WM_PROPERTY,
	GALA_WINDOW_SWITCHER_OPENED_PROPERTY,
	GALA_WINDOW_SWITCHER_ACTOR_PROPERTY,
	GALA_WINDOW_SWITCHER_NUM_PROPERTIES
};
static GParamSpec* gala_window_switcher_properties[GALA_WINDOW_SWITCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaRootTargetIface {
	GTypeInterface parent_iface;
};

struct _GalaWindowSwitcher {
	GalaCanvasActor parent_instance;
	GalaWindowSwitcherPrivate * priv;
};

struct _GalaWindowSwitcherClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaWindowSwitcherPrivate {
	GalaWindowManager* _wm;
	gboolean _opened;
	GalaGestureController* gesture_controller;
	gint modifier_mask;
	GalaModalProxy* modal_proxy;
	GalaDrawingStyleManager* style_manager;
	ClutterActor* container;
	ClutterText* caption;
	GalaShadowEffect* shadow_effect;
	GalaWindowSwitcherIcon* _current_icon;
	gdouble previous_progress;
	gfloat scaling_factor;
};

static gint GalaWindowSwitcher_private_offset;
static gpointer gala_window_switcher_parent_class = NULL;
static GalaGestureTargetIface * gala_window_switcher_gala_gesture_target_parent_iface = NULL;
static GalaRootTargetIface * gala_window_switcher_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_root_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_window_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcher, g_object_unref)
VALA_EXTERN GType gala_gesture_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureController, g_object_unref)
VALA_EXTERN GType gala_window_switcher_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcherIcon, g_object_unref)
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_construct (GType object_type,
                                                    GalaWindowManager* wm);
static void gala_window_switcher_scale (GalaWindowSwitcher* self);
VALA_EXTERN GalaWindowManager* gala_window_switcher_get_wm (GalaWindowSwitcher* self);
static void gala_window_switcher_real_get_preferred_width (ClutterActor* base,
                                                    gfloat for_height,
                                                    gfloat* min_width,
                                                    gfloat* natural_width);
static void gala_window_switcher_real_draw (GalaCanvasActor* base,
                                     cairo_t* ctx,
                                     gint width,
                                     gint height);
static void _vala_ClutterColor_free (ClutterColor* self);
static void gala_window_switcher_real_propagate (GalaGestureTarget* base,
                                          GalaGestureTargetUpdateType update_type,
                                          GalaGestureAction action,
                                          gdouble progress);
static GalaWindowSwitcherIcon* gala_window_switcher_get_current_icon (GalaWindowSwitcher* self);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
static void gala_window_switcher_set_current_icon (GalaWindowSwitcher* self,
                                            GalaWindowSwitcherIcon* value);
static void gala_window_switcher_select_icon (GalaWindowSwitcher* self,
                                       GalaWindowSwitcherIcon* icon);
VALA_EXTERN void gala_gesture_controller_set_progress (GalaGestureController* self,
                                           gdouble value);
VALA_EXTERN void gala_window_switcher_handle_switch_windows (MetaDisplay* display,
                                                 MetaWindow* window,
                                                 ClutterKeyEvent* event,
                                                 MetaKeyBinding* binding,
                                                 GalaWindowSwitcher* self);
VALA_EXTERN gboolean gala_gesture_controller_get_recognizing (GalaGestureController* self);
VALA_EXTERN gboolean gala_window_switcher_get_opened (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_collect_current_windows (GalaWindowSwitcher* self,
                                                       MetaDisplay* display,
                                                       MetaWorkspace* workspace);
static gboolean gala_window_switcher_collect_all_windows (GalaWindowSwitcher* self,
                                                   MetaDisplay* display,
                                                   MetaWorkspace* workspace);
static void gala_window_switcher_open_switcher (GalaWindowSwitcher* self);
static void gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                       gboolean backward);
static void gala_window_switcher_recognizing_changed (GalaWindowSwitcher* self);
static void gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                          guint32 time,
                                          gboolean cancel);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_new (MetaWindow* window,
                                                       gint icon_size,
                                                       gfloat scale_factor);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_construct (GType object_type,
                                                             MetaWindow* window,
                                                             gint icon_size,
                                                             gfloat scale_factor);
static void gala_window_switcher_add_icon (GalaWindowSwitcher* self,
                                    GalaWindowSwitcherIcon* icon);
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GalaWindowTracker* gala_window_manager_gala_get_window_tracker (GalaWindowManagerGala* self);
VALA_EXTERN GalaApp* gala_window_tracker_get_app_for_window (GalaWindowTracker* self,
                                                 MetaWindow* window);
static gboolean __lambda93_ (GalaWindowSwitcher* self,
                      ClutterActor* _icon,
                      ClutterEvent* event);
static gboolean ___lambda93__clutter_actor_motion_event (ClutterActor* _sender,
                                                  ClutterEvent* event,
                                                  gpointer self);
static void gala_window_switcher_toggle_display (GalaWindowSwitcher* self,
                                          gboolean show);
static void gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                      gboolean value);
static void gala_window_switcher_push_modal (GalaWindowSwitcher* self);
static gboolean __lambda94_ (GalaWindowSwitcher* self,
                      MetaKeyBinding* binding);
static gboolean ___lambda94__gala_keybinding_filter (MetaKeyBinding* binding,
                                              gpointer self);
VALA_EXTERN MetaWindow* gala_window_switcher_icon_get_window (GalaWindowSwitcherIcon* self);
VALA_EXTERN gdouble gala_gesture_controller_get_progress (GalaGestureController* self);
static void gala_window_switcher_update_caption_text (GalaWindowSwitcher* self);
static void gala_window_switcher_real_key_focus_out (ClutterActor* base);
static gboolean gala_window_switcher_container_mouse_release (GalaWindowSwitcher* self,
                                                       ClutterEvent* event);
static gboolean gala_window_switcher_real_key_release_event (ClutterActor* base,
                                                      ClutterEvent* event);
static inline ClutterModifierType gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_real_key_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static void gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                                  GalaWindowManager* value);
VALA_EXTERN void gala_window_switcher_icon_set_selected (GalaWindowSwitcherIcon* self,
                                             gboolean value);
static GObject * gala_window_switcher_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
VALA_EXTERN GalaGestureController* gala_gesture_controller_new (GalaGestureAction action,
                                                    GalaWindowManager* wm);
VALA_EXTERN GalaGestureController* gala_gesture_controller_construct (GType object_type,
                                                          GalaGestureAction action,
                                                          GalaWindowManager* wm);
VALA_EXTERN void gala_gesture_controller_set_overshoot_upper_clamp (GalaGestureController* self,
                                                        gdouble value);
VALA_EXTERN void gala_gesture_controller_set_overshoot_lower_clamp (GalaGestureController* self,
                                                        gdouble value);
VALA_EXTERN void gala_gesture_controller_set_snap (GalaGestureController* self,
                                       gboolean value);
VALA_EXTERN void gala_gesture_controller_enable_touchpad (GalaGestureController* self);
static void _gala_window_switcher_recognizing_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
VALA_EXTERN void gala_root_target_add_gesture_controller (GalaRootTarget* self,
                                              GalaGestureController* controller);
static gboolean _gala_window_switcher_container_mouse_release_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                           ClutterEvent* event,
                                                                                           gpointer self);
static void _clutter_content_invalidate_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void _gala_window_switcher_scale_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                        gpointer self);
static void _gala_window_switcher___lambda95_ (GalaWindowSwitcher* self);
static void __gala_window_switcher___lambda95__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
VALA_EXTERN void gala_gesture_target_propagate (GalaGestureTarget* self,
                                    GalaGestureTargetUpdateType update_type,
                                    GalaGestureAction action,
                                    gdouble progress);
VALA_EXTERN ClutterActor* gala_gesture_target_get_actor (GalaGestureTarget* self);
static void gala_window_switcher_finalize (GObject * obj);
static GType gala_window_switcher_get_type_once (void);
static void _vala_gala_window_switcher_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_switcher_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_window_switcher_get_instance_private (GalaWindowSwitcher* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowSwitcher_private_offset);
}

GalaWindowSwitcher*
gala_window_switcher_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowSwitcher * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowSwitcher*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowSwitcher*
gala_window_switcher_new (GalaWindowManager* wm)
{
	return gala_window_switcher_construct (GALA_TYPE_WINDOW_SWITCHER, wm);
}

static void
gala_window_switcher_scale (GalaWindowSwitcher* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	GalaShadowEffect* _tmp4_;
	gint margin = 0;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterText* _tmp9_;
	ClutterText* _tmp10_;
	ClutterText* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	self->priv->scaling_factor = meta_display_get_monitor_scale (_tmp1_, meta_display_get_current_monitor (_tmp3_));
	_tmp4_ = self->priv->shadow_effect;
	gala_shadow_effect_set_monitor_scale (_tmp4_, self->priv->scaling_factor);
	margin = gala_utils_scale_to_int (GALA_WINDOW_SWITCHER_WRAPPER_PADDING, self->priv->scaling_factor);
	_tmp5_ = self->priv->container;
	clutter_actor_set_margin_left (_tmp5_, (gfloat) margin);
	_tmp6_ = self->priv->container;
	clutter_actor_set_margin_right (_tmp6_, (gfloat) margin);
	_tmp7_ = self->priv->container;
	clutter_actor_set_margin_bottom (_tmp7_, (gfloat) margin);
	_tmp8_ = self->priv->container;
	clutter_actor_set_margin_top (_tmp8_, (gfloat) margin);
	_tmp9_ = self->priv->caption;
	clutter_actor_set_margin_left ((ClutterActor*) _tmp9_, (gfloat) margin);
	_tmp10_ = self->priv->caption;
	clutter_actor_set_margin_right ((ClutterActor*) _tmp10_, (gfloat) margin);
	_tmp11_ = self->priv->caption;
	clutter_actor_set_margin_bottom ((ClutterActor*) _tmp11_, (gfloat) margin);
}

static void
gala_window_switcher_real_get_preferred_width (ClutterActor* base,
                                               gfloat for_height,
                                               gfloat* min_width,
                                               gfloat* natural_width)
{
	GalaWindowSwitcher * self;
	gfloat _vala_min_width = 0.0F;
	gfloat _vala_natural_width = 0.0F;
	gfloat preferred_nat_width = 0.0F;
	gfloat _tmp0_ = 0.0F;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	gint monitor = 0;
	MtkRectangle geom = {0};
	MtkRectangle _tmp3_ = {0};
	gfloat container_nat_width = 0.0F;
	ClutterActor* _tmp4_;
	gfloat _tmp5_ = 0.0F;
	gfloat max_width = 0.0F;
	MtkRectangle _tmp6_;
	self = (GalaWindowSwitcher*) base;
	_vala_min_width = (gfloat) 0;
	CLUTTER_ACTOR_CLASS (gala_window_switcher_parent_class)->get_preferred_width ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), for_height, NULL, &_tmp0_);
	preferred_nat_width = _tmp0_;
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	display = _tmp2_;
	monitor = meta_display_get_current_monitor (display);
	meta_display_get_monitor_geometry (display, monitor, &_tmp3_);
	geom = _tmp3_;
	_tmp4_ = self->priv->container;
	clutter_actor_get_preferred_size (_tmp4_, NULL, NULL, &_tmp5_, NULL);
	container_nat_width = _tmp5_;
	_tmp6_ = geom;
	max_width = MIN ((gfloat) (_tmp6_.width - (gala_utils_scale_to_int (GALA_WINDOW_SWITCHER_MIN_OFFSET, self->priv->scaling_factor) * 2)), container_nat_width);
	_vala_natural_width = MIN (max_width, preferred_nat_width);
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static void
gala_window_switcher_real_draw (GalaCanvasActor* base,
                                cairo_t* ctx,
                                gint width,
                                gint height)
{
	GalaWindowSwitcher * self;
	GdkRGBA background_color = {0};
	GdkRGBA border_color = {0};
	gchar* caption_color = NULL;
	gchar* _tmp0_;
	GdkRGBA highlight_color = {0};
	GalaDrawingStyleManager* _tmp1_;
	GalaDrawingStyleManagerColorScheme _tmp2_;
	GalaDrawingStyleManagerColorScheme _tmp3_;
	ClutterText* _tmp5_;
	const gchar* _tmp6_;
	ClutterColor* _tmp7_;
	ClutterColor* _tmp8_;
	ClutterColor _tmp9_;
	gint stroke_width = 0;
	GdkRGBA _tmp10_;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GdkRGBA _tmp15_;
	GdkRGBA _tmp16_;
	GdkRGBA _tmp17_;
	GdkRGBA _tmp18_;
	GdkRGBA _tmp19_;
	GdkRGBA _tmp20_;
	GdkRGBA _tmp21_;
	self = (GalaWindowSwitcher*) base;
	g_return_if_fail (ctx != NULL);
	background_color = GALA_DRAWING_COLOR_LIGHT_BACKGROUND;
	border_color = GALA_DRAWING_COLOR_LIGHT_BORDER;
	_tmp0_ = g_strdup ("#2e2e31");
	caption_color = _tmp0_;
	highlight_color = GALA_DRAWING_COLOR_LIGHT_HIGHLIGHT;
	_tmp1_ = self->priv->style_manager;
	_tmp2_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK) {
		gchar* _tmp4_;
		background_color = GALA_DRAWING_COLOR_DARK_BACKGROUND;
		border_color = GALA_DRAWING_COLOR_DARK_BORDER;
		_tmp4_ = g_strdup ("#fafafa");
		_g_free0 (caption_color);
		caption_color = _tmp4_;
		highlight_color = GALA_DRAWING_COLOR_DARK_HIGHLIGHT;
	}
	_tmp5_ = self->priv->caption;
	_tmp6_ = caption_color;
	_tmp7_ = _vala_clutter_color_from_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = *_tmp8_;
	clutter_text_set_color (_tmp5_, &_tmp9_);
	__vala_ClutterColor_free0 (_tmp8_);
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_clip (ctx);
	cairo_reset_clip (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	stroke_width = gala_utils_scale_to_int (1, self->priv->scaling_factor);
	gala_drawing_utilities_cairo_rounded_rectangle (ctx, stroke_width / 2.0, stroke_width / 2.0, (gdouble) (width - stroke_width), (gdouble) (height - stroke_width), (gdouble) gala_utils_scale_to_int (9, self->priv->scaling_factor));
	_tmp10_ = background_color;
	_tmp11_ = background_color;
	_tmp12_ = background_color;
	_tmp13_ = background_color;
	cairo_set_source_rgba (ctx, _tmp10_.red, _tmp11_.green, _tmp12_.blue, _tmp13_.alpha);
	cairo_fill_preserve (ctx);
	cairo_set_line_width (ctx, (gdouble) stroke_width);
	_tmp14_ = border_color;
	_tmp15_ = border_color;
	_tmp16_ = border_color;
	_tmp17_ = border_color;
	cairo_set_source_rgba (ctx, _tmp14_.red, _tmp15_.green, _tmp16_.blue, _tmp17_.alpha);
	cairo_stroke (ctx);
	cairo_restore (ctx);
	gala_drawing_utilities_cairo_rounded_rectangle (ctx, stroke_width * 1.5, stroke_width * 1.5, (gdouble) (width - (stroke_width * 3)), (gdouble) (height - (stroke_width * 3)), (gdouble) gala_utils_scale_to_int (8, self->priv->scaling_factor));
	cairo_set_line_width (ctx, (gdouble) stroke_width);
	_tmp18_ = highlight_color;
	_tmp19_ = highlight_color;
	_tmp20_ = highlight_color;
	_tmp21_ = highlight_color;
	cairo_set_source_rgba (ctx, _tmp18_.red, _tmp19_.green, _tmp20_.blue, _tmp21_.alpha);
	cairo_stroke (ctx);
	cairo_restore (ctx);
	_g_free0 (caption_color);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_window_switcher_real_propagate (GalaGestureTarget* base,
                                     GalaGestureTargetUpdateType update_type,
                                     GalaGestureAction action,
                                     gdouble progress)
{
	GalaWindowSwitcher * self;
	gboolean _tmp0_ = FALSE;
	gboolean is_step = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ClutterActor* _tmp4_;
	gint current_index = 0;
	ClutterActor* _tmp9_;
	GalaWindowSwitcherIcon* new_icon = NULL;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	GalaWindowSwitcherIcon* _tmp13_;
	GalaWindowSwitcherIcon* _tmp14_;
	GalaWindowSwitcherIcon* _tmp15_;
	GalaWindowSwitcherIcon* _tmp16_;
	self = (GalaWindowSwitcher*) base;
	if (update_type != GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE) {
		_tmp0_ = TRUE;
	} else {
		ClutterActor* _tmp1_;
		_tmp1_ = self->priv->container;
		_tmp0_ = clutter_actor_get_n_children (_tmp1_) == 0;
	}
	if (_tmp0_) {
		return;
	}
	is_step = abs (((gint) (self->priv->previous_progress / GALA_WINDOW_SWITCHER_GESTURE_STEP)) - ((gint) (progress / GALA_WINDOW_SWITCHER_GESTURE_STEP))) >= 1;
	self->priv->previous_progress = progress;
	_tmp4_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp4_) == 1) {
		GalaWindowSwitcherIcon* _tmp5_;
		GalaWindowSwitcherIcon* _tmp6_;
		_tmp5_ = gala_window_switcher_get_current_icon (self);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = is_step;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GalaWindowManager* _tmp7_;
		MetaDisplay* _tmp8_;
		_tmp7_ = self->priv->_wm;
		_tmp8_ = meta_plugin_get_display ((MetaPlugin*) _tmp7_);
		gala_internal_utils_bell_notify (_tmp8_);
		return;
	}
	_tmp9_ = self->priv->container;
	current_index = ((gint) (progress / GALA_WINDOW_SWITCHER_GESTURE_STEP)) % clutter_actor_get_n_children (_tmp9_);
	if (current_index < 0) {
		ClutterActor* _tmp10_;
		_tmp10_ = self->priv->container;
		current_index = clutter_actor_get_n_children (_tmp10_) + current_index;
	}
	_tmp11_ = self->priv->container;
	_tmp12_ = clutter_actor_get_child_at_index (_tmp11_, current_index);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon));
	new_icon = _tmp13_;
	_tmp14_ = new_icon;
	_tmp15_ = gala_window_switcher_get_current_icon (self);
	_tmp16_ = _tmp15_;
	if (_tmp14_ != _tmp16_) {
		GalaWindowSwitcherIcon* _tmp17_;
		_tmp17_ = new_icon;
		gala_window_switcher_set_current_icon (self, _tmp17_);
	}
	_g_object_unref0 (new_icon);
}

static void
gala_window_switcher_select_icon (GalaWindowSwitcher* self,
                                  GalaWindowSwitcherIcon* icon)
{
	gint index = 0;
	g_return_if_fail (self != NULL);
	if (icon == NULL) {
		GalaGestureController* _tmp0_;
		_tmp0_ = self->priv->gesture_controller;
		gala_gesture_controller_set_progress (_tmp0_, (gdouble) 0);
		gala_window_switcher_set_current_icon (self, NULL);
		return;
	}
	index = 0;
	{
		ClutterActor* child = NULL;
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		_tmp1_ = self->priv->container;
		_tmp2_ = clutter_actor_get_first_child (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		child = _tmp3_;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ClutterActor* _tmp8_;
				ClutterActor* _tmp9_;
				gint _tmp11_;
				if (!_tmp4_) {
					ClutterActor* _tmp5_;
					ClutterActor* _tmp6_;
					ClutterActor* _tmp7_;
					_tmp5_ = child;
					_tmp6_ = clutter_actor_get_next_sibling (_tmp5_);
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_g_object_unref0 (child);
					child = _tmp7_;
				}
				_tmp4_ = FALSE;
				_tmp8_ = child;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = child;
				if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (icon, clutter_actor_get_type (), ClutterActor)) {
					GalaGestureController* _tmp10_;
					_tmp10_ = self->priv->gesture_controller;
					gala_gesture_controller_set_progress (_tmp10_, index * GALA_WINDOW_SWITCHER_GESTURE_STEP);
					break;
				}
				_tmp11_ = index;
				index = _tmp11_ + 1;
			}
		}
		_g_object_unref0 (child);
	}
}

void
gala_window_switcher_handle_switch_windows (MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding,
                                            GalaWindowSwitcher* self)
{
	GalaGestureController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	guint mask = 0U;
	gboolean _tmp6_;
	gchar* binding_name = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean backward = FALSE;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->gesture_controller;
	_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = meta_display_get_workspace_manager (display);
	_tmp4_ = meta_workspace_manager_get_active_workspace (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	workspace = _tmp5_;
	mask = meta_key_binding_get_mask (binding);
	if (mask == ((guint) 0)) {
		self->priv->modifier_mask = 0;
	} else {
		self->priv->modifier_mask = 1;
		while (TRUE) {
			if (!(mask > ((guint) 1))) {
				break;
			}
			mask >>= (guint) 1;
			self->priv->modifier_mask = self->priv->modifier_mask << 1;
		}
	}
	_tmp6_ = self->priv->_opened;
	if (!_tmp6_) {
		gboolean windows_exist = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = meta_key_binding_get_name (binding);
		if (g_str_has_prefix (_tmp7_, "switch-group")) {
			MetaWorkspace* _tmp8_;
			_tmp8_ = workspace;
			windows_exist = gala_window_switcher_collect_current_windows (self, display, _tmp8_);
		} else {
			MetaWorkspace* _tmp9_;
			_tmp9_ = workspace;
			windows_exist = gala_window_switcher_collect_all_windows (self, display, _tmp9_);
		}
		if (!windows_exist) {
			_g_object_unref0 (workspace);
			return;
		}
		gala_window_switcher_open_switcher (self);
	}
	_tmp10_ = meta_key_binding_get_name (binding);
	_tmp11_ = g_strdup (_tmp10_);
	binding_name = _tmp11_;
	_tmp12_ = binding_name;
	backward = g_str_has_suffix (_tmp12_, "-backward");
	gala_window_switcher_next_window (self, backward);
	_g_free0 (binding_name);
	_g_object_unref0 (workspace);
}

static void
gala_window_switcher_recognizing_changed (GalaWindowSwitcher* self)
{
	GalaGestureController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gesture_controller;
	_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		MetaDisplay* display = NULL;
		GalaWindowManager* _tmp3_;
		MetaDisplay* _tmp4_;
		MetaWorkspaceManager* workspace_manager = NULL;
		MetaDisplay* _tmp5_;
		MetaWorkspaceManager* _tmp6_;
		MetaWorkspace* active_workspace = NULL;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		gboolean windows_exist = FALSE;
		MetaDisplay* _tmp9_;
		MetaWorkspace* _tmp10_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
		display = _tmp4_;
		_tmp5_ = display;
		_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
		workspace_manager = _tmp6_;
		_tmp7_ = workspace_manager;
		_tmp8_ = meta_workspace_manager_get_active_workspace (_tmp7_);
		active_workspace = _tmp8_;
		_tmp9_ = display;
		_tmp10_ = active_workspace;
		windows_exist = gala_window_switcher_collect_all_windows (self, _tmp9_, _tmp10_);
		if (!windows_exist) {
			return;
		}
		gala_window_switcher_open_switcher (self);
	} else {
		GalaWindowManager* _tmp11_;
		MetaDisplay* _tmp12_;
		_tmp11_ = self->priv->_wm;
		_tmp12_ = meta_plugin_get_display ((MetaPlugin*) _tmp11_);
		gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp12_), FALSE);
	}
}

static gboolean
gala_window_switcher_collect_all_windows (GalaWindowSwitcher* self,
                                          MetaDisplay* display,
                                          MetaWorkspace* workspace)
{
	ClutterActor* _tmp0_;
	GList* windows = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp3_;
	GList* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = self->priv->container;
	clutter_actor_remove_all_children (_tmp0_);
	gala_window_switcher_select_icon (self, NULL);
	_tmp1_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp1_;
	_tmp2_ = windows;
	if (_tmp2_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp3_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	current_window = _tmp3_;
	_tmp4_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp4_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowSwitcherIcon* icon = NULL;
				MetaWindow* _tmp5_;
				GalaWindowSwitcherIcon* _tmp6_;
				GalaWindowSwitcherIcon* _tmp7_;
				MetaWindow* _tmp8_;
				MetaWindow* _tmp9_;
				_tmp5_ = window;
				_tmp6_ = gala_window_switcher_icon_new (_tmp5_, GALA_WINDOW_SWITCHER_ICON_SIZE, self->priv->scaling_factor);
				g_object_ref_sink (_tmp6_);
				icon = _tmp6_;
				_tmp7_ = icon;
				gala_window_switcher_add_icon (self, _tmp7_);
				_tmp8_ = window;
				_tmp9_ = current_window;
				if (_tmp8_ == _tmp9_) {
					GalaWindowSwitcherIcon* _tmp10_;
					_tmp10_ = icon;
					gala_window_switcher_select_icon (self, _tmp10_);
				}
				_g_object_unref0 (icon);
			}
		}
	}
	result = TRUE;
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static gboolean
gala_window_switcher_collect_current_windows (GalaWindowSwitcher* self,
                                              MetaDisplay* display,
                                              MetaWorkspace* workspace)
{
	ClutterActor* _tmp0_;
	GList* windows = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	GalaWindowTracker* window_tracker = NULL;
	GalaWindowManager* _tmp5_;
	GalaWindowTracker* _tmp6_;
	GalaWindowTracker* _tmp7_;
	GalaApp* app = NULL;
	GalaWindowTracker* _tmp8_;
	MetaWindow* _tmp9_;
	GalaApp* _tmp10_;
	GList* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = self->priv->container;
	clutter_actor_remove_all_children (_tmp0_);
	gala_window_switcher_select_icon (self, NULL);
	_tmp1_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp1_;
	_tmp2_ = windows;
	if (_tmp2_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp3_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	current_window = _tmp3_;
	_tmp4_ = current_window;
	if (_tmp4_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp5_ = self->priv->_wm;
	_tmp6_ = gala_window_manager_gala_get_window_tracker (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala));
	_tmp7_ = _tmp6_;
	window_tracker = _tmp7_;
	_tmp8_ = window_tracker;
	_tmp9_ = current_window;
	_tmp10_ = gala_window_tracker_get_app_for_window (_tmp8_, _tmp9_);
	app = _tmp10_;
	_tmp11_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp11_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowTracker* _tmp12_;
				MetaWindow* _tmp13_;
				GalaApp* _tmp14_;
				GalaApp* _tmp15_;
				GalaApp* _tmp16_;
				gboolean _tmp17_;
				_tmp12_ = window_tracker;
				_tmp13_ = window;
				_tmp14_ = gala_window_tracker_get_app_for_window (_tmp12_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = app;
				_tmp17_ = _tmp15_ == _tmp16_;
				_g_object_unref0 (_tmp15_);
				if (_tmp17_) {
					GalaWindowSwitcherIcon* icon = NULL;
					MetaWindow* _tmp18_;
					GalaWindowSwitcherIcon* _tmp19_;
					GalaWindowSwitcherIcon* _tmp20_;
					MetaWindow* _tmp21_;
					MetaWindow* _tmp22_;
					_tmp18_ = window;
					_tmp19_ = gala_window_switcher_icon_new (_tmp18_, GALA_WINDOW_SWITCHER_ICON_SIZE, self->priv->scaling_factor);
					g_object_ref_sink (_tmp19_);
					icon = _tmp19_;
					_tmp20_ = icon;
					gala_window_switcher_add_icon (self, _tmp20_);
					_tmp21_ = window;
					_tmp22_ = current_window;
					if (_tmp21_ == _tmp22_) {
						GalaWindowSwitcherIcon* _tmp23_;
						_tmp23_ = icon;
						gala_window_switcher_select_icon (self, _tmp23_);
					}
					_g_object_unref0 (icon);
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (app);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static gboolean
__lambda93_ (GalaWindowSwitcher* self,
             ClutterActor* _icon,
             ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	gboolean result;
	g_return_val_if_fail (_icon != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, clutter_actor_get_type (), ClutterActor) != _icon) {
		GalaGestureController* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->gesture_controller;
		_tmp4_ = gala_gesture_controller_get_recognizing (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_select_icon (self, G_TYPE_CHECK_INSTANCE_CAST (_icon, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon));
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda93__clutter_actor_motion_event (ClutterActor* _sender,
                                         ClutterEvent* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda93_ ((GalaWindowSwitcher*) self, _sender, event);
	return result;
}

static void
gala_window_switcher_add_icon (GalaWindowSwitcher* self,
                               GalaWindowSwitcherIcon* icon)
{
	ClutterActor* _tmp0_;
	AtkObject* _tmp1_;
	ClutterActor* _tmp2_;
	AtkObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	_tmp0_ = self->priv->container;
	clutter_actor_add_child (_tmp0_, (ClutterActor*) icon);
	_tmp1_ = clutter_actor_get_accessible ((ClutterActor*) icon);
	_tmp2_ = self->priv->container;
	_tmp3_ = clutter_actor_get_accessible (_tmp2_);
	g_object_set (_tmp1_, "accessible-parent", _tmp3_, NULL);
	g_signal_connect_object ((ClutterActor*) icon, "motion-event", (GCallback) ___lambda93__clutter_actor_motion_event, self, 0);
}

static void
gala_window_switcher_open_switcher (GalaWindowSwitcher* self)
{
	ClutterActor* _tmp0_;
	gboolean _tmp3_;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp6_;
	MetaDisplay* _tmp7_;
	gint monitor = 0;
	MetaDisplay* _tmp8_;
	MtkRectangle geom = {0};
	MetaDisplay* _tmp9_;
	MtkRectangle _tmp10_ = {0};
	MtkRectangle _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	MtkRectangle _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp0_) == 0) {
		GalaWindowManager* _tmp1_;
		MetaDisplay* _tmp2_;
		_tmp1_ = self->priv->_wm;
		_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
		gala_internal_utils_bell_notify (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->_opened;
	if (_tmp3_) {
		return;
	}
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	clutter_actor_get_preferred_size ((ClutterActor*) self, NULL, NULL, &_tmp4_, &_tmp5_);
	width = _tmp4_;
	height = _tmp5_;
	_tmp6_ = self->priv->_wm;
	_tmp7_ = meta_plugin_get_display ((MetaPlugin*) _tmp6_);
	display = _tmp7_;
	_tmp8_ = display;
	monitor = meta_display_get_current_monitor (_tmp8_);
	_tmp9_ = display;
	meta_display_get_monitor_geometry (_tmp9_, monitor, &_tmp10_);
	geom = _tmp10_;
	_tmp11_ = geom;
	_tmp12_ = geom;
	_tmp13_ = geom;
	_tmp14_ = geom;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) ((gint) (_tmp11_.x + ((_tmp12_.width - width) / 2))), (gfloat) ((gint) (_tmp13_.y + ((_tmp14_.height - height) / 2))));
	gala_window_switcher_toggle_display (self, TRUE);
}

static void
gala_window_switcher_toggle_display (GalaWindowSwitcher* self,
                                     gboolean show)
{
	gboolean _tmp0_;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (_tmp0_ == show) {
		return;
	}
	gala_window_switcher_set_opened (self, show);
	if (show) {
		gala_window_switcher_push_modal (self);
	} else {
		GalaWindowManager* _tmp1_;
		GalaModalProxy* _tmp2_;
		ClutterStage* _tmp3_;
		_tmp1_ = self->priv->_wm;
		_tmp2_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp1_, _tmp2_);
		_tmp3_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) self);
		clutter_stage_set_key_focus (_tmp3_, NULL);
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, gala_utils_get_animation_duration ((guint) GALA_WINDOW_SWITCHER_ANIMATION_DURATION));
	if (show) {
		_tmp4_ = 255;
	} else {
		_tmp4_ = 0;
	}
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) _tmp4_);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static gboolean
__lambda94_ (GalaWindowSwitcher* self,
             MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda94__gala_keybinding_filter (MetaKeyBinding* binding,
                                     gpointer self)
{
	gboolean result;
	result = __lambda94_ ((GalaWindowSwitcher*) self, binding);
	return result;
}

static void
gala_window_switcher_push_modal (GalaWindowSwitcher* self)
{
	GalaWindowManager* _tmp0_;
	GalaModalProxy* _tmp1_;
	GalaModalProxy* _tmp2_;
	GalaGestureAction* _tmp3_;
	GalaGestureAction* _tmp4_;
	gint _tmp4__length1;
	GalaModalProxy* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_push_modal (_tmp0_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp1_;
	_tmp2_ = self->priv->modal_proxy;
	_tmp3_ = g_new0 (GalaGestureAction, 1);
	_tmp3_[0] = GALA_GESTURE_ACTION_SWITCH_WINDOWS;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	gala_modal_proxy_allow_actions (_tmp2_, _tmp4_, (gint) 1);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp5_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp5_, ___lambda94__gala_keybinding_filter, self);
}

static void
gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                     guint32 time,
                                     gboolean cancel)
{
	gboolean _tmp0_;
	MetaWindow* window = NULL;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_window_switcher_icon_get_window (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	if (!cancel) {
		MetaWorkspace* workspace = NULL;
		MetaWindow* _tmp7_;
		MetaWorkspace* _tmp8_;
		MetaWorkspace* _tmp9_;
		GalaWindowManager* _tmp10_;
		MetaDisplay* _tmp11_;
		MetaWorkspaceManager* _tmp12_;
		MetaWorkspace* _tmp13_;
		_tmp7_ = window;
		_tmp8_ = meta_window_get_workspace (_tmp7_);
		workspace = _tmp8_;
		_tmp9_ = workspace;
		_tmp10_ = self->priv->_wm;
		_tmp11_ = meta_plugin_get_display ((MetaPlugin*) _tmp10_);
		_tmp12_ = meta_display_get_workspace_manager (_tmp11_);
		_tmp13_ = meta_workspace_manager_get_active_workspace (_tmp12_);
		if (_tmp9_ != _tmp13_) {
			MetaWorkspace* _tmp14_;
			MetaWindow* _tmp15_;
			_tmp14_ = workspace;
			_tmp15_ = window;
			meta_workspace_activate_with_focus (_tmp14_, _tmp15_, time);
		} else {
			MetaWindow* _tmp16_;
			_tmp16_ = window;
			meta_window_activate (_tmp16_, time);
		}
	}
	gala_window_switcher_toggle_display (self, FALSE);
	_g_object_unref0 (window);
}

static void
gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                  gboolean backward)
{
	gdouble _tmp0_ = 0.0;
	GalaGestureController* _tmp1_;
	GalaGestureController* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	if (backward) {
		_tmp0_ = -GALA_WINDOW_SWITCHER_GESTURE_STEP;
	} else {
		_tmp0_ = GALA_WINDOW_SWITCHER_GESTURE_STEP;
	}
	_tmp1_ = self->priv->gesture_controller;
	_tmp2_ = self->priv->gesture_controller;
	_tmp3_ = gala_gesture_controller_get_progress (_tmp2_);
	_tmp4_ = _tmp3_;
	gala_gesture_controller_set_progress (_tmp2_, _tmp4_ + _tmp0_);
}

static void
gala_window_switcher_update_caption_text (GalaWindowSwitcher* self)
{
	MetaWindow* _tmp0_ = NULL;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp7_;
	const gchar* _tmp8_ = NULL;
	MetaWindow* _tmp9_;
	gchar* current_caption = NULL;
	gchar* _tmp13_;
	ClutterText* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GalaWindowSwitcherIcon* _tmp3_;
		GalaWindowSwitcherIcon* _tmp4_;
		MetaWindow* _tmp5_;
		MetaWindow* _tmp6_;
		_tmp3_ = gala_window_switcher_get_current_icon (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = gala_window_switcher_icon_get_window (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp0_);
	current_window = _tmp7_;
	_tmp9_ = current_window;
	if (_tmp9_ != NULL) {
		MetaWindow* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = current_window;
		_tmp11_ = meta_window_get_title (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = "n/a";
	}
	_tmp13_ = g_strdup (_tmp8_);
	current_caption = _tmp13_;
	_tmp14_ = self->priv->caption;
	clutter_text_set_text (_tmp14_, current_caption);
	_g_free0 (current_caption);
	_g_object_unref0 (current_window);
}

static void
gala_window_switcher_real_key_focus_out (ClutterActor* base)
{
	GalaWindowSwitcher * self;
	GalaGestureController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (GalaWindowSwitcher*) base;
	_tmp0_ = self->priv->gesture_controller;
	_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GalaWindowManager* _tmp3_;
		MetaDisplay* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
		gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp4_), FALSE);
	}
}

static gboolean
gala_window_switcher_container_mouse_release (GalaWindowSwitcher* self,
                                              ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->_opened;
	if (_tmp2_) {
		_tmp1_ = clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GalaGestureController* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->gesture_controller;
		_tmp4_ = gala_gesture_controller_get_recognizing (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
	}
	result = TRUE;
	return result;
}

static gboolean
gala_window_switcher_real_key_release_event (ClutterActor* base,
                                             ClutterEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gala_window_switcher_get_current_modifiers (self) & self->priv->modifier_mask) == 0) {
		GalaGestureController* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->gesture_controller;
		_tmp2_ = gala_gesture_controller_get_recognizing (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_window_switcher_real_key_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (clutter_event_get_key_symbol (event)) {
		case CLUTTER_KEY_Right:
		{
			GalaGestureController* _tmp0_;
			gboolean _tmp1_;
			gboolean _tmp2_;
			_tmp0_ = self->priv->gesture_controller;
			_tmp1_ = gala_gesture_controller_get_recognizing (_tmp0_);
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gala_window_switcher_next_window (self, FALSE);
			}
			result = CLUTTER_EVENT_STOP;
			return result;
		}
		case CLUTTER_KEY_Left:
		{
			GalaGestureController* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->priv->gesture_controller;
			_tmp4_ = gala_gesture_controller_get_recognizing (_tmp3_);
			_tmp5_ = _tmp4_;
			if (!_tmp5_) {
				gala_window_switcher_next_window (self, TRUE);
			}
			result = CLUTTER_EVENT_STOP;
			return result;
		}
		case CLUTTER_KEY_Escape:
		{
			gala_window_switcher_close_switcher (self, clutter_event_get_time (event), TRUE);
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		case CLUTTER_KEY_Return:
		{
			gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static inline ClutterModifierType
gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self)
{
	ClutterModifierType modifiers = 0U;
	MetaCursorTracker* tracker = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaCursorTracker* _tmp2_;
	ClutterModifierType _tmp3_ = 0U;
	ClutterModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_cursor_tracker_get_for_display (_tmp1_);
	tracker = _tmp2_;
	meta_cursor_tracker_get_pointer (tracker, NULL, &_tmp3_);
	modifiers = _tmp3_;
	result = modifiers & CLUTTER_MODIFIER_MASK;
	return result;
}

GalaWindowManager*
gala_window_switcher_get_wm (GalaWindowSwitcher* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY]);
	}
}

gboolean
gala_window_switcher_get_opened (GalaWindowSwitcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_opened;
	return result;
}

static void
gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_opened (self);
	if (old_value != value) {
		self->priv->_opened = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY]);
	}
}

static ClutterActor*
gala_window_switcher_real_get_actor (GalaGestureTarget* base)
{
	ClutterActor* result;
	GalaWindowSwitcher* self;
	self = (GalaWindowSwitcher*) base;
	result = (ClutterActor*) self;
	return result;
}

static GalaWindowSwitcherIcon*
gala_window_switcher_get_current_icon (GalaWindowSwitcher* self)
{
	GalaWindowSwitcherIcon* result;
	GalaWindowSwitcherIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_icon;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_current_icon (GalaWindowSwitcher* self,
                                       GalaWindowSwitcherIcon* value)
{
	GalaWindowSwitcherIcon* _tmp0_;
	GalaWindowSwitcherIcon* _tmp2_;
	GalaWindowSwitcherIcon* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_icon;
	if (_tmp0_ != NULL) {
		GalaWindowSwitcherIcon* _tmp1_;
		_tmp1_ = self->priv->_current_icon;
		gala_window_switcher_icon_set_selected (_tmp1_, FALSE);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_icon);
	self->priv->_current_icon = _tmp2_;
	_tmp3_ = self->priv->_current_icon;
	if (_tmp3_ != NULL) {
		GalaWindowSwitcherIcon* _tmp4_;
		GalaWindowSwitcherIcon* _tmp5_;
		_tmp4_ = self->priv->_current_icon;
		gala_window_switcher_icon_set_selected (_tmp4_, TRUE);
		_tmp5_ = self->priv->_current_icon;
		clutter_actor_grab_key_focus ((ClutterActor*) _tmp5_);
	}
	gala_window_switcher_update_caption_text (self);
}

static void
_gala_window_switcher_recognizing_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	gala_window_switcher_recognizing_changed ((GalaWindowSwitcher*) self);
}

static gboolean
_gala_window_switcher_container_mouse_release_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                  ClutterEvent* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = gala_window_switcher_container_mouse_release ((GalaWindowSwitcher*) self, event);
	return result;
}

static void
_clutter_content_invalidate_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	clutter_content_invalidate ((ClutterContent*) self);
}

static void
_gala_window_switcher_scale_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                   gpointer self)
{
	gala_window_switcher_scale ((GalaWindowSwitcher*) self);
}

static void
_gala_window_switcher___lambda95_ (GalaWindowSwitcher* self)
{
	guint _tmp0_;
	guint _tmp1_;
	_tmp0_ = clutter_actor_get_opacity ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	g_object_set ((ClutterActor*) self, "visible", _tmp1_ != ((guint) 0), NULL);
}

static void
__gala_window_switcher___lambda95__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	_gala_window_switcher___lambda95_ ((GalaWindowSwitcher*) self);
}

static GObject *
gala_window_switcher_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowSwitcher * self;
	GalaDrawingStyleManager* _tmp0_;
	GalaWindowManager* _tmp1_;
	GalaGestureController* _tmp2_ = NULL;
	GalaGestureController* _tmp3_;
	GalaGestureController* _tmp4_;
	GalaGestureController* _tmp5_;
	ClutterFlowLayout* _tmp6_;
	ClutterActor* _tmp7_ = NULL;
	AtkObject* _tmp8_;
	ClutterActor* _tmp9_;
	AtkObject* _tmp10_;
	gchar* _tmp11_;
	ClutterText* _tmp12_ = NULL;
	ClutterActor* _tmp13_;
	ClutterText* _tmp14_;
	ClutterBoxLayout* _tmp15_ = NULL;
	ClutterBoxLayout* _tmp16_;
	GalaShadowEffect* _tmp17_ = NULL;
	GalaShadowEffect* _tmp18_;
	ClutterActor* _tmp19_;
	GalaDrawingStyleManager* _tmp20_;
	ClutterContent* _tmp21_;
	ClutterContent* _tmp22_;
	MetaMonitorManager* monitor_manager = NULL;
	GalaWindowManager* _tmp23_;
	MetaDisplay* _tmp24_;
	MetaContext* _tmp25_;
	MetaBackend* _tmp26_;
	MetaMonitorManager* _tmp27_;
	MetaMonitorManager* _tmp28_;
	parent_class = G_OBJECT_CLASS (gala_window_switcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_tmp0_ = gala_drawing_style_manager_get_instance ();
	_g_object_unref0 (self->priv->style_manager);
	self->priv->style_manager = _tmp0_;
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_SWITCH_WINDOWS, _tmp1_);
	gala_gesture_controller_set_overshoot_upper_clamp (_tmp2_, (gdouble) G_MAXINT);
	gala_gesture_controller_set_overshoot_lower_clamp (_tmp2_, (gdouble) G_MININT);
	gala_gesture_controller_set_snap (_tmp2_, FALSE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp2_;
	_tmp3_ = self->priv->gesture_controller;
	gala_gesture_controller_enable_touchpad (_tmp3_);
	_tmp4_ = self->priv->gesture_controller;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::recognizing", (GCallback) _gala_window_switcher_recognizing_changed_g_object_notify, self, 0);
	_tmp5_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp5_);
	_tmp6_ = (ClutterFlowLayout*) clutter_flow_layout_new (CLUTTER_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = clutter_actor_new ();
	clutter_actor_set_reactive (_tmp7_, TRUE);
	clutter_actor_set_layout_manager (_tmp7_, (ClutterLayoutManager*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp7_;
	_tmp8_ = clutter_actor_get_accessible ((ClutterActor*) self);
	g_object_set (_tmp8_, "accessible-name", _ ("Window switcher"), NULL);
	_tmp9_ = self->priv->container;
	_tmp10_ = clutter_actor_get_accessible (_tmp9_);
	g_object_set (_tmp10_, "accessible-role", ATK_ROLE_LIST, NULL);
	_tmp11_ = g_strdup (GALA_WINDOW_SWITCHER_CAPTION_FONT_NAME);
	_tmp12_ = (ClutterText*) clutter_text_new ();
	clutter_text_set_font_name (_tmp12_, _tmp11_);
	_g_free0 (_tmp11_);
	clutter_text_set_ellipsize (_tmp12_, PANGO_ELLIPSIZE_END);
	clutter_text_set_line_alignment (_tmp12_, PANGO_ALIGN_CENTER);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->caption);
	self->priv->caption = _tmp12_;
	_tmp13_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp13_);
	_tmp14_ = self->priv->caption;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp14_);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	_tmp15_ = (ClutterBoxLayout*) clutter_box_layout_new ();
	clutter_box_layout_set_orientation (_tmp15_, CLUTTER_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	clutter_actor_set_layout_manager ((ClutterActor*) self, (ClutterLayoutManager*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = gala_shadow_effect_new ("window-switcher", self->priv->scaling_factor);
	gala_shadow_effect_set_border_radius (_tmp17_, 10);
	gala_shadow_effect_set_shadow_opacity (_tmp17_, (guint8) 100);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->shadow_effect);
	self->priv->shadow_effect = _tmp17_;
	_tmp18_ = self->priv->shadow_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp18_);
	gala_window_switcher_scale (self);
	_tmp19_ = self->priv->container;
	g_signal_connect_object (_tmp19_, "button-release-event", (GCallback) _gala_window_switcher_container_mouse_release_clutter_actor_button_release_event, self, 0);
	_tmp20_ = self->priv->style_manager;
	_tmp21_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp22_ = _tmp21_;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::prefers-color-scheme", (GCallback) _clutter_content_invalidate_g_object_notify, _tmp22_, 0);
	_tmp23_ = self->priv->_wm;
	_tmp24_ = meta_plugin_get_display ((MetaPlugin*) _tmp23_);
	_tmp25_ = meta_display_get_context (_tmp24_);
	_tmp26_ = meta_context_get_backend (_tmp25_);
	_tmp27_ = meta_backend_get_monitor_manager (_tmp26_);
	monitor_manager = _tmp27_;
	_tmp28_ = monitor_manager;
	g_signal_connect_object (_tmp28_, "monitors-changed", (GCallback) _gala_window_switcher_scale_meta_monitor_manager_monitors_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::opacity", (GCallback) __gala_window_switcher___lambda95__g_object_notify, self, 0);
	return obj;
}

static void
gala_window_switcher_class_init (GalaWindowSwitcherClass * klass,
                                 gpointer klass_data)
{
	gala_window_switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowSwitcher_private_offset);
	((ClutterActorClass *) klass)->get_preferred_width = (void (*) (ClutterActor*, gfloat, gfloat*, gfloat*)) gala_window_switcher_real_get_preferred_width;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_window_switcher_real_draw;
	((ClutterActorClass *) klass)->key_focus_out = (void (*) (ClutterActor*)) gala_window_switcher_real_key_focus_out;
	((ClutterActorClass *) klass)->key_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_switcher_real_key_release_event;
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_switcher_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_switcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_switcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_switcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_switcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_WM_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_OPENED_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY] = g_param_spec_boolean ("opened", "opened", "opened", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_ACTOR_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_window_switcher_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                         gpointer iface_data)
{
	gala_window_switcher_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_window_switcher_real_propagate;
	iface->get_actor = gala_window_switcher_real_get_actor;
}

static void
gala_window_switcher_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_window_switcher_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_window_switcher_instance_init (GalaWindowSwitcher * self,
                                    gpointer klass)
{
	self->priv = gala_window_switcher_get_instance_private (self);
	self->priv->_opened = FALSE;
	self->priv->modal_proxy = NULL;
	self->priv->_current_icon = NULL;
	self->priv->previous_progress = 0.;
	self->priv->scaling_factor = 1.0f;
}

static void
gala_window_switcher_finalize (GObject * obj)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->modal_proxy);
	_g_object_unref0 (self->priv->style_manager);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->caption);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->_current_icon);
	G_OBJECT_CLASS (gala_window_switcher_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_window_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowSwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowSwitcher), 0, (GInstanceInitFunc) gala_window_switcher_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_window_switcher_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_window_switcher_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_switcher_type_id;
	gala_window_switcher_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaWindowSwitcher", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_switcher_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	g_type_add_interface_static (gala_window_switcher_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaWindowSwitcher_private_offset = g_type_add_instance_private (gala_window_switcher_type_id, sizeof (GalaWindowSwitcherPrivate));
	return gala_window_switcher_type_id;
}

GType
gala_window_switcher_get_type (void)
{
	static gsize gala_window_switcher_type_id__once = 0;
	if (g_once_init_enter (&gala_window_switcher_type_id__once)) {
		GType gala_window_switcher_type_id;
		gala_window_switcher_type_id = gala_window_switcher_get_type_once ();
		g_once_init_leave (&gala_window_switcher_type_id__once, gala_window_switcher_type_id);
	}
	return gala_window_switcher_type_id__once;
}

static void
_vala_gala_window_switcher_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		g_value_set_object (value, gala_window_switcher_get_wm (self));
		break;
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		g_value_set_boolean (value, gala_window_switcher_get_opened (self));
		break;
		case GALA_WINDOW_SWITCHER_ACTOR_PROPERTY:
		g_value_set_object (value, gala_gesture_target_get_actor ((GalaGestureTarget*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_switcher_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		gala_window_switcher_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		gala_window_switcher_set_opened (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

