/* migrator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from migrator.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-games.h"
#include <gio/gio.h>
#include <retro-gtk.h>

#define GAMES_MIGRATOR_LATEST_VERSION ((guint) 3)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_MIGRATOR (games_migrator_get_type ())
#define GAMES_MIGRATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MIGRATOR, GamesMigrator))
#define GAMES_MIGRATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MIGRATOR, GamesMigratorClass))
#define GAMES_IS_MIGRATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MIGRATOR))
#define GAMES_IS_MIGRATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MIGRATOR))
#define GAMES_MIGRATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MIGRATOR, GamesMigratorClass))

typedef struct _GamesMigrator GamesMigrator;
typedef struct _GamesMigratorClass GamesMigratorClass;
typedef struct _GamesMigratorPrivate GamesMigratorPrivate;
enum  {
	GAMES_MIGRATOR_0_PROPERTY,
	GAMES_MIGRATOR_NUM_PROPERTIES
};
static GParamSpec* games_migrator_properties[GAMES_MIGRATOR_NUM_PROPERTIES];

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define GAMES_TYPE_PLATFORM_REGISTER (games_platform_register_get_type ())
#define GAMES_PLATFORM_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegister))
#define GAMES_PLATFORM_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegisterClass))
#define GAMES_IS_PLATFORM_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLATFORM_REGISTER))
#define GAMES_IS_PLATFORM_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLATFORM_REGISTER))
#define GAMES_PLATFORM_REGISTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegisterClass))

typedef struct _GamesPlatformRegister GamesPlatformRegister;
typedef struct _GamesPlatformRegisterClass GamesPlatformRegisterClass;

struct _GamesMigrator {
	GObject parent_instance;
	GamesMigratorPrivate * priv;
};

struct _GamesMigratorClass {
	GObjectClass parent_class;
};

static gpointer games_migrator_parent_class = NULL;
static guint games_migrator_version;
static guint games_migrator_version = (guint) 0;
static gboolean games_migrator_skip_migration;
static gboolean games_migrator_skip_migration = FALSE;

VALA_EXTERN GType games_migrator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void games_migrator_bump_to_latest_version (void);
VALA_EXTERN void games_migrator_bump_version (void);
VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean games_migrator_apply_migration_if_necessary (GamesDatabase* database);
static guint games_migrator_get_version (void);
static gboolean games_migrator_apply_data_dir_migration (void);
VALA_EXTERN void games_database_apply_favorites_migration (GamesDatabase* self,
                                               GError** error);
VALA_EXTERN void games_database_apply_recently_played_migration (GamesDatabase* self,
                                                     GError** error);
static void games_migrator_apply_migration (GError** error);
static void games_migrator_delete_files_no_errors (GFile* file);
static void games_migrator_delete_old_directories (void);
static gboolean games_migrator_try_restore_data (const gchar* backup_archive_path,
                                          const gchar* data_dir_path,
                                          gchar** backup_excluded_files,
                                          gint backup_excluded_files_length1);
static gchar* games_migrator_get_savestates_dir_path (void);
static gchar* games_migrator_get_old_snapshots_dir_path (void);
static void games_migrator_create_first_game_savestate (const gchar* game_uid,
                                                 GError** error);
static GamesRetroPlatform* games_migrator_platform_from_game_uid (const gchar* game_uid);
static gchar* games_migrator_get_old_saves_dir_path (void);
static gchar* games_migrator_get_old_medias_dir_path (void);
VALA_EXTERN GType games_platform_register_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPlatformRegister* games_platform_register_get_register (void);
VALA_EXTERN GList* games_platform_register_get_all_platforms (GamesPlatformRegister* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GamesMigrator* games_migrator_new (void);
VALA_EXTERN GamesMigrator* games_migrator_construct (GType object_type);
static void games_migrator_finalize (GObject * obj);
static GType games_migrator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
games_migrator_bump_to_latest_version (void)
{
	g_info ("migrator.vala:11: [Migrator]: Skipping migration");
	while (TRUE) {
		if (!(games_migrator_version < GAMES_MIGRATOR_LATEST_VERSION)) {
			break;
		}
		games_migrator_bump_version ();
	}
	games_migrator_skip_migration = TRUE;
}

gboolean
games_migrator_apply_migration_if_necessary (GamesDatabase* database)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (database != NULL, FALSE);
	if (games_migrator_skip_migration) {
		result = TRUE;
		return result;
	}
	games_migrator_version = games_migrator_get_version ();
	if (games_migrator_version == ((guint) 0)) {
		if (!games_migrator_apply_data_dir_migration ()) {
			result = FALSE;
			return result;
		}
		games_migrator_bump_version ();
	}
	if (games_migrator_version < ((guint) 2)) {
		{
			games_database_apply_favorites_migration (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			const gchar* _tmp1_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp0_ = e;
			_tmp1_ = _tmp0_->message;
			g_critical ("migrator.vala:38: Failed to apply favorites migration: %s", _tmp1_);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		games_migrator_bump_version ();
	}
	if (games_migrator_version < ((guint) 3)) {
		{
			games_database_apply_recently_played_migration (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_critical ("migrator.vala:50: Failed to apply recently played migration: %s", _tmp4_);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		games_migrator_bump_version ();
	}
	result = TRUE;
	return result;
}

static guint
uint_parse (const gchar* str,
            guint _base)
{
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	result = (guint) strtoul (str, NULL, (gint) _base);
	return result;
}

static guint
games_migrator_get_version (void)
{
	gchar* data_dir_path = NULL;
	gchar* _tmp0_;
	GFile* data_dir = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* version_file = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	guint result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir_path = _tmp0_;
	_tmp1_ = data_dir_path;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	data_dir = _tmp2_;
	_tmp3_ = data_dir;
	_tmp4_ = g_file_get_child (_tmp3_, ".version");
	version_file = _tmp4_;
	_tmp5_ = version_file;
	if (g_file_query_exists (_tmp5_, NULL)) {
		{
			GFileInputStream* file_input_stream = NULL;
			GFile* _tmp6_;
			GFileInputStream* _tmp7_;
			GDataInputStream* data_input_stream = NULL;
			GFileInputStream* _tmp8_;
			GDataInputStream* _tmp9_;
			gchar* line = NULL;
			gchar* _tmp10_ = NULL;
			GDataInputStream* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = version_file;
			_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error0_);
			file_input_stream = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = file_input_stream;
			_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
			data_input_stream = _tmp9_;
			_tmp11_ = data_input_stream;
			_tmp12_ = g_data_input_stream_read_line (_tmp11_, NULL, NULL, &_inner_error0_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (data_input_stream);
				_g_object_unref0 (file_input_stream);
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_free0 (line);
			line = _tmp13_;
			_tmp14_ = line;
			if (_tmp14_ != NULL) {
				const gchar* _tmp15_;
				_tmp15_ = line;
				result = uint_parse (_tmp15_, (guint) 0);
				_g_free0 (_tmp10_);
				_g_free0 (line);
				_g_object_unref0 (data_input_stream);
				_g_object_unref0 (file_input_stream);
				_g_object_unref0 (version_file);
				_g_object_unref0 (data_dir);
				_g_free0 (data_dir_path);
				return result;
			}
			result = (guint) 1;
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data_input_stream);
			_g_object_unref0 (file_input_stream);
			_g_object_unref0 (version_file);
			_g_object_unref0 (data_dir);
			_g_free0 (data_dir_path);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_critical ("migrator.vala:78: Failed to bump version: %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint _tmp18_ = 0U;
			_g_object_unref0 (version_file);
			_g_object_unref0 (data_dir);
			_g_free0 (data_dir_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
	}
	result = (guint) 0;
	_g_object_unref0 (version_file);
	_g_object_unref0 (data_dir);
	_g_free0 (data_dir_path);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
games_migrator_bump_version (void)
{
	gchar* data_dir_path = NULL;
	gchar* _tmp0_;
	GFile* data_dir = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* version_file = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	guint _tmp20_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = games_application_get_data_dir ();
	data_dir_path = _tmp0_;
	_tmp1_ = data_dir_path;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	data_dir = _tmp2_;
	_tmp3_ = data_dir;
	_tmp4_ = g_file_get_child (_tmp3_, ".version");
	version_file = _tmp4_;
	if (games_migrator_version > ((guint) 0)) {
		{
			GFile* _tmp5_;
			guint _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			guint8* _tmp9_;
			gint _tmp9__length1;
			gint _tmp10_ = 0;
			guint8* _tmp11_;
			gint _tmp11__length1;
			_tmp5_ = version_file;
			games_migrator_version = games_migrator_version + 1;
			_tmp6_ = games_migrator_version;
			_tmp7_ = g_strdup_printf ("%u", _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_get_data (_tmp8_, &_tmp10_);
			_tmp9__length1 = _tmp10_;
			_tmp11_ = _tmp9_;
			_tmp11__length1 = _tmp9__length1;
			g_file_replace_contents (_tmp5_, (const char*) _tmp11_, (gsize) _tmp11__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			guint _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = games_migrator_version;
			games_migrator_version = _tmp12_ - 1;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_critical ("migrator.vala:95: Failed to bump version to %u: %s", _tmp12_, _tmp14_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (version_file);
			_g_object_unref0 (data_dir);
			_g_free0 (data_dir_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (version_file);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		return;
	}
	{
		GFile* _tmp15_;
		GFileOutputStream* _tmp16_;
		GFileOutputStream* _tmp17_;
		_tmp15_ = version_file;
		_tmp16_ = g_file_create (_tmp15_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp17_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("migrator.vala:105: Failed to create .version file: %s", _tmp19_);
		_g_error_free0 (e);
		_g_object_unref0 (version_file);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (version_file);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = games_migrator_version;
	games_migrator_version = _tmp20_ + 1;
	_g_object_unref0 (version_file);
	_g_object_unref0 (data_dir);
	_g_free0 (data_dir_path);
}

static gboolean
games_migrator_apply_data_dir_migration (void)
{
	gchar* data_dir_path = NULL;
	gchar* _tmp0_;
	GFile* data_dir = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* backup_archive_path = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* backup_archive = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	gchar* database_path = NULL;
	gchar* _tmp7_;
	gchar** backup_excluded_files = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint backup_excluded_files_length1;
	gint _backup_excluded_files_size_;
	GFile* _tmp34_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir_path = _tmp0_;
	_tmp1_ = data_dir_path;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	data_dir = _tmp2_;
	_tmp3_ = data_dir_path;
	_tmp4_ = g_build_filename (_tmp3_, "exported_data.zip", NULL);
	backup_archive_path = _tmp4_;
	_tmp5_ = backup_archive_path;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	backup_archive = _tmp6_;
	_tmp7_ = games_application_get_database_path ();
	database_path = _tmp7_;
	_tmp8_ = database_path;
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = backup_archive_path;
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp9_;
	_tmp12_[1] = _tmp11_;
	backup_excluded_files = _tmp12_;
	backup_excluded_files_length1 = 2;
	_backup_excluded_files_size_ = backup_excluded_files_length1;
	g_info ("migrator.vala:121: [Migrator]: Data directory migration is necessary");
	{
		GFile* _tmp13_;
		GFileOutputStream* _tmp14_;
		GFileOutputStream* _tmp15_;
		const gchar* _tmp16_;
		GFile* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp13_ = backup_archive;
		_tmp14_ = g_file_create (_tmp13_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp15_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = backup_archive_path;
		_tmp17_ = data_dir;
		_tmp18_ = backup_excluded_files;
		_tmp18__length1 = backup_excluded_files_length1;
		games_file_operations_compress_dir (_tmp16_, _tmp17_, _tmp18_, (gint) _tmp18__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("migrator.vala:129: Unable to backup data, aborting migration: %s", _tmp20_);
		result = FALSE;
		_g_error_free0 (e);
		backup_excluded_files = (_vala_array_free (backup_excluded_files, backup_excluded_files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (database_path);
		_g_object_unref0 (backup_archive);
		_g_free0 (backup_archive_path);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		backup_excluded_files = (_vala_array_free (backup_excluded_files, backup_excluded_files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (database_path);
		_g_object_unref0 (backup_archive);
		_g_free0 (backup_archive_path);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	{
		games_migrator_apply_migration (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		gchar* savestates_dir_path = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		GFile* savestates_dir = NULL;
		const gchar* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_critical ("migrator.vala:139: Migration failed: %s", _tmp23_);
		_tmp24_ = data_dir_path;
		_tmp25_ = g_build_filename (_tmp24_, "/savestates", NULL);
		savestates_dir_path = _tmp25_;
		_tmp26_ = savestates_dir_path;
		_tmp27_ = g_file_new_for_path (_tmp26_);
		savestates_dir = _tmp27_;
		_tmp28_ = savestates_dir;
		games_migrator_delete_files_no_errors (_tmp28_);
		games_migrator_delete_old_directories ();
		_tmp29_ = backup_archive_path;
		_tmp30_ = data_dir_path;
		_tmp31_ = backup_excluded_files;
		_tmp31__length1 = backup_excluded_files_length1;
		if (games_migrator_try_restore_data (_tmp29_, _tmp30_, _tmp31_, (gint) _tmp31__length1)) {
			GFile* _tmp32_;
			_tmp32_ = backup_archive;
			games_migrator_delete_files_no_errors (_tmp32_);
		} else {
			g_assert_not_reached ();
		}
		result = FALSE;
		_g_object_unref0 (savestates_dir);
		_g_free0 (savestates_dir_path);
		_g_error_free0 (e);
		backup_excluded_files = (_vala_array_free (backup_excluded_files, backup_excluded_files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (database_path);
		_g_object_unref0 (backup_archive);
		_g_free0 (backup_archive_path);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp33_ = FALSE;
		backup_excluded_files = (_vala_array_free (backup_excluded_files, backup_excluded_files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (database_path);
		_g_object_unref0 (backup_archive);
		_g_free0 (backup_archive_path);
		_g_object_unref0 (data_dir);
		_g_free0 (data_dir_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp33_;
	}
	_tmp34_ = backup_archive;
	games_migrator_delete_files_no_errors (_tmp34_);
	result = TRUE;
	backup_excluded_files = (_vala_array_free (backup_excluded_files, backup_excluded_files_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (database_path);
	_g_object_unref0 (backup_archive);
	_g_free0 (backup_archive_path);
	_g_object_unref0 (data_dir);
	_g_free0 (data_dir_path);
	return result;
}

static void
games_migrator_apply_migration (GError** error)
{
	GFile* savestates_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* snapshots_dir_path = NULL;
	gchar* _tmp6_;
	GDir* snapshots_dir = NULL;
	const gchar* _tmp7_;
	GDir* _tmp8_;
	gchar* file_name = NULL;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = games_migrator_get_savestates_dir_path ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	savestates_dir = _tmp3_;
	_tmp4_ = savestates_dir;
	if (g_file_query_exists (_tmp4_, NULL)) {
		_g_object_unref0 (savestates_dir);
		return;
	}
	_tmp5_ = savestates_dir;
	g_file_make_directory (_tmp5_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (savestates_dir);
		return;
	}
	_tmp6_ = games_migrator_get_old_snapshots_dir_path ();
	snapshots_dir_path = _tmp6_;
	_tmp7_ = snapshots_dir_path;
	_tmp8_ = g_dir_open (_tmp7_, (guint) 0, &_inner_error0_);
	snapshots_dir = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (snapshots_dir_path);
		_g_object_unref0 (savestates_dir);
		return;
	}
	_tmp9_ = g_strdup ("");
	file_name = _tmp9_;
	while (TRUE) {
		GDir* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar** file_name_tokens = NULL;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint file_name_tokens_length1;
		gint _file_name_tokens_size_;
		gchar* game_uid = NULL;
		gchar** _tmp18_;
		gint _tmp18__length1;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp10_ = snapshots_dir;
		_tmp11_ = g_dir_read_name (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (file_name);
		file_name = _tmp12_;
		_tmp13_ = file_name;
		if (!(_tmp13_ != NULL)) {
			break;
		}
		_tmp14_ = file_name;
		if (!g_str_has_suffix (_tmp14_, ".snapshot")) {
			continue;
		}
		_tmp15_ = file_name;
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, ".snapshot", 0);
		file_name_tokens = _tmp17_;
		file_name_tokens_length1 = _vala_array_length (_tmp16_);
		_file_name_tokens_size_ = file_name_tokens_length1;
		_tmp18_ = file_name_tokens;
		_tmp18__length1 = file_name_tokens_length1;
		_tmp19_ = _tmp18_[0];
		_tmp20_ = g_strdup (_tmp19_);
		game_uid = _tmp20_;
		_tmp21_ = game_uid;
		games_migrator_create_first_game_savestate (_tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (game_uid);
			file_name_tokens = (_vala_array_free (file_name_tokens, file_name_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (file_name);
			_g_dir_close0 (snapshots_dir);
			_g_free0 (snapshots_dir_path);
			_g_object_unref0 (savestates_dir);
			return;
		}
		_g_free0 (game_uid);
		file_name_tokens = (_vala_array_free (file_name_tokens, file_name_tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	games_migrator_delete_old_directories ();
	_g_free0 (file_name);
	_g_dir_close0 (snapshots_dir);
	_g_free0 (snapshots_dir_path);
	_g_object_unref0 (savestates_dir);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
games_migrator_create_first_game_savestate (const gchar* game_uid,
                                            GError** error)
{
	GamesRetroPlatform* platform = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroCoreManager* core_manager = NULL;
	GamesRetroCoreManager* _tmp1_;
	RetroCoreDescriptor* preferred_core = NULL;
	GamesRetroCoreManager* _tmp2_;
	GamesRetroPlatform* _tmp3_;
	RetroCoreDescriptor* _tmp4_;
	gchar* core_id = NULL;
	RetroCoreDescriptor* _tmp5_;
	gchar* _tmp6_;
	gchar* core_id_prefix = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* game_savestates_dir_name = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* game_savestates_dir_path = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* game_savestates_dir = NULL;
	const gchar* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GDateTime* now_time = NULL;
	GTimeZone* _tmp22_;
	GTimeZone* _tmp23_;
	GDateTime* _tmp24_;
	GDateTime* _tmp25_;
	gchar* now_time_str = NULL;
	GDateTime* _tmp26_;
	gchar* _tmp27_;
	gchar* savestate_dir_path = NULL;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GFile* savestate_dir = NULL;
	const gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	gchar* snapshots_dir_path = NULL;
	gchar* _tmp34_;
	gchar* snapshot_path = NULL;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* screenshot_path = NULL;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* saves_dir = NULL;
	gchar* _tmp45_;
	gchar* save_dir_path = NULL;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* save_file_path = NULL;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* medias_dir = NULL;
	gchar* _tmp50_;
	gchar* media_file_path = NULL;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GFile* snapshot_file = NULL;
	const gchar* _tmp56_;
	GFile* _tmp57_;
	GFile* screenshot_file = NULL;
	const gchar* _tmp58_;
	GFile* _tmp59_;
	GFile* save_dir = NULL;
	const gchar* _tmp60_;
	GFile* _tmp61_;
	GFile* save_file = NULL;
	const gchar* _tmp62_;
	GFile* _tmp63_;
	GFile* media_file = NULL;
	const gchar* _tmp64_;
	GFile* _tmp65_;
	gchar* savestate_snapshot_file_path = NULL;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	GFile* savestate_snapshot_file = NULL;
	const gchar* _tmp68_;
	GFile* _tmp69_;
	GFile* _tmp70_;
	GFile* _tmp71_;
	gchar* savestate_screenshot_file_path = NULL;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	GFile* savestate_screenshot_file = NULL;
	const gchar* _tmp74_;
	GFile* _tmp75_;
	GFile* _tmp76_;
	GFile* _tmp77_;
	GFile* _tmp78_;
	gchar* savestate_save_dir_path = NULL;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	GFile* savestate_save_dir = NULL;
	const gchar* _tmp82_;
	GFile* _tmp83_;
	GFile* _tmp84_;
	GFile* _tmp85_;
	GFile* _tmp86_;
	GFile* _tmp93_;
	GKeyFile* metadata = NULL;
	GKeyFile* _tmp100_;
	gchar* metadata_file_path = NULL;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	GKeyFile* _tmp103_;
	GKeyFile* _tmp104_;
	const gchar* _tmp105_;
	GKeyFile* _tmp106_;
	GamesRetroPlatform* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	GKeyFile* _tmp110_;
	const gchar* _tmp111_;
	GKeyFile* _tmp112_;
	const gchar* _tmp113_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (game_uid != NULL);
	_tmp0_ = games_migrator_platform_from_game_uid (game_uid);
	platform = _tmp0_;
	_tmp1_ = games_retro_core_manager_get_instance ();
	core_manager = _tmp1_;
	_tmp2_ = core_manager;
	_tmp3_ = platform;
	_tmp4_ = games_retro_core_manager_get_preferred_core (_tmp2_, _tmp3_);
	preferred_core = _tmp4_;
	_tmp5_ = preferred_core;
	_tmp6_ = retro_core_descriptor_get_id (_tmp5_);
	core_id = _tmp6_;
	_tmp7_ = core_id;
	_tmp8_ = string_replace (_tmp7_, ".libretro", "");
	core_id_prefix = _tmp8_;
	_tmp9_ = g_strconcat (game_uid, "-", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = core_id_prefix;
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	game_savestates_dir_name = _tmp13_;
	_tmp14_ = games_migrator_get_savestates_dir_path ();
	_tmp15_ = _tmp14_;
	_tmp16_ = game_savestates_dir_name;
	_tmp17_ = g_build_filename (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	game_savestates_dir_path = _tmp18_;
	_tmp19_ = game_savestates_dir_path;
	_tmp20_ = g_file_new_for_path (_tmp19_);
	game_savestates_dir = _tmp20_;
	_tmp21_ = game_savestates_dir;
	g_file_make_directory (_tmp21_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (game_savestates_dir);
		_g_free0 (game_savestates_dir_path);
		_g_free0 (game_savestates_dir_name);
		_g_free0 (core_id_prefix);
		_g_free0 (core_id);
		_g_object_unref0 (preferred_core);
		_g_object_unref0 (core_manager);
		_g_object_unref0 (platform);
		return;
	}
	_tmp22_ = g_time_zone_new_local ();
	_tmp23_ = _tmp22_;
	_tmp24_ = g_date_time_new_now (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_time_zone_unref0 (_tmp23_);
	now_time = _tmp25_;
	_tmp26_ = now_time;
	_tmp27_ = g_date_time_to_string (_tmp26_);
	now_time_str = _tmp27_;
	_tmp28_ = game_savestates_dir_path;
	_tmp29_ = now_time_str;
	_tmp30_ = g_build_filename (_tmp28_, _tmp29_, NULL);
	savestate_dir_path = _tmp30_;
	_tmp31_ = savestate_dir_path;
	_tmp32_ = g_file_new_for_path (_tmp31_);
	savestate_dir = _tmp32_;
	_tmp33_ = savestate_dir;
	g_file_make_directory (_tmp33_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (savestate_dir);
		_g_free0 (savestate_dir_path);
		_g_free0 (now_time_str);
		_g_date_time_unref0 (now_time);
		_g_object_unref0 (game_savestates_dir);
		_g_free0 (game_savestates_dir_path);
		_g_free0 (game_savestates_dir_name);
		_g_free0 (core_id_prefix);
		_g_free0 (core_id);
		_g_object_unref0 (preferred_core);
		_g_object_unref0 (core_manager);
		_g_object_unref0 (platform);
		return;
	}
	_tmp34_ = games_migrator_get_old_snapshots_dir_path ();
	snapshots_dir_path = _tmp34_;
	_tmp35_ = snapshots_dir_path;
	_tmp36_ = g_strconcat (game_uid, ".snapshot", NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_build_filename (_tmp35_, _tmp37_, NULL);
	_tmp39_ = _tmp38_;
	_g_free0 (_tmp37_);
	snapshot_path = _tmp39_;
	_tmp40_ = snapshots_dir_path;
	_tmp41_ = g_strconcat (game_uid, ".png", NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_build_filename (_tmp40_, _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	_g_free0 (_tmp42_);
	screenshot_path = _tmp44_;
	_tmp45_ = games_migrator_get_old_saves_dir_path ();
	saves_dir = _tmp45_;
	_tmp46_ = saves_dir;
	_tmp47_ = g_build_filename (_tmp46_, game_uid, NULL);
	save_dir_path = _tmp47_;
	_tmp48_ = save_dir_path;
	_tmp49_ = g_strconcat (_tmp48_, ".save", NULL);
	save_file_path = _tmp49_;
	_tmp50_ = games_migrator_get_old_medias_dir_path ();
	medias_dir = _tmp50_;
	_tmp51_ = medias_dir;
	_tmp52_ = g_strconcat (game_uid, ".media", NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_build_filename (_tmp51_, _tmp53_, NULL);
	_tmp55_ = _tmp54_;
	_g_free0 (_tmp53_);
	media_file_path = _tmp55_;
	_tmp56_ = snapshot_path;
	_tmp57_ = g_file_new_for_path (_tmp56_);
	snapshot_file = _tmp57_;
	_tmp58_ = screenshot_path;
	_tmp59_ = g_file_new_for_path (_tmp58_);
	screenshot_file = _tmp59_;
	_tmp60_ = save_dir_path;
	_tmp61_ = g_file_new_for_path (_tmp60_);
	save_dir = _tmp61_;
	_tmp62_ = save_file_path;
	_tmp63_ = g_file_new_for_path (_tmp62_);
	save_file = _tmp63_;
	_tmp64_ = media_file_path;
	_tmp65_ = g_file_new_for_path (_tmp64_);
	media_file = _tmp65_;
	_tmp66_ = savestate_dir_path;
	_tmp67_ = g_build_filename (_tmp66_, "snapshot", NULL);
	savestate_snapshot_file_path = _tmp67_;
	_tmp68_ = savestate_snapshot_file_path;
	_tmp69_ = g_file_new_for_path (_tmp68_);
	savestate_snapshot_file = _tmp69_;
	_tmp70_ = snapshot_file;
	_tmp71_ = savestate_snapshot_file;
	games_file_operations_copy_contents (_tmp70_, _tmp71_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (savestate_snapshot_file);
		_g_free0 (savestate_snapshot_file_path);
		_g_object_unref0 (media_file);
		_g_object_unref0 (save_file);
		_g_object_unref0 (save_dir);
		_g_object_unref0 (screenshot_file);
		_g_object_unref0 (snapshot_file);
		_g_free0 (media_file_path);
		_g_free0 (medias_dir);
		_g_free0 (save_file_path);
		_g_free0 (save_dir_path);
		_g_free0 (saves_dir);
		_g_free0 (screenshot_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshots_dir_path);
		_g_object_unref0 (savestate_dir);
		_g_free0 (savestate_dir_path);
		_g_free0 (now_time_str);
		_g_date_time_unref0 (now_time);
		_g_object_unref0 (game_savestates_dir);
		_g_free0 (game_savestates_dir_path);
		_g_free0 (game_savestates_dir_name);
		_g_free0 (core_id_prefix);
		_g_free0 (core_id);
		_g_object_unref0 (preferred_core);
		_g_object_unref0 (core_manager);
		_g_object_unref0 (platform);
		return;
	}
	_tmp72_ = savestate_dir_path;
	_tmp73_ = g_build_filename (_tmp72_, "screenshot", NULL);
	savestate_screenshot_file_path = _tmp73_;
	_tmp74_ = savestate_screenshot_file_path;
	_tmp75_ = g_file_new_for_path (_tmp74_);
	savestate_screenshot_file = _tmp75_;
	_tmp76_ = screenshot_file;
	_tmp77_ = savestate_screenshot_file;
	games_file_operations_copy_contents (_tmp76_, _tmp77_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (savestate_screenshot_file);
		_g_free0 (savestate_screenshot_file_path);
		_g_object_unref0 (savestate_snapshot_file);
		_g_free0 (savestate_snapshot_file_path);
		_g_object_unref0 (media_file);
		_g_object_unref0 (save_file);
		_g_object_unref0 (save_dir);
		_g_object_unref0 (screenshot_file);
		_g_object_unref0 (snapshot_file);
		_g_free0 (media_file_path);
		_g_free0 (medias_dir);
		_g_free0 (save_file_path);
		_g_free0 (save_dir_path);
		_g_free0 (saves_dir);
		_g_free0 (screenshot_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshots_dir_path);
		_g_object_unref0 (savestate_dir);
		_g_free0 (savestate_dir_path);
		_g_free0 (now_time_str);
		_g_date_time_unref0 (now_time);
		_g_object_unref0 (game_savestates_dir);
		_g_free0 (game_savestates_dir_path);
		_g_free0 (game_savestates_dir_name);
		_g_free0 (core_id_prefix);
		_g_free0 (core_id);
		_g_object_unref0 (preferred_core);
		_g_object_unref0 (core_manager);
		_g_object_unref0 (platform);
		return;
	}
	_tmp78_ = save_dir;
	if (!g_file_query_exists (_tmp78_, NULL)) {
		GFile* _tmp79_;
		_tmp79_ = save_dir;
		g_file_make_directory (_tmp79_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (savestate_screenshot_file);
			_g_free0 (savestate_screenshot_file_path);
			_g_object_unref0 (savestate_snapshot_file);
			_g_free0 (savestate_snapshot_file_path);
			_g_object_unref0 (media_file);
			_g_object_unref0 (save_file);
			_g_object_unref0 (save_dir);
			_g_object_unref0 (screenshot_file);
			_g_object_unref0 (snapshot_file);
			_g_free0 (media_file_path);
			_g_free0 (medias_dir);
			_g_free0 (save_file_path);
			_g_free0 (save_dir_path);
			_g_free0 (saves_dir);
			_g_free0 (screenshot_path);
			_g_free0 (snapshot_path);
			_g_free0 (snapshots_dir_path);
			_g_object_unref0 (savestate_dir);
			_g_free0 (savestate_dir_path);
			_g_free0 (now_time_str);
			_g_date_time_unref0 (now_time);
			_g_object_unref0 (game_savestates_dir);
			_g_free0 (game_savestates_dir_path);
			_g_free0 (game_savestates_dir_name);
			_g_free0 (core_id_prefix);
			_g_free0 (core_id);
			_g_object_unref0 (preferred_core);
			_g_object_unref0 (core_manager);
			_g_object_unref0 (platform);
			return;
		}
	}
	_tmp80_ = savestate_dir_path;
	_tmp81_ = g_build_filename (_tmp80_, "save-dir", NULL);
	savestate_save_dir_path = _tmp81_;
	_tmp82_ = savestate_save_dir_path;
	_tmp83_ = g_file_new_for_path (_tmp82_);
	savestate_save_dir = _tmp83_;
	_tmp84_ = save_dir;
	_tmp85_ = savestate_save_dir;
	games_file_operations_copy_dir (_tmp84_, _tmp85_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (savestate_save_dir);
		_g_free0 (savestate_save_dir_path);
		_g_object_unref0 (savestate_screenshot_file);
		_g_free0 (savestate_screenshot_file_path);
		_g_object_unref0 (savestate_snapshot_file);
		_g_free0 (savestate_snapshot_file_path);
		_g_object_unref0 (media_file);
		_g_object_unref0 (save_file);
		_g_object_unref0 (save_dir);
		_g_object_unref0 (screenshot_file);
		_g_object_unref0 (snapshot_file);
		_g_free0 (media_file_path);
		_g_free0 (medias_dir);
		_g_free0 (save_file_path);
		_g_free0 (save_dir_path);
		_g_free0 (saves_dir);
		_g_free0 (screenshot_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshots_dir_path);
		_g_object_unref0 (savestate_dir);
		_g_free0 (savestate_dir_path);
		_g_free0 (now_time_str);
		_g_date_time_unref0 (now_time);
		_g_object_unref0 (game_savestates_dir);
		_g_free0 (game_savestates_dir_path);
		_g_free0 (game_savestates_dir_name);
		_g_free0 (core_id_prefix);
		_g_free0 (core_id);
		_g_object_unref0 (preferred_core);
		_g_object_unref0 (core_manager);
		_g_object_unref0 (platform);
		return;
	}
	_tmp86_ = save_file;
	if (g_file_query_exists (_tmp86_, NULL)) {
		gchar* savestate_save_file_path = NULL;
		const gchar* _tmp87_;
		gchar* _tmp88_;
		GFile* savestate_save_file = NULL;
		const gchar* _tmp89_;
		GFile* _tmp90_;
		GFile* _tmp91_;
		GFile* _tmp92_;
		_tmp87_ = savestate_dir_path;
		_tmp88_ = g_build_filename (_tmp87_, "save", NULL);
		savestate_save_file_path = _tmp88_;
		_tmp89_ = savestate_save_file_path;
		_tmp90_ = g_file_new_for_path (_tmp89_);
		savestate_save_file = _tmp90_;
		_tmp91_ = save_file;
		_tmp92_ = savestate_save_file;
		games_file_operations_copy_contents (_tmp91_, _tmp92_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (savestate_save_file);
			_g_free0 (savestate_save_file_path);
			_g_object_unref0 (savestate_save_dir);
			_g_free0 (savestate_save_dir_path);
			_g_object_unref0 (savestate_screenshot_file);
			_g_free0 (savestate_screenshot_file_path);
			_g_object_unref0 (savestate_snapshot_file);
			_g_free0 (savestate_snapshot_file_path);
			_g_object_unref0 (media_file);
			_g_object_unref0 (save_file);
			_g_object_unref0 (save_dir);
			_g_object_unref0 (screenshot_file);
			_g_object_unref0 (snapshot_file);
			_g_free0 (media_file_path);
			_g_free0 (medias_dir);
			_g_free0 (save_file_path);
			_g_free0 (save_dir_path);
			_g_free0 (saves_dir);
			_g_free0 (screenshot_path);
			_g_free0 (snapshot_path);
			_g_free0 (snapshots_dir_path);
			_g_object_unref0 (savestate_dir);
			_g_free0 (savestate_dir_path);
			_g_free0 (now_time_str);
			_g_date_time_unref0 (now_time);
			_g_object_unref0 (game_savestates_dir);
			_g_free0 (game_savestates_dir_path);
			_g_free0 (game_savestates_dir_name);
			_g_free0 (core_id_prefix);
			_g_free0 (core_id);
			_g_object_unref0 (preferred_core);
			_g_object_unref0 (core_manager);
			_g_object_unref0 (platform);
			return;
		}
		_g_object_unref0 (savestate_save_file);
		_g_free0 (savestate_save_file_path);
	}
	_tmp93_ = media_file;
	if (g_file_query_exists (_tmp93_, NULL)) {
		gchar* savestate_media_file_path = NULL;
		const gchar* _tmp94_;
		gchar* _tmp95_;
		GFile* savestate_media_file = NULL;
		const gchar* _tmp96_;
		GFile* _tmp97_;
		GFile* _tmp98_;
		GFile* _tmp99_;
		_tmp94_ = savestate_dir_path;
		_tmp95_ = g_build_filename (_tmp94_, "media", NULL);
		savestate_media_file_path = _tmp95_;
		_tmp96_ = savestate_media_file_path;
		_tmp97_ = g_file_new_for_path (_tmp96_);
		savestate_media_file = _tmp97_;
		_tmp98_ = media_file;
		_tmp99_ = savestate_media_file;
		games_file_operations_copy_contents (_tmp98_, _tmp99_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (savestate_media_file);
			_g_free0 (savestate_media_file_path);
			_g_object_unref0 (savestate_save_dir);
			_g_free0 (savestate_save_dir_path);
			_g_object_unref0 (savestate_screenshot_file);
			_g_free0 (savestate_screenshot_file_path);
			_g_object_unref0 (savestate_snapshot_file);
			_g_free0 (savestate_snapshot_file_path);
			_g_object_unref0 (media_file);
			_g_object_unref0 (save_file);
			_g_object_unref0 (save_dir);
			_g_object_unref0 (screenshot_file);
			_g_object_unref0 (snapshot_file);
			_g_free0 (media_file_path);
			_g_free0 (medias_dir);
			_g_free0 (save_file_path);
			_g_free0 (save_dir_path);
			_g_free0 (saves_dir);
			_g_free0 (screenshot_path);
			_g_free0 (snapshot_path);
			_g_free0 (snapshots_dir_path);
			_g_object_unref0 (savestate_dir);
			_g_free0 (savestate_dir_path);
			_g_free0 (now_time_str);
			_g_date_time_unref0 (now_time);
			_g_object_unref0 (game_savestates_dir);
			_g_free0 (game_savestates_dir_path);
			_g_free0 (game_savestates_dir_name);
			_g_free0 (core_id_prefix);
			_g_free0 (core_id);
			_g_object_unref0 (preferred_core);
			_g_object_unref0 (core_manager);
			_g_object_unref0 (platform);
			return;
		}
		_g_object_unref0 (savestate_media_file);
		_g_free0 (savestate_media_file_path);
	}
	_tmp100_ = g_key_file_new ();
	metadata = _tmp100_;
	_tmp101_ = savestate_dir_path;
	_tmp102_ = g_build_filename (_tmp101_, "metadata", NULL);
	metadata_file_path = _tmp102_;
	_tmp103_ = metadata;
	g_key_file_set_boolean (_tmp103_, "Metadata", "Automatic", TRUE);
	_tmp104_ = metadata;
	_tmp105_ = now_time_str;
	g_key_file_set_string (_tmp104_, "Metadata", "Creation Date", _tmp105_);
	_tmp106_ = metadata;
	_tmp107_ = platform;
	_tmp108_ = games_platform_get_uid_prefix ((GamesPlatform*) _tmp107_);
	_tmp109_ = _tmp108_;
	g_key_file_set_string (_tmp106_, "Metadata", "Platform", _tmp109_);
	_g_free0 (_tmp109_);
	_tmp110_ = metadata;
	_tmp111_ = core_id;
	g_key_file_set_string (_tmp110_, "Metadata", "Core", _tmp111_);
	_tmp112_ = metadata;
	_tmp113_ = metadata_file_path;
	g_key_file_save_to_file (_tmp112_, _tmp113_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (metadata_file_path);
		_g_key_file_unref0 (metadata);
		_g_object_unref0 (savestate_save_dir);
		_g_free0 (savestate_save_dir_path);
		_g_object_unref0 (savestate_screenshot_file);
		_g_free0 (savestate_screenshot_file_path);
		_g_object_unref0 (savestate_snapshot_file);
		_g_free0 (savestate_snapshot_file_path);
		_g_object_unref0 (media_file);
		_g_object_unref0 (save_file);
		_g_object_unref0 (save_dir);
		_g_object_unref0 (screenshot_file);
		_g_object_unref0 (snapshot_file);
		_g_free0 (media_file_path);
		_g_free0 (medias_dir);
		_g_free0 (save_file_path);
		_g_free0 (save_dir_path);
		_g_free0 (saves_dir);
		_g_free0 (screenshot_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshots_dir_path);
		_g_object_unref0 (savestate_dir);
		_g_free0 (savestate_dir_path);
		_g_free0 (now_time_str);
		_g_date_time_unref0 (now_time);
		_g_object_unref0 (game_savestates_dir);
		_g_free0 (game_savestates_dir_path);
		_g_free0 (game_savestates_dir_name);
		_g_free0 (core_id_prefix);
		_g_free0 (core_id);
		_g_object_unref0 (preferred_core);
		_g_object_unref0 (core_manager);
		_g_object_unref0 (platform);
		return;
	}
	_g_free0 (metadata_file_path);
	_g_key_file_unref0 (metadata);
	_g_object_unref0 (savestate_save_dir);
	_g_free0 (savestate_save_dir_path);
	_g_object_unref0 (savestate_screenshot_file);
	_g_free0 (savestate_screenshot_file_path);
	_g_object_unref0 (savestate_snapshot_file);
	_g_free0 (savestate_snapshot_file_path);
	_g_object_unref0 (media_file);
	_g_object_unref0 (save_file);
	_g_object_unref0 (save_dir);
	_g_object_unref0 (screenshot_file);
	_g_object_unref0 (snapshot_file);
	_g_free0 (media_file_path);
	_g_free0 (medias_dir);
	_g_free0 (save_file_path);
	_g_free0 (save_dir_path);
	_g_free0 (saves_dir);
	_g_free0 (screenshot_path);
	_g_free0 (snapshot_path);
	_g_free0 (snapshots_dir_path);
	_g_object_unref0 (savestate_dir);
	_g_free0 (savestate_dir_path);
	_g_free0 (now_time_str);
	_g_date_time_unref0 (now_time);
	_g_object_unref0 (game_savestates_dir);
	_g_free0 (game_savestates_dir_path);
	_g_free0 (game_savestates_dir_name);
	_g_free0 (core_id_prefix);
	_g_free0 (core_id);
	_g_object_unref0 (preferred_core);
	_g_object_unref0 (core_manager);
	_g_object_unref0 (platform);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GamesRetroPlatform*
games_migrator_platform_from_game_uid (const gchar* game_uid)
{
	GamesPlatformRegister* platforms_register = NULL;
	GamesPlatformRegister* _tmp0_;
	GList* platforms = NULL;
	GamesPlatformRegister* _tmp1_;
	GList* _tmp2_;
	gchar* best_match = NULL;
	GamesRetroPlatform* result_platform = NULL;
	GList* _tmp3_;
	GamesRetroPlatform* result;
	g_return_val_if_fail (game_uid != NULL, NULL);
	_tmp0_ = games_platform_register_get_register ();
	platforms_register = _tmp0_;
	_tmp1_ = platforms_register;
	_tmp2_ = games_platform_register_get_all_platforms (_tmp1_);
	platforms = _tmp2_;
	best_match = NULL;
	result_platform = NULL;
	_tmp3_ = platforms;
	{
		GList* platform_collection = NULL;
		GList* platform_it = NULL;
		platform_collection = _tmp3_;
		for (platform_it = platform_collection; platform_it != NULL; platform_it = platform_it->next) {
			GamesPlatform* _tmp4_;
			GamesPlatform* platform = NULL;
			_tmp4_ = _g_object_ref0 ((GamesPlatform*) platform_it->data);
			platform = _tmp4_;
			{
				GamesRetroPlatform* retro_platform = NULL;
				GamesPlatform* _tmp5_;
				GamesRetroPlatform* _tmp6_;
				GamesRetroPlatform* _tmp7_;
				gchar* platform_uid_prefix = NULL;
				GamesPlatform* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp5_ = platform;
				_tmp6_ = _g_object_ref0 (GAMES_IS_RETRO_PLATFORM (_tmp5_) ? ((GamesRetroPlatform*) _tmp5_) : NULL);
				retro_platform = _tmp6_;
				_tmp7_ = retro_platform;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (retro_platform);
					_g_object_unref0 (platform);
					continue;
				}
				_tmp8_ = platform;
				_tmp9_ = games_platform_get_uid_prefix (_tmp8_);
				platform_uid_prefix = _tmp9_;
				_tmp10_ = platform_uid_prefix;
				if (string_contains (game_uid, _tmp10_)) {
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_;
					_tmp12_ = best_match;
					if (_tmp12_ == NULL) {
						_tmp11_ = TRUE;
					} else {
						const gchar* _tmp13_;
						gint _tmp14_;
						gint _tmp15_;
						const gchar* _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						_tmp13_ = platform_uid_prefix;
						_tmp14_ = strlen (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = best_match;
						_tmp17_ = strlen (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp11_ = _tmp15_ > _tmp18_;
					}
					if (_tmp11_) {
						const gchar* _tmp19_;
						gchar* _tmp20_;
						GamesRetroPlatform* _tmp21_;
						GamesRetroPlatform* _tmp22_;
						_tmp19_ = platform_uid_prefix;
						_tmp20_ = g_strdup (_tmp19_);
						_g_free0 (best_match);
						best_match = _tmp20_;
						_tmp21_ = retro_platform;
						_tmp22_ = _g_object_ref0 (_tmp21_);
						_g_object_unref0 (result_platform);
						result_platform = _tmp22_;
					}
				}
				_g_free0 (platform_uid_prefix);
				_g_object_unref0 (retro_platform);
				_g_object_unref0 (platform);
			}
		}
	}
	result = result_platform;
	_g_free0 (best_match);
	(platforms == NULL) ? NULL : (platforms = (_g_list_free__g_object_unref0_ (platforms), NULL));
	_g_object_unref0 (platforms_register);
	return result;
}

static void
games_migrator_delete_old_directories (void)
{
	gchar* snapshots_dir_path = NULL;
	gchar* _tmp0_;
	gchar* saves_dir_path = NULL;
	gchar* _tmp1_;
	gchar* medias_dir_path = NULL;
	gchar* _tmp2_;
	GFile* snapshots_dir = NULL;
	GFile* _tmp3_;
	GFile* saves_dir = NULL;
	GFile* _tmp4_;
	GFile* medias_dir = NULL;
	GFile* _tmp5_;
	_tmp0_ = games_migrator_get_old_snapshots_dir_path ();
	snapshots_dir_path = _tmp0_;
	_tmp1_ = games_migrator_get_old_saves_dir_path ();
	saves_dir_path = _tmp1_;
	_tmp2_ = games_migrator_get_old_medias_dir_path ();
	medias_dir_path = _tmp2_;
	_tmp3_ = g_file_new_for_path (snapshots_dir_path);
	snapshots_dir = _tmp3_;
	_tmp4_ = g_file_new_for_path (saves_dir_path);
	saves_dir = _tmp4_;
	_tmp5_ = g_file_new_for_path (medias_dir_path);
	medias_dir = _tmp5_;
	games_migrator_delete_files_no_errors (snapshots_dir);
	games_migrator_delete_files_no_errors (saves_dir);
	games_migrator_delete_files_no_errors (medias_dir);
	_g_object_unref0 (medias_dir);
	_g_object_unref0 (saves_dir);
	_g_object_unref0 (snapshots_dir);
	_g_free0 (medias_dir_path);
	_g_free0 (saves_dir_path);
	_g_free0 (snapshots_dir_path);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_migrator_get_old_snapshots_dir_path (void)
{
	gchar* data_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/snapshots", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}

static gchar*
games_migrator_get_old_saves_dir_path (void)
{
	gchar* data_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/saves", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}

static gchar*
games_migrator_get_old_medias_dir_path (void)
{
	gchar* data_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/medias", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}

static gchar*
games_migrator_get_savestates_dir_path (void)
{
	gchar* data_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/savestates", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}

static void
games_migrator_delete_files_no_errors (GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	{
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (gchar*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		games_file_operations_delete_files (file, _tmp1_, (gint) 0, &_inner_error0_);
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = g_file_get_path (file);
		_tmp3_ = _tmp2_;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("migrator.vala:354: Cannot delete file %s: %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
games_migrator_try_restore_data (const gchar* backup_archive_path,
                                 const gchar* data_dir_path,
                                 gchar** backup_excluded_files,
                                 gint backup_excluded_files_length1)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (backup_archive_path != NULL, FALSE);
	g_return_val_if_fail (data_dir_path != NULL, FALSE);
	{
		games_file_operations_extract_archive (backup_archive_path, data_dir_path, backup_excluded_files, (gint) backup_excluded_files_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("migrator.vala:363: Failed to restore data from backup archive %s: %s", backup_archive_path, _tmp1_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = TRUE;
	return result;
}

GamesMigrator*
games_migrator_construct (GType object_type)
{
	GamesMigrator * self = NULL;
	self = (GamesMigrator*) g_object_new (object_type, NULL);
	return self;
}

GamesMigrator*
games_migrator_new (void)
{
	return games_migrator_construct (GAMES_TYPE_MIGRATOR);
}

static void
games_migrator_class_init (GamesMigratorClass * klass,
                           gpointer klass_data)
{
	games_migrator_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_migrator_finalize;
}

static void
games_migrator_instance_init (GamesMigrator * self,
                              gpointer klass)
{
}

static void
games_migrator_finalize (GObject * obj)
{
	GamesMigrator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_MIGRATOR, GamesMigrator);
	G_OBJECT_CLASS (games_migrator_parent_class)->finalize (obj);
}

static GType
games_migrator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesMigratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_migrator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesMigrator), 0, (GInstanceInitFunc) games_migrator_instance_init, NULL };
	GType games_migrator_type_id;
	games_migrator_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesMigrator", &g_define_type_info, 0);
	return games_migrator_type_id;
}

GType
games_migrator_get_type (void)
{
	static volatile gsize games_migrator_type_id__once = 0;
	if (g_once_init_enter (&games_migrator_type_id__once)) {
		GType games_migrator_type_id;
		games_migrator_type_id = games_migrator_get_type_once ();
		g_once_init_leave (&games_migrator_type_id__once, games_migrator_type_id);
	}
	return games_migrator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

