/* game-thumbnail.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-thumbnail.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include "gnome-games.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"

#define GAMES_GAME_THUMBNAIL_EMBLEM_SCALE 0.125
#define GAMES_GAME_THUMBNAIL_ICON_SCALE 0.75
#define GAMES_GAME_THUMBNAIL_EMBLEM_MIN_SIZE ((gdouble) 16)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_GAME_THUMBNAIL (games_game_thumbnail_get_type ())
#define GAMES_GAME_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail))
#define GAMES_GAME_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnailClass))
#define GAMES_IS_GAME_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_THUMBNAIL))
#define GAMES_IS_GAME_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_THUMBNAIL))
#define GAMES_GAME_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnailClass))

typedef struct _GamesGameThumbnail GamesGameThumbnail;
typedef struct _GamesGameThumbnailClass GamesGameThumbnailClass;
typedef struct _GamesGameThumbnailPrivate GamesGameThumbnailPrivate;
enum  {
	GAMES_GAME_THUMBNAIL_0_PROPERTY,
	GAMES_GAME_THUMBNAIL_GAME_PROPERTY,
	GAMES_GAME_THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* games_game_thumbnail_properties[GAMES_GAME_THUMBNAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_GAME_THUMBNAIL_TYPE_DRAWING_CONTEXT (games_game_thumbnail_drawing_context_get_type ())
typedef struct _GamesGameThumbnailDrawingContext GamesGameThumbnailDrawingContext;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesGameThumbnail {
	GtkDrawingArea parent_instance;
	GamesGameThumbnailPrivate * priv;
};

struct _GamesGameThumbnailClass {
	GtkDrawingAreaClass parent_class;
};

struct _GamesGameThumbnailPrivate {
	gulong cover_changed_id;
	GamesIcon* icon;
	GamesCover* cover;
	GamesGame* _game;
	GdkPixbuf* cover_pixbuf;
	GdkPixbuf* icon_pixbuf;
	gboolean try_load_cover;
	gint last_scale_factor;
	gint last_cover_size;
};

struct _GamesGameThumbnailDrawingContext {
	cairo_t* cr;
	GtkStyleContext* style;
	GtkStateFlags state;
	gint width;
	gint height;
};

static gint GamesGameThumbnail_private_offset;
static gpointer games_game_thumbnail_parent_class = NULL;

VALA_EXTERN GType games_game_thumbnail_get_type (void) G_GNUC_CONST ;
static GtkSizeRequestMode games_game_thumbnail_real_get_request_mode (GtkWidget* base);
static void games_game_thumbnail_real_get_preferred_height_for_width (GtkWidget* base,
                                                               gint width,
                                                               gint* minimum_height,
                                                               gint* natural_height);
static void games_game_thumbnail_real_size_allocate (GtkWidget* base,
                                              GtkAllocation* alloc);
static gboolean games_game_thumbnail_real_draw (GtkWidget* base,
                                         cairo_t* cr);
VALA_EXTERN GType games_game_thumbnail_drawing_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGameThumbnailDrawingContext* games_game_thumbnail_drawing_context_dup (const GamesGameThumbnailDrawingContext* self);
VALA_EXTERN void games_game_thumbnail_drawing_context_free (GamesGameThumbnailDrawingContext* self);
VALA_EXTERN void games_game_thumbnail_drawing_context_copy (const GamesGameThumbnailDrawingContext* self,
                                                GamesGameThumbnailDrawingContext* dest);
VALA_EXTERN void games_game_thumbnail_drawing_context_destroy (GamesGameThumbnailDrawingContext* self);
VALA_EXTERN void games_game_thumbnail_draw_image (GamesGameThumbnail* self,
                                      GamesGameThumbnailDrawingContext* context);
static void games_game_thumbnail_update_style_classes (GamesGameThumbnail* self);
static void games_game_thumbnail_get_icon_and_cover (GamesGameThumbnail* self,
                                              GamesGameThumbnailDrawingContext* context,
                                              GdkPixbuf** cover,
                                              GdkPixbuf** icon);
static void games_game_thumbnail_draw_pixbuf (GamesGameThumbnail* self,
                                       GamesGameThumbnailDrawingContext* context,
                                       GdkPixbuf* pixbuf);
static GdkPixbuf* games_game_thumbnail_get_emblem (GamesGameThumbnail* self,
                                            GamesGameThumbnailDrawingContext* context);
VALA_EXTERN GamesApplication* games_application_get_default (void);
VALA_EXTERN GamesCoverLoader* games_application_get_cover_loader (GamesApplication* self);
VALA_EXTERN GamesGame* games_game_thumbnail_get_game (GamesGameThumbnail* self);
static void __lambda20_ (GamesGameThumbnail* self,
                  gint scale_factor,
                  gint cover_size,
                  GdkPixbuf* cover_pixbuf,
                  gint icon_size,
                  GdkPixbuf* icon_pixbuf);
static void ___lambda20__games_cover_loader_cover_ready_callback (gint scale_factor,
                                                           gint cover_size,
                                                           GdkPixbuf* cover_pixbuf,
                                                           gint icon_size,
                                                           GdkPixbuf* icon_pixbuf,
                                                           gpointer self);
static void games_game_thumbnail_rounded_rectangle (GamesGameThumbnail* self,
                                             cairo_t* cr,
                                             gdouble x,
                                             gdouble y,
                                             gdouble width,
                                             gdouble height,
                                             gdouble radius);
VALA_EXTERN GamesGameThumbnail* games_game_thumbnail_new (void);
VALA_EXTERN GamesGameThumbnail* games_game_thumbnail_construct (GType object_type);
VALA_EXTERN void games_game_thumbnail_set_game (GamesGameThumbnail* self,
                                    GamesGame* value);
static void _games_game_thumbnail_game____lambda19_ (GamesGameThumbnail* self);
static void __games_game_thumbnail_game____lambda19__games_cover_changed (GamesCover* _sender,
                                                                   gpointer self);
static GObject * games_game_thumbnail_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void games_game_thumbnail_finalize (GObject * obj);
static GType games_game_thumbnail_get_type_once (void);
static void _vala_games_game_thumbnail_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_game_thumbnail_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_game_thumbnail_get_instance_private (GamesGameThumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGameThumbnail_private_offset);
}

static GtkSizeRequestMode
games_game_thumbnail_real_get_request_mode (GtkWidget* base)
{
	GamesGameThumbnail * self;
	GtkSizeRequestMode result;
	self = (GamesGameThumbnail*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static void
games_game_thumbnail_real_get_preferred_height_for_width (GtkWidget* base,
                                                          gint width,
                                                          gint* minimum_height,
                                                          gint* natural_height)
{
	GamesGameThumbnail * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	self = (GamesGameThumbnail*) base;
	_vala_natural_height = width;
	_vala_minimum_height = _vala_natural_height;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_game_thumbnail_real_size_allocate (GtkWidget* base,
                                         GtkAllocation* alloc)
{
	GamesGameThumbnail * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GdkRectangle clip = {0};
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GtkAllocation _tmp5_;
	GdkRectangle _tmp6_ = {0};
	GtkAllocation _tmp7_;
	GdkRectangle _tmp8_;
	self = (GamesGameThumbnail*) base;
	g_return_if_fail (alloc != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = *alloc;
	_tmp3_ = *alloc;
	_tmp4_ = *alloc;
	_tmp5_ = *alloc;
	gtk_render_background_get_clip (context, (gdouble) _tmp2_.x, (gdouble) _tmp3_.y, (gdouble) _tmp4_.width, (gdouble) _tmp5_.height, &_tmp6_);
	clip = _tmp6_;
	_tmp7_ = *alloc;
	GTK_WIDGET_CLASS (games_game_thumbnail_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), &_tmp7_);
	_tmp8_ = clip;
	gtk_widget_set_clip ((GtkWidget*) self, &_tmp8_);
	_g_object_unref0 (context);
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static gboolean
games_game_thumbnail_real_draw (GtkWidget* base,
                                cairo_t* cr)
{
	GamesGameThumbnail * self;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStateFlags state = 0U;
	gint width = 0;
	gint height = 0;
	GamesGameThumbnailDrawingContext context = {0};
	cairo_t* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GamesGameThumbnailDrawingContext _tmp5_ = {0};
	GamesIcon* _tmp6_;
	GamesCover* _tmp7_;
	GamesGameThumbnailDrawingContext _tmp8_;
	GtkStyleContext* _tmp9_;
	GamesGameThumbnailDrawingContext _tmp10_;
	GtkStyleContext* _tmp11_;
	GamesGameThumbnailDrawingContext _tmp12_;
	gboolean result;
	self = (GamesGameThumbnail*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style = _tmp1_;
	state = gtk_widget_get_state_flags ((GtkWidget*) self);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = _cairo_reference0 (cr);
	_tmp3_ = style;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_cairo_destroy0 (_tmp5_.cr);
	_tmp5_.cr = _tmp2_;
	_g_object_unref0 (_tmp5_.style);
	_tmp5_.style = _tmp4_;
	_tmp5_.state = state;
	_tmp5_.width = width;
	_tmp5_.height = height;
	context = _tmp5_;
	_tmp6_ = self->priv->icon;
	if (_tmp6_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		games_game_thumbnail_drawing_context_destroy (&context);
		_g_object_unref0 (style);
		return result;
	}
	_tmp7_ = self->priv->cover;
	if (_tmp7_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		games_game_thumbnail_drawing_context_destroy (&context);
		_g_object_unref0 (style);
		return result;
	}
	_tmp8_ = context;
	_tmp9_ = _tmp8_.style;
	gtk_render_background (_tmp9_, cr, 0.0, 0.0, (gdouble) width, (gdouble) height);
	_tmp10_ = context;
	_tmp11_ = _tmp10_.style;
	gtk_render_frame (_tmp11_, cr, 0.0, 0.0, (gdouble) width, (gdouble) height);
	_tmp12_ = context;
	games_game_thumbnail_draw_image (self, &_tmp12_);
	result = GDK_EVENT_PROPAGATE;
	games_game_thumbnail_drawing_context_destroy (&context);
	_g_object_unref0 (style);
	return result;
}

static void
games_game_thumbnail_update_style_classes (GamesGameThumbnail* self)
{
	GdkPixbuf* _tmp0_;
	gboolean _tmp3_ = FALSE;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cover_pixbuf;
	if (_tmp0_ != NULL) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp1_, "cover");
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp2_, "cover");
	}
	_tmp4_ = self->priv->icon_pixbuf;
	if (_tmp4_ != NULL) {
		GdkPixbuf* _tmp5_;
		_tmp5_ = self->priv->cover_pixbuf;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkStyleContext* _tmp6_;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp6_, "icon");
	} else {
		GtkStyleContext* _tmp7_;
		_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp7_, "icon");
	}
}

void
games_game_thumbnail_draw_image (GamesGameThumbnail* self,
                                 GamesGameThumbnailDrawingContext* context)
{
	GdkPixbuf* cover = NULL;
	GdkPixbuf* icon = NULL;
	GamesGameThumbnailDrawingContext _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* emblem = NULL;
	GamesGameThumbnailDrawingContext _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = *context;
	games_game_thumbnail_get_icon_and_cover (self, &_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (cover);
	cover = _tmp1_;
	_g_object_unref0 (icon);
	icon = _tmp2_;
	_tmp3_ = cover;
	if (_tmp3_ != NULL) {
		GamesGameThumbnailDrawingContext _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = *context;
		_tmp5_ = cover;
		games_game_thumbnail_draw_pixbuf (self, &_tmp4_, _tmp5_);
		_g_object_unref0 (icon);
		_g_object_unref0 (cover);
		return;
	}
	_tmp6_ = icon;
	if (_tmp6_ != NULL) {
		GamesGameThumbnailDrawingContext _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp7_ = *context;
		_tmp8_ = icon;
		games_game_thumbnail_draw_pixbuf (self, &_tmp7_, _tmp8_);
		_g_object_unref0 (icon);
		_g_object_unref0 (cover);
		return;
	}
	_tmp9_ = *context;
	_tmp10_ = games_game_thumbnail_get_emblem (self, &_tmp9_);
	emblem = _tmp10_;
	_tmp11_ = emblem;
	if (_tmp11_ != NULL) {
		GamesGameThumbnailDrawingContext _tmp12_;
		GdkPixbuf* _tmp13_;
		_tmp12_ = *context;
		_tmp13_ = emblem;
		games_game_thumbnail_draw_pixbuf (self, &_tmp12_, _tmp13_);
	}
	_g_object_unref0 (emblem);
	_g_object_unref0 (icon);
	_g_object_unref0 (cover);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static GdkPixbuf*
games_game_thumbnail_get_emblem (GamesGameThumbnail* self,
                                 GamesGameThumbnailDrawingContext* context)
{
	gchar* icon_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GdkPixbuf* emblem = NULL;
	GdkRGBA color = {0};
	GamesGameThumbnailDrawingContext _tmp2_;
	GtkStyleContext* _tmp3_;
	GamesGameThumbnailDrawingContext _tmp4_;
	GdkRGBA _tmp5_ = {0};
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp6_;
	GtkIconTheme* _tmp7_;
	gdouble size = 0.0;
	GamesGameThumbnailDrawingContext _tmp8_;
	GamesGameThumbnailDrawingContext _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = string_to_string (APPLICATION_ID);
	_tmp1_ = g_strconcat (_tmp0_, "-symbolic", NULL);
	icon_name = _tmp1_;
	emblem = NULL;
	_tmp2_ = *context;
	_tmp3_ = _tmp2_.style;
	_tmp4_ = *context;
	gtk_style_context_get_color (_tmp3_, _tmp4_.state, &_tmp5_);
	color = _tmp5_;
	_tmp6_ = gtk_icon_theme_get_default ();
	_tmp7_ = _g_object_ref0 (_tmp6_);
	theme = _tmp7_;
	_tmp8_ = *context;
	_tmp9_ = *context;
	_tmp10_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp11_ = _tmp10_;
	size = (MIN (_tmp8_.width, _tmp9_.height) * GAMES_GAME_THUMBNAIL_EMBLEM_SCALE) * _tmp11_;
	_tmp12_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp13_ = _tmp12_;
	size = MAX (size, GAMES_GAME_THUMBNAIL_EMBLEM_MIN_SIZE * _tmp13_);
	{
		GtkIconInfo* icon_info = NULL;
		GtkIconInfo* _tmp14_;
		GdkPixbuf* _tmp15_ = NULL;
		GdkRGBA _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		_tmp14_ = gtk_icon_theme_lookup_icon (theme, icon_name, (gint) size, GTK_ICON_LOOKUP_FORCE_SIZE);
		icon_info = _tmp14_;
		_tmp16_ = color;
		_tmp17_ = gtk_icon_info_load_symbolic (icon_info, &_tmp16_, NULL, NULL, NULL, NULL, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (icon_info);
			goto __catch0_g_error;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (emblem);
		emblem = _tmp18_;
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (icon_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = string_to_string (icon_name);
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("Unable to get icon “", _tmp19_, "”: ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		g_warning ("game-thumbnail.vala:154: %s", _tmp24_);
		_g_free0 (_tmp24_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (theme);
		_g_object_unref0 (emblem);
		_g_free0 (icon_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = emblem;
	_g_object_unref0 (theme);
	_g_free0 (icon_name);
	return result;
}

static void
__lambda20_ (GamesGameThumbnail* self,
             gint scale_factor,
             gint cover_size,
             GdkPixbuf* cover_pixbuf,
             gint icon_size,
             GdkPixbuf* icon_pixbuf)
{
	gboolean _tmp0_ = FALSE;
	if (scale_factor != self->priv->last_scale_factor) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = cover_size != self->priv->last_cover_size;
	}
	if (_tmp0_) {
		_g_object_unref0 (self->priv->cover_pixbuf);
		self->priv->cover_pixbuf = NULL;
		_g_object_unref0 (self->priv->icon_pixbuf);
		self->priv->icon_pixbuf = NULL;
		self->priv->try_load_cover = TRUE;
	} else {
		if (cover_pixbuf != NULL) {
			GdkPixbuf* _tmp1_;
			_tmp1_ = _g_object_ref0 (cover_pixbuf);
			_g_object_unref0 (self->priv->cover_pixbuf);
			self->priv->cover_pixbuf = _tmp1_;
		}
		if (icon_pixbuf != NULL) {
			GdkPixbuf* _tmp2_;
			_tmp2_ = _g_object_ref0 (icon_pixbuf);
			_g_object_unref0 (self->priv->icon_pixbuf);
			self->priv->icon_pixbuf = _tmp2_;
		}
	}
	games_game_thumbnail_update_style_classes (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda20__games_cover_loader_cover_ready_callback (gint scale_factor,
                                                      gint cover_size,
                                                      GdkPixbuf* cover_pixbuf,
                                                      gint icon_size,
                                                      GdkPixbuf* icon_pixbuf,
                                                      gpointer self)
{
	__lambda20_ ((GamesGameThumbnail*) self, scale_factor, cover_size, cover_pixbuf, icon_size, icon_pixbuf);
}

static void
games_game_thumbnail_get_icon_and_cover (GamesGameThumbnail* self,
                                         GamesGameThumbnailDrawingContext* context,
                                         GdkPixbuf** cover,
                                         GdkPixbuf** icon)
{
	GdkPixbuf* _vala_cover = NULL;
	GdkPixbuf* _vala_icon = NULL;
	gint cover_size = 0;
	GamesGameThumbnailDrawingContext _tmp0_;
	GamesGameThumbnailDrawingContext _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint icon_size = 0;
	gboolean _tmp4_ = FALSE;
	GamesCoverLoader* loader = NULL;
	GamesApplication* _tmp11_;
	GamesApplication* _tmp12_;
	GamesCoverLoader* _tmp13_;
	GamesCoverLoader* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GamesCoverLoader* _tmp17_;
	GamesGame* _tmp18_;
	GamesGame* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GdkPixbuf* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = *context;
	_tmp1_ = *context;
	_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	cover_size = MIN (_tmp0_.width, _tmp1_.height) * _tmp3_;
	icon_size = (gint) (cover_size * GAMES_GAME_THUMBNAIL_ICON_SCALE);
	if (cover_size != self->priv->last_cover_size) {
		_tmp4_ = TRUE;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
		_tmp6_ = _tmp5_;
		_tmp4_ = _tmp6_ != self->priv->last_scale_factor;
	}
	if (_tmp4_) {
		_g_object_unref0 (self->priv->cover_pixbuf);
		self->priv->cover_pixbuf = NULL;
		_g_object_unref0 (self->priv->icon_pixbuf);
		self->priv->icon_pixbuf = NULL;
		games_game_thumbnail_update_style_classes (self);
		self->priv->try_load_cover = TRUE;
	}
	if (!self->priv->try_load_cover) {
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp7_ = self->priv->cover_pixbuf;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_vala_cover);
		_vala_cover = _tmp8_;
		_tmp9_ = self->priv->icon_pixbuf;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (_vala_icon);
		_vala_icon = _tmp10_;
		if (cover) {
			*cover = _vala_cover;
		} else {
			_g_object_unref0 (_vala_cover);
		}
		if (icon) {
			*icon = _vala_icon;
		} else {
			_g_object_unref0 (_vala_icon);
		}
		return;
	}
	_tmp11_ = games_application_get_default ();
	_tmp12_ = _tmp11_;
	_tmp13_ = games_application_get_cover_loader (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	loader = _tmp14_;
	self->priv->last_cover_size = cover_size;
	_tmp15_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp16_ = _tmp15_;
	self->priv->last_scale_factor = _tmp16_;
	self->priv->try_load_cover = FALSE;
	_tmp17_ = loader;
	_tmp18_ = games_game_thumbnail_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp21_ = _tmp20_;
	games_cover_loader_fetch_cover (_tmp17_, _tmp19_, _tmp21_, cover_size, icon_size, ___lambda20__games_cover_loader_cover_ready_callback, self);
	_tmp22_ = self->priv->cover_pixbuf;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (_vala_cover);
	_vala_cover = _tmp23_;
	_tmp24_ = self->priv->icon_pixbuf;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (_vala_icon);
	_vala_icon = _tmp25_;
	_g_object_unref0 (loader);
	if (cover) {
		*cover = _vala_cover;
	} else {
		_g_object_unref0 (_vala_cover);
	}
	if (icon) {
		*icon = _vala_icon;
	} else {
		_g_object_unref0 (_vala_icon);
	}
}

static void
games_game_thumbnail_draw_pixbuf (GamesGameThumbnail* self,
                                  GamesGameThumbnailDrawingContext* context,
                                  GdkPixbuf* pixbuf)
{
	GamesGameThumbnailDrawingContext _tmp0_;
	cairo_t* _tmp1_;
	gint border_radius = 0;
	GamesGameThumbnailDrawingContext _tmp2_;
	GtkStyleContext* _tmp3_;
	GamesGameThumbnailDrawingContext _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp6_;
	gint _tmp7_;
	GamesGameThumbnailDrawingContext _tmp8_;
	GamesGameThumbnailDrawingContext _tmp9_;
	GamesGameThumbnailDrawingContext _tmp10_;
	cairo_t* _tmp11_;
	GamesGameThumbnailDrawingContext _tmp12_;
	GamesGameThumbnailDrawingContext _tmp13_;
	GamesGameThumbnailDrawingContext _tmp14_;
	cairo_t* _tmp15_;
	gint x_offset = 0;
	GamesGameThumbnailDrawingContext _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint y_offset = 0;
	GamesGameThumbnailDrawingContext _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GamesGameThumbnailDrawingContext _tmp26_;
	cairo_t* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GamesGameThumbnailDrawingContext _tmp32_;
	cairo_t* _tmp33_;
	GamesGameThumbnailDrawingContext _tmp34_;
	cairo_t* _tmp35_;
	GamesGameThumbnailDrawingContext _tmp36_;
	cairo_t* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = *context;
	_tmp1_ = _tmp0_.cr;
	cairo_save (_tmp1_);
	_tmp2_ = *context;
	_tmp3_ = _tmp2_.style;
	_tmp4_ = *context;
	gtk_style_context_get_property (_tmp3_, GTK_STYLE_PROPERTY_BORDER_RADIUS, _tmp4_.state, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_value_get_int (&_tmp5_);
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	border_radius = _tmp7_;
	_tmp8_ = *context;
	_tmp9_ = *context;
	border_radius = CLAMP (border_radius, 0, MAX (_tmp8_.width / 2, _tmp9_.height / 2));
	_tmp10_ = *context;
	_tmp11_ = _tmp10_.cr;
	_tmp12_ = *context;
	_tmp13_ = *context;
	games_game_thumbnail_rounded_rectangle (self, _tmp11_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp12_.width, (gdouble) _tmp13_.height, (gdouble) border_radius);
	_tmp14_ = *context;
	_tmp15_ = _tmp14_.cr;
	cairo_clip (_tmp15_);
	_tmp16_ = *context;
	_tmp17_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = gdk_pixbuf_get_width (pixbuf);
	_tmp20_ = _tmp19_;
	x_offset = ((_tmp16_.width * _tmp18_) - _tmp20_) / 2;
	_tmp21_ = *context;
	_tmp22_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = gdk_pixbuf_get_height (pixbuf);
	_tmp25_ = _tmp24_;
	y_offset = ((_tmp21_.height * _tmp23_) - _tmp25_) / 2;
	_tmp26_ = *context;
	_tmp27_ = _tmp26_.cr;
	_tmp28_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp31_ = _tmp30_;
	cairo_scale (_tmp27_, 1.0 / _tmp29_, 1.0 / _tmp31_);
	_tmp32_ = *context;
	_tmp33_ = _tmp32_.cr;
	gdk_cairo_set_source_pixbuf (_tmp33_, pixbuf, (gdouble) x_offset, (gdouble) y_offset);
	_tmp34_ = *context;
	_tmp35_ = _tmp34_.cr;
	cairo_paint (_tmp35_);
	_tmp36_ = *context;
	_tmp37_ = _tmp36_.cr;
	cairo_restore (_tmp37_);
}

static void
games_game_thumbnail_rounded_rectangle (GamesGameThumbnail* self,
                                        cairo_t* cr,
                                        gdouble x,
                                        gdouble y,
                                        gdouble width,
                                        gdouble height,
                                        gdouble radius)
{
	static const gdouble ARC_0 = (gdouble) 0;
	static const gdouble ARC_1 = G_PI * 0.5;
	static const gdouble ARC_2 = G_PI;
	static const gdouble ARC_3 = G_PI * 1.5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_new_sub_path (cr);
	cairo_arc (cr, (x + width) - radius, y + radius, radius, ARC_3, ARC_0);
	cairo_arc (cr, (x + width) - radius, (y + height) - radius, radius, ARC_0, ARC_1);
	cairo_arc (cr, x + radius, (y + height) - radius, radius, ARC_1, ARC_2);
	cairo_arc (cr, x + radius, y + radius, radius, ARC_2, ARC_3);
	cairo_close_path (cr);
}

GamesGameThumbnail*
games_game_thumbnail_construct (GType object_type)
{
	GamesGameThumbnail * self = NULL;
	self = (GamesGameThumbnail*) g_object_new (object_type, NULL);
	return self;
}

GamesGameThumbnail*
games_game_thumbnail_new (void)
{
	return games_game_thumbnail_construct (GAMES_TYPE_GAME_THUMBNAIL);
}

GamesGame*
games_game_thumbnail_get_game (GamesGameThumbnail* self)
{
	GamesGame* result;
	GamesGame* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static void
_games_game_thumbnail_game____lambda19_ (GamesGameThumbnail* self)
{
	self->priv->try_load_cover = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
__games_game_thumbnail_game____lambda19__games_cover_changed (GamesCover* _sender,
                                                              gpointer self)
{
	_games_game_thumbnail_game____lambda19_ ((GamesGameThumbnail*) self);
}

void
games_game_thumbnail_set_game (GamesGameThumbnail* self,
                               GamesGame* value)
{
	GamesGame* _tmp0_;
	GamesCover* _tmp1_;
	GamesGame* _tmp3_;
	GamesGame* _tmp4_;
	GamesGame* _tmp5_;
	GamesIcon* _tmp6_;
	GamesGame* _tmp7_;
	GamesGame* _tmp8_;
	GamesCover* _tmp9_;
	GamesCover* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ == value) {
		return;
	}
	_tmp1_ = self->priv->cover;
	if (_tmp1_ != NULL) {
		GamesCover* _tmp2_;
		_tmp2_ = self->priv->cover;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->cover_changed_id);
	}
	_tmp3_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = games_game_thumbnail_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_game_get_icon (_tmp5_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp6_;
	_tmp7_ = games_game_thumbnail_get_game (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = games_game_get_cover (_tmp8_);
	_g_object_unref0 (self->priv->cover);
	self->priv->cover = _tmp9_;
	self->priv->try_load_cover = TRUE;
	_tmp10_ = self->priv->cover;
	if (_tmp10_ != NULL) {
		GamesCover* _tmp11_;
		gulong _tmp12_;
		_tmp11_ = self->priv->cover;
		_tmp12_ = g_signal_connect_object (_tmp11_, "changed", (GCallback) __games_game_thumbnail_game____lambda19__games_cover_changed, self, 0);
		self->priv->cover_changed_id = _tmp12_;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, games_game_thumbnail_properties[GAMES_GAME_THUMBNAIL_GAME_PROPERTY]);
}

void
games_game_thumbnail_drawing_context_copy (const GamesGameThumbnailDrawingContext* self,
                                           GamesGameThumbnailDrawingContext* dest)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	_tmp0_ = (*self).cr;
	_tmp1_ = _cairo_reference0 (_tmp0_);
	_cairo_destroy0 ((*dest).cr);
	(*dest).cr = _tmp1_;
	_tmp2_ = (*self).style;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).style);
	(*dest).style = _tmp3_;
	(*dest).state = (*self).state;
	(*dest).width = (*self).width;
	(*dest).height = (*self).height;
}

void
games_game_thumbnail_drawing_context_destroy (GamesGameThumbnailDrawingContext* self)
{
	_cairo_destroy0 ((*self).cr);
	_g_object_unref0 ((*self).style);
}

GamesGameThumbnailDrawingContext*
games_game_thumbnail_drawing_context_dup (const GamesGameThumbnailDrawingContext* self)
{
	GamesGameThumbnailDrawingContext* dup;
	dup = g_new0 (GamesGameThumbnailDrawingContext, 1);
	games_game_thumbnail_drawing_context_copy (self, dup);
	return dup;
}

void
games_game_thumbnail_drawing_context_free (GamesGameThumbnailDrawingContext* self)
{
	games_game_thumbnail_drawing_context_destroy (self);
	g_free (self);
}

static GType
games_game_thumbnail_drawing_context_get_type_once (void)
{
	GType games_game_thumbnail_drawing_context_type_id;
	games_game_thumbnail_drawing_context_type_id = g_boxed_type_register_static ("GamesGameThumbnailDrawingContext", (GBoxedCopyFunc) games_game_thumbnail_drawing_context_dup, (GBoxedFreeFunc) games_game_thumbnail_drawing_context_free);
	return games_game_thumbnail_drawing_context_type_id;
}

GType
games_game_thumbnail_drawing_context_get_type (void)
{
	static volatile gsize games_game_thumbnail_drawing_context_type_id__once = 0;
	if (g_once_init_enter (&games_game_thumbnail_drawing_context_type_id__once)) {
		GType games_game_thumbnail_drawing_context_type_id;
		games_game_thumbnail_drawing_context_type_id = games_game_thumbnail_drawing_context_get_type_once ();
		g_once_init_leave (&games_game_thumbnail_drawing_context_type_id__once, games_game_thumbnail_drawing_context_type_id);
	}
	return games_game_thumbnail_drawing_context_type_id__once;
}

static GObject *
games_game_thumbnail_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesGameThumbnail * self;
	parent_class = G_OBJECT_CLASS (games_game_thumbnail_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	self->priv->try_load_cover = TRUE;
	return obj;
}

static void
games_game_thumbnail_class_init (GamesGameThumbnailClass * klass,
                                 gpointer klass_data)
{
	games_game_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGameThumbnail_private_offset);
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) games_game_thumbnail_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) games_game_thumbnail_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) games_game_thumbnail_real_size_allocate;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) games_game_thumbnail_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_game_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_game_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_game_thumbnail_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_game_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_THUMBNAIL_GAME_PROPERTY, games_game_thumbnail_properties[GAMES_GAME_THUMBNAIL_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", GAMES_TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "gamesgamethumbnail");
}

static void
games_game_thumbnail_instance_init (GamesGameThumbnail * self,
                                    gpointer klass)
{
	self->priv = games_game_thumbnail_get_instance_private (self);
}

static void
games_game_thumbnail_finalize (GObject * obj)
{
	GamesGameThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->cover);
	_g_object_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->cover_pixbuf);
	_g_object_unref0 (self->priv->icon_pixbuf);
	G_OBJECT_CLASS (games_game_thumbnail_parent_class)->finalize (obj);
}

static GType
games_game_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGameThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_game_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGameThumbnail), 0, (GInstanceInitFunc) games_game_thumbnail_instance_init, NULL };
	GType games_game_thumbnail_type_id;
	games_game_thumbnail_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GamesGameThumbnail", &g_define_type_info, 0);
	GamesGameThumbnail_private_offset = g_type_add_instance_private (games_game_thumbnail_type_id, sizeof (GamesGameThumbnailPrivate));
	return games_game_thumbnail_type_id;
}

GType
games_game_thumbnail_get_type (void)
{
	static volatile gsize games_game_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&games_game_thumbnail_type_id__once)) {
		GType games_game_thumbnail_type_id;
		games_game_thumbnail_type_id = games_game_thumbnail_get_type_once ();
		g_once_init_leave (&games_game_thumbnail_type_id__once, games_game_thumbnail_type_id);
	}
	return games_game_thumbnail_type_id__once;
}

static void
_vala_games_game_thumbnail_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesGameThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	switch (property_id) {
		case GAMES_GAME_THUMBNAIL_GAME_PROPERTY:
		g_value_set_object (value, games_game_thumbnail_get_game (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_game_thumbnail_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesGameThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	switch (property_id) {
		case GAMES_GAME_THUMBNAIL_GAME_PROPERTY:
		games_game_thumbnail_set_game (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

