/* grep.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from grep.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <errno.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

static void _vala_array_add47 (gsize* * array,
                        gint* length,
                        gint* size,
                        gsize value);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
_vala_array_add47 (gsize* * array,
                   gint* length,
                   gint* size,
                   gsize value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gsize, *array, *size);
	}
	(*array)[(*length)++] = value;
}

gsize*
games_grep_get_offsets (const gchar* filename,
                        const gchar* text,
                        gint* result_length1)
{
	gchar* working_dir = NULL;
	gchar* _tmp0_;
	gchar** args = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint args_length1;
	gint _args_size_;
	gchar** env = NULL;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint env_length1;
	gint _env_size_;
	gboolean success = FALSE;
	gchar* output = NULL;
	gsize* offsets = NULL;
	gsize* _tmp21_;
	gint offsets_length1;
	gint _offsets_size_;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gsize* _tmp36_;
	gint _tmp36__length1;
	GError* _inner_error0_ = NULL;
	gsize* result;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_get_current_dir ();
	working_dir = _tmp0_;
	_tmp1_ = g_strdup ("grep");
	_tmp2_ = g_strdup ("--byte-offset");
	_tmp3_ = g_strdup ("--only-matching");
	_tmp4_ = g_strdup ("--text");
	_tmp5_ = g_strdup (text);
	_tmp6_ = g_strdup ("--");
	_tmp7_ = g_strdup (filename);
	_tmp8_ = g_new0 (gchar*, 7 + 1);
	_tmp8_[0] = _tmp1_;
	_tmp8_[1] = _tmp2_;
	_tmp8_[2] = _tmp3_;
	_tmp8_[3] = _tmp4_;
	_tmp8_[4] = _tmp5_;
	_tmp8_[5] = _tmp6_;
	_tmp8_[6] = _tmp7_;
	args = _tmp8_;
	args_length1 = 7;
	_args_size_ = args_length1;
	_tmp10_ = _tmp9_ = g_get_environ ();
	env = _tmp10_;
	env_length1 = _vala_array_length (_tmp9_);
	_env_size_ = env_length1;
	success = FALSE;
	{
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_ = NULL;
		gboolean _tmp16_;
		_tmp12_ = working_dir;
		_tmp13_ = args;
		_tmp13__length1 = args_length1;
		_tmp14_ = env;
		_tmp14__length1 = env_length1;
		_tmp16_ = g_spawn_sync (_tmp12_, _tmp13_, _tmp14_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp15_, NULL, NULL, &_inner_error0_);
		_g_free0 (output);
		output = _tmp15_;
		_tmp11_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (output);
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (working_dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		success = _tmp11_;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		gsize* _tmp17_;
		gsize* _tmp18_;
		gint _tmp18__length1;
		g_clear_error (&_inner_error0_);
		_tmp17_ = g_new0 (gsize, 0);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp18__length1;
		}
		result = _tmp18_;
		_g_free0 (output);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_dir);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (output);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (!success) {
		gsize* _tmp19_;
		gsize* _tmp20_;
		gint _tmp20__length1;
		_tmp19_ = g_new0 (gsize, 0);
		_tmp20_ = _tmp19_;
		_tmp20__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp20__length1;
		}
		result = _tmp20_;
		_g_free0 (output);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_dir);
		return result;
	}
	_tmp21_ = g_new0 (gsize, 0);
	offsets = _tmp21_;
	offsets_length1 = 0;
	_offsets_size_ = offsets_length1;
	_tmp22_ = output;
	_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp24_;
		line_collection_length1 = _vala_array_length (_tmp23_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp25_;
			gchar* line = NULL;
			_tmp25_ = g_strdup (line_collection[line_it]);
			line = _tmp25_;
			{
				gchar** splitted_line = NULL;
				const gchar* _tmp26_;
				gchar** _tmp27_;
				gchar** _tmp28_;
				gint splitted_line_length1;
				gint _splitted_line_size_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gchar** _tmp30_;
				gint _tmp30__length1;
				const gchar* _tmp31_;
				guint64 offset = 0ULL;
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
				guint64 _tmp34_ = 0ULL;
				gboolean _tmp35_;
				_tmp26_ = line;
				_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, ":", 0);
				splitted_line = _tmp28_;
				splitted_line_length1 = _vala_array_length (_tmp27_);
				_splitted_line_size_ = splitted_line_length1;
				_tmp29_ = splitted_line;
				_tmp29__length1 = splitted_line_length1;
				if (_tmp29__length1 != 2) {
					splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp30_ = splitted_line;
				_tmp30__length1 = splitted_line_length1;
				_tmp31_ = _tmp30_[1];
				if (g_strcmp0 (_tmp31_, text) != 0) {
					splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp32_ = splitted_line;
				_tmp32__length1 = splitted_line_length1;
				_tmp33_ = _tmp32_[0];
				_tmp35_ = uint64_try_parse (_tmp33_, &_tmp34_, NULL, (guint) 0);
				offset = _tmp34_;
				if (!_tmp35_) {
					splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_vala_array_add47 (&offsets, &offsets_length1, &_offsets_size_, (gsize) offset);
				splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp36_ = offsets;
	_tmp36__length1 = offsets_length1;
	if (result_length1) {
		*result_length1 = _tmp36__length1;
	}
	result = _tmp36_;
	_g_free0 (output);
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (working_dir);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

