/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt2_framemapper_cc = R"doc(Maps T2 frames.

Input: Cell and time interleaved QPSK, 16QAM, 64QAM or 256QAM modulated cells. 
Output: T2 frame.

Constructor Specific Documentation:

Create a DVB-T2 frame mapper.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-T2 constellation.
    rotation : DVB-T2 constellation rotation (on or off).
    fecblocks : number of FEC frames in a T2 frame.
    tiblocks : number of time interleaving blocks in a T2 frame.
    carriermode : number of carriers (normal or extended).
    fftsize : OFDM IFFT size.
    guardinterval : OFDM ISI guard interval.
    l1constellation : L1 constellation.
    pilotpattern : DVB-T2 pilot pattern (PP1 - PP8).
    t2frames : number of T2 frames in a super-frame.
    numdatasyms : number of OFDM symbols in a T2 frame.
    paprmode : PAPR reduction mode.
    version : DVB-T2 specification version.
    preamble : P1 symbol preamble format.
    inputmode : Baseband Header mode.
    reservedbiasbits : set all L1 bias bits to 1 (on or off).
    l1scrambled : scramble L1 post signalling (on or off).
    inband : In-band type B signalling (on or off).)doc";


static const char* __doc_gr_dtv_dvbt2_framemapper_cc_dvbt2_framemapper_cc = R"doc()doc";


static const char* __doc_gr_dtv_dvbt2_framemapper_cc_make = R"doc(Maps T2 frames.

Input: Cell and time interleaved QPSK, 16QAM, 64QAM or 256QAM modulated cells. 
Output: T2 frame.

Constructor Specific Documentation:

Create a DVB-T2 frame mapper.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-T2 constellation.
    rotation : DVB-T2 constellation rotation (on or off).
    fecblocks : number of FEC frames in a T2 frame.
    tiblocks : number of time interleaving blocks in a T2 frame.
    carriermode : number of carriers (normal or extended).
    fftsize : OFDM IFFT size.
    guardinterval : OFDM ISI guard interval.
    l1constellation : L1 constellation.
    pilotpattern : DVB-T2 pilot pattern (PP1 - PP8).
    t2frames : number of T2 frames in a super-frame.
    numdatasyms : number of OFDM symbols in a T2 frame.
    paprmode : PAPR reduction mode.
    version : DVB-T2 specification version.
    preamble : P1 symbol preamble format.
    inputmode : Baseband Header mode.
    reservedbiasbits : set all L1 bias bits to 1 (on or off).
    l1scrambled : scramble L1 post signalling (on or off).
    inband : In-band type B signalling (on or off).)doc";
