#ifndef SBK_KJOBTRACKERINTERFACEWRAPPER_H
#define SBK_KJOBTRACKERINTERFACEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kjobtrackerinterface.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KJobTrackerInterfaceWrapper : public KJobTrackerInterface
{
public:
    KJobTrackerInterfaceWrapper(::QObject * parent = nullptr);
    KJobTrackerInterfaceWrapper(const KJobTrackerInterfaceWrapper &) = delete;
    KJobTrackerInterfaceWrapper& operator=(const KJobTrackerInterfaceWrapper &) = delete;
    KJobTrackerInterfaceWrapper(KJobTrackerInterfaceWrapper &&) = delete;
    KJobTrackerInterfaceWrapper& operator=(KJobTrackerInterfaceWrapper &&) = delete;
    ~KJobTrackerInterfaceWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2) override;
    static void sbk_o_description(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void finished(::KJob * job) override;
    static void sbk_o_finished(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job);
    void infoMessage(::KJob * job, const ::QString & message) override;
    void percent(::KJob * job, unsigned long percent) override;
    static void sbk_o_percent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, unsigned long percent);
    void processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount) override;
    static void sbk_o_processedAmount(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, ::KJob::Unit unit, qulonglong amount);
    void registerJob(::KJob * job) override;
    void resumed(::KJob * job) override;
    void speed(::KJob * job, unsigned long value) override;
    void suspended(::KJob * job) override;
    void timerEvent(::QTimerEvent * event) override;
    void totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount) override;
    void unregisterJob(::KJob * job) override;
    void warning(::KJob * job, const ::QString & message) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 19> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KJOBTRACKERINTERFACEWRAPPER_H
