
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "knetworkmounts_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <knetworkmounts.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNetworkMounts_Type = nullptr;
static PyTypeObject *Sbk_KNetworkMounts_TypeF(void)
{
    return _Sbk_KNetworkMounts_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KNetworkMounts_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("KNetworkMounts");
    return -1;
}

static PyObject *Sbk_KNetworkMountsFunc_addPath(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addPath", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::addPath(QString,KNetworkMounts::KNetworkMountsType)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // addPath(QString,KNetworkMounts::KNetworkMountsType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addPath", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KNetworkMounts::KNetworkMountsType cppArg1{KNetworkMounts::NfsPaths};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addPath(QString,KNetworkMounts::KNetworkMountsType)
            cppSelf->addPath(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNetworkMountsFunc_canonicalSymlinkPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNetworkMounts::canonicalSymlinkPath(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // canonicalSymlinkPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "canonicalSymlinkPath", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // canonicalSymlinkPath(QString)
            QString cppResult = cppSelf->canonicalSymlinkPath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_clearCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearCache()
        cppSelf->clearCache();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNetworkMountsFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEnabled()const
        bool cppResult = const_cast<const ::KNetworkMounts *>(cppSelf)->isEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_isOptionEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "isOptionEnabled", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    if (PyArg_ParseTuple(args, "|OO:isOptionEnabled", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::isOptionEnabled(KNetworkMounts::KNetworkMountOption,bool=)const->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountOption_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isOptionEnabled(KNetworkMounts::KNetworkMountOption,bool)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // isOptionEnabled(KNetworkMounts::KNetworkMountOption,bool)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "isOptionEnabled", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "isOptionEnabled", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);
            }
        }
        ::KNetworkMounts::KNetworkMountOption cppArg0{KNetworkMounts::LowSideEffectsOptimizations};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isOptionEnabled(KNetworkMounts::KNetworkMountOption,bool)const
            bool cppResult = const_cast<const ::KNetworkMounts *>(cppSelf)->isOptionEnabled(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_isOptionEnabledForPath(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "isOptionEnabledForPath", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::isOptionEnabledForPath(QString,KNetworkMounts::KNetworkMountOption)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountOption_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // isOptionEnabledForPath(QString,KNetworkMounts::KNetworkMountOption)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "isOptionEnabledForPath", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KNetworkMounts::KNetworkMountOption cppArg1{KNetworkMounts::LowSideEffectsOptimizations};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isOptionEnabledForPath(QString,KNetworkMounts::KNetworkMountOption)
            bool cppResult = cppSelf->isOptionEnabledForPath(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_isSlowPath(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "isSlowPath", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    if (PyArg_ParseTuple(args, "|OO:isSlowPath", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::isSlowPath(QString,KNetworkMounts::KNetworkMountsType=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isSlowPath(QString,KNetworkMounts::KNetworkMountsType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // isSlowPath(QString,KNetworkMounts::KNetworkMountsType)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "isSlowPath", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"type", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))->converter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "isSlowPath", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KNetworkMounts::KNetworkMountsType cppArg1(KNetworkMounts::KNetworkMountsType::Any);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isSlowPath(QString,KNetworkMounts::KNetworkMountsType)
            bool cppResult = cppSelf->isSlowPath(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_paths(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "paths", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    if (PyArg_ParseTuple(args, "|O:paths", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::paths(KNetworkMounts::KNetworkMountsType=)const->QStringList
    if (numArgs == 0) {
        overloadId = 0; // paths(KNetworkMounts::KNetworkMountsType)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // paths(KNetworkMounts::KNetworkMountsType)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "paths", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"type", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))->converter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "paths", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);
            }
        }
        ::KNetworkMounts::KNetworkMountsType cppArg0(KNetworkMounts::KNetworkMountsType::Any);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paths(KNetworkMounts::KNetworkMountsType)const
            QStringList cppResult = const_cast<const ::KNetworkMounts *>(cppSelf)->paths(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_self(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // self()
        KNetworkMounts * cppResult = ::KNetworkMounts::self();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNetworkMountsFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNetworkMounts::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEnabled", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNetworkMountsFunc_setOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::setOption(KNetworkMounts::KNetworkMountOption,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountOption_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setOption(KNetworkMounts::KNetworkMountOption,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setOption", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        ::KNetworkMounts::KNetworkMountOption cppArg0{KNetworkMounts::LowSideEffectsOptimizations};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOption(KNetworkMounts::KNetworkMountOption,bool)
            cppSelf->setOption(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNetworkMountsFunc_setPaths(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setPaths", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNetworkMounts::setPaths(QStringList,KNetworkMounts::KNetworkMountsType)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // setPaths(QStringList,KNetworkMounts::KNetworkMountsType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setPaths", errInfo, SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KNetworkMounts::KNetworkMountsType cppArg1{KNetworkMounts::NfsPaths};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPaths(QStringList,KNetworkMounts::KNetworkMountsType)
            cppSelf->setPaths(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNetworkMountsFunc_sync(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNetworkMounts *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sync()
        cppSelf->sync();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KNetworkMounts_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KNetworkMounts_EnumFlagInfo[] = {
    "KNetworkMountOption:IntEnum",
    "KNetworkMountsType:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNetworkMounts_methods[] = {
    {"addPath", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_addPath), METH_VARARGS, nullptr},
    {"canonicalSymlinkPath", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_canonicalSymlinkPath), METH_O, nullptr},
    {"clearCache", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_clearCache), METH_NOARGS, nullptr},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_isEnabled), METH_NOARGS, nullptr},
    {"isOptionEnabled", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_isOptionEnabled), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"isOptionEnabledForPath", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_isOptionEnabledForPath), METH_VARARGS, nullptr},
    {"isSlowPath", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_isSlowPath), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"paths", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_paths), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"self", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_self), METH_NOARGS|METH_STATIC, nullptr},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_setEnabled), METH_O, nullptr},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_setOption), METH_VARARGS, nullptr},
    {"setPaths", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_setPaths), METH_VARARGS, nullptr},
    {"sync", reinterpret_cast<PyCFunction>(Sbk_KNetworkMountsFunc_sync), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNetworkMounts_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNetworkMounts_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNetworkMounts_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNetworkMounts_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNetworkMounts_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNetworkMounts_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNetworkMounts_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNetworkMounts_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNetworkMounts_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNetworkMounts_spec = {
    "1:KCoreAddons.KNetworkMounts",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNetworkMounts_slots
};

} //extern "C"

static void *Sbk_KNetworkMounts_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNetworkMounts *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KNetworkMounts_KNetworkMountOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNetworkMounts::KNetworkMountOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNetworkMounts::KNetworkMountOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNetworkMounts_KNetworkMountOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountOption_IDX])))
        return Enum_PythonToCpp_KNetworkMounts_KNetworkMountOption;
    return {};
}

static PyObject *KNetworkMounts_KNetworkMountOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNetworkMounts::KNetworkMountOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNetworkMounts::KNetworkMountOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KNetworkMounts_KNetworkMountsType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNetworkMounts::KNetworkMountsType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNetworkMounts::KNetworkMountsType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNetworkMounts_KNetworkMountsType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX])))
        return Enum_PythonToCpp_KNetworkMounts_KNetworkMountsType;
    return {};
}

static PyObject *KNetworkMounts_KNetworkMountsType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNetworkMounts::KNetworkMountsType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNetworkMounts::KNetworkMountsType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNetworkMounts_PythonToCpp_KNetworkMounts_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNetworkMounts_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNetworkMounts_PythonToCpp_KNetworkMounts_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNetworkMounts_TypeF()))
        return KNetworkMounts_PythonToCpp_KNetworkMounts_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNetworkMounts_PTR_CppToPython_KNetworkMounts(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNetworkMounts *>(const_cast<void *>(cppIn)), Sbk_KNetworkMounts_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNetworkMounts_SignatureStrings[] = {
    "KCoreAddons.KNetworkMounts.addPath(self,path:QString,type:KCoreAddons.KNetworkMounts.KNetworkMountsType)",
    "KCoreAddons.KNetworkMounts.canonicalSymlinkPath(self,path:QString)->QString",
    "KCoreAddons.KNetworkMounts.clearCache(self)",
    "KCoreAddons.KNetworkMounts.isEnabled(self)->bool",
    "KCoreAddons.KNetworkMounts.isOptionEnabled(self,option:KCoreAddons.KNetworkMounts.KNetworkMountOption,defaultValue:bool=false)->bool",
    "KCoreAddons.KNetworkMounts.isOptionEnabledForPath(self,path:QString,option:KCoreAddons.KNetworkMounts.KNetworkMountOption)->bool",
    "KCoreAddons.KNetworkMounts.isSlowPath(self,path:QString,type:KCoreAddons.KNetworkMounts.KNetworkMountsType=KNetworkMounts.KNetworkMountsType.Any)->bool",
    "KCoreAddons.KNetworkMounts.paths(self,type:KCoreAddons.KNetworkMounts.KNetworkMountsType=KNetworkMounts.KNetworkMountsType.Any)->QStringList",
    "KCoreAddons.KNetworkMounts.self()->KCoreAddons.KNetworkMounts",
    "KCoreAddons.KNetworkMounts.setEnabled(self,value:bool)",
    "KCoreAddons.KNetworkMounts.setOption(self,option:KCoreAddons.KNetworkMounts.KNetworkMountOption,value:bool)",
    "KCoreAddons.KNetworkMounts.setPaths(self,paths:QStringList,type:KCoreAddons.KNetworkMounts.KNetworkMountsType)",
    "KCoreAddons.KNetworkMounts.sync(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KNetworkMounts_SignatureByteSize = 256;
static constexpr uint8_t KNetworkMounts_SignatureBytes[256] = {
    0x78, 0xda, 0xb5, 0x94, 0xdd, 0x6e, 0xc2, 0x30, 0x0c, 0x85, 0xef, 0xf7, 0x24, 0x54, 0x2a, 0x7d,
    0x80, 0x4a, 0x20, 0x21, 0xc4, 0x6e, 0x3a, 0x36, 0xa6, 0x4e, 0xdc, 0x9b, 0xc6, 0x1d, 0x11, 0xc6,
    0xae, 0x92, 0x74, 0xa8, 0x6f, 0xbf, 0xfe, 0x69, 0x03, 0x69, 0x0d, 0xdd, 0x06, 0x77, 0x49, 0x74,
    0x8e, 0xfd, 0xc5, 0x76, 0x92, 0x2c, 0xc5, 0xe0, 0x42, 0x29, 0x61, 0x1b, 0x25, 0xcf, 0xe8, 0x4e,
    0x62, 0x0e, 0x6b, 0x29, 0xd9, 0xd9, 0x08, 0x94, 0xda, 0x80, 0xdb, 0x4f, 0x2c, 0x52, 0x1e, 0x16,
    0xf5, 0x2a, 0x7e, 0x4d, 0x9d, 0xd1, 0xfc, 0x1e, 0xba, 0xaa, 0xc0, 0x38, 0x19, 0x76, 0x5e, 0x6e,
    0xdf, 0x6a, 0x75, 0xf0, 0xe0, 0x91, 0x67, 0xc0, 0xc2, 0x3a, 0x03, 0x4a, 0xab, 0x23, 0x69, 0x3e,
    0xfc, 0x9c, 0x35, 0x98, 0xce, 0xfb, 0x95, 0x37, 0x16, 0x21, 0x98, 0x25, 0x64, 0x7b, 0x6c, 0x23,
    0x78, 0xf3, 0x6a, 0xbb, 0x62, 0xd8, 0x11, 0xaa, 0x4e, 0x3a, 0x9d, 0xef, 0x44, 0xc8, 0x6f, 0x78,
    0x29, 0x9c, 0x16, 0x3e, 0xb7, 0x85, 0xd2, 0x1e, 0x8d, 0x2e, 0x47, 0x17, 0x21, 0x54, 0x98, 0x43,
    0x49, 0x6e, 0x0b, 0x54, 0x62, 0xdc, 0xe4, 0x9d, 0xe5, 0x40, 0x16, 0x7f, 0x0f, 0xf1, 0x28, 0x66,
    0xa0, 0x4b, 0x7f, 0x02, 0x1b, 0x05, 0x90, 0x92, 0x9c, 0x6e, 0x36, 0x1a, 0xb3, 0xab, 0x8a, 0x68,
    0xc1, 0xd5, 0x08, 0xae, 0x86, 0xc3, 0x76, 0x48, 0x77, 0xa4, 0xe8, 0x2f, 0xfa, 0xa4, 0xad, 0xf3,
    0xc1, 0x34, 0x18, 0x93, 0x5a, 0x3e, 0x2c, 0xf1, 0xbb, 0xdd, 0xc5, 0x8c, 0x7d, 0x7c, 0x8d, 0x49,
    0x70, 0xc5, 0xd6, 0x75, 0xf1, 0x3f, 0x93, 0x39, 0x3e, 0xd7, 0xe6, 0xbb, 0xe0, 0x6d, 0xed, 0xe3,
    0xb3, 0xda, 0xdc, 0xfa, 0x8f, 0xb0, 0x15, 0x67, 0xfd, 0x8b, 0xfe, 0x04, 0x6e, 0xe8, 0xc6, 0x51
};
#endif

PyTypeObject *init_KNetworkMounts(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX].type;

    Shiboken::AutoDecRef Sbk_KNetworkMounts_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KNetworkMounts_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNetworkMounts",
        "KNetworkMounts*",
        &Sbk_KNetworkMounts_spec,
        nullptr,
        Sbk_KNetworkMounts_Type_bases.object(),
        0);
    auto *pyType = Sbk_KNetworkMounts_TypeF(); // references _Sbk_KNetworkMounts_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNetworkMounts_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNetworkMounts_SignatureBytes, KNetworkMounts_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNetworkMounts_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNetworkMounts_PythonToCpp_KNetworkMounts_PTR,
        is_KNetworkMounts_PythonToCpp_KNetworkMounts_PTR_Convertible,
        KNetworkMounts_PTR_CppToPython_KNetworkMounts);

    Shiboken::Conversions::registerConverterName(converter, "KNetworkMounts");
    Shiboken::Conversions::registerConverterName(converter, "KNetworkMounts*");
    Shiboken::Conversions::registerConverterName(converter, "KNetworkMounts&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNetworkMounts).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNetworkMounts_TypeF(), &Sbk_KNetworkMounts_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KNetworkMounts_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'KNetworkMountOption'.
    const char *KNetworkMountOption_Initializer[] = {
        "LowSideEffectsOptimizations",
        "MediumSideEffectsOptimizations",
        "StrongSideEffectsOptimizations",
        "KDirWatchDontAddWatches",
        "SymlinkPathsUseCache",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t KNetworkMountOption_InitializerValues[] = {
        uint8_t(KNetworkMounts::KNetworkMountOption::LowSideEffectsOptimizations),    //  0x00  0
        uint8_t(KNetworkMounts::KNetworkMountOption::MediumSideEffectsOptimizations), //  0x01  1
        uint8_t(KNetworkMounts::KNetworkMountOption::StrongSideEffectsOptimizations), //  0x02  2
        uint8_t(KNetworkMounts::KNetworkMountOption::KDirWatchDontAddWatches),        //  0x03  3
        uint8_t(KNetworkMounts::KNetworkMountOption::SymlinkPathsUseCache)            //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNetworkMounts_TypeF(),
        "1:KCoreAddons.KNetworkMounts.KNetworkMountOption",
        KNetworkMountOption_Initializer, KNetworkMountOption_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountOption_IDX].type = EType;
    // Register converter for enum 'KNetworkMounts::KNetworkMountOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNetworkMounts_KNetworkMountOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNetworkMounts_KNetworkMountOption,
            is_Enum_PythonToCpp_KNetworkMounts_KNetworkMountOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNetworkMounts::KNetworkMountOption");
        Shiboken::Conversions::registerConverterAlias(converter, "KNetworkMountOption");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'KNetworkMountOption' enum.

    // Initialization of enum 'KNetworkMountsType'.
    const char *KNetworkMountsType_Initializer[] = {
        "NfsPaths",
        "SmbPaths",
        "SymlinkDirectory",
        "SymlinkToNetworkMount",
        "Any",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t KNetworkMountsType_InitializerValues[] = {
        uint8_t(KNetworkMounts::KNetworkMountsType::NfsPaths),              //  0x00  0
        uint8_t(KNetworkMounts::KNetworkMountsType::SmbPaths),              //  0x01  1
        uint8_t(KNetworkMounts::KNetworkMountsType::SymlinkDirectory),      //  0x02  2
        uint8_t(KNetworkMounts::KNetworkMountsType::SymlinkToNetworkMount), //  0x03  3
        uint8_t(KNetworkMounts::KNetworkMountsType::Any)                    //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNetworkMounts_TypeF(),
        "1:KCoreAddons.KNetworkMounts.KNetworkMountsType",
        KNetworkMountsType_Initializer, KNetworkMountsType_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KNetworkMounts_KNetworkMountsType_IDX].type = EType;
    // Register converter for enum 'KNetworkMounts::KNetworkMountsType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNetworkMounts_KNetworkMountsType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNetworkMounts_KNetworkMountsType,
            is_Enum_PythonToCpp_KNetworkMounts_KNetworkMountsType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNetworkMounts::KNetworkMountsType");
        Shiboken::Conversions::registerConverterAlias(converter, "KNetworkMountsType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'KNetworkMountsType' enum.

    qRegisterMetaType< ::KNetworkMounts::KNetworkMountOption >("KNetworkMounts::KNetworkMountOption");
    qRegisterMetaType< ::KNetworkMounts::KNetworkMountsType >("KNetworkMounts::KNetworkMountsType");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNetworkMounts::staticMetaObject, sizeof(::KNetworkMounts));

    return pyType;
}
