/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

//
//Copyright 2022 The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/apiserver/pkg/storage/value/encrypt/envelope/kmsv2/v2/api.proto

package v2

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type EncryptedDEKSourceType int32

const (
	// AES_GCM_KEY means that the plaintext of encryptedDEKSource is the DEK itself, with AES-GCM as the encryption algorithm.
	EncryptedDEKSourceType_AES_GCM_KEY EncryptedDEKSourceType = 0
	// HKDF_SHA256_XNONCE_AES_GCM_SEED means that the plaintext of encryptedDEKSource is the pseudo random key
	// (referred to as the seed throughout the code) that is fed into HKDF expand.  SHA256 is the hash algorithm
	// and first 32 bytes of encryptedData are the info param.  The first 32 bytes from the HKDF stream are used
	// as the DEK with AES-GCM as the encryption algorithm.
	EncryptedDEKSourceType_HKDF_SHA256_XNONCE_AES_GCM_SEED EncryptedDEKSourceType = 1
)

// Enum value maps for EncryptedDEKSourceType.
var (
	EncryptedDEKSourceType_name = map[int32]string{
		0: "AES_GCM_KEY",
		1: "HKDF_SHA256_XNONCE_AES_GCM_SEED",
	}
	EncryptedDEKSourceType_value = map[string]int32{
		"AES_GCM_KEY":                     0,
		"HKDF_SHA256_XNONCE_AES_GCM_SEED": 1,
	}
)

func (x EncryptedDEKSourceType) Enum() *EncryptedDEKSourceType {
	p := new(EncryptedDEKSourceType)
	*p = x
	return p
}

func (x EncryptedDEKSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptedDEKSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_enumTypes[0].Descriptor()
}

func (EncryptedDEKSourceType) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_enumTypes[0]
}

func (x EncryptedDEKSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptedDEKSourceType.Descriptor instead.
func (EncryptedDEKSourceType) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescGZIP(), []int{0}
}

// EncryptedObject is the representation of data stored in etcd after envelope encryption.
type EncryptedObject struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// EncryptedData is the encrypted data.
	EncryptedData []byte `protobuf:"bytes,1,opt,name=encryptedData,proto3" json:"encryptedData,omitempty"`
	// KeyID is the KMS key ID used for encryption operations.
	// keyID must satisfy the following constraints:
	// 1. The keyID is not empty.
	// 2. The size of keyID is less than 1 kB.
	KeyID string `protobuf:"bytes,2,opt,name=keyID,proto3" json:"keyID,omitempty"`
	// EncryptedDEKSource is the ciphertext of the source of the DEK used to encrypt the data stored in encryptedData.
	// encryptedDEKSourceType defines the process of using the plaintext of this field to determine the aforementioned DEK.
	// encryptedDEKSource must satisfy the following constraints:
	// 1. The encrypted DEK source is not empty.
	// 2. The size of encrypted DEK source is less than 1 kB.
	EncryptedDEKSource []byte `protobuf:"bytes,3,opt,name=encryptedDEKSource,proto3" json:"encryptedDEKSource,omitempty"`
	// Annotations is additional metadata that was provided by the KMS plugin.
	// Annotations must satisfy the following constraints:
	//  1. Annotation key must be a fully qualified domain name that conforms to the definition in DNS (RFC 1123).
	//  2. The size of annotations keys + values is less than 32 kB.
	Annotations map[string][]byte `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// encryptedDEKSourceType defines the process of using the plaintext of encryptedDEKSource to determine the DEK.
	EncryptedDEKSourceType EncryptedDEKSourceType `protobuf:"varint,5,opt,name=encryptedDEKSourceType,proto3,enum=v2.EncryptedDEKSourceType" json:"encryptedDEKSourceType,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *EncryptedObject) Reset() {
	*x = EncryptedObject{}
	mi := &file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptedObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptedObject) ProtoMessage() {}

func (x *EncryptedObject) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptedObject.ProtoReflect.Descriptor instead.
func (*EncryptedObject) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescGZIP(), []int{0}
}

func (x *EncryptedObject) GetEncryptedData() []byte {
	if x != nil {
		return x.EncryptedData
	}
	return nil
}

func (x *EncryptedObject) GetKeyID() string {
	if x != nil {
		return x.KeyID
	}
	return ""
}

func (x *EncryptedObject) GetEncryptedDEKSource() []byte {
	if x != nil {
		return x.EncryptedDEKSource
	}
	return nil
}

func (x *EncryptedObject) GetAnnotations() map[string][]byte {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *EncryptedObject) GetEncryptedDEKSourceType() EncryptedDEKSourceType {
	if x != nil {
		return x.EncryptedDEKSourceType
	}
	return EncryptedDEKSourceType_AES_GCM_KEY
}

var File_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDesc = string([]byte{
	0x0a, 0x52, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x2f, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x2f, 0x6b, 0x6d, 0x73, 0x76, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x02, 0x76, 0x32, 0x22, 0xd9, 0x02, 0x0a, 0x0f, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x24, 0x0a, 0x0d,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x44, 0x12, 0x2e, 0x0a, 0x12, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x65, 0x64, 0x44, 0x45, 0x4b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44,
	0x45, 0x4b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x52, 0x0a, 0x16, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44, 0x45, 0x4b,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44,
	0x45, 0x4b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x16, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44, 0x45, 0x4b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x2a, 0x4e, 0x0a, 0x16, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
	0x64, 0x44, 0x45, 0x4b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f,
	0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x47, 0x43, 0x4d, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x00, 0x12,
	0x23, 0x0a, 0x1f, 0x48, 0x4b, 0x44, 0x46, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x5f, 0x58,
	0x4e, 0x4f, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x45, 0x53, 0x5f, 0x47, 0x43, 0x4d, 0x5f, 0x53, 0x45,
	0x45, 0x44, 0x10, 0x01, 0x42, 0x3e, 0x5a, 0x3c, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x61,
	0x70, 0x69, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x2f, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x2f, 0x6b, 0x6d, 0x73, 0x76,
	0x32, 0x2f, 0x76, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDesc), len(file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDescData
}

var file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_goTypes = []any{
	(EncryptedDEKSourceType)(0), // 0: v2.EncryptedDEKSourceType
	(*EncryptedObject)(nil),     // 1: v2.EncryptedObject
	nil,                         // 2: v2.EncryptedObject.AnnotationsEntry
}
var file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_depIdxs = []int32{
	2, // 0: v2.EncryptedObject.annotations:type_name -> v2.EncryptedObject.AnnotationsEntry
	0, // 1: v2.EncryptedObject.encryptedDEKSourceType:type_name -> v2.EncryptedDEKSourceType
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() {
	file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_init()
}
func file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_init() {
	if File_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDesc), len(file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_depIdxs,
		EnumInfos:         file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_enumTypes,
		MessageInfos:      file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto = out.File
	file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_goTypes = nil
	file_staging_src_k8s_io_apiserver_pkg_storage_value_encrypt_envelope_kmsv2_v2_api_proto_depIdxs = nil
}
