#if 0
INDI
Copyright (C) 2016 Rumen G. Bogdanovski

This library is free software;
you can redistribute it and / or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation;
either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY;
without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
#endif

#pragma once

#include <stdint.h>

static const char base64digits[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static const char base64lut[] = "AAABACADAEAFAGAHAIAJAKALAMANAOAPAQARASATAUAVAWAXAYAZAaAbAcAdAeAfAgAhAiAjAkAlAmAnAoApAq"
                                "ArAsAtAuAvAwAxAyAzA0A1A2A3A4A5A6A7A8A9A+A/"
                                "BABBBCBDBEBFBGBHBIBJBKBLBMBNBOBPBQBRBSBTBUBVBWBXBYBZBaBbBcBdBeBfBgBhBiBjBkBlBmBnBoBpBq"
                                "BrBsBtBuBvBwBxByBzB0B1B2B3B4B5B6B7B8B9B+B/"
                                "CACBCCCDCECFCGCHCICJCKCLCMCNCOCPCQCRCSCTCUCVCWCXCYCZCaCbCcCdCeCfCgChCiCjCkClCmCnCoCpCq"
                                "CrCsCtCuCvCwCxCyCzC0C1C2C3C4C5C6C7C8C9C+C/"
                                "DADBDCDDDEDFDGDHDIDJDKDLDMDNDODPDQDRDSDTDUDVDWDXDYDZDaDbDcDdDeDfDgDhDiDjDkDlDmDnDoDpDq"
                                "DrDsDtDuDvDwDxDyDzD0D1D2D3D4D5D6D7D8D9D+D/"
                                "EAEBECEDEEEFEGEHEIEJEKELEMENEOEPEQERESETEUEVEWEXEYEZEaEbEcEdEeEfEgEhEiEjEkElEmEnEoEpEq"
                                "ErEsEtEuEvEwExEyEzE0E1E2E3E4E5E6E7E8E9E+E/"
                                "FAFBFCFDFEFFFGFHFIFJFKFLFMFNFOFPFQFRFSFTFUFVFWFXFYFZFaFbFcFdFeFfFgFhFiFjFkFlFmFnFoFpFq"
                                "FrFsFtFuFvFwFxFyFzF0F1F2F3F4F5F6F7F8F9F+F/"
                                "GAGBGCGDGEGFGGGHGIGJGKGLGMGNGOGPGQGRGSGTGUGVGWGXGYGZGaGbGcGdGeGfGgGhGiGjGkGlGmGnGoGpGq"
                                "GrGsGtGuGvGwGxGyGzG0G1G2G3G4G5G6G7G8G9G+G/"
                                "HAHBHCHDHEHFHGHHHIHJHKHLHMHNHOHPHQHRHSHTHUHVHWHXHYHZHaHbHcHdHeHfHgHhHiHjHkHlHmHnHoHpHq"
                                "HrHsHtHuHvHwHxHyHzH0H1H2H3H4H5H6H7H8H9H+H/"
                                "IAIBICIDIEIFIGIHIIIJIKILIMINIOIPIQIRISITIUIVIWIXIYIZIaIbIcIdIeIfIgIhIiIjIkIlImInIoIpIq"
                                "IrIsItIuIvIwIxIyIzI0I1I2I3I4I5I6I7I8I9I+I/"
                                "JAJBJCJDJEJFJGJHJIJJJKJLJMJNJOJPJQJRJSJTJUJVJWJXJYJZJaJbJcJdJeJfJgJhJiJjJkJlJmJnJoJpJq"
                                "JrJsJtJuJvJwJxJyJzJ0J1J2J3J4J5J6J7J8J9J+J/"
                                "KAKBKCKDKEKFKGKHKIKJKKKLKMKNKOKPKQKRKSKTKUKVKWKXKYKZKaKbKcKdKeKfKgKhKiKjKkKlKmKnKoKpKq"
                                "KrKsKtKuKvKwKxKyKzK0K1K2K3K4K5K6K7K8K9K+K/"
                                "LALBLCLDLELFLGLHLILJLKLLLMLNLOLPLQLRLSLTLULVLWLXLYLZLaLbLcLdLeLfLgLhLiLjLkLlLmLnLoLpLq"
                                "LrLsLtLuLvLwLxLyLzL0L1L2L3L4L5L6L7L8L9L+L/"
                                "MAMBMCMDMEMFMGMHMIMJMKMLMMMNMOMPMQMRMSMTMUMVMWMXMYMZMaMbMcMdMeMfMgMhMiMjMkMlMmMnMoMpMq"
                                "MrMsMtMuMvMwMxMyMzM0M1M2M3M4M5M6M7M8M9M+M/"
                                "NANBNCNDNENFNGNHNINJNKNLNMNNNONPNQNRNSNTNUNVNWNXNYNZNaNbNcNdNeNfNgNhNiNjNkNlNmNnNoNpNq"
                                "NrNsNtNuNvNwNxNyNzN0N1N2N3N4N5N6N7N8N9N+N/"
                                "OAOBOCODOEOFOGOHOIOJOKOLOMONOOOPOQOROSOTOUOVOWOXOYOZOaObOcOdOeOfOgOhOiOjOkOlOmOnOoOpOq"
                                "OrOsOtOuOvOwOxOyOzO0O1O2O3O4O5O6O7O8O9O+O/"
                                "PAPBPCPDPEPFPGPHPIPJPKPLPMPNPOPPPQPRPSPTPUPVPWPXPYPZPaPbPcPdPePfPgPhPiPjPkPlPmPnPoPpPq"
                                "PrPsPtPuPvPwPxPyPzP0P1P2P3P4P5P6P7P8P9P+P/"
                                "QAQBQCQDQEQFQGQHQIQJQKQLQMQNQOQPQQQRQSQTQUQVQWQXQYQZQaQbQcQdQeQfQgQhQiQjQkQlQmQnQoQpQq"
                                "QrQsQtQuQvQwQxQyQzQ0Q1Q2Q3Q4Q5Q6Q7Q8Q9Q+Q/"
                                "RARBRCRDRERFRGRHRIRJRKRLRMRNRORPRQRRRSRTRURVRWRXRYRZRaRbRcRdReRfRgRhRiRjRkRlRmRnRoRpRq"
                                "RrRsRtRuRvRwRxRyRzR0R1R2R3R4R5R6R7R8R9R+R/"
                                "SASBSCSDSESFSGSHSISJSKSLSMSNSOSPSQSRSSSTSUSVSWSXSYSZSaSbScSdSeSfSgShSiSjSkSlSmSnSoSpSq"
                                "SrSsStSuSvSwSxSySzS0S1S2S3S4S5S6S7S8S9S+S/"
                                "TATBTCTDTETFTGTHTITJTKTLTMTNTOTPTQTRTSTTTUTVTWTXTYTZTaTbTcTdTeTfTgThTiTjTkTlTmTnToTpTq"
                                "TrTsTtTuTvTwTxTyTzT0T1T2T3T4T5T6T7T8T9T+T/"
                                "UAUBUCUDUEUFUGUHUIUJUKULUMUNUOUPUQURUSUTUUUVUWUXUYUZUaUbUcUdUeUfUgUhUiUjUkUlUmUnUoUpUq"
                                "UrUsUtUuUvUwUxUyUzU0U1U2U3U4U5U6U7U8U9U+U/"
                                "VAVBVCVDVEVFVGVHVIVJVKVLVMVNVOVPVQVRVSVTVUVVVWVXVYVZVaVbVcVdVeVfVgVhViVjVkVlVmVnVoVpVq"
                                "VrVsVtVuVvVwVxVyVzV0V1V2V3V4V5V6V7V8V9V+V/"
                                "WAWBWCWDWEWFWGWHWIWJWKWLWMWNWOWPWQWRWSWTWUWVWWWXWYWZWaWbWcWdWeWfWgWhWiWjWkWlWmWnWoWpWq"
                                "WrWsWtWuWvWwWxWyWzW0W1W2W3W4W5W6W7W8W9W+W/"
                                "XAXBXCXDXEXFXGXHXIXJXKXLXMXNXOXPXQXRXSXTXUXVXWXXXYXZXaXbXcXdXeXfXgXhXiXjXkXlXmXnXoXpXq"
                                "XrXsXtXuXvXwXxXyXzX0X1X2X3X4X5X6X7X8X9X+X/"
                                "YAYBYCYDYEYFYGYHYIYJYKYLYMYNYOYPYQYRYSYTYUYVYWYXYYYZYaYbYcYdYeYfYgYhYiYjYkYlYmYnYoYpYq"
                                "YrYsYtYuYvYwYxYyYzY0Y1Y2Y3Y4Y5Y6Y7Y8Y9Y+Y/"
                                "ZAZBZCZDZEZFZGZHZIZJZKZLZMZNZOZPZQZRZSZTZUZVZWZXZYZZZaZbZcZdZeZfZgZhZiZjZkZlZmZnZoZpZq"
                                "ZrZsZtZuZvZwZxZyZzZ0Z1Z2Z3Z4Z5Z6Z7Z8Z9Z+Z/"
                                "aAaBaCaDaEaFaGaHaIaJaKaLaMaNaOaPaQaRaSaTaUaVaWaXaYaZaaabacadaeafagahaiajakalamanaoapaq"
                                "arasatauavawaxayaza0a1a2a3a4a5a6a7a8a9a+a/"
                                "bAbBbCbDbEbFbGbHbIbJbKbLbMbNbObPbQbRbSbTbUbVbWbXbYbZbabbbcbdbebfbgbhbibjbkblbmbnbobpbq"
                                "brbsbtbubvbwbxbybzb0b1b2b3b4b5b6b7b8b9b+b/"
                                "cAcBcCcDcEcFcGcHcIcJcKcLcMcNcOcPcQcRcScTcUcVcWcXcYcZcacbcccdcecfcgchcicjckclcmcncocpcq"
                                "crcsctcucvcwcxcyczc0c1c2c3c4c5c6c7c8c9c+c/"
                                "dAdBdCdDdEdFdGdHdIdJdKdLdMdNdOdPdQdRdSdTdUdVdWdXdYdZdadbdcdddedfdgdhdidjdkdldmdndodpdq"
                                "drdsdtdudvdwdxdydzd0d1d2d3d4d5d6d7d8d9d+d/"
                                "eAeBeCeDeEeFeGeHeIeJeKeLeMeNeOePeQeReSeTeUeVeWeXeYeZeaebecedeeefegeheiejekelemeneoepeq"
                                "ereseteuevewexeyeze0e1e2e3e4e5e6e7e8e9e+e/"
                                "fAfBfCfDfEfFfGfHfIfJfKfLfMfNfOfPfQfRfSfTfUfVfWfXfYfZfafbfcfdfefffgfhfifjfkflfmfnfofpfq"
                                "frfsftfufvfwfxfyfzf0f1f2f3f4f5f6f7f8f9f+f/"
                                "gAgBgCgDgEgFgGgHgIgJgKgLgMgNgOgPgQgRgSgTgUgVgWgXgYgZgagbgcgdgegfggghgigjgkglgmgngogpgq"
                                "grgsgtgugvgwgxgygzg0g1g2g3g4g5g6g7g8g9g+g/"
                                "hAhBhChDhEhFhGhHhIhJhKhLhMhNhOhPhQhRhShThUhVhWhXhYhZhahbhchdhehfhghhhihjhkhlhmhnhohphq"
                                "hrhshthuhvhwhxhyhzh0h1h2h3h4h5h6h7h8h9h+h/"
                                "iAiBiCiDiEiFiGiHiIiJiKiLiMiNiOiPiQiRiSiTiUiViWiXiYiZiaibicidieifigihiiijikiliminioipiq"
                                "irisitiuiviwixiyizi0i1i2i3i4i5i6i7i8i9i+i/"
                                "jAjBjCjDjEjFjGjHjIjJjKjLjMjNjOjPjQjRjSjTjUjVjWjXjYjZjajbjcjdjejfjgjhjijjjkjljmjnjojpjq"
                                "jrjsjtjujvjwjxjyjzj0j1j2j3j4j5j6j7j8j9j+j/"
                                "kAkBkCkDkEkFkGkHkIkJkKkLkMkNkOkPkQkRkSkTkUkVkWkXkYkZkakbkckdkekfkgkhkikjkkklkmknkokpkq"
                                "krksktkukvkwkxkykzk0k1k2k3k4k5k6k7k8k9k+k/"
                                "lAlBlClDlElFlGlHlIlJlKlLlMlNlOlPlQlRlSlTlUlVlWlXlYlZlalblcldlelflglhliljlklllmlnlolplq"
                                "lrlsltlulvlwlxlylzl0l1l2l3l4l5l6l7l8l9l+l/"
                                "mAmBmCmDmEmFmGmHmImJmKmLmMmNmOmPmQmRmSmTmUmVmWmXmYmZmambmcmdmemfmgmhmimjmkmlmmmnmompmq"
                                "mrmsmtmumvmwmxmymzm0m1m2m3m4m5m6m7m8m9m+m/"
                                "nAnBnCnDnEnFnGnHnInJnKnLnMnNnOnPnQnRnSnTnUnVnWnXnYnZnanbncndnenfngnhninjnknlnmnnnonpnq"
                                "nrnsntnunvnwnxnynzn0n1n2n3n4n5n6n7n8n9n+n/"
                                "oAoBoCoDoEoFoGoHoIoJoKoLoMoNoOoPoQoRoSoToUoVoWoXoYoZoaobocodoeofogohoiojokolomonooopoq"
                                "orosotouovowoxoyozo0o1o2o3o4o5o6o7o8o9o+o/"
                                "pApBpCpDpEpFpGpHpIpJpKpLpMpNpOpPpQpRpSpTpUpVpWpXpYpZpapbpcpdpepfpgphpipjpkplpmpnpopppq"
                                "prpsptpupvpwpxpypzp0p1p2p3p4p5p6p7p8p9p+p/"
                                "qAqBqCqDqEqFqGqHqIqJqKqLqMqNqOqPqQqRqSqTqUqVqWqXqYqZqaqbqcqdqeqfqgqhqiqjqkqlqmqnqoqpqq"
                                "qrqsqtquqvqwqxqyqzq0q1q2q3q4q5q6q7q8q9q+q/"
                                "rArBrCrDrErFrGrHrIrJrKrLrMrNrOrPrQrRrSrTrUrVrWrXrYrZrarbrcrdrerfrgrhrirjrkrlrmrnrorprq"
                                "rrrsrtrurvrwrxryrzr0r1r2r3r4r5r6r7r8r9r+r/"
                                "sAsBsCsDsEsFsGsHsIsJsKsLsMsNsOsPsQsRsSsTsUsVsWsXsYsZsasbscsdsesfsgshsisjskslsmsnsospsq"
                                "srssstsusvswsxsyszs0s1s2s3s4s5s6s7s8s9s+s/"
                                "tAtBtCtDtEtFtGtHtItJtKtLtMtNtOtPtQtRtStTtUtVtWtXtYtZtatbtctdtetftgthtitjtktltmtntotptq"
                                "trtstttutvtwtxtytzt0t1t2t3t4t5t6t7t8t9t+t/"
                                "uAuBuCuDuEuFuGuHuIuJuKuLuMuNuOuPuQuRuSuTuUuVuWuXuYuZuaubucudueufuguhuiujukulumunuoupuq"
                                "urusutuuuvuwuxuyuzu0u1u2u3u4u5u6u7u8u9u+u/"
                                "vAvBvCvDvEvFvGvHvIvJvKvLvMvNvOvPvQvRvSvTvUvVvWvXvYvZvavbvcvdvevfvgvhvivjvkvlvmvnvovpvq"
                                "vrvsvtvuvvvwvxvyvzv0v1v2v3v4v5v6v7v8v9v+v/"
                                "wAwBwCwDwEwFwGwHwIwJwKwLwMwNwOwPwQwRwSwTwUwVwWwXwYwZwawbwcwdwewfwgwhwiwjwkwlwmwnwowpwq"
                                "wrwswtwuwvwwwxwywzw0w1w2w3w4w5w6w7w8w9w+w/"
                                "xAxBxCxDxExFxGxHxIxJxKxLxMxNxOxPxQxRxSxTxUxVxWxXxYxZxaxbxcxdxexfxgxhxixjxkxlxmxnxoxpxq"
                                "xrxsxtxuxvxwxxxyxzx0x1x2x3x4x5x6x7x8x9x+x/"
                                "yAyByCyDyEyFyGyHyIyJyKyLyMyNyOyPyQyRySyTyUyVyWyXyYyZyaybycydyeyfygyhyiyjykylymynyoypyq"
                                "yrysytyuyvywyxyyyzy0y1y2y3y4y5y6y7y8y9y+y/"
                                "zAzBzCzDzEzFzGzHzIzJzKzLzMzNzOzPzQzRzSzTzUzVzWzXzYzZzazbzczdzezfzgzhzizjzkzlzmznzozpzq"
                                "zrzsztzuzvzwzxzyzzz0z1z2z3z4z5z6z7z8z9z+z/"
                                "0A0B0C0D0E0F0G0H0I0J0K0L0M0N0O0P0Q0R0S0T0U0V0W0X0Y0Z0a0b0c0d0e0f0g0h0i0j0k0l0m0n0o0p0q"
                                "0r0s0t0u0v0w0x0y0z000102030405060708090+0/"
                                "1A1B1C1D1E1F1G1H1I1J1K1L1M1N1O1P1Q1R1S1T1U1V1W1X1Y1Z1a1b1c1d1e1f1g1h1i1j1k1l1m1n1o1p1q"
                                "1r1s1t1u1v1w1x1y1z101112131415161718191+1/"
                                "2A2B2C2D2E2F2G2H2I2J2K2L2M2N2O2P2Q2R2S2T2U2V2W2X2Y2Z2a2b2c2d2e2f2g2h2i2j2k2l2m2n2o2p2q"
                                "2r2s2t2u2v2w2x2y2z202122232425262728292+2/"
                                "3A3B3C3D3E3F3G3H3I3J3K3L3M3N3O3P3Q3R3S3T3U3V3W3X3Y3Z3a3b3c3d3e3f3g3h3i3j3k3l3m3n3o3p3q"
                                "3r3s3t3u3v3w3x3y3z303132333435363738393+3/"
                                "4A4B4C4D4E4F4G4H4I4J4K4L4M4N4O4P4Q4R4S4T4U4V4W4X4Y4Z4a4b4c4d4e4f4g4h4i4j4k4l4m4n4o4p4q"
                                "4r4s4t4u4v4w4x4y4z404142434445464748494+4/"
                                "5A5B5C5D5E5F5G5H5I5J5K5L5M5N5O5P5Q5R5S5T5U5V5W5X5Y5Z5a5b5c5d5e5f5g5h5i5j5k5l5m5n5o5p5q"
                                "5r5s5t5u5v5w5x5y5z505152535455565758595+5/"
                                "6A6B6C6D6E6F6G6H6I6J6K6L6M6N6O6P6Q6R6S6T6U6V6W6X6Y6Z6a6b6c6d6e6f6g6h6i6j6k6l6m6n6o6p6q"
                                "6r6s6t6u6v6w6x6y6z606162636465666768696+6/"
                                "7A7B7C7D7E7F7G7H7I7J7K7L7M7N7O7P7Q7R7S7T7U7V7W7X7Y7Z7a7b7c7d7e7f7g7h7i7j7k7l7m7n7o7p7q"
                                "7r7s7t7u7v7w7x7y7z707172737475767778797+7/"
                                "8A8B8C8D8E8F8G8H8I8J8K8L8M8N8O8P8Q8R8S8T8U8V8W8X8Y8Z8a8b8c8d8e8f8g8h8i8j8k8l8m8n8o8p8q"
                                "8r8s8t8u8v8w8x8y8z808182838485868788898+8/"
                                "9A9B9C9D9E9F9G9H9I9J9K9L9M9N9O9P9Q9R9S9T9U9V9W9X9Y9Z9a9b9c9d9e9f9g9h9i9j9k9l9m9n9o9p9q"
                                "9r9s9t9u9v9w9x9y9z909192939495969798999+9/"
                                "+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z+a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+"
                                "q+r+s+t+u+v+w+x+y+z+0+1+2+3+4+5+6+7+8+9+++/"
                                "/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/"
                                "q/r/s/t/u/v/w/x/y/z/0/1/2/3/4/5/6/7/8/9/+//";

static const uint16_t rbase64lut[] =
{
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   16120, 248,  248,   248,   16376,
    13560, 13816, 14072, 14328, 14584, 14840, 15096, 15352, 15608, 15864, 248,   248,   248,  25592, 248,   248,
    248,   248,   504,   760,   1016,  1272,  1528,  1784,  2040,  2296,  2552,  2808,  3064, 3320,  3576,  3832,
    4088,  4344,  4600,  4856,  5112,  5368,  5624,  5880,  6136,  6392,  6648,  248,   248,  248,   248,   248,
    248,   6904,  7160,  7416,  7672,  7928,  8184,  8440,  8696,  8952,  9208,  9464,  9720, 9976,  10232, 10488,
    10744, 11000, 11256, 11512, 11768, 12024, 12280, 12536, 12792, 13048, 13304, 248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,   248,  248,   248,   248,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   16124, 252,  252,   252,   16380,
    13564, 13820, 14076, 14332, 14588, 14844, 15100, 15356, 15612, 15868, 252,   252,   252,  25596, 252,   252,
    252,   252,   508,   764,   1020,  1276,  1532,  1788,  2044,  2300,  2556,  2812,  3068, 3324,  3580,  3836,
    4092,  4348,  4604,  4860,  5116,  5372,  5628,  5884,  6140,  6396,  6652,  252,   252,  252,   252,   252,
    252,   6908,  7164,  7420,  7676,  7932,  8188,  8444,  8700,  8956,  9212,  9468,  9724, 9980,  10236, 10492,
    10748, 11004, 11260, 11516, 11772, 12028, 12284, 12540, 12796, 13052, 13308, 252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,   252,  252,   252,   252,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   16080, 208,  208,   208,   16336,
    13520, 13776, 14032, 14288, 14544, 14800, 15056, 15312, 15568, 15824, 208,   208,   208,  25552, 208,   208,
    208,   208,   464,   720,   976,   1232,  1488,  1744,  2000,  2256,  2512,  2768,  3024, 3280,  3536,  3792,
    4048,  4304,  4560,  4816,  5072,  5328,  5584,  5840,  6096,  6352,  6608,  208,   208,  208,   208,   208,
    208,   6864,  7120,  7376,  7632,  7888,  8144,  8400,  8656,  8912,  9168,  9424,  9680, 9936,  10192, 10448,
    10704, 10960, 11216, 11472, 11728, 11984, 12240, 12496, 12752, 13008, 13264, 208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,   208,  208,   208,   208,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   16084, 212,  212,   212,   16340,
    13524, 13780, 14036, 14292, 14548, 14804, 15060, 15316, 15572, 15828, 212,   212,   212,  25556, 212,   212,
    212,   212,   468,   724,   980,   1236,  1492,  1748,  2004,  2260,  2516,  2772,  3028, 3284,  3540,  3796,
    4052,  4308,  4564,  4820,  5076,  5332,  5588,  5844,  6100,  6356,  6612,  212,   212,  212,   212,   212,
    212,   6868,  7124,  7380,  7636,  7892,  8148,  8404,  8660,  8916,  9172,  9428,  9684, 9940,  10196, 10452,
    10708, 10964, 11220, 11476, 11732, 11988, 12244, 12500, 12756, 13012, 13268, 212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,   212,  212,   212,   212,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   16088, 216,  216,   216,   16344,
    13528, 13784, 14040, 14296, 14552, 14808, 15064, 15320, 15576, 15832, 216,   216,   216,  25560, 216,   216,
    216,   216,   472,   728,   984,   1240,  1496,  1752,  2008,  2264,  2520,  2776,  3032, 3288,  3544,  3800,
    4056,  4312,  4568,  4824,  5080,  5336,  5592,  5848,  6104,  6360,  6616,  216,   216,  216,   216,   216,
    216,   6872,  7128,  7384,  7640,  7896,  8152,  8408,  8664,  8920,  9176,  9432,  9688, 9944,  10200, 10456,
    10712, 10968, 11224, 11480, 11736, 11992, 12248, 12504, 12760, 13016, 13272, 216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,   216,  216,   216,   216,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   16092, 220,  220,   220,   16348,
    13532, 13788, 14044, 14300, 14556, 14812, 15068, 15324, 15580, 15836, 220,   220,   220,  25564, 220,   220,
    220,   220,   476,   732,   988,   1244,  1500,  1756,  2012,  2268,  2524,  2780,  3036, 3292,  3548,  3804,
    4060,  4316,  4572,  4828,  5084,  5340,  5596,  5852,  6108,  6364,  6620,  220,   220,  220,   220,   220,
    220,   6876,  7132,  7388,  7644,  7900,  8156,  8412,  8668,  8924,  9180,  9436,  9692, 9948,  10204, 10460,
    10716, 10972, 11228, 11484, 11740, 11996, 12252, 12508, 12764, 13020, 13276, 220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,   220,  220,   220,   220,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   16096, 224,  224,   224,   16352,
    13536, 13792, 14048, 14304, 14560, 14816, 15072, 15328, 15584, 15840, 224,   224,   224,  25568, 224,   224,
    224,   224,   480,   736,   992,   1248,  1504,  1760,  2016,  2272,  2528,  2784,  3040, 3296,  3552,  3808,
    4064,  4320,  4576,  4832,  5088,  5344,  5600,  5856,  6112,  6368,  6624,  224,   224,  224,   224,   224,
    224,   6880,  7136,  7392,  7648,  7904,  8160,  8416,  8672,  8928,  9184,  9440,  9696, 9952,  10208, 10464,
    10720, 10976, 11232, 11488, 11744, 12000, 12256, 12512, 12768, 13024, 13280, 224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,   224,  224,   224,   224,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   16100, 228,  228,   228,   16356,
    13540, 13796, 14052, 14308, 14564, 14820, 15076, 15332, 15588, 15844, 228,   228,   228,  25572, 228,   228,
    228,   228,   484,   740,   996,   1252,  1508,  1764,  2020,  2276,  2532,  2788,  3044, 3300,  3556,  3812,
    4068,  4324,  4580,  4836,  5092,  5348,  5604,  5860,  6116,  6372,  6628,  228,   228,  228,   228,   228,
    228,   6884,  7140,  7396,  7652,  7908,  8164,  8420,  8676,  8932,  9188,  9444,  9700, 9956,  10212, 10468,
    10724, 10980, 11236, 11492, 11748, 12004, 12260, 12516, 12772, 13028, 13284, 228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,   228,  228,   228,   228,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   16104, 232,  232,   232,   16360,
    13544, 13800, 14056, 14312, 14568, 14824, 15080, 15336, 15592, 15848, 232,   232,   232,  25576, 232,   232,
    232,   232,   488,   744,   1000,  1256,  1512,  1768,  2024,  2280,  2536,  2792,  3048, 3304,  3560,  3816,
    4072,  4328,  4584,  4840,  5096,  5352,  5608,  5864,  6120,  6376,  6632,  232,   232,  232,   232,   232,
    232,   6888,  7144,  7400,  7656,  7912,  8168,  8424,  8680,  8936,  9192,  9448,  9704, 9960,  10216, 10472,
    10728, 10984, 11240, 11496, 11752, 12008, 12264, 12520, 12776, 13032, 13288, 232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,   232,  232,   232,   232,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   16108, 236,  236,   236,   16364,
    13548, 13804, 14060, 14316, 14572, 14828, 15084, 15340, 15596, 15852, 236,   236,   236,  25580, 236,   236,
    236,   236,   492,   748,   1004,  1260,  1516,  1772,  2028,  2284,  2540,  2796,  3052, 3308,  3564,  3820,
    4076,  4332,  4588,  4844,  5100,  5356,  5612,  5868,  6124,  6380,  6636,  236,   236,  236,   236,   236,
    236,   6892,  7148,  7404,  7660,  7916,  8172,  8428,  8684,  8940,  9196,  9452,  9708, 9964,  10220, 10476,
    10732, 10988, 11244, 11500, 11756, 12012, 12268, 12524, 12780, 13036, 13292, 236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,   236,  236,   236,   236,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   16112, 240,  240,   240,   16368,
    13552, 13808, 14064, 14320, 14576, 14832, 15088, 15344, 15600, 15856, 240,   240,   240,  25584, 240,   240,
    240,   240,   496,   752,   1008,  1264,  1520,  1776,  2032,  2288,  2544,  2800,  3056, 3312,  3568,  3824,
    4080,  4336,  4592,  4848,  5104,  5360,  5616,  5872,  6128,  6384,  6640,  240,   240,  240,   240,   240,
    240,   6896,  7152,  7408,  7664,  7920,  8176,  8432,  8688,  8944,  9200,  9456,  9712, 9968,  10224, 10480,
    10736, 10992, 11248, 11504, 11760, 12016, 12272, 12528, 12784, 13040, 13296, 240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,   240,  240,   240,   240,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   16116, 244,  244,   244,   16372,
    13556, 13812, 14068, 14324, 14580, 14836, 15092, 15348, 15604, 15860, 244,   244,   244,  25588, 244,   244,
    244,   244,   500,   756,   1012,  1268,  1524,  1780,  2036,  2292,  2548,  2804,  3060, 3316,  3572,  3828,
    4084,  4340,  4596,  4852,  5108,  5364,  5620,  5876,  6132,  6388,  6644,  244,   244,  244,   244,   244,
    244,   6900,  7156,  7412,  7668,  7924,  8180,  8436,  8692,  8948,  9204,  9460,  9716, 9972,  10228, 10484,
    10740, 10996, 11252, 11508, 11764, 12020, 12276, 12532, 12788, 13044, 13300, 244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,   244,  244,   244,   244,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   16268, 396,  396,   396,   16268,
    13708, 13708, 14220, 14220, 14732, 14732, 15244, 15244, 15756, 15756, 396,   396,   396,  25484, 396,   396,
    396,   396,   396,   908,   908,   1420,  1420,  1932,  1932,  2444,  2444,  2956,  2956, 3468,  3468,  3980,
    3980,  4492,  4492,  5004,  5004,  5516,  5516,  6028,  6028,  6540,  6540,  396,   396,  396,   396,   396,
    396,   7052,  7052,  7564,  7564,  8076,  8076,  8588,  8588,  9100,  9100,  9612,  9612, 10124, 10124, 10636,
    10636, 11148, 11148, 11660, 11660, 12172, 12172, 12684, 12684, 13196, 13196, 396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,   396,  396,   396,   396,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     15876, 4,    4,     4,     16132,
    13316, 13572, 13828, 14084, 14340, 14596, 14852, 15108, 15364, 15620, 4,     4,     4,    25348, 4,     4,
    4,     4,     260,   516,   772,   1028,  1284,  1540,  1796,  2052,  2308,  2564,  2820, 3076,  3332,  3588,
    3844,  4100,  4356,  4612,  4868,  5124,  5380,  5636,  5892,  6148,  6404,  4,     4,    4,     4,     4,
    4,     6660,  6916,  7172,  7428,  7684,  7940,  8196,  8452,  8708,  8964,  9220,  9476, 9732,  9988,  10244,
    10500, 10756, 11012, 11268, 11524, 11780, 12036, 12292, 12548, 12804, 13060, 4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,    4,     4,     4,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     15880, 8,    8,     8,     16136,
    13320, 13576, 13832, 14088, 14344, 14600, 14856, 15112, 15368, 15624, 8,     8,     8,    25352, 8,     8,
    8,     8,     264,   520,   776,   1032,  1288,  1544,  1800,  2056,  2312,  2568,  2824, 3080,  3336,  3592,
    3848,  4104,  4360,  4616,  4872,  5128,  5384,  5640,  5896,  6152,  6408,  8,     8,    8,     8,     8,
    8,     6664,  6920,  7176,  7432,  7688,  7944,  8200,  8456,  8712,  8968,  9224,  9480, 9736,  9992,  10248,
    10504, 10760, 11016, 11272, 11528, 11784, 12040, 12296, 12552, 12808, 13064, 8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,    8,     8,     8,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    15884, 12,   12,    12,    16140,
    13324, 13580, 13836, 14092, 14348, 14604, 14860, 15116, 15372, 15628, 12,    12,    12,   25356, 12,    12,
    12,    12,    268,   524,   780,   1036,  1292,  1548,  1804,  2060,  2316,  2572,  2828, 3084,  3340,  3596,
    3852,  4108,  4364,  4620,  4876,  5132,  5388,  5644,  5900,  6156,  6412,  12,    12,   12,    12,    12,
    12,    6668,  6924,  7180,  7436,  7692,  7948,  8204,  8460,  8716,  8972,  9228,  9484, 9740,  9996,  10252,
    10508, 10764, 11020, 11276, 11532, 11788, 12044, 12300, 12556, 12812, 13068, 12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,    12,   12,    12,    12,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    15888, 16,   16,    16,    16144,
    13328, 13584, 13840, 14096, 14352, 14608, 14864, 15120, 15376, 15632, 16,    16,    16,   25360, 16,    16,
    16,    16,    272,   528,   784,   1040,  1296,  1552,  1808,  2064,  2320,  2576,  2832, 3088,  3344,  3600,
    3856,  4112,  4368,  4624,  4880,  5136,  5392,  5648,  5904,  6160,  6416,  16,    16,   16,    16,    16,
    16,    6672,  6928,  7184,  7440,  7696,  7952,  8208,  8464,  8720,  8976,  9232,  9488, 9744,  10000, 10256,
    10512, 10768, 11024, 11280, 11536, 11792, 12048, 12304, 12560, 12816, 13072, 16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,   16,    16,    16,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    15892, 20,   20,    20,    16148,
    13332, 13588, 13844, 14100, 14356, 14612, 14868, 15124, 15380, 15636, 20,    20,    20,   25364, 20,    20,
    20,    20,    276,   532,   788,   1044,  1300,  1556,  1812,  2068,  2324,  2580,  2836, 3092,  3348,  3604,
    3860,  4116,  4372,  4628,  4884,  5140,  5396,  5652,  5908,  6164,  6420,  20,    20,   20,    20,    20,
    20,    6676,  6932,  7188,  7444,  7700,  7956,  8212,  8468,  8724,  8980,  9236,  9492, 9748,  10004, 10260,
    10516, 10772, 11028, 11284, 11540, 11796, 12052, 12308, 12564, 12820, 13076, 20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,   20,    20,    20,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    15896, 24,   24,    24,    16152,
    13336, 13592, 13848, 14104, 14360, 14616, 14872, 15128, 15384, 15640, 24,    24,    24,   25368, 24,    24,
    24,    24,    280,   536,   792,   1048,  1304,  1560,  1816,  2072,  2328,  2584,  2840, 3096,  3352,  3608,
    3864,  4120,  4376,  4632,  4888,  5144,  5400,  5656,  5912,  6168,  6424,  24,    24,   24,    24,    24,
    24,    6680,  6936,  7192,  7448,  7704,  7960,  8216,  8472,  8728,  8984,  9240,  9496, 9752,  10008, 10264,
    10520, 10776, 11032, 11288, 11544, 11800, 12056, 12312, 12568, 12824, 13080, 24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,   24,    24,    24,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    15900, 28,   28,    28,    16156,
    13340, 13596, 13852, 14108, 14364, 14620, 14876, 15132, 15388, 15644, 28,    28,    28,   25372, 28,    28,
    28,    28,    284,   540,   796,   1052,  1308,  1564,  1820,  2076,  2332,  2588,  2844, 3100,  3356,  3612,
    3868,  4124,  4380,  4636,  4892,  5148,  5404,  5660,  5916,  6172,  6428,  28,    28,   28,    28,    28,
    28,    6684,  6940,  7196,  7452,  7708,  7964,  8220,  8476,  8732,  8988,  9244,  9500, 9756,  10012, 10268,
    10524, 10780, 11036, 11292, 11548, 11804, 12060, 12316, 12572, 12828, 13084, 28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,    28,   28,    28,    28,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    15904, 32,   32,    32,    16160,
    13344, 13600, 13856, 14112, 14368, 14624, 14880, 15136, 15392, 15648, 32,    32,    32,   25376, 32,    32,
    32,    32,    288,   544,   800,   1056,  1312,  1568,  1824,  2080,  2336,  2592,  2848, 3104,  3360,  3616,
    3872,  4128,  4384,  4640,  4896,  5152,  5408,  5664,  5920,  6176,  6432,  32,    32,   32,    32,    32,
    32,    6688,  6944,  7200,  7456,  7712,  7968,  8224,  8480,  8736,  8992,  9248,  9504, 9760,  10016, 10272,
    10528, 10784, 11040, 11296, 11552, 11808, 12064, 12320, 12576, 12832, 13088, 32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,   32,    32,    32,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    15908, 36,   36,    36,    16164,
    13348, 13604, 13860, 14116, 14372, 14628, 14884, 15140, 15396, 15652, 36,    36,    36,   25380, 36,    36,
    36,    36,    292,   548,   804,   1060,  1316,  1572,  1828,  2084,  2340,  2596,  2852, 3108,  3364,  3620,
    3876,  4132,  4388,  4644,  4900,  5156,  5412,  5668,  5924,  6180,  6436,  36,    36,   36,    36,    36,
    36,    6692,  6948,  7204,  7460,  7716,  7972,  8228,  8484,  8740,  8996,  9252,  9508, 9764,  10020, 10276,
    10532, 10788, 11044, 11300, 11556, 11812, 12068, 12324, 12580, 12836, 13092, 36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,   36,    36,    36,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    15912, 40,   40,    40,    16168,
    13352, 13608, 13864, 14120, 14376, 14632, 14888, 15144, 15400, 15656, 40,    40,    40,   25384, 40,    40,
    40,    40,    296,   552,   808,   1064,  1320,  1576,  1832,  2088,  2344,  2600,  2856, 3112,  3368,  3624,
    3880,  4136,  4392,  4648,  4904,  5160,  5416,  5672,  5928,  6184,  6440,  40,    40,   40,    40,    40,
    40,    6696,  6952,  7208,  7464,  7720,  7976,  8232,  8488,  8744,  9000,  9256,  9512, 9768,  10024, 10280,
    10536, 10792, 11048, 11304, 11560, 11816, 12072, 12328, 12584, 12840, 13096, 40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,   40,    40,    40,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    15916, 44,   44,    44,    16172,
    13356, 13612, 13868, 14124, 14380, 14636, 14892, 15148, 15404, 15660, 44,    44,    44,   25388, 44,    44,
    44,    44,    300,   556,   812,   1068,  1324,  1580,  1836,  2092,  2348,  2604,  2860, 3116,  3372,  3628,
    3884,  4140,  4396,  4652,  4908,  5164,  5420,  5676,  5932,  6188,  6444,  44,    44,   44,    44,    44,
    44,    6700,  6956,  7212,  7468,  7724,  7980,  8236,  8492,  8748,  9004,  9260,  9516, 9772,  10028, 10284,
    10540, 10796, 11052, 11308, 11564, 11820, 12076, 12332, 12588, 12844, 13100, 44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,   44,    44,    44,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    15920, 48,   48,    48,    16176,
    13360, 13616, 13872, 14128, 14384, 14640, 14896, 15152, 15408, 15664, 48,    48,    48,   25392, 48,    48,
    48,    48,    304,   560,   816,   1072,  1328,  1584,  1840,  2096,  2352,  2608,  2864, 3120,  3376,  3632,
    3888,  4144,  4400,  4656,  4912,  5168,  5424,  5680,  5936,  6192,  6448,  48,    48,   48,    48,    48,
    48,    6704,  6960,  7216,  7472,  7728,  7984,  8240,  8496,  8752,  9008,  9264,  9520, 9776,  10032, 10288,
    10544, 10800, 11056, 11312, 11568, 11824, 12080, 12336, 12592, 12848, 13104, 48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,   48,    48,    48,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    15924, 52,   52,    52,    16180,
    13364, 13620, 13876, 14132, 14388, 14644, 14900, 15156, 15412, 15668, 52,    52,    52,   25396, 52,    52,
    52,    52,    308,   564,   820,   1076,  1332,  1588,  1844,  2100,  2356,  2612,  2868, 3124,  3380,  3636,
    3892,  4148,  4404,  4660,  4916,  5172,  5428,  5684,  5940,  6196,  6452,  52,    52,   52,    52,    52,
    52,    6708,  6964,  7220,  7476,  7732,  7988,  8244,  8500,  8756,  9012,  9268,  9524, 9780,  10036, 10292,
    10548, 10804, 11060, 11316, 11572, 11828, 12084, 12340, 12596, 12852, 13108, 52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,   52,    52,    52,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    15928, 56,   56,    56,    16184,
    13368, 13624, 13880, 14136, 14392, 14648, 14904, 15160, 15416, 15672, 56,    56,    56,   25400, 56,    56,
    56,    56,    312,   568,   824,   1080,  1336,  1592,  1848,  2104,  2360,  2616,  2872, 3128,  3384,  3640,
    3896,  4152,  4408,  4664,  4920,  5176,  5432,  5688,  5944,  6200,  6456,  56,    56,   56,    56,    56,
    56,    6712,  6968,  7224,  7480,  7736,  7992,  8248,  8504,  8760,  9016,  9272,  9528, 9784,  10040, 10296,
    10552, 10808, 11064, 11320, 11576, 11832, 12088, 12344, 12600, 12856, 13112, 56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,    56,   56,    56,    56,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    15932, 60,   60,    60,    16188,
    13372, 13628, 13884, 14140, 14396, 14652, 14908, 15164, 15420, 15676, 60,    60,    60,   25404, 60,    60,
    60,    60,    316,   572,   828,   1084,  1340,  1596,  1852,  2108,  2364,  2620,  2876, 3132,  3388,  3644,
    3900,  4156,  4412,  4668,  4924,  5180,  5436,  5692,  5948,  6204,  6460,  60,    60,   60,    60,    60,
    60,    6716,  6972,  7228,  7484,  7740,  7996,  8252,  8508,  8764,  9020,  9276,  9532, 9788,  10044, 10300,
    10556, 10812, 11068, 11324, 11580, 11836, 12092, 12348, 12604, 12860, 13116, 60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,   60,    60,    60,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    15936, 64,   64,    64,    16192,
    13376, 13632, 13888, 14144, 14400, 14656, 14912, 15168, 15424, 15680, 64,    64,    64,   25408, 64,    64,
    64,    64,    320,   576,   832,   1088,  1344,  1600,  1856,  2112,  2368,  2624,  2880, 3136,  3392,  3648,
    3904,  4160,  4416,  4672,  4928,  5184,  5440,  5696,  5952,  6208,  6464,  64,    64,   64,    64,    64,
    64,    6720,  6976,  7232,  7488,  7744,  8000,  8256,  8512,  8768,  9024,  9280,  9536, 9792,  10048, 10304,
    10560, 10816, 11072, 11328, 11584, 11840, 12096, 12352, 12608, 12864, 13120, 64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,    64,   64,    64,    64,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    15940, 68,   68,    68,    16196,
    13380, 13636, 13892, 14148, 14404, 14660, 14916, 15172, 15428, 15684, 68,    68,    68,   25412, 68,    68,
    68,    68,    324,   580,   836,   1092,  1348,  1604,  1860,  2116,  2372,  2628,  2884, 3140,  3396,  3652,
    3908,  4164,  4420,  4676,  4932,  5188,  5444,  5700,  5956,  6212,  6468,  68,    68,   68,    68,    68,
    68,    6724,  6980,  7236,  7492,  7748,  8004,  8260,  8516,  8772,  9028,  9284,  9540, 9796,  10052, 10308,
    10564, 10820, 11076, 11332, 11588, 11844, 12100, 12356, 12612, 12868, 13124, 68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,   68,    68,    68,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    15944, 72,   72,    72,    16200,
    13384, 13640, 13896, 14152, 14408, 14664, 14920, 15176, 15432, 15688, 72,    72,    72,   25416, 72,    72,
    72,    72,    328,   584,   840,   1096,  1352,  1608,  1864,  2120,  2376,  2632,  2888, 3144,  3400,  3656,
    3912,  4168,  4424,  4680,  4936,  5192,  5448,  5704,  5960,  6216,  6472,  72,    72,   72,    72,    72,
    72,    6728,  6984,  7240,  7496,  7752,  8008,  8264,  8520,  8776,  9032,  9288,  9544, 9800,  10056, 10312,
    10568, 10824, 11080, 11336, 11592, 11848, 12104, 12360, 12616, 12872, 13128, 72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,    72,   72,    72,    72,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    15948, 76,   76,    76,    16204,
    13388, 13644, 13900, 14156, 14412, 14668, 14924, 15180, 15436, 15692, 76,    76,    76,   25420, 76,    76,
    76,    76,    332,   588,   844,   1100,  1356,  1612,  1868,  2124,  2380,  2636,  2892, 3148,  3404,  3660,
    3916,  4172,  4428,  4684,  4940,  5196,  5452,  5708,  5964,  6220,  6476,  76,    76,   76,    76,    76,
    76,    6732,  6988,  7244,  7500,  7756,  8012,  8268,  8524,  8780,  9036,  9292,  9548, 9804,  10060, 10316,
    10572, 10828, 11084, 11340, 11596, 11852, 12108, 12364, 12620, 12876, 13132, 76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,   76,    76,    76,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    15952, 80,   80,    80,    16208,
    13392, 13648, 13904, 14160, 14416, 14672, 14928, 15184, 15440, 15696, 80,    80,    80,   25424, 80,    80,
    80,    80,    336,   592,   848,   1104,  1360,  1616,  1872,  2128,  2384,  2640,  2896, 3152,  3408,  3664,
    3920,  4176,  4432,  4688,  4944,  5200,  5456,  5712,  5968,  6224,  6480,  80,    80,   80,    80,    80,
    80,    6736,  6992,  7248,  7504,  7760,  8016,  8272,  8528,  8784,  9040,  9296,  9552, 9808,  10064, 10320,
    10576, 10832, 11088, 11344, 11600, 11856, 12112, 12368, 12624, 12880, 13136, 80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,    80,   80,    80,    80,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    15956, 84,   84,    84,    16212,
    13396, 13652, 13908, 14164, 14420, 14676, 14932, 15188, 15444, 15700, 84,    84,    84,   25428, 84,    84,
    84,    84,    340,   596,   852,   1108,  1364,  1620,  1876,  2132,  2388,  2644,  2900, 3156,  3412,  3668,
    3924,  4180,  4436,  4692,  4948,  5204,  5460,  5716,  5972,  6228,  6484,  84,    84,   84,    84,    84,
    84,    6740,  6996,  7252,  7508,  7764,  8020,  8276,  8532,  8788,  9044,  9300,  9556, 9812,  10068, 10324,
    10580, 10836, 11092, 11348, 11604, 11860, 12116, 12372, 12628, 12884, 13140, 84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,    84,   84,    84,    84,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    15960, 88,   88,    88,    16216,
    13400, 13656, 13912, 14168, 14424, 14680, 14936, 15192, 15448, 15704, 88,    88,    88,   25432, 88,    88,
    88,    88,    344,   600,   856,   1112,  1368,  1624,  1880,  2136,  2392,  2648,  2904, 3160,  3416,  3672,
    3928,  4184,  4440,  4696,  4952,  5208,  5464,  5720,  5976,  6232,  6488,  88,    88,   88,    88,    88,
    88,    6744,  7000,  7256,  7512,  7768,  8024,  8280,  8536,  8792,  9048,  9304,  9560, 9816,  10072, 10328,
    10584, 10840, 11096, 11352, 11608, 11864, 12120, 12376, 12632, 12888, 13144, 88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,    88,   88,    88,    88,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    15964, 92,   92,    92,    16220,
    13404, 13660, 13916, 14172, 14428, 14684, 14940, 15196, 15452, 15708, 92,    92,    92,   25436, 92,    92,
    92,    92,    348,   604,   860,   1116,  1372,  1628,  1884,  2140,  2396,  2652,  2908, 3164,  3420,  3676,
    3932,  4188,  4444,  4700,  4956,  5212,  5468,  5724,  5980,  6236,  6492,  92,    92,   92,    92,    92,
    92,    6748,  7004,  7260,  7516,  7772,  8028,  8284,  8540,  8796,  9052,  9308,  9564, 9820,  10076, 10332,
    10588, 10844, 11100, 11356, 11612, 11868, 12124, 12380, 12636, 12892, 13148, 92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,   92,    92,    92,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    15968, 96,   96,    96,    16224,
    13408, 13664, 13920, 14176, 14432, 14688, 14944, 15200, 15456, 15712, 96,    96,    96,   25440, 96,    96,
    96,    96,    352,   608,   864,   1120,  1376,  1632,  1888,  2144,  2400,  2656,  2912, 3168,  3424,  3680,
    3936,  4192,  4448,  4704,  4960,  5216,  5472,  5728,  5984,  6240,  6496,  96,    96,   96,    96,    96,
    96,    6752,  7008,  7264,  7520,  7776,  8032,  8288,  8544,  8800,  9056,  9312,  9568, 9824,  10080, 10336,
    10592, 10848, 11104, 11360, 11616, 11872, 12128, 12384, 12640, 12896, 13152, 96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,    96,   96,    96,    96,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   15972, 100,  100,   100,   16228,
    13412, 13668, 13924, 14180, 14436, 14692, 14948, 15204, 15460, 15716, 100,   100,   100,  25444, 100,   100,
    100,   100,   356,   612,   868,   1124,  1380,  1636,  1892,  2148,  2404,  2660,  2916, 3172,  3428,  3684,
    3940,  4196,  4452,  4708,  4964,  5220,  5476,  5732,  5988,  6244,  6500,  100,   100,  100,   100,   100,
    100,   6756,  7012,  7268,  7524,  7780,  8036,  8292,  8548,  8804,  9060,  9316,  9572, 9828,  10084, 10340,
    10596, 10852, 11108, 11364, 11620, 11876, 12132, 12388, 12644, 12900, 13156, 100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,   100,  100,   100,   100,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   15976, 104,  104,   104,   16232,
    13416, 13672, 13928, 14184, 14440, 14696, 14952, 15208, 15464, 15720, 104,   104,   104,  25448, 104,   104,
    104,   104,   360,   616,   872,   1128,  1384,  1640,  1896,  2152,  2408,  2664,  2920, 3176,  3432,  3688,
    3944,  4200,  4456,  4712,  4968,  5224,  5480,  5736,  5992,  6248,  6504,  104,   104,  104,   104,   104,
    104,   6760,  7016,  7272,  7528,  7784,  8040,  8296,  8552,  8808,  9064,  9320,  9576, 9832,  10088, 10344,
    10600, 10856, 11112, 11368, 11624, 11880, 12136, 12392, 12648, 12904, 13160, 104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,   104,  104,   104,   104,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   15980, 108,  108,   108,   16236,
    13420, 13676, 13932, 14188, 14444, 14700, 14956, 15212, 15468, 15724, 108,   108,   108,  25452, 108,   108,
    108,   108,   364,   620,   876,   1132,  1388,  1644,  1900,  2156,  2412,  2668,  2924, 3180,  3436,  3692,
    3948,  4204,  4460,  4716,  4972,  5228,  5484,  5740,  5996,  6252,  6508,  108,   108,  108,   108,   108,
    108,   6764,  7020,  7276,  7532,  7788,  8044,  8300,  8556,  8812,  9068,  9324,  9580, 9836,  10092, 10348,
    10604, 10860, 11116, 11372, 11628, 11884, 12140, 12396, 12652, 12908, 13164, 108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,  108,   108,   108,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   15984, 112,  112,   112,   16240,
    13424, 13680, 13936, 14192, 14448, 14704, 14960, 15216, 15472, 15728, 112,   112,   112,  25456, 112,   112,
    112,   112,   368,   624,   880,   1136,  1392,  1648,  1904,  2160,  2416,  2672,  2928, 3184,  3440,  3696,
    3952,  4208,  4464,  4720,  4976,  5232,  5488,  5744,  6000,  6256,  6512,  112,   112,  112,   112,   112,
    112,   6768,  7024,  7280,  7536,  7792,  8048,  8304,  8560,  8816,  9072,  9328,  9584, 9840,  10096, 10352,
    10608, 10864, 11120, 11376, 11632, 11888, 12144, 12400, 12656, 12912, 13168, 112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,  112,   112,   112,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   15988, 116,  116,   116,   16244,
    13428, 13684, 13940, 14196, 14452, 14708, 14964, 15220, 15476, 15732, 116,   116,   116,  25460, 116,   116,
    116,   116,   372,   628,   884,   1140,  1396,  1652,  1908,  2164,  2420,  2676,  2932, 3188,  3444,  3700,
    3956,  4212,  4468,  4724,  4980,  5236,  5492,  5748,  6004,  6260,  6516,  116,   116,  116,   116,   116,
    116,   6772,  7028,  7284,  7540,  7796,  8052,  8308,  8564,  8820,  9076,  9332,  9588, 9844,  10100, 10356,
    10612, 10868, 11124, 11380, 11636, 11892, 12148, 12404, 12660, 12916, 13172, 116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,  116,   116,   116,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   15992, 120,  120,   120,   16248,
    13432, 13688, 13944, 14200, 14456, 14712, 14968, 15224, 15480, 15736, 120,   120,   120,  25464, 120,   120,
    120,   120,   376,   632,   888,   1144,  1400,  1656,  1912,  2168,  2424,  2680,  2936, 3192,  3448,  3704,
    3960,  4216,  4472,  4728,  4984,  5240,  5496,  5752,  6008,  6264,  6520,  120,   120,  120,   120,   120,
    120,   6776,  7032,  7288,  7544,  7800,  8056,  8312,  8568,  8824,  9080,  9336,  9592, 9848,  10104, 10360,
    10616, 10872, 11128, 11384, 11640, 11896, 12152, 12408, 12664, 12920, 13176, 120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,  120,   120,   120,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   15996, 124,  124,   124,   16252,
    13436, 13692, 13948, 14204, 14460, 14716, 14972, 15228, 15484, 15740, 124,   124,   124,  25468, 124,   124,
    124,   124,   380,   636,   892,   1148,  1404,  1660,  1916,  2172,  2428,  2684,  2940, 3196,  3452,  3708,
    3964,  4220,  4476,  4732,  4988,  5244,  5500,  5756,  6012,  6268,  6524,  124,   124,  124,   124,   124,
    124,   6780,  7036,  7292,  7548,  7804,  8060,  8316,  8572,  8828,  9084,  9340,  9596, 9852,  10108, 10364,
    10620, 10876, 11132, 11388, 11644, 11900, 12156, 12412, 12668, 12924, 13180, 124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,   124,  124,   124,   124,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   16000, 128,  128,   128,   16256,
    13440, 13696, 13952, 14208, 14464, 14720, 14976, 15232, 15488, 15744, 128,   128,   128,  25472, 128,   128,
    128,   128,   384,   640,   896,   1152,  1408,  1664,  1920,  2176,  2432,  2688,  2944, 3200,  3456,  3712,
    3968,  4224,  4480,  4736,  4992,  5248,  5504,  5760,  6016,  6272,  6528,  128,   128,  128,   128,   128,
    128,   6784,  7040,  7296,  7552,  7808,  8064,  8320,  8576,  8832,  9088,  9344,  9600, 9856,  10112, 10368,
    10624, 10880, 11136, 11392, 11648, 11904, 12160, 12416, 12672, 12928, 13184, 128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,   128,  128,   128,   128,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   16004, 132,  132,   132,   16260,
    13444, 13700, 13956, 14212, 14468, 14724, 14980, 15236, 15492, 15748, 132,   132,   132,  25476, 132,   132,
    132,   132,   388,   644,   900,   1156,  1412,  1668,  1924,  2180,  2436,  2692,  2948, 3204,  3460,  3716,
    3972,  4228,  4484,  4740,  4996,  5252,  5508,  5764,  6020,  6276,  6532,  132,   132,  132,   132,   132,
    132,   6788,  7044,  7300,  7556,  7812,  8068,  8324,  8580,  8836,  9092,  9348,  9604, 9860,  10116, 10372,
    10628, 10884, 11140, 11396, 11652, 11908, 12164, 12420, 12676, 12932, 13188, 132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,   132,  132,   132,   132,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   16008, 136,  136,   136,   16264,
    13448, 13704, 13960, 14216, 14472, 14728, 14984, 15240, 15496, 15752, 136,   136,   136,  25480, 136,   136,
    136,   136,   392,   648,   904,   1160,  1416,  1672,  1928,  2184,  2440,  2696,  2952, 3208,  3464,  3720,
    3976,  4232,  4488,  4744,  5000,  5256,  5512,  5768,  6024,  6280,  6536,  136,   136,  136,   136,   136,
    136,   6792,  7048,  7304,  7560,  7816,  8072,  8328,  8584,  8840,  9096,  9352,  9608, 9864,  10120, 10376,
    10632, 10888, 11144, 11400, 11656, 11912, 12168, 12424, 12680, 12936, 13192, 136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,   136,  136,   136,   136,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   16012, 140,  140,   140,   16268,
    13452, 13708, 13964, 14220, 14476, 14732, 14988, 15244, 15500, 15756, 140,   140,   140,  25484, 140,   140,
    140,   140,   396,   652,   908,   1164,  1420,  1676,  1932,  2188,  2444,  2700,  2956, 3212,  3468,  3724,
    3980,  4236,  4492,  4748,  5004,  5260,  5516,  5772,  6028,  6284,  6540,  140,   140,  140,   140,   140,
    140,   6796,  7052,  7308,  7564,  7820,  8076,  8332,  8588,  8844,  9100,  9356,  9612, 9868,  10124, 10380,
    10636, 10892, 11148, 11404, 11660, 11916, 12172, 12428, 12684, 12940, 13196, 140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,   140,  140,   140,   140,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   16016, 144,  144,   144,   16272,
    13456, 13712, 13968, 14224, 14480, 14736, 14992, 15248, 15504, 15760, 144,   144,   144,  25488, 144,   144,
    144,   144,   400,   656,   912,   1168,  1424,  1680,  1936,  2192,  2448,  2704,  2960, 3216,  3472,  3728,
    3984,  4240,  4496,  4752,  5008,  5264,  5520,  5776,  6032,  6288,  6544,  144,   144,  144,   144,   144,
    144,   6800,  7056,  7312,  7568,  7824,  8080,  8336,  8592,  8848,  9104,  9360,  9616, 9872,  10128, 10384,
    10640, 10896, 11152, 11408, 11664, 11920, 12176, 12432, 12688, 12944, 13200, 144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,   144,  144,   144,   144,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   16020, 148,  148,   148,   16276,
    13460, 13716, 13972, 14228, 14484, 14740, 14996, 15252, 15508, 15764, 148,   148,   148,  25492, 148,   148,
    148,   148,   404,   660,   916,   1172,  1428,  1684,  1940,  2196,  2452,  2708,  2964, 3220,  3476,  3732,
    3988,  4244,  4500,  4756,  5012,  5268,  5524,  5780,  6036,  6292,  6548,  148,   148,  148,   148,   148,
    148,   6804,  7060,  7316,  7572,  7828,  8084,  8340,  8596,  8852,  9108,  9364,  9620, 9876,  10132, 10388,
    10644, 10900, 11156, 11412, 11668, 11924, 12180, 12436, 12692, 12948, 13204, 148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,   148,  148,   148,   148,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   16024, 152,  152,   152,   16280,
    13464, 13720, 13976, 14232, 14488, 14744, 15000, 15256, 15512, 15768, 152,   152,   152,  25496, 152,   152,
    152,   152,   408,   664,   920,   1176,  1432,  1688,  1944,  2200,  2456,  2712,  2968, 3224,  3480,  3736,
    3992,  4248,  4504,  4760,  5016,  5272,  5528,  5784,  6040,  6296,  6552,  152,   152,  152,   152,   152,
    152,   6808,  7064,  7320,  7576,  7832,  8088,  8344,  8600,  8856,  9112,  9368,  9624, 9880,  10136, 10392,
    10648, 10904, 11160, 11416, 11672, 11928, 12184, 12440, 12696, 12952, 13208, 152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,   152,  152,   152,   152,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   16028, 156,  156,   156,   16284,
    13468, 13724, 13980, 14236, 14492, 14748, 15004, 15260, 15516, 15772, 156,   156,   156,  25500, 156,   156,
    156,   156,   412,   668,   924,   1180,  1436,  1692,  1948,  2204,  2460,  2716,  2972, 3228,  3484,  3740,
    3996,  4252,  4508,  4764,  5020,  5276,  5532,  5788,  6044,  6300,  6556,  156,   156,  156,   156,   156,
    156,   6812,  7068,  7324,  7580,  7836,  8092,  8348,  8604,  8860,  9116,  9372,  9628, 9884,  10140, 10396,
    10652, 10908, 11164, 11420, 11676, 11932, 12188, 12444, 12700, 12956, 13212, 156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,   156,  156,   156,   156,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   16032, 160,  160,   160,   16288,
    13472, 13728, 13984, 14240, 14496, 14752, 15008, 15264, 15520, 15776, 160,   160,   160,  25504, 160,   160,
    160,   160,   416,   672,   928,   1184,  1440,  1696,  1952,  2208,  2464,  2720,  2976, 3232,  3488,  3744,
    4000,  4256,  4512,  4768,  5024,  5280,  5536,  5792,  6048,  6304,  6560,  160,   160,  160,   160,   160,
    160,   6816,  7072,  7328,  7584,  7840,  8096,  8352,  8608,  8864,  9120,  9376,  9632, 9888,  10144, 10400,
    10656, 10912, 11168, 11424, 11680, 11936, 12192, 12448, 12704, 12960, 13216, 160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,   160,  160,   160,   160,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   16036, 164,  164,   164,   16292,
    13476, 13732, 13988, 14244, 14500, 14756, 15012, 15268, 15524, 15780, 164,   164,   164,  25508, 164,   164,
    164,   164,   420,   676,   932,   1188,  1444,  1700,  1956,  2212,  2468,  2724,  2980, 3236,  3492,  3748,
    4004,  4260,  4516,  4772,  5028,  5284,  5540,  5796,  6052,  6308,  6564,  164,   164,  164,   164,   164,
    164,   6820,  7076,  7332,  7588,  7844,  8100,  8356,  8612,  8868,  9124,  9380,  9636, 9892,  10148, 10404,
    10660, 10916, 11172, 11428, 11684, 11940, 12196, 12452, 12708, 12964, 13220, 164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,   164,  164,   164,   164,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   16040, 168,  168,   168,   16296,
    13480, 13736, 13992, 14248, 14504, 14760, 15016, 15272, 15528, 15784, 168,   168,   168,  25512, 168,   168,
    168,   168,   424,   680,   936,   1192,  1448,  1704,  1960,  2216,  2472,  2728,  2984, 3240,  3496,  3752,
    4008,  4264,  4520,  4776,  5032,  5288,  5544,  5800,  6056,  6312,  6568,  168,   168,  168,   168,   168,
    168,   6824,  7080,  7336,  7592,  7848,  8104,  8360,  8616,  8872,  9128,  9384,  9640, 9896,  10152, 10408,
    10664, 10920, 11176, 11432, 11688, 11944, 12200, 12456, 12712, 12968, 13224, 168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,   168,  168,   168,   168,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   16044, 172,  172,   172,   16300,
    13484, 13740, 13996, 14252, 14508, 14764, 15020, 15276, 15532, 15788, 172,   172,   172,  25516, 172,   172,
    172,   172,   428,   684,   940,   1196,  1452,  1708,  1964,  2220,  2476,  2732,  2988, 3244,  3500,  3756,
    4012,  4268,  4524,  4780,  5036,  5292,  5548,  5804,  6060,  6316,  6572,  172,   172,  172,   172,   172,
    172,   6828,  7084,  7340,  7596,  7852,  8108,  8364,  8620,  8876,  9132,  9388,  9644, 9900,  10156, 10412,
    10668, 10924, 11180, 11436, 11692, 11948, 12204, 12460, 12716, 12972, 13228, 172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,   172,  172,   172,   172,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   16048, 176,  176,   176,   16304,
    13488, 13744, 14000, 14256, 14512, 14768, 15024, 15280, 15536, 15792, 176,   176,   176,  25520, 176,   176,
    176,   176,   432,   688,   944,   1200,  1456,  1712,  1968,  2224,  2480,  2736,  2992, 3248,  3504,  3760,
    4016,  4272,  4528,  4784,  5040,  5296,  5552,  5808,  6064,  6320,  6576,  176,   176,  176,   176,   176,
    176,   6832,  7088,  7344,  7600,  7856,  8112,  8368,  8624,  8880,  9136,  9392,  9648, 9904,  10160, 10416,
    10672, 10928, 11184, 11440, 11696, 11952, 12208, 12464, 12720, 12976, 13232, 176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,   176,  176,   176,   176,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   16052, 180,  180,   180,   16308,
    13492, 13748, 14004, 14260, 14516, 14772, 15028, 15284, 15540, 15796, 180,   180,   180,  25524, 180,   180,
    180,   180,   436,   692,   948,   1204,  1460,  1716,  1972,  2228,  2484,  2740,  2996, 3252,  3508,  3764,
    4020,  4276,  4532,  4788,  5044,  5300,  5556,  5812,  6068,  6324,  6580,  180,   180,  180,   180,   180,
    180,   6836,  7092,  7348,  7604,  7860,  8116,  8372,  8628,  8884,  9140,  9396,  9652, 9908,  10164, 10420,
    10676, 10932, 11188, 11444, 11700, 11956, 12212, 12468, 12724, 12980, 13236, 180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,   180,  180,   180,   180,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   16056, 184,  184,   184,   16312,
    13496, 13752, 14008, 14264, 14520, 14776, 15032, 15288, 15544, 15800, 184,   184,   184,  25528, 184,   184,
    184,   184,   440,   696,   952,   1208,  1464,  1720,  1976,  2232,  2488,  2744,  3000, 3256,  3512,  3768,
    4024,  4280,  4536,  4792,  5048,  5304,  5560,  5816,  6072,  6328,  6584,  184,   184,  184,   184,   184,
    184,   6840,  7096,  7352,  7608,  7864,  8120,  8376,  8632,  8888,  9144,  9400,  9656, 9912,  10168, 10424,
    10680, 10936, 11192, 11448, 11704, 11960, 12216, 12472, 12728, 12984, 13240, 184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,   184,  184,   184,   184,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   16060, 188,  188,   188,   16316,
    13500, 13756, 14012, 14268, 14524, 14780, 15036, 15292, 15548, 15804, 188,   188,   188,  25532, 188,   188,
    188,   188,   444,   700,   956,   1212,  1468,  1724,  1980,  2236,  2492,  2748,  3004, 3260,  3516,  3772,
    4028,  4284,  4540,  4796,  5052,  5308,  5564,  5820,  6076,  6332,  6588,  188,   188,  188,   188,   188,
    188,   6844,  7100,  7356,  7612,  7868,  8124,  8380,  8636,  8892,  9148,  9404,  9660, 9916,  10172, 10428,
    10684, 10940, 11196, 11452, 11708, 11964, 12220, 12476, 12732, 12988, 13244, 188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,   188,  188,   188,   188,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   16064, 192,  192,   192,   16320,
    13504, 13760, 14016, 14272, 14528, 14784, 15040, 15296, 15552, 15808, 192,   192,   192,  25536, 192,   192,
    192,   192,   448,   704,   960,   1216,  1472,  1728,  1984,  2240,  2496,  2752,  3008, 3264,  3520,  3776,
    4032,  4288,  4544,  4800,  5056,  5312,  5568,  5824,  6080,  6336,  6592,  192,   192,  192,   192,   192,
    192,   6848,  7104,  7360,  7616,  7872,  8128,  8384,  8640,  8896,  9152,  9408,  9664, 9920,  10176, 10432,
    10688, 10944, 11200, 11456, 11712, 11968, 12224, 12480, 12736, 12992, 13248, 192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,   192,  192,   192,   192,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   16068, 196,  196,   196,   16324,
    13508, 13764, 14020, 14276, 14532, 14788, 15044, 15300, 15556, 15812, 196,   196,   196,  25540, 196,   196,
    196,   196,   452,   708,   964,   1220,  1476,  1732,  1988,  2244,  2500,  2756,  3012, 3268,  3524,  3780,
    4036,  4292,  4548,  4804,  5060,  5316,  5572,  5828,  6084,  6340,  6596,  196,   196,  196,   196,   196,
    196,   6852,  7108,  7364,  7620,  7876,  8132,  8388,  8644,  8900,  9156,  9412,  9668, 9924,  10180, 10436,
    10692, 10948, 11204, 11460, 11716, 11972, 12228, 12484, 12740, 12996, 13252, 196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,   196,  196,   196,   196,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   16072, 200,  200,   200,   16328,
    13512, 13768, 14024, 14280, 14536, 14792, 15048, 15304, 15560, 15816, 200,   200,   200,  25544, 200,   200,
    200,   200,   456,   712,   968,   1224,  1480,  1736,  1992,  2248,  2504,  2760,  3016, 3272,  3528,  3784,
    4040,  4296,  4552,  4808,  5064,  5320,  5576,  5832,  6088,  6344,  6600,  200,   200,  200,   200,   200,
    200,   6856,  7112,  7368,  7624,  7880,  8136,  8392,  8648,  8904,  9160,  9416,  9672, 9928,  10184, 10440,
    10696, 10952, 11208, 11464, 11720, 11976, 12232, 12488, 12744, 13000, 13256, 200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,  200,   200,   200,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   16076, 204,  204,   204,   16332,
    13516, 13772, 14028, 14284, 14540, 14796, 15052, 15308, 15564, 15820, 204,   204,   204,  25548, 204,   204,
    204,   204,   460,   716,   972,   1228,  1484,  1740,  1996,  2252,  2508,  2764,  3020, 3276,  3532,  3788,
    4044,  4300,  4556,  4812,  5068,  5324,  5580,  5836,  6092,  6348,  6604,  204,   204,  204,   204,   204,
    204,   6860,  7116,  7372,  7628,  7884,  8140,  8396,  8652,  8908,  9164,  9420,  9676, 9932,  10188, 10444,
    10700, 10956, 11212, 11468, 11724, 11980, 12236, 12492, 12748, 13004, 13260, 204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,   204,  204,   204,   204,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     15872, 0,    0,     0,     16128,
    13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 0,     0,     0,    25344, 0,     0,
    0,     0,     256,   512,   768,   1024,  1280,  1536,  1792,  2048,  2304,  2560,  2816, 3072,  3328,  3584,
    3840,  4096,  4352,  4608,  4864,  5120,  5376,  5632,  5888,  6144,  6400,  0,     0,    0,     0,     0,
    0,     6656,  6912,  7168,  7424,  7680,  7936,  8192,  8448,  8704,  8960,  9216,  9472, 9728,  9984,  10240,
    10496, 10752, 11008, 11264, 11520, 11776, 12032, 12288, 12544, 12800, 13056, 0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,     0,     0
};
