/* Image.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Image.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_PLUGIN (enotes_plugin_get_type ())
#define ENOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN, ENotesPlugin))
#define ENOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN, ENotesPluginClass))
#define ENOTES_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN))
#define ENOTES_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN))
#define ENOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN, ENotesPluginClass))

typedef struct _ENotesPlugin ENotesPlugin;
typedef struct _ENotesPluginClass ENotesPluginClass;
typedef struct _ENotesPluginPrivate ENotesPluginPrivate;

#define TYPE_BL_MEMBER (bl_member_get_type ())
#define BL_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BL_MEMBER, BLMember))
#define BL_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BL_MEMBER, BLMemberClass))
#define IS_BL_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BL_MEMBER))
#define IS_BL_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BL_MEMBER))
#define BL_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BL_MEMBER, BLMemberClass))

typedef struct _BLMember BLMember;
typedef struct _BLMemberClass BLMemberClass;

#define ENOTES_TYPE_IMAGE_PLUGIN (enotes_image_plugin_get_type ())
#define ENOTES_IMAGE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE_PLUGIN, ENotesImagePlugin))
#define ENOTES_IMAGE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE_PLUGIN, ENotesImagePluginClass))
#define ENOTES_IS_IMAGE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE_PLUGIN))
#define ENOTES_IS_IMAGE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE_PLUGIN))
#define ENOTES_IMAGE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE_PLUGIN, ENotesImagePluginClass))

typedef struct _ENotesImagePlugin ENotesImagePlugin;
typedef struct _ENotesImagePluginClass ENotesImagePluginClass;
typedef struct _ENotesImagePluginPrivate ENotesImagePluginPrivate;
enum  {
	ENOTES_IMAGE_PLUGIN_0_PROPERTY,
	ENOTES_IMAGE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* enotes_image_plugin_properties[ENOTES_IMAGE_PLUGIN_NUM_PROPERTIES];
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_IMAGE_TABLE (enotes_image_table_get_type ())
#define ENOTES_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTable))
#define ENOTES_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))
#define ENOTES_IS_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IS_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IMAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))

typedef struct _ENotesImageTable ENotesImageTable;
typedef struct _ENotesImageTableClass ENotesImageTableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;

#define ENOTES_TYPE_IMAGE (enotes_image_get_type ())
#define ENOTES_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE, ENotesImage))
#define ENOTES_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE, ENotesImageClass))
#define ENOTES_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE))
#define ENOTES_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE))
#define ENOTES_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE, ENotesImageClass))

typedef struct _ENotesImage ENotesImage;
typedef struct _ENotesImageClass ENotesImageClass;
typedef struct _ENotesImagePrivate ENotesImagePrivate;
typedef enum  {
	ENOTES_IMAGE_FORMAT_PNG = 0,
	ENOTES_IMAGE_FORMAT_SVG = 1
} ENotesImageFormat;

#define ENOTES_TYPE_IMAGE_FORMAT (enotes_image_format_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _bl_member_unref0(var) ((var == NULL) ? NULL : (var = (bl_member_unref (var), NULL)))

struct _ENotesPlugin {
	GObject parent_instance;
	ENotesPluginPrivate * priv;
	gboolean state;
	gchar* code_name;
};

struct _ENotesPluginClass {
	GObjectClass parent_class;
	gchar* (*get_desctiption) (ENotesPlugin* self);
	gchar* (*get_name) (ENotesPlugin* self);
	gboolean (*has_match) (ENotesPlugin* self, const gchar* text);
	gchar* (*convert) (ENotesPlugin* self, const gchar* line);
	GtkWidget* (*editor_button) (ENotesPlugin* self);
	gchar* (*get_button_desctiption) (ENotesPlugin* self);
	gchar* (*request_string) (ENotesPlugin* self, const gchar* selection);
	GeeList* (*get_blacklist_members) (ENotesPlugin* self);
};

struct _ENotesImagePlugin {
	ENotesPlugin parent_instance;
	ENotesImagePluginPrivate * priv;
};

struct _ENotesImagePluginClass {
	ENotesPluginClass parent_class;
};

struct _ENotesImagePluginPrivate {
	GPatternSpec* spec;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _ENotesImage {
	GObject parent_instance;
	ENotesImagePrivate * priv;
	gint64 id;
	ENotesImageFormat format;
	gchar* data;
};

struct _ENotesImageClass {
	GObjectClass parent_class;
};

static gint ENotesImagePlugin_private_offset;
static gpointer enotes_image_plugin_parent_class = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPlugin, g_object_unref)
VALA_EXTERN gpointer bl_member_ref (gpointer instance);
VALA_EXTERN void bl_member_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_bl_member (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_bl_member (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_bl_member (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_bl_member (const GValue* value);
VALA_EXTERN GType bl_member_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BLMember, bl_member_unref)
VALA_EXTERN GType enotes_image_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImagePlugin, g_object_unref)
VALA_EXTERN gchar* enotes_plugin_get_desctiption (ENotesPlugin* self);
VALA_EXTERN gchar* enotes_plugin_get_name (ENotesPlugin* self);
VALA_EXTERN GtkWidget* enotes_plugin_editor_button (ENotesPlugin* self);
VALA_EXTERN gchar* enotes_plugin_request_string (ENotesPlugin* self,
                                     const gchar* selection);
VALA_EXTERN gchar* enotes_plugin_get_button_desctiption (ENotesPlugin* self);
VALA_EXTERN gboolean enotes_plugin_has_match (ENotesPlugin* self,
                                  const gchar* text);
VALA_EXTERN gchar* enotes_plugin_convert (ENotesPlugin* self,
                              const gchar* line);
VALA_EXTERN GeeList* enotes_plugin_get_blacklist_members (ENotesPlugin* self);
static gchar* enotes_image_plugin_real_get_desctiption (ENotesPlugin* base);
static gchar* enotes_image_plugin_real_get_name (ENotesPlugin* base);
static GtkWidget* enotes_image_plugin_real_editor_button (ENotesPlugin* base);
static gchar* enotes_image_plugin_real_request_string (ENotesPlugin* base,
                                                const gchar* selection);
static gchar* enotes_image_plugin_real_get_button_desctiption (ENotesPlugin* base);
static gboolean enotes_image_plugin_real_has_match (ENotesPlugin* base,
                                             const gchar* text);
static gchar* enotes_image_plugin_real_convert (ENotesPlugin* base,
                                         const gchar* _line);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_image_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImageTable, database_table_unref)
VALA_EXTERN ENotesImageTable* enotes_image_table_get_instance (void);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
VALA_EXTERN GType enotes_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImage, g_object_unref)
VALA_EXTERN ENotesImage* enotes_image_table_get_image (ENotesImageTable* self,
                                           gint64 page_id,
                                           gint64 photo_id);
VALA_EXTERN gchar* enotes_image_format_get_data (gint64 format);
VALA_EXTERN GType enotes_image_format_get_type (void) G_GNUC_CONST ;
static GeeList* enotes_image_plugin_real_get_blacklist_members (ENotesPlugin* base);
VALA_EXTERN BLMember* bl_member_new (GRegex* reg,
                         const gchar* replace);
VALA_EXTERN BLMember* bl_member_construct (GType object_type,
                               GRegex* reg,
                               const gchar* replace);
VALA_EXTERN ENotesImagePlugin* enotes_image_plugin_new (void);
VALA_EXTERN ENotesImagePlugin* enotes_image_plugin_construct (GType object_type);
VALA_EXTERN ENotesPlugin* enotes_plugin_construct (GType object_type);
static GObject * enotes_image_plugin_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void enotes_image_plugin_finalize (GObject * obj);
static GType enotes_image_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
enotes_image_plugin_get_instance_private (ENotesImagePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesImagePlugin_private_offset);
}

static gchar*
enotes_image_plugin_real_get_desctiption (ENotesPlugin* base)
{
	ENotesImagePlugin * self;
	gchar* _tmp0_;
	gchar* result;
#line 27 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 28 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = g_strdup (_ ("Load an embeded image"));
#line 28 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = _tmp0_;
#line 28 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 361 "Image.c"
}

static gchar*
enotes_image_plugin_real_get_name (ENotesPlugin* base)
{
	ENotesImagePlugin * self;
	gchar* _tmp0_;
	gchar* result;
#line 31 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 32 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = g_strdup (_ ("Image"));
#line 32 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = _tmp0_;
#line 32 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 378 "Image.c"
}

static GtkWidget*
enotes_image_plugin_real_editor_button (ENotesPlugin* base)
{
	ENotesImagePlugin * self;
	GtkWidget* result;
#line 35 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 36 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = NULL;
#line 36 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 392 "Image.c"
}

static gchar*
enotes_image_plugin_real_request_string (ENotesPlugin* base,
                                         const gchar* selection)
{
	ENotesImagePlugin * self;
	gchar* _tmp0_;
	gchar* result;
#line 40 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 40 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 41 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = g_strdup (selection);
#line 41 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = _tmp0_;
#line 41 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 412 "Image.c"
}

static gchar*
enotes_image_plugin_real_get_button_desctiption (ENotesPlugin* base)
{
	ENotesImagePlugin * self;
	gchar* _tmp0_;
	gchar* result;
#line 44 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 45 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = g_strdup ("");
#line 45 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = _tmp0_;
#line 45 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 429 "Image.c"
}

static gboolean
enotes_image_plugin_real_has_match (ENotesPlugin* base,
                                    const gchar* text)
{
	ENotesImagePlugin * self;
	GPatternSpec* _tmp0_;
	gboolean result;
#line 48 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 48 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 49 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = self->priv->spec;
#line 49 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = g_pattern_match_string (_tmp0_, text);
#line 49 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 449 "Image.c"
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
#line 778 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 779 "glib-2.0.vapi"
	result = g_ascii_strtoll (str, NULL, _base);
#line 779 "glib-2.0.vapi"
	return result;
#line 463 "Image.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 485 "Image.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 489 "Image.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 495 "Image.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 499 "Image.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 503 "Image.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 511 "Image.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 539 "Image.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 548 "Image.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 562 "Image.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 571 "Image.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 585 "Image.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 594 "Image.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 603 "Image.c"
}

static gchar*
enotes_image_plugin_real_convert (ENotesPlugin* base,
                                  const gchar* _line)
{
	ENotesImagePlugin * self;
	ENotesImageTable* image_table = NULL;
	ENotesImageTable* _tmp0_;
	gint64 image_id = 0LL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint64 _tmp7_;
	gint64 page_id = 0LL;
	ENotesApplication* _tmp8_;
	ENotesApplicationState* _tmp9_;
	ENotesPage* _tmp10_;
	ENotesPage* _tmp11_;
	ENotesImage* image = NULL;
	ENotesImageTable* _tmp12_;
	ENotesImage* _tmp13_;
	GString* data = NULL;
	GString* _tmp14_;
	ENotesImage* _tmp15_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* result;
#line 52 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 52 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	g_return_val_if_fail (_line != NULL, NULL);
#line 53 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = enotes_image_table_get_instance ();
#line 53 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	image_table = _tmp0_;
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_line, "<image ", 0);
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp3_ = _tmp2_;
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp4_ = _tmp3_[1];
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp5_ = string_replace (_tmp4_, ">", "");
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp6_ = _tmp5_;
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp7_ = int64_parse (_tmp6_, (guint) 0);
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_g_free0 (_tmp6_);
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 54 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	image_id = _tmp7_;
#line 55 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp8_ = enotes_app;
#line 55 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp9_ = _tmp8_->state;
#line 55 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp10_ = enotes_application_state_get_opened_page (_tmp9_);
#line 55 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp11_ = _tmp10_;
#line 55 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	page_id = _tmp11_->id;
#line 56 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp12_ = image_table;
#line 56 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp13_ = enotes_image_table_get_image (_tmp12_, page_id, image_id);
#line 56 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	image = _tmp13_;
#line 58 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp14_ = g_string_new ("");
#line 58 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	data = _tmp14_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp15_ = image;
#line 59 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	if (_tmp15_ != NULL) {
#line 689 "Image.c"
		GString* _tmp16_;
		ENotesImage* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GString* _tmp22_;
		ENotesImage* _tmp23_;
		const gchar* _tmp24_;
		GString* _tmp25_;
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp16_ = data;
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp17_ = image;
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp18_ = enotes_image_format_get_data ((gint64) _tmp17_->format);
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp19_ = _tmp18_;
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp20_ = g_strdup_printf ("<img src=\'%s,", _tmp19_);
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp21_ = _tmp20_;
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		g_string_append (_tmp16_, _tmp21_);
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_g_free0 (_tmp21_);
#line 60 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_g_free0 (_tmp19_);
#line 61 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp22_ = data;
#line 61 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp23_ = image;
#line 61 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp24_ = _tmp23_->data;
#line 61 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		g_string_append (_tmp22_, _tmp24_);
#line 62 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		_tmp25_ = data;
#line 62 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		g_string_append (_tmp25_, "\'>");
#line 730 "Image.c"
	}
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp26_ = data;
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp27_ = _tmp26_->str;
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp28_ = g_strdup (_tmp27_);
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = _tmp28_;
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_g_string_free0 (data);
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_g_object_unref0 (image);
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_database_table_unref0 (image_table);
#line 65 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 748 "Image.c"
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 762 "Image.c"
	}
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return *re;
#line 766 "Image.c"
}

static GeeList*
enotes_image_plugin_real_get_blacklist_members (ENotesPlugin* base)
{
	ENotesImagePlugin * self;
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	BLMember* _tmp1_;
	BLMember* _tmp2_;
	GeeList* result;
#line 68 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) base;
#line 69 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = gee_linked_list_new (TYPE_BL_MEMBER, (GBoxedCopyFunc) bl_member_ref, (GDestroyNotify) bl_member_unref, NULL, NULL, NULL);
#line 69 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	list = _tmp0_;
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp1_ = bl_member_new (_thread_safe_regex_init (&_tmp_regex_0, "<image \\d+>", 0), "");
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp2_ = _tmp1_;
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp2_);
#line 70 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_bl_member_unref0 (_tmp2_);
#line 71 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	result = (GeeList*) list;
#line 71 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return result;
#line 796 "Image.c"
}

ENotesImagePlugin*
enotes_image_plugin_construct (GType object_type)
{
	ENotesImagePlugin * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = (ENotesImagePlugin*) enotes_plugin_construct (object_type);
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return self;
#line 807 "Image.c"
}

ENotesImagePlugin*
enotes_image_plugin_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return enotes_image_plugin_construct (ENOTES_TYPE_IMAGE_PLUGIN);
#line 815 "Image.c"
}

static GObject *
enotes_image_plugin_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesImagePlugin * self;
#line 25 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	parent_class = G_OBJECT_CLASS (enotes_image_plugin_parent_class);
#line 25 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 25 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_IMAGE_PLUGIN, ENotesImagePlugin);
#line 25 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	return obj;
#line 834 "Image.c"
}

static void
enotes_image_plugin_class_init (ENotesImagePluginClass * klass,
                                gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	enotes_image_plugin_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	g_type_class_adjust_private_offset (klass, &ENotesImagePlugin_private_offset);
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->get_desctiption = (gchar* (*) (ENotesPlugin*)) enotes_image_plugin_real_get_desctiption;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->get_name = (gchar* (*) (ENotesPlugin*)) enotes_image_plugin_real_get_name;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->editor_button = (GtkWidget* (*) (ENotesPlugin*)) enotes_image_plugin_real_editor_button;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->request_string = (gchar* (*) (ENotesPlugin*, const gchar*)) enotes_image_plugin_real_request_string;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->get_button_desctiption = (gchar* (*) (ENotesPlugin*)) enotes_image_plugin_real_get_button_desctiption;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->has_match = (gboolean (*) (ENotesPlugin*, const gchar*)) enotes_image_plugin_real_has_match;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->convert = (gchar* (*) (ENotesPlugin*, const gchar*)) enotes_image_plugin_real_convert;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	((ENotesPluginClass *) klass)->get_blacklist_members = (GeeList* (*) (ENotesPlugin*)) enotes_image_plugin_real_get_blacklist_members;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_image_plugin_constructor;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_image_plugin_finalize;
#line 865 "Image.c"
}

static void
enotes_image_plugin_instance_init (ENotesImagePlugin * self,
                                   gpointer klass)
{
	GPatternSpec* _tmp0_;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self->priv = enotes_image_plugin_get_instance_private (self);
#line 23 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_tmp0_ = g_pattern_spec_new ("*<image *>*");
#line 23 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self->priv->spec = _tmp0_;
#line 879 "Image.c"
}

static void
enotes_image_plugin_finalize (GObject * obj)
{
	ENotesImagePlugin * self;
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_IMAGE_PLUGIN, ENotesImagePlugin);
#line 23 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	_g_pattern_spec_free0 (self->priv->spec);
#line 22 "../Notes-up-2.0.6/src/Plugins/Image.vala"
	G_OBJECT_CLASS (enotes_image_plugin_parent_class)->finalize (obj);
#line 892 "Image.c"
}

static GType
enotes_image_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesImagePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_image_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesImagePlugin), 0, (GInstanceInitFunc) enotes_image_plugin_instance_init, NULL };
	GType enotes_image_plugin_type_id;
	enotes_image_plugin_type_id = g_type_register_static (ENOTES_TYPE_PLUGIN, "ENotesImagePlugin", &g_define_type_info, 0);
	ENotesImagePlugin_private_offset = g_type_add_instance_private (enotes_image_plugin_type_id, sizeof (ENotesImagePluginPrivate));
	return enotes_image_plugin_type_id;
}

GType
enotes_image_plugin_get_type (void)
{
	static volatile gsize enotes_image_plugin_type_id__once = 0;
	if (g_once_init_enter (&enotes_image_plugin_type_id__once)) {
		GType enotes_image_plugin_type_id;
		enotes_image_plugin_type_id = enotes_image_plugin_get_type_once ();
		g_once_init_leave (&enotes_image_plugin_type_id__once, enotes_image_plugin_type_id);
	}
	return enotes_image_plugin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

