/* rygel-http-resource-handler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-http-resource-handler.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
enum  {
	RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_0_PROPERTY,
	RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_media_resource_handler_properties[RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPMediaResourceHandlerPrivate {
	RygelMediaObject* media_object;
	gchar* media_resource_name;
};

static gint RygelHTTPMediaResourceHandler_private_offset;
static gpointer rygel_http_media_resource_handler_parent_class = NULL;

VALA_EXTERN GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_new (RygelMediaObject* media_object,
                                                                      const gchar* media_resource_name,
                                                                      GCancellable* cancellable,
                                                                      GError** error);
VALA_EXTERN RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_construct (GType object_type,
                                                                            RygelMediaObject* media_object,
                                                                            const gchar* media_resource_name,
                                                                            GCancellable* cancellable,
                                                                            GError** error);
static void rygel_http_media_resource_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                                  RygelHTTPGet* request,
                                                                  GError** error);
static gchar* rygel_http_media_resource_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* base);
static gboolean rygel_http_media_resource_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                                        const gchar* mode);
static RygelHTTPResponse* rygel_http_media_resource_handler_real_render_body (RygelHTTPGetHandler* base,
                                                                       RygelHTTPGet* request,
                                                                       GError** error);
static gint64 rygel_http_media_resource_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gint64 rygel_http_media_resource_handler_real_get_resource_duration (RygelHTTPGetHandler* base);
static gboolean rygel_http_media_resource_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static gboolean rygel_http_media_resource_handler_real_supports_time_seek (RygelHTTPGetHandler* base);
static gboolean rygel_http_media_resource_handler_real_supports_playspeed (RygelHTTPGetHandler* base);
static void rygel_http_media_resource_handler_finalize (GObject * obj);
static GType rygel_http_media_resource_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_media_resource_handler_get_instance_private (RygelHTTPMediaResourceHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPMediaResourceHandler_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelHTTPMediaResourceHandler*
rygel_http_media_resource_handler_construct (GType object_type,
                                             RygelMediaObject* media_object,
                                             const gchar* media_resource_name,
                                             GCancellable* cancellable,
                                             GError** error)
{
	RygelHTTPMediaResourceHandler * self = NULL;
	RygelMediaObject* _tmp0_;
	gchar* _tmp1_;
	RygelMediaResource* resource = NULL;
	RygelMediaResource* _tmp2_;
	RygelMediaResource* _tmp3_;
	RygelMediaResource* _tmp5_;
	RygelMediaResource* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (media_object != NULL, NULL);
	g_return_val_if_fail (media_resource_name != NULL, NULL);
	self = (RygelHTTPMediaResourceHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = _g_object_ref0 (media_object);
	_g_object_unref0 (self->priv->media_object);
	self->priv->media_object = _tmp0_;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, cancellable);
	_tmp1_ = g_strdup (media_resource_name);
	_g_free0 (self->priv->media_resource_name);
	self->priv->media_resource_name = _tmp1_;
	_tmp2_ = rygel_media_object_get_resource_by_name (media_object, media_resource_name);
	resource = _tmp2_;
	_tmp3_ = resource;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "MediaResource %s not found", media_resource_name);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (resource);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (resource);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = resource;
	_tmp6_ = rygel_media_resource_dup (_tmp5_);
	_g_object_unref0 (self->media_resource);
	self->media_resource = _tmp6_;
	_g_object_unref0 (resource);
	return self;
}

RygelHTTPMediaResourceHandler*
rygel_http_media_resource_handler_new (RygelMediaObject* media_object,
                                       const gchar* media_resource_name,
                                       GCancellable* cancellable,
                                       GError** error)
{
	return rygel_http_media_resource_handler_construct (RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, media_object, media_resource_name, cancellable, error);
}

static void
rygel_http_media_resource_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                             RygelHTTPGet* request,
                                                             GError** error)
{
	RygelHTTPMediaResourceHandler * self;
	RygelHTTPServer* _tmp0_;
	RygelMediaResource* _tmp1_;
	GHashTable* replacements = NULL;
	RygelHTTPServer* _tmp2_;
	GHashTable* _tmp3_;
	gchar* mime_type = NULL;
	GHashTable* _tmp4_;
	RygelMediaResource* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SoupServerMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	const gchar* _tmp11_;
	GUPnPProtocolInfo* protocol_info = NULL;
	RygelMediaResource* _tmp12_;
	GHashTable* _tmp13_;
	GUPnPProtocolInfo* _tmp14_;
	GUPnPProtocolInfo* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = (RygelHTTPMediaResourceHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->http_server;
	_tmp1_ = self->media_resource;
	rygel_http_server_set_resource_delivery_options (_tmp0_, _tmp1_);
	_tmp2_ = ((RygelHTTPRequest*) request)->http_server;
	_tmp3_ = rygel_http_server_get_replacements (_tmp2_);
	replacements = _tmp3_;
	_tmp4_ = replacements;
	_tmp5_ = self->media_resource;
	_tmp6_ = rygel_media_resource_get_mime_type (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_media_object_apply_replacements (_tmp4_, _tmp7_);
	mime_type = _tmp8_;
	_tmp9_ = ((RygelHTTPRequest*) request)->msg;
	_tmp10_ = soup_server_message_get_response_headers (_tmp9_);
	_tmp11_ = mime_type;
	soup_message_headers_append (_tmp10_, "Content-Type", _tmp11_);
	_tmp12_ = self->media_resource;
	_tmp13_ = replacements;
	_tmp14_ = rygel_media_resource_get_protocol_info (_tmp12_, _tmp13_);
	protocol_info = _tmp14_;
	_tmp15_ = protocol_info;
	if (_tmp15_ != NULL) {
		gchar** pi_fields = NULL;
		GUPnPProtocolInfo* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gint pi_fields_length1;
		gint _pi_fields_size_;
		gboolean _tmp22_ = FALSE;
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp16_ = protocol_info;
		_tmp17_ = gupnp_protocol_info_to_string (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, ":", 4);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = _vala_array_length (_tmp19_);
		_g_free0 (_tmp18_);
		pi_fields = _tmp21_;
		pi_fields_length1 = _tmp21__length1;
		_pi_fields_size_ = pi_fields_length1;
		_tmp23_ = pi_fields;
		_tmp23__length1 = pi_fields_length1;
		if (_tmp23_ != NULL) {
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			_tmp24_ = pi_fields;
			_tmp24__length1 = pi_fields_length1;
			_tmp25_ = _tmp24_[3];
			_tmp22_ = _tmp25_ != NULL;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			SoupServerMessage* _tmp26_;
			SoupMessageHeaders* _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
			_tmp26_ = ((RygelHTTPRequest*) request)->msg;
			_tmp27_ = soup_server_message_get_response_headers (_tmp26_);
			_tmp28_ = pi_fields;
			_tmp28__length1 = pi_fields_length1;
			_tmp29_ = _tmp28_[3];
			soup_message_headers_append (_tmp27_, "contentFeatures.dlna.org", _tmp29_);
		}
		pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
	}
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_media_resource_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), request, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (protocol_info);
			_g_free0 (mime_type);
			_g_hash_table_unref0 (replacements);
			return;
		} else {
			_g_object_unref0 (protocol_info);
			_g_free0 (mime_type);
			_g_hash_table_unref0 (replacements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (protocol_info);
	_g_free0 (mime_type);
	_g_hash_table_unref0 (replacements);
}

static gchar*
rygel_http_media_resource_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* base)
{
	RygelHTTPMediaResourceHandler * self;
	RygelMediaResource* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_get_default_transfer_mode (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
rygel_http_media_resource_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                               const gchar* mode)
{
	RygelHTTPMediaResourceHandler * self;
	RygelMediaResource* _tmp0_;
	gboolean result;
	self = (RygelHTTPMediaResourceHandler*) base;
	g_return_val_if_fail (mode != NULL, FALSE);
	_tmp0_ = self->media_resource;
	result = rygel_media_resource_supports_transfer_mode (_tmp0_, mode);
	return result;
}

static RygelHTTPResponse*
rygel_http_media_resource_handler_real_render_body (RygelHTTPGetHandler* base,
                                                    RygelHTTPGet* request,
                                                    GError** error)
{
	RygelHTTPMediaResourceHandler * self;
	GError* _inner_error0_ = NULL;
	RygelHTTPResponse* result;
	self = (RygelHTTPMediaResourceHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelDataSource* src = NULL;
		RygelMediaObject* _tmp0_;
		RygelMediaResource* _tmp1_;
		RygelDataSource* _tmp2_;
		RygelDataSource* _tmp3_;
		RygelHTTPResponse* _tmp9_ = NULL;
		RygelDataSource* _tmp10_;
		RygelHTTPResponse* _tmp11_;
		RygelHTTPResponse* _tmp12_;
		_tmp0_ = ((RygelHTTPRequest*) request)->object;
		_tmp1_ = self->media_resource;
		_tmp2_ = rygel_media_object_create_stream_source_for_resource (_tmp0_, (RygelHTTPRequest*) request, _tmp1_, &_inner_error0_);
		src = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = src;
		if (_tmp3_ == NULL) {
			RygelMediaResource* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			GError* _tmp8_;
			_tmp4_ = self->media_resource;
			_tmp5_ = rygel_media_resource_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _ ("Couldn’t create data source for %s"), _tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			_inner_error0_ = _tmp8_;
			_g_object_unref0 (src);
			goto __catch0_g_error;
		}
		_tmp10_ = src;
		_tmp11_ = rygel_http_response_new (request, (RygelHTTPGetHandler*) self, _tmp10_, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (src);
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		result = _tmp12_;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (src);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp14_);
		_inner_error0_ = _tmp15_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gint64
rygel_http_media_resource_handler_real_get_resource_size (RygelHTTPGetHandler* base)
{
	RygelHTTPMediaResourceHandler * self;
	RygelMediaResource* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 result;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gint64
rygel_http_media_resource_handler_real_get_resource_duration (RygelHTTPGetHandler* base)
{
	RygelHTTPMediaResourceHandler * self;
	RygelMediaResource* _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	gint64 result;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_get_duration (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint64) (_tmp2_ * G_TIME_SPAN_SECOND);
	return result;
}

static gboolean
rygel_http_media_resource_handler_real_supports_byte_seek (RygelHTTPGetHandler* base)
{
	RygelHTTPMediaResourceHandler * self;
	gboolean _tmp0_ = FALSE;
	RygelMediaResource* _tmp1_;
	gboolean result;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp1_ = self->media_resource;
	if (rygel_media_resource_supports_arbitrary_byte_seek (_tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		RygelMediaResource* _tmp2_;
		_tmp2_ = self->media_resource;
		_tmp0_ = rygel_media_resource_supports_limited_byte_seek (_tmp2_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_http_media_resource_handler_real_supports_time_seek (RygelHTTPGetHandler* base)
{
	RygelHTTPMediaResourceHandler * self;
	gboolean _tmp0_ = FALSE;
	RygelMediaResource* _tmp1_;
	gboolean result;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp1_ = self->media_resource;
	if (rygel_media_resource_supports_arbitrary_time_seek (_tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		RygelMediaResource* _tmp2_;
		_tmp2_ = self->media_resource;
		_tmp0_ = rygel_media_resource_supports_limited_time_seek (_tmp2_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_http_media_resource_handler_real_supports_playspeed (RygelHTTPGetHandler* base)
{
	RygelHTTPMediaResourceHandler * self;
	RygelMediaResource* _tmp0_;
	gboolean result;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	result = rygel_media_resource_supports_playspeed (_tmp0_);
	return result;
}

static void
rygel_http_media_resource_handler_class_init (RygelHTTPMediaResourceHandlerClass * klass,
                                              gpointer klass_data)
{
	rygel_http_media_resource_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPMediaResourceHandler_private_offset);
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_media_resource_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->get_default_transfer_mode = (gchar* (*) (RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_get_default_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*) (RygelHTTPGetHandler*, const gchar*)) rygel_http_media_resource_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_media_resource_handler_real_render_body;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_duration = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_get_resource_duration;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_supports_byte_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_time_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_supports_time_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_playspeed = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_supports_playspeed;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_media_resource_handler_finalize;
}

static void
rygel_http_media_resource_handler_instance_init (RygelHTTPMediaResourceHandler * self,
                                                 gpointer klass)
{
	self->priv = rygel_http_media_resource_handler_get_instance_private (self);
}

static void
rygel_http_media_resource_handler_finalize (GObject * obj)
{
	RygelHTTPMediaResourceHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler);
	_g_object_unref0 (self->priv->media_object);
	_g_free0 (self->priv->media_resource_name);
	_g_object_unref0 (self->media_resource);
	G_OBJECT_CLASS (rygel_http_media_resource_handler_parent_class)->finalize (obj);
}

/**
 * The HTTP handler for HTTP ContentResource requests.
 */
 G_GNUC_NO_INLINE static GType
rygel_http_media_resource_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPMediaResourceHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_media_resource_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPMediaResourceHandler), 0, (GInstanceInitFunc) rygel_http_media_resource_handler_instance_init, NULL };
	GType rygel_http_media_resource_handler_type_id;
	rygel_http_media_resource_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPMediaResourceHandler", &g_define_type_info, 0);
	RygelHTTPMediaResourceHandler_private_offset = g_type_add_instance_private (rygel_http_media_resource_handler_type_id, sizeof (RygelHTTPMediaResourceHandlerPrivate));
	return rygel_http_media_resource_handler_type_id;
}

GType
rygel_http_media_resource_handler_get_type (void)
{
	static volatile gsize rygel_http_media_resource_handler_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_media_resource_handler_type_id__once)) {
		GType rygel_http_media_resource_handler_type_id;
		rygel_http_media_resource_handler_type_id = rygel_http_media_resource_handler_get_type_once ();
		g_once_init_leave (&rygel_http_media_resource_handler_type_id__once, rygel_http_media_resource_handler_type_id);
	}
	return rygel_http_media_resource_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

