/* rygel-media-export-generic-extractor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-media-export-generic-extractor.vala, do not modify */

/*
 * Copyright (C) 2016 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <libmediaart/mediaart.h>
#include <gst/gst.h>
#include "mx-constants.h"
#include <libgupnp-dlna/gupnp-dlna-gst-utils.h>
#include <gst/tag/tag.h>
#include <glib/gi18n-lib.h>

#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR (rygel_media_export_generic_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))

typedef struct _RygelMediaExportGenericExtractor RygelMediaExportGenericExtractor;
typedef struct _RygelMediaExportGenericExtractorClass RygelMediaExportGenericExtractorClass;
typedef struct _RygelMediaExportGenericExtractorPrivate RygelMediaExportGenericExtractorPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_generic_extractor_properties[RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_EXTRACTOR_ERROR (extractor_error_get_type ())
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
typedef struct _RygelMediaExportGenericExtractorRunData RygelMediaExportGenericExtractorRunData;
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))

struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportGenericExtractor {
	RygelMediaExportExtractor parent_instance;
	RygelMediaExportGenericExtractorPrivate * priv;
};

struct _RygelMediaExportGenericExtractorClass {
	RygelMediaExportExtractorClass parent_class;
};

struct _RygelMediaExportGenericExtractorPrivate {
	gchar* upnp_class;
	gchar* mime_type;
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaExportGenericExtractor* self;
	GError* _error_;
	GstDiscovererInfo* info;
	gpointer _async_data_;
};

typedef enum  {
	EXTRACTOR_ERROR_GENERAL,
	EXTRACTOR_ERROR_INVALID
} ExtractorError;
#define EXTRACTOR_ERROR extractor_error_quark ()

struct _RygelMediaExportGenericExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportGenericExtractor* self;
	Block1Data* _data1_;
	GstDiscoverer* _tmp0_;
	GError* _tmp1_;
	gulong id;
	GstDiscoverer* _tmp2_;
	gulong _tmp3_;
	gchar* path;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* uri;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GstDiscoverer* _tmp15_;
	const gchar* _tmp16_;
	GstDiscoverer* _tmp17_;
	GError* _tmp18_;
	GstDiscoverer* _tmp19_;
	GstDiscoverer* _tmp20_;
	GstDiscoverer* _tmp21_;
	GstDiscoverer* _tmp22_;
	GstDiscoverer* _tmp23_;
	GstDiscovererResult _result_;
	GstDiscovererInfo* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GError* _tmp33_;
	GError* _tmp34_;
	GstDiscovererStreamInfo* stream_info;
	GstDiscovererInfo* _tmp35_;
	GstDiscovererStreamInfo* _tmp36_;
	GstTagList* stream_tags;
	GstDiscovererStreamInfo* _tmp37_;
	GstDiscovererStreamInfo* _tmp38_;
	GstTagList* _tmp39_;
	GstTagList* _tmp40_;
	GstDiscovererStreamInfo* _tmp41_;
	GstDiscovererStreamInfo* _tmp42_;
	GstTagList* _tmp43_;
	GstTagList* _tmp44_;
	GList* audio_streams;
	GstDiscovererInfo* _tmp45_;
	GList* _tmp46_;
	GList* video_streams;
	GstDiscovererInfo* _tmp47_;
	GList* _tmp48_;
	gboolean _tmp49_;
	GList* _tmp50_;
	GList* _tmp51_;
	GFile* _tmp52_;
	GFile* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GError* _tmp56_;
	gchar* _tmp57_;
	gboolean _tmp58_;
	GList* _tmp59_;
	GList* _tmp60_;
	gconstpointer _tmp61_;
	gchar* _tmp62_;
	GList* _tmp63_;
	gchar* _tmp64_;
	GList* _tmp65_;
	gchar* _tmp66_;
	GVariantDict* _tmp67_;
	const gchar* _tmp68_;
	GUPnPDLNAInformation* dlna_info;
	GstDiscovererInfo* _tmp69_;
	GUPnPDLNAInformation* _tmp70_;
	GUPnPDLNAProfile* dlna;
	GUPnPDLNAProfileGuesser* _tmp71_;
	GUPnPDLNAInformation* _tmp72_;
	GUPnPDLNAProfile* _tmp73_;
	GUPnPDLNAProfile* _tmp74_;
	GUPnPDLNAProfile* _tmp75_;
	GVariantDict* _tmp76_;
	GUPnPDLNAProfile* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	GVariantDict* _tmp80_;
	GUPnPDLNAProfile* _tmp81_;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	GVariantDict* _tmp84_;
	gchar* _tmp85_;
	glong duration;
	GstDiscovererInfo* _tmp86_;
	GstDiscovererInfo* _tmp87_;
	GVariantDict* _tmp88_;
	GstTagList* _tmp89_;
	gboolean _tmp90_;
	GList* _tmp91_;
	GList* _tmp92_;
	gconstpointer _tmp93_;
	GstDiscovererVideoInfo* vinfo;
	GList* _tmp94_;
	gconstpointer _tmp95_;
	GstDiscovererVideoInfo* _tmp96_;
	GVariantDict* _tmp97_;
	GstDiscovererVideoInfo* _tmp98_;
	GVariantDict* _tmp99_;
	GstDiscovererVideoInfo* _tmp100_;
	guint _tmp101_;
	GstDiscovererVideoInfo* _tmp102_;
	GstDiscovererVideoInfo* _tmp103_;
	GVariantDict* _tmp104_;
	gboolean _tmp105_;
	GList* _tmp106_;
	GList* _tmp107_;
	gconstpointer _tmp108_;
	GstDiscovererAudioInfo* ainfo;
	GList* _tmp109_;
	gconstpointer _tmp110_;
	GstDiscovererAudioInfo* _tmp111_;
	gboolean _tmp112_;
	GList* _tmp113_;
	GstTagList* _tmp114_;
	GstDiscovererAudioInfo* _tmp115_;
	GstTagList* _tmp116_;
	GVariantDict* _tmp117_;
	GstDiscovererAudioInfo* _tmp118_;
	GVariantDict* _tmp119_;
	GstDiscovererAudioInfo* _tmp120_;
	GstTagList* atags;
	GstDiscovererAudioInfo* _tmp121_;
	GstTagList* _tmp122_;
	GstTagList* _tmp123_;
	GstTagList* _tmp124_;
	gchar* artist;
	gboolean _tmp125_;
	GstTagList* _tmp126_;
	gchar* _tmp127_;
	gboolean _tmp128_;
	const gchar* _tmp129_;
	GVariantDict* _tmp130_;
	const gchar* _tmp131_;
	gchar* album;
	GstTagList* _tmp132_;
	gchar* _tmp133_;
	gboolean _tmp134_;
	GVariantDict* _tmp135_;
	const gchar* _tmp136_;
	gchar* genre;
	GstTagList* _tmp137_;
	gchar* _tmp138_;
	gboolean _tmp139_;
	GVariantDict* _tmp140_;
	const gchar* _tmp141_;
	guint volume;
	GstTagList* _tmp142_;
	guint _tmp143_;
	gboolean _tmp144_;
	GVariantDict* _tmp145_;
	guint track;
	GstTagList* _tmp146_;
	guint _tmp147_;
	gboolean _tmp148_;
	GVariantDict* _tmp149_;
	guint bitrate;
	GstTagList* _tmp150_;
	guint _tmp151_;
	gboolean _tmp152_;
	GVariantDict* _tmp153_;
	MediaArtProcess* _tmp154_;
	GstSample* sample;
	GstTagList* _tmp155_;
	GstSample* _tmp156_;
	GstSample* _tmp157_;
	GstTagList* _tmp158_;
	GstSample* _tmp159_;
	GstSample* _tmp160_;
	gboolean _tmp161_;
	const gchar* _tmp162_;
	const gchar* _tmp163_;
	MediaArtProcess* _tmp164_;
	GFile* _tmp165_;
	GFile* _tmp166_;
	const gchar* _tmp167_;
	const gchar* _tmp168_;
	GError* _error_;
	GError* _tmp169_;
	const gchar* _tmp170_;
	GstCaps* caps;
	GstSample* _tmp171_;
	GstCaps* _tmp172_;
	GstCaps* _tmp173_;
	GstStructure* structure;
	GstCaps* _tmp174_;
	GstStructure* _tmp175_;
	gint image_type;
	GstStructure* _tmp176_;
	gint _tmp177_;
	gboolean _tmp178_;
	GstMapInfo map_info;
	GstSample* _tmp179_;
	GstBuffer* _tmp180_;
	GstMapInfo _tmp181_;
	guint8* data;
	GstMapInfo _tmp182_;
	guint8* _tmp183_;
	gint _tmp183__length1;
	gint data_length1;
	gint _data_size_;
	GstMapInfo _tmp184_;
	MediaArtProcess* _tmp185_;
	GFile* _tmp186_;
	GFile* _tmp187_;
	guint8* _tmp188_;
	gint _tmp188__length1;
	GstStructure* _tmp189_;
	const gchar* _tmp190_;
	const gchar* _tmp191_;
	const gchar* _tmp192_;
	GError* _vala1__error_;
	GError* _tmp193_;
	const gchar* _tmp194_;
	GstSample* _tmp195_;
	GstBuffer* _tmp196_;
	GstMapInfo _tmp197_;
	GError* _inner_error0_;
};

static gint RygelMediaExportGenericExtractor_private_offset;
static gpointer rygel_media_export_generic_extractor_parent_class = NULL;
static GstDiscoverer* rygel_media_export_generic_extractor_discoverer;
static GstDiscoverer* rygel_media_export_generic_extractor_discoverer = NULL;
static GUPnPDLNAProfileGuesser* rygel_media_export_generic_extractor_guesser;
static GUPnPDLNAProfileGuesser* rygel_media_export_generic_extractor_guesser = NULL;
static MediaArtProcess* rygel_media_export_generic_extractor_media_art;
static MediaArtProcess* rygel_media_export_generic_extractor_media_art = NULL;

VALA_EXTERN GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportExtractor, g_object_unref)
VALA_EXTERN GType rygel_media_export_generic_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportGenericExtractor, g_object_unref)
VALA_EXTERN void rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error);
VALA_EXTERN RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_new (GFile* file);
VALA_EXTERN RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_construct (GType object_type,
                                                                                  GFile* file);
static void rygel_media_export_generic_extractor_real_run_data_free (gpointer _data);
static void rygel_media_export_generic_extractor_real_run (RygelMediaExportExtractor* base,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean rygel_media_export_generic_extractor_real_run_co (RygelMediaExportGenericExtractorRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void rygel_media_export_generic_extractor_run_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN GQuark extractor_error_quark (void);
VALA_EXTERN GType extractor_error_get_type (void) G_GNUC_CONST ;
static void __lambda4_ (Block1Data* _data1_,
                 GstDiscovererInfo* _info,
                 GError* _error);
static void ___lambda4__gst_discoverer_discovered (GstDiscoverer* _sender,
                                            GstDiscovererInfo* info,
                                            GError* err,
                                            gpointer self);
VALA_EXTERN GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_generic_extractor_get_title_and_date (RygelMediaExportGenericExtractor* self,
                                                              GstTagList* tags);
static void rygel_media_export_generic_extractor_finalize (GObject * obj);
static GType rygel_media_export_generic_extractor_get_type_once (void);

static inline gpointer
rygel_media_export_generic_extractor_get_instance_private (RygelMediaExportGenericExtractor* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportGenericExtractor_private_offset);
}

RygelMediaExportGenericExtractor*
rygel_media_export_generic_extractor_construct (GType object_type,
                                                GFile* file)
{
	RygelMediaExportGenericExtractor * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (RygelMediaExportGenericExtractor*) g_object_new (object_type, "file", file, NULL);
	return self;
}

RygelMediaExportGenericExtractor*
rygel_media_export_generic_extractor_new (GFile* file)
{
	return rygel_media_export_generic_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, file);
}

static void
rygel_media_export_generic_extractor_real_run_data_free (gpointer _data)
{
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportGenericExtractorRunData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_media_export_generic_extractor_real_run (RygelMediaExportExtractor* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelMediaExportGenericExtractor * self;
	RygelMediaExportGenericExtractorRunData* _data_;
	RygelMediaExportGenericExtractor* _tmp0_;
	self = (RygelMediaExportGenericExtractor*) base;
	_data_ = g_slice_new0 (RygelMediaExportGenericExtractorRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_generic_extractor_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_generic_extractor_real_run_co (_data_);
}

static void
rygel_media_export_generic_extractor_run_finish (RygelMediaExportExtractor* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelMediaExportGenericExtractor* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->info);
		_g_error_free0 (_data1_->_error_);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
rygel_media_export_generic_extractor_run_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelMediaExportGenericExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_generic_extractor_real_run_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_,
            GstDiscovererInfo* _info,
            GError* _error)
{
	RygelMediaExportGenericExtractor* self;
	GstDiscovererInfo* _tmp0_;
	GError* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (_info != NULL);
	_tmp0_ = _g_object_ref0 (_info);
	_g_object_unref0 (_data1_->info);
	_data1_->info = _tmp0_;
	_tmp1_ = _g_error_copy0 (_error);
	_g_error_free0 (_data1_->_error_);
	_data1_->_error_ = _tmp1_;
	rygel_media_export_generic_extractor_real_run_co (_data1_->_async_data_);
}

static void
___lambda4__gst_discoverer_discovered (GstDiscoverer* _sender,
                                       GstDiscovererInfo* info,
                                       GError* err,
                                       gpointer self)
{
	__lambda4_ (self, info, err);
}

static gpointer
_gst_tag_list_ref0 (gpointer self)
{
	return self ? gst_tag_list_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_gst_caps_ref0 (gpointer self)
{
	return self ? gst_caps_ref (self) : NULL;
}

static gboolean
rygel_media_export_generic_extractor_real_run_co (RygelMediaExportGenericExtractorRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_state_ = 1;
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_generic_extractor_parent_class)->run (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), rygel_media_export_generic_extractor_run_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_generic_extractor_parent_class)->run_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = rygel_media_export_generic_extractor_discoverer;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (EXTRACTOR_ERROR, EXTRACTOR_ERROR_GENERAL, "Backend not avaliable");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data1_->_error_ = NULL;
	_data_->_data1_->info = NULL;
	_data_->_tmp2_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp3_ = g_signal_connect_data (_data_->_tmp2_, "discovered", (GCallback) ___lambda4__gst_discoverer_discovered, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->id = _data_->_tmp3_;
	_data_->_tmp4_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_file_get_path (_data_->_tmp5_);
	_data_->path = _data_->_tmp6_;
	_data_->_tmp7_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_file_get_uri (_data_->_tmp8_);
	_data_->uri = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->path;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp12_ = _data_->path;
		_data_->_tmp13_ = g_filename_to_uri (_data_->_tmp12_, NULL, &_data_->_inner_error0_);
		_data_->_tmp11_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->path);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = _data_->_tmp11_;
		_data_->_tmp11_ = NULL;
		_g_free0 (_data_->uri);
		_data_->uri = _data_->_tmp14_;
		_g_free0 (_data_->_tmp11_);
	}
	_data_->_tmp15_ = rygel_media_export_generic_extractor_discoverer;
	_data_->_tmp16_ = _data_->uri;
	gst_discoverer_discover_uri_async (_data_->_tmp15_, _data_->_tmp16_);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp17_ = rygel_media_export_generic_extractor_discoverer;
	g_signal_handler_disconnect ((GObject*) _data_->_tmp17_, _data_->id);
	_data_->_tmp18_ = _data_->_data1_->_error_;
	if (_data_->_tmp18_ != NULL) {
		_data_->_tmp19_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_stop (_data_->_tmp19_);
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = NULL;
		_data_->_tmp21_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_data_->_inner_error0_);
		_data_->_tmp20_ = _data_->_tmp21_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->path);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = _data_->_tmp20_;
		_data_->_tmp20_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = _data_->_tmp22_;
		_data_->_tmp23_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_start (_data_->_tmp23_);
		_data_->_tmp24_ = _data_->_data1_->info;
		_data_->_result_ = gst_discoverer_info_get_result (_data_->_tmp24_);
		if (_data_->_result_ == GST_DISCOVERER_TIMEOUT) {
			_data_->_tmp25_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = g_file_get_uri (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			g_debug ("rygel-media-export-generic-extractor.vala:93: Extraction timed out on " \
"%s", _data_->_tmp28_);
			_g_free0 (_data_->_tmp28_);
		} else {
			if (_data_->_result_ == GST_DISCOVERER_MISSING_PLUGINS) {
				_data_->_tmp29_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = g_file_get_uri (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_tmp31_;
				g_debug ("rygel-media-export-generic-extractor.vala:95: Plugins are missing for " \
"extraction of file %s", _data_->_tmp32_);
				_g_free0 (_data_->_tmp32_);
			}
		}
		_data_->_tmp33_ = _data_->_data1_->_error_;
		_data_->_tmp34_ = _g_error_copy0 (_data_->_tmp33_);
		_data_->_inner_error0_ = _data_->_tmp34_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp20_);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->path);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = _data_->_data1_->info;
	_data_->_tmp36_ = gst_discoverer_info_get_stream_info (_data_->_tmp35_);
	_data_->stream_info = _data_->_tmp36_;
	_data_->stream_tags = NULL;
	_data_->_tmp37_ = _data_->stream_info;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp37_, gst_discoverer_container_info_get_type ())) {
		_data_->_tmp38_ = _data_->stream_info;
		_data_->_tmp39_ = gst_discoverer_container_info_get_tags (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp38_, gst_discoverer_container_info_get_type (), GstDiscovererContainerInfo));
		_data_->_tmp40_ = _gst_tag_list_ref0 (_data_->_tmp39_);
		_gst_tag_list_unref0 (_data_->stream_tags);
		_data_->stream_tags = _data_->_tmp40_;
	} else {
		_data_->_tmp41_ = _data_->stream_info;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp41_, gst_discoverer_stream_info_get_type ())) {
			_data_->_tmp42_ = _data_->stream_info;
			_data_->_tmp43_ = gst_discoverer_stream_info_get_tags (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp42_, gst_discoverer_stream_info_get_type (), GstDiscovererStreamInfo));
			_data_->_tmp44_ = _gst_tag_list_ref0 (_data_->_tmp43_);
			_gst_tag_list_unref0 (_data_->stream_tags);
			_data_->stream_tags = _data_->_tmp44_;
		}
	}
	_data_->_tmp45_ = _data_->_data1_->info;
	_data_->_tmp46_ = gst_discoverer_info_get_audio_streams (_data_->_tmp45_);
	_data_->audio_streams = (GList*) _data_->_tmp46_;
	_data_->_tmp47_ = _data_->_data1_->info;
	_data_->_tmp48_ = gst_discoverer_info_get_video_streams (_data_->_tmp47_);
	_data_->video_streams = (GList*) _data_->_tmp48_;
	_data_->_tmp50_ = _data_->audio_streams;
	if (_data_->_tmp50_ == NULL) {
		_data_->_tmp51_ = _data_->video_streams;
		_data_->_tmp49_ = _data_->_tmp51_ == NULL;
	} else {
		_data_->_tmp49_ = FALSE;
	}
	if (_data_->_tmp49_) {
		_data_->_tmp52_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
		_data_->_tmp53_ = _data_->_tmp52_;
		_data_->_tmp54_ = g_file_get_uri (_data_->_tmp53_);
		_data_->_tmp55_ = _data_->_tmp54_;
		g_debug ("rygel-media-export-generic-extractor.vala:117: %s had neither audio no" \
"r video/picture streams. Ignoring.", _data_->_tmp55_);
		_g_free0 (_data_->_tmp55_);
		_data_->_tmp56_ = g_error_new_literal (EXTRACTOR_ERROR, EXTRACTOR_ERROR_GENERAL, "No stream information");
		_data_->_inner_error0_ = _data_->_tmp56_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
		(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
		_gst_tag_list_unref0 (_data_->stream_tags);
		_g_object_unref0 (_data_->stream_info);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->path);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp57_ = g_strdup ("object.item");
	_g_free0 (_data_->self->priv->upnp_class);
	_data_->self->priv->upnp_class = _data_->_tmp57_;
	_data_->_tmp59_ = _data_->audio_streams;
	if (_data_->_tmp59_ == NULL) {
		_data_->_tmp60_ = _data_->video_streams;
		_data_->_tmp61_ = _data_->_tmp60_->data;
		_data_->_tmp58_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _data_->_tmp61_);
	} else {
		_data_->_tmp58_ = FALSE;
	}
	if (_data_->_tmp58_) {
		_data_->_tmp62_ = g_strdup (UPNP_CLASS_PHOTO);
		_g_free0 (_data_->self->priv->upnp_class);
		_data_->self->priv->upnp_class = _data_->_tmp62_;
	} else {
		_data_->_tmp63_ = _data_->video_streams;
		if (_data_->_tmp63_ != NULL) {
			_data_->_tmp64_ = g_strdup (UPNP_CLASS_VIDEO);
			_g_free0 (_data_->self->priv->upnp_class);
			_data_->self->priv->upnp_class = _data_->_tmp64_;
		} else {
			_data_->_tmp65_ = _data_->audio_streams;
			if (_data_->_tmp65_ != NULL) {
				_data_->_tmp66_ = g_strdup (UPNP_CLASS_MUSIC);
				_g_free0 (_data_->self->priv->upnp_class);
				_data_->self->priv->upnp_class = _data_->_tmp66_;
			}
		}
	}
	_data_->_tmp67_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp68_ = _data_->self->priv->upnp_class;
	g_variant_dict_insert (_data_->_tmp67_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", _data_->_tmp68_, NULL);
	_data_->_tmp69_ = _data_->_data1_->info;
	_data_->_tmp70_ = gupnp_dlna_gst_utils_information_from_discoverer_info (_data_->_tmp69_);
	_data_->dlna_info = _data_->_tmp70_;
	_data_->_tmp71_ = rygel_media_export_generic_extractor_guesser;
	_data_->_tmp72_ = _data_->dlna_info;
	_data_->_tmp73_ = gupnp_dlna_profile_guesser_guess_profile_from_info (_data_->_tmp71_, _data_->_tmp72_);
	_data_->_tmp74_ = _g_object_ref0 (_data_->_tmp73_);
	_data_->dlna = _data_->_tmp74_;
	_data_->_tmp75_ = _data_->dlna;
	if (_data_->_tmp75_ != NULL) {
		_data_->_tmp76_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp77_ = _data_->dlna;
		_data_->_tmp78_ = gupnp_dlna_profile_get_name (_data_->_tmp77_);
		_data_->_tmp79_ = _data_->_tmp78_;
		g_variant_dict_insert (_data_->_tmp76_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, "s", _data_->_tmp79_, NULL);
		_data_->_tmp80_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp81_ = _data_->dlna;
		_data_->_tmp82_ = gupnp_dlna_profile_get_mime (_data_->_tmp81_);
		_data_->_tmp83_ = _data_->_tmp82_;
		g_variant_dict_insert (_data_->_tmp80_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", _data_->_tmp83_, NULL);
	}
	_data_->_tmp84_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp85_ = NULL;
	g_variant_dict_lookup (_data_->_tmp84_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", &_data_->_tmp85_, NULL);
	_g_free0 (_data_->self->priv->mime_type);
	_data_->self->priv->mime_type = _data_->_tmp85_;
	_data_->duration = (glong) -1;
	_data_->_tmp86_ = _data_->_data1_->info;
	if (gst_discoverer_info_get_duration (_data_->_tmp86_) > ((GstClockTime) 0)) {
		_data_->_tmp87_ = _data_->_data1_->info;
		_data_->duration = (glong) (gst_discoverer_info_get_duration (_data_->_tmp87_) / GST_SECOND);
		_data_->_tmp88_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp88_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION, "i", _data_->duration, NULL);
	}
	_data_->_tmp89_ = _data_->stream_tags;
	rygel_media_export_generic_extractor_get_title_and_date (_data_->self, _data_->_tmp89_);
	_data_->_tmp91_ = _data_->video_streams;
	if (_data_->_tmp91_ != NULL) {
		_data_->_tmp92_ = _data_->video_streams;
		_data_->_tmp93_ = _data_->_tmp92_->data;
		_data_->_tmp90_ = ((GstDiscovererVideoInfo*) _data_->_tmp93_) != NULL;
	} else {
		_data_->_tmp90_ = FALSE;
	}
	if (_data_->_tmp90_) {
		_data_->_tmp94_ = _data_->video_streams;
		_data_->_tmp95_ = _data_->_tmp94_->data;
		_data_->_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GstDiscovererVideoInfo*) _data_->_tmp95_, gst_discoverer_video_info_get_type (), GstDiscovererVideoInfo));
		_data_->vinfo = _data_->_tmp96_;
		_data_->_tmp97_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp98_ = _data_->vinfo;
		g_variant_dict_insert (_data_->_tmp97_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH, "i", (gint) gst_discoverer_video_info_get_width (_data_->_tmp98_), NULL);
		_data_->_tmp99_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp100_ = _data_->vinfo;
		g_variant_dict_insert (_data_->_tmp99_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT, "i", (gint) gst_discoverer_video_info_get_height (_data_->_tmp100_), NULL);
		_data_->_tmp102_ = _data_->vinfo;
		if (gst_discoverer_video_info_get_depth (_data_->_tmp102_) > ((guint) 0)) {
			_data_->_tmp103_ = _data_->vinfo;
			_data_->_tmp101_ = gst_discoverer_video_info_get_depth (_data_->_tmp103_);
		} else {
			_data_->_tmp101_ = (guint) -1;
		}
		_data_->_tmp104_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp104_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH, "i", _data_->_tmp101_, NULL);
		_g_object_unref0 (_data_->vinfo);
	}
	_data_->_tmp106_ = _data_->audio_streams;
	if (_data_->_tmp106_ != NULL) {
		_data_->_tmp107_ = _data_->audio_streams;
		_data_->_tmp108_ = _data_->_tmp107_->data;
		_data_->_tmp105_ = ((GstDiscovererAudioInfo*) _data_->_tmp108_) != NULL;
	} else {
		_data_->_tmp105_ = FALSE;
	}
	if (_data_->_tmp105_) {
		_data_->_tmp109_ = _data_->audio_streams;
		_data_->_tmp110_ = _data_->_tmp109_->data;
		_data_->_tmp111_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GstDiscovererAudioInfo*) _data_->_tmp110_, gst_discoverer_audio_info_get_type (), GstDiscovererAudioInfo));
		_data_->ainfo = _data_->_tmp111_;
		_data_->_tmp113_ = _data_->video_streams;
		if (_data_->_tmp113_ == NULL) {
			_data_->_tmp114_ = _data_->stream_tags;
			_data_->_tmp112_ = _data_->_tmp114_ == NULL;
		} else {
			_data_->_tmp112_ = FALSE;
		}
		if (_data_->_tmp112_) {
			_data_->_tmp115_ = _data_->ainfo;
			_data_->_tmp116_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _data_->_tmp115_);
			rygel_media_export_generic_extractor_get_title_and_date (_data_->self, _data_->_tmp116_);
		}
		_data_->_tmp117_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp118_ = _data_->ainfo;
		g_variant_dict_insert (_data_->_tmp117_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS, "i", (gint) gst_discoverer_audio_info_get_channels (_data_->_tmp118_), NULL);
		_data_->_tmp119_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp120_ = _data_->ainfo;
		g_variant_dict_insert (_data_->_tmp119_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE, "i", (gint) gst_discoverer_audio_info_get_sample_rate (_data_->_tmp120_), NULL);
		_data_->_tmp121_ = _data_->ainfo;
		_data_->_tmp122_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _data_->_tmp121_);
		_data_->_tmp123_ = _gst_tag_list_ref0 (_data_->_tmp122_);
		_data_->atags = _data_->_tmp123_;
		_data_->_tmp124_ = _data_->atags;
		if (_data_->_tmp124_ != NULL) {
			_data_->artist = NULL;
			_data_->_tmp126_ = _data_->atags;
			_data_->_tmp127_ = NULL;
			_data_->_tmp128_ = gst_tag_list_get_string (_data_->_tmp126_, GST_TAG_ARTIST, &_data_->_tmp127_);
			_g_free0 (_data_->artist);
			_data_->artist = _data_->_tmp127_;
			if (_data_->_tmp128_) {
				_data_->_tmp129_ = _data_->self->priv->mime_type;
				_data_->_tmp125_ = g_strcmp0 (_data_->_tmp129_, "video/x-msvideo") != 0;
			} else {
				_data_->_tmp125_ = FALSE;
			}
			if (_data_->_tmp125_) {
				_data_->_tmp130_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp131_ = _data_->artist;
				g_variant_dict_insert (_data_->_tmp130_, RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST, "s", _data_->_tmp131_, NULL);
			}
			_data_->album = NULL;
			_data_->_tmp132_ = _data_->atags;
			_data_->_tmp133_ = NULL;
			_data_->_tmp134_ = gst_tag_list_get_string (_data_->_tmp132_, GST_TAG_ALBUM, &_data_->_tmp133_);
			_g_free0 (_data_->album);
			_data_->album = _data_->_tmp133_;
			if (_data_->_tmp134_) {
				_data_->_tmp135_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp136_ = _data_->album;
				g_variant_dict_insert (_data_->_tmp135_, RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM, "s", _data_->_tmp136_, NULL);
			}
			_data_->genre = NULL;
			_data_->_tmp137_ = _data_->atags;
			_data_->_tmp138_ = NULL;
			_data_->_tmp139_ = gst_tag_list_get_string (_data_->_tmp137_, GST_TAG_GENRE, &_data_->_tmp138_);
			_g_free0 (_data_->genre);
			_data_->genre = _data_->_tmp138_;
			if (_data_->_tmp139_) {
				_data_->_tmp140_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp141_ = _data_->genre;
				g_variant_dict_insert (_data_->_tmp140_, RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE, "s", _data_->_tmp141_, NULL);
			}
			_data_->volume = G_MAXUINT;
			_data_->_tmp142_ = _data_->atags;
			_data_->_tmp143_ = 0U;
			_data_->_tmp144_ = gst_tag_list_get_uint (_data_->_tmp142_, GST_TAG_ALBUM_VOLUME_NUMBER, &_data_->_tmp143_);
			_data_->volume = _data_->_tmp143_;
			if (_data_->_tmp144_) {
				_data_->_tmp145_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				g_variant_dict_insert (_data_->_tmp145_, RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER, "i", _data_->volume, NULL);
			}
			_data_->track = G_MAXUINT;
			_data_->_tmp146_ = _data_->atags;
			_data_->_tmp147_ = 0U;
			_data_->_tmp148_ = gst_tag_list_get_uint (_data_->_tmp146_, GST_TAG_TRACK_NUMBER, &_data_->_tmp147_);
			_data_->track = _data_->_tmp147_;
			if (_data_->_tmp148_) {
				_data_->_tmp149_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				g_variant_dict_insert (_data_->_tmp149_, RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER, "i", _data_->track, NULL);
			}
			_data_->bitrate = G_MAXUINT;
			_data_->_tmp150_ = _data_->atags;
			_data_->_tmp151_ = 0U;
			_data_->_tmp152_ = gst_tag_list_get_uint (_data_->_tmp150_, GST_TAG_BITRATE, &_data_->_tmp151_);
			_data_->bitrate = _data_->_tmp151_;
			if (_data_->_tmp152_) {
				_data_->_tmp153_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				g_variant_dict_insert (_data_->_tmp153_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE, "i", ((gint) _data_->bitrate) / 8, NULL);
			}
			_data_->_tmp154_ = rygel_media_export_generic_extractor_media_art;
			if (_data_->_tmp154_ != NULL) {
				_data_->_tmp155_ = _data_->atags;
				_data_->_tmp156_ = NULL;
				gst_tag_list_get_sample (_data_->_tmp155_, GST_TAG_IMAGE, &_data_->_tmp156_);
				_gst_sample_unref0 (_data_->sample);
				_data_->sample = _data_->_tmp156_;
				_data_->_tmp157_ = _data_->sample;
				if (_data_->_tmp157_ == NULL) {
					_data_->_tmp158_ = _data_->atags;
					_data_->_tmp159_ = NULL;
					gst_tag_list_get_sample (_data_->_tmp158_, GST_TAG_PREVIEW_IMAGE, &_data_->_tmp159_);
					_gst_sample_unref0 (_data_->sample);
					_data_->sample = _data_->_tmp159_;
				}
				_data_->_tmp160_ = _data_->sample;
				if (_data_->_tmp160_ == NULL) {
					{
						_data_->_tmp162_ = _data_->artist;
						if (_data_->_tmp162_ != NULL) {
							_data_->_tmp161_ = TRUE;
						} else {
							_data_->_tmp163_ = _data_->album;
							_data_->_tmp161_ = _data_->_tmp163_ != NULL;
						}
						if (_data_->_tmp161_) {
							_data_->_tmp164_ = rygel_media_export_generic_extractor_media_art;
							_data_->_tmp165_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
							_data_->_tmp166_ = _data_->_tmp165_;
							_data_->_tmp167_ = _data_->artist;
							_data_->_tmp168_ = _data_->album;
							media_art_process_file (_data_->_tmp164_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _data_->_tmp166_, _data_->_tmp167_, _data_->_tmp168_, NULL, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						_data_->_error_ = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp169_ = _data_->_error_;
						_data_->_tmp170_ = _data_->_tmp169_->message;
						g_debug ("rygel-media-export-generic-extractor.vala:234: Failed to add external " \
"media art: %s", _data_->_tmp170_);
						_g_error_free0 (_data_->_error_);
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_gst_sample_unref0 (_data_->sample);
						_g_free0 (_data_->genre);
						_g_free0 (_data_->album);
						_g_free0 (_data_->artist);
						_gst_tag_list_unref0 (_data_->atags);
						_g_object_unref0 (_data_->ainfo);
						_g_object_unref0 (_data_->dlna);
						_g_object_unref0 (_data_->dlna_info);
						(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
						(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
						_gst_tag_list_unref0 (_data_->stream_tags);
						_g_object_unref0 (_data_->stream_info);
						_g_free0 (_data_->uri);
						_g_free0 (_data_->path);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				} else {
					_data_->_tmp171_ = _data_->sample;
					_data_->_tmp172_ = gst_sample_get_caps (_data_->_tmp171_);
					_data_->_tmp173_ = _gst_caps_ref0 (_data_->_tmp172_);
					_data_->caps = _data_->_tmp173_;
					_data_->_tmp174_ = _data_->caps;
					_data_->_tmp175_ = gst_caps_get_structure (_data_->_tmp174_, (guint) 0);
					_data_->structure = _data_->_tmp175_;
					_data_->_tmp176_ = _data_->structure;
					_data_->_tmp177_ = 0;
					gst_structure_get_enum (_data_->_tmp176_, "image-type", gst_tag_image_type_get_type (), &_data_->_tmp177_);
					_data_->image_type = _data_->_tmp177_;
					if (_data_->image_type == ((gint) GST_TAG_IMAGE_TYPE_UNDEFINED)) {
						_data_->_tmp178_ = TRUE;
					} else {
						_data_->_tmp178_ = _data_->image_type == ((gint) GST_TAG_IMAGE_TYPE_FRONT_COVER);
					}
					if (_data_->_tmp178_) {
						_data_->_tmp179_ = _data_->sample;
						_data_->_tmp180_ = gst_sample_get_buffer (_data_->_tmp179_);
						memset (&_data_->_tmp181_, 0, sizeof (GstMapInfo));
						gst_buffer_map (_data_->_tmp180_, &_data_->_tmp181_, GST_MAP_READ);
						_data_->map_info = _data_->_tmp181_;
						_data_->_tmp182_ = _data_->map_info;
						_data_->_tmp183_ = _data_->_tmp182_.data;
						_data_->_tmp183__length1 = _data_->_tmp182_.size;
						_data_->data = _data_->_tmp183_;
						_data_->data_length1 = _data_->_tmp183__length1;
						_data_->_data_size_ = _data_->data_length1;
						_data_->_tmp184_ = _data_->map_info;
						_data_->data_length1 = (gint) _data_->_tmp184_.size;
						{
							_data_->_tmp185_ = rygel_media_export_generic_extractor_media_art;
							_data_->_tmp186_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
							_data_->_tmp187_ = _data_->_tmp186_;
							_data_->_tmp188_ = _data_->data;
							_data_->_tmp188__length1 = _data_->data_length1;
							_data_->_tmp189_ = _data_->structure;
							_data_->_tmp190_ = gst_structure_get_name (_data_->_tmp189_);
							_data_->_tmp191_ = _data_->artist;
							_data_->_tmp192_ = _data_->album;
							media_art_process_buffer (_data_->_tmp185_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _data_->_tmp187_, _data_->_tmp188_, (gsize) _data_->_tmp188__length1, _data_->_tmp190_, _data_->_tmp191_, _data_->_tmp192_, NULL, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
						}
						goto __finally1;
						__catch1_g_error:
						{
							_data_->_vala1__error_ = _data_->_inner_error0_;
							_data_->_inner_error0_ = NULL;
							_data_->_tmp193_ = _data_->_vala1__error_;
							_data_->_tmp194_ = _data_->_tmp193_->message;
							g_debug ("rygel-media-export-generic-extractor.vala:264: Failed to add media art" \
" to cache: %s", _data_->_tmp194_);
							_g_error_free0 (_data_->_vala1__error_);
						}
						__finally1:
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_gst_caps_unref0 (_data_->caps);
							_gst_sample_unref0 (_data_->sample);
							_g_free0 (_data_->genre);
							_g_free0 (_data_->album);
							_g_free0 (_data_->artist);
							_gst_tag_list_unref0 (_data_->atags);
							_g_object_unref0 (_data_->ainfo);
							_g_object_unref0 (_data_->dlna);
							_g_object_unref0 (_data_->dlna_info);
							(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
							(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
							_gst_tag_list_unref0 (_data_->stream_tags);
							_g_object_unref0 (_data_->stream_info);
							_g_free0 (_data_->uri);
							_g_free0 (_data_->path);
							block1_data_unref (_data_->_data1_);
							_data_->_data1_ = NULL;
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp195_ = _data_->sample;
						_data_->_tmp196_ = gst_sample_get_buffer (_data_->_tmp195_);
						_data_->_tmp197_ = _data_->map_info;
						gst_buffer_unmap (_data_->_tmp196_, &_data_->_tmp197_);
					}
					_gst_caps_unref0 (_data_->caps);
				}
				_gst_sample_unref0 (_data_->sample);
			}
			_g_free0 (_data_->genre);
			_g_free0 (_data_->album);
			_g_free0 (_data_->artist);
		}
		_gst_tag_list_unref0 (_data_->atags);
		_g_object_unref0 (_data_->ainfo);
	}
	_g_object_unref0 (_data_->dlna);
	_g_object_unref0 (_data_->dlna_info);
	(_data_->video_streams == NULL) ? NULL : (_data_->video_streams = (_g_list_free__g_object_unref0_ (_data_->video_streams), NULL));
	(_data_->audio_streams == NULL) ? NULL : (_data_->audio_streams = (_g_list_free__g_object_unref0_ (_data_->audio_streams), NULL));
	_gst_tag_list_unref0 (_data_->stream_tags);
	_g_object_unref0 (_data_->stream_info);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->path);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_generic_extractor_get_title_and_date (RygelMediaExportGenericExtractor* self,
                                                         GstTagList* tags)
{
	gchar* title = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* date = NULL;
	GstDateTime* dt = NULL;
	GstDateTime* _tmp7_ = NULL;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	if (tags == NULL) {
		return;
	}
	title = NULL;
	_tmp1_ = gst_tag_list_get_string (tags, GST_TAG_TITLE, &_tmp0_);
	_g_free0 (title);
	title = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		_tmp3_ = self->priv->mime_type;
		if (g_strcmp0 (_tmp3_, "video/x-msvideo") != 0) {
			const gchar* _tmp4_;
			_tmp4_ = title;
			_tmp2_ = _tmp4_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GVariantDict* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = ((RygelMediaExportExtractor*) self)->serialized_info;
			_tmp6_ = title;
			g_variant_dict_insert (_tmp5_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, "s", _tmp6_, NULL);
		}
	}
	date = NULL;
	dt = NULL;
	_tmp8_ = gst_tag_list_get_date_time (tags, GST_TAG_DATE_TIME, &_tmp7_);
	_gst_date_time_unref0 (dt);
	dt = _tmp7_;
	if (_tmp8_) {
		gboolean _tmp9_ = FALSE;
		GstDateTime* _tmp10_;
		GVariantDict* _tmp22_;
		const gchar* _tmp23_;
		_tmp10_ = dt;
		if (!gst_date_time_has_day (_tmp10_)) {
			_tmp9_ = TRUE;
		} else {
			GstDateTime* _tmp11_;
			_tmp11_ = dt;
			_tmp9_ = !gst_date_time_has_month (_tmp11_);
		}
		if (_tmp9_) {
			gint _tmp12_ = 0;
			GstDateTime* _tmp13_;
			gint _tmp15_ = 0;
			GstDateTime* _tmp16_;
			GstDateTime* _tmp18_;
			gchar* _tmp19_;
			_tmp13_ = dt;
			if (gst_date_time_has_month (_tmp13_)) {
				GstDateTime* _tmp14_;
				_tmp14_ = dt;
				_tmp12_ = gst_date_time_get_month (_tmp14_);
			} else {
				_tmp12_ = 1;
			}
			_tmp16_ = dt;
			if (gst_date_time_has_day (_tmp16_)) {
				GstDateTime* _tmp17_;
				_tmp17_ = dt;
				_tmp15_ = gst_date_time_get_day (_tmp17_);
			} else {
				_tmp15_ = 1;
			}
			_tmp18_ = dt;
			_tmp19_ = g_strdup_printf ("%d-%02d-%02d", gst_date_time_get_year (_tmp18_), _tmp12_, _tmp15_);
			_g_free0 (date);
			date = _tmp19_;
		} else {
			GstDateTime* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = dt;
			_tmp21_ = gst_date_time_to_iso8601_string (_tmp20_);
			_g_free0 (date);
			date = _tmp21_;
		}
		_tmp22_ = ((RygelMediaExportExtractor*) self)->serialized_info;
		_tmp23_ = date;
		g_variant_dict_insert (_tmp22_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _tmp23_, NULL);
	}
	_gst_date_time_unref0 (dt);
	_g_free0 (date);
	_g_free0 (title);
}

static void
rygel_media_export_generic_extractor_class_init (RygelMediaExportGenericExtractorClass * klass,
                                                 gpointer klass_data)
{
	GUPnPDLNAProfileGuesser* _tmp6_;
	GError* _inner_error0_ = NULL;
	rygel_media_export_generic_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportGenericExtractor_private_offset);
	((RygelMediaExportExtractorClass *) klass)->run = (void (*) (RygelMediaExportExtractor*, GAsyncReadyCallback, gpointer)) rygel_media_export_generic_extractor_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = (void (*) (RygelMediaExportExtractor*, GAsyncResult*, GError**)) rygel_media_export_generic_extractor_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_generic_extractor_finalize;
	{
		GstDiscoverer* _tmp0_ = NULL;
		GstDiscoverer* _tmp1_;
		GstDiscoverer* _tmp2_;
		GstDiscoverer* _tmp3_;
		_tmp1_ = gst_discoverer_new ((GstClockTime) (10 * GST_SECOND), &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_discoverer);
		rygel_media_export_generic_extractor_discoverer = _tmp2_;
		_tmp3_ = rygel_media_export_generic_extractor_discoverer;
		gst_discoverer_start (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_debug ("rygel-media-export-generic-extractor.vala:43: Generic extractor unavai" \
"lable: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp6_ = gupnp_dlna_profile_guesser_new (TRUE, TRUE);
	_g_object_unref0 (rygel_media_export_generic_extractor_guesser);
	rygel_media_export_generic_extractor_guesser = _tmp6_;
	{
		MediaArtProcess* _tmp7_ = NULL;
		MediaArtProcess* _tmp8_;
		MediaArtProcess* _tmp9_;
		_tmp8_ = media_art_process_new (&_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (rygel_media_export_generic_extractor_media_art);
		rygel_media_export_generic_extractor_media_art = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to create media art extractor: %s"), _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
rygel_media_export_generic_extractor_instance_init (RygelMediaExportGenericExtractor * self,
                                                    gpointer klass)
{
	self->priv = rygel_media_export_generic_extractor_get_instance_private (self);
}

static void
rygel_media_export_generic_extractor_finalize (GObject * obj)
{
	RygelMediaExportGenericExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor);
	_g_free0 (self->priv->upnp_class);
	_g_free0 (self->priv->mime_type);
	G_OBJECT_CLASS (rygel_media_export_generic_extractor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_media_export_generic_extractor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportGenericExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_generic_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportGenericExtractor), 0, (GInstanceInitFunc) rygel_media_export_generic_extractor_instance_init, NULL };
	GType rygel_media_export_generic_extractor_type_id;
	rygel_media_export_generic_extractor_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, "RygelMediaExportGenericExtractor", &g_define_type_info, 0);
	RygelMediaExportGenericExtractor_private_offset = g_type_add_instance_private (rygel_media_export_generic_extractor_type_id, sizeof (RygelMediaExportGenericExtractorPrivate));
	return rygel_media_export_generic_extractor_type_id;
}

GType
rygel_media_export_generic_extractor_get_type (void)
{
	static volatile gsize rygel_media_export_generic_extractor_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_generic_extractor_type_id__once)) {
		GType rygel_media_export_generic_extractor_type_id;
		rygel_media_export_generic_extractor_type_id = rygel_media_export_generic_extractor_get_type_once ();
		g_once_init_leave (&rygel_media_export_generic_extractor_type_id__once, rygel_media_export_generic_extractor_type_id);
	}
	return rygel_media_export_generic_extractor_type_id__once;
}

