/* MonitorManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MonitorManager.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "display.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_MONITOR_MANAGER_0_PROPERTY,
	DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITORS_PROPERTY,
	DISPLAY_MONITOR_MANAGER_MONITORS_PROPERTY,
	DISPLAY_MONITOR_MANAGER_FRACTIONAL_SCALE_ENABLED_PROPERTY,
	DISPLAY_MONITOR_MANAGER_GLOBAL_SCALE_REQUIRED_PROPERTY,
	DISPLAY_MONITOR_MANAGER_MIRRORING_SUPPORTED_PROPERTY,
	DISPLAY_MONITOR_MANAGER_MAX_WIDTH_PROPERTY,
	DISPLAY_MONITOR_MANAGER_MAX_HEIGHT_PROPERTY,
	DISPLAY_MONITOR_MANAGER_MONITOR_NUMBER_PROPERTY,
	DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITOR_NUMBER_PROPERTY,
	DISPLAY_MONITOR_MANAGER_IS_MIRRORED_PROPERTY,
	DISPLAY_MONITOR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DisplayMonitorManagerPrivate {
	GeeLinkedList* _virtual_monitors;
	GeeLinkedList* _monitors;
	gboolean _fractional_scale_enabled;
	gboolean _global_scale_required;
	gboolean _mirroring_supported;
	gint _max_width;
	gint _max_height;
	MutterDisplayConfigInterface* iface;
	guint current_serial;
};

static gint DisplayMonitorManager_private_offset;
static gpointer display_monitor_manager_parent_class = NULL;
static DisplayMonitorManager* display_monitor_manager_monitor_manager;
static DisplayMonitorManager* display_monitor_manager_monitor_manager = NULL;

static DisplayMonitorManager* display_monitor_manager_new (void);
static DisplayMonitorManager* display_monitor_manager_construct (GType object_type);
static void _vala_MutterReadMonitor_array_free (MutterReadMonitor * array,
                                         gssize array_length);
static void _vala_MutterReadLogicalMonitor_array_free (MutterReadLogicalMonitor * array,
                                                gssize array_length);
static void display_monitor_manager_set_mirroring_supported (DisplayMonitorManager* self,
                                                      gboolean value);
static void display_monitor_manager_set_global_scale_required (DisplayMonitorManager* self,
                                                        gboolean value);
static void display_monitor_manager_set_fractional_scale_enabled (DisplayMonitorManager* self,
                                                           gboolean value);
static void display_monitor_manager_set_max_width (DisplayMonitorManager* self,
                                            gint value);
static void display_monitor_manager_set_max_height (DisplayMonitorManager* self,
                                             gint value);
static DisplayMonitor* display_monitor_manager_get_monitor_by_hash (DisplayMonitorManager* self,
                                                             guint hash);
static gdouble* _vala_array_dup10 (gdouble* self,
                            gssize length);
static DisplayVirtualMonitor* display_monitor_manager_get_virtual_monitor_by_id (DisplayMonitorManager* self,
                                                                          const gchar* id);
static gboolean display_monitor_manager_compare_monitor_with_mutter_info (DisplayMonitor* monitor,
                                                                   MutterReadMonitorInfo* mutter_info);
static void display_monitor_manager_add_virtual_monitor (DisplayMonitorManager* self,
                                                  DisplayVirtualMonitor* virtual_monitor);
static void _vala_array_add2 (MutterWriteLogicalMonitor* * array,
                       gint* length,
                       gint* size,
                       const MutterWriteLogicalMonitor* value);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void _vala_MutterWriteLogicalMonitor_array_free (MutterWriteLogicalMonitor * array,
                                                 gssize array_length);
static void _vala_array_add3 (MutterWriteMonitor* * array,
                       gint* length,
                       gint* size,
                       const MutterWriteMonitor* value);
static MutterWriteMonitor* _vala_array_dup11 (MutterWriteMonitor* self,
                                       gssize length);
static void _vala_MutterWriteMonitor_array_free (MutterWriteMonitor * array,
                                          gssize array_length);
static gboolean _vala_double_array_contains (gdouble * stack,
                                      gssize stack_length,
                                      const gdouble needle);
static GObject * display_monitor_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _display_monitor_manager_get_monitor_config_mutter_display_config_interface_monitors_changed (MutterDisplayConfigInterface* _sender,
                                                                                                   gpointer self);
static void display_monitor_manager_finalize (GObject * obj);
static GType display_monitor_manager_get_type_once (void);
static void _vala_display_monitor_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_display_monitor_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
display_monitor_manager_get_instance_private (DisplayMonitorManager* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayMonitorManager_private_offset);
}

DisplayMonitorManager*
display_monitor_manager_get_default (void)
{
	DisplayMonitorManager* _tmp0_;
	DisplayMonitorManager* _tmp2_;
	DisplayMonitorManager* result;
	_tmp0_ = display_monitor_manager_monitor_manager;
	if (_tmp0_ == NULL) {
		DisplayMonitorManager* _tmp1_;
		_tmp1_ = display_monitor_manager_new ();
		_g_object_unref0 (display_monitor_manager_monitor_manager);
		display_monitor_manager_monitor_manager = _tmp1_;
	}
	_tmp2_ = display_monitor_manager_monitor_manager;
	result = _tmp2_;
	return result;
}

static DisplayMonitorManager*
display_monitor_manager_construct (GType object_type)
{
	DisplayMonitorManager * self = NULL;
	self = (DisplayMonitorManager*) g_object_new (object_type, NULL);
	display_monitor_manager_get_monitor_config (self);
	return self;
}

static DisplayMonitorManager*
display_monitor_manager_new (void)
{
	return display_monitor_manager_construct (DISPLAY_TYPE_MONITOR_MANAGER);
}

static void
_vala_MutterReadMonitor_array_free (MutterReadMonitor * array,
                                    gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_MutterReadLogicalMonitor_array_free (MutterReadLogicalMonitor * array,
                                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_logical_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gdouble*
_vala_array_dup10 (gdouble* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

void
display_monitor_manager_get_monitor_config (DisplayMonitorManager* self)
{
	MutterReadMonitor* mutter_monitors = NULL;
	gint mutter_monitors_length1 = 0;
	gint _mutter_monitors_size_ = 0;
	MutterReadLogicalMonitor* mutter_logical_monitors = NULL;
	gint mutter_logical_monitors_length1 = 0;
	gint _mutter_logical_monitors_size_ = 0;
	GHashTable* properties = NULL;
	GeeLinkedList* _tmp9_;
	GeeLinkedList* _tmp10_;
	GVariant* supports_mirroring_variant = NULL;
	gconstpointer _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* global_scale_required_variant = NULL;
	gconstpointer _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	guint layout_mode = 0U;
	GVariant* layout_mode_variant = NULL;
	gconstpointer _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* max_screen_size_variant = NULL;
	gconstpointer _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	GeeLinkedList* monitors_with_changed_modes = NULL;
	GeeLinkedList* _tmp32_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		MutterDisplayConfigInterface* _tmp0_;
		guint _tmp1_ = 0U;
		MutterReadMonitor* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		MutterReadLogicalMonitor* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GHashTable* _tmp6_ = NULL;
		_tmp0_ = self->priv->iface;
		mutter_display_config_interface_get_current_state (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_inner_error0_);
		self->priv->current_serial = _tmp1_;
		mutter_monitors = (_vala_MutterReadMonitor_array_free (mutter_monitors, mutter_monitors_length1), NULL);
		mutter_monitors = _tmp2_;
		mutter_monitors_length1 = _tmp3_;
		_mutter_monitors_size_ = mutter_monitors_length1;
		mutter_logical_monitors = (_vala_MutterReadLogicalMonitor_array_free (mutter_logical_monitors, mutter_logical_monitors_length1), NULL);
		mutter_logical_monitors = _tmp4_;
		mutter_logical_monitors_length1 = _tmp5_;
		_mutter_logical_monitors_size_ = mutter_logical_monitors_length1;
		_g_hash_table_unref0 (properties);
		properties = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("MonitorManager.vala:83: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (properties);
		mutter_logical_monitors = (_vala_MutterReadLogicalMonitor_array_free (mutter_logical_monitors, mutter_logical_monitors_length1), NULL);
		mutter_monitors = (_vala_MutterReadMonitor_array_free (mutter_monitors, mutter_monitors_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = self->priv->_monitors;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp9_);
	_tmp10_ = self->priv->_virtual_monitors;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	_tmp11_ = g_hash_table_lookup (properties, "supports-mirroring");
	_tmp12_ = _g_variant_ref0 ((GVariant*) _tmp11_);
	supports_mirroring_variant = _tmp12_;
	_tmp13_ = supports_mirroring_variant;
	if (_tmp13_ != NULL) {
		GVariant* _tmp14_;
		_tmp14_ = supports_mirroring_variant;
		display_monitor_manager_set_mirroring_supported (self, g_variant_get_boolean (_tmp14_));
	} else {
		display_monitor_manager_set_mirroring_supported (self, TRUE);
	}
	_tmp15_ = g_hash_table_lookup (properties, "global-scale-required");
	_tmp16_ = _g_variant_ref0 ((GVariant*) _tmp15_);
	global_scale_required_variant = _tmp16_;
	_tmp17_ = global_scale_required_variant;
	if (_tmp17_ != NULL) {
		GVariant* _tmp18_;
		_tmp18_ = global_scale_required_variant;
		display_monitor_manager_set_global_scale_required (self, g_variant_get_boolean (_tmp18_));
	} else {
		display_monitor_manager_set_global_scale_required (self, FALSE);
	}
	layout_mode = (guint) 1;
	_tmp19_ = g_hash_table_lookup (properties, "layout-mode");
	_tmp20_ = _g_variant_ref0 ((GVariant*) _tmp19_);
	layout_mode_variant = _tmp20_;
	_tmp21_ = layout_mode_variant;
	if (_tmp21_ != NULL) {
		GVariant* _tmp22_;
		_tmp22_ = layout_mode_variant;
		layout_mode = (guint) g_variant_get_uint32 (_tmp22_);
	}
	display_monitor_manager_set_fractional_scale_enabled (self, layout_mode == ((guint) 1));
	_tmp23_ = g_hash_table_lookup (properties, "max-screen-size");
	_tmp24_ = _g_variant_ref0 ((GVariant*) _tmp23_);
	max_screen_size_variant = _tmp24_;
	_tmp25_ = max_screen_size_variant;
	if (_tmp25_ != NULL) {
		GVariant* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		GVariant* _tmp31_;
		_tmp26_ = max_screen_size_variant;
		_tmp27_ = g_variant_get_child_value (_tmp26_, (gsize) 0);
		_tmp28_ = _tmp27_;
		display_monitor_manager_set_max_width (self, (gint) g_variant_get_int32 (_tmp28_));
		_g_variant_unref0 (_tmp28_);
		_tmp29_ = max_screen_size_variant;
		_tmp30_ = g_variant_get_child_value (_tmp29_, (gsize) 1);
		_tmp31_ = _tmp30_;
		display_monitor_manager_set_max_height (self, (gint) g_variant_get_int32 (_tmp31_));
		_g_variant_unref0 (_tmp31_);
	} else {
		display_monitor_manager_set_max_width (self, G_MAXINT);
		display_monitor_manager_set_max_height (self, G_MAXINT);
	}
	_tmp32_ = gee_linked_list_new (DISPLAY_TYPE_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	monitors_with_changed_modes = _tmp32_;
	{
		MutterReadMonitor* mutter_monitor_collection = NULL;
		gint mutter_monitor_collection_length1 = 0;
		gint _mutter_monitor_collection_size_ = 0;
		gint mutter_monitor_it = 0;
		mutter_monitor_collection = mutter_monitors;
		mutter_monitor_collection_length1 = mutter_monitors_length1;
		for (mutter_monitor_it = 0; mutter_monitor_it < mutter_monitor_collection_length1; mutter_monitor_it = mutter_monitor_it + 1) {
			MutterReadMonitor _tmp33_;
			MutterReadMonitor _tmp34_ = {0};
			MutterReadMonitor mutter_monitor = {0};
			_tmp33_ = mutter_monitor_collection[mutter_monitor_it];
			mutter_read_monitor_copy (&_tmp33_, &_tmp34_);
			mutter_monitor = _tmp34_;
			{
				DisplayMonitor* monitor = NULL;
				MutterReadMonitor _tmp35_;
				MutterReadMonitorInfo _tmp36_;
				guint _tmp37_;
				guint _tmp38_;
				DisplayMonitor* _tmp39_;
				DisplayMonitor* _tmp40_;
				DisplayMonitor* _tmp46_;
				MutterReadMonitor _tmp47_;
				MutterReadMonitorInfo _tmp48_;
				const gchar* _tmp49_;
				DisplayMonitor* _tmp50_;
				MutterReadMonitor _tmp51_;
				MutterReadMonitorInfo _tmp52_;
				const gchar* _tmp53_;
				DisplayMonitor* _tmp54_;
				MutterReadMonitor _tmp55_;
				MutterReadMonitorInfo _tmp56_;
				const gchar* _tmp57_;
				DisplayMonitor* _tmp58_;
				MutterReadMonitor _tmp59_;
				MutterReadMonitorInfo _tmp60_;
				const gchar* _tmp61_;
				GVariant* display_name_variant = NULL;
				MutterReadMonitor _tmp62_;
				GHashTable* _tmp63_;
				gconstpointer _tmp64_;
				GVariant* _tmp65_;
				GVariant* _tmp66_;
				GVariant* is_builtin_variant = NULL;
				MutterReadMonitor _tmp74_;
				GHashTable* _tmp75_;
				gconstpointer _tmp76_;
				GVariant* _tmp77_;
				GVariant* _tmp78_;
				MutterReadMonitor _tmp82_;
				MutterReadMonitorMode* _tmp83_;
				gint _tmp83__length1;
				_tmp35_ = mutter_monitor;
				_tmp36_ = _tmp35_.monitor;
				_tmp37_ = mutter_read_monitor_info_get_hash (&_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = display_monitor_manager_get_monitor_by_hash (self, _tmp38_);
				monitor = _tmp39_;
				_tmp40_ = monitor;
				if (_tmp40_ == NULL) {
					DisplayMonitor* _tmp41_;
					GeeLinkedList* _tmp42_;
					DisplayMonitor* _tmp43_;
					_tmp41_ = display_monitor_new ();
					_g_object_unref0 (monitor);
					monitor = _tmp41_;
					_tmp42_ = self->priv->_monitors;
					_tmp43_ = monitor;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp43_);
				} else {
					GeeLinkedList* _tmp44_;
					DisplayMonitor* _tmp45_;
					_tmp44_ = monitors_with_changed_modes;
					_tmp45_ = monitor;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
				}
				_tmp46_ = monitor;
				_tmp47_ = mutter_monitor;
				_tmp48_ = _tmp47_.monitor;
				_tmp49_ = _tmp48_.connector;
				display_monitor_set_connector (_tmp46_, _tmp49_);
				_tmp50_ = monitor;
				_tmp51_ = mutter_monitor;
				_tmp52_ = _tmp51_.monitor;
				_tmp53_ = _tmp52_.vendor;
				display_monitor_set_vendor (_tmp50_, _tmp53_);
				_tmp54_ = monitor;
				_tmp55_ = mutter_monitor;
				_tmp56_ = _tmp55_.monitor;
				_tmp57_ = _tmp56_.product;
				display_monitor_set_product (_tmp54_, _tmp57_);
				_tmp58_ = monitor;
				_tmp59_ = mutter_monitor;
				_tmp60_ = _tmp59_.monitor;
				_tmp61_ = _tmp60_.serial;
				display_monitor_set_serial (_tmp58_, _tmp61_);
				_tmp62_ = mutter_monitor;
				_tmp63_ = _tmp62_.properties;
				_tmp64_ = g_hash_table_lookup (_tmp63_, "display-name");
				_tmp65_ = _g_variant_ref0 ((GVariant*) _tmp64_);
				display_name_variant = _tmp65_;
				_tmp66_ = display_name_variant;
				if (_tmp66_ != NULL) {
					DisplayMonitor* _tmp67_;
					GVariant* _tmp68_;
					const gchar* _tmp69_;
					_tmp67_ = monitor;
					_tmp68_ = display_name_variant;
					_tmp69_ = g_variant_get_string (_tmp68_, NULL);
					display_monitor_set_display_name (_tmp67_, _tmp69_);
				} else {
					DisplayMonitor* _tmp70_;
					DisplayMonitor* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					_tmp70_ = monitor;
					_tmp71_ = monitor;
					_tmp72_ = display_monitor_get_connector (_tmp71_);
					_tmp73_ = _tmp72_;
					display_monitor_set_display_name (_tmp70_, _tmp73_);
				}
				_tmp74_ = mutter_monitor;
				_tmp75_ = _tmp74_.properties;
				_tmp76_ = g_hash_table_lookup (_tmp75_, "is-builtin");
				_tmp77_ = _g_variant_ref0 ((GVariant*) _tmp76_);
				is_builtin_variant = _tmp77_;
				_tmp78_ = is_builtin_variant;
				if (_tmp78_ != NULL) {
					DisplayMonitor* _tmp79_;
					GVariant* _tmp80_;
					_tmp79_ = monitor;
					_tmp80_ = is_builtin_variant;
					display_monitor_set_is_builtin (_tmp79_, g_variant_get_boolean (_tmp80_));
				} else {
					DisplayMonitor* _tmp81_;
					_tmp81_ = monitor;
					display_monitor_set_is_builtin (_tmp81_, FALSE);
				}
				_tmp82_ = mutter_monitor;
				_tmp83_ = _tmp82_.modes;
				_tmp83__length1 = _tmp82_.modes_length1;
				{
					MutterReadMonitorMode* mutter_mode_collection = NULL;
					gint mutter_mode_collection_length1 = 0;
					gint _mutter_mode_collection_size_ = 0;
					gint mutter_mode_it = 0;
					mutter_mode_collection = _tmp83_;
					mutter_mode_collection_length1 = _tmp83__length1;
					for (mutter_mode_it = 0; mutter_mode_it < mutter_mode_collection_length1; mutter_mode_it = mutter_mode_it + 1) {
						MutterReadMonitorMode _tmp84_;
						MutterReadMonitorMode _tmp85_ = {0};
						MutterReadMonitorMode mutter_mode = {0};
						_tmp84_ = mutter_mode_collection[mutter_mode_it];
						mutter_read_monitor_mode_copy (&_tmp84_, &_tmp85_);
						mutter_mode = _tmp85_;
						{
							DisplayMonitorMode* mode = NULL;
							DisplayMonitor* _tmp86_;
							MutterReadMonitorMode _tmp87_;
							const gchar* _tmp88_;
							DisplayMonitorMode* _tmp89_;
							DisplayMonitorMode* _tmp90_;
							DisplayMonitorMode* _tmp96_;
							MutterReadMonitorMode _tmp97_;
							const gchar* _tmp98_;
							DisplayMonitorMode* _tmp99_;
							MutterReadMonitorMode _tmp100_;
							DisplayMonitorMode* _tmp101_;
							MutterReadMonitorMode _tmp102_;
							DisplayMonitorMode* _tmp103_;
							MutterReadMonitorMode _tmp104_;
							DisplayMonitorMode* _tmp105_;
							MutterReadMonitorMode _tmp106_;
							DisplayMonitorMode* _tmp107_;
							MutterReadMonitorMode _tmp108_;
							gdouble* _tmp109_;
							gint _tmp109__length1;
							gdouble* _tmp110_;
							gint _tmp110__length1;
							GVariant* is_preferred_variant = NULL;
							MutterReadMonitorMode _tmp111_;
							GHashTable* _tmp112_;
							gconstpointer _tmp113_;
							GVariant* _tmp114_;
							GVariant* _tmp115_;
							GVariant* is_current_variant = NULL;
							MutterReadMonitorMode _tmp119_;
							GHashTable* _tmp120_;
							gconstpointer _tmp121_;
							GVariant* _tmp122_;
							GVariant* _tmp123_;
							_tmp86_ = monitor;
							_tmp87_ = mutter_mode;
							_tmp88_ = _tmp87_.id;
							_tmp89_ = display_monitor_get_mode_by_id (_tmp86_, _tmp88_);
							mode = _tmp89_;
							_tmp90_ = mode;
							if (_tmp90_ == NULL) {
								DisplayMonitorMode* _tmp91_;
								DisplayMonitor* _tmp92_;
								GeeLinkedList* _tmp93_;
								GeeLinkedList* _tmp94_;
								DisplayMonitorMode* _tmp95_;
								_tmp91_ = display_monitor_mode_new ();
								_g_object_unref0 (mode);
								mode = _tmp91_;
								_tmp92_ = monitor;
								_tmp93_ = display_monitor_get_modes (_tmp92_);
								_tmp94_ = _tmp93_;
								_tmp95_ = mode;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, _tmp95_);
							}
							_tmp96_ = mode;
							_tmp97_ = mutter_mode;
							_tmp98_ = _tmp97_.id;
							display_monitor_mode_set_id (_tmp96_, _tmp98_);
							_tmp99_ = mode;
							_tmp100_ = mutter_mode;
							display_monitor_mode_set_width (_tmp99_, _tmp100_.width);
							_tmp101_ = mode;
							_tmp102_ = mutter_mode;
							display_monitor_mode_set_height (_tmp101_, _tmp102_.height);
							_tmp103_ = mode;
							_tmp104_ = mutter_mode;
							display_monitor_mode_set_frequency (_tmp103_, _tmp104_.frequency);
							_tmp105_ = mode;
							_tmp106_ = mutter_mode;
							display_monitor_mode_set_preferred_scale (_tmp105_, _tmp106_.preferred_scale);
							_tmp107_ = mode;
							_tmp108_ = mutter_mode;
							_tmp109_ = _tmp108_.supported_scales;
							_tmp109__length1 = _tmp108_.supported_scales_length1;
							_tmp110_ = (_tmp109_ != NULL) ? _vala_array_dup10 (_tmp109_, _tmp109__length1) : _tmp109_;
							_tmp110__length1 = _tmp109__length1;
							_tmp107_->supported_scales = (g_free (_tmp107_->supported_scales), NULL);
							_tmp107_->supported_scales = _tmp110_;
							_tmp107_->supported_scales_length1 = _tmp110__length1;
							_tmp111_ = mutter_mode;
							_tmp112_ = _tmp111_.properties;
							_tmp113_ = g_hash_table_lookup (_tmp112_, "is-preferred");
							_tmp114_ = _g_variant_ref0 ((GVariant*) _tmp113_);
							is_preferred_variant = _tmp114_;
							_tmp115_ = is_preferred_variant;
							if (_tmp115_ != NULL) {
								DisplayMonitorMode* _tmp116_;
								GVariant* _tmp117_;
								_tmp116_ = mode;
								_tmp117_ = is_preferred_variant;
								display_monitor_mode_set_is_preferred (_tmp116_, g_variant_get_boolean (_tmp117_));
							} else {
								DisplayMonitorMode* _tmp118_;
								_tmp118_ = mode;
								display_monitor_mode_set_is_preferred (_tmp118_, FALSE);
							}
							_tmp119_ = mutter_mode;
							_tmp120_ = _tmp119_.properties;
							_tmp121_ = g_hash_table_lookup (_tmp120_, "is-current");
							_tmp122_ = _g_variant_ref0 ((GVariant*) _tmp121_);
							is_current_variant = _tmp122_;
							_tmp123_ = is_current_variant;
							if (_tmp123_ != NULL) {
								DisplayMonitorMode* _tmp124_;
								GVariant* _tmp125_;
								_tmp124_ = mode;
								_tmp125_ = is_current_variant;
								display_monitor_mode_set_is_current (_tmp124_, g_variant_get_boolean (_tmp125_));
							} else {
								DisplayMonitorMode* _tmp126_;
								_tmp126_ = mode;
								display_monitor_mode_set_is_current (_tmp126_, FALSE);
							}
							_g_variant_unref0 (is_current_variant);
							_g_variant_unref0 (is_preferred_variant);
							_g_object_unref0 (mode);
							mutter_read_monitor_mode_destroy (&mutter_mode);
						}
					}
				}
				_g_variant_unref0 (is_builtin_variant);
				_g_variant_unref0 (display_name_variant);
				_g_object_unref0 (monitor);
				mutter_read_monitor_destroy (&mutter_monitor);
			}
		}
	}
	{
		MutterReadLogicalMonitor* mutter_logical_monitor_collection = NULL;
		gint mutter_logical_monitor_collection_length1 = 0;
		gint _mutter_logical_monitor_collection_size_ = 0;
		gint mutter_logical_monitor_it = 0;
		mutter_logical_monitor_collection = mutter_logical_monitors;
		mutter_logical_monitor_collection_length1 = mutter_logical_monitors_length1;
		for (mutter_logical_monitor_it = 0; mutter_logical_monitor_it < mutter_logical_monitor_collection_length1; mutter_logical_monitor_it = mutter_logical_monitor_it + 1) {
			MutterReadLogicalMonitor _tmp127_;
			MutterReadLogicalMonitor _tmp128_ = {0};
			MutterReadLogicalMonitor mutter_logical_monitor = {0};
			_tmp127_ = mutter_logical_monitor_collection[mutter_logical_monitor_it];
			mutter_read_logical_monitor_copy (&_tmp127_, &_tmp128_);
			mutter_logical_monitor = _tmp128_;
			{
				gchar* monitors_id = NULL;
				MutterReadLogicalMonitor _tmp129_;
				MutterReadMonitorInfo* _tmp130_;
				gint _tmp130__length1;
				gchar* _tmp131_;
				DisplayVirtualMonitor* virtual_monitor = NULL;
				const gchar* _tmp132_;
				DisplayVirtualMonitor* _tmp133_;
				DisplayVirtualMonitor* _tmp134_;
				MutterReadLogicalMonitor _tmp136_;
				MutterReadMonitorInfo* _tmp137_;
				gint _tmp137__length1;
				DisplayVirtualMonitor* _tmp161_;
				MutterReadLogicalMonitor _tmp162_;
				DisplayVirtualMonitor* _tmp163_;
				MutterReadLogicalMonitor _tmp164_;
				DisplayVirtualMonitor* _tmp165_;
				MutterReadLogicalMonitor _tmp166_;
				DisplayVirtualMonitor* _tmp167_;
				MutterReadLogicalMonitor _tmp168_;
				DisplayVirtualMonitor* _tmp169_;
				MutterReadLogicalMonitor _tmp170_;
				DisplayVirtualMonitor* _tmp171_;
				MutterReadLogicalMonitor _tmp172_;
				DisplayVirtualMonitor* _tmp173_;
				MutterReadLogicalMonitor _tmp174_;
				DisplayVirtualMonitor* _tmp175_;
				_tmp129_ = mutter_logical_monitor;
				_tmp130_ = _tmp129_.monitors;
				_tmp130__length1 = _tmp129_.monitors_length1;
				_tmp131_ = display_virtual_monitor_generate_id_from_monitors (_tmp130_, (gint) _tmp130__length1);
				monitors_id = _tmp131_;
				_tmp132_ = monitors_id;
				_tmp133_ = display_monitor_manager_get_virtual_monitor_by_id (self, _tmp132_);
				virtual_monitor = _tmp133_;
				_tmp134_ = virtual_monitor;
				if (_tmp134_ == NULL) {
					DisplayVirtualMonitor* _tmp135_;
					_tmp135_ = display_virtual_monitor_new ();
					_g_object_unref0 (virtual_monitor);
					virtual_monitor = _tmp135_;
				}
				_tmp136_ = mutter_logical_monitor;
				_tmp137_ = _tmp136_.monitors;
				_tmp137__length1 = _tmp136_.monitors_length1;
				{
					MutterReadMonitorInfo* mutter_info_collection = NULL;
					gint mutter_info_collection_length1 = 0;
					gint _mutter_info_collection_size_ = 0;
					gint mutter_info_it = 0;
					mutter_info_collection = _tmp137_;
					mutter_info_collection_length1 = _tmp137__length1;
					for (mutter_info_it = 0; mutter_info_it < mutter_info_collection_length1; mutter_info_it = mutter_info_it + 1) {
						MutterReadMonitorInfo _tmp138_;
						MutterReadMonitorInfo _tmp139_ = {0};
						MutterReadMonitorInfo mutter_info = {0};
						_tmp138_ = mutter_info_collection[mutter_info_it];
						mutter_read_monitor_info_copy (&_tmp138_, &_tmp139_);
						mutter_info = _tmp139_;
						{
							{
								GeeLinkedList* _monitor_list = NULL;
								GeeLinkedList* _tmp140_;
								gint _monitor_size = 0;
								GeeLinkedList* _tmp141_;
								gint _tmp142_;
								gint _tmp143_;
								gint _monitor_index = 0;
								_tmp140_ = self->priv->_monitors;
								_monitor_list = _tmp140_;
								_tmp141_ = _monitor_list;
								_tmp142_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp141_);
								_tmp143_ = _tmp142_;
								_monitor_size = _tmp143_;
								_monitor_index = -1;
								while (TRUE) {
									gint _tmp144_;
									gint _tmp145_;
									DisplayMonitor* monitor = NULL;
									GeeLinkedList* _tmp146_;
									gpointer _tmp147_;
									DisplayMonitor* _tmp148_;
									MutterReadMonitorInfo _tmp149_;
									_monitor_index = _monitor_index + 1;
									_tmp144_ = _monitor_index;
									_tmp145_ = _monitor_size;
									if (!(_tmp144_ < _tmp145_)) {
										break;
									}
									_tmp146_ = _monitor_list;
									_tmp147_ = gee_abstract_list_get ((GeeAbstractList*) _tmp146_, _monitor_index);
									monitor = (DisplayMonitor*) _tmp147_;
									_tmp148_ = monitor;
									_tmp149_ = mutter_info;
									if (display_monitor_manager_compare_monitor_with_mutter_info (_tmp148_, &_tmp149_)) {
										DisplayVirtualMonitor* _tmp150_;
										GeeLinkedList* _tmp151_;
										GeeLinkedList* _tmp152_;
										DisplayMonitor* _tmp153_;
										GeeLinkedList* _tmp158_;
										DisplayMonitor* _tmp159_;
										_tmp150_ = virtual_monitor;
										_tmp151_ = display_virtual_monitor_get_monitors (_tmp150_);
										_tmp152_ = _tmp151_;
										_tmp153_ = monitor;
										if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp152_, _tmp153_)) {
											DisplayVirtualMonitor* _tmp154_;
											GeeLinkedList* _tmp155_;
											GeeLinkedList* _tmp156_;
											DisplayMonitor* _tmp157_;
											_tmp154_ = virtual_monitor;
											_tmp155_ = display_virtual_monitor_get_monitors (_tmp154_);
											_tmp156_ = _tmp155_;
											_tmp157_ = monitor;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp156_, _tmp157_);
										}
										_tmp158_ = monitors_with_changed_modes;
										_tmp159_ = monitor;
										if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp158_, _tmp159_)) {
											DisplayVirtualMonitor* _tmp160_;
											_tmp160_ = virtual_monitor;
											g_signal_emit_by_name (_tmp160_, "modes-changed");
										}
										_g_object_unref0 (monitor);
										break;
									}
									_g_object_unref0 (monitor);
								}
							}
							mutter_read_monitor_info_destroy (&mutter_info);
						}
					}
				}
				_tmp161_ = virtual_monitor;
				_tmp162_ = mutter_logical_monitor;
				display_virtual_monitor_set_x (_tmp161_, _tmp162_.x);
				_tmp163_ = virtual_monitor;
				_tmp164_ = mutter_logical_monitor;
				display_virtual_monitor_set_y (_tmp163_, _tmp164_.y);
				_tmp165_ = virtual_monitor;
				_tmp166_ = mutter_logical_monitor;
				display_virtual_monitor_set_current_x (_tmp165_, _tmp166_.x);
				_tmp167_ = virtual_monitor;
				_tmp168_ = mutter_logical_monitor;
				display_virtual_monitor_set_current_y (_tmp167_, _tmp168_.y);
				_tmp169_ = virtual_monitor;
				_tmp170_ = mutter_logical_monitor;
				display_virtual_monitor_set_scale (_tmp169_, _tmp170_.scale);
				_tmp171_ = virtual_monitor;
				_tmp172_ = mutter_logical_monitor;
				display_virtual_monitor_set_transform (_tmp171_, _tmp172_.transform);
				_tmp173_ = virtual_monitor;
				_tmp174_ = mutter_logical_monitor;
				display_virtual_monitor_set_primary (_tmp173_, _tmp174_.primary);
				_tmp175_ = virtual_monitor;
				display_monitor_manager_add_virtual_monitor (self, _tmp175_);
				_g_object_unref0 (virtual_monitor);
				_g_free0 (monitors_id);
				mutter_read_logical_monitor_destroy (&mutter_logical_monitor);
			}
		}
	}
	{
		GeeLinkedList* _monitor_list = NULL;
		GeeLinkedList* _tmp176_;
		gint _monitor_size = 0;
		GeeLinkedList* _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gint _monitor_index = 0;
		_tmp176_ = self->priv->_monitors;
		_monitor_list = _tmp176_;
		_tmp177_ = _monitor_list;
		_tmp178_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp177_);
		_tmp179_ = _tmp178_;
		_monitor_size = _tmp179_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp180_;
			gint _tmp181_;
			DisplayMonitor* monitor = NULL;
			GeeLinkedList* _tmp182_;
			gpointer _tmp183_;
			gboolean found = FALSE;
			_monitor_index = _monitor_index + 1;
			_tmp180_ = _monitor_index;
			_tmp181_ = _monitor_size;
			if (!(_tmp180_ < _tmp181_)) {
				break;
			}
			_tmp182_ = _monitor_list;
			_tmp183_ = gee_abstract_list_get ((GeeAbstractList*) _tmp182_, _monitor_index);
			monitor = (DisplayMonitor*) _tmp183_;
			found = FALSE;
			{
				GeeLinkedList* _virtual_monitor_list = NULL;
				GeeLinkedList* _tmp184_;
				gint _virtual_monitor_size = 0;
				GeeLinkedList* _tmp185_;
				gint _tmp186_;
				gint _tmp187_;
				gint _virtual_monitor_index = 0;
				_tmp184_ = self->priv->_virtual_monitors;
				_virtual_monitor_list = _tmp184_;
				_tmp185_ = _virtual_monitor_list;
				_tmp186_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp185_);
				_tmp187_ = _tmp186_;
				_virtual_monitor_size = _tmp187_;
				_virtual_monitor_index = -1;
				while (TRUE) {
					gint _tmp188_;
					gint _tmp189_;
					DisplayVirtualMonitor* virtual_monitor = NULL;
					GeeLinkedList* _tmp190_;
					gpointer _tmp191_;
					DisplayVirtualMonitor* _tmp192_;
					GeeLinkedList* _tmp193_;
					GeeLinkedList* _tmp194_;
					DisplayMonitor* _tmp195_;
					_virtual_monitor_index = _virtual_monitor_index + 1;
					_tmp188_ = _virtual_monitor_index;
					_tmp189_ = _virtual_monitor_size;
					if (!(_tmp188_ < _tmp189_)) {
						break;
					}
					_tmp190_ = _virtual_monitor_list;
					_tmp191_ = gee_abstract_list_get ((GeeAbstractList*) _tmp190_, _virtual_monitor_index);
					virtual_monitor = (DisplayVirtualMonitor*) _tmp191_;
					_tmp192_ = virtual_monitor;
					_tmp193_ = display_virtual_monitor_get_monitors (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = monitor;
					if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp194_, _tmp195_)) {
						found = TRUE;
						_g_object_unref0 (virtual_monitor);
						break;
					}
					_g_object_unref0 (virtual_monitor);
				}
			}
			if (!found) {
				DisplayVirtualMonitor* virtual_monitor = NULL;
				DisplayVirtualMonitor* _tmp196_;
				DisplayVirtualMonitor* _tmp197_;
				DisplayVirtualMonitor* _tmp198_;
				DisplayVirtualMonitor* _tmp199_;
				GeeLinkedList* _tmp200_;
				GeeLinkedList* _tmp201_;
				DisplayMonitor* _tmp202_;
				DisplayVirtualMonitor* _tmp203_;
				GeeLinkedList* _tmp204_;
				gpointer _tmp205_;
				DisplayVirtualMonitor* _tmp206_;
				gdouble _tmp207_;
				gdouble _tmp208_;
				DisplayVirtualMonitor* _tmp209_;
				_tmp196_ = display_virtual_monitor_new ();
				virtual_monitor = _tmp196_;
				_tmp197_ = virtual_monitor;
				display_virtual_monitor_set_is_active (_tmp197_, FALSE);
				_tmp198_ = virtual_monitor;
				display_virtual_monitor_set_primary (_tmp198_, FALSE);
				_tmp199_ = virtual_monitor;
				_tmp200_ = display_virtual_monitor_get_monitors (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp202_ = monitor;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp201_, _tmp202_);
				_tmp203_ = virtual_monitor;
				_tmp204_ = self->priv->_virtual_monitors;
				_tmp205_ = gee_abstract_list_get ((GeeAbstractList*) _tmp204_, 0);
				_tmp206_ = (DisplayVirtualMonitor*) _tmp205_;
				_tmp207_ = display_virtual_monitor_get_scale (_tmp206_);
				_tmp208_ = _tmp207_;
				display_virtual_monitor_set_scale (_tmp203_, _tmp208_);
				_g_object_unref0 (_tmp206_);
				_tmp209_ = virtual_monitor;
				display_monitor_manager_add_virtual_monitor (self, _tmp209_);
				_g_object_unref0 (virtual_monitor);
			}
			_g_object_unref0 (monitor);
		}
	}
	_g_object_unref0 (monitors_with_changed_modes);
	_g_variant_unref0 (max_screen_size_variant);
	_g_variant_unref0 (layout_mode_variant);
	_g_variant_unref0 (global_scale_required_variant);
	_g_variant_unref0 (supports_mirroring_variant);
	_g_hash_table_unref0 (properties);
	mutter_logical_monitors = (_vala_MutterReadLogicalMonitor_array_free (mutter_logical_monitors, mutter_logical_monitors_length1), NULL);
	mutter_monitors = (_vala_MutterReadMonitor_array_free (mutter_monitors, mutter_monitors_length1), NULL);
}

static void
_vala_array_add2 (MutterWriteLogicalMonitor* * array,
                  gint* length,
                  gint* size,
                  const MutterWriteLogicalMonitor* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (MutterWriteLogicalMonitor, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
_vala_MutterWriteLogicalMonitor_array_free (MutterWriteLogicalMonitor * array,
                                            gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_write_logical_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

void
display_monitor_manager_set_monitor_config (DisplayMonitorManager* self,
                                            GError** error)
{
	MutterWriteLogicalMonitor* logical_monitors = NULL;
	MutterWriteLogicalMonitor* _tmp0_;
	gint logical_monitors_length1;
	gint _logical_monitors_size_;
	gint min_x = 0;
	gint min_y = 0;
	MutterWriteLogicalMonitor* _tmp14_;
	gint _tmp14__length1;
	gboolean _tmp17_ = FALSE;
	GHashTable* properties = NULL;
	GHashFunc _tmp25_;
	GEqualFunc _tmp26_;
	GHashTable* _tmp27_;
	MutterDisplayConfigInterface* _tmp28_;
	MutterWriteLogicalMonitor* _tmp29_;
	gint _tmp29__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (MutterWriteLogicalMonitor, 0);
	logical_monitors = _tmp0_;
	logical_monitors_length1 = 0;
	_logical_monitors_size_ = logical_monitors_length1;
	{
		GeeLinkedList* _virtual_monitor_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _virtual_monitor_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _virtual_monitor_index = 0;
		_tmp1_ = self->priv->_virtual_monitors;
		_virtual_monitor_list = _tmp1_;
		_tmp2_ = _virtual_monitor_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_virtual_monitor_size = _tmp4_;
		_virtual_monitor_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			DisplayVirtualMonitor* virtual_monitor = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			DisplayVirtualMonitor* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_virtual_monitor_index = _virtual_monitor_index + 1;
			_tmp5_ = _virtual_monitor_index;
			_tmp6_ = _virtual_monitor_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _virtual_monitor_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _virtual_monitor_index);
			virtual_monitor = (DisplayVirtualMonitor*) _tmp8_;
			_tmp9_ = virtual_monitor;
			_tmp10_ = display_virtual_monitor_get_is_active (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				DisplayVirtualMonitor* _tmp12_;
				MutterWriteLogicalMonitor _tmp13_ = {0};
				_tmp12_ = virtual_monitor;
				display_monitor_manager_get_mutter_logical_monitor (_tmp12_, &_tmp13_);
				_vala_array_add2 (&logical_monitors, &logical_monitors_length1, &_logical_monitors_size_, &_tmp13_);
			}
			_g_object_unref0 (virtual_monitor);
		}
	}
	min_x = G_MAXINT;
	min_y = G_MAXINT;
	_tmp14_ = logical_monitors;
	_tmp14__length1 = logical_monitors_length1;
	{
		MutterWriteLogicalMonitor* logical_monitor_collection = NULL;
		gint logical_monitor_collection_length1 = 0;
		gint _logical_monitor_collection_size_ = 0;
		gint logical_monitor_it = 0;
		logical_monitor_collection = _tmp14_;
		logical_monitor_collection_length1 = _tmp14__length1;
		for (logical_monitor_it = 0; logical_monitor_it < logical_monitor_collection_length1; logical_monitor_it = logical_monitor_it + 1) {
			MutterWriteLogicalMonitor logical_monitor = {0};
			logical_monitor = logical_monitor_collection[logical_monitor_it];
			{
				MutterWriteLogicalMonitor _tmp15_;
				MutterWriteLogicalMonitor _tmp16_;
				_tmp15_ = logical_monitor;
				min_x = MIN (min_x, _tmp15_.x);
				_tmp16_ = logical_monitor;
				min_y = MIN (min_y, _tmp16_.y);
			}
		}
	}
	if (min_x != 0) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = min_y != 0;
	}
	if (_tmp17_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					MutterWriteLogicalMonitor* _tmp20_;
					gint _tmp20__length1;
					MutterWriteLogicalMonitor* _tmp21_;
					gint _tmp21__length1;
					MutterWriteLogicalMonitor* _tmp22_;
					gint _tmp22__length1;
					MutterWriteLogicalMonitor* _tmp23_;
					gint _tmp23__length1;
					MutterWriteLogicalMonitor* _tmp24_;
					gint _tmp24__length1;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = logical_monitors;
					_tmp20__length1 = logical_monitors_length1;
					if (!(i < _tmp20__length1)) {
						break;
					}
					_tmp21_ = logical_monitors;
					_tmp21__length1 = logical_monitors_length1;
					_tmp22_ = logical_monitors;
					_tmp22__length1 = logical_monitors_length1;
					_tmp22_[i].x = _tmp22_[i].x - min_x;
					_tmp23_ = logical_monitors;
					_tmp23__length1 = logical_monitors_length1;
					_tmp24_ = logical_monitors;
					_tmp24__length1 = logical_monitors_length1;
					_tmp24_[i].y = _tmp24_[i].y - min_y;
				}
			}
		}
	}
	_tmp25_ = g_str_hash;
	_tmp26_ = g_str_equal;
	_tmp27_ = g_hash_table_new_full (_tmp25_, _tmp26_, _g_free0_, _g_variant_unref0_);
	properties = _tmp27_;
	_tmp28_ = self->priv->iface;
	_tmp29_ = logical_monitors;
	_tmp29__length1 = logical_monitors_length1;
	mutter_display_config_interface_apply_monitors_config (_tmp28_, self->priv->current_serial, MUTTER_APPLY_METHOD_PERSISTENT, _tmp29_, (gint) _tmp29__length1, properties, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (properties);
		logical_monitors = (_vala_MutterWriteLogicalMonitor_array_free (logical_monitors, logical_monitors_length1), NULL);
		return;
	}
	_g_hash_table_unref0 (properties);
	logical_monitors = (_vala_MutterWriteLogicalMonitor_array_free (logical_monitors, logical_monitors_length1), NULL);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
_vala_array_add3 (MutterWriteMonitor* * array,
                  gint* length,
                  gint* size,
                  const MutterWriteMonitor* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (MutterWriteMonitor, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static MutterWriteMonitor*
_vala_array_dup11 (MutterWriteMonitor* self,
                   gssize length)
{
	if (length > 0) {
		MutterWriteMonitor* result;
		gssize i;
		result = g_new0 (MutterWriteMonitor, length);
		for (i = 0; i < length; i++) {
			MutterWriteMonitor _tmp0_;
			MutterWriteMonitor _tmp1_ = {0};
			_tmp0_ = self[i];
			mutter_write_monitor_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_MutterWriteMonitor_array_free (MutterWriteMonitor * array,
                                     gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_write_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

void
display_monitor_manager_get_mutter_logical_monitor (DisplayVirtualMonitor* virtual_monitor,
                                                    MutterWriteLogicalMonitor* result)
{
	MutterWriteLogicalMonitor logical_monitor = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	DisplayTransform _tmp6_;
	DisplayTransform _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	MutterWriteLogicalMonitor _tmp10_ = {0};
	MutterWriteMonitor* mutter_monitors = NULL;
	MutterWriteMonitor* _tmp11_;
	gint mutter_monitors_length1;
	gint _mutter_monitors_size_;
	MutterWriteMonitor* _tmp42_;
	gint _tmp42__length1;
	MutterWriteMonitor* _tmp43_;
	gint _tmp43__length1;
	g_return_if_fail (virtual_monitor != NULL);
	_tmp0_ = display_virtual_monitor_get_x (virtual_monitor);
	_tmp1_ = _tmp0_;
	_tmp2_ = display_virtual_monitor_get_y (virtual_monitor);
	_tmp3_ = _tmp2_;
	_tmp4_ = display_virtual_monitor_get_scale (virtual_monitor);
	_tmp5_ = _tmp4_;
	_tmp6_ = display_virtual_monitor_get_transform (virtual_monitor);
	_tmp7_ = _tmp6_;
	_tmp8_ = display_virtual_monitor_get_primary (virtual_monitor);
	_tmp9_ = _tmp8_;
	memset (&_tmp10_, 0, sizeof (MutterWriteLogicalMonitor));
	_tmp10_.x = _tmp1_;
	_tmp10_.y = _tmp3_;
	_tmp10_.scale = _tmp5_;
	_tmp10_.transform = _tmp7_;
	_tmp10_.primary = _tmp9_;
	logical_monitor = _tmp10_;
	_tmp11_ = g_new0 (MutterWriteMonitor, 0);
	mutter_monitors = _tmp11_;
	mutter_monitors_length1 = 0;
	_mutter_monitors_size_ = mutter_monitors_length1;
	{
		GeeLinkedList* _monitor_list = NULL;
		GeeLinkedList* _tmp12_;
		GeeLinkedList* _tmp13_;
		gint _monitor_size = 0;
		GeeLinkedList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _monitor_index = 0;
		_tmp12_ = display_virtual_monitor_get_monitors (virtual_monitor);
		_tmp13_ = _tmp12_;
		_monitor_list = _tmp13_;
		_tmp14_ = _monitor_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_monitor_size = _tmp16_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			DisplayMonitor* monitor = NULL;
			GeeLinkedList* _tmp19_;
			gpointer _tmp20_;
			GHashTable* properties = NULL;
			GHashFunc _tmp21_;
			GEqualFunc _tmp22_;
			GHashTable* _tmp23_;
			MutterWriteMonitor mutter_monitor = {0};
			DisplayMonitor* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			DisplayMonitor* _tmp28_;
			DisplayMonitorMode* _tmp29_;
			DisplayMonitorMode* _tmp30_;
			DisplayMonitorMode* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			GHashTable* _tmp35_;
			GHashTable* _tmp36_;
			MutterWriteMonitor _tmp37_ = {0};
			MutterWriteMonitor _tmp38_;
			MutterWriteMonitor _tmp39_;
			MutterWriteMonitor _tmp40_;
			MutterWriteMonitor _tmp41_ = {0};
			_monitor_index = _monitor_index + 1;
			_tmp17_ = _monitor_index;
			_tmp18_ = _monitor_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _monitor_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _monitor_index);
			monitor = (DisplayMonitor*) _tmp20_;
			_tmp21_ = g_str_hash;
			_tmp22_ = g_str_equal;
			_tmp23_ = g_hash_table_new_full (_tmp21_, _tmp22_, _g_free0_, _g_variant_unref0_);
			properties = _tmp23_;
			_tmp24_ = monitor;
			_tmp25_ = display_monitor_get_connector (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup (_tmp26_);
			_tmp28_ = monitor;
			_tmp29_ = display_monitor_get_current_mode (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = display_monitor_mode_get_id (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strdup (_tmp33_);
			_tmp35_ = properties;
			_tmp36_ = _g_hash_table_ref0 (_tmp35_);
			memset (&_tmp37_, 0, sizeof (MutterWriteMonitor));
			_g_free0 (_tmp37_.connector);
			_tmp37_.connector = _tmp27_;
			_g_free0 (_tmp37_.monitor_mode);
			_tmp37_.monitor_mode = _tmp34_;
			_g_hash_table_unref0 (_tmp37_.properties);
			_tmp37_.properties = _tmp36_;
			_tmp38_ = _tmp37_;
			_g_object_unref0 (_tmp31_);
			mutter_monitor = _tmp38_;
			_tmp39_ = mutter_monitor;
			_tmp40_ = _tmp39_;
			mutter_write_monitor_copy (&_tmp40_, &_tmp41_);
			_vala_array_add3 (&mutter_monitors, &mutter_monitors_length1, &_mutter_monitors_size_, &_tmp41_);
			mutter_write_monitor_destroy (&mutter_monitor);
			_g_hash_table_unref0 (properties);
			_g_object_unref0 (monitor);
		}
	}
	_tmp42_ = mutter_monitors;
	_tmp42__length1 = mutter_monitors_length1;
	_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup11 (_tmp42_, _tmp42__length1) : _tmp42_;
	_tmp43__length1 = _tmp42__length1;
	logical_monitor.monitors = (_vala_MutterWriteMonitor_array_free (logical_monitor.monitors, logical_monitor.monitors_length1), NULL);
	logical_monitor.monitors = _tmp43_;
	logical_monitor.monitors_length1 = _tmp43__length1;
	*result = logical_monitor;
	mutter_monitors = (_vala_MutterWriteMonitor_array_free (mutter_monitors, mutter_monitors_length1), NULL);
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
display_monitor_manager_enable_clone_mode (DisplayMonitorManager* self)
{
	DisplayVirtualMonitor* clone_virtual_monitor = NULL;
	DisplayVirtualMonitor* _tmp0_;
	DisplayVirtualMonitor* _tmp1_;
	DisplayVirtualMonitor* _tmp2_;
	GeeLinkedList* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp5_;
	DisplayVirtualMonitor* _tmp6_;
	GeeLinkedList* _tmp7_;
	GeeLinkedList* modes = NULL;
	DisplayVirtualMonitor* _tmp8_;
	GeeLinkedList* _tmp9_;
	DisplayMonitorMode* largest_mode_in_use = NULL;
	DisplayMonitorMode* largest_mode = NULL;
	GeeLinkedList* _tmp10_;
	gpointer _tmp11_;
	DisplayMonitorMode* _tmp46_;
	GeeLinkedList* _tmp51_;
	GeeLinkedList* _tmp52_;
	DisplayVirtualMonitor* _tmp53_;
	g_return_if_fail (self != NULL);
	_tmp0_ = display_virtual_monitor_new ();
	clone_virtual_monitor = _tmp0_;
	_tmp1_ = clone_virtual_monitor;
	display_virtual_monitor_set_primary (_tmp1_, TRUE);
	_tmp2_ = clone_virtual_monitor;
	_tmp3_ = display_virtual_monitor_get_monitors (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_monitors;
	gee_collection_add_all ((GeeCollection*) _tmp4_, (GeeCollection*) _tmp5_);
	_tmp6_ = clone_virtual_monitor;
	_tmp7_ = self->priv->_monitors;
	display_virtual_monitor_set_scale (_tmp6_, display_utils_get_min_compatible_scale (_tmp7_));
	_tmp8_ = clone_virtual_monitor;
	_tmp9_ = display_virtual_monitor_get_available_modes (_tmp8_);
	modes = _tmp9_;
	largest_mode_in_use = NULL;
	_tmp10_ = modes;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, 0);
	largest_mode = (DisplayMonitorMode*) _tmp11_;
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp12_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _mode_index = 0;
		_tmp12_ = modes;
		_mode_list = _tmp12_;
		_tmp13_ = _mode_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_mode_size = _tmp15_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp18_;
			gpointer _tmp19_;
			DisplayMonitorMode* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			DisplayMonitorMode* _tmp34_;
			_mode_index = _mode_index + 1;
			_tmp16_ = _mode_index;
			_tmp17_ = _mode_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _mode_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp19_;
			_tmp20_ = mode;
			_tmp21_ = display_monitor_mode_get_is_current (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				DisplayMonitorMode* _tmp23_;
				_tmp23_ = largest_mode_in_use;
				if (_tmp23_ == NULL) {
					DisplayMonitorMode* _tmp24_;
					DisplayMonitorMode* _tmp25_;
					_tmp24_ = mode;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					_g_object_unref0 (largest_mode_in_use);
					largest_mode_in_use = _tmp25_;
				} else {
					DisplayMonitorMode* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					DisplayMonitorMode* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					_tmp26_ = largest_mode_in_use;
					_tmp27_ = display_monitor_mode_get_width (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = mode;
					_tmp30_ = display_monitor_mode_get_width (_tmp29_);
					_tmp31_ = _tmp30_;
					if (_tmp28_ < _tmp31_) {
						DisplayMonitorMode* _tmp32_;
						DisplayMonitorMode* _tmp33_;
						_tmp32_ = mode;
						_tmp33_ = _g_object_ref0 (_tmp32_);
						_g_object_unref0 (largest_mode_in_use);
						largest_mode_in_use = _tmp33_;
					}
				}
			}
			_tmp34_ = largest_mode_in_use;
			if (_tmp34_ == NULL) {
				DisplayMonitorMode* _tmp35_;
				_tmp35_ = largest_mode;
				if (_tmp35_ == NULL) {
					DisplayMonitorMode* _tmp36_;
					DisplayMonitorMode* _tmp37_;
					_tmp36_ = mode;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					_g_object_unref0 (largest_mode);
					largest_mode = _tmp37_;
				} else {
					DisplayMonitorMode* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					DisplayMonitorMode* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					_tmp38_ = largest_mode;
					_tmp39_ = display_monitor_mode_get_width (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = mode;
					_tmp42_ = display_monitor_mode_get_width (_tmp41_);
					_tmp43_ = _tmp42_;
					if (_tmp40_ < _tmp43_) {
						DisplayMonitorMode* _tmp44_;
						DisplayMonitorMode* _tmp45_;
						_tmp44_ = mode;
						_tmp45_ = _g_object_ref0 (_tmp44_);
						_g_object_unref0 (largest_mode);
						largest_mode = _tmp45_;
					}
				}
			}
			_g_object_unref0 (mode);
		}
	}
	_tmp46_ = largest_mode_in_use;
	if (_tmp46_ != NULL) {
		DisplayVirtualMonitor* _tmp47_;
		DisplayMonitorMode* _tmp48_;
		_tmp47_ = clone_virtual_monitor;
		_tmp48_ = largest_mode_in_use;
		display_virtual_monitor_set_current_mode (_tmp47_, _tmp48_);
	} else {
		DisplayVirtualMonitor* _tmp49_;
		DisplayMonitorMode* _tmp50_;
		_tmp49_ = clone_virtual_monitor;
		_tmp50_ = largest_mode;
		display_virtual_monitor_set_current_mode (_tmp49_, _tmp50_);
	}
	_tmp51_ = self->priv->_virtual_monitors;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp51_);
	_tmp52_ = self->priv->_virtual_monitors;
	_tmp53_ = clone_virtual_monitor;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
	g_object_notify ((GObject*) self, "virtual-monitor-number");
	g_object_notify ((GObject*) self, "is-mirrored");
	_g_object_unref0 (largest_mode);
	_g_object_unref0 (largest_mode_in_use);
	_g_object_unref0 (modes);
	_g_object_unref0 (clone_virtual_monitor);
}

void
display_monitor_manager_set_scale_on_all_monitors (DisplayMonitorManager* self,
                                                   gdouble new_scale,
                                                   GError** error)
{
	gdouble max_scale = 0.0;
	GeeLinkedList* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (new_scale <= 0.0) {
		return;
	}
	_tmp0_ = self->priv->_monitors;
	max_scale = display_utils_get_min_compatible_scale (_tmp0_);
	if (new_scale > max_scale) {
		return;
	}
	{
		GeeLinkedList* _monitor_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _monitor_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _monitor_index = 0;
		_tmp1_ = self->priv->_virtual_monitors;
		_monitor_list = _tmp1_;
		_tmp2_ = _monitor_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_monitor_size = _tmp4_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			DisplayVirtualMonitor* monitor = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			DisplayVirtualMonitor* _tmp9_;
			_monitor_index = _monitor_index + 1;
			_tmp5_ = _monitor_index;
			_tmp6_ = _monitor_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _monitor_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _monitor_index);
			monitor = (DisplayVirtualMonitor*) _tmp8_;
			_tmp9_ = monitor;
			display_virtual_monitor_set_scale (_tmp9_, new_scale);
			_g_object_unref0 (monitor);
		}
	}
	display_monitor_manager_set_monitor_config (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gboolean
_vala_double_array_contains (gdouble * stack,
                             gssize stack_length,
                             const gdouble needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

void
display_monitor_manager_disable_clone_mode (DisplayMonitorManager* self)
{
	gdouble max_scale = 0.0;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* new_virtual_monitors = NULL;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp61_;
	gpointer _tmp62_;
	DisplayVirtualMonitor* _tmp63_;
	GeeLinkedList* _tmp64_;
	GeeLinkedList* _tmp65_;
	GeeLinkedList* _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitors;
	max_scale = display_utils_get_min_compatible_scale (_tmp0_);
	_tmp1_ = gee_linked_list_new (DISPLAY_TYPE_VIRTUAL_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	new_virtual_monitors = _tmp1_;
	{
		GeeLinkedList* _monitor_list = NULL;
		GeeLinkedList* _tmp2_;
		gint _monitor_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _monitor_index = 0;
		_tmp2_ = self->priv->_monitors;
		_monitor_list = _tmp2_;
		_tmp3_ = _monitor_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_monitor_size = _tmp5_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			DisplayMonitor* monitor = NULL;
			GeeLinkedList* _tmp8_;
			gpointer _tmp9_;
			DisplayVirtualMonitor* single_virtual_monitor = NULL;
			DisplayVirtualMonitor* _tmp10_;
			DisplayMonitorMode* preferred_mode = NULL;
			DisplayMonitor* _tmp11_;
			DisplayMonitorMode* _tmp12_;
			DisplayMonitorMode* _tmp13_;
			DisplayMonitorMode* current_mode = NULL;
			DisplayMonitor* _tmp14_;
			DisplayMonitorMode* _tmp15_;
			DisplayMonitorMode* _tmp16_;
			DisplayVirtualMonitor* _tmp17_;
			GeeLinkedList* _tmp18_;
			GeeLinkedList* _tmp19_;
			DisplayMonitor* _tmp20_;
			gboolean _tmp21_;
			GeeLinkedList* _tmp59_;
			DisplayVirtualMonitor* _tmp60_;
			_monitor_index = _monitor_index + 1;
			_tmp6_ = _monitor_index;
			_tmp7_ = _monitor_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _monitor_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _monitor_index);
			monitor = (DisplayMonitor*) _tmp9_;
			_tmp10_ = display_virtual_monitor_new ();
			single_virtual_monitor = _tmp10_;
			_tmp11_ = monitor;
			_tmp12_ = display_monitor_get_preferred_mode (_tmp11_);
			_tmp13_ = _tmp12_;
			preferred_mode = _tmp13_;
			_tmp14_ = monitor;
			_tmp15_ = display_monitor_get_current_mode (_tmp14_);
			_tmp16_ = _tmp15_;
			current_mode = _tmp16_;
			_tmp17_ = single_virtual_monitor;
			_tmp18_ = display_virtual_monitor_get_monitors (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = monitor;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
			_tmp21_ = self->priv->_global_scale_required;
			if (_tmp21_) {
				DisplayVirtualMonitor* _tmp22_;
				DisplayMonitorMode* _tmp23_;
				gdouble* _tmp24_;
				gint _tmp24__length1;
				_tmp22_ = single_virtual_monitor;
				display_virtual_monitor_set_scale (_tmp22_, max_scale);
				_tmp23_ = preferred_mode;
				_tmp24_ = _tmp23_->supported_scales;
				_tmp24__length1 = _tmp23_->supported_scales_length1;
				if (_vala_double_array_contains (_tmp24_, _tmp24__length1, max_scale)) {
					DisplayMonitorMode* _tmp25_;
					DisplayMonitorMode* _tmp26_;
					_tmp25_ = current_mode;
					display_monitor_mode_set_is_current (_tmp25_, FALSE);
					_tmp26_ = preferred_mode;
					display_monitor_mode_set_is_current (_tmp26_, TRUE);
				} else {
					DisplayMonitorMode* _tmp27_;
					gdouble* _tmp28_;
					gint _tmp28__length1;
					_tmp27_ = current_mode;
					_tmp28_ = _tmp27_->supported_scales;
					_tmp28__length1 = _tmp27_->supported_scales_length1;
					if (!_vala_double_array_contains (_tmp28_, _tmp28__length1, max_scale)) {
						DisplayMonitorMode* largest_mode = NULL;
						DisplayMonitorMode* _tmp51_;
						DisplayMonitorMode* _tmp52_;
						largest_mode = NULL;
						{
							GeeLinkedList* _mode_list = NULL;
							DisplayMonitor* _tmp29_;
							GeeLinkedList* _tmp30_;
							GeeLinkedList* _tmp31_;
							gint _mode_size = 0;
							GeeLinkedList* _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _mode_index = 0;
							_tmp29_ = monitor;
							_tmp30_ = display_monitor_get_modes (_tmp29_);
							_tmp31_ = _tmp30_;
							_mode_list = _tmp31_;
							_tmp32_ = _mode_list;
							_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
							_tmp34_ = _tmp33_;
							_mode_size = _tmp34_;
							_mode_index = -1;
							while (TRUE) {
								gint _tmp35_;
								gint _tmp36_;
								DisplayMonitorMode* mode = NULL;
								GeeLinkedList* _tmp37_;
								gpointer _tmp38_;
								DisplayMonitorMode* _tmp39_;
								gdouble* _tmp40_;
								gint _tmp40__length1;
								_mode_index = _mode_index + 1;
								_tmp35_ = _mode_index;
								_tmp36_ = _mode_size;
								if (!(_tmp35_ < _tmp36_)) {
									break;
								}
								_tmp37_ = _mode_list;
								_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _mode_index);
								mode = (DisplayMonitorMode*) _tmp38_;
								_tmp39_ = mode;
								_tmp40_ = _tmp39_->supported_scales;
								_tmp40__length1 = _tmp39_->supported_scales_length1;
								if (_vala_double_array_contains (_tmp40_, _tmp40__length1, max_scale)) {
									gboolean _tmp41_ = FALSE;
									DisplayMonitorMode* _tmp42_;
									_tmp42_ = largest_mode;
									if (_tmp42_ == NULL) {
										_tmp41_ = TRUE;
									} else {
										DisplayMonitorMode* _tmp43_;
										gint _tmp44_;
										gint _tmp45_;
										DisplayMonitorMode* _tmp46_;
										gint _tmp47_;
										gint _tmp48_;
										_tmp43_ = mode;
										_tmp44_ = display_monitor_mode_get_width (_tmp43_);
										_tmp45_ = _tmp44_;
										_tmp46_ = largest_mode;
										_tmp47_ = display_monitor_mode_get_width (_tmp46_);
										_tmp48_ = _tmp47_;
										_tmp41_ = _tmp45_ > _tmp48_;
									}
									if (_tmp41_) {
										DisplayMonitorMode* _tmp49_;
										DisplayMonitorMode* _tmp50_;
										_tmp49_ = mode;
										_tmp50_ = _g_object_ref0 (_tmp49_);
										_g_object_unref0 (largest_mode);
										largest_mode = _tmp50_;
									}
								}
								_g_object_unref0 (mode);
							}
						}
						_tmp51_ = current_mode;
						display_monitor_mode_set_is_current (_tmp51_, FALSE);
						_tmp52_ = largest_mode;
						display_monitor_mode_set_is_current (_tmp52_, TRUE);
						_g_object_unref0 (largest_mode);
					}
				}
			} else {
				DisplayMonitorMode* _tmp53_;
				DisplayMonitorMode* _tmp54_;
				DisplayVirtualMonitor* _tmp55_;
				DisplayMonitorMode* _tmp56_;
				gdouble _tmp57_;
				gdouble _tmp58_;
				_tmp53_ = current_mode;
				display_monitor_mode_set_is_current (_tmp53_, FALSE);
				_tmp54_ = preferred_mode;
				display_monitor_mode_set_is_current (_tmp54_, TRUE);
				_tmp55_ = single_virtual_monitor;
				_tmp56_ = preferred_mode;
				_tmp57_ = display_monitor_mode_get_preferred_scale (_tmp56_);
				_tmp58_ = _tmp57_;
				display_virtual_monitor_set_scale (_tmp55_, _tmp58_);
			}
			_tmp59_ = new_virtual_monitors;
			_tmp60_ = single_virtual_monitor;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, _tmp60_);
			_g_object_unref0 (current_mode);
			_g_object_unref0 (preferred_mode);
			_g_object_unref0 (single_virtual_monitor);
			_g_object_unref0 (monitor);
		}
	}
	_tmp61_ = new_virtual_monitors;
	_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, 0);
	_tmp63_ = (DisplayVirtualMonitor*) _tmp62_;
	display_virtual_monitor_set_primary (_tmp63_, TRUE);
	_g_object_unref0 (_tmp63_);
	_tmp64_ = self->priv->_virtual_monitors;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp64_);
	_tmp65_ = self->priv->_virtual_monitors;
	_tmp66_ = new_virtual_monitors;
	gee_collection_add_all ((GeeCollection*) _tmp65_, (GeeCollection*) _tmp66_);
	g_object_notify ((GObject*) self, "virtual-monitor-number");
	g_object_notify ((GObject*) self, "is-mirrored");
	_g_object_unref0 (new_virtual_monitors);
}

static void
display_monitor_manager_add_virtual_monitor (DisplayMonitorManager* self,
                                             DisplayVirtualMonitor* virtual_monitor)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (virtual_monitor != NULL);
	_tmp0_ = self->priv->_virtual_monitors;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, virtual_monitor);
	g_object_notify ((GObject*) self, "virtual-monitor-number");
}

static DisplayVirtualMonitor*
display_monitor_manager_get_virtual_monitor_by_id (DisplayMonitorManager* self,
                                                   const gchar* id)
{
	DisplayVirtualMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		GeeLinkedList* _vm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _vm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _vm_index = 0;
		_tmp0_ = self->priv->_virtual_monitors;
		_vm_list = _tmp0_;
		_tmp1_ = _vm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_vm_size = _tmp3_;
		_vm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayVirtualMonitor* vm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayVirtualMonitor* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			_vm_index = _vm_index + 1;
			_tmp4_ = _vm_index;
			_tmp5_ = _vm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _vm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _vm_index);
			vm = (DisplayVirtualMonitor*) _tmp7_;
			_tmp8_ = vm;
			_tmp9_ = display_virtual_monitor_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, id) == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				result = vm;
				return result;
			}
			_g_object_unref0 (vm);
		}
	}
	result = NULL;
	return result;
}

static gboolean
display_monitor_manager_compare_monitor_with_mutter_info (DisplayMonitor* monitor,
                                                          MutterReadMonitorInfo* mutter_info)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	MutterReadMonitorInfo _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (monitor != NULL, FALSE);
	g_return_val_if_fail (mutter_info != NULL, FALSE);
	_tmp3_ = display_monitor_get_connector (monitor);
	_tmp4_ = _tmp3_;
	_tmp5_ = *mutter_info;
	_tmp6_ = _tmp5_.connector;
	if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		MutterReadMonitorInfo _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = display_monitor_get_vendor (monitor);
		_tmp8_ = _tmp7_;
		_tmp9_ = *mutter_info;
		_tmp10_ = _tmp9_.vendor;
		_tmp2_ = g_strcmp0 (_tmp8_, _tmp10_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		MutterReadMonitorInfo _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = display_monitor_get_product (monitor);
		_tmp12_ = _tmp11_;
		_tmp13_ = *mutter_info;
		_tmp14_ = _tmp13_.product;
		_tmp1_ = g_strcmp0 (_tmp12_, _tmp14_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		MutterReadMonitorInfo _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = display_monitor_get_serial (monitor);
		_tmp16_ = _tmp15_;
		_tmp17_ = *mutter_info;
		_tmp18_ = _tmp17_.serial;
		_tmp0_ = g_strcmp0 (_tmp16_, _tmp18_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static DisplayMonitor*
display_monitor_manager_get_monitor_by_hash (DisplayMonitorManager* self,
                                             guint hash)
{
	DisplayMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _monitor_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _monitor_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->_monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitor* monitor = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayMonitor* _tmp8_;
			guint _tmp9_;
			guint _tmp10_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _monitor_index);
			monitor = (DisplayMonitor*) _tmp7_;
			_tmp8_ = monitor;
			_tmp9_ = display_monitor_get_hash (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == hash) {
				result = monitor;
				return result;
			}
			_g_object_unref0 (monitor);
		}
	}
	result = NULL;
	return result;
}

GeeLinkedList*
display_monitor_manager_get_virtual_monitors (DisplayMonitorManager* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_virtual_monitors;
	result = _tmp0_;
	return result;
}

static void
display_monitor_manager_set_virtual_monitors (DisplayMonitorManager* self,
                                              GeeLinkedList* value)
{
	GeeLinkedList* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_virtual_monitors (self);
	if (old_value != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_virtual_monitors);
		self->priv->_virtual_monitors = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITORS_PROPERTY]);
	}
}

GeeLinkedList*
display_monitor_manager_get_monitors (DisplayMonitorManager* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_monitors;
	result = _tmp0_;
	return result;
}

static void
display_monitor_manager_set_monitors (DisplayMonitorManager* self,
                                      GeeLinkedList* value)
{
	GeeLinkedList* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_monitors (self);
	if (old_value != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_monitors);
		self->priv->_monitors = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MONITORS_PROPERTY]);
	}
}

gboolean
display_monitor_manager_get_fractional_scale_enabled (DisplayMonitorManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fractional_scale_enabled;
	return result;
}

static void
display_monitor_manager_set_fractional_scale_enabled (DisplayMonitorManager* self,
                                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_fractional_scale_enabled (self);
	if (old_value != value) {
		self->priv->_fractional_scale_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_FRACTIONAL_SCALE_ENABLED_PROPERTY]);
	}
}

gboolean
display_monitor_manager_get_global_scale_required (DisplayMonitorManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_global_scale_required;
	return result;
}

static void
display_monitor_manager_set_global_scale_required (DisplayMonitorManager* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_global_scale_required (self);
	if (old_value != value) {
		self->priv->_global_scale_required = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_GLOBAL_SCALE_REQUIRED_PROPERTY]);
	}
}

gboolean
display_monitor_manager_get_mirroring_supported (DisplayMonitorManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mirroring_supported;
	return result;
}

static void
display_monitor_manager_set_mirroring_supported (DisplayMonitorManager* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_mirroring_supported (self);
	if (old_value != value) {
		self->priv->_mirroring_supported = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MIRRORING_SUPPORTED_PROPERTY]);
	}
}

gint
display_monitor_manager_get_max_width (DisplayMonitorManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_width;
	return result;
}

static void
display_monitor_manager_set_max_width (DisplayMonitorManager* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_max_width (self);
	if (old_value != value) {
		self->priv->_max_width = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MAX_WIDTH_PROPERTY]);
	}
}

gint
display_monitor_manager_get_max_height (DisplayMonitorManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_height;
	return result;
}

static void
display_monitor_manager_set_max_height (DisplayMonitorManager* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_manager_get_max_height (self);
	if (old_value != value) {
		self->priv->_max_height = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MAX_HEIGHT_PROPERTY]);
	}
}

gint
display_monitor_manager_get_monitor_number (DisplayMonitorManager* self)
{
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_monitors;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
display_monitor_manager_get_virtual_monitor_number (DisplayMonitorManager* self)
{
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_virtual_monitors;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
display_monitor_manager_get_is_mirrored (DisplayMonitorManager* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_virtual_monitors;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 1) {
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->_monitors;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ > 1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
_display_monitor_manager_get_monitor_config_mutter_display_config_interface_monitors_changed (MutterDisplayConfigInterface* _sender,
                                                                                              gpointer self)
{
	display_monitor_manager_get_monitor_config ((DisplayMonitorManager*) self);
}

static GObject *
display_monitor_manager_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayMonitorManager * self;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (display_monitor_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_MONITOR_MANAGER, DisplayMonitorManager);
	_tmp0_ = gee_linked_list_new (DISPLAY_TYPE_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	display_monitor_manager_set_monitors (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_linked_list_new (DISPLAY_TYPE_VIRTUAL_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	display_monitor_manager_set_virtual_monitors (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		MutterDisplayConfigInterface* _tmp4_ = NULL;
		MutterDisplayConfigInterface* _tmp5_;
		MutterDisplayConfigInterface* _tmp6_;
		MutterDisplayConfigInterface* _tmp7_;
		_tmp5_ = (MutterDisplayConfigInterface*) g_initable_new (TYPE_MUTTER_DISPLAY_CONFIG_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.Mutter.DisplayConfig", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Mutter/DisplayConfig", "g-interface-name", "org.gnome.Mutter.DisplayConfig", NULL);
		_tmp4_ = (MutterDisplayConfigInterface*) _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->iface);
		self->priv->iface = _tmp6_;
		_tmp7_ = self->priv->iface;
		g_signal_connect_object (_tmp7_, "monitors-changed", (GCallback) _display_monitor_manager_get_monitor_config_mutter_display_config_interface_monitors_changed, self, 0);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("MonitorManager.vala:72: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
display_monitor_manager_class_init (DisplayMonitorManagerClass * klass,
                                    gpointer klass_data)
{
	display_monitor_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayMonitorManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_monitor_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_monitor_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = display_monitor_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = display_monitor_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITORS_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITORS_PROPERTY] = g_param_spec_object ("virtual-monitors", "virtual-monitors", "virtual-monitors", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_MONITORS_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MONITORS_PROPERTY] = g_param_spec_object ("monitors", "monitors", "monitors", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_FRACTIONAL_SCALE_ENABLED_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_FRACTIONAL_SCALE_ENABLED_PROPERTY] = g_param_spec_boolean ("fractional-scale-enabled", "fractional-scale-enabled", "fractional-scale-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_GLOBAL_SCALE_REQUIRED_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_GLOBAL_SCALE_REQUIRED_PROPERTY] = g_param_spec_boolean ("global-scale-required", "global-scale-required", "global-scale-required", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_MIRRORING_SUPPORTED_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MIRRORING_SUPPORTED_PROPERTY] = g_param_spec_boolean ("mirroring-supported", "mirroring-supported", "mirroring-supported", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_MAX_WIDTH_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MAX_WIDTH_PROPERTY] = g_param_spec_int ("max-width", "max-width", "max-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_MAX_HEIGHT_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MAX_HEIGHT_PROPERTY] = g_param_spec_int ("max-height", "max-height", "max-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_MONITOR_NUMBER_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_MONITOR_NUMBER_PROPERTY] = g_param_spec_int ("monitor-number", "monitor-number", "monitor-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITOR_NUMBER_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITOR_NUMBER_PROPERTY] = g_param_spec_int ("virtual-monitor-number", "virtual-monitor-number", "virtual-monitor-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MANAGER_IS_MIRRORED_PROPERTY, display_monitor_manager_properties[DISPLAY_MONITOR_MANAGER_IS_MIRRORED_PROPERTY] = g_param_spec_boolean ("is-mirrored", "is-mirrored", "is-mirrored", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
display_monitor_manager_instance_init (DisplayMonitorManager * self,
                                       gpointer klass)
{
	self->priv = display_monitor_manager_get_instance_private (self);
}

static void
display_monitor_manager_finalize (GObject * obj)
{
	DisplayMonitorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_MONITOR_MANAGER, DisplayMonitorManager);
	_g_object_unref0 (self->priv->_virtual_monitors);
	_g_object_unref0 (self->priv->_monitors);
	_g_object_unref0 (self->priv->iface);
	G_OBJECT_CLASS (display_monitor_manager_parent_class)->finalize (obj);
}

static GType
display_monitor_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayMonitorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_monitor_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayMonitorManager), 0, (GInstanceInitFunc) display_monitor_manager_instance_init, NULL };
	GType display_monitor_manager_type_id;
	display_monitor_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DisplayMonitorManager", &g_define_type_info, 0);
	DisplayMonitorManager_private_offset = g_type_add_instance_private (display_monitor_manager_type_id, sizeof (DisplayMonitorManagerPrivate));
	return display_monitor_manager_type_id;
}

GType
display_monitor_manager_get_type (void)
{
	static volatile gsize display_monitor_manager_type_id__once = 0;
	if (g_once_init_enter (&display_monitor_manager_type_id__once)) {
		GType display_monitor_manager_type_id;
		display_monitor_manager_type_id = display_monitor_manager_get_type_once ();
		g_once_init_leave (&display_monitor_manager_type_id__once, display_monitor_manager_type_id);
	}
	return display_monitor_manager_type_id__once;
}

static void
_vala_display_monitor_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	DisplayMonitorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_MONITOR_MANAGER, DisplayMonitorManager);
	switch (property_id) {
		case DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITORS_PROPERTY:
		g_value_set_object (value, display_monitor_manager_get_virtual_monitors (self));
		break;
		case DISPLAY_MONITOR_MANAGER_MONITORS_PROPERTY:
		g_value_set_object (value, display_monitor_manager_get_monitors (self));
		break;
		case DISPLAY_MONITOR_MANAGER_FRACTIONAL_SCALE_ENABLED_PROPERTY:
		g_value_set_boolean (value, display_monitor_manager_get_fractional_scale_enabled (self));
		break;
		case DISPLAY_MONITOR_MANAGER_GLOBAL_SCALE_REQUIRED_PROPERTY:
		g_value_set_boolean (value, display_monitor_manager_get_global_scale_required (self));
		break;
		case DISPLAY_MONITOR_MANAGER_MIRRORING_SUPPORTED_PROPERTY:
		g_value_set_boolean (value, display_monitor_manager_get_mirroring_supported (self));
		break;
		case DISPLAY_MONITOR_MANAGER_MAX_WIDTH_PROPERTY:
		g_value_set_int (value, display_monitor_manager_get_max_width (self));
		break;
		case DISPLAY_MONITOR_MANAGER_MAX_HEIGHT_PROPERTY:
		g_value_set_int (value, display_monitor_manager_get_max_height (self));
		break;
		case DISPLAY_MONITOR_MANAGER_MONITOR_NUMBER_PROPERTY:
		g_value_set_int (value, display_monitor_manager_get_monitor_number (self));
		break;
		case DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITOR_NUMBER_PROPERTY:
		g_value_set_int (value, display_monitor_manager_get_virtual_monitor_number (self));
		break;
		case DISPLAY_MONITOR_MANAGER_IS_MIRRORED_PROPERTY:
		g_value_set_boolean (value, display_monitor_manager_get_is_mirrored (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_monitor_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	DisplayMonitorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_MONITOR_MANAGER, DisplayMonitorManager);
	switch (property_id) {
		case DISPLAY_MONITOR_MANAGER_VIRTUAL_MONITORS_PROPERTY:
		display_monitor_manager_set_virtual_monitors (self, g_value_get_object (value));
		break;
		case DISPLAY_MONITOR_MANAGER_MONITORS_PROPERTY:
		display_monitor_manager_set_monitors (self, g_value_get_object (value));
		break;
		case DISPLAY_MONITOR_MANAGER_FRACTIONAL_SCALE_ENABLED_PROPERTY:
		display_monitor_manager_set_fractional_scale_enabled (self, g_value_get_boolean (value));
		break;
		case DISPLAY_MONITOR_MANAGER_GLOBAL_SCALE_REQUIRED_PROPERTY:
		display_monitor_manager_set_global_scale_required (self, g_value_get_boolean (value));
		break;
		case DISPLAY_MONITOR_MANAGER_MIRRORING_SUPPORTED_PROPERTY:
		display_monitor_manager_set_mirroring_supported (self, g_value_get_boolean (value));
		break;
		case DISPLAY_MONITOR_MANAGER_MAX_WIDTH_PROPERTY:
		display_monitor_manager_set_max_width (self, g_value_get_int (value));
		break;
		case DISPLAY_MONITOR_MANAGER_MAX_HEIGHT_PROPERTY:
		display_monitor_manager_set_max_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

