/* Device.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Device.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */
/* Functions and classes for handling disk partitions */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;
typedef struct _DevicePrivate DevicePrivate;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;
enum  {
	DEVICE_0_PROPERTY,
	DEVICE_FREE_BYTES_PROPERTY,
	DEVICE_SIZE_PROPERTY,
	DEVICE_USED_PROPERTY,
	DEVICE_FREE_PROPERTY,
	DEVICE_IS_MOUNTED_PROPERTY,
	DEVICE_FULL_NAME_WITH_ALIAS_PROPERTY,
	DEVICE_FULL_NAME_WITH_PARENT_PROPERTY,
	DEVICE_SHORT_NAME_WITH_ALIAS_PROPERTY,
	DEVICE_SHORT_NAME_WITH_PARENT_PROPERTY,
	DEVICE_DEVICE_NAME_WITH_PARENT_PROPERTY,
	DEVICE_NUM_PROPERTIES
};
static GParamSpec* device_properties[DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MountEntryPrivate MountEntryPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TIMEOUT_COUNTER (timeout_counter_get_type ())
#define TIMEOUT_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMEOUT_COUNTER, TimeoutCounter))
#define TIMEOUT_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMEOUT_COUNTER, TimeoutCounterClass))
#define IS_TIMEOUT_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMEOUT_COUNTER))
#define IS_TIMEOUT_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMEOUT_COUNTER))
#define TIMEOUT_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMEOUT_COUNTER, TimeoutCounterClass))

typedef struct _TimeoutCounter TimeoutCounter;
typedef struct _TimeoutCounterClass TimeoutCounterClass;

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _MountEntry {
	GObject parent_instance;
	MountEntryPrivate * priv;
	Device* device;
	gchar* mount_point;
	gchar* mount_options;
};

struct _MountEntryClass {
	GObjectClass parent_class;
};

static gpointer device_parent_class = NULL;
VALA_EXTERN gdouble device_KB;
gdouble device_KB = (gdouble) 1000;
VALA_EXTERN gdouble device_MB;
gdouble device_MB = 0.0;
VALA_EXTERN gdouble device_GB;
gdouble device_GB = 0.0;
VALA_EXTERN gdouble device_KiB;
gdouble device_KiB = (gdouble) 1024;
VALA_EXTERN gdouble device_MiB;
gdouble device_MiB = 0.0;
VALA_EXTERN gdouble device_GiB;
gdouble device_GiB = 0.0;
static gchar* device_lsblk_version;
static gchar* device_lsblk_version = NULL;
static gboolean device_lsblk_is_ancient;
static gboolean device_lsblk_is_ancient = FALSE;
static GeeArrayList* device_device_list;
static GeeArrayList* device_device_list = NULL;
VALA_EXTERN gboolean tee_jee_logging_LOG_DEBUG;

VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN Device* device_new (void);
VALA_EXTERN Device* device_construct (GType object_type);
VALA_EXTERN void device_test_lsblk_version (void);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN gboolean device_is_mounted_at_path (Device* self,
                                    const gchar* subvolname,
                                    const gchar* mount_path);
VALA_EXTERN gboolean device_type_is_raid (Device* self);
VALA_EXTERN gboolean device_has_linux_filesystem (Device* self);
VALA_EXTERN gboolean device_is_encrypted_partition (Device* self);
VALA_EXTERN gboolean device_is_on_encrypted_partition (Device* self);
VALA_EXTERN gboolean device_is_lvm_partition (Device* self);
VALA_EXTERN gboolean device_has_children (Device* self);
VALA_EXTERN Device* device_first_linux_child (Device* self);
VALA_EXTERN gboolean device_has_parent (Device* self);
VALA_EXTERN GeeArrayList* device_get_filesystems (gboolean get_space,
                                      gboolean get_mounts);
VALA_EXTERN GeeArrayList* device_get_block_devices_using_lsblk (const gchar* dev_name);
VALA_EXTERN GeeArrayList* device_get_disk_space_using_df (const gchar* dev_name_or_mount_point);
VALA_EXTERN Device* device_find_device_in_list (GeeArrayList* list,
                                    const gchar* _dev_alias);
VALA_EXTERN GeeArrayList* device_get_mounted_filesystems_using_mtab (void);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
static void device_find_child_devices (GeeArrayList* list,
                                Device* parent);
static void device_find_toplevel_parent (GeeArrayList* list,
                                  Device* dev);
static void device_find_child_devices_using_dmsetup (GeeArrayList* list);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gint device_remove_parents (GeeArrayList* list,
                            Device* dev);
VALA_EXTERN MountEntry* mount_entry_new (Device* device,
                             const gchar* mount_point,
                             const gchar* mount_options);
VALA_EXTERN MountEntry* mount_entry_construct (GType object_type,
                                   Device* device,
                                   const gchar* mount_point,
                                   const gchar* mount_options);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN GeeArrayList* device_get_block_devices_using_blkid (const gchar* dev_name);
VALA_EXTERN gint tee_jee_process_helper_exec_script_sync (const gchar* script,
                                              gchar** std_out,
                                              gchar** std_err,
                                              gboolean supress_errors,
                                              gboolean run_as_admin,
                                              gboolean cleanup_tmp,
                                              gboolean print_to_terminal);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gchar* device_resolve_device_name (const gchar* dev_alias);
VALA_EXTERN gchar* device_get_device_uuid (const gchar* device);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN Device* device_get_device_by_uuid (const gchar* uuid);
VALA_EXTERN Device* device_get_device_by_name (const gchar* file_name);
VALA_EXTERN Device* device_get_device_by_path (const gchar* path_to_check);
VALA_EXTERN GeeArrayList* device_get_device_mount_points (const gchar* dev_name_or_uuid);
VALA_EXTERN gboolean device_device_is_mounted (const gchar* dev_name_or_uuid);
VALA_EXTERN gboolean device_mount_point_in_use (const gchar* mount_point);
VALA_EXTERN gboolean tee_jee_file_system_file_is_symlink (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_get_symlink_target (const gchar* file_path);
VALA_EXTERN void device_copy_fields_from (Device* self,
                              Device* dev2);
VALA_EXTERN Device* device_query_changes (Device* self);
VALA_EXTERN void device_query_disk_space (Device* self);
VALA_EXTERN gboolean device_automount_udisks (const gchar* dev_name_or_uuid,
                                  GtkWindow* parent_window);
VALA_EXTERN void tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean is_error);
VALA_EXTERN gboolean device_automount_udisks_iso (const gchar* iso_file_path,
                                      gchar** loop_device,
                                      GtkWindow* parent_window);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean device_unmount_udisks (const gchar* dev_name_or_uuid,
                                GtkWindow* parent_window);
VALA_EXTERN Device* device_luks_unlock (Device* luks_device,
                            const gchar* mapped_name,
                            const gchar* passphrase,
                            GtkWindow* parent_window,
                            gchar** message,
                            gchar** details);
VALA_EXTERN GType timeout_counter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeoutCounter, g_object_unref)
VALA_EXTERN TimeoutCounter* timeout_counter_new (void);
VALA_EXTERN TimeoutCounter* timeout_counter_construct (GType object_type);
VALA_EXTERN void timeout_counter_kill_process_on_timeout (TimeoutCounter* self,
                                              const gchar* process_to_kill,
                                              gint seconds_to_wait,
                                              gboolean exit_app);
VALA_EXTERN void timeout_counter_stop (TimeoutCounter* self);
VALA_EXTERN gchar* tee_jee_gtk_helper_gtk_inputbox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean mask_password);
VALA_EXTERN gboolean device_luks_lock (const gchar* kname,
                           GtkWindow* parent_window);
VALA_EXTERN gboolean device_mount (const gchar* dev_name_or_uuid,
                       const gchar* mount_point,
                       const gchar* mount_options,
                       gboolean silent);
VALA_EXTERN gboolean tee_jee_file_system_dir_create (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN gboolean device_unmount (const gchar* mount_point);
VALA_EXTERN gchar* device_get_device_name_with_parent (Device* self);
VALA_EXTERN gchar* device_automount (const gchar* dev_name_or_uuid,
                         const gchar* mount_options,
                         const gchar* mount_prefix);
VALA_EXTERN gchar* device_description (Device* self);
VALA_EXTERN gchar* device_description_formatted (Device* self);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN gchar* device_get_short_name_with_parent (Device* self);
VALA_EXTERN gchar* device_description_simple (Device* self);
VALA_EXTERN gchar* device_description_simple_formatted (Device* self);
VALA_EXTERN gchar* device_description_full_free (Device* self);
VALA_EXTERN guint64 device_get_free_bytes (Device* self);
VALA_EXTERN gchar* device_description_free (Device* self);
VALA_EXTERN gchar* device_description_full (Device* self);
VALA_EXTERN gchar* device_get_used (Device* self);
VALA_EXTERN gchar* device_get_size (Device* self);
VALA_EXTERN gchar* device_description_usage (Device* self);
VALA_EXTERN gchar* device_tooltip_text (Device* self);
VALA_EXTERN void device_test_all (void);
VALA_EXTERN void device_print_device_list (GeeArrayList* list);
VALA_EXTERN void device_print_device_mounts (GeeArrayList* list);
VALA_EXTERN void device_print_device_disk_space (GeeArrayList* list);
VALA_EXTERN gchar* device_get_free (Device* self);
VALA_EXTERN gboolean device_get_is_mounted (Device* self);
VALA_EXTERN gchar* device_get_full_name_with_alias (Device* self);
VALA_EXTERN gchar* device_get_full_name_with_parent (Device* self);
VALA_EXTERN gchar* device_get_short_name_with_alias (Device* self);
static void device_finalize (GObject * obj);
static GType device_get_type_once (void);
static void _vala_device_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

Device*
device_construct (GType object_type)
{
	Device * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	self = (Device*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (TYPE_MOUNT_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->mount_points);
	self->mount_points = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->symlinks);
	self->symlinks = _tmp1_;
	_tmp2_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->children);
	self->children = _tmp2_;
	device_test_lsblk_version ();
	return self;
}

Device*
device_new (void)
{
	return device_construct (TYPE_DEVICE);
}

void
device_test_lsblk_version (void)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint status = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_;
	_tmp1_ = device_lsblk_version;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = device_lsblk_version;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = tee_jee_process_helper_exec_sync ("lsblk --bytes --pairs --output HOTPLUG,PKNAME,VENDOR,SERIAL,REV", &_tmp5_, &_tmp6_);
	_g_free0 (std_out);
	std_out = _tmp5_;
	_g_free0 (std_err);
	std_err = _tmp6_;
	status = _tmp7_;
	if (status == 0) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = std_out;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (device_lsblk_version);
		device_lsblk_version = _tmp9_;
		device_lsblk_is_ancient = FALSE;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("ancient");
		_g_free0 (device_lsblk_version);
		device_lsblk_version = _tmp10_;
		device_lsblk_is_ancient = TRUE;
	}
	_g_free0 (std_err);
	_g_free0 (std_out);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
device_is_mounted_at_path (Device* self,
                           const gchar* subvolname,
                           const gchar* mount_path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subvolname != NULL, FALSE);
	g_return_val_if_fail (mount_path != NULL, FALSE);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_points;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, mount_path) == 0) {
				gint _tmp10_;
				gint _tmp11_;
				_tmp10_ = strlen (subvolname);
				_tmp11_ = _tmp10_;
				if (_tmp11_ == 0) {
					result = TRUE;
					_g_object_unref0 (mnt);
					return result;
				} else {
					gboolean _tmp12_ = FALSE;
					MountEntry* _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gboolean _tmp17_;
					_tmp13_ = mnt;
					_tmp14_ = _tmp13_->mount_options;
					_tmp15_ = g_strdup_printf ("subvol=%s", subvolname);
					_tmp16_ = _tmp15_;
					_tmp17_ = string_contains (_tmp14_, _tmp16_);
					_g_free0 (_tmp16_);
					if (_tmp17_) {
						_tmp12_ = TRUE;
					} else {
						MountEntry* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp18_ = mnt;
						_tmp19_ = _tmp18_->mount_options;
						_tmp20_ = g_strdup_printf ("subvol=/%s", subvolname);
						_tmp21_ = _tmp20_;
						_tmp12_ = string_contains (_tmp19_, _tmp21_);
						_g_free0 (_tmp21_);
					}
					if (_tmp12_) {
						result = TRUE;
						_g_object_unref0 (mnt);
						return result;
					}
				}
			}
			_g_object_unref0 (mnt);
		}
	}
	result = FALSE;
	return result;
}

gboolean
device_type_is_raid (Device* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->type;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("raid0")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("raid1"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("raid4"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("raid5"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("raid6"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("raid10"))))) {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}

gboolean
device_has_linux_filesystem (Device* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->fstype;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((((((((((((((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("ext2")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("ext3"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("ext4"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("f2fs"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("reiserfs"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("reiser4"))))) || (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("xfs"))))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("jfs"))))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("zfs"))))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("zfs_member"))))) || (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("btrfs"))))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("lvm"))))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("lvm2"))))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("lvm2_member"))))) || (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("luks"))))) || (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("crypt"))))) || (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("crypto_luks"))))) {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}

gboolean
device_is_encrypted_partition (Device* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->type;
	if (g_strcmp0 (_tmp1_, "part") == 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->fstype;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
		_tmp4_ = _tmp3_;
		_tmp0_ = string_contains (_tmp4_, "luks");
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
device_is_on_encrypted_partition (Device* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->type;
	result = g_strcmp0 (_tmp0_, "crypt") == 0;
	return result;
}

gboolean
device_is_lvm_partition (Device* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->type;
	if (g_strcmp0 (_tmp1_, "part") == 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->fstype;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
		_tmp4_ = _tmp3_;
		_tmp0_ = string_contains (_tmp4_, "lvm2_member");
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
device_has_children (Device* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->children;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

Device*
device_first_linux_child (Device* self)
{
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _child_list = NULL;
		GeeArrayList* _tmp0_;
		gint _child_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _child_index = 0;
		_tmp0_ = self->children;
		_child_list = _tmp0_;
		_tmp1_ = _child_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_child_size = _tmp3_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Device* child = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			Device* _tmp8_;
			_child_index = _child_index + 1;
			_tmp4_ = _child_index;
			_tmp5_ = _child_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _child_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _child_index);
			child = (Device*) _tmp7_;
			_tmp8_ = child;
			if (device_has_linux_filesystem (_tmp8_)) {
				result = child;
				return result;
			}
			_g_object_unref0 (child);
		}
	}
	result = NULL;
	return result;
}

gboolean
device_has_parent (Device* self)
{
	Device* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->parent;
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeArrayList*
device_get_filesystems (gboolean get_space,
                        gboolean get_mounts)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GeeArrayList* result;
	_tmp0_ = device_get_block_devices_using_lsblk ("");
	list = _tmp0_;
	if (get_space) {
		GeeArrayList* list_df = NULL;
		GeeArrayList* _tmp1_;
		_tmp1_ = device_get_disk_space_using_df ("");
		list_df = _tmp1_;
		{
			GeeArrayList* _dev_df_list = NULL;
			GeeArrayList* _tmp2_;
			gint _dev_df_size = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _dev_df_index = 0;
			_tmp2_ = list_df;
			_dev_df_list = _tmp2_;
			_tmp3_ = _dev_df_list;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_dev_df_size = _tmp5_;
			_dev_df_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				Device* dev_df = NULL;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				Device* dev = NULL;
				GeeArrayList* _tmp10_;
				Device* _tmp11_;
				const gchar* _tmp12_;
				Device* _tmp13_;
				Device* _tmp14_;
				_dev_df_index = _dev_df_index + 1;
				_tmp6_ = _dev_df_index;
				_tmp7_ = _dev_df_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _dev_df_list;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _dev_df_index);
				dev_df = (Device*) _tmp9_;
				_tmp10_ = list;
				_tmp11_ = dev_df;
				_tmp12_ = _tmp11_->uuid;
				_tmp13_ = device_find_device_in_list (_tmp10_, _tmp12_);
				dev = _tmp13_;
				_tmp14_ = dev;
				if (_tmp14_ != NULL) {
					Device* _tmp15_;
					Device* _tmp16_;
					Device* _tmp17_;
					Device* _tmp18_;
					Device* _tmp19_;
					Device* _tmp20_;
					Device* _tmp21_;
					Device* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp15_ = dev;
					_tmp16_ = dev_df;
					_tmp15_->size_bytes = _tmp16_->size_bytes;
					_tmp17_ = dev;
					_tmp18_ = dev_df;
					_tmp17_->used_bytes = _tmp18_->used_bytes;
					_tmp19_ = dev;
					_tmp20_ = dev_df;
					_tmp19_->available_bytes = _tmp20_->available_bytes;
					_tmp21_ = dev;
					_tmp22_ = dev_df;
					_tmp23_ = _tmp22_->used_percent;
					_tmp24_ = g_strdup (_tmp23_);
					_g_free0 (_tmp21_->used_percent);
					_tmp21_->used_percent = _tmp24_;
				}
				_g_object_unref0 (dev);
				_g_object_unref0 (dev_df);
			}
		}
		_g_object_unref0 (list_df);
	}
	if (get_mounts) {
		GeeArrayList* list_mtab = NULL;
		GeeArrayList* _tmp25_;
		_tmp25_ = device_get_mounted_filesystems_using_mtab ();
		list_mtab = _tmp25_;
		{
			GeeArrayList* _dev_mtab_list = NULL;
			GeeArrayList* _tmp26_;
			gint _dev_mtab_size = 0;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _dev_mtab_index = 0;
			_tmp26_ = list_mtab;
			_dev_mtab_list = _tmp26_;
			_tmp27_ = _dev_mtab_list;
			_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_dev_mtab_size = _tmp29_;
			_dev_mtab_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				Device* dev_mtab = NULL;
				GeeArrayList* _tmp32_;
				gpointer _tmp33_;
				Device* dev = NULL;
				GeeArrayList* _tmp34_;
				Device* _tmp35_;
				const gchar* _tmp36_;
				Device* _tmp37_;
				Device* _tmp38_;
				_dev_mtab_index = _dev_mtab_index + 1;
				_tmp30_ = _dev_mtab_index;
				_tmp31_ = _dev_mtab_size;
				if (!(_tmp30_ < _tmp31_)) {
					break;
				}
				_tmp32_ = _dev_mtab_list;
				_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _dev_mtab_index);
				dev_mtab = (Device*) _tmp33_;
				_tmp34_ = list;
				_tmp35_ = dev_mtab;
				_tmp36_ = _tmp35_->uuid;
				_tmp37_ = device_find_device_in_list (_tmp34_, _tmp36_);
				dev = _tmp37_;
				_tmp38_ = dev;
				if (_tmp38_ != NULL) {
					Device* _tmp39_;
					Device* _tmp40_;
					GeeArrayList* _tmp41_;
					GeeArrayList* _tmp42_;
					_tmp39_ = dev;
					_tmp40_ = dev_mtab;
					_tmp41_ = _tmp40_->mount_points;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					_g_object_unref0 (_tmp39_->mount_points);
					_tmp39_->mount_points = _tmp42_;
				}
				_g_object_unref0 (dev);
				_g_object_unref0 (dev_mtab);
			}
		}
		_g_object_unref0 (list_mtab);
	}
	_tmp43_ = list;
	_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf ("Device: get_filesystems(): %d", _tmp45_);
	_tmp47_ = _tmp46_;
	tee_jee_logging_log_debug (_tmp47_);
	_g_free0 (_tmp47_);
	result = list;
	return result;
}

static void
device_find_child_devices (GeeArrayList* list,
                           Device* parent)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (list != NULL);
	g_return_if_fail (parent != NULL);
	if (device_lsblk_is_ancient) {
		const gchar* _tmp1_;
		_tmp1_ = parent->type;
		_tmp0_ = g_strcmp0 (_tmp1_, "disk") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			GeeArrayList* _part_list = NULL;
			gint _part_size = 0;
			GeeArrayList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _part_index = 0;
			_part_list = list;
			_tmp2_ = _part_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_part_size = _tmp4_;
			_part_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				Device* part = NULL;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
				Device* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_part_index = _part_index + 1;
				_tmp5_ = _part_index;
				_tmp6_ = _part_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _part_list;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _part_index);
				part = (Device*) _tmp8_;
				_tmp10_ = part;
				_tmp11_ = _tmp10_->kname;
				_tmp12_ = parent->kname;
				if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
					Device* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp13_ = part;
					_tmp14_ = _tmp13_->kname;
					_tmp15_ = parent->kname;
					_tmp9_ = g_str_has_prefix (_tmp14_, _tmp15_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GeeArrayList* _tmp16_;
					Device* _tmp17_;
					Device* _tmp18_;
					Device* _tmp19_;
					Device* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					Device* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp16_ = parent->children;
					_tmp17_ = part;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					_tmp18_ = part;
					_tmp19_ = _g_object_ref0 (parent);
					_g_object_unref0 (_tmp18_->parent);
					_tmp18_->parent = _tmp19_;
					_tmp20_ = part;
					_tmp21_ = parent->kname;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (_tmp20_->pkname);
					_tmp20_->pkname = _tmp22_;
					_tmp23_ = parent->kname;
					_tmp24_ = part;
					_tmp25_ = _tmp24_->kname;
					_tmp26_ = g_strdup_printf ("%s -> %s", _tmp23_, _tmp25_);
					_tmp27_ = _tmp26_;
					tee_jee_logging_log_debug (_tmp27_);
					_g_free0 (_tmp27_);
				}
				_g_object_unref0 (part);
			}
		}
	} else {
		{
			GeeArrayList* _part_list = NULL;
			gint _part_size = 0;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _part_index = 0;
			_part_list = list;
			_tmp28_ = _part_list;
			_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_part_size = _tmp30_;
			_part_index = -1;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				Device* part = NULL;
				GeeArrayList* _tmp33_;
				gpointer _tmp34_;
				Device* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_part_index = _part_index + 1;
				_tmp31_ = _part_index;
				_tmp32_ = _part_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _part_list;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _part_index);
				part = (Device*) _tmp34_;
				_tmp35_ = part;
				_tmp36_ = _tmp35_->pkname;
				_tmp37_ = parent->kname;
				if (g_strcmp0 (_tmp36_, _tmp37_) == 0) {
					GeeArrayList* _tmp38_;
					Device* _tmp39_;
					Device* _tmp40_;
					Device* _tmp41_;
					_tmp38_ = parent->children;
					_tmp39_ = part;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp39_);
					_tmp40_ = part;
					_tmp41_ = _g_object_ref0 (parent);
					_g_object_unref0 (_tmp40_->parent);
					_tmp40_->parent = _tmp41_;
				}
				_g_object_unref0 (part);
			}
		}
	}
}

static void
device_find_toplevel_parent (GeeArrayList* list,
                             Device* dev)
{
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* top_kname = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (list != NULL);
	g_return_if_fail (dev != NULL);
	_tmp0_ = dev->pkname;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = dev->pkname;
	_tmp4_ = g_strdup (_tmp3_);
	top_kname = _tmp4_;
	{
		GeeArrayList* _part_list = NULL;
		gint _part_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _part_index = 0;
		_part_list = list;
		_tmp5_ = _part_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_part_size = _tmp7_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			Device* part = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			Device* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_part_index = _part_index + 1;
			_tmp8_ = _part_index;
			_tmp9_ = _part_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _part_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _part_index);
			part = (Device*) _tmp11_;
			_tmp12_ = part;
			_tmp13_ = _tmp12_->kname;
			_tmp14_ = top_kname;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				Device* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				_tmp15_ = part;
				_tmp16_ = _tmp15_->pkname;
				_tmp17_ = strlen (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ > 0) {
					Device* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp19_ = part;
					_tmp20_ = _tmp19_->pkname;
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (top_kname);
					top_kname = _tmp21_;
				}
			}
			_g_object_unref0 (part);
		}
	}
	_tmp22_ = top_kname;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (dev->pkname_toplevel);
	dev->pkname_toplevel = _tmp23_;
	_g_free0 (top_kname);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
device_find_child_devices_using_dmsetup (GeeArrayList* list)
{
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GRegex* rex = NULL;
	GMatchInfo* match = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (list != NULL);
	tee_jee_process_helper_exec_sync ("dmsetup deps -o blkdevname", &_tmp0_, &_tmp1_);
	_g_free0 (std_out);
	std_out = _tmp0_;
	_g_free0 (std_err);
	std_err = _tmp1_;
	_tmp2_ = std_out;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp4_;
		line_collection_length1 = _vala_array_length (_tmp3_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line = NULL;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_;
				_tmp6_ = line;
				_tmp7_ = string_strip (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = strlen (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_ == 0;
				_g_free0 (_tmp8_);
				if (_tmp11_) {
					_g_free0 (line);
					continue;
				}
				{
					GRegex* _tmp12_ = NULL;
					GRegex* _tmp13_;
					GRegex* _tmp14_;
					GRegex* _tmp15_;
					const gchar* _tmp16_;
					GMatchInfo* _tmp17_ = NULL;
					gboolean _tmp18_;
					_tmp13_ = g_regex_new ("([^:]*)\\:.*\\((.*)\\)", 0, 0, &_inner_error0_);
					_tmp12_ = _tmp13_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp14_ = _tmp12_;
					_tmp12_ = NULL;
					_g_regex_unref0 (rex);
					rex = _tmp14_;
					_tmp15_ = rex;
					_tmp16_ = line;
					_tmp18_ = g_regex_match (_tmp15_, _tmp16_, 0, &_tmp17_);
					_g_match_info_unref0 (match);
					match = _tmp17_;
					if (_tmp18_) {
						gchar* child_name = NULL;
						GMatchInfo* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* parent_kname = NULL;
						GMatchInfo* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						Device* parent = NULL;
						Device* child = NULL;
						gboolean _tmp53_ = FALSE;
						Device* _tmp54_;
						_tmp19_ = match;
						_tmp20_ = g_match_info_fetch (_tmp19_, 1);
						_tmp21_ = _tmp20_;
						_tmp22_ = string_strip (_tmp21_);
						_tmp23_ = _tmp22_;
						_g_free0 (_tmp21_);
						child_name = _tmp23_;
						_tmp24_ = match;
						_tmp25_ = g_match_info_fetch (_tmp24_, 2);
						_tmp26_ = _tmp25_;
						_tmp27_ = string_strip (_tmp26_);
						_tmp28_ = _tmp27_;
						_g_free0 (_tmp26_);
						parent_kname = _tmp28_;
						parent = NULL;
						{
							GeeArrayList* _dev_list = NULL;
							gint _dev_size = 0;
							GeeArrayList* _tmp29_;
							gint _tmp30_;
							gint _tmp31_;
							gint _dev_index = 0;
							_dev_list = list;
							_tmp29_ = _dev_list;
							_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
							_tmp31_ = _tmp30_;
							_dev_size = _tmp31_;
							_dev_index = -1;
							while (TRUE) {
								gint _tmp32_;
								gint _tmp33_;
								Device* dev = NULL;
								GeeArrayList* _tmp34_;
								gpointer _tmp35_;
								Device* _tmp36_;
								const gchar* _tmp37_;
								const gchar* _tmp38_;
								_dev_index = _dev_index + 1;
								_tmp32_ = _dev_index;
								_tmp33_ = _dev_size;
								if (!(_tmp32_ < _tmp33_)) {
									break;
								}
								_tmp34_ = _dev_list;
								_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _dev_index);
								dev = (Device*) _tmp35_;
								_tmp36_ = dev;
								_tmp37_ = _tmp36_->kname;
								_tmp38_ = parent_kname;
								if (g_strcmp0 (_tmp37_, _tmp38_) == 0) {
									Device* _tmp39_;
									Device* _tmp40_;
									_tmp39_ = dev;
									_tmp40_ = _g_object_ref0 (_tmp39_);
									_g_object_unref0 (parent);
									parent = _tmp40_;
									_g_object_unref0 (dev);
									break;
								}
								_g_object_unref0 (dev);
							}
						}
						child = NULL;
						{
							GeeArrayList* _dev_list = NULL;
							gint _dev_size = 0;
							GeeArrayList* _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gint _dev_index = 0;
							_dev_list = list;
							_tmp41_ = _dev_list;
							_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
							_tmp43_ = _tmp42_;
							_dev_size = _tmp43_;
							_dev_index = -1;
							while (TRUE) {
								gint _tmp44_;
								gint _tmp45_;
								Device* dev = NULL;
								GeeArrayList* _tmp46_;
								gpointer _tmp47_;
								Device* _tmp48_;
								const gchar* _tmp49_;
								const gchar* _tmp50_;
								_dev_index = _dev_index + 1;
								_tmp44_ = _dev_index;
								_tmp45_ = _dev_size;
								if (!(_tmp44_ < _tmp45_)) {
									break;
								}
								_tmp46_ = _dev_list;
								_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _dev_index);
								dev = (Device*) _tmp47_;
								_tmp48_ = dev;
								_tmp49_ = _tmp48_->mapped_name;
								_tmp50_ = child_name;
								if (g_strcmp0 (_tmp49_, _tmp50_) == 0) {
									Device* _tmp51_;
									Device* _tmp52_;
									_tmp51_ = dev;
									_tmp52_ = _g_object_ref0 (_tmp51_);
									_g_object_unref0 (child);
									child = _tmp52_;
									_g_object_unref0 (dev);
									break;
								}
								_g_object_unref0 (dev);
							}
						}
						_tmp54_ = parent;
						if (_tmp54_ != NULL) {
							Device* _tmp55_;
							_tmp55_ = child;
							_tmp53_ = _tmp55_ != NULL;
						} else {
							_tmp53_ = FALSE;
						}
						if (_tmp53_) {
							Device* _tmp56_;
							Device* _tmp57_;
							const gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp56_ = child;
							_tmp57_ = parent;
							_tmp58_ = _tmp57_->kname;
							_tmp59_ = g_strdup (_tmp58_);
							_g_free0 (_tmp56_->pkname);
							_tmp56_->pkname = _tmp59_;
						}
						_g_object_unref0 (child);
						_g_object_unref0 (parent);
						_g_free0 (parent_kname);
						_g_free0 (child_name);
					} else {
						const gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						_tmp60_ = line;
						_tmp61_ = g_strdup_printf ("no-match: %s", _tmp60_);
						_tmp62_ = _tmp61_;
						tee_jee_logging_log_debug (_tmp62_);
						_g_free0 (_tmp62_);
					}
					_g_regex_unref0 (_tmp12_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp63_;
					const gchar* _tmp64_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp63_ = e;
					_tmp64_ = _tmp63_->message;
					tee_jee_logging_log_error (_tmp64_, FALSE, FALSE);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_match_info_unref0 (match);
					_g_regex_unref0 (rex);
					_g_free0 (std_err);
					_g_free0 (std_out);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_match_info_unref0 (match);
	_g_regex_unref0 (rex);
	_g_free0 (std_err);
	_g_free0 (std_out);
}

gint
device_remove_parents (GeeArrayList* list,
                       Device* dev)
{
	gint removed = 0;
	const gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (list != NULL, 0);
	g_return_val_if_fail (dev != NULL, 0);
	removed = 0;
	_tmp0_ = dev->pkname;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp21_;
		{
			gint i = 0;
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) list);
			_tmp2_ = _tmp1_;
			i = _tmp2_ - 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gpointer _tmp5_;
					Device* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					gboolean _tmp9_;
					if (!_tmp3_) {
						gint _tmp4_;
						i = i - 1;
						_tmp4_ = i;
					}
					_tmp3_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) list, i);
					_tmp6_ = (Device*) _tmp5_;
					_tmp7_ = _tmp6_->kname;
					_tmp8_ = dev->pkname;
					_tmp9_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
					_g_object_unref0 (_tmp6_);
					if (_tmp9_) {
						gpointer _tmp10_;
						Device* _tmp11_;
						const gchar* _tmp12_;
						gboolean _tmp13_;
						gpointer _tmp16_;
						Device* _tmp17_;
						gint _tmp18_;
						gchar* _tmp19_;
						gint _tmp20_;
						_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) list, i);
						_tmp11_ = (Device*) _tmp10_;
						_tmp12_ = _tmp11_->pkname;
						_tmp13_ = g_strcmp0 (_tmp12_, "") != 0;
						_g_object_unref0 (_tmp11_);
						if (_tmp13_) {
							gpointer _tmp14_;
							Device* _tmp15_;
							_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) list, i);
							_tmp15_ = (Device*) _tmp14_;
							removed = device_remove_parents (list, _tmp15_);
							_g_object_unref0 (_tmp15_);
							i -= removed;
						}
						_tmp16_ = gee_abstract_list_remove_at ((GeeAbstractList*) list, i);
						_tmp17_ = (Device*) _tmp16_;
						_g_object_unref0 (_tmp17_);
						i = i - 1;
						_tmp18_ = i;
						_tmp19_ = g_strdup ("");
						_g_free0 (dev->pkname);
						dev->pkname = _tmp19_;
						removed = removed + 1;
						_tmp20_ = removed;
					}
				}
			}
		}
		_tmp21_ = dev->pkname;
		if (g_strcmp0 (_tmp21_, "") != 0) {
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("");
			_g_free0 (dev->pkname);
			dev->pkname = _tmp22_;
		}
	}
	result = removed;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GeeArrayList*
device_get_block_devices_using_lsblk (const gchar* dev_name)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* cmd = NULL;
	gint ret_val = 0;
	GRegex* rex = NULL;
	GMatchInfo* match = NULL;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gint index = 0;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	GeeArrayList* _tmp284_;
	GeeArrayList* _tmp285_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (dev_name != NULL, NULL);
	device_test_lsblk_version ();
	_tmp0_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	if (device_lsblk_is_ancient) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("lsblk --bytes --pairs --output NAME,KNAME,LABEL,UUID,TYPE,FSTYPE,SIZE," \
"MOUNTPOINT,MODEL,RO,RM,MAJ:MIN");
		_g_free0 (cmd);
		cmd = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("lsblk --bytes --pairs --output NAME,KNAME,LABEL,UUID,TYPE,FSTYPE,SIZE," \
"MOUNTPOINT,MODEL,RO,HOTPLUG,MAJ:MIN,PARTLABEL,PARTUUID,PKNAME,VENDOR,S" \
"ERIAL,REV");
		_g_free0 (cmd);
		cmd = _tmp2_;
	}
	_tmp3_ = strlen (dev_name);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = cmd;
		_tmp6_ = g_strdup_printf (" %s", dev_name);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_g_free0 (cmd);
		cmd = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_tmp9_ = cmd;
	_tmp12_ = tee_jee_process_helper_exec_sync (_tmp9_, &_tmp10_, &_tmp11_);
	_g_free0 (std_out);
	std_out = _tmp10_;
	_g_free0 (std_err);
	std_err = _tmp11_;
	ret_val = _tmp12_;
	index = -1;
	_tmp13_ = std_out;
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp15_;
		line_collection_length1 = _vala_array_length (_tmp14_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp16_;
			gchar* line = NULL;
			_tmp16_ = g_strdup (line_collection[line_it]);
			line = _tmp16_;
			{
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gboolean _tmp22_;
				_tmp17_ = line;
				_tmp18_ = string_strip (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = _tmp21_ == 0;
				_g_free0 (_tmp19_);
				if (_tmp22_) {
					_g_free0 (line);
					continue;
				}
				{
					GRegex* _tmp29_;
					const gchar* _tmp30_;
					GMatchInfo* _tmp31_ = NULL;
					gboolean _tmp32_;
					if (device_lsblk_is_ancient) {
						GRegex* _tmp23_ = NULL;
						GRegex* _tmp24_;
						GRegex* _tmp25_;
						_tmp24_ = g_regex_new ("NAME=\"(.*)\" KNAME=\"(.*)\" LABEL=\"(.*)\" UUID=\"(.*)\" TYPE=\"(.*)\"" \
" FSTYPE=\"(.*)\" SIZE=\"(.*)\" MOUNTPOINT=\"(.*)\" MODEL=\"(.*)\" RO=\"" \
"([0-9]+)\" RM=\"([0-9]+)\" MAJ[_:]MIN=\"([0-9:]+)\"", 0, 0, &_inner_error0_);
						_tmp23_ = _tmp24_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp25_ = _tmp23_;
						_tmp23_ = NULL;
						_g_regex_unref0 (rex);
						rex = _tmp25_;
						_g_regex_unref0 (_tmp23_);
					} else {
						GRegex* _tmp26_ = NULL;
						GRegex* _tmp27_;
						GRegex* _tmp28_;
						_tmp27_ = g_regex_new ("NAME=\"(.*)\" KNAME=\"(.*)\" LABEL=\"(.*)\" UUID=\"(.*)\" TYPE=\"(.*)\"" \
" FSTYPE=\"(.*)\" SIZE=\"(.*)\" MOUNTPOINT=\"(.*)\" MODEL=\"(.*)\" RO=\"" \
"([0-9]+)\" HOTPLUG=\"([0-9]+)\" MAJ[_:]MIN=\"([0-9:]+)\" PARTLABEL=\"(" \
".*)\" PARTUUID=\"(.*)\" PKNAME=\"(.*)\" VENDOR=\"(.*)\" SERIAL=\"(.*)\"" \
" REV=\"(.*)\"", 0, 0, &_inner_error0_);
						_tmp26_ = _tmp27_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp28_ = _tmp26_;
						_tmp26_ = NULL;
						_g_regex_unref0 (rex);
						rex = _tmp28_;
						_g_regex_unref0 (_tmp26_);
					}
					_tmp29_ = rex;
					_tmp30_ = line;
					_tmp32_ = g_regex_match (_tmp29_, _tmp30_, 0, &_tmp31_);
					_g_match_info_unref0 (match);
					match = _tmp31_;
					if (_tmp32_) {
						Device* pi = NULL;
						Device* _tmp33_;
						gint pos = 0;
						Device* _tmp34_;
						GMatchInfo* _tmp35_;
						gint _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						Device* _tmp40_;
						GMatchInfo* _tmp41_;
						gint _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						Device* _tmp46_;
						GMatchInfo* _tmp47_;
						gint _tmp48_;
						gchar* _tmp49_;
						Device* _tmp50_;
						GMatchInfo* _tmp51_;
						gint _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						Device* _tmp56_;
						GMatchInfo* _tmp57_;
						gint _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						Device* _tmp64_;
						GMatchInfo* _tmp65_;
						gint _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						const gchar* _tmp72_ = NULL;
						Device* _tmp73_;
						const gchar* _tmp74_;
						Device* _tmp77_;
						gchar* _tmp78_;
						const gchar* _tmp79_ = NULL;
						Device* _tmp80_;
						const gchar* _tmp81_;
						Device* _tmp84_;
						gchar* _tmp85_;
						Device* _tmp86_;
						GMatchInfo* _tmp87_;
						gint _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar* _tmp92_;
						gchar* mp = NULL;
						GMatchInfo* _tmp93_;
						gint _tmp94_;
						gchar* _tmp95_;
						gchar* _tmp96_;
						gchar* _tmp97_;
						gchar* _tmp98_;
						const gchar* _tmp99_;
						gint _tmp100_;
						gint _tmp101_;
						Device* _tmp108_;
						GMatchInfo* _tmp109_;
						gint _tmp110_;
						gchar* _tmp111_;
						gchar* _tmp112_;
						gchar* _tmp113_;
						Device* _tmp114_;
						GMatchInfo* _tmp115_;
						gint _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp120_;
						Device* _tmp121_;
						GMatchInfo* _tmp122_;
						gint _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* txt = NULL;
						GMatchInfo* _tmp128_;
						gint _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						gchar* _tmp132_;
						gchar* _tmp133_;
						const gchar* _tmp134_;
						Device* _tmp181_;
						gint _tmp182_;
						Device* _tmp183_;
						Device* _tmp184_;
						const gchar* _tmp185_;
						gchar* _tmp186_;
						Device* _tmp187_;
						const gchar* _tmp188_;
						gint _tmp189_;
						gint _tmp190_;
						Device* _tmp195_;
						const gchar* _tmp196_;
						gint _tmp197_;
						gint _tmp198_;
						Device* _tmp203_;
						const gchar* _tmp204_;
						gint _tmp205_;
						gint _tmp206_;
						Device* _tmp211_;
						const gchar* _tmp212_;
						gint _tmp213_;
						gint _tmp214_;
						GeeArrayList* _tmp219_;
						Device* _tmp220_;
						_tmp33_ = device_new ();
						pi = _tmp33_;
						pos = 0;
						_tmp34_ = pi;
						_tmp35_ = match;
						pos = pos + 1;
						_tmp36_ = pos;
						_tmp37_ = g_match_info_fetch (_tmp35_, _tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = string_strip (_tmp38_);
						_g_free0 (_tmp34_->name);
						_tmp34_->name = _tmp39_;
						_g_free0 (_tmp38_);
						_tmp40_ = pi;
						_tmp41_ = match;
						pos = pos + 1;
						_tmp42_ = pos;
						_tmp43_ = g_match_info_fetch (_tmp41_, _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = string_strip (_tmp44_);
						_g_free0 (_tmp40_->kname);
						_tmp40_->kname = _tmp45_;
						_g_free0 (_tmp44_);
						_tmp46_ = pi;
						_tmp47_ = match;
						pos = pos + 1;
						_tmp48_ = pos;
						_tmp49_ = g_match_info_fetch (_tmp47_, _tmp48_);
						_g_free0 (_tmp46_->label);
						_tmp46_->label = _tmp49_;
						_tmp50_ = pi;
						_tmp51_ = match;
						pos = pos + 1;
						_tmp52_ = pos;
						_tmp53_ = g_match_info_fetch (_tmp51_, _tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = string_strip (_tmp54_);
						_g_free0 (_tmp50_->uuid);
						_tmp50_->uuid = _tmp55_;
						_g_free0 (_tmp54_);
						_tmp56_ = pi;
						_tmp57_ = match;
						pos = pos + 1;
						_tmp58_ = pos;
						_tmp59_ = g_match_info_fetch (_tmp57_, _tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = string_strip (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = g_utf8_strdown (_tmp62_, (gssize) -1);
						_g_free0 (_tmp56_->type);
						_tmp56_->type = _tmp63_;
						_g_free0 (_tmp62_);
						_g_free0 (_tmp60_);
						_tmp64_ = pi;
						_tmp65_ = match;
						pos = pos + 1;
						_tmp66_ = pos;
						_tmp67_ = g_match_info_fetch (_tmp65_, _tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = string_strip (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_utf8_strdown (_tmp70_, (gssize) -1);
						_g_free0 (_tmp64_->fstype);
						_tmp64_->fstype = _tmp71_;
						_g_free0 (_tmp70_);
						_g_free0 (_tmp68_);
						_tmp73_ = pi;
						_tmp74_ = _tmp73_->fstype;
						if (g_strcmp0 (_tmp74_, "crypto_luks") == 0) {
							_tmp72_ = "luks";
						} else {
							Device* _tmp75_;
							const gchar* _tmp76_;
							_tmp75_ = pi;
							_tmp76_ = _tmp75_->fstype;
							_tmp72_ = _tmp76_;
						}
						_tmp77_ = pi;
						_tmp78_ = g_strdup (_tmp72_);
						_g_free0 (_tmp77_->fstype);
						_tmp77_->fstype = _tmp78_;
						_tmp80_ = pi;
						_tmp81_ = _tmp80_->fstype;
						if (g_strcmp0 (_tmp81_, "lvm2_member") == 0) {
							_tmp79_ = "lvm2";
						} else {
							Device* _tmp82_;
							const gchar* _tmp83_;
							_tmp82_ = pi;
							_tmp83_ = _tmp82_->fstype;
							_tmp79_ = _tmp83_;
						}
						_tmp84_ = pi;
						_tmp85_ = g_strdup (_tmp79_);
						_g_free0 (_tmp84_->fstype);
						_tmp84_->fstype = _tmp85_;
						_tmp86_ = pi;
						_tmp87_ = match;
						pos = pos + 1;
						_tmp88_ = pos;
						_tmp89_ = g_match_info_fetch (_tmp87_, _tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = string_strip (_tmp90_);
						_tmp92_ = _tmp91_;
						_tmp86_->size_bytes = (guint64) int64_parse (_tmp92_, (guint) 0);
						_g_free0 (_tmp92_);
						_g_free0 (_tmp90_);
						_tmp93_ = match;
						pos = pos + 1;
						_tmp94_ = pos;
						_tmp95_ = g_match_info_fetch (_tmp93_, _tmp94_);
						_tmp96_ = _tmp95_;
						_tmp97_ = string_strip (_tmp96_);
						_tmp98_ = _tmp97_;
						_g_free0 (_tmp96_);
						mp = _tmp98_;
						_tmp99_ = mp;
						_tmp100_ = strlen (_tmp99_);
						_tmp101_ = _tmp100_;
						if (_tmp101_ > 0) {
							Device* _tmp102_;
							GeeArrayList* _tmp103_;
							Device* _tmp104_;
							const gchar* _tmp105_;
							MountEntry* _tmp106_;
							MountEntry* _tmp107_;
							_tmp102_ = pi;
							_tmp103_ = _tmp102_->mount_points;
							_tmp104_ = pi;
							_tmp105_ = mp;
							_tmp106_ = mount_entry_new (_tmp104_, _tmp105_, "");
							_tmp107_ = _tmp106_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp103_, _tmp107_);
							_g_object_unref0 (_tmp107_);
						}
						_tmp108_ = pi;
						_tmp109_ = match;
						pos = pos + 1;
						_tmp110_ = pos;
						_tmp111_ = g_match_info_fetch (_tmp109_, _tmp110_);
						_tmp112_ = _tmp111_;
						_tmp113_ = string_strip (_tmp112_);
						_g_free0 (_tmp108_->model);
						_tmp108_->model = _tmp113_;
						_g_free0 (_tmp112_);
						_tmp114_ = pi;
						_tmp115_ = match;
						pos = pos + 1;
						_tmp116_ = pos;
						_tmp117_ = g_match_info_fetch (_tmp115_, _tmp116_);
						_tmp118_ = _tmp117_;
						_tmp119_ = string_strip (_tmp118_);
						_tmp120_ = _tmp119_;
						_tmp114_->read_only = g_strcmp0 (_tmp120_, "1") == 0;
						_g_free0 (_tmp120_);
						_g_free0 (_tmp118_);
						_tmp121_ = pi;
						_tmp122_ = match;
						pos = pos + 1;
						_tmp123_ = pos;
						_tmp124_ = g_match_info_fetch (_tmp122_, _tmp123_);
						_tmp125_ = _tmp124_;
						_tmp126_ = string_strip (_tmp125_);
						_tmp127_ = _tmp126_;
						_tmp121_->removable = g_strcmp0 (_tmp127_, "1") == 0;
						_g_free0 (_tmp127_);
						_g_free0 (_tmp125_);
						_tmp128_ = match;
						pos = pos + 1;
						_tmp129_ = pos;
						_tmp130_ = g_match_info_fetch (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						_tmp132_ = string_strip (_tmp131_);
						_tmp133_ = _tmp132_;
						_g_free0 (_tmp131_);
						txt = _tmp133_;
						_tmp134_ = txt;
						if (string_contains (_tmp134_, ":")) {
							Device* _tmp135_;
							const gchar* _tmp136_;
							gchar** _tmp137_;
							gchar** _tmp138_;
							gchar** _tmp139_;
							gint _tmp139__length1;
							const gchar* _tmp140_;
							Device* _tmp141_;
							const gchar* _tmp142_;
							gchar** _tmp143_;
							gchar** _tmp144_;
							gchar** _tmp145_;
							gint _tmp145__length1;
							const gchar* _tmp146_;
							_tmp135_ = pi;
							_tmp136_ = txt;
							_tmp138_ = _tmp137_ = g_strsplit (_tmp136_, ":", 0);
							_tmp139_ = _tmp138_;
							_tmp139__length1 = _vala_array_length (_tmp137_);
							_tmp140_ = _tmp139_[0];
							_tmp135_->major = atoi (_tmp140_);
							_tmp139_ = (_vala_array_free (_tmp139_, _tmp139__length1, (GDestroyNotify) g_free), NULL);
							_tmp141_ = pi;
							_tmp142_ = txt;
							_tmp144_ = _tmp143_ = g_strsplit (_tmp142_, ":", 0);
							_tmp145_ = _tmp144_;
							_tmp145__length1 = _vala_array_length (_tmp143_);
							_tmp146_ = _tmp145_[1];
							_tmp141_->minor = atoi (_tmp146_);
							_tmp145_ = (_vala_array_free (_tmp145_, _tmp145__length1, (GDestroyNotify) g_free), NULL);
						}
						if (!device_lsblk_is_ancient) {
							Device* _tmp147_;
							GMatchInfo* _tmp148_;
							gint _tmp149_;
							gchar* _tmp150_;
							Device* _tmp151_;
							GMatchInfo* _tmp152_;
							gint _tmp153_;
							gchar* _tmp154_;
							gchar* _tmp155_;
							gchar* _tmp156_;
							Device* _tmp157_;
							GMatchInfo* _tmp158_;
							gint _tmp159_;
							gchar* _tmp160_;
							gchar* _tmp161_;
							gchar* _tmp162_;
							Device* _tmp163_;
							GMatchInfo* _tmp164_;
							gint _tmp165_;
							gchar* _tmp166_;
							gchar* _tmp167_;
							gchar* _tmp168_;
							Device* _tmp169_;
							GMatchInfo* _tmp170_;
							gint _tmp171_;
							gchar* _tmp172_;
							gchar* _tmp173_;
							gchar* _tmp174_;
							Device* _tmp175_;
							GMatchInfo* _tmp176_;
							gint _tmp177_;
							gchar* _tmp178_;
							gchar* _tmp179_;
							gchar* _tmp180_;
							_tmp147_ = pi;
							_tmp148_ = match;
							pos = pos + 1;
							_tmp149_ = pos;
							_tmp150_ = g_match_info_fetch (_tmp148_, _tmp149_);
							_g_free0 (_tmp147_->partlabel);
							_tmp147_->partlabel = _tmp150_;
							_tmp151_ = pi;
							_tmp152_ = match;
							pos = pos + 1;
							_tmp153_ = pos;
							_tmp154_ = g_match_info_fetch (_tmp152_, _tmp153_);
							_tmp155_ = _tmp154_;
							_tmp156_ = string_strip (_tmp155_);
							_g_free0 (_tmp151_->partuuid);
							_tmp151_->partuuid = _tmp156_;
							_g_free0 (_tmp155_);
							_tmp157_ = pi;
							_tmp158_ = match;
							pos = pos + 1;
							_tmp159_ = pos;
							_tmp160_ = g_match_info_fetch (_tmp158_, _tmp159_);
							_tmp161_ = _tmp160_;
							_tmp162_ = string_strip (_tmp161_);
							_g_free0 (_tmp157_->pkname);
							_tmp157_->pkname = _tmp162_;
							_g_free0 (_tmp161_);
							_tmp163_ = pi;
							_tmp164_ = match;
							pos = pos + 1;
							_tmp165_ = pos;
							_tmp166_ = g_match_info_fetch (_tmp164_, _tmp165_);
							_tmp167_ = _tmp166_;
							_tmp168_ = string_strip (_tmp167_);
							_g_free0 (_tmp163_->vendor);
							_tmp163_->vendor = _tmp168_;
							_g_free0 (_tmp167_);
							_tmp169_ = pi;
							_tmp170_ = match;
							pos = pos + 1;
							_tmp171_ = pos;
							_tmp172_ = g_match_info_fetch (_tmp170_, _tmp171_);
							_tmp173_ = _tmp172_;
							_tmp174_ = string_strip (_tmp173_);
							_g_free0 (_tmp169_->serial);
							_tmp169_->serial = _tmp174_;
							_g_free0 (_tmp173_);
							_tmp175_ = pi;
							_tmp176_ = match;
							pos = pos + 1;
							_tmp177_ = pos;
							_tmp178_ = g_match_info_fetch (_tmp176_, _tmp177_);
							_tmp179_ = _tmp178_;
							_tmp180_ = string_strip (_tmp179_);
							_g_free0 (_tmp175_->revision);
							_tmp175_->revision = _tmp180_;
							_g_free0 (_tmp179_);
						}
						_tmp181_ = pi;
						index = index + 1;
						_tmp182_ = index;
						_tmp181_->order = _tmp182_;
						_tmp183_ = pi;
						_tmp184_ = pi;
						_tmp185_ = _tmp184_->kname;
						_tmp186_ = g_strdup_printf ("/dev/%s", _tmp185_);
						_g_free0 (_tmp183_->device);
						_tmp183_->device = _tmp186_;
						_tmp187_ = pi;
						_tmp188_ = _tmp187_->uuid;
						_tmp189_ = strlen (_tmp188_);
						_tmp190_ = _tmp189_;
						if (_tmp190_ > 0) {
							Device* _tmp191_;
							Device* _tmp192_;
							const gchar* _tmp193_;
							gchar* _tmp194_;
							_tmp191_ = pi;
							_tmp192_ = pi;
							_tmp193_ = _tmp192_->uuid;
							_tmp194_ = g_strdup_printf ("/dev/disk/by-uuid/%s", _tmp193_);
							_g_free0 (_tmp191_->device_by_uuid);
							_tmp191_->device_by_uuid = _tmp194_;
						}
						_tmp195_ = pi;
						_tmp196_ = _tmp195_->label;
						_tmp197_ = strlen (_tmp196_);
						_tmp198_ = _tmp197_;
						if (_tmp198_ > 0) {
							Device* _tmp199_;
							Device* _tmp200_;
							const gchar* _tmp201_;
							gchar* _tmp202_;
							_tmp199_ = pi;
							_tmp200_ = pi;
							_tmp201_ = _tmp200_->label;
							_tmp202_ = g_strdup_printf ("/dev/disk/by-label/%s", _tmp201_);
							_g_free0 (_tmp199_->device_by_label);
							_tmp199_->device_by_label = _tmp202_;
						}
						_tmp203_ = pi;
						_tmp204_ = _tmp203_->partuuid;
						_tmp205_ = strlen (_tmp204_);
						_tmp206_ = _tmp205_;
						if (_tmp206_ > 0) {
							Device* _tmp207_;
							Device* _tmp208_;
							const gchar* _tmp209_;
							gchar* _tmp210_;
							_tmp207_ = pi;
							_tmp208_ = pi;
							_tmp209_ = _tmp208_->partuuid;
							_tmp210_ = g_strdup_printf ("/dev/disk/by-partuuid/%s", _tmp209_);
							_g_free0 (_tmp207_->device_by_partuuid);
							_tmp207_->device_by_partuuid = _tmp210_;
						}
						_tmp211_ = pi;
						_tmp212_ = _tmp211_->partlabel;
						_tmp213_ = strlen (_tmp212_);
						_tmp214_ = _tmp213_;
						if (_tmp214_ > 0) {
							Device* _tmp215_;
							Device* _tmp216_;
							const gchar* _tmp217_;
							gchar* _tmp218_;
							_tmp215_ = pi;
							_tmp216_ = pi;
							_tmp217_ = _tmp216_->partlabel;
							_tmp218_ = g_strdup_printf ("/dev/disk/by-partlabel/%s", _tmp217_);
							_g_free0 (_tmp215_->device_by_partlabel);
							_tmp215_->device_by_partlabel = _tmp218_;
						}
						_tmp219_ = list;
						_tmp220_ = pi;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp219_, _tmp220_);
						_g_free0 (txt);
						_g_free0 (mp);
						_g_object_unref0 (pi);
					} else {
						const gchar* _tmp221_;
						gchar* _tmp222_;
						gchar* _tmp223_;
						_tmp221_ = line;
						_tmp222_ = g_strdup_printf ("no-match: %s", _tmp221_);
						_tmp223_ = _tmp222_;
						tee_jee_logging_log_debug (_tmp223_);
						_g_free0 (_tmp223_);
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp224_;
					const gchar* _tmp225_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp224_ = e;
					_tmp225_ = _tmp224_->message;
					tee_jee_logging_log_error (_tmp225_, FALSE, FALSE);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_match_info_unref0 (match);
					_g_regex_unref0 (rex);
					_g_free0 (cmd);
					_g_free0 (std_err);
					_g_free0 (std_out);
					_g_object_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp226_;
		gint _dev_size = 0;
		GeeArrayList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _dev_index = 0;
		_tmp226_ = list;
		_dev_list = _tmp226_;
		_tmp227_ = _dev_list;
		_tmp228_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_dev_size = _tmp229_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			Device* dev = NULL;
			GeeArrayList* _tmp232_;
			gpointer _tmp233_;
			gchar* dev_by_uuid = NULL;
			Device* _tmp234_;
			const gchar* _tmp235_;
			gchar* _tmp236_;
			const gchar* _tmp237_;
			_dev_index = _dev_index + 1;
			_tmp230_ = _dev_index;
			_tmp231_ = _dev_size;
			if (!(_tmp230_ < _tmp231_)) {
				break;
			}
			_tmp232_ = _dev_list;
			_tmp233_ = gee_abstract_list_get ((GeeAbstractList*) _tmp232_, _dev_index);
			dev = (Device*) _tmp233_;
			_tmp234_ = dev;
			_tmp235_ = _tmp234_->uuid;
			_tmp236_ = tee_jee_file_system_path_combine ("/dev/disk/by-uuid/", _tmp235_);
			dev_by_uuid = _tmp236_;
			_tmp237_ = dev_by_uuid;
			if (tee_jee_file_system_file_exists (_tmp237_)) {
				Device* _tmp238_;
				GeeArrayList* _tmp239_;
				const gchar* _tmp240_;
				_tmp238_ = dev;
				_tmp239_ = _tmp238_->symlinks;
				_tmp240_ = dev_by_uuid;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp239_, _tmp240_);
			}
			_g_free0 (dev_by_uuid);
			_g_object_unref0 (dev);
		}
	}
	{
		GFile* f_dev_mapper = NULL;
		GFile* _tmp241_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		GFileEnumerator* _tmp245_;
		GFileEnumerator* _tmp246_;
		GFileInfo* info = NULL;
		_tmp241_ = g_file_new_for_path ("/dev/mapper");
		f_dev_mapper = _tmp241_;
		_tmp242_ = f_dev_mapper;
		_tmp243_ = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET);
		_tmp244_ = _tmp243_;
		_tmp245_ = g_file_enumerate_children (_tmp242_, _tmp244_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp246_ = _tmp245_;
		_g_free0 (_tmp244_);
		enumerator = _tmp246_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f_dev_mapper);
			goto __catch1_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp247_ = NULL;
			GFileEnumerator* _tmp248_;
			GFileInfo* _tmp249_;
			GFileInfo* _tmp250_;
			GFileInfo* _tmp251_;
			GFileInfo* _tmp252_;
			const gchar* _tmp253_;
			GFile* f_mapped = NULL;
			GFile* _tmp254_;
			GFileInfo* _tmp255_;
			const gchar* _tmp256_;
			GFile* _tmp257_;
			gchar* mapped_file = NULL;
			GFile* _tmp258_;
			gchar* _tmp259_;
			gchar* mapped_device = NULL;
			GFileInfo* _tmp260_;
			const gchar* _tmp261_;
			gchar* _tmp262_;
			const gchar* _tmp263_;
			gchar* _tmp264_;
			_tmp248_ = enumerator;
			_tmp249_ = g_file_enumerator_next_file (_tmp248_, NULL, &_inner_error0_);
			_tmp247_ = _tmp249_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (f_dev_mapper);
				goto __catch1_g_error;
			}
			_tmp250_ = _tmp247_;
			_tmp247_ = NULL;
			_g_object_unref0 (info);
			info = _tmp250_;
			_tmp251_ = info;
			if (!(_tmp251_ != NULL)) {
				_g_object_unref0 (_tmp247_);
				break;
			}
			_tmp252_ = info;
			_tmp253_ = g_file_info_get_name (_tmp252_);
			if (g_strcmp0 (_tmp253_, "control") == 0) {
				_g_object_unref0 (_tmp247_);
				continue;
			}
			_tmp254_ = f_dev_mapper;
			_tmp255_ = info;
			_tmp256_ = g_file_info_get_name (_tmp255_);
			_tmp257_ = g_file_resolve_relative_path (_tmp254_, _tmp256_);
			f_mapped = _tmp257_;
			_tmp258_ = f_mapped;
			_tmp259_ = g_file_get_path (_tmp258_);
			mapped_file = _tmp259_;
			_tmp260_ = info;
			_tmp261_ = g_file_info_get_symlink_target (_tmp260_);
			_tmp262_ = g_strdup (_tmp261_);
			mapped_device = _tmp262_;
			_tmp263_ = mapped_device;
			_tmp264_ = string_replace (_tmp263_, "..", "/dev");
			_g_free0 (mapped_device);
			mapped_device = _tmp264_;
			{
				GeeArrayList* _dev_list = NULL;
				GeeArrayList* _tmp265_;
				gint _dev_size = 0;
				GeeArrayList* _tmp266_;
				gint _tmp267_;
				gint _tmp268_;
				gint _dev_index = 0;
				_tmp265_ = list;
				_dev_list = _tmp265_;
				_tmp266_ = _dev_list;
				_tmp267_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp266_);
				_tmp268_ = _tmp267_;
				_dev_size = _tmp268_;
				_dev_index = -1;
				while (TRUE) {
					gint _tmp269_;
					gint _tmp270_;
					Device* dev = NULL;
					GeeArrayList* _tmp271_;
					gpointer _tmp272_;
					Device* _tmp273_;
					const gchar* _tmp274_;
					const gchar* _tmp275_;
					_dev_index = _dev_index + 1;
					_tmp269_ = _dev_index;
					_tmp270_ = _dev_size;
					if (!(_tmp269_ < _tmp270_)) {
						break;
					}
					_tmp271_ = _dev_list;
					_tmp272_ = gee_abstract_list_get ((GeeAbstractList*) _tmp271_, _dev_index);
					dev = (Device*) _tmp272_;
					_tmp273_ = dev;
					_tmp274_ = _tmp273_->device;
					_tmp275_ = mapped_device;
					if (g_strcmp0 (_tmp274_, _tmp275_) == 0) {
						Device* _tmp276_;
						const gchar* _tmp277_;
						gchar* _tmp278_;
						Device* _tmp279_;
						GeeArrayList* _tmp280_;
						const gchar* _tmp281_;
						_tmp276_ = dev;
						_tmp277_ = mapped_file;
						_tmp278_ = string_replace (_tmp277_, "/dev/mapper/", "");
						_g_free0 (_tmp276_->mapped_name);
						_tmp276_->mapped_name = _tmp278_;
						_tmp279_ = dev;
						_tmp280_ = _tmp279_->symlinks;
						_tmp281_ = mapped_file;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp280_, _tmp281_);
						_g_object_unref0 (dev);
						break;
					}
					_g_object_unref0 (dev);
				}
			}
			_g_free0 (mapped_device);
			_g_free0 (mapped_file);
			_g_object_unref0 (f_mapped);
			_g_object_unref0 (_tmp247_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (f_dev_mapper);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp282_;
		const gchar* _tmp283_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp282_ = e;
		_tmp283_ = _tmp282_->message;
		tee_jee_logging_log_error (_tmp283_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match);
		_g_regex_unref0 (rex);
		_g_free0 (cmd);
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp284_ = list;
	_tmp285_ = _g_object_ref0 (_tmp284_);
	_g_object_unref0 (device_device_list);
	device_device_list = _tmp285_;
	{
		GeeArrayList* _part_list = NULL;
		GeeArrayList* _tmp286_;
		gint _part_size = 0;
		GeeArrayList* _tmp287_;
		gint _tmp288_;
		gint _tmp289_;
		gint _part_index = 0;
		_tmp286_ = list;
		_part_list = _tmp286_;
		_tmp287_ = _part_list;
		_tmp288_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp287_);
		_tmp289_ = _tmp288_;
		_part_size = _tmp289_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp290_;
			gint _tmp291_;
			Device* part = NULL;
			GeeArrayList* _tmp292_;
			gpointer _tmp293_;
			GeeArrayList* _tmp294_;
			Device* _tmp295_;
			GeeArrayList* _tmp296_;
			Device* _tmp297_;
			_part_index = _part_index + 1;
			_tmp290_ = _part_index;
			_tmp291_ = _part_size;
			if (!(_tmp290_ < _tmp291_)) {
				break;
			}
			_tmp292_ = _part_list;
			_tmp293_ = gee_abstract_list_get ((GeeAbstractList*) _tmp292_, _part_index);
			part = (Device*) _tmp293_;
			_tmp294_ = list;
			_tmp295_ = part;
			device_find_child_devices (_tmp294_, _tmp295_);
			_tmp296_ = list;
			_tmp297_ = part;
			device_find_toplevel_parent (_tmp296_, _tmp297_);
			_g_object_unref0 (part);
		}
	}
	{
		gint i = 0;
		GeeArrayList* _tmp298_;
		gint _tmp299_;
		gint _tmp300_;
		_tmp298_ = list;
		_tmp299_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp298_);
		_tmp300_ = _tmp299_;
		i = _tmp300_ - 1;
		{
			gboolean _tmp301_ = FALSE;
			_tmp301_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp303_;
				gpointer _tmp304_;
				Device* _tmp305_;
				gboolean _tmp306_;
				if (!_tmp301_) {
					gint _tmp302_;
					i = i - 1;
					_tmp302_ = i;
				}
				_tmp301_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp303_ = list;
				_tmp304_ = gee_abstract_list_get ((GeeAbstractList*) _tmp303_, i);
				_tmp305_ = (Device*) _tmp304_;
				_tmp306_ = device_type_is_raid (_tmp305_);
				_g_object_unref0 (_tmp305_);
				if (_tmp306_) {
					GeeArrayList* _tmp307_;
					GeeArrayList* _tmp308_;
					gpointer _tmp309_;
					Device* _tmp310_;
					_tmp307_ = list;
					_tmp308_ = list;
					_tmp309_ = gee_abstract_list_get ((GeeAbstractList*) _tmp308_, i);
					_tmp310_ = (Device*) _tmp309_;
					i -= device_remove_parents (_tmp307_, _tmp310_);
					_g_object_unref0 (_tmp310_);
					{
						gint j = 0;
						GeeArrayList* _tmp311_;
						gint _tmp312_;
						gint _tmp313_;
						_tmp311_ = list;
						_tmp312_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp311_);
						_tmp313_ = _tmp312_;
						j = _tmp313_ - 1;
						{
							gboolean _tmp314_ = FALSE;
							_tmp314_ = TRUE;
							while (TRUE) {
								GeeArrayList* _tmp316_;
								gpointer _tmp317_;
								Device* _tmp318_;
								const gchar* _tmp319_;
								GeeArrayList* _tmp320_;
								gpointer _tmp321_;
								Device* _tmp322_;
								const gchar* _tmp323_;
								gboolean _tmp324_;
								if (!_tmp314_) {
									gint _tmp315_;
									j = j - 1;
									_tmp315_ = j;
								}
								_tmp314_ = FALSE;
								if (!(j > i)) {
									break;
								}
								_tmp316_ = list;
								_tmp317_ = gee_abstract_list_get ((GeeAbstractList*) _tmp316_, j);
								_tmp318_ = (Device*) _tmp317_;
								_tmp319_ = _tmp318_->pkname;
								_tmp320_ = list;
								_tmp321_ = gee_abstract_list_get ((GeeAbstractList*) _tmp320_, i);
								_tmp322_ = (Device*) _tmp321_;
								_tmp323_ = _tmp322_->kname;
								_tmp324_ = g_strcmp0 (_tmp319_, _tmp323_) == 0;
								_g_object_unref0 (_tmp322_);
								_g_object_unref0 (_tmp318_);
								if (_tmp324_) {
									{
										gint k = 0;
										k = j - 1;
										{
											gboolean _tmp325_ = FALSE;
											_tmp325_ = TRUE;
											while (TRUE) {
												GeeArrayList* _tmp327_;
												gpointer _tmp328_;
												Device* _tmp329_;
												const gchar* _tmp330_;
												GeeArrayList* _tmp331_;
												gpointer _tmp332_;
												Device* _tmp333_;
												const gchar* _tmp334_;
												gboolean _tmp335_;
												if (!_tmp325_) {
													gint _tmp326_;
													k = k - 1;
													_tmp326_ = k;
												}
												_tmp325_ = FALSE;
												if (!(k >= 0)) {
													break;
												}
												_tmp327_ = list;
												_tmp328_ = gee_abstract_list_get ((GeeAbstractList*) _tmp327_, k);
												_tmp329_ = (Device*) _tmp328_;
												_tmp330_ = _tmp329_->kname;
												_tmp331_ = list;
												_tmp332_ = gee_abstract_list_get ((GeeAbstractList*) _tmp331_, j);
												_tmp333_ = (Device*) _tmp332_;
												_tmp334_ = _tmp333_->kname;
												_tmp335_ = g_strcmp0 (_tmp330_, _tmp334_) == 0;
												_g_object_unref0 (_tmp333_);
												_g_object_unref0 (_tmp329_);
												if (_tmp335_) {
													GeeArrayList* _tmp336_;
													gpointer _tmp337_;
													Device* _tmp338_;
													gint _tmp339_;
													gint _tmp340_;
													_tmp336_ = list;
													_tmp337_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp336_, k);
													_tmp338_ = (Device*) _tmp337_;
													_g_object_unref0 (_tmp338_);
													i = i - 1;
													_tmp339_ = i;
													j = j - 1;
													_tmp340_ = j;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		GeeArrayList* _tmp341_;
		gint _tmp342_;
		gint _tmp343_;
		_tmp341_ = list;
		_tmp342_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp341_);
		_tmp343_ = _tmp342_;
		i = _tmp343_ - 1;
		{
			gboolean _tmp344_ = FALSE;
			_tmp344_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp346_;
				gpointer _tmp347_;
				Device* _tmp348_;
				gboolean _tmp349_;
				if (!_tmp344_) {
					gint _tmp345_;
					i = i - 1;
					_tmp345_ = i;
				}
				_tmp344_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp346_ = list;
				_tmp347_ = gee_abstract_list_get ((GeeAbstractList*) _tmp346_, i);
				_tmp348_ = (Device*) _tmp347_;
				_tmp349_ = device_type_is_raid (_tmp348_);
				_g_object_unref0 (_tmp348_);
				if (_tmp349_) {
					GeeArrayList* _tmp350_;
					gpointer _tmp351_;
					Device* _tmp352_;
					gchar* _tmp353_;
					GeeArrayList* _tmp354_;
					gpointer _tmp355_;
					Device* _tmp356_;
					GeeArrayList* _tmp357_;
					gpointer _tmp358_;
					Device* _tmp359_;
					const gchar* _tmp360_;
					gchar* _tmp361_;
					_tmp350_ = list;
					_tmp351_ = gee_abstract_list_get ((GeeAbstractList*) _tmp350_, i);
					_tmp352_ = (Device*) _tmp351_;
					_tmp353_ = g_strdup ("disk");
					_g_free0 (_tmp352_->type);
					_tmp352_->type = _tmp353_;
					_g_object_unref0 (_tmp352_);
					_tmp354_ = list;
					_tmp355_ = gee_abstract_list_get ((GeeAbstractList*) _tmp354_, i);
					_tmp356_ = (Device*) _tmp355_;
					_tmp357_ = list;
					_tmp358_ = gee_abstract_list_get ((GeeAbstractList*) _tmp357_, i);
					_tmp359_ = (Device*) _tmp358_;
					_tmp360_ = _tmp359_->name;
					_tmp361_ = g_strdup (_tmp360_);
					_g_free0 (_tmp356_->model);
					_tmp356_->model = _tmp361_;
					_g_object_unref0 (_tmp359_);
					_g_object_unref0 (_tmp356_);
					{
						gint j = 0;
						GeeArrayList* _tmp362_;
						gint _tmp363_;
						gint _tmp364_;
						_tmp362_ = list;
						_tmp363_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp362_);
						_tmp364_ = _tmp363_;
						j = _tmp364_ - 1;
						{
							gboolean _tmp365_ = FALSE;
							_tmp365_ = TRUE;
							while (TRUE) {
								gboolean _tmp367_ = FALSE;
								gboolean _tmp368_ = FALSE;
								if (!_tmp365_) {
									gint _tmp366_;
									j = j - 1;
									_tmp366_ = j;
								}
								_tmp365_ = FALSE;
								if (!(j >= 0)) {
									break;
								}
								if (i != j) {
									GeeArrayList* _tmp369_;
									gpointer _tmp370_;
									Device* _tmp371_;
									const gchar* _tmp372_;
									GeeArrayList* _tmp373_;
									gpointer _tmp374_;
									Device* _tmp375_;
									const gchar* _tmp376_;
									_tmp369_ = list;
									_tmp370_ = gee_abstract_list_get ((GeeAbstractList*) _tmp369_, j);
									_tmp371_ = (Device*) _tmp370_;
									_tmp372_ = _tmp371_->type;
									_tmp373_ = list;
									_tmp374_ = gee_abstract_list_get ((GeeAbstractList*) _tmp373_, i);
									_tmp375_ = (Device*) _tmp374_;
									_tmp376_ = _tmp375_->type;
									_tmp368_ = g_strcmp0 (_tmp372_, _tmp376_) == 0;
									_g_object_unref0 (_tmp375_);
									_g_object_unref0 (_tmp371_);
								} else {
									_tmp368_ = FALSE;
								}
								if (_tmp368_) {
									GeeArrayList* _tmp377_;
									gpointer _tmp378_;
									Device* _tmp379_;
									const gchar* _tmp380_;
									GeeArrayList* _tmp381_;
									gpointer _tmp382_;
									Device* _tmp383_;
									const gchar* _tmp384_;
									_tmp377_ = list;
									_tmp378_ = gee_abstract_list_get ((GeeAbstractList*) _tmp377_, j);
									_tmp379_ = (Device*) _tmp378_;
									_tmp380_ = _tmp379_->kname;
									_tmp381_ = list;
									_tmp382_ = gee_abstract_list_get ((GeeAbstractList*) _tmp381_, i);
									_tmp383_ = (Device*) _tmp382_;
									_tmp384_ = _tmp383_->kname;
									_tmp367_ = g_strcmp0 (_tmp380_, _tmp384_) == 0;
									_g_object_unref0 (_tmp383_);
									_g_object_unref0 (_tmp379_);
								} else {
									_tmp367_ = FALSE;
								}
								if (_tmp367_) {
									GeeArrayList* _tmp385_;
									gpointer _tmp386_;
									Device* _tmp387_;
									_tmp385_ = list;
									_tmp386_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp385_, j);
									_tmp387_ = (Device*) _tmp386_;
									_g_object_unref0 (_tmp387_);
									if (j < i) {
										gint _tmp388_;
										i = i - 1;
										_tmp388_ = i;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		GeeArrayList* _tmp389_;
		gint _tmp390_;
		gint _tmp391_;
		_tmp389_ = list;
		_tmp390_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp389_);
		_tmp391_ = _tmp390_;
		i = _tmp391_ - 1;
		{
			gboolean _tmp392_ = FALSE;
			_tmp392_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp394_;
				gpointer _tmp395_;
				Device* _tmp396_;
				const gchar* _tmp397_;
				gboolean _tmp398_;
				if (!_tmp392_) {
					gint _tmp393_;
					i = i - 1;
					_tmp393_ = i;
				}
				_tmp392_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp394_ = list;
				_tmp395_ = gee_abstract_list_get ((GeeAbstractList*) _tmp394_, i);
				_tmp396_ = (Device*) _tmp395_;
				_tmp397_ = _tmp396_->type;
				_tmp398_ = g_strcmp0 (_tmp397_, "dmraid") == 0;
				_g_object_unref0 (_tmp396_);
				if (_tmp398_) {
					GeeArrayList* _tmp399_;
					GeeArrayList* _tmp400_;
					gpointer _tmp401_;
					Device* _tmp402_;
					_tmp399_ = list;
					_tmp400_ = list;
					_tmp401_ = gee_abstract_list_get ((GeeAbstractList*) _tmp400_, i);
					_tmp402_ = (Device*) _tmp401_;
					i -= device_remove_parents (_tmp399_, _tmp402_);
					_g_object_unref0 (_tmp402_);
					{
						gint j = 0;
						GeeArrayList* _tmp403_;
						gint _tmp404_;
						gint _tmp405_;
						_tmp403_ = list;
						_tmp404_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp403_);
						_tmp405_ = _tmp404_;
						j = _tmp405_ - 1;
						{
							gboolean _tmp406_ = FALSE;
							_tmp406_ = TRUE;
							while (TRUE) {
								GeeArrayList* _tmp408_;
								gpointer _tmp409_;
								Device* _tmp410_;
								const gchar* _tmp411_;
								GeeArrayList* _tmp412_;
								gpointer _tmp413_;
								Device* _tmp414_;
								const gchar* _tmp415_;
								gboolean _tmp416_;
								if (!_tmp406_) {
									gint _tmp407_;
									j = j - 1;
									_tmp407_ = j;
								}
								_tmp406_ = FALSE;
								if (!(j > i)) {
									break;
								}
								_tmp408_ = list;
								_tmp409_ = gee_abstract_list_get ((GeeAbstractList*) _tmp408_, j);
								_tmp410_ = (Device*) _tmp409_;
								_tmp411_ = _tmp410_->pkname;
								_tmp412_ = list;
								_tmp413_ = gee_abstract_list_get ((GeeAbstractList*) _tmp412_, i);
								_tmp414_ = (Device*) _tmp413_;
								_tmp415_ = _tmp414_->kname;
								_tmp416_ = g_strcmp0 (_tmp411_, _tmp415_) == 0;
								_g_object_unref0 (_tmp414_);
								_g_object_unref0 (_tmp410_);
								if (_tmp416_) {
									{
										gint k = 0;
										k = j - 1;
										{
											gboolean _tmp417_ = FALSE;
											_tmp417_ = TRUE;
											while (TRUE) {
												GeeArrayList* _tmp419_;
												gpointer _tmp420_;
												Device* _tmp421_;
												const gchar* _tmp422_;
												GeeArrayList* _tmp423_;
												gpointer _tmp424_;
												Device* _tmp425_;
												const gchar* _tmp426_;
												gboolean _tmp427_;
												if (!_tmp417_) {
													gint _tmp418_;
													k = k - 1;
													_tmp418_ = k;
												}
												_tmp417_ = FALSE;
												if (!(k >= 0)) {
													break;
												}
												_tmp419_ = list;
												_tmp420_ = gee_abstract_list_get ((GeeAbstractList*) _tmp419_, k);
												_tmp421_ = (Device*) _tmp420_;
												_tmp422_ = _tmp421_->kname;
												_tmp423_ = list;
												_tmp424_ = gee_abstract_list_get ((GeeAbstractList*) _tmp423_, j);
												_tmp425_ = (Device*) _tmp424_;
												_tmp426_ = _tmp425_->kname;
												_tmp427_ = g_strcmp0 (_tmp422_, _tmp426_) == 0;
												_g_object_unref0 (_tmp425_);
												_g_object_unref0 (_tmp421_);
												if (_tmp427_) {
													GeeArrayList* _tmp428_;
													gpointer _tmp429_;
													Device* _tmp430_;
													gint _tmp431_;
													_tmp428_ = list;
													_tmp429_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp428_, k);
													_tmp430_ = (Device*) _tmp429_;
													_g_object_unref0 (_tmp430_);
													j = j - 1;
													_tmp431_ = j;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		GeeArrayList* _tmp432_;
		gint _tmp433_;
		gint _tmp434_;
		_tmp432_ = list;
		_tmp433_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp432_);
		_tmp434_ = _tmp433_;
		i = _tmp434_ - 1;
		{
			gboolean _tmp435_ = FALSE;
			_tmp435_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp437_;
				gpointer _tmp438_;
				Device* _tmp439_;
				const gchar* _tmp440_;
				gboolean _tmp441_;
				if (!_tmp435_) {
					gint _tmp436_;
					i = i - 1;
					_tmp436_ = i;
				}
				_tmp435_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp437_ = list;
				_tmp438_ = gee_abstract_list_get ((GeeAbstractList*) _tmp437_, i);
				_tmp439_ = (Device*) _tmp438_;
				_tmp440_ = _tmp439_->type;
				_tmp441_ = g_strcmp0 (_tmp440_, "dmraid") == 0;
				_g_object_unref0 (_tmp439_);
				if (_tmp441_) {
					GeeArrayList* _tmp442_;
					gpointer _tmp443_;
					Device* _tmp444_;
					gchar* _tmp445_;
					GeeArrayList* _tmp446_;
					gpointer _tmp447_;
					Device* _tmp448_;
					GeeArrayList* _tmp449_;
					gpointer _tmp450_;
					Device* _tmp451_;
					const gchar* _tmp452_;
					gchar* _tmp453_;
					_tmp442_ = list;
					_tmp443_ = gee_abstract_list_get ((GeeAbstractList*) _tmp442_, i);
					_tmp444_ = (Device*) _tmp443_;
					_tmp445_ = g_strdup ("disk");
					_g_free0 (_tmp444_->type);
					_tmp444_->type = _tmp445_;
					_g_object_unref0 (_tmp444_);
					_tmp446_ = list;
					_tmp447_ = gee_abstract_list_get ((GeeAbstractList*) _tmp446_, i);
					_tmp448_ = (Device*) _tmp447_;
					_tmp449_ = list;
					_tmp450_ = gee_abstract_list_get ((GeeAbstractList*) _tmp449_, i);
					_tmp451_ = (Device*) _tmp450_;
					_tmp452_ = _tmp451_->name;
					_tmp453_ = g_strdup (_tmp452_);
					_g_free0 (_tmp448_->model);
					_tmp448_->model = _tmp453_;
					_g_object_unref0 (_tmp451_);
					_g_object_unref0 (_tmp448_);
					{
						gint j = 0;
						GeeArrayList* _tmp454_;
						gint _tmp455_;
						gint _tmp456_;
						_tmp454_ = list;
						_tmp455_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp454_);
						_tmp456_ = _tmp455_;
						j = _tmp456_ - 1;
						{
							gboolean _tmp457_ = FALSE;
							_tmp457_ = TRUE;
							while (TRUE) {
								gboolean _tmp459_ = FALSE;
								gboolean _tmp460_ = FALSE;
								if (!_tmp457_) {
									gint _tmp458_;
									j = j - 1;
									_tmp458_ = j;
								}
								_tmp457_ = FALSE;
								if (!(j >= 0)) {
									break;
								}
								if (i != j) {
									GeeArrayList* _tmp461_;
									gpointer _tmp462_;
									Device* _tmp463_;
									const gchar* _tmp464_;
									_tmp461_ = list;
									_tmp462_ = gee_abstract_list_get ((GeeAbstractList*) _tmp461_, j);
									_tmp463_ = (Device*) _tmp462_;
									_tmp464_ = _tmp463_->type;
									_tmp460_ = g_strcmp0 (_tmp464_, "dmraid") == 0;
									_g_object_unref0 (_tmp463_);
								} else {
									_tmp460_ = FALSE;
								}
								if (_tmp460_) {
									GeeArrayList* _tmp465_;
									gpointer _tmp466_;
									Device* _tmp467_;
									const gchar* _tmp468_;
									GeeArrayList* _tmp469_;
									gpointer _tmp470_;
									Device* _tmp471_;
									const gchar* _tmp472_;
									_tmp465_ = list;
									_tmp466_ = gee_abstract_list_get ((GeeAbstractList*) _tmp465_, j);
									_tmp467_ = (Device*) _tmp466_;
									_tmp468_ = _tmp467_->kname;
									_tmp469_ = list;
									_tmp470_ = gee_abstract_list_get ((GeeAbstractList*) _tmp469_, i);
									_tmp471_ = (Device*) _tmp470_;
									_tmp472_ = _tmp471_->kname;
									_tmp459_ = g_strcmp0 (_tmp468_, _tmp472_) == 0;
									_g_object_unref0 (_tmp471_);
									_g_object_unref0 (_tmp467_);
								} else {
									_tmp459_ = FALSE;
								}
								if (_tmp459_) {
									GeeArrayList* _tmp473_;
									gpointer _tmp474_;
									Device* _tmp475_;
									_tmp473_ = list;
									_tmp474_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp473_, j);
									_tmp475_ = (Device*) _tmp474_;
									_g_object_unref0 (_tmp475_);
									if (j < i) {
										gint _tmp476_;
										i = i - 1;
										_tmp476_ = i;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (device_lsblk_is_ancient) {
		GeeArrayList* _tmp477_;
		_tmp477_ = list;
		device_find_child_devices_using_dmsetup (_tmp477_);
	}
	result = list;
	_g_match_info_unref0 (match);
	_g_regex_unref0 (rex);
	_g_free0 (cmd);
	_g_free0 (std_err);
	_g_free0 (std_out);
	return result;
}

GeeArrayList*
device_get_block_devices_using_blkid (const gchar* dev_name)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* cmd = NULL;
	gint ret_val = 0;
	GRegex* rex = NULL;
	GMatchInfo* match = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp6_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	GeeArrayList* _tmp104_;
	gint _tmp105_;
	gint _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (dev_name != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp2_ = strlen (dev_name);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strconcat (" ", dev_name, NULL);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = g_strconcat ("/sbin/blkid", _tmp1_, NULL);
	_g_free0 (cmd);
	cmd = _tmp6_;
	if (tee_jee_logging_LOG_DEBUG) {
		const gchar* _tmp7_;
		_tmp7_ = cmd;
		tee_jee_logging_log_debug (_tmp7_);
	}
	_tmp8_ = cmd;
	_tmp11_ = tee_jee_process_helper_exec_script_sync (_tmp8_, &_tmp9_, &_tmp10_, FALSE, FALSE, TRUE, FALSE);
	_g_free0 (std_out);
	std_out = _tmp9_;
	_g_free0 (std_err);
	std_err = _tmp10_;
	ret_val = _tmp11_;
	if (ret_val != 0) {
		gchar* msg = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gint _tmp14_;
		gint _tmp15_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp12_ = g_strconcat ("blkid: ", _ ("Failed to get partition list"), NULL);
		msg = _tmp12_;
		_tmp14_ = strlen (dev_name);
		_tmp15_ = _tmp14_;
		if (_tmp15_ > 0) {
			gchar* _tmp16_;
			_tmp16_ = g_strconcat (": ", dev_name, NULL);
			_g_free0 (_tmp13_);
			_tmp13_ = _tmp16_;
		} else {
			gchar* _tmp17_;
			_tmp17_ = g_strdup ("");
			_g_free0 (_tmp13_);
			_tmp13_ = _tmp17_;
		}
		_tmp18_ = msg;
		_tmp19_ = g_strconcat (_tmp18_, _tmp13_, NULL);
		_g_free0 (msg);
		msg = _tmp19_;
		_tmp20_ = msg;
		tee_jee_logging_log_error (_tmp20_, FALSE, FALSE);
		result = list;
		_g_free0 (_tmp13_);
		_g_free0 (msg);
		_g_free0 (_tmp1_);
		_g_match_info_unref0 (match);
		_g_regex_unref0 (rex);
		_g_free0 (cmd);
		_g_free0 (std_err);
		_g_free0 (std_out);
		return result;
	}
	_tmp21_ = std_out;
	_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp23_;
		line_collection_length1 = _vala_array_length (_tmp22_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp24_;
			gchar* line = NULL;
			_tmp24_ = g_strdup (line_collection[line_it]);
			line = _tmp24_;
			{
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gboolean _tmp30_;
				Device* pi = NULL;
				Device* _tmp31_;
				Device* _tmp32_;
				const gchar* _tmp33_;
				gchar** _tmp34_;
				gchar** _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				Device* _tmp39_;
				const gchar* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				Device* _tmp43_;
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				Device* _tmp48_;
				const gchar* _tmp49_;
				Device* _tmp98_;
				const gchar* _tmp99_;
				gint _tmp100_;
				gint _tmp101_;
				_tmp25_ = line;
				_tmp26_ = string_strip (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = strlen (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = _tmp29_ == 0;
				_g_free0 (_tmp27_);
				if (_tmp30_) {
					_g_free0 (line);
					continue;
				}
				_tmp31_ = device_new ();
				pi = _tmp31_;
				_tmp32_ = pi;
				_tmp33_ = line;
				_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, ":", 0);
				_tmp36_ = _tmp35_;
				_tmp36__length1 = _vala_array_length (_tmp34_);
				_tmp37_ = _tmp36_[0];
				_tmp38_ = string_strip (_tmp37_);
				_g_free0 (_tmp32_->device);
				_tmp32_->device = _tmp38_;
				_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
				_tmp39_ = pi;
				_tmp40_ = _tmp39_->device;
				_tmp41_ = strlen (_tmp40_);
				_tmp42_ = _tmp41_;
				if (_tmp42_ == 0) {
					_g_object_unref0 (pi);
					_g_free0 (line);
					continue;
				}
				_tmp43_ = pi;
				_tmp44_ = _tmp43_->device;
				if (!g_str_has_prefix (_tmp44_, "/dev/")) {
					_g_object_unref0 (pi);
					_g_free0 (line);
					continue;
				}
				_tmp48_ = pi;
				_tmp49_ = _tmp48_->device;
				if (g_str_has_prefix (_tmp49_, "/dev/sd")) {
					_tmp47_ = TRUE;
				} else {
					Device* _tmp50_;
					const gchar* _tmp51_;
					_tmp50_ = pi;
					_tmp51_ = _tmp50_->device;
					_tmp47_ = g_str_has_prefix (_tmp51_, "/dev/hd");
				}
				if (_tmp47_) {
					_tmp46_ = TRUE;
				} else {
					Device* _tmp52_;
					const gchar* _tmp53_;
					_tmp52_ = pi;
					_tmp53_ = _tmp52_->device;
					_tmp46_ = g_str_has_prefix (_tmp53_, "/dev/mapper/");
				}
				if (_tmp46_) {
					_tmp45_ = TRUE;
				} else {
					Device* _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = pi;
					_tmp55_ = _tmp54_->device;
					_tmp45_ = g_str_has_prefix (_tmp55_, "/dev/dm");
				}
				if (_tmp45_) {
				} else {
					Device* _tmp56_;
					const gchar* _tmp57_;
					_tmp56_ = pi;
					_tmp57_ = _tmp56_->device;
					if (g_str_has_prefix (_tmp57_, "/dev/disk/by-uuid/")) {
						Device* _tmp58_;
						Device* _tmp59_;
						const gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp58_ = pi;
						_tmp59_ = pi;
						_tmp60_ = _tmp59_->device;
						_tmp61_ = string_replace (_tmp60_, "/dev/disk/by-uuid/", "");
						_g_free0 (_tmp58_->uuid);
						_tmp58_->uuid = _tmp61_;
					} else {
						_g_object_unref0 (pi);
						_g_free0 (line);
						continue;
					}
				}
				{
					GRegex* _tmp62_ = NULL;
					GRegex* _tmp63_;
					GRegex* _tmp64_;
					GRegex* _tmp65_;
					const gchar* _tmp66_;
					GMatchInfo* _tmp67_ = NULL;
					gboolean _tmp68_;
					GRegex* _tmp72_ = NULL;
					GRegex* _tmp73_;
					GRegex* _tmp74_;
					GRegex* _tmp75_;
					const gchar* _tmp76_;
					GMatchInfo* _tmp77_ = NULL;
					gboolean _tmp78_;
					GRegex* _tmp84_ = NULL;
					GRegex* _tmp85_;
					GRegex* _tmp86_;
					GRegex* _tmp87_;
					const gchar* _tmp88_;
					GMatchInfo* _tmp89_ = NULL;
					gboolean _tmp90_;
					_tmp63_ = g_regex_new ("LABEL=\\\"([^\\\"]*)\\\"", 0, 0, &_inner_error0_);
					_tmp62_ = _tmp63_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp64_ = _tmp62_;
					_tmp62_ = NULL;
					_g_regex_unref0 (rex);
					rex = _tmp64_;
					_tmp65_ = rex;
					_tmp66_ = line;
					_tmp68_ = g_regex_match (_tmp65_, _tmp66_, 0, &_tmp67_);
					_g_match_info_unref0 (match);
					match = _tmp67_;
					if (_tmp68_) {
						Device* _tmp69_;
						GMatchInfo* _tmp70_;
						gchar* _tmp71_;
						_tmp69_ = pi;
						_tmp70_ = match;
						_tmp71_ = g_match_info_fetch (_tmp70_, 1);
						_g_free0 (_tmp69_->label);
						_tmp69_->label = _tmp71_;
					}
					_tmp73_ = g_regex_new ("UUID=\\\"([^\\\"]*)\\\"", 0, 0, &_inner_error0_);
					_tmp72_ = _tmp73_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_regex_unref0 (_tmp62_);
						goto __catch0_g_error;
					}
					_tmp74_ = _tmp72_;
					_tmp72_ = NULL;
					_g_regex_unref0 (rex);
					rex = _tmp74_;
					_tmp75_ = rex;
					_tmp76_ = line;
					_tmp78_ = g_regex_match (_tmp75_, _tmp76_, 0, &_tmp77_);
					_g_match_info_unref0 (match);
					match = _tmp77_;
					if (_tmp78_) {
						Device* _tmp79_;
						GMatchInfo* _tmp80_;
						gchar* _tmp81_;
						gchar* _tmp82_;
						gchar* _tmp83_;
						_tmp79_ = pi;
						_tmp80_ = match;
						_tmp81_ = g_match_info_fetch (_tmp80_, 1);
						_tmp82_ = _tmp81_;
						_tmp83_ = string_strip (_tmp82_);
						_g_free0 (_tmp79_->uuid);
						_tmp79_->uuid = _tmp83_;
						_g_free0 (_tmp82_);
					}
					_tmp85_ = g_regex_new ("TYPE=\\\"([^\\\"]*)\\\"", 0, 0, &_inner_error0_);
					_tmp84_ = _tmp85_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_regex_unref0 (_tmp72_);
						_g_regex_unref0 (_tmp62_);
						goto __catch0_g_error;
					}
					_tmp86_ = _tmp84_;
					_tmp84_ = NULL;
					_g_regex_unref0 (rex);
					rex = _tmp86_;
					_tmp87_ = rex;
					_tmp88_ = line;
					_tmp90_ = g_regex_match (_tmp87_, _tmp88_, 0, &_tmp89_);
					_g_match_info_unref0 (match);
					match = _tmp89_;
					if (_tmp90_) {
						Device* _tmp91_;
						GMatchInfo* _tmp92_;
						gchar* _tmp93_;
						gchar* _tmp94_;
						gchar* _tmp95_;
						_tmp91_ = pi;
						_tmp92_ = match;
						_tmp93_ = g_match_info_fetch (_tmp92_, 1);
						_tmp94_ = _tmp93_;
						_tmp95_ = string_strip (_tmp94_);
						_g_free0 (_tmp91_->fstype);
						_tmp91_->fstype = _tmp95_;
						_g_free0 (_tmp94_);
					}
					_g_regex_unref0 (_tmp84_);
					_g_regex_unref0 (_tmp72_);
					_g_regex_unref0 (_tmp62_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp96_;
					const gchar* _tmp97_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp96_ = e;
					_tmp97_ = _tmp96_->message;
					tee_jee_logging_log_error (_tmp97_, FALSE, FALSE);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (pi);
					_g_free0 (line);
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp1_);
					_g_match_info_unref0 (match);
					_g_regex_unref0 (rex);
					_g_free0 (cmd);
					_g_free0 (std_err);
					_g_free0 (std_out);
					_g_object_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp98_ = pi;
				_tmp99_ = _tmp98_->uuid;
				_tmp100_ = strlen (_tmp99_);
				_tmp101_ = _tmp100_;
				if (_tmp101_ > 0) {
					GeeArrayList* _tmp102_;
					Device* _tmp103_;
					_tmp102_ = list;
					_tmp103_ = pi;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, _tmp103_);
				}
				_g_object_unref0 (pi);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp104_ = list;
	_tmp105_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = g_strdup_printf ("Device: get_block_devices_using_blkid(): %d", _tmp106_);
	_tmp108_ = _tmp107_;
	tee_jee_logging_log_debug (_tmp108_);
	_g_free0 (_tmp108_);
	result = list;
	_g_free0 (_tmp1_);
	_g_match_info_unref0 (match);
	_g_regex_unref0 (rex);
	_g_free0 (cmd);
	_g_free0 (std_err);
	_g_free0 (std_out);
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

GeeArrayList*
device_get_disk_space_using_df (const gchar* dev_name_or_mount_point)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* cmd = NULL;
	gint ret_val = 0;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gint _tmp14_;
	gchar** lines = NULL;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint lines_length1;
	gint _lines_size_;
	gint line_num = 0;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GeeArrayList* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	GeeArrayList* result;
	g_return_val_if_fail (dev_name_or_mount_point != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = g_strdup ("df -T -B1");
	_g_free0 (cmd);
	cmd = _tmp1_;
	_tmp2_ = strlen (dev_name_or_mount_point);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = cmd;
		_tmp5_ = tee_jee_file_system_escape_single_quote (dev_name_or_mount_point);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf (" '%s'", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
		_g_free0 (cmd);
		cmd = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	if (tee_jee_logging_LOG_DEBUG) {
		const gchar* _tmp10_;
		_tmp10_ = cmd;
		tee_jee_logging_log_debug (_tmp10_);
	}
	_tmp11_ = cmd;
	_tmp14_ = tee_jee_process_helper_exec_sync (_tmp11_, &_tmp12_, &_tmp13_);
	_g_free0 (std_out);
	std_out = _tmp12_;
	_g_free0 (std_err);
	std_err = _tmp13_;
	ret_val = _tmp14_;
	_tmp15_ = std_out;
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "\n", 0);
	lines = _tmp17_;
	lines_length1 = _vala_array_length (_tmp16_);
	_lines_size_ = lines_length1;
	line_num = 0;
	_tmp18_ = lines;
	_tmp18__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp18_;
		line_collection_length1 = _tmp18__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp19_;
			gchar* line = NULL;
			_tmp19_ = g_strdup (line_collection[line_it]);
			line = _tmp19_;
			{
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gboolean _tmp26_;
				Device* pi = NULL;
				Device* _tmp27_;
				gint k = 0;
				const gchar* _tmp28_;
				gchar** _tmp29_;
				gchar** _tmp30_;
				Device* _tmp60_;
				Device* _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				Device* _tmp64_;
				Device* _tmp65_;
				const gchar* _tmp66_;
				gchar* _tmp67_;
				Device* _tmp68_;
				const gchar* _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				line_num = line_num + 1;
				_tmp20_ = line_num;
				if (_tmp20_ == 1) {
					_g_free0 (line);
					continue;
				}
				_tmp21_ = line;
				_tmp22_ = string_strip (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_ == 0;
				_g_free0 (_tmp23_);
				if (_tmp26_) {
					_g_free0 (line);
					continue;
				}
				_tmp27_ = device_new ();
				pi = _tmp27_;
				k = 1;
				_tmp28_ = line;
				_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, " ", 0);
				{
					gchar** val_collection = NULL;
					gint val_collection_length1 = 0;
					gint _val_collection_size_ = 0;
					gint val_it = 0;
					val_collection = _tmp30_;
					val_collection_length1 = _vala_array_length (_tmp29_);
					for (val_it = 0; val_it < val_collection_length1; val_it = val_it + 1) {
						gchar* _tmp31_;
						gchar* val = NULL;
						_tmp31_ = g_strdup (val_collection[val_it]);
						val = _tmp31_;
						{
							const gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gboolean _tmp37_;
							gint _tmp38_;
							_tmp32_ = val;
							_tmp33_ = string_strip (_tmp32_);
							_tmp34_ = _tmp33_;
							_tmp35_ = strlen (_tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = _tmp36_ == 0;
							_g_free0 (_tmp34_);
							if (_tmp37_) {
								_g_free0 (val);
								continue;
							}
							_tmp38_ = k;
							k = _tmp38_ + 1;
							switch (_tmp38_) {
								case 1:
								{
									Device* _tmp39_;
									const gchar* _tmp40_;
									gchar* _tmp41_;
									_tmp39_ = pi;
									_tmp40_ = val;
									_tmp41_ = string_strip (_tmp40_);
									_g_free0 (_tmp39_->device);
									_tmp39_->device = _tmp41_;
									break;
								}
								case 2:
								{
									Device* _tmp42_;
									const gchar* _tmp43_;
									gchar* _tmp44_;
									_tmp42_ = pi;
									_tmp43_ = val;
									_tmp44_ = string_strip (_tmp43_);
									_g_free0 (_tmp42_->fstype);
									_tmp42_->fstype = _tmp44_;
									break;
								}
								case 3:
								{
									Device* _tmp45_;
									const gchar* _tmp46_;
									gchar* _tmp47_;
									gchar* _tmp48_;
									_tmp45_ = pi;
									_tmp46_ = val;
									_tmp47_ = string_strip (_tmp46_);
									_tmp48_ = _tmp47_;
									_tmp45_->size_bytes = uint64_parse (_tmp48_, (guint) 0);
									_g_free0 (_tmp48_);
									break;
								}
								case 4:
								{
									Device* _tmp49_;
									const gchar* _tmp50_;
									gchar* _tmp51_;
									gchar* _tmp52_;
									_tmp49_ = pi;
									_tmp50_ = val;
									_tmp51_ = string_strip (_tmp50_);
									_tmp52_ = _tmp51_;
									_tmp49_->used_bytes = uint64_parse (_tmp52_, (guint) 0);
									_g_free0 (_tmp52_);
									break;
								}
								case 5:
								{
									Device* _tmp53_;
									const gchar* _tmp54_;
									gchar* _tmp55_;
									gchar* _tmp56_;
									_tmp53_ = pi;
									_tmp54_ = val;
									_tmp55_ = string_strip (_tmp54_);
									_tmp56_ = _tmp55_;
									_tmp53_->available_bytes = uint64_parse (_tmp56_, (guint) 0);
									_g_free0 (_tmp56_);
									break;
								}
								case 6:
								{
									Device* _tmp57_;
									const gchar* _tmp58_;
									gchar* _tmp59_;
									_tmp57_ = pi;
									_tmp58_ = val;
									_tmp59_ = string_strip (_tmp58_);
									_g_free0 (_tmp57_->used_percent);
									_tmp57_->used_percent = _tmp59_;
									break;
								}
								case 7:
								{
									break;
								}
								default:
								break;
							}
							_g_free0 (val);
						}
					}
					val_collection = (_vala_array_free (val_collection, val_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_tmp60_ = pi;
				_tmp61_ = pi;
				_tmp62_ = _tmp61_->device;
				_tmp63_ = device_resolve_device_name (_tmp62_);
				_g_free0 (_tmp60_->device);
				_tmp60_->device = _tmp63_;
				_tmp64_ = pi;
				_tmp65_ = pi;
				_tmp66_ = _tmp65_->device;
				_tmp67_ = device_get_device_uuid (_tmp66_);
				_g_free0 (_tmp64_->uuid);
				_tmp64_->uuid = _tmp67_;
				_tmp68_ = pi;
				_tmp69_ = _tmp68_->uuid;
				_tmp70_ = strlen (_tmp69_);
				_tmp71_ = _tmp70_;
				if (_tmp71_ > 0) {
					GeeArrayList* _tmp72_;
					Device* _tmp73_;
					_tmp72_ = list;
					_tmp73_ = pi;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, _tmp73_);
				}
				_g_object_unref0 (pi);
				_g_free0 (line);
			}
		}
	}
	_tmp74_ = list;
	_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = g_strdup_printf ("Device: get_disk_space_using_df(): %d", _tmp76_);
	_tmp78_ = _tmp77_;
	tee_jee_logging_log_debug (_tmp78_);
	_g_free0 (_tmp78_);
	result = list;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_free0 (std_err);
	_g_free0 (std_out);
	return result;
}

GeeArrayList*
device_get_mounted_filesystems_using_mtab (void)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* mtab_path = NULL;
	gchar* _tmp1_;
	gchar* mtab_lines = NULL;
	gchar* _tmp2_;
	GFile* f = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** lines = NULL;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint lines_length1;
	gint _lines_size_;
	GeeArrayList* mount_list = NULL;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GeeArrayList* result;
	_tmp0_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = g_strdup ("/etc/mtab");
	mtab_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	mtab_lines = _tmp2_;
	_tmp3_ = g_strdup ("/proc/mounts");
	_g_free0 (mtab_path);
	mtab_path = _tmp3_;
	_tmp4_ = mtab_path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_g_object_unref0 (f);
	f = _tmp5_;
	_tmp6_ = f;
	if (!g_file_query_exists (_tmp6_, NULL)) {
		gchar* _tmp7_;
		const gchar* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp7_ = g_strdup ("/proc/self/mounts");
		_g_free0 (mtab_path);
		mtab_path = _tmp7_;
		_tmp8_ = mtab_path;
		_tmp9_ = g_file_new_for_path (_tmp8_);
		_g_object_unref0 (f);
		f = _tmp9_;
		_tmp10_ = f;
		if (!g_file_query_exists (_tmp10_, NULL)) {
			gchar* _tmp11_;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			_tmp11_ = g_strdup ("/etc/mtab");
			_g_free0 (mtab_path);
			mtab_path = _tmp11_;
			_tmp12_ = mtab_path;
			_tmp13_ = g_file_new_for_path (_tmp12_);
			_g_object_unref0 (f);
			f = _tmp13_;
			_tmp14_ = f;
			if (!g_file_query_exists (_tmp14_, NULL)) {
				result = list;
				_g_object_unref0 (f);
				_g_free0 (mtab_lines);
				_g_free0 (mtab_path);
				return result;
			}
		}
	}
	_tmp15_ = mtab_path;
	_tmp16_ = tee_jee_file_system_file_read (_tmp15_);
	_g_free0 (mtab_lines);
	mtab_lines = _tmp16_;
	_tmp17_ = mtab_lines;
	_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "\n", 0);
	lines = _tmp19_;
	lines_length1 = _vala_array_length (_tmp18_);
	_lines_size_ = lines_length1;
	_tmp20_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	mount_list = _tmp20_;
	{
		gint i = 0;
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp21_ = lines;
		_tmp21__length1 = lines_length1;
		i = _tmp21__length1 - 1;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gboolean ignoreEntry = FALSE;
				gchar* line = NULL;
				gchar** _tmp24_;
				gint _tmp24__length1;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				Device* pi = NULL;
				Device* _tmp30_;
				MountEntry* mp = NULL;
				Device* _tmp31_;
				MountEntry* _tmp32_;
				gint k = 0;
				const gchar* _tmp33_;
				gchar** _tmp34_;
				gchar** _tmp35_;
				Device* _tmp69_;
				Device* _tmp70_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				Device* _tmp73_;
				Device* _tmp74_;
				const gchar* _tmp75_;
				gchar* _tmp76_;
				Device* _tmp77_;
				const gchar* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ - 1;
				}
				_tmp22_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				ignoreEntry = FALSE;
				_tmp24_ = lines;
				_tmp24__length1 = lines_length1;
				_tmp25_ = _tmp24_[i];
				_tmp26_ = string_strip (_tmp25_);
				line = _tmp26_;
				_tmp27_ = line;
				_tmp28_ = strlen (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == 0) {
					_g_free0 (line);
					continue;
				}
				_tmp30_ = device_new ();
				pi = _tmp30_;
				_tmp31_ = pi;
				_tmp32_ = mount_entry_new (_tmp31_, "", "");
				mp = _tmp32_;
				k = 1;
				_tmp33_ = line;
				_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, " ", 0);
				{
					gchar** val_collection = NULL;
					gint val_collection_length1 = 0;
					gint _val_collection_size_ = 0;
					gint val_it = 0;
					val_collection = _tmp35_;
					val_collection_length1 = _vala_array_length (_tmp34_);
					for (val_it = 0; val_it < val_collection_length1; val_it = val_it + 1) {
						gchar* _tmp36_;
						gchar* val = NULL;
						_tmp36_ = g_strdup (val_collection[val_it]);
						val = _tmp36_;
						{
							const gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							gboolean _tmp42_;
							gint _tmp43_;
							_tmp37_ = val;
							_tmp38_ = string_strip (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = strlen (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = _tmp41_ == 0;
							_g_free0 (_tmp39_);
							if (_tmp42_) {
								_g_free0 (val);
								continue;
							}
							if (ignoreEntry) {
								_g_free0 (val);
								break;
							}
							_tmp43_ = k;
							k = _tmp43_ + 1;
							switch (_tmp43_) {
								case 1:
								{
									Device* _tmp44_;
									const gchar* _tmp45_;
									gchar* _tmp46_;
									_tmp44_ = pi;
									_tmp45_ = val;
									_tmp46_ = string_strip (_tmp45_);
									_g_free0 (_tmp44_->device);
									_tmp44_->device = _tmp46_;
									break;
								}
								case 2:
								{
									MountEntry* _tmp47_;
									const gchar* _tmp48_;
									gchar* _tmp49_;
									gchar* _tmp50_;
									gchar* _tmp51_;
									MountEntry* _tmp52_;
									const gchar* _tmp53_;
									GeeArrayList* _tmp54_;
									MountEntry* _tmp55_;
									const gchar* _tmp56_;
									_tmp47_ = mp;
									_tmp48_ = val;
									_tmp49_ = string_strip (_tmp48_);
									_tmp50_ = _tmp49_;
									_tmp51_ = string_replace (_tmp50_, "\\040", " ");
									_g_free0 (_tmp47_->mount_point);
									_tmp47_->mount_point = _tmp51_;
									_g_free0 (_tmp50_);
									_tmp52_ = mp;
									_tmp53_ = _tmp52_->mount_point;
									if (string_contains (_tmp53_, "/docker")) {
										ignoreEntry = TRUE;
										break;
									}
									_tmp54_ = mount_list;
									_tmp55_ = mp;
									_tmp56_ = _tmp55_->mount_point;
									if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp54_, _tmp56_)) {
										GeeArrayList* _tmp57_;
										MountEntry* _tmp58_;
										const gchar* _tmp59_;
										Device* _tmp60_;
										GeeArrayList* _tmp61_;
										MountEntry* _tmp62_;
										_tmp57_ = mount_list;
										_tmp58_ = mp;
										_tmp59_ = _tmp58_->mount_point;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp59_);
										_tmp60_ = pi;
										_tmp61_ = _tmp60_->mount_points;
										_tmp62_ = mp;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
									}
									break;
								}
								case 3:
								{
									Device* _tmp63_;
									const gchar* _tmp64_;
									gchar* _tmp65_;
									_tmp63_ = pi;
									_tmp64_ = val;
									_tmp65_ = string_strip (_tmp64_);
									_g_free0 (_tmp63_->fstype);
									_tmp63_->fstype = _tmp65_;
									break;
								}
								case 4:
								{
									MountEntry* _tmp66_;
									const gchar* _tmp67_;
									gchar* _tmp68_;
									_tmp66_ = mp;
									_tmp67_ = val;
									_tmp68_ = string_strip (_tmp67_);
									_g_free0 (_tmp66_->mount_options);
									_tmp66_->mount_options = _tmp68_;
									break;
								}
								default:
								{
									break;
								}
							}
							_g_free0 (val);
						}
					}
					val_collection = (_vala_array_free (val_collection, val_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				if (ignoreEntry) {
					_g_object_unref0 (mp);
					_g_object_unref0 (pi);
					_g_free0 (line);
					continue;
				}
				_tmp69_ = pi;
				_tmp70_ = pi;
				_tmp71_ = _tmp70_->device;
				_tmp72_ = device_resolve_device_name (_tmp71_);
				_g_free0 (_tmp69_->device);
				_tmp69_->device = _tmp72_;
				_tmp73_ = pi;
				_tmp74_ = pi;
				_tmp75_ = _tmp74_->device;
				_tmp76_ = device_get_device_uuid (_tmp75_);
				_g_free0 (_tmp73_->uuid);
				_tmp73_->uuid = _tmp76_;
				_tmp77_ = pi;
				_tmp78_ = _tmp77_->uuid;
				_tmp79_ = strlen (_tmp78_);
				_tmp80_ = _tmp79_;
				if (_tmp80_ > 0) {
					Device* dev = NULL;
					GeeArrayList* _tmp81_;
					Device* _tmp82_;
					const gchar* _tmp83_;
					Device* _tmp84_;
					Device* _tmp85_;
					_tmp81_ = list;
					_tmp82_ = pi;
					_tmp83_ = _tmp82_->uuid;
					_tmp84_ = device_find_device_in_list (_tmp81_, _tmp83_);
					dev = _tmp84_;
					_tmp85_ = dev;
					if (_tmp85_ == NULL) {
						GeeArrayList* _tmp86_;
						Device* _tmp87_;
						_tmp86_ = list;
						_tmp87_ = pi;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
					} else {
						{
							GeeArrayList* _item_list = NULL;
							Device* _tmp88_;
							GeeArrayList* _tmp89_;
							gint _item_size = 0;
							GeeArrayList* _tmp90_;
							gint _tmp91_;
							gint _tmp92_;
							gint _item_index = 0;
							_tmp88_ = pi;
							_tmp89_ = _tmp88_->mount_points;
							_item_list = _tmp89_;
							_tmp90_ = _item_list;
							_tmp91_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp90_);
							_tmp92_ = _tmp91_;
							_item_size = _tmp92_;
							_item_index = -1;
							while (TRUE) {
								gint _tmp93_;
								gint _tmp94_;
								MountEntry* item = NULL;
								GeeArrayList* _tmp95_;
								gpointer _tmp96_;
								Device* _tmp97_;
								GeeArrayList* _tmp98_;
								MountEntry* _tmp99_;
								_item_index = _item_index + 1;
								_tmp93_ = _item_index;
								_tmp94_ = _item_size;
								if (!(_tmp93_ < _tmp94_)) {
									break;
								}
								_tmp95_ = _item_list;
								_tmp96_ = gee_abstract_list_get ((GeeAbstractList*) _tmp95_, _item_index);
								item = (MountEntry*) _tmp96_;
								_tmp97_ = dev;
								_tmp98_ = _tmp97_->mount_points;
								_tmp99_ = item;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, _tmp99_);
								_g_object_unref0 (item);
							}
						}
					}
					_g_object_unref0 (dev);
				}
				_g_object_unref0 (mp);
				_g_object_unref0 (pi);
				_g_free0 (line);
			}
		}
	}
	_tmp100_ = list;
	_tmp101_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = g_strdup_printf ("Device: get_mounted_filesystems_using_mtab(): %d", _tmp102_);
	_tmp104_ = _tmp103_;
	tee_jee_logging_log_debug (_tmp104_);
	_g_free0 (_tmp104_);
	result = list;
	_g_object_unref0 (mount_list);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (f);
	_g_free0 (mtab_lines);
	_g_free0 (mtab_path);
	return result;
}

Device*
device_get_device_by_uuid (const gchar* uuid)
{
	GeeArrayList* _tmp0_;
	Device* _tmp1_;
	Device* result;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = device_device_list;
	_tmp1_ = device_find_device_in_list (_tmp0_, uuid);
	result = _tmp1_;
	return result;
}

Device*
device_get_device_by_name (const gchar* file_name)
{
	GeeArrayList* _tmp0_;
	Device* _tmp1_;
	Device* result;
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = device_device_list;
	_tmp1_ = device_find_device_in_list (_tmp0_, file_name);
	result = _tmp1_;
	return result;
}

Device*
device_get_device_by_path (const gchar* path_to_check)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Device* result;
	g_return_val_if_fail (path_to_check != NULL, NULL);
	_tmp0_ = device_get_disk_space_using_df (path_to_check);
	list = _tmp0_;
	_tmp1_ = list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = list;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, 0);
		result = (Device*) _tmp5_;
		_g_object_unref0 (list);
		return result;
	}
	result = NULL;
	_g_object_unref0 (list);
	return result;
}

gchar*
device_get_device_uuid (const gchar* device)
{
	GeeArrayList* _tmp0_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device_device_list;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		_tmp1_ = device_get_block_devices_using_lsblk ("");
		_g_object_unref0 (device_device_list);
		device_device_list = _tmp1_;
	}
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp2_;
		gint _dev_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _dev_index = 0;
		_tmp2_ = device_device_list;
		_dev_list = _tmp2_;
		_tmp3_ = _dev_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_dev_size = _tmp5_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			Device* dev = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			Device* _tmp10_;
			const gchar* _tmp11_;
			_dev_index = _dev_index + 1;
			_tmp6_ = _dev_index;
			_tmp7_ = _dev_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _dev_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _dev_index);
			dev = (Device*) _tmp9_;
			_tmp10_ = dev;
			_tmp11_ = _tmp10_->device;
			if (g_strcmp0 (_tmp11_, device) == 0) {
				Device* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = dev;
				_tmp13_ = _tmp12_->uuid;
				_tmp14_ = g_strdup (_tmp13_);
				result = _tmp14_;
				_g_object_unref0 (dev);
				return result;
			}
			_g_object_unref0 (dev);
		}
	}
	_tmp15_ = g_strdup ("");
	result = _tmp15_;
	return result;
}

GeeArrayList*
device_get_device_mount_points (const gchar* dev_name_or_uuid)
{
	gchar* device = NULL;
	gchar* _tmp0_;
	gchar* uuid = NULL;
	gchar* _tmp1_;
	GeeArrayList* list_mtab = NULL;
	GeeArrayList* _tmp9_;
	Device* dev = NULL;
	GeeArrayList* _tmp10_;
	const gchar* _tmp11_;
	Device* _tmp12_;
	Device* _tmp13_;
	GeeArrayList* result;
	g_return_val_if_fail (dev_name_or_uuid != NULL, NULL);
	_tmp0_ = g_strdup ("");
	device = _tmp0_;
	_tmp1_ = g_strdup ("");
	uuid = _tmp1_;
	if (g_str_has_prefix (dev_name_or_uuid, "/dev")) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup (dev_name_or_uuid);
		_g_free0 (device);
		device = _tmp2_;
		_tmp3_ = device_get_device_uuid (dev_name_or_uuid);
		_g_free0 (uuid);
		uuid = _tmp3_;
	} else {
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = g_strdup (dev_name_or_uuid);
		_g_free0 (uuid);
		uuid = _tmp4_;
		_tmp5_ = uuid;
		_tmp6_ = g_strdup_printf ("/dev/disk/by-uuid/%s", _tmp5_);
		_g_free0 (device);
		device = _tmp6_;
		_tmp7_ = device;
		_tmp8_ = device_resolve_device_name (_tmp7_);
		_g_free0 (device);
		device = _tmp8_;
	}
	_tmp9_ = device_get_mounted_filesystems_using_mtab ();
	list_mtab = _tmp9_;
	_tmp10_ = list_mtab;
	_tmp11_ = uuid;
	_tmp12_ = device_find_device_in_list (_tmp10_, _tmp11_);
	dev = _tmp12_;
	_tmp13_ = dev;
	if (_tmp13_ != NULL) {
		Device* _tmp14_;
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		_tmp14_ = dev;
		_tmp15_ = _tmp14_->mount_points;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		result = _tmp16_;
		_g_object_unref0 (dev);
		_g_object_unref0 (list_mtab);
		_g_free0 (uuid);
		_g_free0 (device);
		return result;
	} else {
		GeeArrayList* _tmp17_;
		_tmp17_ = gee_array_list_new (TYPE_MOUNT_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		result = _tmp17_;
		_g_object_unref0 (dev);
		_g_object_unref0 (list_mtab);
		_g_free0 (uuid);
		_g_free0 (device);
		return result;
	}
}

gboolean
device_device_is_mounted (const gchar* dev_name_or_uuid)
{
	GeeArrayList* mps = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (dev_name_or_uuid != NULL, FALSE);
	_tmp0_ = device_get_device_mount_points (dev_name_or_uuid);
	mps = _tmp0_;
	_tmp1_ = mps;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		result = TRUE;
		_g_object_unref0 (mps);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (mps);
	return result;
}

gboolean
device_mount_point_in_use (const gchar* mount_point)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (mount_point != NULL, FALSE);
	_tmp0_ = device_get_mounted_filesystems_using_mtab ();
	list = _tmp0_;
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp1_;
		gint _dev_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dev_index = 0;
		_tmp1_ = list;
		_dev_list = _tmp1_;
		_tmp2_ = _dev_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dev_size = _tmp4_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Device* dev = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_dev_index = _dev_index + 1;
			_tmp5_ = _dev_index;
			_tmp6_ = _dev_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _dev_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _dev_index);
			dev = (Device*) _tmp8_;
			{
				GeeArrayList* _mp_list = NULL;
				Device* _tmp9_;
				GeeArrayList* _tmp10_;
				gint _mp_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _mp_index = 0;
				_tmp9_ = dev;
				_tmp10_ = _tmp9_->mount_points;
				_mp_list = _tmp10_;
				_tmp11_ = _mp_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_mp_size = _tmp13_;
				_mp_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					MountEntry* mp = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					MountEntry* _tmp18_;
					const gchar* _tmp19_;
					_mp_index = _mp_index + 1;
					_tmp14_ = _mp_index;
					_tmp15_ = _mp_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _mp_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _mp_index);
					mp = (MountEntry*) _tmp17_;
					_tmp18_ = mp;
					_tmp19_ = _tmp18_->mount_point;
					if (g_str_has_prefix (_tmp19_, mount_point)) {
						result = TRUE;
						_g_object_unref0 (mp);
						_g_object_unref0 (dev);
						_g_object_unref0 (list);
						return result;
					}
					_g_object_unref0 (mp);
				}
			}
			_g_object_unref0 (dev);
		}
	}
	result = FALSE;
	_g_object_unref0 (list);
	return result;
}

gchar*
device_resolve_device_name (const gchar* dev_alias)
{
	Device* dev = NULL;
	GeeArrayList* _tmp0_;
	Device* _tmp1_;
	Device* _tmp2_;
	gchar* result;
	g_return_val_if_fail (dev_alias != NULL, NULL);
	_tmp0_ = device_device_list;
	_tmp1_ = device_find_device_in_list (_tmp0_, dev_alias);
	dev = _tmp1_;
	_tmp2_ = dev;
	if (_tmp2_ != NULL) {
		Device* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = dev;
		_tmp4_ = _tmp3_->device;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (dev);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (dev_alias);
		result = _tmp6_;
		_g_object_unref0 (dev);
		return result;
	}
}

Device*
device_find_device_in_list (GeeArrayList* list,
                            const gchar* _dev_alias)
{
	gchar* dev_alias = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	Device* result;
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (_dev_alias != NULL, NULL);
	_tmp0_ = g_strdup (_dev_alias);
	dev_alias = _tmp0_;
	_tmp1_ = dev_alias;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (_tmp3_, "uuid=");
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp5_ = dev_alias;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "=", 2);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		_tmp9_ = _tmp8_[1];
		_tmp10_ = string_strip (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
		_g_free0 (dev_alias);
		dev_alias = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	} else {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp14_ = dev_alias;
		if (tee_jee_file_system_file_exists (_tmp14_)) {
			const gchar* _tmp15_;
			_tmp15_ = dev_alias;
			_tmp13_ = tee_jee_file_system_file_is_symlink (_tmp15_);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gchar* link_path = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = dev_alias;
			_tmp17_ = tee_jee_file_system_file_get_symlink_target (_tmp16_);
			link_path = _tmp17_;
			_tmp18_ = link_path;
			_tmp19_ = string_replace (_tmp18_, "../../../", "/dev/");
			_tmp20_ = _tmp19_;
			_tmp21_ = string_replace (_tmp20_, "../../", "/dev/");
			_tmp22_ = _tmp21_;
			_tmp23_ = string_replace (_tmp22_, "../", "/dev/");
			_g_free0 (dev_alias);
			dev_alias = _tmp23_;
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_g_free0 (link_path);
		}
	}
	{
		GeeArrayList* _dev_list = NULL;
		gint _dev_size = 0;
		GeeArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _dev_index = 0;
		_dev_list = list;
		_tmp24_ = _dev_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_dev_size = _tmp26_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			Device* dev = NULL;
			GeeArrayList* _tmp29_;
			gpointer _tmp30_;
			Device* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_dev_index = _dev_index + 1;
			_tmp27_ = _dev_index;
			_tmp28_ = _dev_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _dev_list;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _dev_index);
			dev = (Device*) _tmp30_;
			_tmp31_ = dev;
			_tmp32_ = _tmp31_->device;
			_tmp33_ = dev_alias;
			if (g_strcmp0 (_tmp32_, _tmp33_) == 0) {
				result = dev;
				_g_free0 (dev_alias);
				return result;
			} else {
				Device* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp34_ = dev;
				_tmp35_ = _tmp34_->uuid;
				_tmp36_ = dev_alias;
				if (g_strcmp0 (_tmp35_, _tmp36_) == 0) {
					result = dev;
					_g_free0 (dev_alias);
					return result;
				} else {
					Device* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					_tmp37_ = dev;
					_tmp38_ = _tmp37_->label;
					_tmp39_ = dev_alias;
					if (g_strcmp0 (_tmp38_, _tmp39_) == 0) {
						result = dev;
						_g_free0 (dev_alias);
						return result;
					} else {
						Device* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						_tmp40_ = dev;
						_tmp41_ = _tmp40_->partuuid;
						_tmp42_ = dev_alias;
						if (g_strcmp0 (_tmp41_, _tmp42_) == 0) {
							result = dev;
							_g_free0 (dev_alias);
							return result;
						} else {
							Device* _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							_tmp43_ = dev;
							_tmp44_ = _tmp43_->partlabel;
							_tmp45_ = dev_alias;
							if (g_strcmp0 (_tmp44_, _tmp45_) == 0) {
								result = dev;
								_g_free0 (dev_alias);
								return result;
							} else {
								Device* _tmp46_;
								const gchar* _tmp47_;
								const gchar* _tmp48_;
								_tmp46_ = dev;
								_tmp47_ = _tmp46_->device_by_uuid;
								_tmp48_ = dev_alias;
								if (g_strcmp0 (_tmp47_, _tmp48_) == 0) {
									result = dev;
									_g_free0 (dev_alias);
									return result;
								} else {
									Device* _tmp49_;
									const gchar* _tmp50_;
									const gchar* _tmp51_;
									_tmp49_ = dev;
									_tmp50_ = _tmp49_->device_by_label;
									_tmp51_ = dev_alias;
									if (g_strcmp0 (_tmp50_, _tmp51_) == 0) {
										result = dev;
										_g_free0 (dev_alias);
										return result;
									} else {
										Device* _tmp52_;
										const gchar* _tmp53_;
										const gchar* _tmp54_;
										_tmp52_ = dev;
										_tmp53_ = _tmp52_->device_by_partuuid;
										_tmp54_ = dev_alias;
										if (g_strcmp0 (_tmp53_, _tmp54_) == 0) {
											result = dev;
											_g_free0 (dev_alias);
											return result;
										} else {
											Device* _tmp55_;
											const gchar* _tmp56_;
											const gchar* _tmp57_;
											_tmp55_ = dev;
											_tmp56_ = _tmp55_->device_by_partlabel;
											_tmp57_ = dev_alias;
											if (g_strcmp0 (_tmp56_, _tmp57_) == 0) {
												result = dev;
												_g_free0 (dev_alias);
												return result;
											} else {
												Device* _tmp58_;
												const gchar* _tmp59_;
												const gchar* _tmp60_;
												_tmp58_ = dev;
												_tmp59_ = _tmp58_->device_mapper;
												_tmp60_ = dev_alias;
												if (g_strcmp0 (_tmp59_, _tmp60_) == 0) {
													result = dev;
													_g_free0 (dev_alias);
													return result;
												} else {
													Device* _tmp61_;
													const gchar* _tmp62_;
													const gchar* _tmp63_;
													_tmp61_ = dev;
													_tmp62_ = _tmp61_->mapped_name;
													_tmp63_ = dev_alias;
													if (g_strcmp0 (_tmp62_, _tmp63_) == 0) {
														result = dev;
														_g_free0 (dev_alias);
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_g_object_unref0 (dev);
		}
	}
	result = NULL;
	_g_free0 (dev_alias);
	return result;
}

void
device_copy_fields_from (Device* self,
                         Device* dev2)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	Device* _tmp22_;
	Device* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dev2 != NULL);
	_tmp0_ = dev2->device;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->device);
	self->device = _tmp1_;
	_tmp2_ = dev2->name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->name);
	self->name = _tmp3_;
	_tmp4_ = dev2->kname;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->kname);
	self->kname = _tmp5_;
	_tmp6_ = dev2->pkname;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->pkname);
	self->pkname = _tmp7_;
	_tmp8_ = dev2->label;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->label);
	self->label = _tmp9_;
	_tmp10_ = dev2->uuid;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->uuid);
	self->uuid = _tmp11_;
	_tmp12_ = dev2->mapped_name;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (self->mapped_name);
	self->mapped_name = _tmp13_;
	_tmp14_ = dev2->type;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (self->type);
	self->type = _tmp15_;
	_tmp16_ = dev2->fstype;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (self->fstype);
	self->fstype = _tmp17_;
	self->size_bytes = dev2->size_bytes;
	self->used_bytes = dev2->used_bytes;
	self->available_bytes = dev2->available_bytes;
	_tmp18_ = dev2->mount_points;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (self->mount_points);
	self->mount_points = _tmp19_;
	_tmp20_ = dev2->symlinks;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (self->symlinks);
	self->symlinks = _tmp21_;
	_tmp22_ = dev2->parent;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->parent);
	self->parent = _tmp23_;
	_tmp24_ = dev2->children;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->children);
	self->children = _tmp25_;
	_tmp26_ = dev2->vendor;
	_tmp27_ = g_strdup (_tmp26_);
	_g_free0 (self->vendor);
	self->vendor = _tmp27_;
	_tmp28_ = dev2->model;
	_tmp29_ = g_strdup (_tmp28_);
	_g_free0 (self->model);
	self->model = _tmp29_;
	_tmp30_ = dev2->serial;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (self->serial);
	self->serial = _tmp31_;
	_tmp32_ = dev2->revision;
	_tmp33_ = g_strdup (_tmp32_);
	_g_free0 (self->revision);
	self->revision = _tmp33_;
	self->removable = dev2->removable;
	self->read_only = dev2->read_only;
}

Device*
device_query_changes (Device* self)
{
	Device* dev_new = NULL;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	dev_new = NULL;
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp0_;
		gint _dev_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _dev_index = 0;
		_tmp0_ = device_get_block_devices_using_lsblk ("");
		_dev_list = _tmp0_;
		_tmp1_ = _dev_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_dev_size = _tmp3_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Device* dev = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_dev_index = _dev_index + 1;
			_tmp4_ = _dev_index;
			_tmp5_ = _dev_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _dev_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _dev_index);
			dev = (Device*) _tmp7_;
			_tmp8_ = self->uuid;
			_tmp9_ = strlen (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ > 0) {
				Device* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = dev;
				_tmp12_ = _tmp11_->uuid;
				_tmp13_ = self->uuid;
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					Device* _tmp14_;
					Device* _tmp15_;
					_tmp14_ = dev;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					_g_object_unref0 (dev_new);
					dev_new = _tmp15_;
					_g_object_unref0 (dev);
					break;
				}
			} else {
				Device* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = dev;
				_tmp17_ = _tmp16_->device;
				_tmp18_ = self->device;
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
					Device* _tmp19_;
					Device* _tmp20_;
					_tmp19_ = dev;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_g_object_unref0 (dev_new);
					dev_new = _tmp20_;
					_g_object_unref0 (dev);
					break;
				}
			}
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_list);
	}
	result = dev_new;
	return result;
}

void
device_query_disk_space (Device* self)
{
	GeeArrayList* list_df = NULL;
	const gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	Device* dev_df = NULL;
	GeeArrayList* _tmp2_;
	const gchar* _tmp3_;
	Device* _tmp4_;
	Device* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->device;
	_tmp1_ = device_get_disk_space_using_df (_tmp0_);
	list_df = _tmp1_;
	_tmp2_ = list_df;
	_tmp3_ = self->uuid;
	_tmp4_ = device_find_device_in_list (_tmp2_, _tmp3_);
	dev_df = _tmp4_;
	_tmp5_ = dev_df;
	if (_tmp5_ != NULL) {
		Device* _tmp6_;
		Device* _tmp7_;
		Device* _tmp8_;
		Device* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = dev_df;
		self->size_bytes = _tmp6_->size_bytes;
		_tmp7_ = dev_df;
		self->used_bytes = _tmp7_->used_bytes;
		_tmp8_ = dev_df;
		self->available_bytes = _tmp8_->available_bytes;
		_tmp9_ = dev_df;
		_tmp10_ = _tmp9_->used_percent;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->used_percent);
		self->used_percent = _tmp11_;
	}
	_g_object_unref0 (dev_df);
	_g_object_unref0 (list_df);
}

gboolean
device_automount_udisks (const gchar* dev_name_or_uuid,
                         GtkWindow* parent_window)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* cmd = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (dev_name_or_uuid != NULL, FALSE);
	_tmp0_ = strlen (dev_name_or_uuid);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		tee_jee_logging_log_error (_ ("Device name is empty!"), FALSE, FALSE);
		result = FALSE;
		return result;
	}
	_tmp2_ = g_strdup_printf ("udisksctl mount -b '%s'", dev_name_or_uuid);
	cmd = _tmp2_;
	_tmp3_ = cmd;
	tee_jee_logging_log_debug (_tmp3_);
	_tmp4_ = cmd;
	status = system (_tmp4_);
	if (status != 0) {
		if (parent_window != NULL) {
			gchar* msg = NULL;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = g_strdup_printf ("Failed to mount: %s", dev_name_or_uuid);
			msg = _tmp5_;
			_tmp6_ = msg;
			tee_jee_gtk_helper_gtk_messagebox ("Error", _tmp6_, parent_window, TRUE);
			_g_free0 (msg);
		}
	}
	result = status == 0;
	_g_free0 (cmd);
	return result;
}

gboolean
device_automount_udisks_iso (const gchar* iso_file_path,
                             gchar** loop_device,
                             GtkWindow* parent_window)
{
	gchar* _vala_loop_device = NULL;
	gchar* _tmp0_;
	gchar* cmd = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint exit_code = 0;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_;
	gboolean result;
	g_return_val_if_fail (iso_file_path != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_loop_device);
	_vala_loop_device = _tmp0_;
	if (!tee_jee_file_system_file_exists (iso_file_path)) {
		gchar* msg = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("%s: %s", _ ("Could not find file"), iso_file_path);
		msg = _tmp1_;
		_tmp2_ = msg;
		tee_jee_logging_log_error (_tmp2_, FALSE, FALSE);
		result = FALSE;
		_g_free0 (msg);
		if (loop_device) {
			*loop_device = _vala_loop_device;
		} else {
			_g_free0 (_vala_loop_device);
		}
		return result;
	}
	_tmp3_ = tee_jee_file_system_escape_single_quote (iso_file_path);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("udisksctl loop-setup -r -f '%s'", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	cmd = _tmp6_;
	_tmp7_ = cmd;
	tee_jee_logging_log_debug (_tmp7_);
	_tmp8_ = cmd;
	_tmp11_ = tee_jee_process_helper_exec_sync (_tmp8_, &_tmp9_, &_tmp10_);
	_g_free0 (std_out);
	std_out = _tmp9_;
	_g_free0 (std_err);
	std_err = _tmp10_;
	exit_code = _tmp11_;
	if (exit_code == 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GeeArrayList* list = NULL;
		GeeArrayList* _tmp27_;
		_tmp12_ = std_out;
		_tmp13_ = g_strdup_printf ("%s", _tmp12_);
		_tmp14_ = _tmp13_;
		tee_jee_logging_log_msg (_tmp14_, FALSE);
		_g_free0 (_tmp14_);
		_tmp15_ = std_out;
		if (!string_contains (_tmp15_, " as ")) {
			tee_jee_logging_log_error ("Could not determine loop device", FALSE, FALSE);
			result = FALSE;
			_g_free0 (std_err);
			_g_free0 (std_out);
			_g_free0 (cmd);
			if (loop_device) {
				*loop_device = _vala_loop_device;
			} else {
				_g_free0 (_vala_loop_device);
			}
			return result;
		}
		_tmp16_ = std_out;
		_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, " as ", 0);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = _vala_array_length (_tmp17_);
		_tmp20_ = _tmp19_[1];
		_tmp21_ = string_replace (_tmp20_, ".", "");
		_tmp22_ = _tmp21_;
		_tmp23_ = string_strip (_tmp22_);
		_g_free0 (_vala_loop_device);
		_vala_loop_device = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
		_tmp24_ = _vala_loop_device;
		_tmp25_ = g_strdup_printf ("loop_device: %s", _tmp24_);
		_tmp26_ = _tmp25_;
		tee_jee_logging_log_msg (_tmp26_, FALSE);
		_g_free0 (_tmp26_);
		_tmp27_ = device_get_block_devices_using_lsblk ("");
		list = _tmp27_;
		{
			GeeArrayList* _dev_list = NULL;
			GeeArrayList* _tmp28_;
			gint _dev_size = 0;
			GeeArrayList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _dev_index = 0;
			_tmp28_ = list;
			_dev_list = _tmp28_;
			_tmp29_ = _dev_list;
			_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_dev_size = _tmp31_;
			_dev_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				Device* dev = NULL;
				GeeArrayList* _tmp34_;
				gpointer _tmp35_;
				gboolean _tmp36_ = FALSE;
				Device* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gboolean _tmp42_;
				_dev_index = _dev_index + 1;
				_tmp32_ = _dev_index;
				_tmp33_ = _dev_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _dev_list;
				_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _dev_index);
				dev = (Device*) _tmp35_;
				_tmp37_ = dev;
				_tmp38_ = _tmp37_->pkname;
				_tmp39_ = _vala_loop_device;
				_tmp40_ = string_replace (_tmp39_, "/dev/", "");
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strcmp0 (_tmp38_, _tmp41_) == 0;
				_g_free0 (_tmp41_);
				if (_tmp42_) {
					Device* _tmp43_;
					const gchar* _tmp44_;
					_tmp43_ = dev;
					_tmp44_ = _tmp43_->fstype;
					_tmp36_ = g_strcmp0 (_tmp44_, "iso9660") == 0;
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					Device* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					Device* _tmp48_;
					const gchar* _tmp49_;
					_tmp45_ = dev;
					_tmp46_ = _tmp45_->device;
					_tmp47_ = g_strdup (_tmp46_);
					_g_free0 (_vala_loop_device);
					_vala_loop_device = _tmp47_;
					_tmp48_ = dev;
					_tmp49_ = _tmp48_->device;
					result = device_automount_udisks (_tmp49_, parent_window);
					_g_object_unref0 (dev);
					_g_object_unref0 (list);
					_g_free0 (std_err);
					_g_free0 (std_out);
					_g_free0 (cmd);
					if (loop_device) {
						*loop_device = _vala_loop_device;
					} else {
						_g_free0 (_vala_loop_device);
					}
					return result;
				}
				_g_object_unref0 (dev);
			}
		}
		_g_object_unref0 (list);
	}
	result = FALSE;
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	if (loop_device) {
		*loop_device = _vala_loop_device;
	} else {
		_g_free0 (_vala_loop_device);
	}
	return result;
}

gboolean
device_unmount_udisks (const gchar* dev_name_or_uuid,
                       GtkWindow* parent_window)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* cmd = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (dev_name_or_uuid != NULL, FALSE);
	_tmp0_ = strlen (dev_name_or_uuid);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		tee_jee_logging_log_error (_ ("Device name is empty!"), FALSE, FALSE);
		result = FALSE;
		return result;
	}
	_tmp2_ = g_strdup_printf ("udisksctl unmount -b '%s'", dev_name_or_uuid);
	cmd = _tmp2_;
	_tmp3_ = cmd;
	tee_jee_logging_log_debug (_tmp3_);
	_tmp4_ = cmd;
	status = system (_tmp4_);
	if (status != 0) {
		if (parent_window != NULL) {
			gchar* msg = NULL;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = g_strdup_printf ("Failed to unmount: %s", dev_name_or_uuid);
			msg = _tmp5_;
			_tmp6_ = msg;
			tee_jee_gtk_helper_gtk_messagebox ("Error", _tmp6_, parent_window, TRUE);
			_g_free0 (msg);
		}
	}
	result = status == 0;
	_g_free0 (cmd);
	return result;
}

Device*
device_luks_unlock (Device* luks_device,
                    const gchar* mapped_name,
                    const gchar* passphrase,
                    GtkWindow* parent_window,
                    gchar** message,
                    gchar** details)
{
	gchar* _vala_message = NULL;
	gchar* _vala_details = NULL;
	Device* unlocked_device = NULL;
	gchar* std_out = NULL;
	gchar* _tmp0_;
	gchar* std_err = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp7_;
	gchar* luks_pass = NULL;
	gchar* _tmp25_;
	gchar* luks_name = NULL;
	gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	GeeArrayList* _tmp106_;
	gboolean is_error = FALSE;
	Device* _tmp120_;
	Device* result;
	g_return_val_if_fail (luks_device != NULL, NULL);
	g_return_val_if_fail (mapped_name != NULL, NULL);
	g_return_val_if_fail (passphrase != NULL, NULL);
	unlocked_device = NULL;
	_tmp0_ = g_strdup ("");
	std_out = _tmp0_;
	_tmp1_ = g_strdup ("");
	std_err = _tmp1_;
	_tmp3_ = luks_device->fstype;
	if (!string_contains (_tmp3_, "luks")) {
		const gchar* _tmp4_;
		_tmp4_ = luks_device->fstype;
		_tmp2_ = !string_contains (_tmp4_, "crypt");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup (_ ("This device is not encrypted"));
		_g_free0 (_vala_message);
		_vala_message = _tmp5_;
		_tmp6_ = g_strdup (_ ("Failed to unlock device"));
		_g_free0 (_vala_details);
		_vala_details = _tmp6_;
		result = NULL;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_object_unref0 (unlocked_device);
		if (message) {
			*message = _vala_message;
		} else {
			_g_free0 (_vala_message);
		}
		if (details) {
			*details = _vala_details;
		} else {
			_g_free0 (_vala_details);
		}
		return result;
	}
	_tmp7_ = device_get_block_devices_using_lsblk ("");
	list = _tmp7_;
	{
		GeeArrayList* _part_list = NULL;
		GeeArrayList* _tmp8_;
		gint _part_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _part_index = 0;
		_tmp8_ = list;
		_part_list = _tmp8_;
		_tmp9_ = _part_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_part_size = _tmp11_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			Device* part = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			Device* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_part_index = _part_index + 1;
			_tmp12_ = _part_index;
			_tmp13_ = _part_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _part_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _part_index);
			part = (Device*) _tmp15_;
			_tmp16_ = part;
			_tmp17_ = _tmp16_->pkname;
			_tmp18_ = luks_device->kname;
			if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
				Device* _tmp19_;
				Device* _tmp20_;
				gchar* _tmp21_;
				Device* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp19_ = part;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (unlocked_device);
				unlocked_device = _tmp20_;
				_tmp21_ = g_strdup (_ ("Device is unlocked"));
				_g_free0 (_vala_message);
				_vala_message = _tmp21_;
				_tmp22_ = part;
				_tmp23_ = _tmp22_->mapped_name;
				_tmp24_ = g_strdup_printf (_ ("Unlocked device is mapped to '%s'"), _tmp23_);
				_g_free0 (_vala_details);
				_vala_details = _tmp24_;
				result = part;
				_g_object_unref0 (list);
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_object_unref0 (unlocked_device);
				if (message) {
					*message = _vala_message;
				} else {
					_g_free0 (_vala_message);
				}
				if (details) {
					*details = _vala_details;
				} else {
					_g_free0 (_vala_details);
				}
				return result;
			}
			_g_object_unref0 (part);
		}
	}
	_tmp25_ = g_strdup (passphrase);
	luks_pass = _tmp25_;
	_tmp26_ = g_strdup (mapped_name);
	luks_name = _tmp26_;
	_tmp28_ = luks_name;
	if (_tmp28_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp29_ = luks_name;
		_tmp30_ = strlen (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp27_ = _tmp31_ == 0;
	}
	if (_tmp27_) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = luks_device->kname;
		_tmp33_ = g_strdup_printf ("%s_crypt", _tmp32_);
		_g_free0 (luks_name);
		luks_name = _tmp33_;
	}
	if (parent_window == NULL) {
		gboolean _tmp34_ = FALSE;
		const gchar* _tmp35_;
		_tmp35_ = luks_pass;
		if (_tmp35_ == NULL) {
			_tmp34_ = TRUE;
		} else {
			const gchar* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp36_ = luks_pass;
			_tmp37_ = strlen (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp34_ = _tmp38_ == 0;
		}
		if (_tmp34_) {
			TimeoutCounter* counter = NULL;
			TimeoutCounter* _tmp39_;
			TimeoutCounter* _tmp40_;
			gchar* cmd = NULL;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			TimeoutCounter* _tmp46_;
			_tmp39_ = timeout_counter_new ();
			counter = _tmp39_;
			_tmp40_ = counter;
			timeout_counter_kill_process_on_timeout (_tmp40_, "cryptsetup", 20, TRUE);
			_tmp41_ = luks_device->device;
			_tmp42_ = luks_name;
			_tmp43_ = g_strdup_printf ("cryptsetup luksOpen '%s' '%s'", _tmp41_, _tmp42_);
			cmd = _tmp43_;
			_tmp44_ = cmd;
			tee_jee_logging_log_debug (_tmp44_);
			_tmp45_ = cmd;
			system (_tmp45_);
			_tmp46_ = counter;
			timeout_counter_stop (_tmp46_);
			tee_jee_logging_log_msg ("", FALSE);
			_g_free0 (cmd);
			_g_object_unref0 (counter);
		} else {
			gchar* cmd = NULL;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gint status = 0;
			const gchar* _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gint _tmp63_;
			_tmp47_ = luks_pass;
			_tmp48_ = tee_jee_file_system_escape_single_quote (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = luks_device->device;
			_tmp51_ = luks_name;
			_tmp52_ = g_strdup_printf ("echo -n -e '%s' | cryptsetup luksOpen --key-file - '%s' '%s'\n", _tmp49_, _tmp50_, _tmp51_);
			_tmp53_ = _tmp52_;
			_g_free0 (_tmp49_);
			cmd = _tmp53_;
			_tmp54_ = cmd;
			_tmp55_ = luks_pass;
			_tmp56_ = tee_jee_file_system_escape_single_quote (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = string_replace (_tmp54_, _tmp57_, "**PASSWORD**");
			_tmp59_ = _tmp58_;
			tee_jee_logging_log_debug (_tmp59_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
			_tmp60_ = cmd;
			_tmp63_ = tee_jee_process_helper_exec_script_sync (_tmp60_, &_tmp61_, &_tmp62_, FALSE, TRUE, TRUE, FALSE);
			_g_free0 (std_out);
			std_out = _tmp61_;
			_g_free0 (std_err);
			std_err = _tmp62_;
			status = _tmp63_;
			switch (status) {
				case 512:
				{
					gchar* _tmp64_;
					gchar* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					_tmp64_ = g_strdup (_ ("Wrong password"));
					_g_free0 (_vala_message);
					_vala_message = _tmp64_;
					_tmp65_ = g_strdup (_ ("Failed to unlock device"));
					_g_free0 (_vala_details);
					_vala_details = _tmp65_;
					_tmp66_ = _vala_message;
					tee_jee_logging_log_error (_tmp66_, FALSE, FALSE);
					_tmp67_ = _vala_details;
					tee_jee_logging_log_error (_tmp67_, FALSE, FALSE);
					break;
				}
				default:
				break;
			}
			_g_free0 (cmd);
		}
	} else {
		gboolean _tmp68_ = FALSE;
		const gchar* _tmp69_;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp81_;
		_tmp69_ = luks_pass;
		if (_tmp69_ == NULL) {
			_tmp68_ = TRUE;
		} else {
			const gchar* _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp70_ = luks_pass;
			_tmp71_ = strlen (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp68_ = _tmp72_ == 0;
		}
		if (_tmp68_) {
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			const gchar* _tmp77_;
			tee_jee_logging_log_debug ("Prompting user for passphrase..");
			_tmp73_ = luks_device->name;
			_tmp74_ = g_strdup_printf (_ ("Enter passphrase to unlock '%s'"), _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = tee_jee_gtk_helper_gtk_inputbox (_ ("Encrypted Device"), _tmp75_, parent_window, TRUE);
			_g_free0 (luks_pass);
			luks_pass = _tmp76_;
			_g_free0 (_tmp75_);
			_tmp77_ = luks_pass;
			if (_tmp77_ == NULL) {
				gchar* _tmp78_;
				gchar* _tmp79_;
				_tmp78_ = g_strdup (_ ("Failed to unlock device"));
				_g_free0 (_vala_message);
				_vala_message = _tmp78_;
				_tmp79_ = g_strdup (_ ("User cancelled the password prompt"));
				_g_free0 (_vala_details);
				_vala_details = _tmp79_;
				tee_jee_logging_log_debug ("User cancelled the password prompt");
				result = NULL;
				_g_free0 (luks_name);
				_g_free0 (luks_pass);
				_g_object_unref0 (list);
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_object_unref0 (unlocked_device);
				if (message) {
					*message = _vala_message;
				} else {
					_g_free0 (_vala_message);
				}
				if (details) {
					*details = _vala_details;
				} else {
					_g_free0 (_vala_details);
				}
				return result;
			}
		}
		_tmp81_ = luks_pass;
		if (_tmp81_ != NULL) {
			const gchar* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			_tmp82_ = luks_pass;
			_tmp83_ = strlen (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp80_ = _tmp84_ > 0;
		} else {
			_tmp80_ = FALSE;
		}
		if (_tmp80_) {
			gchar* cmd = NULL;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gint status = 0;
			const gchar* _tmp98_;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gint _tmp101_;
			_tmp85_ = luks_pass;
			_tmp86_ = tee_jee_file_system_escape_single_quote (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = luks_device->device;
			_tmp89_ = luks_name;
			_tmp90_ = g_strdup_printf ("echo -n -e '%s' | cryptsetup luksOpen --key-file - '%s' '%s'\n", _tmp87_, _tmp88_, _tmp89_);
			_tmp91_ = _tmp90_;
			_g_free0 (_tmp87_);
			cmd = _tmp91_;
			_tmp92_ = cmd;
			_tmp93_ = luks_pass;
			_tmp94_ = tee_jee_file_system_escape_single_quote (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = string_replace (_tmp92_, _tmp95_, "**PASSWORD**");
			_tmp97_ = _tmp96_;
			tee_jee_logging_log_debug (_tmp97_);
			_g_free0 (_tmp97_);
			_g_free0 (_tmp95_);
			_tmp98_ = cmd;
			_tmp101_ = tee_jee_process_helper_exec_script_sync (_tmp98_, &_tmp99_, &_tmp100_, FALSE, TRUE, TRUE, FALSE);
			_g_free0 (std_out);
			std_out = _tmp99_;
			_g_free0 (std_err);
			std_err = _tmp100_;
			status = _tmp101_;
			switch (status) {
				case 512:
				{
					gchar* _tmp102_;
					gchar* _tmp103_;
					const gchar* _tmp104_;
					const gchar* _tmp105_;
					_tmp102_ = g_strdup (_ ("Wrong password"));
					_g_free0 (_vala_message);
					_vala_message = _tmp102_;
					_tmp103_ = g_strdup (_ ("Failed to unlock device"));
					_g_free0 (_vala_details);
					_vala_details = _tmp103_;
					_tmp104_ = _vala_message;
					tee_jee_logging_log_error (_tmp104_, FALSE, FALSE);
					_tmp105_ = _vala_details;
					tee_jee_logging_log_error (_tmp105_, FALSE, FALSE);
					break;
				}
				default:
				break;
			}
			_g_free0 (cmd);
		}
	}
	_tmp106_ = device_get_block_devices_using_lsblk ("");
	_g_object_unref0 (list);
	list = _tmp106_;
	{
		GeeArrayList* _part_list = NULL;
		GeeArrayList* _tmp107_;
		gint _part_size = 0;
		GeeArrayList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _part_index = 0;
		_tmp107_ = list;
		_part_list = _tmp107_;
		_tmp108_ = _part_list;
		_tmp109_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_part_size = _tmp110_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp111_;
			gint _tmp112_;
			Device* part = NULL;
			GeeArrayList* _tmp113_;
			gpointer _tmp114_;
			Device* _tmp115_;
			const gchar* _tmp116_;
			const gchar* _tmp117_;
			_part_index = _part_index + 1;
			_tmp111_ = _part_index;
			_tmp112_ = _part_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _part_list;
			_tmp114_ = gee_abstract_list_get ((GeeAbstractList*) _tmp113_, _part_index);
			part = (Device*) _tmp114_;
			_tmp115_ = part;
			_tmp116_ = _tmp115_->pkname;
			_tmp117_ = luks_device->kname;
			if (g_strcmp0 (_tmp116_, _tmp117_) == 0) {
				Device* _tmp118_;
				Device* _tmp119_;
				_tmp118_ = part;
				_tmp119_ = _g_object_ref0 (_tmp118_);
				_g_object_unref0 (unlocked_device);
				unlocked_device = _tmp119_;
				_g_object_unref0 (part);
				break;
			}
			_g_object_unref0 (part);
		}
	}
	is_error = FALSE;
	_tmp120_ = unlocked_device;
	if (_tmp120_ == NULL) {
		const gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		const gchar* _tmp125_;
		gchar* _tmp126_;
		_tmp121_ = luks_device->device;
		_tmp122_ = g_strdup_printf (" '%s'", _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strconcat (_ ("Failed to unlock device"), _tmp123_, NULL);
		_g_free0 (_vala_message);
		_vala_message = _tmp124_;
		_g_free0 (_tmp123_);
		_tmp125_ = std_err;
		_tmp126_ = g_strdup (_tmp125_);
		_g_free0 (_vala_details);
		_vala_details = _tmp126_;
		is_error = TRUE;
	} else {
		gchar* _tmp127_;
		Device* _tmp128_;
		const gchar* _tmp129_;
		gchar* _tmp130_;
		_tmp127_ = g_strdup (_ ("Unlocked successfully"));
		_g_free0 (_vala_message);
		_vala_message = _tmp127_;
		_tmp128_ = unlocked_device;
		_tmp129_ = _tmp128_->mapped_name;
		_tmp130_ = g_strdup_printf (_ ("Unlocked device is mapped to '%s'"), _tmp129_);
		_g_free0 (_vala_details);
		_vala_details = _tmp130_;
	}
	if (parent_window != NULL) {
		const gchar* _tmp131_;
		const gchar* _tmp132_;
		_tmp131_ = _vala_message;
		_tmp132_ = _vala_details;
		tee_jee_gtk_helper_gtk_messagebox (_tmp131_, _tmp132_, parent_window, is_error);
	}
	result = unlocked_device;
	_g_free0 (luks_name);
	_g_free0 (luks_pass);
	_g_object_unref0 (list);
	_g_free0 (std_err);
	_g_free0 (std_out);
	if (message) {
		*message = _vala_message;
	} else {
		_g_free0 (_vala_message);
	}
	if (details) {
		*details = _vala_details;
	} else {
		_g_free0 (_vala_details);
	}
	return result;
}

gboolean
device_luks_lock (const gchar* kname,
                  GtkWindow* parent_window)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint status = 0;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (kname != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("cryptsetup luksClose %s", kname);
	cmd = _tmp0_;
	_tmp1_ = cmd;
	tee_jee_logging_log_debug (_tmp1_);
	_tmp2_ = cmd;
	_tmp5_ = tee_jee_process_helper_exec_script_sync (_tmp2_, &_tmp3_, &_tmp4_, FALSE, TRUE, TRUE, FALSE);
	_g_free0 (std_out);
	std_out = _tmp3_;
	_g_free0 (std_err);
	std_err = _tmp4_;
	status = _tmp5_;
	_tmp6_ = std_out;
	tee_jee_logging_log_msg (_tmp6_, FALSE);
	_tmp7_ = std_err;
	tee_jee_logging_log_msg (_tmp7_, FALSE);
	if (status != 0) {
		if (parent_window != NULL) {
			gchar* msg = NULL;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = g_strdup_printf ("Failed to lock device: %s", kname);
			msg = _tmp8_;
			_tmp9_ = msg;
			tee_jee_gtk_helper_gtk_messagebox ("Error", _tmp9_, parent_window, TRUE);
			_g_free0 (msg);
		}
	}
	result = status == 0;
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	return result;
}

gboolean
device_mount (const gchar* dev_name_or_uuid,
              const gchar* mount_point,
              const gchar* mount_options,
              gboolean silent)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint ret_val = 0;
	gchar* device = NULL;
	gchar* _tmp1_;
	gchar* uuid = NULL;
	gchar* _tmp2_;
	GeeArrayList* mps = NULL;
	GeeArrayList* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint _tmp52_;
	gint _tmp53_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gint _tmp64_;
	gboolean result;
	g_return_val_if_fail (dev_name_or_uuid != NULL, FALSE);
	g_return_val_if_fail (mount_point != NULL, FALSE);
	g_return_val_if_fail (mount_options != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	cmd = _tmp0_;
	_tmp1_ = g_strdup ("");
	device = _tmp1_;
	_tmp2_ = g_strdup ("");
	uuid = _tmp2_;
	if (g_str_has_prefix (dev_name_or_uuid, "/dev")) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup (dev_name_or_uuid);
		_g_free0 (device);
		device = _tmp3_;
		_tmp4_ = device_get_device_uuid (dev_name_or_uuid);
		_g_free0 (uuid);
		uuid = _tmp4_;
	} else {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = g_strdup (dev_name_or_uuid);
		_g_free0 (uuid);
		uuid = _tmp5_;
		_tmp6_ = uuid;
		_tmp7_ = g_strdup_printf ("/dev/disk/by-uuid/%s", _tmp6_);
		_g_free0 (device);
		device = _tmp7_;
		_tmp8_ = device;
		_tmp9_ = device_resolve_device_name (_tmp8_);
		_g_free0 (device);
		device = _tmp9_;
	}
	_tmp10_ = device_get_device_mount_points (dev_name_or_uuid);
	mps = _tmp10_;
	tee_jee_logging_log_debug ("------------------");
	_tmp11_ = device;
	_tmp12_ = g_strdup_printf ("arg=%s, device=%s", dev_name_or_uuid, _tmp11_);
	_tmp13_ = _tmp12_;
	tee_jee_logging_log_debug (_tmp13_);
	_g_free0 (_tmp13_);
	{
		GeeArrayList* _mp_list = NULL;
		GeeArrayList* _tmp14_;
		gint _mp_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _mp_index = 0;
		_tmp14_ = mps;
		_mp_list = _tmp14_;
		_tmp15_ = _mp_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_mp_size = _tmp17_;
		_mp_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			MountEntry* mp = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			MountEntry* _tmp22_;
			const gchar* _tmp23_;
			_mp_index = _mp_index + 1;
			_tmp18_ = _mp_index;
			_tmp19_ = _mp_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _mp_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _mp_index);
			mp = (MountEntry*) _tmp21_;
			_tmp22_ = mp;
			_tmp23_ = _tmp22_->mount_point;
			tee_jee_logging_log_debug (_tmp23_);
			_g_object_unref0 (mp);
		}
	}
	tee_jee_logging_log_debug ("------------------");
	{
		GeeArrayList* _mp_list = NULL;
		GeeArrayList* _tmp24_;
		gint _mp_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _mp_index = 0;
		_tmp24_ = mps;
		_mp_list = _tmp24_;
		_tmp25_ = _mp_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_mp_size = _tmp27_;
		_mp_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			MountEntry* mp = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			gboolean _tmp32_ = FALSE;
			MountEntry* _tmp33_;
			const gchar* _tmp34_;
			_mp_index = _mp_index + 1;
			_tmp28_ = _mp_index;
			_tmp29_ = _mp_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _mp_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _mp_index);
			mp = (MountEntry*) _tmp31_;
			_tmp33_ = mp;
			_tmp34_ = _tmp33_->mount_point;
			if (g_strcmp0 (_tmp34_, mount_point) == 0) {
				MountEntry* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = mp;
				_tmp36_ = _tmp35_->mount_options;
				_tmp32_ = string_contains (_tmp36_, mount_options);
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				if (!silent) {
					gchar* msg = NULL;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					MountEntry* _tmp39_;
					const gchar* _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					const gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp37_ = device;
					_tmp38_ = g_strdup_printf ("%s is mounted at: %s", _tmp37_, mount_point);
					msg = _tmp38_;
					_tmp39_ = mp;
					_tmp40_ = _tmp39_->mount_options;
					_tmp41_ = strlen (_tmp40_);
					_tmp42_ = _tmp41_;
					if (_tmp42_ > 0) {
						const gchar* _tmp43_;
						MountEntry* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp43_ = msg;
						_tmp44_ = mp;
						_tmp45_ = _tmp44_->mount_options;
						_tmp46_ = g_strdup_printf (", options: %s", _tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = g_strconcat (_tmp43_, _tmp47_, NULL);
						_g_free0 (msg);
						msg = _tmp48_;
						_g_free0 (_tmp47_);
					}
					_tmp49_ = msg;
					_tmp50_ = g_strdup_printf ("\n%s\n", _tmp49_);
					_tmp51_ = _tmp50_;
					tee_jee_logging_log_msg (_tmp51_, FALSE);
					_g_free0 (_tmp51_);
					_g_free0 (msg);
				}
				result = TRUE;
				_g_object_unref0 (mp);
				_g_object_unref0 (mps);
				_g_free0 (uuid);
				_g_free0 (device);
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_free0 (cmd);
				return result;
			}
			_g_object_unref0 (mp);
		}
	}
	tee_jee_file_system_dir_create (mount_point, FALSE);
	device_unmount (mount_point);
	_tmp52_ = strlen (mount_options);
	_tmp53_ = _tmp52_;
	if (_tmp53_ > 0) {
		const gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp54_ = device;
		_tmp55_ = g_strdup_printf ("mount -o %s \"%s\" \"%s\"", mount_options, _tmp54_, mount_point);
		_g_free0 (cmd);
		cmd = _tmp55_;
	} else {
		const gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp56_ = device;
		_tmp57_ = g_strdup_printf ("mount \"%s\" \"%s\"", _tmp56_, mount_point);
		_g_free0 (cmd);
		cmd = _tmp57_;
	}
	_tmp58_ = cmd;
	_tmp59_ = g_strdup_printf ("mount command: %s", _tmp58_);
	_tmp60_ = _tmp59_;
	tee_jee_logging_log_debug (_tmp60_);
	_g_free0 (_tmp60_);
	_tmp61_ = cmd;
	_tmp64_ = tee_jee_process_helper_exec_sync (_tmp61_, &_tmp62_, &_tmp63_);
	_g_free0 (std_out);
	std_out = _tmp62_;
	_g_free0 (std_err);
	std_err = _tmp63_;
	ret_val = _tmp64_;
	if (ret_val != 0) {
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		const gchar* _tmp68_;
		_tmp65_ = device;
		_tmp66_ = g_strdup_printf ("Failed to mount device '%s' at mount point '%s'", _tmp65_, mount_point);
		_tmp67_ = _tmp66_;
		tee_jee_logging_log_error (_tmp67_, FALSE, FALSE);
		_g_free0 (_tmp67_);
		_tmp68_ = std_err;
		tee_jee_logging_log_error (_tmp68_, FALSE, FALSE);
		result = FALSE;
		_g_object_unref0 (mps);
		_g_free0 (uuid);
		_g_free0 (device);
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	} else {
		if (!silent) {
			Device* dev = NULL;
			const gchar* _tmp69_;
			Device* _tmp70_;
			gchar* _tmp71_ = NULL;
			Device* _tmp72_;
			gchar* _tmp78_ = NULL;
			gint _tmp79_;
			gint _tmp80_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp69_ = device;
			_tmp70_ = device_get_device_by_name (_tmp69_);
			dev = _tmp70_;
			_tmp72_ = dev;
			if (_tmp72_ == NULL) {
				const gchar* _tmp73_;
				gchar* _tmp74_;
				_tmp73_ = device;
				_tmp74_ = g_strdup (_tmp73_);
				_g_free0 (_tmp71_);
				_tmp71_ = _tmp74_;
			} else {
				Device* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp75_ = dev;
				_tmp76_ = device_get_device_name_with_parent (_tmp75_);
				_tmp77_ = _tmp76_;
				_g_free0 (_tmp71_);
				_tmp71_ = _tmp77_;
			}
			_tmp79_ = strlen (mount_options);
			_tmp80_ = _tmp79_;
			if (_tmp80_ > 0) {
				gchar* _tmp81_;
				_tmp81_ = g_strdup_printf (" (%s)", mount_options);
				_g_free0 (_tmp78_);
				_tmp78_ = _tmp81_;
			} else {
				gchar* _tmp82_;
				_tmp82_ = g_strdup ("");
				_g_free0 (_tmp78_);
				_tmp78_ = _tmp82_;
			}
			_tmp83_ = g_strdup_printf ("Mounted '%s'%s at '%s'", _tmp71_, _tmp78_, mount_point);
			_tmp84_ = _tmp83_;
			tee_jee_logging_log_msg (_tmp84_, FALSE);
			_g_free0 (_tmp84_);
			_g_free0 (_tmp78_);
			_g_free0 (_tmp71_);
			_g_object_unref0 (dev);
		}
		result = TRUE;
		_g_object_unref0 (mps);
		_g_free0 (uuid);
		_g_free0 (device);
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
}

gchar*
device_automount (const gchar* dev_name_or_uuid,
                  const gchar* mount_options,
                  const gchar* mount_prefix)
{
	gchar* device = NULL;
	gchar* _tmp0_;
	gchar* uuid = NULL;
	gchar* _tmp1_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp9_;
	Device* dev = NULL;
	GeeArrayList* _tmp10_;
	const gchar* _tmp11_;
	Device* _tmp12_;
	Device* _tmp13_;
	gchar* mount_point = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (dev_name_or_uuid != NULL, NULL);
	g_return_val_if_fail (mount_options != NULL, NULL);
	g_return_val_if_fail (mount_prefix != NULL, NULL);
	_tmp0_ = g_strdup ("");
	device = _tmp0_;
	_tmp1_ = g_strdup ("");
	uuid = _tmp1_;
	if (g_str_has_prefix (dev_name_or_uuid, "/dev")) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup (dev_name_or_uuid);
		_g_free0 (device);
		device = _tmp2_;
		_tmp3_ = device_get_device_uuid (dev_name_or_uuid);
		_g_free0 (uuid);
		uuid = _tmp3_;
	} else {
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = g_strdup (dev_name_or_uuid);
		_g_free0 (uuid);
		uuid = _tmp4_;
		_tmp5_ = uuid;
		_tmp6_ = g_strdup_printf ("/dev/disk/by-uuid/%s", _tmp5_);
		_g_free0 (device);
		device = _tmp6_;
		_tmp7_ = device;
		_tmp8_ = device_resolve_device_name (_tmp7_);
		_g_free0 (device);
		device = _tmp8_;
	}
	_tmp9_ = device_get_block_devices_using_lsblk ("");
	list = _tmp9_;
	_tmp10_ = list;
	_tmp11_ = uuid;
	_tmp12_ = device_find_device_in_list (_tmp10_, _tmp11_);
	dev = _tmp12_;
	_tmp13_ = dev;
	if (_tmp13_ != NULL) {
		Device* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_;
		MountEntry* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp14_ = dev;
		_tmp15_ = _tmp14_->mount_points;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
		_tmp17_ = (MountEntry*) _tmp16_;
		_tmp18_ = _tmp17_->mount_point;
		_tmp19_ = g_strdup (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp17_);
		result = _tmp20_;
		_g_object_unref0 (dev);
		_g_object_unref0 (list);
		_g_free0 (uuid);
		_g_free0 (device);
		return result;
	}
	_tmp21_ = uuid;
	_tmp22_ = g_strdup_printf ("%s/%s", mount_prefix, _tmp21_);
	mount_point = _tmp22_;
	{
		GFile* file = NULL;
		const gchar* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_;
		_tmp23_ = mount_point;
		_tmp24_ = g_file_new_for_path (_tmp23_);
		file = _tmp24_;
		_tmp25_ = file;
		if (!g_file_query_exists (_tmp25_, NULL)) {
			GFile* _tmp26_;
			_tmp26_ = file;
			g_file_make_directory_with_parents (_tmp26_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		tee_jee_logging_log_error (_tmp28_, FALSE, FALSE);
		_tmp29_ = g_strdup ("");
		result = _tmp29_;
		_g_error_free0 (e);
		_g_free0 (mount_point);
		_g_object_unref0 (dev);
		_g_object_unref0 (list);
		_g_free0 (uuid);
		_g_free0 (device);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (mount_point);
		_g_object_unref0 (dev);
		_g_object_unref0 (list);
		_g_free0 (uuid);
		_g_free0 (device);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp30_ = uuid;
	_tmp31_ = mount_point;
	if (device_mount (_tmp30_, _tmp31_, mount_options, FALSE)) {
		result = mount_point;
		_g_object_unref0 (dev);
		_g_object_unref0 (list);
		_g_free0 (uuid);
		_g_free0 (device);
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		_g_free0 (mount_point);
		_g_object_unref0 (dev);
		_g_object_unref0 (list);
		_g_free0 (uuid);
		_g_free0 (device);
		return result;
	}
}

gboolean
device_unmount (const gchar* mount_point)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint ret_val = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (mount_point != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	cmd = _tmp0_;
	if (!device_mount_point_in_use (mount_point)) {
		result = TRUE;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
	{
		gchar* cmd_unmount = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_;
		_tmp1_ = g_strdup_printf ("cat /proc/mounts | awk '{print $2}' | grep '%s' | sort -r | xargs umou" \
"nt", mount_point);
		cmd_unmount = _tmp1_;
		_tmp2_ = g_strdup_printf (": '%s'", mount_point);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_ ("Unmounting from"), _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		tee_jee_logging_log_debug (_tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_tmp6_ = g_strdup ("sync");
		_g_free0 (cmd);
		cmd = _tmp6_;
		_tmp7_ = cmd;
		g_spawn_command_line_sync (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_inner_error0_);
		_g_free0 (std_out);
		std_out = _tmp8_;
		_g_free0 (std_err);
		std_err = _tmp9_;
		ret_val = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (cmd_unmount);
			goto __catch0_g_error;
		}
		_tmp11_ = cmd_unmount;
		_tmp14_ = tee_jee_process_helper_exec_script_sync (_tmp11_, &_tmp12_, &_tmp13_, FALSE, FALSE, TRUE, FALSE);
		_g_free0 (std_out);
		std_out = _tmp12_;
		_g_free0 (std_err);
		std_err = _tmp13_;
		ret_val = _tmp14_;
		if (ret_val != 0) {
			const gchar* _tmp15_;
			tee_jee_logging_log_error (_ ("Failed to unmount"), FALSE, FALSE);
			_tmp15_ = std_err;
			tee_jee_logging_log_error (_tmp15_, FALSE, FALSE);
		}
		_g_free0 (cmd_unmount);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		tee_jee_logging_log_error (_tmp17_, FALSE, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	if (!device_mount_point_in_use (mount_point)) {
		result = TRUE;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	} else {
		result = FALSE;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
}

gchar*
device_description (Device* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = device_description_formatted (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "<b>", "");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "</b>", "");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
device_description_formatted (Device* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	_tmp1_ = self->type;
	if (g_strcmp0 (_tmp1_, "disk") == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		const gchar* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp2_ = s;
		_tmp3_ = self->kname;
		_tmp4_ = g_strconcat ("<b>", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "</b> ~", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp2_, _tmp7_, NULL);
		_g_free0 (s);
		s = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp9_ = self->vendor;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ > 0) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = s;
			_tmp13_ = self->vendor;
			_tmp14_ = g_strconcat (" ", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
			_g_free0 (s);
			s = _tmp16_;
			_g_free0 (_tmp15_);
		}
		_tmp17_ = self->model;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ > 0) {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp20_ = s;
			_tmp21_ = self->model;
			_tmp22_ = g_strconcat (" ", _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat (_tmp20_, _tmp23_, NULL);
			_g_free0 (s);
			s = _tmp24_;
			_g_free0 (_tmp23_);
		}
		if (self->size_bytes > ((guint64) 0)) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp25_ = s;
			_tmp26_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 0);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strdup_printf (" (%s)", _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
			_g_free0 (s);
			s = _tmp30_;
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
		}
	} else {
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_ = NULL;
		const gchar* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp31_ = s;
		_tmp32_ = device_get_short_name_with_parent (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat ("<b>", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, "</b>", NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp31_, _tmp38_, NULL);
		_g_free0 (s);
		s = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		_tmp41_ = self->label;
		_tmp42_ = strlen (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_ > 0) {
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp44_ = self->label;
			_tmp45_ = g_strconcat (" (", _tmp44_, NULL);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp46_, ")", NULL);
			_g_free0 (_tmp40_);
			_tmp40_ = _tmp47_;
			_g_free0 (_tmp46_);
		} else {
			gchar* _tmp48_;
			_tmp48_ = g_strdup ("");
			_g_free0 (_tmp40_);
			_tmp40_ = _tmp48_;
		}
		_tmp49_ = s;
		_tmp50_ = g_strconcat (_tmp49_, _tmp40_, NULL);
		_g_free0 (s);
		s = _tmp50_;
		_tmp52_ = self->fstype;
		_tmp53_ = strlen (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ > 0) {
			const gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp55_ = self->fstype;
			_tmp56_ = g_strconcat (" ~ ", _tmp55_, NULL);
			_g_free0 (_tmp51_);
			_tmp51_ = _tmp56_;
		} else {
			gchar* _tmp57_;
			_tmp57_ = g_strdup ("");
			_g_free0 (_tmp51_);
			_tmp51_ = _tmp57_;
		}
		_tmp58_ = s;
		_tmp59_ = g_strconcat (_tmp58_, _tmp51_, NULL);
		_g_free0 (s);
		s = _tmp59_;
		if (self->size_bytes > ((guint64) 0)) {
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp60_ = s;
			_tmp61_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 0);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strdup_printf (" (%s)", _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strconcat (_tmp60_, _tmp64_, NULL);
			_g_free0 (s);
			s = _tmp65_;
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
		}
		_g_free0 (_tmp51_);
		_g_free0 (_tmp40_);
	}
	_tmp66_ = s;
	_tmp67_ = string_strip (_tmp66_);
	result = _tmp67_;
	_g_free0 (s);
	return result;
}

gchar*
device_description_simple (Device* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = device_description_simple_formatted (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "<b>", "");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "</b>", "");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
device_description_simple_formatted (Device* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	_tmp1_ = self->type;
	if (g_strcmp0 (_tmp1_, "disk") == 0) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp2_ = self->vendor;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ > 0) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = s;
			_tmp6_ = self->vendor;
			_tmp7_ = g_strconcat (" ", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
			_g_free0 (s);
			s = _tmp9_;
			_g_free0 (_tmp8_);
		}
		_tmp10_ = self->model;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = s;
			_tmp14_ = self->model;
			_tmp15_ = g_strconcat (" ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
			_g_free0 (s);
			s = _tmp17_;
			_g_free0 (_tmp16_);
		}
		if (self->size_bytes > ((guint64) 0)) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gboolean _tmp23_;
			_tmp18_ = s;
			_tmp19_ = string_strip (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = strlen (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_ == 0;
			_g_free0 (_tmp20_);
			if (_tmp23_) {
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp24_ = s;
				_tmp25_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 0);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strdup_printf ("%s Device", _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
				_g_free0 (s);
				s = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			} else {
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp30_ = s;
				_tmp31_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 0);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strdup_printf (" (%s)", _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strconcat (_tmp30_, _tmp34_, NULL);
				_g_free0 (s);
				s = _tmp35_;
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
			}
		}
	} else {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		const gchar* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_ = NULL;
		const gchar* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp36_ = s;
		_tmp37_ = device_get_short_name_with_parent (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat ("<b>", _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat (_tmp41_, "</b>", NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp36_, _tmp43_, NULL);
		_g_free0 (s);
		s = _tmp44_;
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_tmp46_ = self->label;
		_tmp47_ = strlen (_tmp46_);
		_tmp48_ = _tmp47_;
		if (_tmp48_ > 0) {
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp49_ = self->label;
			_tmp50_ = g_strconcat (" (", _tmp49_, NULL);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strconcat (_tmp51_, ")", NULL);
			_g_free0 (_tmp45_);
			_tmp45_ = _tmp52_;
			_g_free0 (_tmp51_);
		} else {
			gchar* _tmp53_;
			_tmp53_ = g_strdup ("");
			_g_free0 (_tmp45_);
			_tmp45_ = _tmp53_;
		}
		_tmp54_ = s;
		_tmp55_ = g_strconcat (_tmp54_, _tmp45_, NULL);
		_g_free0 (s);
		s = _tmp55_;
		_tmp57_ = self->fstype;
		_tmp58_ = strlen (_tmp57_);
		_tmp59_ = _tmp58_;
		if (_tmp59_ > 0) {
			const gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp60_ = self->fstype;
			_tmp61_ = g_strconcat (" ~ ", _tmp60_, NULL);
			_g_free0 (_tmp56_);
			_tmp56_ = _tmp61_;
		} else {
			gchar* _tmp62_;
			_tmp62_ = g_strdup ("");
			_g_free0 (_tmp56_);
			_tmp56_ = _tmp62_;
		}
		_tmp63_ = s;
		_tmp64_ = g_strconcat (_tmp63_, _tmp56_, NULL);
		_g_free0 (s);
		s = _tmp64_;
		if (self->size_bytes > ((guint64) 0)) {
			const gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp65_ = s;
			_tmp66_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 0);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strdup_printf (" (%s)", _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat (_tmp65_, _tmp69_, NULL);
			_g_free0 (s);
			s = _tmp70_;
			_g_free0 (_tmp69_);
			_g_free0 (_tmp67_);
		}
		_g_free0 (_tmp56_);
		_g_free0 (_tmp45_);
	}
	_tmp71_ = s;
	_tmp72_ = string_strip (_tmp71_);
	result = _tmp72_;
	_g_free0 (s);
	return result;
}

gchar*
device_description_full_free (Device* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	_tmp1_ = self->type;
	if (g_strcmp0 (_tmp1_, "disk") == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp2_ = s;
		_tmp3_ = self->model;
		_tmp4_ = self->vendor;
		_tmp5_ = g_strdup_printf ("%s %s", _tmp3_, _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_strip (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp2_, _tmp8_, NULL);
		_g_free0 (s);
		s = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp10_ = s;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == 0) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp13_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf ("%s Disk", _tmp14_);
			_g_free0 (s);
			s = _tmp15_;
			_g_free0 (_tmp14_);
		} else {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp16_ = s;
			_tmp17_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 1);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf (" (%s Disk)", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp16_, _tmp20_, NULL);
			_g_free0 (s);
			s = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
		}
	} else {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		guint64 _tmp41_;
		guint64 _tmp42_;
		_tmp22_ = s;
		_tmp23_ = self->kname;
		_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
		_g_free0 (s);
		s = _tmp24_;
		_tmp25_ = self->label;
		_tmp26_ = strlen (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ > 0) {
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp28_ = s;
			_tmp29_ = self->label;
			_tmp30_ = g_strdup_printf (" (%s)", _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_tmp28_, _tmp31_, NULL);
			_g_free0 (s);
			s = _tmp32_;
			_g_free0 (_tmp31_);
		}
		_tmp33_ = self->fstype;
		_tmp34_ = strlen (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ > 0) {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp36_ = s;
			_tmp37_ = self->fstype;
			_tmp38_ = g_strdup_printf (" ~ %s", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
			_g_free0 (s);
			s = _tmp40_;
			_g_free0 (_tmp39_);
		}
		_tmp41_ = device_get_free_bytes (self);
		_tmp42_ = _tmp41_;
		if (_tmp42_ > ((guint64) 0)) {
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp43_ = s;
			_tmp44_ = device_description_free (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup_printf (" ~ %s", _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strconcat (_tmp43_, _tmp47_, NULL);
			_g_free0 (s);
			s = _tmp48_;
			_g_free0 (_tmp47_);
			_g_free0 (_tmp45_);
		}
	}
	result = s;
	return result;
}

gchar*
device_description_full (Device* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gboolean _tmp39_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = self->device;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_g_free0 (s);
	s = _tmp3_;
	_tmp5_ = self->label;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = self->label;
		_tmp9_ = g_strconcat (" (", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, ")", NULL);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp11_;
		_g_free0 (_tmp10_);
	} else {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp12_;
	}
	_tmp13_ = s;
	_tmp14_ = g_strconcat (_tmp13_, _tmp4_, NULL);
	_g_free0 (s);
	s = _tmp14_;
	_tmp16_ = self->uuid;
	_tmp17_ = strlen (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ > 0) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = self->uuid;
		_tmp20_ = g_strconcat (" ~ ", _tmp19_, NULL);
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp20_;
	} else {
		gchar* _tmp21_;
		_tmp21_ = g_strdup ("");
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp21_;
	}
	_tmp22_ = s;
	_tmp23_ = g_strconcat (_tmp22_, _tmp15_, NULL);
	_g_free0 (s);
	s = _tmp23_;
	_tmp25_ = self->fstype;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ > 0) {
		const gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp28_ = self->fstype;
		_tmp29_ = g_strconcat (" ~ ", _tmp28_, NULL);
		_g_free0 (_tmp24_);
		_tmp24_ = _tmp29_;
	} else {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("");
		_g_free0 (_tmp24_);
		_tmp24_ = _tmp30_;
	}
	_tmp31_ = s;
	_tmp32_ = g_strconcat (_tmp31_, _tmp24_, NULL);
	_g_free0 (s);
	s = _tmp32_;
	_tmp34_ = device_get_used (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _tmp38_ > 0;
	_g_free0 (_tmp36_);
	if (_tmp39_) {
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp40_ = device_get_used (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (" ~ ", _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp44_, " / ", NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = device_get_size (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat (_tmp51_, " GB used (", NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = self->used_percent;
		_tmp55_ = g_strconcat (_tmp53_, _tmp54_, NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp56_, ")", NULL);
		_g_free0 (_tmp33_);
		_tmp33_ = _tmp57_;
		_g_free0 (_tmp56_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
	} else {
		gchar* _tmp58_;
		_tmp58_ = g_strdup ("");
		_g_free0 (_tmp33_);
		_tmp33_ = _tmp58_;
	}
	_tmp59_ = s;
	_tmp60_ = g_strconcat (_tmp59_, _tmp33_, NULL);
	_g_free0 (s);
	s = _tmp60_;
	result = s;
	_g_free0 (_tmp33_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp4_);
	return result;
}

gchar*
device_description_usage (Device* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = device_get_used (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ > 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp6_ = device_get_used (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, " / ", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = device_get_size (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, " used (", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->used_percent;
		_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ")", NULL);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		result = _tmp22_;
		return result;
	} else {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("");
		result = _tmp23_;
		return result;
	}
}

gchar*
device_description_free (Device* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = device_get_used (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ > 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		guint64 _tmp6_;
		guint64 _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp6_ = device_get_free_bytes (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = tee_jee_file_system_format_file_size (_tmp7_, FALSE, "g", FALSE, 1);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, " / ", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "g", TRUE, 1);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, " free", NULL);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		result = _tmp17_;
		return result;
	} else {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("");
		result = _tmp18_;
		return result;
	}
}

gchar*
device_tooltip_text (Device* self)
{
	gchar* tt = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	tt = _tmp0_;
	_tmp1_ = self->type;
	if (g_strcmp0 (_tmp1_, "disk") == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp2_ = tt;
		_tmp3_ = self->device;
		_tmp4_ = g_strdup_printf ("%-15s: %s\n", _ ("Device"), _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
		_g_free0 (tt);
		tt = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp7_ = tt;
		_tmp8_ = self->vendor;
		_tmp9_ = g_strdup_printf ("%-15s: %s\n", _ ("Vendor"), _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
		_g_free0 (tt);
		tt = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp12_ = tt;
		_tmp13_ = self->model;
		_tmp14_ = g_strdup_printf ("%-15s: %s\n", _ ("Model"), _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
		_g_free0 (tt);
		tt = _tmp16_;
		_g_free0 (_tmp15_);
		_tmp17_ = tt;
		_tmp18_ = self->serial;
		_tmp19_ = g_strdup_printf ("%-15s: %s\n", _ ("Serial"), _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
		_g_free0 (tt);
		tt = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp22_ = tt;
		_tmp23_ = self->revision;
		_tmp24_ = g_strdup_printf ("%-15s: %s\n", _ ("Revision"), _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp22_, _tmp25_, NULL);
		_g_free0 (tt);
		tt = _tmp26_;
		_g_free0 (_tmp25_);
		if (self->size_bytes > ((guint64) 0)) {
			gchar* _tmp28_;
			_tmp28_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 1);
			_g_free0 (_tmp27_);
			_tmp27_ = _tmp28_;
		} else {
			gchar* _tmp29_;
			_tmp29_ = g_strdup ("N/A");
			_g_free0 (_tmp27_);
			_tmp27_ = _tmp29_;
		}
		_tmp30_ = tt;
		_tmp31_ = g_strdup_printf ("%-15s: %s\n", _ ("Size"), _tmp27_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
		_g_free0 (tt);
		tt = _tmp33_;
		_g_free0 (_tmp32_);
		_g_free0 (_tmp27_);
	} else {
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_ = NULL;
		const gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_ = NULL;
		const gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		const gchar* _tmp87_;
		const gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		_tmp35_ = self->mapped_name;
		_tmp36_ = strlen (_tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp37_ > 0) {
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp38_ = self->device;
			_tmp39_ = self->mapped_name;
			_tmp40_ = g_strdup_printf ("%s → %s", _tmp38_, _tmp39_);
			_g_free0 (_tmp34_);
			_tmp34_ = _tmp40_;
		} else {
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp41_ = self->device;
			_tmp42_ = g_strdup (_tmp41_);
			_g_free0 (_tmp34_);
			_tmp34_ = _tmp42_;
		}
		_tmp43_ = tt;
		_tmp44_ = g_strdup_printf ("%-15s: %s\n", _ ("Device"), _tmp34_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp43_, _tmp45_, NULL);
		_g_free0 (tt);
		tt = _tmp46_;
		_g_free0 (_tmp45_);
		if (device_has_parent (self)) {
			const gchar* _tmp47_;
			Device* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp47_ = tt;
			_tmp48_ = self->parent;
			_tmp49_ = _tmp48_->device;
			_tmp50_ = g_strdup_printf ("%-15s: %s\n", _ ("Parent Device"), _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strconcat (_tmp47_, _tmp51_, NULL);
			_g_free0 (tt);
			tt = _tmp52_;
			_g_free0 (_tmp51_);
		}
		_tmp53_ = tt;
		_tmp54_ = self->uuid;
		_tmp55_ = g_strdup_printf ("%-15s: %s\n", _ ("UUID"), _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp53_, _tmp56_, NULL);
		_g_free0 (tt);
		tt = _tmp57_;
		_g_free0 (_tmp56_);
		_tmp58_ = tt;
		_tmp59_ = self->type;
		_tmp60_ = g_strdup_printf ("%-15s: %s\n", _ ("Type"), _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat (_tmp58_, _tmp61_, NULL);
		_g_free0 (tt);
		tt = _tmp62_;
		_g_free0 (_tmp61_);
		_tmp63_ = tt;
		_tmp64_ = self->fstype;
		_tmp65_ = g_strdup_printf ("%-15s: %s\n", _ ("Filesystem"), _tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp63_, _tmp66_, NULL);
		_g_free0 (tt);
		tt = _tmp67_;
		_g_free0 (_tmp66_);
		_tmp68_ = tt;
		_tmp69_ = self->label;
		_tmp70_ = g_strdup_printf ("%-15s: %s\n", _ ("Label"), _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strconcat (_tmp68_, _tmp71_, NULL);
		_g_free0 (tt);
		tt = _tmp72_;
		_g_free0 (_tmp71_);
		if (self->size_bytes > ((guint64) 0)) {
			gchar* _tmp74_;
			_tmp74_ = tee_jee_file_system_format_file_size (self->size_bytes, FALSE, "", TRUE, 1);
			_g_free0 (_tmp73_);
			_tmp73_ = _tmp74_;
		} else {
			gchar* _tmp75_;
			_tmp75_ = g_strdup ("N/A");
			_g_free0 (_tmp73_);
			_tmp73_ = _tmp75_;
		}
		_tmp76_ = tt;
		_tmp77_ = g_strdup_printf ("%-15s: %s\n", _ ("Size"), _tmp73_);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strconcat (_tmp76_, _tmp78_, NULL);
		_g_free0 (tt);
		tt = _tmp79_;
		_g_free0 (_tmp78_);
		if (self->used_bytes > ((guint64) 0)) {
			gchar* _tmp81_;
			_tmp81_ = tee_jee_file_system_format_file_size (self->used_bytes, FALSE, "", TRUE, 1);
			_g_free0 (_tmp80_);
			_tmp80_ = _tmp81_;
		} else {
			gchar* _tmp82_;
			_tmp82_ = g_strdup ("N/A");
			_g_free0 (_tmp80_);
			_tmp80_ = _tmp82_;
		}
		_tmp83_ = tt;
		_tmp84_ = g_strdup_printf ("%-15s: %s\n", _ ("Used"), _tmp80_);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strconcat (_tmp83_, _tmp85_, NULL);
		_g_free0 (tt);
		tt = _tmp86_;
		_g_free0 (_tmp85_);
		_tmp87_ = tt;
		_tmp88_ = self->dist_info;
		_tmp89_ = g_strdup_printf ("%-15s: %s\n", _ ("System"), _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = g_strconcat (_tmp87_, _tmp90_, NULL);
		_g_free0 (tt);
		tt = _tmp91_;
		_g_free0 (_tmp90_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp34_);
	}
	_tmp92_ = tt;
	_tmp93_ = g_strdup_printf ("<tt>%s</tt>", _tmp92_);
	result = _tmp93_;
	_g_free0 (tt);
	return result;
}

void
device_test_all (void)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	_tmp0_ = device_get_block_devices_using_lsblk ("");
	list = _tmp0_;
	tee_jee_logging_log_msg ("\n> get_block_devices_using_lsblk()", FALSE);
	_tmp1_ = list;
	device_print_device_list (_tmp1_);
	tee_jee_logging_log_msg ("", FALSE);
	_tmp2_ = device_get_mounted_filesystems_using_mtab ();
	_g_object_unref0 (list);
	list = _tmp2_;
	tee_jee_logging_log_msg ("\n> get_mounted_filesystems_using_mtab()", FALSE);
	_tmp3_ = list;
	device_print_device_mounts (_tmp3_);
	tee_jee_logging_log_msg ("", FALSE);
	_tmp4_ = device_get_disk_space_using_df ("");
	_g_object_unref0 (list);
	list = _tmp4_;
	tee_jee_logging_log_msg ("\n> get_disk_space_using_df()", FALSE);
	_tmp5_ = list;
	device_print_device_disk_space (_tmp5_);
	tee_jee_logging_log_msg ("", FALSE);
	_tmp6_ = device_get_filesystems (TRUE, TRUE);
	_g_object_unref0 (list);
	list = _tmp6_;
	tee_jee_logging_log_msg ("\n> get_filesystems()", FALSE);
	_tmp7_ = list;
	device_print_device_list (_tmp7_);
	_tmp8_ = list;
	device_print_device_mounts (_tmp8_);
	_tmp9_ = list;
	device_print_device_disk_space (_tmp9_);
	tee_jee_logging_log_msg ("", FALSE);
	_g_object_unref0 (list);
}

void
device_print_device_list (GeeArrayList* list)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (list != NULL);
	tee_jee_logging_log_debug ("");
	_tmp0_ = g_strdup_printf ("%-12s ,%-5s ,%-5s ,%-36s ,%s", "device", "pkname", "kname", "uuid", "mapped_name");
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strnfill ((gsize) 100, '-');
	_tmp3_ = _tmp2_;
	tee_jee_logging_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	{
		GeeArrayList* _dev_list = NULL;
		gint _dev_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _dev_index = 0;
		_dev_list = list;
		_tmp4_ = _dev_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_dev_size = _tmp6_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Device* dev = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			Device* _tmp11_;
			const gchar* _tmp12_;
			Device* _tmp13_;
			const gchar* _tmp14_;
			Device* _tmp15_;
			const gchar* _tmp16_;
			Device* _tmp17_;
			const gchar* _tmp18_;
			Device* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_dev_index = _dev_index + 1;
			_tmp7_ = _dev_index;
			_tmp8_ = _dev_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _dev_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _dev_index);
			dev = (Device*) _tmp10_;
			_tmp11_ = dev;
			_tmp12_ = _tmp11_->device;
			_tmp13_ = dev;
			_tmp14_ = _tmp13_->pkname;
			_tmp15_ = dev;
			_tmp16_ = _tmp15_->kname;
			_tmp17_ = dev;
			_tmp18_ = _tmp17_->uuid;
			_tmp19_ = dev;
			_tmp20_ = _tmp19_->mapped_name;
			_tmp21_ = g_strdup_printf ("%-12s ,%-5s ,%-5s ,%-36s ,%s", _tmp12_, _tmp14_, _tmp16_, _tmp18_, _tmp20_);
			_tmp22_ = _tmp21_;
			tee_jee_logging_log_debug (_tmp22_);
			_g_free0 (_tmp22_);
			_g_object_unref0 (dev);
		}
	}
	tee_jee_logging_log_debug ("");
}

void
device_print_device_mounts (GeeArrayList* list)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (list != NULL);
	tee_jee_logging_log_debug ("");
	_tmp0_ = g_strdup_printf ("%-15s %s", "device", "> mount_points (mount_options)");
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strnfill ((gsize) 100, '-');
	_tmp3_ = _tmp2_;
	tee_jee_logging_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	{
		GeeArrayList* _dev_list = NULL;
		gint _dev_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _dev_index = 0;
		_dev_list = list;
		_tmp4_ = _dev_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_dev_size = _tmp6_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Device* dev = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gchar* mps = NULL;
			gchar* _tmp11_;
			Device* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_dev_index = _dev_index + 1;
			_tmp7_ = _dev_index;
			_tmp8_ = _dev_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _dev_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _dev_index);
			dev = (Device*) _tmp10_;
			_tmp11_ = g_strdup ("");
			mps = _tmp11_;
			{
				GeeArrayList* _mp_list = NULL;
				Device* _tmp12_;
				GeeArrayList* _tmp13_;
				gint _mp_size = 0;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _mp_index = 0;
				_tmp12_ = dev;
				_tmp13_ = _tmp12_->mount_points;
				_mp_list = _tmp13_;
				_tmp14_ = _mp_list;
				_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_mp_size = _tmp16_;
				_mp_index = -1;
				while (TRUE) {
					gint _tmp17_;
					gint _tmp18_;
					MountEntry* mp = NULL;
					GeeArrayList* _tmp19_;
					gpointer _tmp20_;
					const gchar* _tmp21_;
					MountEntry* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					MountEntry* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					_mp_index = _mp_index + 1;
					_tmp17_ = _mp_index;
					_tmp18_ = _mp_size;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = _mp_list;
					_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _mp_index);
					mp = (MountEntry*) _tmp20_;
					_tmp21_ = mps;
					_tmp22_ = mp;
					_tmp23_ = _tmp22_->mount_point;
					_tmp24_ = g_strdup_printf ("\n    %s -> ", _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_strconcat (_tmp21_, _tmp25_, NULL);
					_g_free0 (mps);
					mps = _tmp26_;
					_g_free0 (_tmp25_);
					_tmp27_ = mp;
					_tmp28_ = _tmp27_->mount_options;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					if (_tmp30_ > 0) {
						const gchar* _tmp31_;
						MountEntry* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						_tmp31_ = mps;
						_tmp32_ = mp;
						_tmp33_ = _tmp32_->mount_options;
						_tmp34_ = g_strdup_printf (" %s", _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strconcat (_tmp31_, _tmp35_, NULL);
						_g_free0 (mps);
						mps = _tmp36_;
						_g_free0 (_tmp35_);
					}
					_g_object_unref0 (mp);
				}
			}
			_tmp37_ = dev;
			_tmp38_ = _tmp37_->device;
			_tmp39_ = mps;
			_tmp40_ = g_strdup_printf ("%-15s %s", _tmp38_, _tmp39_);
			_tmp41_ = _tmp40_;
			tee_jee_logging_log_debug (_tmp41_);
			_g_free0 (_tmp41_);
			_g_free0 (mps);
			_g_object_unref0 (dev);
		}
	}
	tee_jee_logging_log_debug ("");
}

void
device_print_device_disk_space (GeeArrayList* list)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (list != NULL);
	tee_jee_logging_log_debug ("");
	_tmp0_ = g_strdup_printf ("%-15s %-12s %15s %15s %15s %10s", "device", "fstype", "size", "used", "available", "used_percent");
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strnfill ((gsize) 100, '-');
	_tmp3_ = _tmp2_;
	tee_jee_logging_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	{
		GeeArrayList* _dev_list = NULL;
		gint _dev_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _dev_index = 0;
		_dev_list = list;
		_tmp4_ = _dev_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_dev_size = _tmp6_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Device* dev = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			Device* _tmp11_;
			const gchar* _tmp12_;
			Device* _tmp13_;
			const gchar* _tmp14_;
			Device* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			Device* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			Device* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			Device* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_dev_index = _dev_index + 1;
			_tmp7_ = _dev_index;
			_tmp8_ = _dev_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _dev_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _dev_index);
			dev = (Device*) _tmp10_;
			_tmp11_ = dev;
			_tmp12_ = _tmp11_->device;
			_tmp13_ = dev;
			_tmp14_ = _tmp13_->fstype;
			_tmp15_ = dev;
			_tmp16_ = tee_jee_file_system_format_file_size (_tmp15_->size_bytes, TRUE, "", TRUE, 1);
			_tmp17_ = _tmp16_;
			_tmp18_ = dev;
			_tmp19_ = tee_jee_file_system_format_file_size (_tmp18_->used_bytes, TRUE, "", TRUE, 1);
			_tmp20_ = _tmp19_;
			_tmp21_ = dev;
			_tmp22_ = tee_jee_file_system_format_file_size (_tmp21_->available_bytes, TRUE, "", TRUE, 1);
			_tmp23_ = _tmp22_;
			_tmp24_ = dev;
			_tmp25_ = _tmp24_->used_percent;
			_tmp26_ = g_strdup_printf ("%-15s %-12s %15s %15s %15s %10s", _tmp12_, _tmp14_, _tmp17_, _tmp20_, _tmp23_, _tmp25_);
			_tmp27_ = _tmp26_;
			tee_jee_logging_log_debug (_tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp17_);
			_g_object_unref0 (dev);
		}
	}
	tee_jee_logging_log_debug ("");
}

guint64
device_get_free_bytes (Device* self)
{
	guint64 result;
	guint64 _tmp0_ = 0ULL;
	g_return_val_if_fail (self != NULL, 0ULL);
	if (self->used_bytes == ((guint64) 0)) {
		_tmp0_ = (guint64) 0;
	} else {
		_tmp0_ = self->available_bytes;
	}
	result = _tmp0_;
	return result;
}

gchar*
device_get_size (Device* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (((gdouble) self->size_bytes) < device_GB) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("%.1f MB", self->size_bytes / device_MB);
		result = _tmp0_;
		return result;
	} else {
		if (self->size_bytes > ((guint64) 0)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf ("%.1f GB", self->size_bytes / device_GB);
			result = _tmp1_;
			return result;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("");
			result = _tmp2_;
			return result;
		}
	}
}

gchar*
device_get_used (Device* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->used_bytes == ((guint64) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf ("%.1f GB", self->used_bytes / device_GB);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

gchar*
device_get_free (Device* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	guint64 _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = device_get_free_bytes (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint64) 0)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		guint64 _tmp4_;
		guint64 _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = device_get_free_bytes (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%.1f GB", _tmp5_ / device_GB);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

gboolean
device_get_is_mounted (Device* self)
{
	gboolean result;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->mount_points;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

gchar*
device_get_full_name_with_alias (Device* self)
{
	gchar* result;
	gchar* text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->device;
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	_tmp2_ = self->mapped_name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = text;
		_tmp6_ = self->mapped_name;
		_tmp7_ = g_strdup_printf (" (%s)", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
		_g_free0 (text);
		text = _tmp9_;
		_g_free0 (_tmp8_);
	}
	result = text;
	return result;
}

gchar*
device_get_full_name_with_parent (Device* self)
{
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = device_get_device_name_with_parent (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

gchar*
device_get_short_name_with_alias (Device* self)
{
	gchar* result;
	gchar* text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->kname;
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	_tmp2_ = self->mapped_name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = text;
		_tmp6_ = self->mapped_name;
		_tmp7_ = g_strdup_printf (" (%s)", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
		_g_free0 (text);
		text = _tmp9_;
		_g_free0 (_tmp8_);
	}
	result = text;
	return result;
}

gchar*
device_get_short_name_with_parent (Device* self)
{
	gchar* result;
	gchar* text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->kname;
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	if (device_has_parent (self)) {
		Device* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->parent;
		_tmp4_ = _tmp3_->type;
		_tmp2_ = g_strcmp0 (_tmp4_, "part") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = text;
		_tmp6_ = self->pkname;
		_tmp7_ = g_strdup_printf (" (%s)", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
		_g_free0 (text);
		text = _tmp9_;
		_g_free0 (_tmp8_);
	}
	result = text;
	return result;
}

gchar*
device_get_device_name_with_parent (Device* self)
{
	gchar* result;
	gchar* text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->device;
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	if (device_has_parent (self)) {
		Device* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->parent;
		_tmp4_ = _tmp3_->type;
		_tmp2_ = g_strcmp0 (_tmp4_, "part") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		Device* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = text;
		_tmp6_ = self->parent;
		_tmp7_ = _tmp6_->kname;
		_tmp8_ = g_strdup_printf (" (%s)", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
		_g_free0 (text);
		text = _tmp10_;
		_g_free0 (_tmp9_);
	}
	result = text;
	return result;
}

static void
device_class_init (DeviceClass * klass,
                   gpointer klass_data)
{
	gchar* _tmp0_;
	device_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_device_get_property;
	G_OBJECT_CLASS (klass)->finalize = device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_FREE_BYTES_PROPERTY, device_properties[DEVICE_FREE_BYTES_PROPERTY] = g_param_spec_uint64 ("free-bytes", "free-bytes", "free-bytes", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_SIZE_PROPERTY, device_properties[DEVICE_SIZE_PROPERTY] = g_param_spec_string ("size", "size", "size", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_USED_PROPERTY, device_properties[DEVICE_USED_PROPERTY] = g_param_spec_string ("used", "used", "used", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_FREE_PROPERTY, device_properties[DEVICE_FREE_PROPERTY] = g_param_spec_string ("free", "free", "free", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_IS_MOUNTED_PROPERTY, device_properties[DEVICE_IS_MOUNTED_PROPERTY] = g_param_spec_boolean ("is-mounted", "is-mounted", "is-mounted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_FULL_NAME_WITH_ALIAS_PROPERTY, device_properties[DEVICE_FULL_NAME_WITH_ALIAS_PROPERTY] = g_param_spec_string ("full-name-with-alias", "full-name-with-alias", "full-name-with-alias", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_FULL_NAME_WITH_PARENT_PROPERTY, device_properties[DEVICE_FULL_NAME_WITH_PARENT_PROPERTY] = g_param_spec_string ("full-name-with-parent", "full-name-with-parent", "full-name-with-parent", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_SHORT_NAME_WITH_ALIAS_PROPERTY, device_properties[DEVICE_SHORT_NAME_WITH_ALIAS_PROPERTY] = g_param_spec_string ("short-name-with-alias", "short-name-with-alias", "short-name-with-alias", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_SHORT_NAME_WITH_PARENT_PROPERTY, device_properties[DEVICE_SHORT_NAME_WITH_PARENT_PROPERTY] = g_param_spec_string ("short-name-with-parent", "short-name-with-parent", "short-name-with-parent", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_DEVICE_NAME_WITH_PARENT_PROPERTY, device_properties[DEVICE_DEVICE_NAME_WITH_PARENT_PROPERTY] = g_param_spec_string ("device-name-with-parent", "device-name-with-parent", "device-name-with-parent", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	device_MB = 1000 * device_KB;
	device_GB = 1000 * device_MB;
	device_MiB = 1024 * device_KiB;
	device_GiB = 1024 * device_MiB;
	_tmp0_ = g_strdup ("");
	device_lsblk_version = _tmp0_;
}

static void
device_instance_init (Device * self,
                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	_tmp0_ = g_strdup ("");
	self->device = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->kname = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->pkname = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->pkname_toplevel = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->mapped_name = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->uuid = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->label = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->partuuid = _tmp8_;
	_tmp9_ = g_strdup ("");
	self->partlabel = _tmp9_;
	self->major = -1;
	self->minor = -1;
	_tmp10_ = g_strdup ("");
	self->device_mapper = _tmp10_;
	_tmp11_ = g_strdup ("");
	self->device_by_uuid = _tmp11_;
	_tmp12_ = g_strdup ("");
	self->device_by_label = _tmp12_;
	_tmp13_ = g_strdup ("");
	self->device_by_partuuid = _tmp13_;
	_tmp14_ = g_strdup ("");
	self->device_by_partlabel = _tmp14_;
	_tmp15_ = g_strdup ("");
	self->type = _tmp15_;
	_tmp16_ = g_strdup ("");
	self->fstype = _tmp16_;
	self->order = -1;
	_tmp17_ = g_strdup ("");
	self->vendor = _tmp17_;
	_tmp18_ = g_strdup ("");
	self->model = _tmp18_;
	_tmp19_ = g_strdup ("");
	self->serial = _tmp19_;
	_tmp20_ = g_strdup ("");
	self->revision = _tmp20_;
	self->removable = FALSE;
	self->read_only = FALSE;
	self->size_bytes = (guint64) 0;
	self->used_bytes = (guint64) 0;
	self->available_bytes = (guint64) 0;
	_tmp21_ = g_strdup ("");
	self->used_percent = _tmp21_;
	_tmp22_ = g_strdup ("");
	self->dist_info = _tmp22_;
	self->parent = NULL;
	self->children = NULL;
}

static void
device_finalize (GObject * obj)
{
	Device * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEVICE, Device);
	_g_free0 (self->device);
	_g_free0 (self->name);
	_g_free0 (self->kname);
	_g_free0 (self->pkname);
	_g_free0 (self->pkname_toplevel);
	_g_free0 (self->mapped_name);
	_g_free0 (self->uuid);
	_g_free0 (self->label);
	_g_free0 (self->partuuid);
	_g_free0 (self->partlabel);
	_g_free0 (self->device_mapper);
	_g_free0 (self->device_by_uuid);
	_g_free0 (self->device_by_label);
	_g_free0 (self->device_by_partuuid);
	_g_free0 (self->device_by_partlabel);
	_g_free0 (self->type);
	_g_free0 (self->fstype);
	_g_free0 (self->vendor);
	_g_free0 (self->model);
	_g_free0 (self->serial);
	_g_free0 (self->revision);
	_g_free0 (self->used_percent);
	_g_free0 (self->dist_info);
	_g_object_unref0 (self->mount_points);
	_g_object_unref0 (self->symlinks);
	_g_object_unref0 (self->parent);
	_g_object_unref0 (self->children);
	G_OBJECT_CLASS (device_parent_class)->finalize (obj);
}

static GType
device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Device), 0, (GInstanceInitFunc) device_instance_init, NULL };
	GType device_type_id;
	device_type_id = g_type_register_static (G_TYPE_OBJECT, "Device", &g_define_type_info, 0);
	return device_type_id;
}

GType
device_get_type (void)
{
	static volatile gsize device_type_id__once = 0;
	if (g_once_init_enter (&device_type_id__once)) {
		GType device_type_id;
		device_type_id = device_get_type_once ();
		g_once_init_leave (&device_type_id__once, device_type_id);
	}
	return device_type_id__once;
}

static void
_vala_device_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Device * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEVICE, Device);
	switch (property_id) {
		case DEVICE_FREE_BYTES_PROPERTY:
		g_value_set_uint64 (value, device_get_free_bytes (self));
		break;
		case DEVICE_SIZE_PROPERTY:
		g_value_take_string (value, device_get_size (self));
		break;
		case DEVICE_USED_PROPERTY:
		g_value_take_string (value, device_get_used (self));
		break;
		case DEVICE_FREE_PROPERTY:
		g_value_take_string (value, device_get_free (self));
		break;
		case DEVICE_IS_MOUNTED_PROPERTY:
		g_value_set_boolean (value, device_get_is_mounted (self));
		break;
		case DEVICE_FULL_NAME_WITH_ALIAS_PROPERTY:
		g_value_take_string (value, device_get_full_name_with_alias (self));
		break;
		case DEVICE_FULL_NAME_WITH_PARENT_PROPERTY:
		g_value_take_string (value, device_get_full_name_with_parent (self));
		break;
		case DEVICE_SHORT_NAME_WITH_ALIAS_PROPERTY:
		g_value_take_string (value, device_get_short_name_with_alias (self));
		break;
		case DEVICE_SHORT_NAME_WITH_PARENT_PROPERTY:
		g_value_take_string (value, device_get_short_name_with_parent (self));
		break;
		case DEVICE_DEVICE_NAME_WITH_PARENT_PROPERTY:
		g_value_take_string (value, device_get_device_name_with_parent (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

