/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// RouteParentStatusApplyConfiguration represents a declarative configuration of the RouteParentStatus type for use
// with apply.
type RouteParentStatusApplyConfiguration struct {
	ParentRef      *ParentReferenceApplyConfiguration   `json:"parentRef,omitempty"`
	ControllerName *apisv1.GatewayController            `json:"controllerName,omitempty"`
	Conditions     []metav1.ConditionApplyConfiguration `json:"conditions,omitempty"`
}

// RouteParentStatusApplyConfiguration constructs a declarative configuration of the RouteParentStatus type for use with
// apply.
func RouteParentStatus() *RouteParentStatusApplyConfiguration {
	return &RouteParentStatusApplyConfiguration{}
}

// WithParentRef sets the ParentRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ParentRef field is set to the value of the last call.
func (b *RouteParentStatusApplyConfiguration) WithParentRef(value *ParentReferenceApplyConfiguration) *RouteParentStatusApplyConfiguration {
	b.ParentRef = value
	return b
}

// WithControllerName sets the ControllerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ControllerName field is set to the value of the last call.
func (b *RouteParentStatusApplyConfiguration) WithControllerName(value apisv1.GatewayController) *RouteParentStatusApplyConfiguration {
	b.ControllerName = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *RouteParentStatusApplyConfiguration) WithConditions(values ...*metav1.ConditionApplyConfiguration) *RouteParentStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}
