/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGMatrix.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGMatrix.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_multiply);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_inverse);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_translate);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_scale);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_scaleNonUniform);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_rotate);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_rotateFromVector);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_flipX);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_flipY);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_skewX);
static JSC_DECLARE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_skewY);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrixConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrix_a);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGMatrix_a);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrix_b);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGMatrix_b);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrix_c);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGMatrix_c);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrix_d);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGMatrix_d);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrix_e);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGMatrix_e);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMatrix_f);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGMatrix_f);

class JSSVGMatrixPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGMatrixPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGMatrixPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGMatrixPrototype>(vm)) JSSVGMatrixPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGMatrixPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGMatrixPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGMatrixPrototype, JSSVGMatrixPrototype::Base);

using JSSVGMatrixDOMConstructor = JSDOMConstructorNotConstructable<JSSVGMatrix>;

template<> const ClassInfo JSSVGMatrixDOMConstructor::s_info = { "SVGMatrix"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGMatrixDOMConstructor) };

template<> JSValue JSSVGMatrixDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGMatrixDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGMatrix"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGMatrix::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 18> JSSVGMatrixPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrixConstructor, 0 } },
    HashTableValue { "a"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrix_a, setJSSVGMatrix_a } },
    HashTableValue { "b"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrix_b, setJSSVGMatrix_b } },
    HashTableValue { "c"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrix_c, setJSSVGMatrix_c } },
    HashTableValue { "d"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrix_d, setJSSVGMatrix_d } },
    HashTableValue { "e"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrix_e, setJSSVGMatrix_e } },
    HashTableValue { "f"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMatrix_f, setJSSVGMatrix_f } },
    HashTableValue { "multiply"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_multiply, 1 } },
    HashTableValue { "inverse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_inverse, 0 } },
    HashTableValue { "translate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_translate, 2 } },
    HashTableValue { "scale"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_scale, 1 } },
    HashTableValue { "scaleNonUniform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_scaleNonUniform, 2 } },
    HashTableValue { "rotate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_rotate, 1 } },
    HashTableValue { "rotateFromVector"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_rotateFromVector, 2 } },
    HashTableValue { "flipX"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_flipX, 0 } },
    HashTableValue { "flipY"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_flipY, 0 } },
    HashTableValue { "skewX"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_skewX, 1 } },
    HashTableValue { "skewY"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGMatrixPrototypeFunction_skewY, 1 } },
};

const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrix"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGMatrixPrototype) };

void JSSVGMatrixPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGMatrix::info(), JSSVGMatrixPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGMatrix) };

JSSVGMatrix::JSSVGMatrix(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGMatrix>&& impl)
    : JSDOMWrapper<SVGMatrix, SignedPtrTraits<SVGMatrix, SVGMatrixPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGMatrix>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGMatrix::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGMatrixPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGMatrixPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGMatrix::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGMatrix>(vm, globalObject);
}

JSValue JSSVGMatrix::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMatrixDOMConstructor, DOMConstructorID::SVGMatrix>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGMatrix::destroy(JSC::JSCell* cell)
{
    JSSVGMatrix* thisObject = static_cast<JSSVGMatrix*>(cell);
    thisObject->JSSVGMatrix::~JSSVGMatrix();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrixConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGMatrixPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGMatrix::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGMatrix_aGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.a())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrix_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::get<jsSVGMatrix_aGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGMatrix_aSetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setA(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGMatrix_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::set<setJSSVGMatrix_aSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGMatrix_bGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.b())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrix_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::get<jsSVGMatrix_bGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGMatrix_bSetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGMatrix_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::set<setJSSVGMatrix_bSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGMatrix_cGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.c())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrix_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::get<jsSVGMatrix_cGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGMatrix_cSetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setC(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGMatrix_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::set<setJSSVGMatrix_cSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGMatrix_dGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.d())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrix_d, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::get<jsSVGMatrix_dGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGMatrix_dSetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setD(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGMatrix_d, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::set<setJSSVGMatrix_dSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGMatrix_eGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.e())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrix_e, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::get<jsSVGMatrix_eGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGMatrix_eSetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setE(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGMatrix_e, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::set<setJSSVGMatrix_eSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGMatrix_fGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.f())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMatrix_f, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::get<jsSVGMatrix_fGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGMatrix_fSetter(JSGlobalObject& lexicalGlobalObject, JSSVGMatrix& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setF(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGMatrix_f, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMatrix>::set<setJSSVGMatrix_fSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_multiplyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto secondMatrixConversionResult = convert<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "secondMatrix"_s, "SVGMatrix"_s, "multiply"_s, "SVGMatrix"_s); });
    if (secondMatrixConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.multiply(*secondMatrixConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_multiply, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_multiplyBody>(*lexicalGlobalObject, *callFrame, "multiply");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_inverseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.inverse())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_inverse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_inverseBody>(*lexicalGlobalObject, *callFrame, "inverse");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_translateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.translate(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_translate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_translateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_scaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto scaleFactorConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (scaleFactorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scale(scaleFactorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_scale, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_scaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_scaleNonUniformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto scaleFactorXConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (scaleFactorXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto scaleFactorYConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (scaleFactorYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scaleNonUniform(scaleFactorXConversionResult.releaseReturnValue(), scaleFactorYConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_scaleNonUniform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_scaleNonUniformBody>(*lexicalGlobalObject, *callFrame, "scaleNonUniform");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_rotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotate(angleConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_rotate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_rotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_rotateFromVectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotateFromVector(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_rotateFromVector, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_rotateFromVectorBody>(*lexicalGlobalObject, *callFrame, "rotateFromVector");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_flipXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.flipX())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_flipX, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_flipXBody>(*lexicalGlobalObject, *callFrame, "flipX");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_flipYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.flipY())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_flipY, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_flipYBody>(*lexicalGlobalObject, *callFrame, "flipY");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_skewXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.skewX(angleConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_skewX, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_skewXBody>(*lexicalGlobalObject, *callFrame, "skewX");
}

static inline JSC::EncodedJSValue jsSVGMatrixPrototypeFunction_skewYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGMatrix>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.skewY(angleConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGMatrixPrototypeFunction_skewY, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGMatrix>::call<jsSVGMatrixPrototypeFunction_skewYBody>(*lexicalGlobalObject, *callFrame, "skewY");
}

JSC::GCClient::IsoSubspace* JSSVGMatrix::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGMatrix, UseCustomHeapCellType::No>(vm, "JSSVGMatrix"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGMatrix.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGMatrix = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGMatrix.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGMatrix = std::forward<decltype(space)>(space); }
    );
}

void JSSVGMatrix::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGMatrix*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGMatrixOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGMatrixOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGMatrix = static_cast<JSSVGMatrix*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGMatrix->protectedWrapped().ptr(), jsSVGMatrix);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGMatrix>&& impl)
{
    return createWrapper<SVGMatrix>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGMatrix& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGMatrix* JSSVGMatrix::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGMatrix*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
