/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "permission-store-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_BOOLEAN_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringBooleanVariantVariantFunc)
       (void *data1,
        const gchar *arg_table,
        const gchar *arg_id,
        gboolean arg_deleted,
        GVariant *arg_data,
        GVariant *arg_permissions,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringBooleanVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringBooleanVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_boolean (param_values + 3),
            g_marshal_value_peek_variant (param_values + 4),
            g_marshal_value_peek_variant (param_values + 5),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_table,
        const gchar *arg_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_STRING_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanStringVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_table,
        gboolean arg_create,
        const gchar *arg_id,
        GVariant *arg_app_permissions,
        GVariant *arg_data,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanStringVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanStringVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_table,
        gboolean arg_create,
        const gchar *arg_id,
        GVariant *arg_data,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_STRING_STRING_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanStringStringBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_table,
        gboolean arg_create,
        const gchar *arg_id,
        const gchar *arg_app,
        const gchar *const *arg_permissions,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanStringStringBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanStringStringBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_boxed (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_table,
        const gchar *arg_id,
        const gchar *arg_app,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_table,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.PermissionStore
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdgPermissionStore
 * @title: XdgPermissionStore
 * @short_description: Generated C code for the org.freedesktop.impl.portal.PermissionStore D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link> D-Bus interface in C.
 */

enum
{
  XDG__PERMISSION_STORE_CHANGED,
};

static unsigned XDG__PERMISSION_STORE_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.PermissionStore ---- */

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_lookup_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_lookup_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_lookup_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_lookup_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_lookup_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_lookup_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_lookup_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_lookup_OUT_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_lookup_OUT_ARG_permissions.parent_struct,
  &_xdg_permission_store_method_info_lookup_OUT_ARG_data.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdg_permission_store_method_lookup_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out0",
  (gchar *) "QMap<QString,QStringList>",
  NULL
};

static const GDBusAnnotationInfo * const _xdg_permission_store_method_lookup_annotation_info_pointers[] =
{
  &_xdg_permission_store_method_lookup_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_lookup =
{
  {
    -1,
    (gchar *) "Lookup",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_lookup_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdg_permission_store_method_info_lookup_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdg_permission_store_method_lookup_annotation_info_pointers
  },
  "handle-lookup",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_IN_ARG_app_permissions =
{
  {
    -1,
    (gchar *) "app_permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_set_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_set_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_set_IN_ARG_create.parent_struct,
  &_xdg_permission_store_method_info_set_IN_ARG_id.parent_struct,
  &_xdg_permission_store_method_info_set_IN_ARG_app_permissions.parent_struct,
  &_xdg_permission_store_method_info_set_IN_ARG_data.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdg_permission_store_method_set_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QMap<QString,QStringList>",
  NULL
};

static const GDBusAnnotationInfo * const _xdg_permission_store_method_set_annotation_info_pointers[] =
{
  &_xdg_permission_store_method_set_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_set =
{
  {
    -1,
    (gchar *) "Set",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_set_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xdg_permission_store_method_set_annotation_info_pointers
  },
  "handle-set",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_delete_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_delete_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_delete_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_delete_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_delete_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_value_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_value_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_value_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_value_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_set_value_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_set_value_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_set_value_IN_ARG_create.parent_struct,
  &_xdg_permission_store_method_info_set_value_IN_ARG_id.parent_struct,
  &_xdg_permission_store_method_info_set_value_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_set_value =
{
  {
    -1,
    (gchar *) "SetValue",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_set_value_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-value",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_permission_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_set_permission_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_set_permission_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_set_permission_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_set_permission_IN_ARG_create.parent_struct,
  &_xdg_permission_store_method_info_set_permission_IN_ARG_id.parent_struct,
  &_xdg_permission_store_method_info_set_permission_IN_ARG_app.parent_struct,
  &_xdg_permission_store_method_info_set_permission_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_set_permission =
{
  {
    -1,
    (gchar *) "SetPermission",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_set_permission_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_delete_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_delete_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_delete_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_delete_permission_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_delete_permission_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_delete_permission_IN_ARG_id.parent_struct,
  &_xdg_permission_store_method_info_delete_permission_IN_ARG_app.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_delete_permission =
{
  {
    -1,
    (gchar *) "DeletePermission",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_delete_permission_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_get_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_get_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_get_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_get_permission_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_get_permission_IN_ARG_table.parent_struct,
  &_xdg_permission_store_method_info_get_permission_IN_ARG_id.parent_struct,
  &_xdg_permission_store_method_info_get_permission_IN_ARG_app.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_get_permission_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_get_permission_OUT_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_get_permission_OUT_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_get_permission =
{
  {
    -1,
    (gchar *) "GetPermission",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_get_permission_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdg_permission_store_method_info_get_permission_OUT_ARG_pointers,
    NULL
  },
  "handle-get-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_list_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_list_IN_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_list_IN_ARG_table.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_method_info_list_OUT_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_method_info_list_OUT_ARG_pointers[] =
{
  &_xdg_permission_store_method_info_list_OUT_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdg_permission_store_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    (GDBusArgInfo **) &_xdg_permission_store_method_info_list_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdg_permission_store_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const GDBusMethodInfo * const _xdg_permission_store_method_info_pointers[] =
{
  &_xdg_permission_store_method_info_lookup.parent_struct,
  &_xdg_permission_store_method_info_set.parent_struct,
  &_xdg_permission_store_method_info_delete.parent_struct,
  &_xdg_permission_store_method_info_set_value.parent_struct,
  &_xdg_permission_store_method_info_set_permission.parent_struct,
  &_xdg_permission_store_method_info_delete_permission.parent_struct,
  &_xdg_permission_store_method_info_get_permission.parent_struct,
  &_xdg_permission_store_method_info_list.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_signal_info_changed_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_signal_info_changed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_signal_info_changed_ARG_deleted =
{
  {
    -1,
    (gchar *) "deleted",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_signal_info_changed_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdg_permission_store_signal_info_changed_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdg_permission_store_signal_info_changed_ARG_pointers[] =
{
  &_xdg_permission_store_signal_info_changed_ARG_table.parent_struct,
  &_xdg_permission_store_signal_info_changed_ARG_id.parent_struct,
  &_xdg_permission_store_signal_info_changed_ARG_deleted.parent_struct,
  &_xdg_permission_store_signal_info_changed_ARG_data.parent_struct,
  &_xdg_permission_store_signal_info_changed_ARG_permissions.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdg_permission_store_signal_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out4",
  (gchar *) "QMap<QString,QStringList>",
  NULL
};

static const GDBusAnnotationInfo * const _xdg_permission_store_signal_changed_annotation_info_pointers[] =
{
  &_xdg_permission_store_signal_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdg_permission_store_signal_info_changed =
{
  {
    -1,
    (gchar *) "Changed",
    (GDBusArgInfo **) &_xdg_permission_store_signal_info_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdg_permission_store_signal_changed_annotation_info_pointers
  },
  "changed"
};

static const GDBusSignalInfo * const _xdg_permission_store_signal_info_pointers[] =
{
  &_xdg_permission_store_signal_info_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdg_permission_store_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdg_permission_store_property_info_pointers[] =
{
  &_xdg_permission_store_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdg_permission_store_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.PermissionStore",
    (GDBusMethodInfo **) &_xdg_permission_store_method_info_pointers,
    (GDBusSignalInfo **) &_xdg_permission_store_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdg_permission_store_property_info_pointers,
    NULL
  },
  "permission-store",
};


/**
 * xdg_permission_store_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdg_permission_store_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdg_permission_store_interface_info.parent_struct;
}

/**
 * xdg_permission_store_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdgPermissionStore interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdg_permission_store_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
xdg_permission_store_signal_marshal_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_BOOLEAN_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_lookup (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_set (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_STRING_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_delete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_set_value (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_set_permission (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_STRING_STRING_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_delete_permission (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_get_permission (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdg_permission_store_method_marshal_list (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdgPermissionStore:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 */

/**
 * XdgPermissionStoreIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #XdgPermissionStore::handle-delete signal.
 * @handle_delete_permission: Handler for the #XdgPermissionStore::handle-delete-permission signal.
 * @handle_get_permission: Handler for the #XdgPermissionStore::handle-get-permission signal.
 * @handle_list: Handler for the #XdgPermissionStore::handle-list signal.
 * @handle_lookup: Handler for the #XdgPermissionStore::handle-lookup signal.
 * @handle_set: Handler for the #XdgPermissionStore::handle-set signal.
 * @handle_set_permission: Handler for the #XdgPermissionStore::handle-set-permission signal.
 * @handle_set_value: Handler for the #XdgPermissionStore::handle-set-value signal.
 * @get_version: Getter for the #XdgPermissionStore:version property.
 * @changed: Handler for the #XdgPermissionStore::changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 */

typedef XdgPermissionStoreIface XdgPermissionStoreInterface;
G_DEFINE_INTERFACE (XdgPermissionStore, xdg_permission_store, G_TYPE_OBJECT)

static void
xdg_permission_store_default_init (XdgPermissionStoreIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdgPermissionStore::handle-lookup:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_lookup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lookup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_lookup),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_lookup,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdgPermissionStore::handle-set:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app_permissions: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_set),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_set,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdgPermissionStore::handle-delete:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_delete,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdgPermissionStore::handle-set-value:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_set_value() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-value",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_set_value),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_set_value,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdgPermissionStore::handle-set-permission:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_set_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_set_permission),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_set_permission,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdgPermissionStore::handle-delete-permission:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_delete_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_delete_permission),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_delete_permission,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdgPermissionStore::handle-get-permission:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_get_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_get_permission),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_get_permission,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdgPermissionStore::handle-list:
   * @object: A #XdgPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdg_permission_store_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdgPermissionStoreIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
      xdg_permission_store_method_marshal_list,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdgPermissionStore::changed:
   * @object: A #XdgPermissionStore.
   * @arg_table: Argument.
   * @arg_id: Argument.
   * @arg_deleted: Argument.
   * @arg_data: Argument.
   * @arg_permissions: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-PermissionStore.Changed">"Changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XDG__PERMISSION_STORE_SIGNALS[XDG__PERMISSION_STORE_CHANGED] =
    g_signal_new ("changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XdgPermissionStoreIface, changed),
      NULL,
      NULL,
      xdg_permission_store_signal_marshal_changed,
      G_TYPE_NONE,
      5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdgPermissionStore:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdg_permission_store_get_version: (skip)
 * @object: A #XdgPermissionStore.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdg_permission_store_get_version (XdgPermissionStore *object)
{
  g_return_val_if_fail (XDG_IS_PERMISSION_STORE (object), 0);

  return XDG_PERMISSION_STORE_GET_IFACE (object)->get_version (object);
}

/**
 * xdg_permission_store_set_version: (skip)
 * @object: A #XdgPermissionStore.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdg_permission_store_set_version (XdgPermissionStore *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdg_permission_store_emit_changed:
 * @object: A #XdgPermissionStore.
 * @arg_table: Argument to pass with the signal.
 * @arg_id: Argument to pass with the signal.
 * @arg_deleted: Argument to pass with the signal.
 * @arg_data: Argument to pass with the signal.
 * @arg_permissions: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-PermissionStore.Changed">"Changed"</link> D-Bus signal.
 */
void
xdg_permission_store_emit_changed (
    XdgPermissionStore *object,
    const gchar *arg_table,
    const gchar *arg_id,
    gboolean arg_deleted,
    GVariant *arg_data,
    GVariant *arg_permissions)
{
  g_signal_emit (object, XDG__PERMISSION_STORE_SIGNALS[XDG__PERMISSION_STORE_CHANGED], 0, arg_table, arg_id, arg_deleted, arg_data, arg_permissions);
}

/**
 * xdg_permission_store_call_lookup:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_lookup_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_lookup_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_lookup (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_lookup_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_lookup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_lookup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_lookup_finish (
    XdgPermissionStore *proxy,
    GVariant **out_permissions,
    GVariant **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sas}@v)",
                 out_permissions,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_lookup_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_lookup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_lookup_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GVariant **out_permissions,
    GVariant **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sas}@v)",
                 out_permissions,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_set:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app_permissions: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_set_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_set_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_set (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_app_permissions,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(sbs@a{sas}@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app_permissions,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_set_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_set_finish (
    XdgPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_set_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app_permissions: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_set_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_app_permissions,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(sbs@a{sas}@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app_permissions,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_delete:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_delete_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_delete (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_delete_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_delete_finish (
    XdgPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_delete_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_delete_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_set_value:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_set_value_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_set_value_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_set_value (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetValue",
    g_variant_new ("(sbs@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_set_value_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_set_value().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_set_value().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_set_value_finish (
    XdgPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_set_value_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_set_value() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_set_value_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetValue",
    g_variant_new ("(sbs@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_set_permission:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_set_permission_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_set_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_set_permission (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    const gchar *arg_app,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPermission",
    g_variant_new ("(sbss^as)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_set_permission_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_set_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_set_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_set_permission_finish (
    XdgPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_set_permission_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_set_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_set_permission_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    const gchar *arg_app,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPermission",
    g_variant_new ("(sbss^as)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_delete_permission:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_delete_permission_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_delete_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_delete_permission (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeletePermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_delete_permission_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_delete_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_delete_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_delete_permission_finish (
    XdgPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_delete_permission_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_delete_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_delete_permission_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeletePermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_get_permission:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_get_permission_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_get_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_get_permission (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_get_permission_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @out_permissions: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_get_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_get_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_get_permission_finish (
    XdgPermissionStore *proxy,
    gchar ***out_permissions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_get_permission_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @out_permissions: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_get_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_get_permission_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    gchar ***out_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_list:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_call_list_finish() to get the result of the operation.
 *
 * See xdg_permission_store_call_list_sync() for the synchronous, blocking version of this method.
 */
void
xdg_permission_store_call_list (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_table),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdg_permission_store_call_list_finish:
 * @proxy: A #XdgPermissionStoreProxy.
 * @out_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdg_permission_store_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_list_finish (
    XdgPermissionStore *proxy,
    gchar ***out_ids,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_ids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_call_list_sync:
 * @proxy: A #XdgPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @out_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdg_permission_store_call_list_sync (
    XdgPermissionStore *proxy,
    const gchar *arg_table,
    gchar ***out_ids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_table),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_ids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdg_permission_store_complete_lookup:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_lookup (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *permissions,
    GVariant *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sas}@v)",
                   permissions,
                   data));
}

/**
 * xdg_permission_store_complete_set:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_set (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdg_permission_store_complete_delete:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_delete (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdg_permission_store_complete_set_value:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_set_value (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdg_permission_store_complete_set_permission:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_set_permission (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdg_permission_store_complete_delete_permission:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_delete_permission (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdg_permission_store_complete_get_permission:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_get_permission (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *permissions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   permissions));
}

/**
 * xdg_permission_store_complete_list:
 * @object: A #XdgPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ids: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdg_permission_store_complete_list (
    XdgPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *ids)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   ids));
}

/* ------------------------------------------------------------------------ */

/**
 * XdgPermissionStoreProxy:
 *
 * The #XdgPermissionStoreProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdgPermissionStoreProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdgPermissionStoreProxy.
 */

struct _XdgPermissionStoreProxyPrivate
{
  GData *qdata;
};

static void xdg_permission_store_proxy_iface_init (XdgPermissionStoreIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdgPermissionStoreProxy, xdg_permission_store_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdgPermissionStoreProxy)
                         G_IMPLEMENT_INTERFACE (XDG_TYPE_PERMISSION_STORE, xdg_permission_store_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdgPermissionStoreProxy, xdg_permission_store_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDG_TYPE_PERMISSION_STORE, xdg_permission_store_proxy_iface_init))

#endif
static void
xdg_permission_store_proxy_finalize (GObject *object)
{
  XdgPermissionStoreProxy *proxy = XDG_PERMISSION_STORE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdg_permission_store_proxy_parent_class)->finalize (object);
}

static void
xdg_permission_store_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdg_permission_store_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdg_permission_store_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.PermissionStore: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdg_permission_store_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdg_permission_store_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.PermissionStore", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdg_permission_store_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdg_permission_store_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdg_permission_store_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDG_TYPE_PERMISSION_STORE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDG_TYPE_PERMISSION_STORE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdg_permission_store_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdgPermissionStoreProxy *proxy = XDG_PERMISSION_STORE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdg_permission_store_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdg_permission_store_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdg_permission_store_proxy_get_version (XdgPermissionStore *object)
{
  XdgPermissionStoreProxy *proxy = XDG_PERMISSION_STORE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdg_permission_store_proxy_init (XdgPermissionStoreProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdg_permission_store_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDG_TYPE_PERMISSION_STORE_PROXY, XdgPermissionStoreProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdg_permission_store_interface_info ());
}

static void
xdg_permission_store_proxy_class_init (XdgPermissionStoreProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdg_permission_store_proxy_finalize;
  gobject_class->get_property = xdg_permission_store_proxy_get_property;
  gobject_class->set_property = xdg_permission_store_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdg_permission_store_proxy_g_signal;
  proxy_class->g_properties_changed = xdg_permission_store_proxy_g_properties_changed;

  xdg_permission_store_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdgPermissionStoreProxyPrivate));
#endif
}

static void
xdg_permission_store_proxy_iface_init (XdgPermissionStoreIface *iface)
{
  iface->get_version = xdg_permission_store_proxy_get_version;
}

/**
 * xdg_permission_store_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_proxy_new_finish() to get the result of the operation.
 *
 * See xdg_permission_store_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdg_permission_store_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDG_TYPE_PERMISSION_STORE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
}

/**
 * xdg_permission_store_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdg_permission_store_proxy_new().
 *
 * Returns: (transfer full) (type XdgPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdgPermissionStore *
xdg_permission_store_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDG_PERMISSION_STORE (ret);
  else
    return NULL;
}

/**
 * xdg_permission_store_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdgPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdgPermissionStore *
xdg_permission_store_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDG_TYPE_PERMISSION_STORE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
  if (ret != NULL)
    return XDG_PERMISSION_STORE (ret);
  else
    return NULL;
}


/**
 * xdg_permission_store_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdg_permission_store_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdg_permission_store_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdg_permission_store_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdg_permission_store_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDG_TYPE_PERMISSION_STORE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
}

/**
 * xdg_permission_store_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdg_permission_store_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdg_permission_store_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdgPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdgPermissionStore *
xdg_permission_store_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDG_PERMISSION_STORE (ret);
  else
    return NULL;
}

/**
 * xdg_permission_store_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdg_permission_store_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdg_permission_store_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdgPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdgPermissionStore *
xdg_permission_store_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDG_TYPE_PERMISSION_STORE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
  if (ret != NULL)
    return XDG_PERMISSION_STORE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdgPermissionStoreSkeleton:
 *
 * The #XdgPermissionStoreSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdgPermissionStoreSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdgPermissionStoreSkeleton.
 */

struct _XdgPermissionStoreSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdg_permission_store_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDG_TYPE_PERMISSION_STORE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDG_TYPE_PERMISSION_STORE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdg_permission_store_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdg_permission_store_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdg_permission_store_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdg_permission_store_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdg_permission_store_skeleton_vtable =
{
  _xdg_permission_store_skeleton_handle_method_call,
  _xdg_permission_store_skeleton_handle_get_property,
  _xdg_permission_store_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdg_permission_store_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdg_permission_store_interface_info ();
}

static GDBusInterfaceVTable *
xdg_permission_store_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdg_permission_store_skeleton_vtable;
}

static GVariant *
xdg_permission_store_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdg_permission_store_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdg_permission_store_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdg_permission_store_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdg_permission_store_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.PermissionStore", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdg_permission_store_emit_changed (gpointer user_data);

static void
xdg_permission_store_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdg_permission_store_emit_changed (skeleton);
}

static void
_xdg_permission_store_on_signal_changed (
    XdgPermissionStore *object,
    const gchar *arg_table,
    const gchar *arg_id,
    gboolean arg_deleted,
    GVariant *arg_data,
    GVariant *arg_permissions)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ssb@v@a{sas})",
                   arg_table,
                   arg_id,
                   arg_deleted,
                   arg_data,
                   arg_permissions));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.PermissionStore", "Changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdg_permission_store_skeleton_iface_init (XdgPermissionStoreIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdgPermissionStoreSkeleton, xdg_permission_store_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdgPermissionStoreSkeleton)
                         G_IMPLEMENT_INTERFACE (XDG_TYPE_PERMISSION_STORE, xdg_permission_store_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdgPermissionStoreSkeleton, xdg_permission_store_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDG_TYPE_PERMISSION_STORE, xdg_permission_store_skeleton_iface_init))

#endif
static void
xdg_permission_store_skeleton_finalize (GObject *object)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdg_permission_store_skeleton_parent_class)->finalize (object);
}

static void
xdg_permission_store_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdg_permission_store_emit_changed (gpointer user_data)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.PermissionStore",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdg_permission_store_schedule_emit_changed (XdgPermissionStoreSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdg_permission_store_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdg_permission_store_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdg_permission_store_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdg_permission_store_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdg_permission_store_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdg_permission_store_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdg_permission_store_skeleton_init (XdgPermissionStoreSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdg_permission_store_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDG_TYPE_PERMISSION_STORE_SKELETON, XdgPermissionStoreSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdg_permission_store_skeleton_get_version (XdgPermissionStore *object)
{
  XdgPermissionStoreSkeleton *skeleton = XDG_PERMISSION_STORE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdg_permission_store_skeleton_class_init (XdgPermissionStoreSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdg_permission_store_skeleton_finalize;
  gobject_class->get_property = xdg_permission_store_skeleton_get_property;
  gobject_class->set_property = xdg_permission_store_skeleton_set_property;
  gobject_class->notify       = xdg_permission_store_skeleton_notify;


  xdg_permission_store_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdg_permission_store_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdg_permission_store_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdg_permission_store_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdg_permission_store_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdgPermissionStoreSkeletonPrivate));
#endif
}

static void
xdg_permission_store_skeleton_iface_init (XdgPermissionStoreIface *iface)
{
  iface->changed = _xdg_permission_store_on_signal_changed;
  iface->get_version = xdg_permission_store_skeleton_get_version;
}

/**
 * xdg_permission_store_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 *
 * Returns: (transfer full) (type XdgPermissionStoreSkeleton): The skeleton object.
 */
XdgPermissionStore *
xdg_permission_store_skeleton_new (void)
{
  return XDG_PERMISSION_STORE (g_object_new (XDG_TYPE_PERMISSION_STORE_SKELETON, NULL));
}

