/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Read an image file and return a SimpleITK Image.


The reader can handle scalar images, and vector images. Pixel types
such as RGB, RGBA are loaded as multi-component images with vector
pixel types. Additionally, tensor images are loaded with the pixel
type being a 1-d vector.

An interface is also provided to access the information from the
underlying itk::ImageIO. This information can be loaded with the
ReadImageInformation method. The information is from the itk::ImageIO
interface. In some degenerate cases reading the bulk data may produce
different results. Please see itk::ImageFileReader for more details.

Reading takes place by the ITK ImageIO factory mechanism. ITK contains
many ImageIO classes which are responsible for reading separate file
formats. By default, each ImageIO is asked if it "can read" the
file, and the first one which "can read" the format is used. The
list of available ImageIOs can be obtained using the
GetRegisteredImageIOs method. The ImageIO used can be overridden with
the SetImageIO method. This is useful in cases when multiple ImageIOs
"can read" the file and the user wants to select a specific IO (not
the first).


DICOM tags are represented as strings in the meta-data dictionary(s),
therefore "0020|000D" and "0020|000d" are different when accessing
the tag value. This differs from the hexadecimal numbers they
represent, 0020|000D and 0020|000d are equivalent. The ITK meta-data
dictionary is string based and uses lower case to represent the
hexadecimal number read from disk, so 0020|000d will work as a key and
0020|000D will not be found in the dictionary (results in an exception
if attempting to access). It is recommended to use lower case when
setting and accessing DICOM tags.

See:
 itk::simple::ReadImage for the procedural interface


C++ includes: sitkImageFileReader.h
*/
public class ImageFileReader extends ImageReaderBase {
  private transient long swigCPtr;

  protected ImageFileReader(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ImageFileReader_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ImageFileReader obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ImageFileReader obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::ImageFileReader::~ImageFileReader() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ImageFileReader(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ImageFileReader::ImageFileReader()
*/
public  ImageFileReader() {
    this(SimpleITKJNI.new_ImageFileReader(), true);
  }

  /**
std::string itk::simple::ImageFileReader::ToString() const override

Print ourselves to string

*/
public  String toString() {
    return SimpleITKJNI.ImageFileReader_toString(swigCPtr, this);
  }

  /**
std::string itk::simple::ImageFileReader::GetName() const override

return user readable name of the filter

*/
public  String getName() {
    return SimpleITKJNI.ImageFileReader_getName(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageFileReader::SetFileName(const PathType &amp;fn)
*/
public  void setFileName(String fn) {
    SimpleITKJNI.ImageFileReader_setFileName(swigCPtr, this, fn);
  }

  /**
PathType itk::simple::ImageFileReader::GetFileName() const
*/
public  String getFileName() {
    return SimpleITKJNI.ImageFileReader_getFileName(swigCPtr, this);
  }

  /**
Image itk::simple::ImageFileReader::Execute() override

Set/Get The output PixelType of the image.


By default the value is sitkUnknown, which enable the output pixel
type to be same as the file. If the pixel type is specified then the itk::ConvertPixelBuffer will be used to convert the pixels.

*/
public  Image execute() {
    return new Image(SimpleITKJNI.ImageFileReader_execute(swigCPtr, this), true);
  }

  /**
void itk::simple::ImageFileReader::ReadImageInformation()

Read only the meta-data and image information in the file.


This method can be used to determine what the size and pixel type of
an image file is without reading the whole image. Even if SimpleITK
does not support an image of a certain dimension or type, the meta-
information can still be read.

*/
public  void readImageInformation() {
    SimpleITKJNI.ImageFileReader_readImageInformation(swigCPtr, this);
  }

  public PixelIDValueEnum getPixelID() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.ImageFileReader_getPixelID(swigCPtr, this));
  }

  public int getPixelIDValue() {
    return SimpleITKJNI.ImageFileReader_getPixelIDValue(swigCPtr, this);
  }

  public long getDimension() {
    return SimpleITKJNI.ImageFileReader_getDimension(swigCPtr, this);
  }

  public long getNumberOfComponents() {
    return SimpleITKJNI.ImageFileReader_getNumberOfComponents(swigCPtr, this);
  }

  public VectorDouble getOrigin() {
    return new VectorDouble(SimpleITKJNI.ImageFileReader_getOrigin(swigCPtr, this), false);
  }

  public VectorDouble getSpacing() {
    return new VectorDouble(SimpleITKJNI.ImageFileReader_getSpacing(swigCPtr, this), false);
  }

  public VectorDouble getDirection() {
    return new VectorDouble(SimpleITKJNI.ImageFileReader_getDirection(swigCPtr, this), false);
  }

  public VectorUInt64 getSize() {
    return new VectorUInt64(SimpleITKJNI.ImageFileReader_getSize(swigCPtr, this), false);
  }

  /**
std::vector&lt;std::string&gt; itk::simple::ImageFileReader::GetMetaDataKeys() const

Get the meta-data dictionary keys.


This is only valid after successful ReadImageInformation or Execute of
this filter.

Returns a vector of keys to the key/value entries in the file's meta-
data dictionary. Iterate through with these keys to get the values.

*/
public  VectorString getMetaDataKeys() {
    return new VectorString(SimpleITKJNI.ImageFileReader_getMetaDataKeys(swigCPtr, this), true);
  }

  /**
bool itk::simple::ImageFileReader::HasMetaDataKey(const std::string &amp;key) const

Query a meta-data dictionary for the existence of a key.

*/
public  boolean hasMetaDataKey(String key) {
    return SimpleITKJNI.ImageFileReader_hasMetaDataKey(swigCPtr, this, key);
  }

  /**
std::string itk::simple::ImageFileReader::GetMetaData(const std::string &amp;key) const

Get the value of a meta-data dictionary entry as a string.


If the key is not in the dictionary then an exception is thrown.

String types in the dictionary are returned as their native string.
Other types are printed to string before returning.

*/
public  String getMetaData(String key) {
    return SimpleITKJNI.ImageFileReader_getMetaData(swigCPtr, this, key);
  }

  /**
Self&amp; itk::simple::ImageFileReader::SetExtractSize(const std::vector&lt; unsigned int &gt; &amp;size)

size of image to extract from file.


By default the reader loads the entire image, this is specified when
the size has zero length.

If specified, then the image returned from Execute will be of this size. If the ImageIO and file support reading just a
region, then the reader will perform streaming.

The dimension of the image can be reduced by specifying a dimension's
size as 0. For example a size of $[10,20,30,0,0]$ results in a 3D
image with size of $[10,20,30]$. This enables reading a 5D image into
a 3D image. If the length of the specified size is greater than the
dimension of the image file, an exception will be generated. If the
size's length is less than the image's dimension then the missing
values are assumed to be zero.

When the dimension of the image is reduced, the direction cosine
matrix will be set to the identity. However, the spacing for the
selected axis will remain. The matrix from the file can still be
obtained by ImageFileReader::GetDirection.


See:
 ExtractImageFilter


*/
public  void setExtractSize(VectorUInt32 size) {
    SimpleITKJNI.ImageFileReader_setExtractSize(swigCPtr, this, VectorUInt32.getCPtr(size), size);
  }

  /**
const std::vector&lt;unsigned int&gt;&amp; itk::simple::ImageFileReader::GetExtractSize() const
*/
public  VectorUInt32 getExtractSize() {
    return new VectorUInt32(SimpleITKJNI.ImageFileReader_getExtractSize(swigCPtr, this), false);
  }

  /**
Self&amp; itk::simple::ImageFileReader::SetExtractIndex(const std::vector&lt; int &gt; &amp;index)

starting index from the image on disk to extract.


Missing dimensions are treated the same as 0.


See:
 ExtractImageFilter


*/
public  void setExtractIndex(VectorInt32 index) {
    SimpleITKJNI.ImageFileReader_setExtractIndex(swigCPtr, this, VectorInt32.getCPtr(index), index);
  }

  /**
const std::vector&lt;int&gt;&amp; itk::simple::ImageFileReader::GetExtractIndex() const
*/
public  VectorInt32 getExtractIndex() {
    return new VectorInt32(SimpleITKJNI.ImageFileReader_getExtractIndex(swigCPtr, this), false);
  }

}
