/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.util.IconHelper;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;

public class ToolTipHelpLabel
extends JLabel {
    private static final Icon ICON_16 = IconHelper.loadIcon("help_16.png");
    private static final Icon ICON_DISABLED_16 = IconHelper.loadIcon("help_disabled_16.png");
    private String tooltipText;

    public ToolTipHelpLabel(String tooltipText) {
        super(ICON_16);
        this.setDisabledIcon(ICON_DISABLED_16);
        this.tooltipText = tooltipText;
        this.registerWithToolTipManager();
        this.addMouseListener(new MouseAdapter(){
            private boolean initialized;
            private int initialDelay;
            private int dismissDelay;

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                if (!this.initialized) {
                    this.dismissDelay = toolTipManager.getDismissDelay();
                    this.initialDelay = toolTipManager.getInitialDelay();
                    this.initialized = true;
                }
                toolTipManager.setDismissDelay(Integer.MAX_VALUE);
                toolTipManager.setInitialDelay(0);
                toolTipManager.mouseMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.initialized) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setDismissDelay(this.dismissDelay);
                    toolTipManager.setInitialDelay(this.initialDelay);
                }
            }
        });
    }

    @Override
    public String getToolTipText() {
        return this.isEnabled() ? this.tooltipText : null;
    }

    @Override
    public void setToolTipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    private void registerWithToolTipManager() {
        InputMap inputMap = this.getInputMap();
        this.getActionMap();
        boolean removeKeyStroke = false;
        KeyStroke[] ks = inputMap.keys();
        if (ks == null || ks.length == 0) {
            inputMap.put(KeyStroke.getKeyStroke(92, 0), "backSlash");
            removeKeyStroke = true;
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        if (removeKeyStroke) {
            inputMap.remove(KeyStroke.getKeyStroke(92, 0));
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }
}

