/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;

public class CompoundEntry {
    protected String label;
    protected String mainLabel;
    protected String options;
    protected String[] elements;

    public CompoundEntry(String string, String string2) throws Bib2GlsException {
        this.label = string;
        this.elements = string2.trim().split("\\s*,\\s*");
        if (this.elements.length < 2) {
            throw new Bib2GlsSyntaxException(String.format("at least 2 elements required (%d found)", this.elements.length));
        }
        this.mainLabel = this.elements[this.elements.length - 1];
        this.options = "";
    }

    public CompoundEntry(String string, String string2, String string3) throws Bib2GlsException {
        this(string, string2);
        this.setMainLabel(string3);
    }

    public CompoundEntry(String string, String string2, String string3, String string4) throws Bib2GlsException {
        this(string, string2, string3);
        this.setOptions(string4);
    }

    public boolean isElement(String string) {
        for (String string2 : this.elements) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setMainLabel(String string) throws Bib2GlsException {
        if (!this.isElement(string)) {
            throw new Bib2GlsException(String.format("label '%s' not in element list", new Object[0]));
        }
        this.mainLabel = string;
    }

    public void setOptions(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.options = string;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMainLabel() {
        return this.mainLabel;
    }

    public String[] getElements() {
        return this.elements;
    }

    public String getElementList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.elements[i]);
        }
        return stringBuilder.toString();
    }

    public String getOptions() {
        return this.options;
    }
}

