/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.dbgl.util.fat.BlockDevice;

public final class FileDisk
implements BlockDevice {
    public static final int BYTES_PER_SECTOR = 512;
    private final RandomAccessFile raf_;
    private final FileChannel fc_;
    private boolean closed_;

    public FileDisk(File file) throws FileNotFoundException {
        this.raf_ = new RandomAccessFile(file, "r");
        this.fc_ = this.raf_.getChannel();
        this.closed_ = false;
    }

    @Override
    public long getSize() throws IOException {
        this.checkClosed();
        return this.raf_.length();
    }

    @Override
    public void read(long devOffset, ByteBuffer dest) throws IOException {
        this.checkClosed();
        int toRead = dest.remaining();
        if (devOffset + (long)toRead > this.getSize()) {
            throw new IOException("reading past end of device");
        }
        while (toRead > 0) {
            int read = this.fc_.read(dest, devOffset);
            if (read < 0) {
                throw new IOException();
            }
            toRead -= read;
            devOffset += (long)read;
        }
    }

    @Override
    public int getSectorSize() {
        this.checkClosed();
        return 512;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed_ = true;
        this.fc_.close();
        this.raf_.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed_;
    }

    private void checkClosed() {
        if (this.closed_) {
            throw new IllegalStateException("device already closed");
        }
    }
}

