/* timex.h: mn10300 architecture timex specifications
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_TIMEX_H
#define _ASM_TIMEX_H

#include <linux/config.h>
#include <asm/proc/timer-regs.h>
#include <asm/hardirq.h>

#define TICK_SIZE (tick_nsec / 1000)

#define CLOCK_TICK_RATE 1193180 /* Underlying HZ - this should probably be set
				 * to something appropriate, but what? */

/*
 * we use a cascaded pair of 16-bit down-counting timers (timers 4 & 5) to
 * count I/O clock cycles for the purposes of time keeping
 */
typedef unsigned long cycles_t;

extern cycles_t cacheflush_time;

#ifdef __KERNEL__

static inline cycles_t get_cycles(void)
{
	return TM45BC;
}

extern unsigned long mn10300_ioclk;	/* IOCLK (crystal speed) in HZ */
extern unsigned long mn10300_last_tsc;	/* time-stamp counter at last time interrupt occurred */
extern unsigned long mn10300_tsc_per_HZ;
extern unsigned long mn10300_rtc_update_period;

extern void advance_kernel_clock(struct pt_regs *regs);

#endif /* __KERNEL__ */

#endif /* _ASM_TIMEX_H */
