/* peripherals.h: ASB2303/8 peripherals
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _ASM_UNIT_ASB2305_PERIPHERALS_H
#define _ASM_UNIT_ASB2305_PERIPHERALS_H

#include <asm/cpu-regs.h>
#include <asm/exceptions.h>
#include <linux/serial_reg.h>

#define MN103E010_CONSOLE_ON_SERIO 1	/* use MN103E010 serial port 1 */

#define ASB2303_7SEGLEDS	__SYSREG(0xA6F90000,u32)

#define ASB2308_SERIAL_IRQ	XIRQ0	/* Dual serial (PC16552)	(Hi) */
#define ASB2308_SD_IRQ		XIRQ2	/* SD Card (MN5772ZZ)		(Lo) */
#define ASB2308_ETH_IRQ		XIRQ3	/* SMSC LAN91C111 Ethernet	(Hi) */
#define ASB2308_USB_IRQ		XIRQ4	/* USB (MN5575)			(Lo) */
#define ASB2308_DSP_IRQ		XIRQ5	/* DSP (MN67736)		(Lo) */

/*
 * use the 7-segment LEDs to indicate states
 */
/* flip the 7-segment LEDs between "G" and "-" */
#define mn10300_set_gdbleds(ONOFF)			\
do {							\
	ASB2303_7SEGLEDS = (ONOFF) ? 0x85 : 0x7f;	\
} while(0)

/* indicate double-fault by displaying "d" on the LEDs */
#define mn10300_set_dbfleds			\
	mov	0x43,d0			;	\
	movbu	d0,(ASB2303_7SEGLEDS)

#ifndef __ASSEMBLY__
extern void peripheral_leds_display_exception(exception_code_t code);
extern void peripheral_leds_led_chase(void);
extern void debug_to_serial(const char *p, int n);
#endif /* __ASSEMBLY__ */

/*
 * dispose of the /dev/ttyS0 and /dev/ttyS1 serial ports
 */
#ifndef CONFIG_GDBSTUB_ON_TTYSx

#define SERIAL_PORT_DFNS				\
	{						\
	baud_base:		BASE_BAUD,		\
	irq:			XIRQ0,			\
	flags:			STD_COM_FLAGS,		\
	iomem_base:		(u8 *) 0xA6FB0000UL,	\
	iomem_reg_shift:	2,			\
	io_type:		SERIAL_IO_MEM,		\
	},						\
	{						\
	baud_base:		BASE_BAUD,		\
	irq:			XIRQ0,			\
	flags:			STD_COM_FLAGS,		\
	iomem_base:		(u8 *) 0xA6FC0000UL,	\
	iomem_reg_shift:	2,			\
	io_type:		SERIAL_IO_MEM,		\
	},

#else
#define SERIAL_PORT_DFNS /* both stolen by gdb-stub because they share an IRQ */

#if defined(CONFIG_GDBSTUB_ON_TTYS0)
#define GDBPORT_SERIAL_RX	__SYSREG(0xA6FB0000+UART_RX  *4,u8)
#define GDBPORT_SERIAL_TX	__SYSREG(0xA6FB0000+UART_TX  *4,u8)
#define GDBPORT_SERIAL_DLL	__SYSREG(0xA6FB0000+UART_DLL *4,u8)
#define GDBPORT_SERIAL_DLM	__SYSREG(0xA6FB0000+UART_DLM *4,u8)
#define GDBPORT_SERIAL_IER	__SYSREG(0xA6FB0000+UART_IER *4,u8)
#define GDBPORT_SERIAL_IIR	__SYSREG(0xA6FB0000+UART_IIR *4,u8)
#define GDBPORT_SERIAL_FCR	__SYSREG(0xA6FB0000+UART_FCR *4,u8)
#define GDBPORT_SERIAL_LCR	__SYSREG(0xA6FB0000+UART_LCR *4,u8)
#define GDBPORT_SERIAL_MCR	__SYSREG(0xA6FB0000+UART_MCR *4,u8)
#define GDBPORT_SERIAL_LSR	__SYSREG(0xA6FB0000+UART_LSR *4,u8)
#define GDBPORT_SERIAL_MSR	__SYSREG(0xA6FB0000+UART_MSR *4,u8)
#define GDBPORT_SERIAL_SCR	__SYSREG(0xA6FB0000+UART_SCR *4,u8)
#define GDBPORT_SERIAL_IRQ	XIRQ0

#elif defined(CONFIG_GDBSTUB_ON_TTYS1)
#define GDBPORT_SERIAL_RX	__SYSREG(0xA6FC0000+UART_RX  *4,u8)
#define GDBPORT_SERIAL_TX	__SYSREG(0xA6FC0000+UART_TX  *4,u8)
#define GDBPORT_SERIAL_DLL	__SYSREG(0xA6FC0000+UART_DLL *4,u8)
#define GDBPORT_SERIAL_DLM	__SYSREG(0xA6FC0000+UART_DLM *4,u8)
#define GDBPORT_SERIAL_IER	__SYSREG(0xA6FC0000+UART_IER *4,u8)
#define GDBPORT_SERIAL_IIR	__SYSREG(0xA6FC0000+UART_IIR *4,u8)
#define GDBPORT_SERIAL_FCR	__SYSREG(0xA6FC0000+UART_FCR *4,u8)
#define GDBPORT_SERIAL_LCR	__SYSREG(0xA6FC0000+UART_LCR *4,u8)
#define GDBPORT_SERIAL_MCR	__SYSREG(0xA6FC0000+UART_MCR *4,u8)
#define GDBPORT_SERIAL_LSR	__SYSREG(0xA6FC0000+UART_LSR *4,u8)
#define GDBPORT_SERIAL_MSR	__SYSREG(0xA6FC0000+UART_MSR *4,u8)
#define GDBPORT_SERIAL_SCR	__SYSREG(0xA6FC0000+UART_SCR *4,u8)
#define GDBPORT_SERIAL_IRQ	XIRQ0
#endif

#endif

#endif /* _ASM_UNIT_ASB2305_PERIPHERALS_H */
