/* smc91111_cfg.h: support for the ASB2303's SMC91C111 NIC
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_UNIT_SMC91111_CFG_H_
#define _ASM_UNIT_SMC91111_CFG_H_

#include <asm/unit/peripherals.h>


#define SMC_CAN_USE_8BIT	0
#define SMC_CAN_USE_16BIT	1
#define SMC_CAN_USE_32BIT	0
#define SMC_NOWAIT		1

#define SMC_inb(a, r)		inb((a) + (r))
#define SMC_inw(a, r)		inw((a) + (r))
#define SMC_inl(a, r)		inl((a) + (r))
#define SMC_outb(v, a, r)	outb(v, (a) + (r))
#define SMC_outw(v, a, r)	outw(v, (a) + (r))
#define SMC_outl(v, a, r)	outl(v, (a) + (r))
#define SMC_insw(a, r, p, l)	insw((a) + (r), p, l)
#define SMC_insl(a, r, p, l)	insl((a) + (r), p, l)
#define SMC_outsw(a, r, p, l)	outsw((a) + (r), p, l)
#define SMC_outsl(a, r, p, l)	outsl((a) + (r), p, l)

#define RPC_LSA_DEFAULT		RPC_LED_100_10
#define RPC_LSB_DEFAULT		RPC_LED_TX_RX

#define ASB2308_SMC_BASE	0xAA000300UL
#define ASB2308_SMC_BASE_END	0xAA000400UL
#define ASB2308_SMC_IRQ		XIRQ3

#define set_irq_type(irq, type)

#endif /*  _ASM_UNIT_SMC91111_CFG_H_ */
