/* peripherals.h: ASB2305 peripherals
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _ASM_UNIT_ASB2305_PERIPHERALS_H
#define _ASM_UNIT_ASB2305_PERIPHERALS_H

#include <asm/proc/pio-regs.h>
#include <asm/cpu-regs.h>
#include <asm/exceptions.h>
#include <linux/serial_reg.h>

#define MN10300_CONSOLE_ON_16550 1

#define ASB2305_7SEGLEDS	__SYSREG(0xA6F90000, u32)
#define ASB2305_DEBUG_MCR	__SYSREG(0xA6FB0000 + UART_MCR * 2, u8)

/* perform a hard reset by driving PIO06 low */
#define mn10300_unit_hard_reset()		\
do {						\
	P0OUT &= 0xbf;				\
	P0MD = (P0MD & P0MD_6) | P0MD_6_OUT;	\
} while(0)

/*
 * use the 7-segment LEDs to indicate states
 */
/* indicate double-fault by displaying "db-f" on the LEDs */
#define mn10300_set_dbfleds			\
	mov	0x43077f1d,d0		;	\
	mov	d0,(ASB2305_7SEGLEDS)

/* flip the 7-segment LEDs between "Gdb-" and "----" */
#define mn10300_set_gdbleds(ONOFF)				\
do {								\
	ASB2305_7SEGLEDS = (ONOFF) ? 0x8543077f : 0x7f7f7f7f;	\
} while(0)

#ifndef __ASSEMBLY__
extern void peripheral_leds_display_exception(exception_code_t code);
extern void peripheral_leds_led_chase(void);
extern void peripheral_leds7x4_display_dec(unsigned int val, unsigned int points);
extern void peripheral_leds7x4_display_hex(unsigned int val, unsigned int points);
extern void peripheral_leds7x4_display_minssecs(unsigned int time, unsigned int points);
extern void peripheral_leds7x4_display_rtc(void);
extern void debug_to_serial(const char *p, int n);
#endif /* __ASSEMBLY__ */

/*
 * dispose of the /dev/ttyS0 serial port
 */
#ifndef CONFIG_GDBSTUB_ON_TTYSx

#define SERIAL_PORT_DFNS				\
	{						\
	baud_base:		BASE_BAUD,		\
	irq:			XIRQ0,			\
	flags:			STD_COM_FLAGS,		\
	iomem_base:		(u8 *) 0xA6FB0000UL,	\
	iomem_reg_shift:	2,			\
	io_type:		SERIAL_IO_MEM,		\
	},

#else
#define SERIAL_PORT_DFNS /* stolen by gdb-stub */

#define GDBPORT_SERIAL_RX	__SYSREG(0xA6FB0000 + UART_RX  * 4, u8)
#define GDBPORT_SERIAL_TX	__SYSREG(0xA6FB0000 + UART_TX  * 4, u8)
#define GDBPORT_SERIAL_DLL	__SYSREG(0xA6FB0000 + UART_DLL * 4, u8)
#define GDBPORT_SERIAL_DLM	__SYSREG(0xA6FB0000 + UART_DLM * 4, u8)
#define GDBPORT_SERIAL_IER	__SYSREG(0xA6FB0000 + UART_IER * 4, u8)
#define GDBPORT_SERIAL_IIR	__SYSREG(0xA6FB0000 + UART_IIR * 4, u8)
#define GDBPORT_SERIAL_FCR	__SYSREG(0xA6FB0000 + UART_FCR * 4, u8)
#define GDBPORT_SERIAL_LCR	__SYSREG(0xA6FB0000 + UART_LCR * 4, u8)
#define GDBPORT_SERIAL_MCR	__SYSREG(0xA6FB0000 + UART_MCR * 4, u8)
#define GDBPORT_SERIAL_LSR	__SYSREG(0xA6FB0000 + UART_LSR * 4, u8)
#define GDBPORT_SERIAL_MSR	__SYSREG(0xA6FB0000 + UART_MSR * 4, u8)
#define GDBPORT_SERIAL_SCR	__SYSREG(0xA6FB0000 + UART_SCR * 4, u8)
#define GDBPORT_SERIAL_IRQ	XIRQ0	/* serial (PC16550)	(Hi) */

#endif

#ifdef CONFIG_GDBSTUB_ON_TTYS1
#error The ASB2305 doesnt have a /dev/ttyS1
#endif

#endif /* _ASM_UNIT_ASB2305_PERIPHERALS_H */
