%if %{?WITH_SQL:0}%{!?WITH_SQL:1}
%define WITH_SQL 1
%endif
%define cs1_version 1.5.28
%define _plugindir %{_libdir}/sasl
%define _plugindir2 %{_libdir}/sasl2
%define db_version 4.2.52

# Version 1 support.  We provide the library and plugins for the vanishingly
# small number of applications which still need them.  As of this writing,
# nothing in the FC3 test tree needs them.
%define includev1 1
%if "%{_arch}" != %{_build_arch}
%define includev1 0
%endif

Summary: The Cyrus SASL library.
Name: cyrus-sasl
Version: 2.1.19
Release: 3.gnupro.1
License: Freely Distributable
Group: System Environment/Libraries
Source0: ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/cyrus-sasl-%{version}.tar.gz
Source1: ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/cyrus-sasl-%{version}.tar.gz.sig
%if %{includev1}
Source2: ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/cyrus-sasl-%{cs1_version}.tar.gz
Source3: ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/cyrus-sasl-%{cs1_version}.tar.gz.sig
%endif
Source4: saslauthd.init
Source5: README.RPM
Source6: http://www.sleepycat.com/download/snapshot/db-%{db_version}.tar.gz
Source7: sasl-mechlist.c
Source8: sasl-checkpass.c
Source9: saslauthd.sysconfig
URL: http://asg.web.cmu.edu/sasl/sasl-library.html
%if %{includev1}
Patch0: cyrus-sasl-1.5.24-rpath.patch
Patch1: cyrus-sasl-1.5.28-autoconf25.patch
Patch2: cyrus-sasl-1.5.28-automake17.patch
Patch3: cyrus-sasl-1.5.28-automake18.patch
Patch4: cyrus-sasl-1.5.28-saslauthd2.patch
%endif
Patch5: cyrus-sasl-2.1.7-gdbm.patch
Patch6: cyrus-sasl-2.1.10-des.patch
Patch7: cyrus-sasl-2.1.17-gssapi-dynamic.patch
Patch9: cyrus-sasl-2.1.17-saslauthd1.patch
Patch10: cyrus-sasl-2.1.18-db_bundle.patch
Patch11: cyrus-sasl-2.1.18-no_rpath.patch
Patch12: cyrus-sasl-1.5.28-env.patch
Patch13: cyrus-sasl-2.1.19-env.patch
Patch10000: cyrus-sasl-2.1.19-cross.patch
Patch10001: cyrus-sasl-2.1.19-gcc4.patch
Buildroot: %{_tmppath}/%{name}-root
%if %{includev1}
BuildPrereq: gdbm-devel
%endif
%if "%{_arch}" == %{_build_arch}
BuildPrereq: autoconf, automake, libtool
BuildPrereq: krb5-devel >= 1.2, openssl-devel, pam-devel, pkgconfig
%else
BuildPrereq: krb5-devel >= 1.2, openssl-devel, pam-devel
%endif
%if %{WITH_SQL}
BuildPrereq: mysql-devel, postgresql-devel
%endif
Prereq: /sbin/ldconfig, chkconfig, /sbin/service

%description
The %{name} package contains the Cyrus implementation of SASL.
SASL is the Simple Authentication and Security Layer, a method for
adding authentication support to connection-based protocols.

%package devel
Requires: %{name} = %{version}-%{release}
Group: Development/Libraries
Summary: Files needed for developing applications with Cyrus SASL.

%description devel
The %{name}-devel package contains files needed for developing and
compiling applications which use the Cyrus SASL library.

%package gssapi
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: GSSAPI support for Cyrus SASL.

%description gssapi
The %{name}-gssapi package contains the Cyrus SASL plugins which
support GSSAPI authentication. GSSAPI is commonly used for Kerberos
authentication.

%package plain
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: PLAIN and LOGIN support for Cyrus SASL.

%description plain
The %{name}-plain package contains the Cyrus SASL plugins which support
PLAIN and LOGIN authentication schemes.

%package md5
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: CRAM-MD5 and DIGEST-MD5 support for Cyrus SASL.

%description md5
The %{name}-md5 package contains the Cyrus SASL plugins which support
CRAM-MD5 and DIGEST-MD5 authentication schemes.

%package ntlm
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: NTLM support for Cyrus SASL.

%description ntlm
The %{name}-ntlm package contains the Cyrus SASL plugin which supports
the NTLM authentication schemes.

%package sql
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: SQL auxprop support for Cyrus SASL.

%description sql
The %{name}-sql package contains the Cyrus SASL plugin which supports
using a RDBMS for storing shared secrets.

%prep
%if %{includev1}
%setup -q -c -a 2 -a 6
%else
%setup -q -c -a 6
%endif

%if %{includev1}
pushd cyrus-sasl-%{cs1_version}
%patch0 -p1 -b .rpath
%patch1 -p1 -b .autoconf25
%patch2 -p1 -b .automake17
%patch3 -p1 -b .automake18
%patch4 -p1 -b .saslauthd2
%patch12 -p1 -b .env
rm config/ltconfig
libtoolize -f -c
aclocal -I config -I cmulocal
automake -a -c -f
autoheader
autoconf -f
popd
%endif

pushd cyrus-sasl-%{version}
for buildtype in static shared ; do
	mkdir build-${buildtype}
	ln -s ../configure build-${buildtype}
done
%patch5 -p1 -b .gdbm
%patch6 -p1 -b .des
%patch7 -p1 -b .gssapi-dynamic
#%patch9 -p1 -b .saslauthd1
%patch10 -p1 -b .db_bundle
%patch11 -p1 -b .no_rpath
%patch13 -p1 -b .env
%if "%{_arch}" != %{_build_arch}
%patch10000 -p1 -b .cross
%endif
%patch10001 -p0 -b .gcc4
# FIXME - this is just weird
rm config/ltconfig config/libtool.m4
libtoolize -f -c
aclocal -I config -I cmulocal
automake -a -c -f
autoheader
autoconf -f

pushd saslauthd
# FIXME - this is just weird
rm config/ltconfig
libtoolize -f -c
aclocal -I config -I ../cmulocal -I ../config
automake -a -c -f
autoheader
autoconf -f
popd
popd

%if %{includev1}
# Sort of merge the docs.
mkdir cyrus-sasl-%{version}/%{cs1_version}
mkdir cyrus-sasl-%{version}/%{cs1_version}-devel
cp %{name}-%{cs1_version}/{AUTHORS,COPYING,NEWS,README,doc/*.html} cyrus-sasl-%{version}/%{cs1_version}
cp %{name}-%{cs1_version}/doc/*.txt cyrus-sasl-%{version}/%{cs1_version}-devel

# Remove duplicate RFCs.
pushd cyrus-sasl-%{version}/%{cs1_version}-devel
for file in * ; do
	if [ -f ../doc/${file} ] ; then
		rm -f ${file}
	fi
done
popd
%endif

%build
%if "%{_arch}" != %{_build_arch}
export lt_cv_deplibs_check_method=pass_all
%_update_config
%endif

CFLAGS="$RPM_OPT_FLAGS -fPIC"; export CFLAGS

# Bundling copy of Berkeley DB, for sasldb support.
topdir=`pwd`
pushd db-%{db_version}/build_unix
%if "%{_arch}" != %{_build_arch}
AR="${AR:-%{__ar}}" \
AS="${AS:-%{__as}}" \
CC="${CC:-%{__cc}}" \
CC_FOR_BUILD=gcc \
CXX="${CXX:-%{__cxx}}" \
LD="${LD:-%{__ld}}" \
NM="${NM:-%{__nm}}" \
OBJCOPY="${OBJCOPY:-%{__objcopy}}" \
OBJDUMP="${OBJDUMP:-%{__objdump}}" \
RANLIB="${RANLIB:-%{__ranlib}}" \
STRIP="${STRIP:-%{__strip}}" \
CFLAGS="${CFLAGS:-%optflags}" \
CXXFLAGS="${CXXFLAGS:-%optflags}" \
%endif
../dist/configure \
%if "%{_arch}" != %{_build_arch}
	--target=%{_target_platform} \
	--host=%{_target_platform} \
	--build=%{_build_platform} \
%endif
	--with-mutex=UNIX/fcntl --disable-shared --enable-static --with-pic \
	--with-uniquename=_cyrus_sasl_sasldb_rh \
	--prefix=${topdir}/db-instroot \
	--includedir=${topdir}/db-instroot/include \
	--libdir=${topdir}/db-instroot/lib
make
make install
popd

# Find Kerberos.
%if "%{_arch}" != %{_build_arch}
export krb5_prefix=%{_sysroot}%{_prefix}/kerberos
%endif
if test x$krb5_prefix = x%{_prefix} ; then
	krb5_prefix=
else
	CPPFLAGS="-I${krb5_prefix}/include"; export CPPFLAGS
	CFLAGS="-I${krb5_prefix}/include $CFLAGS"
	LDFLAGS="-L${krb5_prefix}/%{_lib}"; export LDFLAGS
fi
LIBS="-lcrypt"; export LIBS
if pkg-config openssl ; then
	CPPFLAGS="`pkg-config --cflags-only-I openssl` $CPPFLAGS"; export CPPFLAGS
	CFLAGS="`pkg-config --cflags openssl` $CFLAGS"; export CFLAGS
	LDFLAGS="`pkg-config --libs-only-L openssl` $LDFLAGS"; export LDFLAGS
fi
%if "%{_arch}" != %{_build_arch}
# Fix up paths returned by pkg-config
CPPFLAGS="`echo $CPPFLAGS | perl -p -e s@-I/usr@-I%{_sysroot}/usr@`"
CFLAGS="`echo $CFLAGS | perl -p -e s@-I/usr@-I%{_sysroot}/usr@`"
LDFLAGS="`echo $LDFLAGS | perl -p -e s@-L/usr@-L%{_sysroot}/usr@`"

# Libtool insists on using libraries in /usr/lib and /lib.  Try to avoid this.
#LDFLAGS="-L%{_sysroot}%{_libdir} $LDFLAGS"
%endif

%if %{includev1}
pushd cyrus-sasl-%{cs1_version}
%configure \
	--enable-static --enable-staticdlopen --with-pic --enable-shared \
	--with-plugindir=%{_plugindir} \
	--disable-krb4 \
	--enable-gssapi${krb5_prefix:+=${krb5_prefix}} \
	--with-rc4 \
	--with-dblib=gdbm \
	--with-saslauthd=/var/run/saslauthd --without-pwcheck \
	--enable-anon \
	--enable-cram \
	--enable-digest \
	--enable-plain \
	--enable-login
make sasldir=%{_plugindir}
tagname=CC libtool --mode=link %{__cc} -o saslauthd1-checkpass -I./include $CFLAGS $RPM_SOURCE_DIR/sasl-checkpass.c $LDFLAGS ./lib/libsasl.la
popd
%endif

%if %{WITH_SQL}
# Find the SQL libraries used needed by the SQL auxprop plugin.
SQL_CFLAGS=`mysql_config --cflags`" -I"`pg_config --includedir`
SQL_LIBS=`mysql_config --libs`" -L"`pg_config --libdir`""
SQL_CFLAGS=`eval echo "$SQL_CFLAGS" | sed -e 's,-I%{_includedir}[^/],,g' -e 's,-I%{_includedir}$,,g'`
SQL_LIBS=`eval echo "$SQL_LIBS" | sed -e 's,-L%{_libdir}[^/],,g' -e 's,-L%{_libdir}$,,g'`
SQL_LDFLAGS=`eval echo "$SQL_LIBS" | sed -e 's,-[^L][^ ]*,,g'`
echo $SQL_LDFLAGS
SQL_LIBS=`eval echo "$SQL_LIBS" | sed -e 's,-[^l][^ ]*,,g'`
echo $SQL_LIBS

CFLAGS=`echo $CFLAGS $SQL_CFLAGS | sed -e 's,[ 	]+, ,g'`; export CFLAGS
CPPFLAGS=`echo $CPPFLAGS $SQL_CFLAGS | sed -e 's,[ 	]+, ,g'`; export CPPFLAGS
LDFLAGS=`echo $LDFLAGS $SQL_LDFLAGS | sed -e 's,[ 	]+, ,g'`; export LDFLAGS
%else
CFLAGS=`echo $CFLAGS | sed -e 's,[ 	]+, ,g'`; export CFLAGS
CPPFLAGS=`echo $CPPFLAGS | sed -e 's,[ 	]+, ,g'`; export CPPFLAGS
LDFLAGS=`echo $LDFLAGS | sed -e 's,[ 	]+, ,g'`; export LDFLAGS
%endif

# Version 2.  If built statically, the plugins are part of the library itself,
# and if built shared in the same instance, in the shared library, too, so we
# build twice.  Yay.
for buildtype in static shared ; do
pushd cyrus-sasl-%{version}/build-${buildtype}
build_static=
build_shared=
eval build_${buildtype}=yes
%if %{WITH_SQL}
if test x$build_shared = xyes ; then
	moreflags="--enable-sql --with-mysql=%{_prefix} --with-pgsql=%{_prefix}"
fi
%endif
# We patch configure.in, so we regenerate configure, but the generated version
# doesn't cache whether or not it can build shared libraries, so configure gets
# confused.  Aaargh.
ac_cv_can_build_shared=yes
export ac_cv_can_build_shared
%configure \
	--disable-shared --disable-static --enable-${buildtype} \
	--disable-java \
	--with-plugindir=%{_plugindir2} \
	--disable-krb4 \
	--enable-gssapi${krb5_prefix:+=${krb5_prefix}} \
	--with-gss_impl=mit \
	--with-rc4 \
	--with-dblib=berkeley \
	--with-bdb-incdir=${topdir}/db-instroot/include \
	--with-bdb-libdir=${topdir}/db-instroot/lib \
	--with-saslauthd=/var/run/saslauthd --without-pwcheck \
	--with-ldap \
	--with-devrandom=/dev/urandom \
	--enable-anon \
	--enable-cram \
	--enable-digest \
	--enable-ntlm \
	--enable-plain \
	--enable-login \
	--disable-otp \
	$moreflags
	# --enable-auth-sasldb -- EXPERIMENTAL

%if "%{_arch}" != %{_build_arch}
# This is a gross hack, but because of the stuff going on under
# 'FIXME' in prep there wasn't a better way.  We normally would have
# patched libtool.m4, but it gets removed.
if [ -f libtool ]; then
perl -pi -e s@^sys_lib_search_path_spec=".+"@sys_lib_search_path_spec="%{_sysroot}"@ libtool
else
exit -1
fi
%endif

make sasldir=%{_plugindir2} AR=%{__ar}
make -C saslauthd testsaslauthd
popd
done

# Merge our static libdb in with libsasl, because we won't be installing it.
pushd cyrus-sasl-%{version}/build-static/lib
%{__ar} x ${topdir}/db-instroot/lib/libdb.a
%{__ar} cru libsasl2.a `%{__ar} t ${topdir}/db-instroot/lib/libdb.a`

# Build small programs to list the available mechanisms, because I need them.
%{__cc} -o sasl2-static-mechlist \
	-I../../include $CFLAGS \
	$RPM_SOURCE_DIR/sasl-mechlist.c \
	$LDFLAGS ./libsasl2.a \
	`pkg-config --libs openssl`
popd
pushd cyrus-sasl-%{version}/build-shared/lib
tagname=CC ../libtool --mode=link %{__cc} -o sasl2-shared-mechlist -I../../include $CFLAGS $RPM_SOURCE_DIR/sasl-mechlist.c $LDFLAGS ./libsasl2.la
popd
pushd cyrus-sasl-%{version}/build-shared
#tagname=CC ./libtool --mode=link %{__cc} -o saslauthd2-checkpass -DSASL2 -I../include $CFLAGS $RPM_SOURCE_DIR/sasl-checkpass.c $LDFLAGS ./lib/libsasl2.la
popd

%install
test "$RPM_BUILD_ROOT" != "/" && rm -rf $RPM_BUILD_ROOT

%if %{includev1}
pushd cyrus-sasl-%{cs1_version}
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir}
install -m755 -d $RPM_BUILD_ROOT%{_bindir}
libtool --mode=install \
install -m755 sample/client $RPM_BUILD_ROOT%{_bindir}/sasl-sample-client
libtool --mode=install \
install -m755 sample/server $RPM_BUILD_ROOT%{_bindir}/sasl-sample-server
popd
%endif

pushd cyrus-sasl-%{version}/build-static
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir2} transform="" -C lib
popd

pushd cyrus-sasl-%{version}/build-shared
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir2} transform=""
install -m755 -d $RPM_BUILD_ROOT%{_bindir}

libtool --mode=install \
install -m755 sample/client $RPM_BUILD_ROOT%{_bindir}/sasl2-sample-client
libtool --mode=install \
install -m755 sample/server $RPM_BUILD_ROOT%{_bindir}/sasl2-sample-server
libtool --mode=install \
install -m755 saslauthd/testsaslauthd $RPM_BUILD_ROOT%{_sbindir}/testsaslauthd
libtool --mode=install \
install -m755 utils/dbconverter-2 $RPM_BUILD_ROOT%{_sbindir}/dbconverter-2

# Install the saslauthd mdoc page in the expected location.  Sure, it's not
# really a man page, but groff seems to be able to cope with it.
install -m755 -d $RPM_BUILD_ROOT%{_mandir}/man8/
install -m644 ../saslauthd/saslauthd.mdoc $RPM_BUILD_ROOT%{_mandir}/man8/saslauthd.8

# Create the saslauthd listening directory.
install -m755 -d $RPM_BUILD_ROOT/var/run/saslauthd

# Install the init script.
install -m755 -d $RPM_BUILD_ROOT/etc/rc.d/init.d $RPM_BUILD_ROOT/etc/sysconfig
install -m755 $RPM_SOURCE_DIR/saslauthd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/saslauthd
install -m644 $RPM_SOURCE_DIR/saslauthd.sysconfig $RPM_BUILD_ROOT/etc/sysconfig/saslauthd

popd

# Figure out an easy way to test various saslauthd clients.
%if %{includev1}
libtool --mode=install \
install -m755 cyrus-sasl-%{cs1_version}/saslauthd1-checkpass \
$RPM_BUILD_ROOT%{_sbindir}/
%endif
#libtool --mode=install \
#install -m755 cyrus-sasl-%{version}/build-shared/saslauthd2-checkpass \
#$RPM_BUILD_ROOT%{_sbindir}/

# Figure out an easy way to query the list of available mechanisms.
libtool --mode=install \
install -m755 cyrus-sasl-%{version}/build-shared/lib/sasl2-shared-mechlist \
$RPM_BUILD_ROOT%{_sbindir}/
libtool --mode=install \
install -m755 cyrus-sasl-%{version}/build-static/lib/sasl2-static-mechlist \
$RPM_BUILD_ROOT%{_sbindir}/

# Remove unpackaged files from the buildroot.
rm -f $RPM_BUILD_ROOT%{_libdir}/sasl2/libotp.*
rm -f $RPM_BUILD_ROOT%{_mandir}/cat8/saslauthd.8

%clean
test "$RPM_BUILD_ROOT" != "/" && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
/sbin/chkconfig --add saslauthd

%preun
if [ $1 = 0 ] ; then
	/sbin/chkconfig --del saslauthd
fi

%postun
/sbin/ldconfig
if [ $1 != 0 ] ; then
	/sbin/service saslauthd condrestart 2>&1 > /dev/null
fi

%files
%defattr(-,root,root)
%if %{includev1}
%doc %{name}-%{version}/%{cs1_version}
%endif
%doc %{name}-%{version}/{AUTHORS,COPYING,NEWS,README,doc/*.html}
%doc %{name}-%{version}/saslauthd/LDAP_SASLAUTHD
%doc $RPM_SOURCE_DIR/README.RPM
%{_libdir}/libsasl*.so.*
%if %{includev1}
%dir %{_plugindir}/
%endif
%dir %{_plugindir2}/
%if %{includev1}
%{_plugindir}/*anonymous*.so*
%{_plugindir}/*anonymous*.la
%endif
%{_plugindir2}/*anonymous*.so*
%{_plugindir2}/*anonymous*.la
%{_plugindir2}/*sasldb*.so*
%{_plugindir2}/*sasldb*.la
%{_mandir}/man8/*
%{_sbindir}/dbconverter-2
%if %{includev1}
%{_sbindir}/saslpasswd
%{_sbindir}/sasldblistusers
%endif
%{_sbindir}/saslpasswd2
%{_sbindir}/sasldblistusers2
%{_sbindir}/saslauthd
%{_sbindir}/testsaslauthd
%config(noreplace) /etc/sysconfig/saslauthd
%config /etc/rc.d/init.d/saslauthd
/var/run/saslauthd

%files plain
%defattr(-,root,root)
%if %{includev1}
%{_plugindir}/*plain*.so*
%{_plugindir}/*plain*.la
%{_plugindir}/*login*.so*
%{_plugindir}/*login*.la
%endif
%{_plugindir2}/*plain*.so*
%{_plugindir2}/*plain*.la
%{_plugindir2}/*login*.so*
%{_plugindir2}/*login*.la

%files md5
%defattr(-,root,root)
%if %{includev1}
%{_plugindir}/*crammd5*.so*
%{_plugindir}/*crammd5*.la
%{_plugindir}/*digestmd5*.so*
%{_plugindir}/*digestmd5*.la
%endif
%{_plugindir2}/*crammd5*.so*
%{_plugindir2}/*crammd5*.la
%{_plugindir2}/*digestmd5*.so*
%{_plugindir2}/*digestmd5*.la

%files ntlm
%defattr(-,root,root)
%{_plugindir2}/*ntlm*.so*
%{_plugindir2}/*ntlm*.la

%if %{WITH_SQL}
%files sql
%defattr(-,root,root)
%{_plugindir2}/*sql*.so*
%{_plugindir2}/*sql*.la
%endif

%files gssapi
%defattr(-,root,root)
%if %{includev1}
%{_plugindir}/*gssapi*.so*
%{_plugindir}/*gssapi*.la
%endif
%{_plugindir2}/*gssapi*.so*
%{_plugindir2}/*gssapi*.la

%files devel
%defattr(-,root,root)
%if %{includev1}
%doc %{name}-%{version}/%{cs1_version}-devel
%endif
%doc %{name}-%{version}/doc/*.txt
%if %{includev1}
%{_bindir}/sasl-sample-client
%{_bindir}/sasl-sample-server
%endif
%{_bindir}/sasl2-sample-client
%{_bindir}/sasl2-sample-server
%{_includedir}/*
%{_libdir}/libsasl*.*a
%{_libdir}/libsasl*.*so
%if %{includev1}
%{_plugindir}/*anonymous*.a
%{_plugindir}/*crammd5*.a
%{_plugindir}/*digestmd5*.a
%{_plugindir}/*gssapi*.a
%{_plugindir}/*login*.a
%{_plugindir}/*plain*.a
%endif
%if 0
%{_plugindir2}/*anonymous*.a
%{_plugindir2}/*crammd5*.a
%{_plugindir2}/*digestmd5*.a
%{_plugindir2}/*gssapi*.a
%{_plugindir2}/*login*.a
%{_plugindir2}/*plain*.a
%{_plugindir2}/*sasldb*.a
%endif
%{_mandir}/man3/*
%{_sbindir}/sasl2-static-mechlist
%{_sbindir}/sasl2-shared-mechlist
%if %{includev1}
%{_sbindir}/saslauthd1-checkpass
%endif
#%{_sbindir}/saslauthd2-checkpass

%changelog
* Thu Oct  5 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-3
- use notting's fix for incorrect patch for CAN-2004-0884 for 1.5.28

* Thu Oct  5 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-2
- don't trust the environment in setuid/setgid contexts (CAN-2004-0884, #134660)

* Thu Aug 19 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-1
- rebuild (the 2.1.19 changelog for fixing a buffer overflow referred to a CVS
  revision between 2.1.18 and 2.1.19)

* Mon Jul 19 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-0
- update to 2.1.19, maybe for update

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Jun  7 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.18-4
- enable sql auxprop support in a subpackage
- include LDAP_SASLAUTHD documentation file (#124830)

* Fri Jun  4 2004 Nalin Dahyabhai <nalin@redhat.com>
- turn on ntlm in a subpackage

* Thu May 13 2004 Thomas Woerner <twoerner@redhat.com> 2.1.18-3
- removed rpath

* Tue Mar 16 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.18-2
- turn on building of libsasl v1 again

* Fri Mar 12 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.18-1
- update to 2.1.18
- saslauthd's ldap code is no longer marked experimental, so we build it

* Mon Mar  8 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.17-4
- rebuild

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb  3 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.17-2
- include default /etc/sysconfig/saslauthd configuration file for the init
  script (#114868)

* Thu Jan 29 2004 Nalin Dahyabhai <nalin@redhat.com>
- drop saslauthd_version patch for libsasl2

* Thu Jan 29 2004 Nalin Dahyabhai <nalin@redhat.com>
- add a saslauthd_version option to libsasl's saslauthd client and teach it to
  do the right thing
- enable the saslauthd client code in libsasl version 1 (it's still going away!)
- add saslauthd1-checkpass/saslauthd2-checkpass for testing the above change

* Wed Jan  7 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.17-1
- forcibly disable otp and sql plugins at compile-time

* Fri Dec 19 2003 Nalin Dahyabhai <nalin@redhat.com>
- update to 2.1.17, forcing the gssapi plugin to be shared now, as before
- use a bundled libdb (#112215)
- build static-with-all-plugins and normal-shared libsasl versions
- add sasl2-{shared,static}-mechlist for very basic sanity checking
- make inclusion of sasl1 stuffs conditional, because it's so going away

* Sat Dec 13 2003 Jeff Johnson <jbj@jbj.org> 2.1.15-7
- rebuild against db-4.2.52.

* Thu Oct 23 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-6
- use /dev/urandom instead of /dev/random for SASL2 (docs indicate that this is
  safe if you aren't using OTP or SRP, and we build neither); SASL1 appears to
  use it to seed the libc RNG only (#103378)

* Mon Oct 20 2003 Nalin Dahyabhai <nalin@redhat.com>
- obey RPM_OPT_FLAGS again when krb5_prefix != %%{_prefix}

* Fri Oct 17 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-5
- install saslauthd's mdoc page instead of the pre-formatted man page, which
  would get formatted again

* Thu Sep 25 2003 Jeff Johnson <jbj@jbj.org> 2.1.15-5
- rebuild against db-4.2.42.

* Mon Sep 15 2003 Nalin Dahyabhai <nalin@redhat.com>
- include testsaslauthd
- note in the README that the saslauthd protocol is different for v1 and v2,
  so v1's clients can't talk to the v2 server

* Thu Aug 21 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-4
- rebuild

* Thu Aug 21 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-3
- add logic to build with gssapi libs in either /usr or /usr/kerberos

* Mon Jul 21 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-2
- rebuild

* Tue Jul 15 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-1
- update to 2.1.15

* Mon Jul 14 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.14-1
- update to 2.1.14

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri May  9 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.13-3
- change -m argument to saslauthd to be a directory instead of a path

* Thu May  8 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.13-2
- link libsasl2 with -lpthread to ensure that the sasldb plug-in can always
  be loaded

* Tue Apr 29 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.13-1
- update to 2.1.13

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Tue Jan  7 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.10-3
- rebuild

* Thu Dec 12 2002 Nalin Dahyabhai <nalin@redhat.com>
- consider either des_cbc_encrypt or DES_cbc_encrypt to be sufficient when
  searching for a DES implementation in libcrypto
- pull in CPPFLAGS and LDFLAGS from openssl's pkg-config data, if it exists

* Mon Dec  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.10-2
- rebuild

* Mon Dec  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.10-1
- update to 2.1.10, fixing buffer overflows in libsasl2 noted by Timo Sirainen

* Tue Nov 12 2002 Tim Powers <timp@redhat.com> 2.1.7-5
- remove files from $RPM_BUILD_ROOT that we don't intend to include

* Tue Oct  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-4
- update to SASLv1 to final 1.5.28

* Fri Sep 13 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-3
- rebuild, overriding sasldir when running make so that on multilib systems
  applications will be able to load modules for the right arch

* Mon Sep  2 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-2
- include dbconverter-2 (#68741)

* Fri Aug  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-1
- update to 2.1.7, fixing a race condition in digest-md5

* Wed Jul 17 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.6-1
- update to 2.1.6 and 1.5.28

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Jun 13 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.5-1
- update to 2.1.5

* Mon Jun 10 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.4-1
- update to 2.1.4

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 16 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.2-1
- modify to build with db 4.x

* Thu Apr 18 2002 Nalin Dahyabhai <nalin@redhat.com>
- update cyrus-sasl 2 to 2.1.2
- change buildreq to db3-devel

* Tue Feb 12 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.1-3
- suppress output to stdout/stderr in %%postun

* Sun Feb 10 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.1-2
- configure sasldb2 to use berkeley DB instead of gdbm

* Wed Feb  6 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.1-1
- update to 2.1.1

* Thu Jan 31 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.0-1
- marge 1.5.24 back in, making a note that it should be removed at some
  point in the future

* Wed Jan 30 2002 Nalin Dahyabhai <nalin@redhat.com>
- update to 2.1.0, which is designed to be installed in parallel with cyrus sasl
  1.x, so fork the package and rename it to cyrus-sasl2
- add the sasldb auxprop plugin to the main package
- add disabled-by-default saslauthd init script
- move the .la files for plugins into their respective packages -- they're
  needed by the library

* Wed Jan 23 2002 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-24
- free ride through the build system

* Fri Nov  2 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-23
- patch to fix possible syslog format-string vulnerability 

* Mon Oct 29 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-22
- add pam-devel as a buildprereq

* Wed Aug 29 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-21
- include sample programs in the -devel subpackage, prefixing their names
  with "sasl-" to reduce future potential naming conflicts

* Tue Aug 14 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-20
- build without -ggdb

* Fri Aug  3 2001 Nalin Dahyabhai <nalin@redhat.com>
- add gdbm-devel as a build dependency (#44990)
- split off CRAM-MD5 and DIGEST-MD5 into a subpackage of their own (#43079,
  and dialogs with David L. Parsley)

* Fri Apr 27 2001 Nalin Dahyabhai <nalin@redhat.com>
- split out the PLAIN and LOGIN mechanisms into their own package (this allows
  an administrator to disable them by simply removing the package)

* Fri Jan 19 2001 Nalin Dahyabhai <nalin@redhat.com>
- rebuild in new environment

* Wed Dec  6 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix gssapi-over-tls

* Fri Oct 27 2000 Nalin Dahyabhai <nalin@redhat.com>
- enable static libraries, but always build with -fPIC

* Wed Oct 25 2000 Nalin Dahyabhai <nalin@redhat.com>
- make sure the version of 1.5.24 in the package matches the masters (#18968)

* Mon Oct  9 2000 Nalin Dahyabhai <nalin@redhat.com>
- re-add the libsasl.so symlink to the -devel package (oops)

* Fri Oct  6 2000 Nalin Dahyabhai <nalin@redhat.com>
- move .so files for modules to their respective packages -- they're not -devel
  links meant for use by ld anyway

* Thu Oct  5 2000 Nalin Dahyabhai <nalin@redhat.com>
- split off -devel subpackage
- add a -gssapi subpackage for the gssapi plugins

* Wed Aug 16 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix the summary text

* Sun Aug 13 2000 Nalin Dahyabhai <nalin@redhat.com>
- re-enable arcfour and CRAM

* Fri Aug  4 2000 Nalin Dahyabhai <nalin@redhat.com>
- force use of gdbm for database files to avoid DB migration weirdness
- enable login mechanism
- disable gssapi until it can coexist peacefully with non-gssapi setups
- actually do a make in the build section (#15410)

* Fri Jul 21 2000 Nalin Dahyabhai <nalin@redhat.com>
- update to 1.5.24

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jun 27 2000 Nalin Dahyabhai <nalin@redhat.com>
- rebuild in new environment (release 3)

* Mon Jun 19 2000 Nalin Dahyabhai <nalin@redhat.com>
- don't muck with syslogd in post
- remove patch for db-3.0 wackiness, no longer needed

* Thu Jun  8 2000 Nalin Dahyabhai <nalin@redhat.com>
- FHS cleanup
- don't strip anything by default

* Fri Feb 11 2000 Tim Powers <timp@redhat.com>
- fixed man pages not being gzipped

* Tue Nov 16 1999 Tim Powers <timp@redhat.com>
- incorporated changes from Mads Kiilerich
- release number is 1, not mk1

* Tue Nov 10 1999 Mads Kiilerich <mads@kiilerich.com>
- updated to sasl 1.5.11
- configure --disable-krb4 --without-rc4 --disable-cram 
  because of missing libraries and pine having cram as default...
- handle changing libsasl.so versions

* Mon Aug 30 1999 Tim Powers <timp@redhat.com>
- changed group

* Fri Aug 13 1999 Tim Powers <timp@redhat.com>
- first build for Powertools
