/*	Copyright (C) 1995 Cygnus Support, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, Cygnus Support gives permission
 * for additional uses of the text contained in its release of this library.
 *
 * The exception is that, if you link this library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking this library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by 
 * Cygnus Support as part of this library.  If you copy
 * code from other releases distributed under the terms of the GPL into a copy of
 * this library, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from such code.
 *
 * If you write modifications of your own for this library, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include "_scm.h"
#include "tk.h"
#include "guile-tcl.h"
#include "guile-tk.h"



#undef DEFER_INTS
#undef ALLOW_INTS
#define DEFER_INTS
#define ALLOW_INTS



PROC (s_init_main_window, "tk-init-main-window", 4, 0, 0, scm_init_main_window);
#ifdef __STDC__
SCM
scm_init_main_window (SCM tobj, SCM display, SCM name, SCM class)
#else
SCM
scm_init_main_window (tobj, display, name, class)
     SCM tobj;
     SCM display;
     SCM name;
     SCM class;
#endif
{
  int status;
  Tk_Window win;
  ASSERT (NIMP (tobj) && TERPP (tobj), tobj, ARG1, s_init_main_window);
  ASSERT (NIMP (display) && STRINGP (display),
	  display, ARG2, s_init_main_window);
  ASSERT (NIMP (name) && STRINGP (name), name, ARG3, s_init_main_window);
  ASSERT (NIMP (class) && STRINGP (class), class, ARG4, s_init_main_window);

  DEFER_INTS;
  win = Tk_CreateMainWindow (TERP (tobj),
			     CHARS (display), CHARS (name), CHARS (class));
  ALLOW_INTS;

  if (win == NULL)
    return makfrom0str (TERP (tobj)->result);

  DEFER_INTS;
  status = Tcl_Init(TERP (tobj));
  ALLOW_INTS;

  if (status == TCL_ERROR)
    return makfrom0str (TERP (tobj)->result);

  DEFER_INTS;
  status = Tk_Init(TERP (tobj));
  ALLOW_INTS;
  if (status == TCL_ERROR)
    return makfrom0str (TERP (tobj)->result);

  DEFER_INTS;
  Tcl_SetVar (TERP (tobj), "tcl_interactive", "0", TCL_GLOBAL_ONLY);
  ALLOW_INTS;

  return BOOL_T;
}


PROC (s_do_one_event, "tk-do-one-event", 1, 0, 0, scm_do_one_event);
#ifdef __STDC__
SCM
scm_do_one_event (SCM flags)
#else
SCM
scm_do_one_event (flags)
     SCM flags;
#endif
{
  int answer;
  ASSERT (INUMP (flags), flags, ARG1, s_do_one_event);
  DEFER_INTS;
  answer = (Tk_DoOneEvent (INUM (flags)));
  ALLOW_INTS;
  return MAKINUM (answer);
}

PROC (s_main_loop, "tk-main-loop", 0, 0, 0, scm_main_loop);
#ifdef __STDC__
SCM
scm_main_loop (void)
#else
SCM
scm_main_loop ()
#endif
{
  DEFER_INTS;
  Tk_MainLoop ();
  ALLOW_INTS;
  return UNSPECIFIED;
}


PROC (s_num_main_windows, "tk-num-main-windows", 0, 0, 0, scm_num_main_windows);
#ifdef __STDC__
SCM
scm_num_main_windows (void)
#else
SCM
scm_num_main_windows ()
#endif
{
  return MAKINUM (Tk_GetNumMainWindows ());
}


#ifdef __STDC__
void
scm_init_gtk (void)
#else
void
scm_init_gtk ()
#endif
{
#include "guile-tk.x"
}
