/* CY16 ELF support for BFD.
   Copyright (C) 2001, 2003 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _ELF_CY16_H
#define _ELF_CY16_H

#include "elf/reloc-macros.h"

/* Relocations.  */
START_RELOC_NUMBERS (elf_cy16_reloc_type)
  RELOC_NUMBER (R_CY16_NONE, 0)

  RELOC_NUMBER (R_CY16_16, 1)
  RELOC_NUMBER (R_CY16_32, 2)
  RELOC_NUMBER (R_CY16_IMMED3, 3)
  RELOC_NUMBER (R_CY16_IMMED1_16, 4)
  RELOC_NUMBER (R_CY16_IMMED2_16, 5)
  RELOC_NUMBER (R_CY16_LABEL_7, 6)
  RELOC_NUMBER (R_CY16_LABEL_16, 7)

  RELOC_NUMBER (R_CY16_GNU_VTINHERIT, 8)
  RELOC_NUMBER (R_CY16_GNU_VTENTRY, 9)
END_RELOC_NUMBERS (R_CY16_MAX)

/* Define the data & instruction memory discriminator.  In a linked
   executable, an symbol should be deemed to point to an instruction
   if ((address & CY16_INSN_MASK) == CY16_INSN_VALUE), and similarly
   for the data space.  See also `ld/emulparams/elf32cy16.sh'.

   The CY16 has a unified address space, so define these macros to do
   nothing.
  */
#define CY16_DATA_MASK   0x00000000
#define CY16_DATA_VALUE  0x00000000
#define CY16_INSN_MASK   0x00000000
#define CY16_INSN_VALUE  0x00000000

#endif /* _ELF_CY16_H */
