/*
 * Copyright (c) 1992, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 *  Modified for incorporation into newlib by Joel Sherrill
 *  (joel@OARcorp.com), On-Line Applications Research, 1995.
 *  Did the following:
 *     + merged in DEFS.h
 *     + removed error check since it prevented using this setjmp
 *       to "context switch" 
 *     + added the support for the "user label" and "register" prefix
 *
 *  Modified for usage by Nios processor by Jeff Johnston
 *  (jjohnstn@redhat.com), Red Hat, Inc., 2000.
 *  Did the following:
 *     + changed to use Nios opcodes
 *     + made routine work for either nios16 or nios32 processors
 *     + removed PROF version of ENTRY
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: $Header: /cvs/cvsfiles/devo/newlib/libc/machine/nios/setjmp.S,v 1.3 2002/01/02 05:15:18 bje Exp $
 */

#if defined(LIBC_SCCS) && !defined(lint)
        .asciz "@(#)_setjmp.s   8.1 (Berkeley) 6/4/93"
#endif /* LIBC_SCCS and not lint */


/*
 * C library -- _setjmp, _longjmp
 *
 *      _longjmp(a,v)
 * will generate a "return(v?v:1)" from
 * the last call to
 *      _setjmp(a)
 * by unwinding the call stack.
 * The previous signal state is NOT restored.
 */


/* #include "DEFS.h" */

	.align 4
	.text
	.globl setjmp
	.globl _setjmp
	.globl longjmp
	.globl _longjmp

setjmp:
_setjmp:
        st      [%o0], %sp      /* caller's stack pointer */
	pfx	1
        st      [%o0], %i7      /* caller's return pc */
	pfx	2
        st      [%o0], %fp      /* store caller's frame pointer */
	pfx	3
        st      [%o0], %o7
        lret
        clr     %o0             /* return 0 */

longjmp:
_longjmp:
        trap    0x04            /* flush registers */
	nop
	mov	%g6, %o1
        addi   	%g6, 0          /* compute v ? v : 1 in a global register */
        bne    	label1
	nop
        movi    %g6, 1
label1:
        ld      %sp, [%o0]      /* caller's stack pointer */

	lds	%l0, [%sp,0]
	lds	%l1, [%sp,1]
	lds	%l2, [%sp,2]
	lds	%l3, [%sp,3]
	lds	%l4, [%sp,4]
	lds	%l5, [%sp,5]
	lds	%l6, [%sp,6]
	lds	%l7, [%sp,7]

	lds	%i0, [%sp,8]
	lds	%i1, [%sp,9]
	lds	%i2, [%sp,10]
	lds	%i3, [%sp,11]
	lds	%i4, [%sp,12]
	lds	%i5, [%sp,13]

	pfx	1
        ld      %i7, [%o0]      /* caller's return pc */
	pfx	2
        ld      %fp, [%o0]      /* caller's frame pointer */
	pfx	3
        ld      %o7, [%o0] 

	mov	%o0, %o7
        jmp     %o0             /* success, return %g6 */
        mov     %o0, %g6

