#include <_ansi.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sys/syscall.h"
int errno;

#define __sys_p_ipi(call_nr, arg1, arg2, arg3) \
({ \
  void *result; \
 \
  __asm("ld r0,#0% ld e10,r0% ld e8,r0% " \
	"%L3 r10,%3% %L2 a9,%2% %L1 r8,%1% %L4 r0,%4% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,a8" \
	: "=rm" (result) \
	: "am" (arg1), "am" (arg2), "am" (arg3), "rmi" (call_nr) \
	: "r0", "r2", "a8", "a9", "r9", "a10", "r10", "memory"); \
  result; \
})

#define __sys_p_ipp(call_nr, arg1, arg2, arg3) \
({ \
  void *result; \
 \
  __asm("ld r0,#0% ld e8,r0% " \
	"%L3 a10,%3% %L2 a9,%2% %L1 r8,%1% %L4 r0,%4% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,a8" \
	: "=rm" (result) \
	: "am" (arg1), "am" (arg2), "am" (arg3), "rmi" (call_nr) \
	: "r0", "r2", "a8", "a9", "r9", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i_pii(call_nr, arg1, arg2, arg3) \
({ \
  int result; \
 \
  __asm("ld r0,#0% ld e10,r0% ld e9,r0% " \
	"%L3 r10,%3% %L2 r9,%2% %L1 a8,%1% %L4 r0,%4% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "am" (arg1), "am" (arg2), "am" (arg3), "rmi" (call_nr) \
	: "r0", "r2", "a8", "r8", "r9", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i_ppp(call_nr, arg1, arg2, arg3) \
({ \
  int result; \
 \
  __asm("%L3 a10,%3% %L2 a9,%2% %L1 a8,%1% %L4 r0,%4% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "am" (arg1), "am" (arg2), "am" (arg3), "rmi" (call_nr) \
	: "r0", "r2", "a8", "r8", "a9", "r9", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i_pi(call_nr, arg1, arg2) \
({ \
  int result; \
 \
  __asm("ld r0,#0% ld e9,r0% %L2 r9,%2% %L1 a8,%1% %L3 r0,%3% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "am" (arg1), "am" (arg2), "rmi" (call_nr) \
	: "r0", "r2", "a8", "r8", "r9", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i_pp(call_nr, arg1, arg2) \
({ \
  int result; \
 \
  __asm("%L2 a9,%2% %L1 a8,%1% %L3 r0,%3% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "am" (arg1), "am" (arg2), "rmi" (call_nr) \
	: "r0", "r2", "a8", "r8", "a9", "r9", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i_i(call_nr, arg1) \
({ \
  int result; \
 \
  __asm volatile ("ld r0,#0% ld e8,r0% %L1 r8,%1% %L2 r0,%2% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "am" (arg1), "rmi" (call_nr) \
	: "r0", "r2", "r8", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i_p(call_nr, arg1) \
({ \
  int result; \
 \
  __asm("%L1 a8,%1% %L2 r0,%2% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "am" (arg1), "rmi" (call_nr) \
	: "r0", "r2", "a8", "r8", "a10", "r10", "memory"); \
  result; \
})

#define __sys_p_p(call_nr, arg1) \
({ \
  void *result; \
 \
  __asm("%L1 a8,%1% %L2 r0,%2% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,a8" \
	: "=rm" (result) \
	: "am" (arg1), "rmi" (call_nr) \
	: "r0", "r2", "a8", "r8", "a10", "r10", "memory"); \
  result; \
})

#define __sys_i(call_nr) \
({ \
  int result; \
 \
  __asm("%L1 r0,%1% " \
	"swi #0% " \
	"ld a10,#_errno% ldw @[a10+0],r2% %L0 %0,r8" \
	: "=rm" (result) \
	: "rmi" (call_nr) \
	: "r0", "r2", "r8", "a10", "r10", "memory"); \
  result; \
})

/* This is used by _sbrk.  */
register char *stack_ptr asm ("a15");

size_t
_read (int file,
       char *ptr,
       size_t len)
{
  return (size_t) __sys_p_ipp (SYS_read, file, ptr, (void*)len);
}

ptrdiff_t
_lseek (int file,
	ptrdiff_t ptr,
	int dir)
{
  return (size_t) __sys_p_ipi (SYS_lseek, file, (void*)ptr, dir);
}

size_t
_write ( int file,
	 char *ptr,
	 size_t len)
{
  return (size_t) __sys_p_ipp (SYS_write, file, ptr, (void*)len);
}

int
_close (int file)
{
  return __sys_i_i (SYS_close, file);
}

caddr_t
_sbrk (size_t incr)
{
  extern char end;		/* Defined by the linker */
  static char *heap_end;
  char *prev_heap_end;

  if (heap_end == 0)
    {
      heap_end = &end;
    }
  prev_heap_end = heap_end;
  if (heap_end + incr > stack_ptr)
    {
      _write (1, "Heap and stack collision\n", 25);
      abort ();
    }
  heap_end += incr;
  return (caddr_t) prev_heap_end;
}

int
_fstat (int file,
	struct stat *st)
{
  st->st_mode = S_IFCHR;
  return 0;
}

int
_open (const char *path,
	int flags)
{
  return __sys_i_pi (SYS_open, path, flags);
}

int
_creat (const char *path,
	int mode)
{
  return __sys_i_pi (SYS_creat, path, mode);
}

int
_unlink ()
{
  return -1;
}

int
isatty (fd)
     int fd;
{
  return 1;
}

void
_exit (n)
{
  __sys_i_i (SYS_exit, n);
}

int
_kill (n, m)
{
  return __sys_i_pi (SYS_exit, (void*)0xdead, 0);
}

pid_t
_getpid (n)
{
  return 1;
}

int
_raise ()
{
}

int
_stat (const char *path, struct stat *st)

{
  return __sys_i_pp (SYS_stat, path, st);
}

int
_chmod (const char *path, short mode)
{
  return __sys_i_pi (SYS_chmod, path, mode);
}

int
_chown (const char *path, short owner, short group)
{
  return __sys_i_pii (SYS_chown, path, owner, group);
}

int
_utime (path, times)
     const char *path;
     char *times;
{
  return __sys_i_pp (SYS_utime, path, times);
}

int
_fork ()
{
  return __sys_i (SYS_fork);
}

int
_wait (statusp)
     int *statusp;
{
  return __sys_i (SYS_wait);
}

int
_execve (const char *path, char *const argv[], char *const envp[])
{
  return __sys_i_ppp (SYS_execve, path, argv, envp);
}

int
_execv (const char *path, char *const argv[])
{
  return __sys_i_pp (SYS_execv, path, argv);
}

int
_pipe (int *fd)
{
  return __sys_i_p (SYS_pipe, fd);
}

time_t
time (time_t *t)
{
  time_t result = __sys_p_p (SYS_time, t);

  if (t)
    *t = result;
  return result;
}
