
#include "test.h"
#include <errno.h>

/* Test mod - this is given a real hammering by the strtod type
   routines, here are some more tests.

   By definition

   modf = func(value, &iptr)

      (*iptr + modf) == value

   we test this

*/

/* testsuite entry point */
void
_DEFUN_VOID (test_main)
{
	int     i;

	newfunc ("modf");

	for (i = 0; i < 1000; i++) {
		double  intpart;
		double  n;
		line (i);
		n = randx ();
		if (finite (n) && n != 0.0) {
			double  r = modf (n, &intpart);
			line (i);
			test_mok (intpart + r, n, 63);
		}
	}
	newfunc ("modff");

	for (i = 0; i < 1000; i++) {
		float   intpart;
		double  nd;
		line (i);
		nd = randx ();
		if (nd < FLT_MAX && finitef (nd) && nd != 0.0) {
			float   n = nd;
			double  r = modff (n, &intpart);
			line (i);
			test_mok (intpart + r, n, 32);
		}
	}

}
