From abel@netvision.net.il Mon Jun  3 09:32:56 1996
Status: RO
X-VM-v5-Data: ([nil nil nil nil nil nil nil nil nil]
	["3389" "Mon" " 3" "June" "1996" "18:29:31" "+0200" "Harvey J. Stein" "abel@netvision.net.il" nil "107" "catch/throw implemented with call/cc" "^From:" nil nil "6" "1996060316:29:31" nil nil nil]
	nil)
Received: from blinky.cpaf.com (hjstein@ts002p4.pop3a.netvision.net.il [194.90.100.42]) by sst10a.lanl.gov (8.6.10/8.6.10) with ESMTP id JAA04776 for <rosalia@nis.lanl.gov>; Mon, 3 Jun 1996 09:32:46 -0600
Received: (from hjstein@localhost) by blinky.cpaf.com (8.6.11/8.6.9) id SAA27885; Mon, 3 Jun 1996 18:29:31 +0200
Message-Id: <199606031629.SAA27885@blinky.cpaf.com>
Newsgroups: comp.lang.scheme
In-Reply-To: <76hgsut242.fsf@gps-xray.lanl.gov>
References: <76hgsut242.fsf@gps-xray.lanl.gov>
From: "Harvey J. Stein" <abel@netvision.net.il>
To: Mark Galassi <rosalia@nis.lanl.gov>
Subject: catch/throw implemented with call/cc
Date: Mon, 3 Jun 1996 18:29:31 +0200

Mark Galassi writes:
 > Dear scheme programmers,
 > 
 > For the Guile manual I would like to be able to show examples of how
 > the Gulie/SCM catch and throw procedures can be implemented in terms
 > of call-with-current-continuation (call/cc).

Here's an approximation.  It's not a full implementation, but gives
the basic idea of how to do it, and it should be easy to make it a
full implementation.  It has the following problems:
   -catch and throw should be macros so that the first argument
    doesn't have to be quoted.  I defined them as functions because
    the macro capabilities of scheme implementations varies.
   -I'm not handling #t and #f keys.
   -No "jump buffer objects".
   -No "throw-default-handler" properties.
   -I don't think the error function that I'm using is R4RS.  It works
    in STk, but might not in Guile.
   -It's not thoroughly tested.  I might not be handling the catch
    stack exactly right.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Implemetation of catch and throw via call/cc
;;; Copyright (c) 1996 Harvey J. Stein <abel@netvision.net.il>
;;; All Rights Reserved
;;; This code is under the GPL.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Symbols which will be exported by this module:
(define scm-catch ())
(define scm-throw ())

;;; Put everything else in it's own environment - we don't want to
;;; pollute the environment..
(let ((*catch-table* ())
      (*catch-id* 0))

;;; Layout for *catch-table* records:
(define (table-sym rec)
  (list-ref rec 0))

(define (table-id rec)
  (list-ref rec 1))

(define (table-handler rec)
  (list-ref rec 2))

;;; Table handling
(define (push-handler sym id func)
  (set! *catch-table* (cons (list sym id func) *catch-table*)))

; Gets handler for a given symbol, cleaning up the stack along the way.
(define (find-handler sym)
  (define (pop-handler)
    (if (not (null? *catch-table*))
	(let ((handle (table-handler (car *catch-table*))))
	  (set! *catch-table* (cdr *catch-table*))
	  handle)
	#f))
  (cond ((null? *catch-table*) #f)
	((eq? sym (table-sym (car *catch-table*)))
	 (pop-handler))
	(else (pop-handler)
	      (find-handler sym))))

; Removes handler with specified id.
(define (delete-handler id)
  (define (del table)
    (cond ((null? table) ())
	  ((= *catch-id* (table-id (car table)))
	   (cdr table))
	(else
	 (cons (car table) (del (cdr table))))))
  (set! *catch-table* (del *catch-table*)))

;;; Here we go...  Basically, just use call/cc to as a setjmp so that
;;; throw can return here.
(define (catch sym thunk handler)
  (set! *catch-id* (+ *catch-id* 1))
  (let* ((id *catch-id*)
	 (ret-val (call/cc (lambda (return)
			    (push-handler sym
					  id
					  (lambda args (return
							(apply handler args))))
			    (thunk)))))
    (delete-handler id)
    ret-val))

(define (throw sym . args)
  (let ((handler (find-handler sym)))
    (if handler
	(apply handler args)
	(error "scm-throw: no handler for ~a\n" sym))))

;; Install exported args:
(set! scm-catch catch)
(set! scm-throw throw)
)

;;; Example usage:
(scm-catch 'foo (lambda ()
		  (format #t "hi from catch-thunk\n")
		  (scm-throw 'foo 'arg1 'arg2)
;;;               Control should never get to the following line.
		  (format #t "hi from catch-thunk (after throw)\n"))
	   (lambda args (format #t "handler: called with arglist ~a\n" args)))

