/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.zendesk;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelZendeskSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_ZENDESK_PATH_METHOD_NAME_CONF = "camel.sink.path.methodName";
    public static final String CAMEL_SINK_ZENDESK_PATH_METHOD_NAME_DOC = "What operation to use One of: [ADD_TAG_TO_ORGANISATIONS] [ADD_TAG_TO_TICKET] [ADD_TAG_TO_TOPICS] [ASSOCIATE_ATTACHMENTS_TO_ARTICLE] [CHANGE_USER_PASSWORD] [CREATE_ARTICLE] [CREATE_ARTICLE_1] [CREATE_ARTICLE_TRANSLATION] [CREATE_AUTOMATION] [CREATE_CATEGORY] [CREATE_CATEGORY_TRANSLATION] [CREATE_COMMENT] [CREATE_DYNAMIC_CONTENT_ITEM] [CREATE_DYNAMIC_CONTENT_ITEM_VARIANT] [CREATE_FORUM] [CREATE_GROUP] [CREATE_GROUP_MEMBERSHIP] [CREATE_GROUP_MEMBERSHIP_1] [CREATE_MACRO] [CREATE_OR_UPDATE_USER] [CREATE_OR_UPDATE_USERS] [CREATE_OR_UPDATE_USERS_1] [CREATE_OR_UPDATE_USERS_ASYNC] [CREATE_ORGANIZATION] [CREATE_ORGANIZATION_MEMBERSHIP] [CREATE_ORGANIZATION_MEMBERSHIP_1] [CREATE_ORGANIZATION_MEMBERSHIPS] [CREATE_ORGANIZATION_MEMBERSHIPS_1] [CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC] [CREATE_ORGANIZATIONS] [CREATE_ORGANIZATIONS_1] [CREATE_ORGANIZATIONS_ASYNC] [CREATE_PERMISSION_GROUP] [CREATE_REQUEST] [CREATE_SATISFACTION_RATING] [CREATE_SATISFACTION_RATING_1] [CREATE_SECTION] [CREATE_SECTION_TRANSLATION] [CREATE_TARGET] [CREATE_TICKET] [CREATE_TICKET_ASYNC] [CREATE_TICKET_FIELD] [CREATE_TICKET_FORM] [CREATE_TICKET_FROM_TWEET] [CREATE_TICKETS] [CREATE_TICKETS_1] [CREATE_TICKETS_ASYNC] [CREATE_TOPIC] [CREATE_TRIGGER] [CREATE_UPLOAD] [CREATE_UPLOAD_1] [CREATE_UPLOAD_2] [CREATE_UPLOAD_ARTICLE] [CREATE_UPLOAD_ARTICLE_1] [CREATE_USER] [CREATE_USER_IDENTITY] [CREATE_USER_IDENTITY_1] [CREATE_USER_SEGMENT] [CREATE_USERS] [CREATE_USERS_1] [CREATE_USERS_ASYNC] [DELETE_ARTICLE] [DELETE_ARTICLE_ATTACHMENT] [DELETE_ARTICLE_ATTACHMENT_1] [DELETE_ATTACHMENT] [DELETE_ATTACHMENT_1] [DELETE_AUTOMATION] [DELETE_CATEGORY] [DELETE_DYNAMIC_CONTENT_ITEM] [DELETE_DYNAMIC_CONTENT_ITEM_VARIANT] [DELETE_FORUM] [DELETE_GROUP] [DELETE_GROUP_1] [DELETE_GROUP_MEMBERSHIP] [DELETE_GROUP_MEMBERSHIP_1] [DELETE_GROUP_MEMBERSHIP_2] [DELETE_GROUP_MEMBERSHIP_3] [DELETE_ORGANIZATION] [DELETE_ORGANIZATION_1] [DELETE_ORGANIZATION_MEMBERSHIP] [DELETE_ORGANIZATION_MEMBERSHIP_1] [DELETE_ORGANIZATION_MEMBERSHIP_2] [DELETE_ORGANIZATION_MEMBERSHIPS] [DELETE_PERMISSION_GROUP] [DELETE_PERMISSION_GROUP_1] [DELETE_SECTION] [DELETE_SUSPENDED_TICKET] [DELETE_SUSPENDED_TICKET_1] [DELETE_TARGET] [DELETE_TICKET] [DELETE_TICKET_1] [DELETE_TICKET_FIELD] [DELETE_TICKET_FIELD_1] [DELETE_TICKETS] [DELETE_TOPIC] [DELETE_TRANSLATION] [DELETE_TRANSLATION_1] [DELETE_TRIGGER] [DELETE_UPLOAD] [DELETE_UPLOAD_1] [DELETE_USER] [DELETE_USER_1] [DELETE_USER_IDENTITY] [DELETE_USER_IDENTITY_1] [DELETE_USER_IDENTITY_2] [DELETE_USER_SEGMENT] [DELETE_USER_SEGMENT_1] [GET_ARTICLE] [GET_ARTICLE_FROM_SEARCH] [GET_ARTICLE_FROM_SEARCH_1] [GET_ARTICLE_SUBSCRIPTIONS] [GET_ARTICLE_SUBSCRIPTIONS_1] [GET_ARTICLE_TRANSLATIONS] [GET_ARTICLES] [GET_ARTICLES_1] [GET_ARTICLES_2] [GET_ARTICLES_3] [GET_ARTICLES_FROM_ALL_LABELS] [GET_ARTICLES_FROM_ANY_LABELS] [GET_ARTICLES_FROM_PAGE] [GET_ARTICLES_INCREMENTALLY] [GET_ASSIGNABLE_GROUP_MEMBERSHIPS] [GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1] [GET_ASSIGNABLE_GROUPS] [GET_ATTACHMENT] [GET_ATTACHMENT_1] [GET_ATTACHMENTS_FROM_ARTICLE] [GET_AUTHENTICATED_USER] [GET_AUTO_COMPLETE_ORGANIZATIONS] [GET_AUTOMATION] [GET_AUTOMATIONS] [GET_BRANDS] [GET_CC_REQUESTS] [GET_CATEGORIES] [GET_CATEGORY] [GET_CATEGORY_TRANSLATIONS] [GET_COMPLIANCE_DELETION_STATUSES] [GET_CURRENT_USER] [GET_CUSTOM_AGENT_ROLES] [GET_DELETED_TICKETS] [GET_DELETED_TICKETS_1] [GET_DYNAMIC_CONTENT_ITEM] [GET_DYNAMIC_CONTENT_ITEM_VARIANT] [GET_DYNAMIC_CONTENT_ITEM_VARIANTS] [GET_DYNAMIC_CONTENT_ITEMS] [GET_FORUM] [GET_FORUMS] [GET_FORUMS_1] [GET_GROUP] [GET_GROUP_MEMBERSHIP] [GET_GROUP_MEMBERSHIP_1] [GET_GROUP_MEMBERSHIP_BY_USER] [GET_GROUP_MEMBERSHIPS] [GET_GROUP_MEMBERSHIPS_1] [GET_GROUP_ORGANIZATION] [GET_GROUP_USERS] [GET_GROUPS] [GET_HELP_CENTER_LOCALES] [GET_HOLIDAYS_FOR_SCHEDULE] [GET_HOLIDAYS_FOR_SCHEDULE_1] [GET_INCREMENTAL_TICKETS_RESULT] [GET_JOB_STATUS] [GET_JOB_STATUS_ASYNC] [GET_JOB_STATUSES] [GET_JOB_STATUSES_ASYNC] [GET_MACRO] [GET_MACROS] [GET_OPEN_REQUESTS] [GET_ORGANIZATION] [GET_ORGANIZATION_FIELDS] [GET_ORGANIZATION_MEMBERSHIP] [GET_ORGANIZATION_MEMBERSHIP_BY_USER] [GET_ORGANIZATION_MEMBERSHIP_FOR_USER] [GET_ORGANIZATION_MEMBERSHIPS] [GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG] [GET_ORGANIZATION_MEMBERSHIPS_FOR_USER] [GET_ORGANIZATION_TICKETS] [GET_ORGANIZATION_USERS] [GET_ORGANIZATIONS] [GET_ORGANIZATIONS_INCREMENTALLY] [GET_PERMISSION_GROUP] [GET_PERMISSION_GROUPS] [GET_RECENT_TICKETS] [GET_REQUEST] [GET_REQUEST_COMMENT] [GET_REQUEST_COMMENT_1] [GET_REQUEST_COMMENT_2] [GET_REQUEST_COMMENTS] [GET_REQUEST_COMMENTS_1] [GET_REQUESTS] [GET_SATISFACTION_RATING] [GET_SATISFACTION_RATINGS] [GET_SCHEDULE] [GET_SCHEDULE_1] [GET_SCHEDULES] [GET_SEARCH_RESULTS] [GET_SEARCH_RESULTS_1] [GET_SEARCH_RESULTS_2] [GET_SEARCH_RESULTS_3] [GET_SEARCH_RESULTS_4] [GET_SECTION] [GET_SECTION_SUBSCRIPTIONS] [GET_SECTION_SUBSCRIPTIONS_1] [GET_SECTION_TRANSLATIONS] [GET_SECTIONS] [GET_SECTIONS_1] [GET_SECTIONS_2] [GET_SOLVED_REQUESTS] [GET_SUSPENDED_TICKETS] [GET_TARGET] [GET_TARGETS] [GET_TICKET] [GET_TICKET_AUDIT] [GET_TICKET_AUDIT_1] [GET_TICKET_AUDIT_2] [GET_TICKET_AUDITS] [GET_TICKET_AUDITS_1] [GET_TICKET_COLLABORATORS] [GET_TICKET_COMMENTS] [GET_TICKET_COMMENTS_1] [GET_TICKET_FIELD] [GET_TICKET_FIELDS] [GET_TICKET_FORM] [GET_TICKET_FORMS] [GET_TICKET_INCIDENTS] [GET_TICKET_METRIC] [GET_TICKET_METRIC_BY_TICKET] [GET_TICKET_METRICS] [GET_TICKETS] [GET_TICKETS_1] [GET_TICKETS_BY_EXTERNAL_ID] [GET_TICKETS_BY_EXTERNAL_ID_1] [GET_TICKETS_FROM_SEARCH] [GET_TICKETS_INCREMENTALLY] [GET_TICKETS_INCREMENTALLY_1] [GET_TOPIC] [GET_TOPICS] [GET_TOPICS_1] [GET_TOPICS_2] [GET_TOPICS_3] [GET_TOPICS_BY_USER] [GET_TRIGGER] [GET_TRIGGERS] [GET_TWITTER_MONITORS] [GET_USER] [GET_USER_CCD_TICKETS] [GET_USER_FIELDS] [GET_USER_IDENTITIES] [GET_USER_IDENTITIES_1] [GET_USER_IDENTITY] [GET_USER_IDENTITY_1] [GET_USER_IDENTITY_2] [GET_USER_RELATED_INFO] [GET_USER_REQUESTED_TICKETS] [GET_USER_REQUESTS] [GET_USER_REQUESTS_1] [GET_USER_SEGMENT] [GET_USER_SEGMENTS] [GET_USER_SEGMENTS_1] [GET_USER_SEGMENTS_APPLICABLE] [GET_USER_SUBSCRIPTIONS] [GET_USER_SUBSCRIPTIONS_1] [GET_USERS] [GET_USERS_BY_ROLE] [GET_USERS_INCREMENTALLY] [IMPORT_TICKET] [IMPORT_TOPIC] [LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID] [LOOKUP_USER_BY_EMAIL] [LOOKUP_USER_BY_EXTERNAL_ID] [MACROS_SHOW_CHANGES_TO_TICKET] [MACROS_SHOW_TICKET_AFTER_CHANGES] [MAKE_PRIVATE_TICKET_AUDIT] [MAKE_PRIVATE_TICKET_AUDIT_1] [MAKE_PRIVATE_TICKET_AUDIT_2] [MARK_TICKET_AS_SPAM] [MARK_TICKET_AS_SPAM_1] [MERGE_USERS] [NOTIFY_APP] [PERMANENTLY_DELETE_TICKET] [PERMANENTLY_DELETE_TICKET_1] [PERMANENTLY_DELETE_TICKETS] [PERMANENTLY_DELETE_USER] [PERMANENTLY_DELETE_USER_1] [QUEUE_CREATE_TICKET_ASYNC] [REMOVE_TAG_FROM_ORGANISATIONS] [REMOVE_TAG_FROM_TICKET] [REMOVE_TAG_FROM_TOPICS] [REQUEST_VERIFY_USER_IDENTITY] [REQUEST_VERIFY_USER_IDENTITY_1] [REQUEST_VERIFY_USER_IDENTITY_2] [RESET_USER_PASSWORD] [RESET_USER_PASSWORD_1] [SET_GROUP_MEMBERSHIP_AS_DEFAULT] [SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT] [SET_TAG_ON_ORGANISATIONS] [SET_TAG_ON_TICKET] [SET_TAG_ON_TOPICS] [SET_USER_PRIMARY_IDENTITY] [SET_USER_PRIMARY_IDENTITY_1] [SET_USER_PRIMARY_IDENTITY_2] [SUSPEND_USER] [TRUST_TICKET_AUDIT] [TRUST_TICKET_AUDIT_1] [TRUST_TICKET_AUDIT_2] [UNSUSPEND_USER] [UPDATE_ARTICLE] [UPDATE_ARTICLE_TRANSLATION] [UPDATE_AUTOMATION] [UPDATE_CATEGORY] [UPDATE_CATEGORY_TRANSLATION] [UPDATE_DYNAMIC_CONTENT_ITEM] [UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT] [UPDATE_FORUM] [UPDATE_GROUP] [UPDATE_INSTALLATION] [UPDATE_MACRO] [UPDATE_ORGANIZATION] [UPDATE_ORGANIZATIONS] [UPDATE_ORGANIZATIONS_1] [UPDATE_ORGANIZATIONS_ASYNC] [UPDATE_PERMISSION_GROUP] [UPDATE_REQUEST] [UPDATE_SECTION] [UPDATE_SECTION_TRANSLATION] [UPDATE_TICKET] [UPDATE_TICKET_FIELD] [UPDATE_TICKETS] [UPDATE_TICKETS_1] [UPDATE_TICKETS_ASYNC] [UPDATE_TOPIC] [UPDATE_TRIGGER] [UPDATE_USER] [UPDATE_USER_IDENTITY] [UPDATE_USER_IDENTITY_1] [UPDATE_USER_SEGMENT] [UPDATE_USERS] [UPDATE_USERS_1] [UPDATE_USERS_ASYNC] [VERIFY_USER_IDENTITY] [VERIFY_USER_IDENTITY_1] [VERIFY_USER_IDENTITY_2]";
    public static final String CAMEL_SINK_ZENDESK_PATH_METHOD_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_IN_BODY_CONF = "camel.sink.endpoint.inBody";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_IN_BODY_DOC = "Sets the name of a parameter to be passed in the exchange In Body";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_IN_BODY_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_SERVER_URL_CONF = "camel.sink.endpoint.serverUrl";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_SERVER_URL_DOC = "The server URL to connect.";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_SERVER_URL_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_ZENDESK_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_ZENDESK_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_OAUTH_TOKEN_CONF = "camel.sink.endpoint.oauthToken";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_OAUTH_TOKEN_DOC = "The OAuth token.";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_OAUTH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_PASSWORD_DOC = "The password.";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_TOKEN_CONF = "camel.sink.endpoint.token";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_TOKEN_DOC = "The security token.";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_USERNAME_CONF = "camel.sink.endpoint.username";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_USERNAME_DOC = "The user name.";
    public static final String CAMEL_SINK_ZENDESK_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_SERVER_URL_CONF = "camel.component.zendesk.serverUrl";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_SERVER_URL_DOC = "The server URL to connect.";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_SERVER_URL_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.zendesk.lazyStartProducer";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_ZENDESK_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.zendesk.autowiredEnabled";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_CONFIGURATION_CONF = "camel.component.zendesk.configuration";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_CONFIGURATION_DOC = "Component configuration";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_ZENDESK_CONF = "camel.component.zendesk.zendesk";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_ZENDESK_DOC = "To use a shared Zendesk instance.";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_ZENDESK_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_OAUTH_TOKEN_CONF = "camel.component.zendesk.oauthToken";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_OAUTH_TOKEN_DOC = "The OAuth token.";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_OAUTH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_PASSWORD_CONF = "camel.component.zendesk.password";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_PASSWORD_DOC = "The password.";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_TOKEN_CONF = "camel.component.zendesk.token";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_TOKEN_DOC = "The security token.";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_USERNAME_CONF = "camel.component.zendesk.username";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_USERNAME_DOC = "The user name.";
    public static final String CAMEL_SINK_ZENDESK_COMPONENT_USERNAME_DEFAULT = null;

    public CamelZendeskSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelZendeskSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_ZENDESK_PATH_METHOD_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_PATH_METHOD_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_ZENDESK_PATH_METHOD_NAME_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_IN_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_ENDPOINT_IN_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_IN_BODY_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_SERVER_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_ENDPOINT_SERVER_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_SERVER_URL_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_ZENDESK_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_ZENDESK_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_OAUTH_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_ENDPOINT_OAUTH_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_OAUTH_TOKEN_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_ENDPOINT_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_TOKEN_DOC);
        conf.define(CAMEL_SINK_ZENDESK_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_SERVER_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_SERVER_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_SERVER_URL_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_ZENDESK_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_ZENDESK_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_ZENDESK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_ZENDESK_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_OAUTH_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_OAUTH_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_OAUTH_TOKEN_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_TOKEN_DOC);
        conf.define(CAMEL_SINK_ZENDESK_COMPONENT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_ZENDESK_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_ZENDESK_COMPONENT_USERNAME_DOC);
        return conf;
    }
}