/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine;

import java.io.Serializable;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheListener {
    private static Log log = LogFactory.getLog(CacheListener.class);
    private static CacheListener myself;

    private CacheListener() {
    }

    public static void startUp() {
        if (myself == null) {
            myself = new CacheListener();
            myself.init();
        }
    }

    private void init() {
        MyListener listener = new MyListener();
        NotificationFilterSupport filter = null;
        try {
            InitialContext ic = new InitialContext();
            MBeanServerConnection server = (MBeanServerConnection)ic.lookup("jmx/invoker/RMIAdaptor");
            String cacheName = "rhq.cache:subsystem=alerts,service=cache";
            ObjectName mgmt_name = new ObjectName(cacheName);
            filter = new NotificationFilterSupport();
            filter.disableAllTypes();
            filter.enableType("org.jboss.cache.NodeCreated");
            filter.enableType("org.jboss.cache.NodeRemoved");
            filter.enableType("org.jboss.cache.NodeModified");
            server.addNotificationListener(mgmt_name, listener, (NotificationFilter)filter, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MyListener
    implements NotificationListener,
    Serializable {
        private MyListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            String message = notification.getMessage();
            String type = notification.getType();
            Object userData = notification.getUserData();
            System.out.println(type + ": " + message);
            if (userData == null) {
                System.out.println("notification data is null");
            } else if (userData instanceof String) {
                log.info((Object)("notification data: " + (String)userData));
            } else if (userData instanceof Object[]) {
                Object[] ud = (Object[])userData;
                for (int i = 0; i > ud.length; ++i) {
                    log.info((Object)("notification data: " + ud[i].toString()));
                }
            } else {
                log.info((Object)("notification data class: " + userData.getClass().getName()));
            }
        }
    }
}

