/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.domain.cloud.FailoverList;
import org.rhq.core.domain.cloud.FailoverListDetails;
import org.rhq.core.domain.cloud.PartitionEvent;
import org.rhq.core.domain.cloud.PartitionEventDetails;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.domain.cloud.composite.FailoverListDetailsComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.cloud.ServerBucket;
import org.rhq.enterprise.server.core.AgentManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class FailoverListManagerBean
implements FailoverListManagerLocal {
    private final Log log = LogFactory.getLog(FailoverListManagerBean.class);
    private static final double ACCEPTABLE_DISPARITY = 0.1;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    @IgnoreDependency
    CloudManagerLocal cloudManager;
    @EJB
    AgentManagerLocal agentManager;
    @EJB
    FailoverListManagerLocal failoverListManager;

    @Override
    public FailoverListComposite getExistingForSingleAgent(String agentName) {
        Agent agent = this.agentManager.getAgentByName(agentName);
        if (null == agent) {
            throw new IllegalArgumentException("No agent found for registration name: " + agentName);
        }
        return this.doGetExistingForSingleAgent(agent);
    }

    private FailoverListComposite doGetExistingForSingleAgent(Agent agent) {
        FailoverListComposite result = null;
        Query query = this.entityManager.createNamedQuery("FailoverList.getViaAgent");
        query.setParameter("agent", (Object)agent);
        try {
            FailoverList serverList = (FailoverList)query.getSingleResult();
            ArrayList<FailoverListComposite.ServerEntry> serverEntries = new ArrayList<FailoverListComposite.ServerEntry>();
            for (FailoverListDetails next : serverList.getServerList()) {
                serverEntries.add(next.getServer().getServerEntry());
            }
            result = new FailoverListComposite(serverEntries);
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    @Override
    public FailoverListComposite getForSingleAgent(PartitionEvent event, String agentName) {
        Agent agent = this.agentManager.getAgentByName(agentName);
        if (null == agent) {
            throw new IllegalArgumentException("No agent found for registration name: " + agentName);
        }
        FailoverListComposite result = this.doGetExistingForSingleAgent(agent);
        if (null == result) {
            result = this.generateServerList(event, agent);
        }
        return result;
    }

    private FailoverListComposite generateServerList(PartitionEvent event, Agent agent) {
        List<Server> servers = this.cloudManager.getAllCloudServers();
        ArrayList<Agent> agents = new ArrayList<Agent>(1);
        agents.add(agent);
        Query query = this.entityManager.createNamedQuery("FailoverListDetails.getAssignedLoads");
        List existingLoads = query.getResultList();
        Map<Agent, FailoverListComposite> agentServerListMap = this.getForAgents(event, servers, agents, existingLoads);
        this.persistComposites(event, agentServerListMap);
        return agentServerListMap.get(agent);
    }

    @Override
    public Map<Agent, FailoverListComposite> refresh(PartitionEvent event) {
        List<Server> servers = this.cloudManager.getAllCloudServers();
        List<Agent> agents = this.agentManager.getAllAgents();
        Map<Agent, FailoverListComposite> agentServerListMap = this.getForAgents(event, servers, agents, null);
        this.clear();
        this.persistComposites(event, agentServerListMap);
        return agentServerListMap;
    }

    @Override
    public Map<Agent, FailoverListComposite> refresh(PartitionEvent event, List<Server> servers, List<Agent> agents) {
        Map<Agent, FailoverListComposite> agentServerListMap = this.getForAgents(event, servers, agents, null);
        for (Agent next : agents) {
            this.deleteServerListsForAgent(next);
        }
        this.persistComposites(event, agentServerListMap);
        return agentServerListMap;
    }

    private Map<Agent, FailoverListComposite> getForAgents(PartitionEvent event, List<Server> servers, List<Agent> agents, List<FailoverListDetailsComposite> existingLoads) {
        HashMap<Agent, FailoverListComposite> result = new HashMap<Agent, FailoverListComposite>(agents.size());
        ArrayList<ServerBucket> buckets = new ArrayList<ServerBucket>(servers.size());
        for (Server next : servers) {
            buckets.add(new ServerBucket(next));
        }
        HashMap<Agent, List<ServerBucket>> agentServerListMap = new HashMap<Agent, List<ServerBucket>>(agents.size());
        for (Agent next : agents) {
            agentServerListMap.put(next, new ArrayList(servers.size()));
        }
        for (int level = 0; level < servers.size(); ++level) {
            this.initBuckets(buckets, existingLoads, level);
            for (Agent next : agents) {
                List serverList = (List)agentServerListMap.get(next);
                ServerBucket bestBucket = null;
                Collections.rotate(buckets, 1);
                bestBucket = 0 == level && null != next.getServer() ? ServerBucket.getBestBucket(buckets, serverList, next.getAffinityGroup(), next.getServer().getName()) : ServerBucket.getBestBucket(buckets, serverList, next.getAffinityGroup(), null);
                if (null == bestBucket) {
                    this.log.error((Object)"Unexpected Condition! null bucket in getForAllAgents()");
                    continue;
                }
                serverList.add(bestBucket);
                bestBucket.assignedLoad += this.getAgentLoad(next) / (double)bestBucket.computePower;
                bestBucket.assignedAgents.add(next);
            }
            if (!this.balanceLoad(buckets, agentServerListMap)) continue;
        }
        for (Agent next : agentServerListMap.keySet()) {
            ArrayList<FailoverListComposite.ServerEntry> serverEntries = new ArrayList<FailoverListComposite.ServerEntry>(servers.size());
            for (ServerBucket bucket : (List)agentServerListMap.get(next)) {
                serverEntries.add(bucket.serverEntry);
            }
            result.put(next, new FailoverListComposite(serverEntries));
        }
        return result;
    }

    private void initBuckets(List<ServerBucket> buckets, List<FailoverListDetailsComposite> existingLoads, int level) {
        block0: for (ServerBucket bucket : buckets) {
            bucket.assignedLoad = 0.0;
            bucket.assignedAgents.clear();
            if (null == existingLoads) continue;
            int serverId = bucket.server.getId();
            for (FailoverListDetailsComposite existingLoad : existingLoads) {
                if (existingLoad.ordinal != level || existingLoad.serverId != serverId) continue;
                bucket.assignedLoad = existingLoad.assignedAgentCount / (long)bucket.computePower;
                continue block0;
            }
        }
    }

    private boolean balanceLoad(List<ServerBucket> buckets, Map<Agent, List<ServerBucket>> agentServerListMap) {
        boolean done = false;
        boolean rebalanced = false;
        if (buckets.size() < 2) {
            return false;
        }
        block0: do {
            Collections.sort(buckets, new Comparator<ServerBucket>(){

                @Override
                public int compare(ServerBucket bucket1, ServerBucket bucket2) {
                    return bucket2.assignedLoad > bucket1.assignedLoad ? 1 : -1;
                }
            });
            ServerBucket lowBucket = buckets.get(buckets.size() - 1);
            if (this.getLoadDisparity(buckets.get((int)0).assignedLoad, lowBucket.assignedLoad) < 0.1) {
                done = true;
                continue;
            }
            for (ServerBucket bucket : buckets) {
                if (bucket == lowBucket) {
                    done = true;
                    continue block0;
                }
                AffinityGroup affinityGroup = bucket.server.getAffinityGroup();
                boolean checkAffinity = null != affinityGroup && !affinityGroup.equals((Object)lowBucket.server.getAffinityGroup());
                int highIndex = -1;
                double highLoad = 0.0;
                double load = 0.0;
                int size = bucket.assignedAgents.size();
                for (int i = 0; i < size; ++i) {
                    Agent agent = bucket.assignedAgents.get(i);
                    if (checkAffinity && affinityGroup.equals((Object)agent.getAffinityGroup()) || agentServerListMap.get(agent).contains(lowBucket) || !((load = this.getAgentLoad(agent)) > highLoad) || lowBucket.assignedLoad + load > bucket.assignedLoad - load) continue;
                    highIndex = i;
                    highLoad = load;
                }
                if (highIndex <= -1) continue;
                Agent agent = bucket.assignedAgents.remove(highIndex);
                lowBucket.assignedAgents.add(agent);
                agentServerListMap.get(agent).remove(bucket);
                agentServerListMap.get(agent).add(lowBucket);
                lowBucket.assignedLoad += highLoad;
                bucket.assignedLoad -= highLoad;
                rebalanced = true;
                continue block0;
            }
        } while (!done);
        return rebalanced;
    }

    private double getLoadDisparity(Double highLoad, Double lowLoad) {
        return (highLoad - lowLoad) / highLoad;
    }

    private double getAgentLoad(Agent agent) {
        if (null == agent) {
            return 0.0;
        }
        return 1.0;
    }

    private void logServerList(String debugTitle, Map<Agent, List<ServerBucket>> agentServerListMap) {
        StringBuilder sb = new StringBuilder("\nServerList (");
        sb.append(debugTitle);
        sb.append(") :");
        for (Agent agent : agentServerListMap.keySet()) {
            sb.append("\n\n Agent: " + agent.getName());
            for (ServerBucket bucket : agentServerListMap.get(agent)) {
                sb.append("\n   ");
                sb.append(bucket.assignedLoad);
                sb.append(" : ");
                sb.append(bucket.server.getName());
            }
        }
        sb.append("\n\n");
        System.out.println(sb.toString());
        this.log.info((Object)sb.toString());
    }

    @Override
    public void deleteServerListsForAgent(Agent agent) {
        Query query1 = this.entityManager.createNamedQuery("FailoverListDetails.deleteViaAgent");
        Query query2 = this.entityManager.createNamedQuery("FailoverList.deletViaAgent");
        query1.setParameter("agent", (Object)agent);
        query2.setParameter("agent", (Object)agent);
        query1.executeUpdate();
        query2.executeUpdate();
    }

    @Override
    public void deleteServerListDetailsForServer(int serverId) {
        Query query = this.entityManager.createNamedQuery("FailoverListDetails.deleteViaServer");
        query.setParameter("serverId", (Object)serverId);
        query.executeUpdate();
    }

    private void clear() {
        Query query = this.entityManager.createNamedQuery("FailoverListDetails.truncate");
        query.executeUpdate();
        query = this.entityManager.createNamedQuery("FailoverList.truncate");
        query.executeUpdate();
    }

    private void persistComposites(PartitionEvent event, Map<Agent, FailoverListComposite> agentServerListMap) {
        FailoverList fl = null;
        FailoverListDetails failoverListDetails = null;
        PartitionEventDetails eventDetails = null;
        for (Map.Entry<Agent, FailoverListComposite> next : agentServerListMap.entrySet()) {
            Agent nextAgent = next.getKey();
            FailoverListComposite nextComposite = next.getValue();
            fl = new FailoverList(event, nextAgent);
            this.entityManager.persist((Object)fl);
            boolean first = true;
            for (int i = 0; i < nextComposite.size(); ++i) {
                FailoverListComposite.ServerEntry serverEntry = nextComposite.get(i);
                Server server = (Server)this.entityManager.find(Server.class, (Object)serverEntry.serverId);
                failoverListDetails = new FailoverListDetails(fl, i, server);
                this.entityManager.persist((Object)failoverListDetails);
                if (!first) continue;
                eventDetails = new PartitionEventDetails(event, nextAgent, server);
                this.entityManager.persist((Object)eventDetails);
                first = false;
            }
        }
    }
}

