/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail.attributes.code;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.gjt.jclasslib.browser.detail.attributes.code.ByteCodeDisplay;

public class CounterDisplay
extends JPanel {
    private static final Map STYLE;
    private static final Color COLOR_BACKGROUND;
    private int maxCount;
    private int lineHeight;
    private int ascent;
    private int maxChars;
    private FontRenderContext frc;

    public CounterDisplay() {
        this.setBorder(ByteCodeDisplay.BORDER);
        this.setDoubleBuffered(false);
        this.setOpaque(false);
    }

    public void init(ByteCodeDisplay byteCodeDisplay) {
        this.maxCount = byteCodeDisplay.getLineCount();
        this.lineHeight = byteCodeDisplay.getLineHeight();
        this.ascent = byteCodeDisplay.getAscent();
        this.frc = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        this.maxChars = Math.max(1, String.valueOf(this.maxCount).length());
        TextLayout textLayout = new TextLayout(this.getCharacterIterator(this.maxCount), this.frc);
        this.setPreferredSize(new Dimension((int)textLayout.getAdvance() + 6, this.maxCount * this.lineHeight + 6));
        this.invalidate();
    }

    private AttributedCharacterIterator getCharacterIterator(int n) {
        AttributedString attributedString = new AttributedString(ByteCodeDisplay.getPaddedValue(n, this.maxChars), STYLE);
        return attributedString.getIterator();
    }

    protected void paintComponent(Graphics graphics) {
        if (this.maxCount == 0 || this.lineHeight == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(3, 3);
        Rectangle rectangle = graphics.getClipBounds();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(COLOR_BACKGROUND);
        graphics2D.fill(rectangle);
        graphics2D.setPaint(paint);
        int n = Math.max(0, rectangle.y / this.lineHeight - 1);
        int n2 = Math.min(this.maxCount, (rectangle.y + rectangle.height) / this.lineHeight + 1);
        for (int i = n; i < n2; ++i) {
            TextLayout textLayout = new TextLayout(this.getCharacterIterator(i + 1), this.frc);
            textLayout.draw(graphics2D, 0.0f, i * this.lineHeight + this.ascent);
        }
        graphics2D.translate(-3, -3);
    }

    static {
        COLOR_BACKGROUND = UIManager.getColor("Panel.background");
        Font font = UIManager.getFont("TextArea.font");
        STYLE = new HashMap(3);
        STYLE.put(TextAttribute.FAMILY, font.getFamily());
        STYLE.put(TextAttribute.SIZE, new Float(font.getSize() - 2));
        STYLE.put(TextAttribute.FOREGROUND, new Color(92, 92, 92));
    }
}

