/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.dom.DOMEmitter;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TEXTEmitter;
import net.sf.saxon.event.UncommittedEmitter;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResultWrapper {
    public static Receiver getReceiver(Result result, NamePool namePool, Properties properties, HashMap hashMap) throws TransformerException {
        if (result instanceof Emitter) {
            ((Emitter)result).setOutputProperties(properties);
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            return (Receiver)result;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            contentHandlerProxy.setNamePool(namePool);
            return contentHandlerProxy;
        }
        if (result instanceof StreamResult) {
            Object object;
            Object object2;
            Object object3;
            Emitter emitter = null;
            ProxyReceiver proxyReceiver = null;
            String string = properties.getProperty("method");
            String string2 = properties.getProperty("{http://saxon.sf.net/}use-character-maps");
            if (string2 != null && hashMap != null) {
                object3 = new ArrayList();
                object2 = new StringTokenizer(string2);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object2).nextToken();
                    int n = namePool.getFingerprintForExpandedName(string3);
                    HashMap hashMap2 = (HashMap)hashMap.get(new Integer(n));
                    if (hashMap2 == null) {
                        throw new TransformerException("Character map '" + string3 + "' has not been defined");
                    }
                    object3.add(hashMap2);
                }
                if (object3.size() > 0) {
                    proxyReceiver = new CharacterMapExpander();
                    ((CharacterMapExpander)proxyReceiver).setCharacterMaps((List)object3);
                }
            }
            if (string == null) {
                emitter = new UncommittedEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if (proxyReceiver != null) {
                    proxyReceiver.setUnderlyingReceiver((Receiver)object);
                    object = proxyReceiver;
                }
            } else if (string.equals("html")) {
                emitter = new HTMLEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if (!"no".equals(properties.getProperty("indent"))) {
                    object3 = new HTMLIndenter();
                    ((ProxyReceiver)object3).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object3).setNamePool(namePool);
                    ((HTMLIndenter)object3).setOutputProperties(properties);
                    object = object3;
                }
                if (proxyReceiver != null) {
                    proxyReceiver.setUnderlyingReceiver((Receiver)object);
                    object = proxyReceiver;
                }
            } else if (string.equals("xml")) {
                emitter = new XMLEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if ("yes".equals(properties.getProperty("indent"))) {
                    object3 = new XMLIndenter();
                    ((ProxyReceiver)object3).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object3).setNamePool(namePool);
                    ((XMLIndenter)object3).setOutputProperties(properties);
                    object = object3;
                }
                if (proxyReceiver != null) {
                    proxyReceiver.setUnderlyingReceiver((Receiver)object);
                    object = proxyReceiver;
                }
                if ((object3 = properties.getProperty("cdata-section-elements")) != null && ((String)object3).length() > 0) {
                    object2 = new CDATAFilter();
                    ((ProxyReceiver)object2).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object2).setNamePool(namePool);
                    ((CDATAFilter)object2).setOutputProperties(properties);
                    object = object2;
                }
            } else if (string.equals("xhtml")) {
                emitter = new XHTMLEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if ("yes".equals(properties.getProperty("indent"))) {
                    object3 = new HTMLIndenter();
                    ((ProxyReceiver)object3).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object3).setNamePool(namePool);
                    ((HTMLIndenter)object3).setOutputProperties(properties);
                    object = object3;
                }
                if (proxyReceiver != null) {
                    proxyReceiver.setUnderlyingReceiver((Receiver)object);
                    object = proxyReceiver;
                }
                if ((object3 = properties.getProperty("cdata-section-elements")) != null && ((String)object3).length() > 0) {
                    object2 = new CDATAFilter();
                    ((ProxyReceiver)object2).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object2).setNamePool(namePool);
                    ((CDATAFilter)object2).setOutputProperties(properties);
                    object = object2;
                }
            } else if (string.equals("text")) {
                emitter = new TEXTEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if (proxyReceiver != null) {
                    proxyReceiver.setUnderlyingReceiver((Receiver)object);
                    object = proxyReceiver;
                }
            } else {
                int n = string.indexOf(125);
                object2 = string.substring(n + 1);
                int n2 = ((String)object2).indexOf(58);
                object2 = ((String)object2).substring(n2 + 1);
                emitter = Emitter.makeEmitter((String)object2);
                emitter.setNamePool(namePool);
                object = emitter;
            }
            if (emitter != null) {
                emitter.setOutputProperties(properties);
                StreamResult streamResult = (StreamResult)result;
                emitter.setStreamResult(streamResult);
            }
            return object;
        }
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            if (node != null) {
                if (node instanceof NodeInfo) {
                    if (node instanceof DocumentInfo) {
                        DocumentInfo documentInfo = (DocumentInfo)((Object)node);
                        if (node.getFirstChild() != null) {
                            throw new TransformerException("Target document must be empty");
                        }
                        Builder builder = documentInfo instanceof DocumentImpl ? new TreeBuilder() : new TinyBuilder();
                        builder.setRootNode(documentInfo);
                        builder.setSystemId(result.getSystemId());
                        builder.setNamePool(namePool);
                        return builder;
                    }
                    throw new TransformerException("Cannot add to an existing Saxon document");
                }
                DOMEmitter dOMEmitter = new DOMEmitter();
                dOMEmitter.setSystemId(result.getSystemId());
                dOMEmitter.setNamePool(namePool);
                dOMEmitter.setNode(node);
                return dOMEmitter;
            }
            TinyBuilder tinyBuilder = new TinyBuilder();
            tinyBuilder.setSystemId(result.getSystemId());
            tinyBuilder.setNamePool(namePool);
            tinyBuilder.createDocument();
            Document document = (Document)((Object)tinyBuilder.getCurrentDocument());
            ((DOMResult)result).setNode(document);
            return tinyBuilder;
        }
        throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
    }
}

