/*******************************************************************************
 * Copyright (c) 2007 Exadel, Inc. and Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Exadel, Inc. and Red Hat, Inc. - initial API and implementation
 ******************************************************************************/ 
package org.jboss.tools.hibernate.wizard.hibernatecachewizard.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.jboss.tools.hibernate.wizard.hibernatecachewizard.HibernateCacheWizard;
import org.jboss.tools.hibernate.wizard.hibernatecachewizard.datamodel.*;



public class CommonCachedPage extends WizardPage 

{
	protected Button							ToCache						= null;
	protected Button							AllToCache					= null;
	protected Button							FromCache					= null;
	protected Button							AllFromCache				= null;
	protected CommonTreeViewer					CachedTreeViewer			= null;
	protected HibernateCacheWizardMouseListener MListener 					= new HibernateCacheWizardMouseListener();
	protected HibernateCacheWizard				CallBack					= null;
	protected CacheContextMenuListener			CMListener					= new CacheContextMenuListener();
	private   String							DescriptionInit;
	protected String 							cacheConcurrencyStrategy;	
	protected ListViewer						InitialViewer,	CachedViewer;
	protected HashSet Incoming;
	protected HashSet<String> Cached;
	protected Menu								CacheContextMenu;
	protected ListDataModelContentProvider		ListContentProvider;
	protected ListSorter						Sorter;

	public CommonCachedPage(String pagetitle, final String descrinit, final String descrcomp)

	{
		super(pagetitle);
		DescriptionInit 			= descrinit;
		cacheConcurrencyStrategy 	= ICacheable.bundle.getString("HibernateCacheWizard.transactional");// default param.
	}

	public void createControl(Composite parent) 
	{}

	protected void setLayout(Composite comp)
	{}

	protected void createPageElements(Composite parent)
	{
		createInitialTreeDescriptor(parent);
		createInitilaTreeViewer(parent);
		createControlButtons(parent);		
		createComposedTreeDescriptor(parent);
		createComposedTreeViewer(parent);
	}

	protected void createInitialTreeDescriptor(Composite parent)
	{
		Label description = new Label(parent,SWT.NONE);
		description.setText(DescriptionInit);
	}

	protected GridData calculateTreeViewerSize(int dimension)
	{
		Rectangle clientarea = getShell().getClientArea();
		int height = (clientarea.height * 40) / 100;
		int width = (clientarea.height * 40) / 100; 
		GridData data = new GridData(dimension);
		switch (dimension)
		{
		case GridData.FILL_BOTH:
			data.heightHint = height;
			data.widthHint	= width;
			break;
		case GridData.FILL_HORIZONTAL:
			data.heightHint = height;
			break;
		case GridData.FILL_VERTICAL:
			data.widthHint	= width;
			break;
		default:// incorrect fill parameter!
			break;
		}
		return data;
	}

	protected void createInitilaTreeViewer(Composite parent)
	{}	
	protected void createControlButtons(Composite parent)
	{
		Group buttonsform = new Group(parent, SWT.NONE);
		GridLayout gridlayout = new GridLayout();
		gridlayout.numColumns = 1;
		buttonsform.setLayout(gridlayout);

		GridData gdata = new GridData(GridData.FILL_HORIZONTAL);
		int style = SWT.PUSH | SWT.CENTER;
		
		ToCache = createButton(buttonsform,style, SWT.CENTER,
					"HibernateCacheWizard.ADD_TO_CACHE_TEXT",gdata);
		AllToCache = createButton(buttonsform,style, SWT.CENTER,
					"HibernateCacheWizard.ADD_ALL_TO_CACHE_TEXT",gdata);
		FromCache = createButton(buttonsform,style, SWT.CENTER,
				"HibernateCacheWizard.REMOVE_FROM_CACHE_TEXT",gdata);
		AllFromCache = createButton(buttonsform,style, SWT.CENTER,
				"HibernateCacheWizard.REMOVE_ALL_FROM_CACHE_TEXT",gdata);
		if(ToCache != null)
		{
			ToCache.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent event) { processAddToCacheButtonPressed();   }
	        });
		}
		
		if(AllToCache != null)
		{
			AllToCache.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent event) { processAddAllToCacheButtonPressed();   }
	        });
		}
		
		if(FromCache != null)
		{
			FromCache.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent event) { processRemoveFromCachePressed();   }
	        });
		}
		
		if(AllFromCache != null)
		{
			AllFromCache.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent event) { processRemoveAllFromCachePressed();   }
	        });
		}
		buttonsform.pack();
		enableControlButtons(false);
	}
	protected Button createButton(Group btngroup, int style, int alignment, String text, GridData gdata)
	{
		Button thebutton = new Button(btngroup,style);
		thebutton.setAlignment(alignment);
		thebutton.setText(ICacheable.bundle.getString(text));
		thebutton.setFont(JFaceResources.getDialogFont());
		thebutton.setLayoutData(gdata);
		thebutton.pack();
		 return thebutton;
	}
	
	protected void enableControlButtons(boolean state)
	{
		boolean alltocache 		= false;
		boolean allfromcache 	= false;
		if( InitialViewer != null)
		{
			List initiallist = InitialViewer.getList();
			alltocache = initiallist != null && initiallist.getItems().length > 0 ? true : false;
		}

		if(CachedViewer != null)
		{
			List cachedlist = CachedViewer.getList();
			allfromcache = cachedlist != null && cachedlist.getItems().length > 0 ? true : false;
		}
		AllFromCache.setEnabled(allfromcache);
		FromCache.setEnabled(state);
		AllToCache.setEnabled(alltocache);
		ToCache.setEnabled(state);
	}
	public void setDefaultSelectionForList(boolean initial, boolean relevant)
	{
		ListViewer lwtemp = (initial) ? InitialViewer : CachedViewer;
		if(lwtemp == null || lwtemp.getList() == null || lwtemp.getList().getItems() == null) 	return;
		if(lwtemp.getList().getItems().length > 0)
		{		lwtemp.setSelection(new StructuredSelection(lwtemp.getElementAt(0)), relevant);}
	}

	public ListViewer getInitialViewer()
	{	return InitialViewer;			}
	
	public ListViewer getCachedViewer()
	{	return CachedViewer;			}
	
	protected void createComposedTreeDescriptor(Composite parent){}

	protected void createComposedTreeViewer(Composite parent)
	{
		CachedTreeViewer = new CommonTreeViewer(parent);
	}

	protected void processAddToCacheButtonPressed(){}

	protected void processAddAllToCacheButtonPressed(){}

	protected void processRemoveFromCachePressed(){}

	protected void processRemoveAllFromCachePressed(){}

	protected void createPopupMenu()
	{
		CacheContextMenu = new Menu(this.getShell(),SWT.POP_UP);
		MenuItem item1 = new MenuItem(CacheContextMenu,SWT.RADIO);
		MenuItem item2 = new MenuItem(CacheContextMenu,SWT.RADIO);
		MenuItem item3 = new MenuItem(CacheContextMenu,SWT.RADIO);
		MenuItem item4 = new MenuItem(CacheContextMenu,SWT.RADIO);

		item1.setSelection(true);
		item1.setText(ICacheable.bundle.getString("HibernateCacheWizard.transactional"));
		item2.setText(ICacheable.bundle.getString("HibernateCacheWizard.readwrite"));
		item3.setText(ICacheable.bundle.getString("HibernateCacheWizard.nonstrict-read-write"));
		item4.setText(ICacheable.bundle.getString("HibernateCacheWizard.read-only"));
		item1.addListener(SWT.Selection, CMListener);
		item2.addListener(SWT.Selection, CMListener);
		item3.addListener(SWT.Selection, CMListener);
		item4.addListener(SWT.Selection, CMListener);
	}

	/**
	 *  Add item to cache or remove item from cache. 
	 * @param name - name of item;
	 * @param param - cacheable parameter (concurrency strategy). if <param> == null remove item from cache.
	 */

	protected void itemAddRemoveCache(String name, String param, boolean strategy){}
	protected void updateUI(){}
	protected void updateInitialViewer(){}
	protected void updateComposedViewer(){}
	protected void WriteToCache(String name){}

	/**
	 * Change cacheConcurrencyStrategy for cached items.
	 */
	private void changeCachedStrategy()
	{
		InitialViewer.getList().deselectAll();
		if(CachedViewer.getControl().isFocusControl())// if list of cached items focused
		{// get selection;
			IStructuredSelection selection = (IStructuredSelection)CachedViewer.getSelection();
			int index = CachedViewer.getList().getSelectionIndex();
			Iterator it = selection.iterator();
			while(it.hasNext())
			{
				String oldname = (String)it.next();
				String newname = setNewCachedStrategy(oldname);
				if(oldname.equals(newname))// strategy will not changed.
					continue;
				Cached.remove(oldname);
				Cached.add(newname);
				updateComposedViewer();
				WriteToCache(newname);
			}
			CachedViewer.getList().setSelection(index);
			CachedViewer.setSelection(new StructuredSelection(CachedViewer.getList().getItem(index)));
			processButtonsState();
		}
	}

	/**
	 * 
	 * @param itemname - name of selected item with old cached strategy;
	 * @return - name of selected item with new cached strategy;
	 */
	private String setNewCachedStrategy(String itemname)
	{
		String[] splits = itemname.split(ICacheable.bundle.getString("HibernateCacheWizard.CACHED_STRATEGY_TOKEN"));
		itemname = "";									
		itemname = splits[0]; 							// set name of item
		itemname += ICacheable.bundle.getString("HibernateCacheWizard.CACHED_STRATEGY_TOKEN"); 	// add tokenizer
		itemname += cacheConcurrencyStrategy;			// add new cached strategy;
		itemAddRemoveCache(splits[0], cacheConcurrencyStrategy,true);
		return itemname;
	}

	private void clearContexMenuSelection()
	{
		if(CacheContextMenu == null || CacheContextMenu.getItems() == null) return;
		MenuItem[] items = CacheContextMenu.getItems();
		for(int i = 0; i < items.length; i++)
		{
			items[i].setSelection(false);
		}
	}
	
	protected void processButtonsState()
	{
		processSingleButtons();
		processGroupButtons();
	}
	protected void processSingleButtons()
	{
		boolean 			issel 	= false;
		StructuredSelection sel 	= null;
		if(InitialViewer != null)
		{
			sel = (StructuredSelection)InitialViewer.getSelection();
			issel = (sel.size() < 1) ? false : true; 
		}
		ToCache.setEnabled(issel);
		if(CachedViewer != null)
		{
			sel = (StructuredSelection)CachedViewer.getSelection();
			issel = (sel.size() < 1) ? false : true;
		}
		FromCache.setEnabled(issel);
	}
	protected void processGroupButtons()
	{
		boolean allcache 		= false;

		if( InitialViewer != null)
		{
			List initiallist = InitialViewer.getList();
			allcache = initiallist != null && initiallist.getItems().length > 0 ? true : false;
		}
		AllToCache.setEnabled(allcache);
		
		if(CachedViewer != null)
		{
			List cachedlist = CachedViewer.getList();
			allcache = cachedlist != null && cachedlist.getItems().length > 0 ? true : false;
		}
		AllFromCache.setEnabled(allcache);
	}

	protected class CacheContextMenuListener implements Listener
	{
		public void handleEvent(Event event) 
		{
			clearContexMenuSelection();
			cacheConcurrencyStrategy = ((MenuItem)event.widget).getText();
			((MenuItem)event.widget).setSelection(true);
			changeCachedStrategy();
			// clear any menu selection.
			//clearContexMenuSelection();
		}
	}

	protected class HibernateCacheWizardSelectionListener implements ISelectionChangedListener
	{
		public void selectionChanged(SelectionChangedEvent event) 
		{
			StructuredSelection sel = (StructuredSelection)event.getSelection();
			if(sel.size() < 1)						// if have not selected items - do nothing.
				{	enableControlButtons(false);
					return;		
				}
			// user set selection
			
			processButtonsState();
			clearContexMenuSelection();
			if(sel.size() == 1)						// selected single item; get his strategy.
			{
				String[] splits = ((String)sel.getFirstElement()).split(ICacheable.bundle.getString("HibernateCacheWizard.CACHED_STRATEGY_TOKEN"));
				if(splits.length == 1)
				{// name of item don't contain cache strategy.
					// selected items from initial list.
					// set flag selection of initial list 
					if(CacheContextMenu != null && CacheContextMenu.getItems()[0] != null)
						{		CacheContextMenu.getItems()[0].setSelection(true);			}// select first  item.
				}
				else
				{// name of item contain cache strategy.
					checkItemStrategy(splits[1]);
				}
			}
			else									// multiple selection. dont set any selection.
			{}
			
		}
		private void checkItemStrategy(String strategy)
		{
			MenuItem[] items = CacheContextMenu.getItems();
			for(int i = 0; i < items.length; i++)
			{
				if(items[i].getText().equals(strategy))
				{
					items[i].setSelection(true);
					break;
				}
			}
		}
	}

	protected class HibernateCacheWizardPopUpMenuReadWrite extends Action
	{
		public HibernateCacheWizardPopUpMenuReadWrite ()
		{			
			super(ICacheable.bundle.getString("HibernateCacheWizard.readwrite"),AS_RADIO_BUTTON);		
			super.setChecked(false);
		}
		public void run()
		{
			cacheConcurrencyStrategy = ICacheable.bundle.getString("HibernateCacheWizard.readwrite");
			changeCachedStrategy();
		}
	};

	protected class HibernateCacheWizardPopUpMenuTransactional extends Action
	{
		public HibernateCacheWizardPopUpMenuTransactional ()
		{	
			super(ICacheable.bundle.getString("HibernateCacheWizard.transactional"), AS_RADIO_BUTTON);		
			super.setChecked(true);
			cacheConcurrencyStrategy = ICacheable.bundle.getString("HibernateCacheWizard.transactional"); 
		}
		public void run()
		{
			cacheConcurrencyStrategy = ICacheable.bundle.getString("HibernateCacheWizard.transactional");
			changeCachedStrategy();
		}
	};

	protected class HibernateCacheWizardPopUpMenuNonstrictReadWrite extends Action
	{
		public HibernateCacheWizardPopUpMenuNonstrictReadWrite ()
		{			
			super(ICacheable.bundle.getString("HibernateCacheWizard.nonstrict-read-write"),AS_RADIO_BUTTON);
			super.setChecked(false);
		}
		public void run()
		{
			cacheConcurrencyStrategy = ICacheable.bundle.getString("HibernateCacheWizard.nonstrict-read-write");
			changeCachedStrategy();
		}
	};

	protected class HibernateCacheWizardPopUpMenuReadOnly extends Action
	{
		public HibernateCacheWizardPopUpMenuReadOnly ()
		{
			super(ICacheable.bundle.getString("HibernateCacheWizard.read-only"),AS_RADIO_BUTTON);
			super.setChecked(false);
		}
		public void run()
		{
			cacheConcurrencyStrategy = ICacheable.bundle.getString("HibernateCacheWizard.read-only");
			changeCachedStrategy();
		}
	};



	protected class HibernateCacheWizardMouseListener implements MouseListener
	{
		public void mouseDoubleClick(MouseEvent e) 
		{
			//mouseDown(e);
		}
		public void mouseDown(MouseEvent e) 
		{
			if (e.getSource() instanceof Button) 
			{// button pressed
				processButtonPressed((Button)e.getSource());
			}
			if(e.getSource() instanceof Table)
			{
			}
		}
		public void mouseUp(MouseEvent e) 
		{}

		private void processButtonPressed(Button btnevent)
		{
			if(btnevent.getText().equals(ICacheable.bundle.getString("HibernateCacheWizard.ADD_TO_CACHE_TEXT")))
			{
				processAddToCacheButtonPressed();
				processButtonsState();
			}
			else if(btnevent.getText().equals(ICacheable.bundle.getString("HibernateCacheWizard.ADD_ALL_TO_CACHE_TEXT")))
			{
				processAddAllToCacheButtonPressed();
			}
			else if(btnevent.getText().equals(ICacheable.bundle.getString("HibernateCacheWizard.REMOVE_FROM_CACHE_TEXT")))
			{
				processRemoveFromCachePressed();
				processButtonsState();
			}
			else if(btnevent.getText().equals(ICacheable.bundle.getString("HibernateCacheWizard.REMOVE_ALL_FROM_CACHE_TEXT")))
			{
				processRemoveAllFromCachePressed();
			}
			else
			{
				// unsupported button pressed;
			}
		}
	}
	

	protected class ListDataModelContentProvider implements IStructuredContentProvider
	{
		public void dispose(){}

		public Object[] getElements(Object inputElement) 
		{
			return ((Set)inputElement).toArray();
		}
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput){}
	};

	protected class ListSorter extends ViewerSorter
	{
		public int compare(Viewer viewer, Object e1, Object e2) 
		{
			// edit tau 12.01.2005
			//return ((String)e1).compareTo(e2);
			return ((String)e1).compareTo((String) e2);			
		}
	};

	protected class ListDataModelLabelProvider extends LabelProvider
	{
		public String getText(Object element) 
		{
			return ((ListDataModel)element).getName();
		}
	}

	protected class TreeSorter extends ViewerSorter
	{
		public int compare(Viewer viewer, Object e1, Object e2) 
		{
			String name1 = ((TreeDataModel)e1).getName();
			String name2 = ((TreeDataModel)e2).getName();
			return name1.compareTo(name2);
		}
	}

}

