//$Id: AddressId.java 5701 2008-01-15 09:51:16 -0500 (Tue, 15 Jan 2008) dgeraskov $
package mapping.typedonetoone;

import java.io.Serializable;

/**
 * @author Gavin King
 */
public class AddressId implements Serializable {
	private String type;
	private String customerId;
	
	public AddressId(String type, String customerId) {
		this.customerId = customerId;
		this.type = type;
	}
	
	public AddressId() {}
	
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getCustomerId() {
		return customerId;
	}
	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}
	public boolean equals(Object other) {
		if ( !(other instanceof AddressId) ) return false;
		AddressId add = (AddressId) other;
		return type.equals(add.type) && customerId.equals(add.customerId);
	}
	public int hashCode() {
		return customerId.hashCode() + type.hashCode();
	}

}
