/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.jbpm.gd.jpdl.ui.JpdlConstants;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPartFactory;


public class JpdlModelGraphicalViewer extends ScrollingGraphicalViewer {
	
	private PropertySheetPage propertySheetPage;
	private JpdlEditor editor;
	
	public JpdlModelGraphicalViewer(JpdlEditor editor) {
		this.editor = editor;
		editor.getSelectionSynchronizer().addViewer(this);
		setKeyHandler(new GraphicalViewerKeyHandler(this));
		setRootEditPart(new ScalableFreeformRootEditPart());
		prepareGrid();
	}

	private void prepareGrid() {
		getLayerManager().getLayer(LayerConstants.GRID_LAYER).setForegroundColor(JpdlConstants.veryLightBlue);
		editor.getActionRegistry().registerAction(new ToggleGridAction(this));
	}
	
	public void createControl(SashForm parent) {
		initControl(parent);
		initEditDomain(parent);
		initSite(parent);
		initEditPartFactory(parent);
		initContents(parent);
		initPropertySheetPage(parent);
	}
	
	private void initControl(SashForm parent) {
		super.createControl(parent);
		getControl().setBackground(ColorConstants.white);
		// TODO create a context meny whithout the nasty 'run as' and 'debug as' entries
		ContextMenuProvider provider = new JpdlContextMenuProvider(this, editor.getActionRegistry());
		setContextMenu(provider);
		editor.getSite().registerContextMenu("org.jbpm.gd.jpdl.ui.graph.context", provider, this);
	}
	
	private void initEditDomain(SashForm parent) {
		EditDomain editDomain = editor.getEditDomain();
		editDomain.addViewer(this);
	}
	
	private void initSite(SashForm parent) {
		IWorkbenchPartSite site = editor.getGraphPage().getSite();
		site.setSelectionProvider(this);
	}
	
	private void initEditPartFactory(SashForm parent) {
		setEditPartFactory(new NotationElementGraphicalEditPartFactory());
	}
	
	private void initContents(SashForm parent) {
		setContents(editor.getProcessDefinitionContainer());
	}
	
	private void initPropertySheetPage(SashForm parent) {
		CommandStack commandStack = editor.getCommandStack();
		IPropertySheetEntry rootEntry = new UndoablePropertySheetEntry(commandStack);
		setPropertySheetPage(new PropertySheetPage());
		getPropertySheetPage().setRootEntry(rootEntry);
	}
	
	private void setPropertySheetPage(PropertySheetPage propertySheetPage) {
		this.propertySheetPage = propertySheetPage;
	}
	
	PropertySheetPage getPropertySheetPage() {
		return propertySheetPage;
	}
	
	public Dimension getDimension() {
		Rectangle rectangle = getControl().getBounds();
		return new Dimension(rectangle.width, rectangle.height);
	}
	
	public FigureCanvas getFigureCanvas() {
		return super.getFigureCanvas();
	}
	
}
