/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.graph.part;

import java.beans.PropertyChangeEvent;
import java.util.Observable;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.jbpm.gd.common.figure.EdgeFigure;
import org.jbpm.gd.common.figure.LabelFigure;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.ui.policy.TransitionLabelDirectEditPolicy;
import org.jbpm.gd.jpdl.ui.policy.TransitionLabelGraphicalNodeEditPolicy;

public class LabelGraphicalEditPart 
	extends AbstractNotationElementGraphicalEditPart {
	
	private DirectEditManager manager;
	
	public LabelGraphicalEditPart(AbstractNotationElement notationElement) {
		super(notationElement);
	}
	
//	public Transition getTransition() {
//		return (Transition)getParent().getModel();
//	}
//	
//	private TransitionLabel getTransitionLabel() {
//		return (TransitionLabel)getModel();
//	}
//	
//	private String getTransitionLabelText() {
//		String result = getTransition().getName();
//		return result == null ? "" : result;
//	}

	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy("DirectEditPolicy", new TransitionLabelDirectEditPolicy());
		installEditPolicy("GraphicalNodeEditPolciy", new TransitionLabelGraphicalNodeEditPolicy());
	}
	
	protected IFigure createFigure() {
		LabelFigure result = new LabelFigure();
		result.setText(((Label)getNotationElement()).getText());
		return new LabelFigure();
	}

	protected void refreshVisuals() {
		String text = ((Label)getNotationElement()).getText();
		EdgeGraphicalEditPart parent = (EdgeGraphicalEditPart)getParent(); 									                      
		EdgeFigure edgeFigure = (EdgeFigure)parent.getFigure();
		Point offset = ((Label)getNotationElement()).getOffset();
		if (offset == null) {
			offset = calculateInitialOffset(edgeFigure);
			((Label)getNotationElement()).setOffset(offset);
		}
		LabelFigure figure = (LabelFigure)getFigure();
		figure.setText(text);
		LabelConstraint constraint = 
			new LabelConstraint(text, offset, edgeFigure);
		parent.setLayoutConstraint(this,getFigure(),constraint);	  
	}
	
	private Point calculateInitialOffset(EdgeFigure transitionFigure) {
		Point result = new Point(5, -10);
		Point start = transitionFigure.getStart();
		Point end = transitionFigure.getEnd();
		Point mid = start.getNegated().getTranslated(end).getScaled(0.5);
		if (mid.x < -10) {
			result.y = 10;
		}
		return result;
	}
		  
	public DragTracker getDragTracker(Request request) {
		return new LabelTracker(this,(EdgeGraphicalEditPart)getParent()); 	
	}
		  
	private void performDirectEdit() {
		if (manager == null) {
			initializeManager();
		}
		manager.show();
	}
	
	private void initializeManager() {
		LabelCellEditorLocator locator = new LabelCellEditorLocator((LabelFigure)getFigure());
		manager = new LabelDirectEditManager(this, TextCellEditor.class, locator);
	}

	public void performRequest(Request request) {
		if (request.getType() == RequestConstants.REQ_DIRECT_EDIT)
			performDirectEdit();
	}
	
	public void update(Observable arg0, Object arg1) {
		refreshVisuals();		
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("text")
				|| eventName.equals("offset")) {
			refreshVisuals();
		} 
	}
	
}
