/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.ui.JpdlPlugin;
import org.jbpm.gd.jpdl.ui.JpdlSharedImages;

public class ProcessDefinitionOutlineEditPart 
extends JpdlElementOutlineEditPart {

	public ProcessDefinitionOutlineEditPart(ProcessDefinition processDefinition) {
		super(processDefinition);
	}

	public ProcessDefinition getProcessDefinition() {
		return (ProcessDefinition) getModel();
	}

	protected List getModelChildren() {
		List result = new ArrayList();
		if (getProcessDefinition().getStartState() != null) {
			result.add(getProcessDefinition().getStartState());
		}
		NodeElement[] nodes = getProcessDefinition().getNodeElements();
		for (int i = 0; i < nodes.length; i++) {
			result.add(nodes[i]);
		}
		Event[] events = getProcessDefinition().getEvents();
		for (int i = 0; i < events.length; i++) {
			result.add(events[i]);
		}
		Task[] tasks = getProcessDefinition().getTasks();
		for (int i = 0; i < tasks.length; i++) {
			result.add(tasks[i]);
		}
		return result;
	}

	protected void refreshVisuals() {
		ImageDescriptor descriptor = ImageDescriptor.createFromURL(JpdlPlugin.getDefault()
				.getBundle().getEntry("/icons/full/obj16/process_definition_enabled.gif"));
		setWidgetImage(JpdlSharedImages.INSTANCE.getImage(descriptor));
		String name = getProcessDefinition().getName();
		setWidgetText(name == null ? "process-definition" : name);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("startStateAdd") 
				|| eventName.equals("nodeElementAdd")
				|| eventName.equals("eventAdd")
				|| eventName.equals("taskAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("startStateRemove")
				|| eventName.equals("nodeElementRemove")
				|| eventName.equals("eventRemove")
				|| eventName.equals("taskRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
	
}
