/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.outline.part;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.TaskNode;

public class TaskNodeOutlineEditPart extends NodeElementOutlineEditPart {
	
	public TaskNodeOutlineEditPart(AbstractNode node) {
		super(node);
	}
	
	private TaskNode getTaskNode() {
		return (TaskNode)getModel();
	}

	protected List getModelChildren() {
		List result = new ArrayList();
		result.addAll(super.getModelChildren());
		result.add(new TaskListOutlineEditPart(getTaskNode()));
		return result;
	}
	
//	protected List getModelChildren() {
//		List result = new ArrayList();
//		Task[] tasks = ((TaskNode)getNode()).getTasks();
//		for (int i = 0; i < tasks.length; i++) {
//			result.add(tasks[i]);
//		}
//		Event[] events = getNode().getEvents();
//		for (int i = 0; i < events.length; i++) {
//			result.add(events[i]);
//		}
//		Transition[] transitions = getNode().getTransitions();
//		for (int i = 0; i < transitions.length; i++) {
//			result.add(transitions[i]);
//		}
//		return result;
//	}
//
//	protected void refreshVisuals(){
//		ImageDescriptor descriptor = ImageDescriptor.createFromURL(JpdlPlugin.getDefault()
//				.getBundle().getEntry("/icons/full/obj16/task_node_enabled.gif"));
//		setWidgetImage(JpdlSharedImages.INSTANCE.getImage(descriptor));	
//		String name = getNode().getName();
//		setWidgetText(name == null ? "task" : name);
//	}

//	public void propertyChange(PropertyChangeEvent evt) {
//		String eventName = evt.getPropertyName();
//		if (eventName.equals("taskAdd")) {
//			handleChildAdd(evt.getNewValue());
//		} else if (eventName.equals("taskRemove")) {
//			refreshChildren();
//			getViewer().select(this);
//		} else {
//			super.propertyChange(evt);
//		}
//	}
	
}
