package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.EventContainer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

public class TransitionListOutlineEditPart extends JpdlElementOutlineEditPart {
	
	public TransitionListOutlineEditPart(EventContainer model) {
		super(model);
	}

	protected String getIconName() {
		return "transitions_multiple.gif";
	}
	
	protected String getText() {
		return "Transitions";
	}
	
	protected List getModelChildren() {
		List result = new ArrayList();
		Transition[] transitions = ((NodeElement)getModel()). getTransitions();
		for (int i = 0; i < transitions.length; i++) {
			result.add(transitions[i]);
		}
		return result;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("transitionAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("transitionRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
}
