package org.jbpm.gd.jpdl.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Assignment;
import org.jbpm.gd.jpdl.model.ConfigInfoElement;
import org.jbpm.gd.jpdl.ui.dialog.ChooseDelegationClassDialog;

public class AssignmentInformationPageBook implements PropertyChangeListener, ModifyListener {
	
	public static AssignmentInformationPageBook create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		AssignmentInformationPageBook result = new AssignmentInformationPageBook();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}
	
	private TabbedPropertySheetWidgetFactory widgetFactory;
	private Composite parent;
	
	private Assignment assignment;
	
	private ScrolledPageBook assignmentInfoPageBook;
	private Text expressionText;
	private Label expressionLabel; 
	private Text actorText;
	private Label actorLabel;
	private Text pooledActorsText;
	private Label pooledActorsLabel;
	private DelegationConfigurationComposite delegationConfigurationComposite;
	
	private AssignmentInformationPageBook() {}
	
	private void create() {
		assignmentInfoPageBook = widgetFactory.createPageBook(parent, SWT.V_SCROLL);
		assignmentInfoPageBook.setAlwaysShowScrollBars(true);
		assignmentInfoPageBook.setLayoutData(createAssignmentInfoPageBookLayoutData());
		createAssignmentInfoPages();
	}
	
	private void createAssignmentInfoPages() {		
		createExpressionPage();		
		createActorPage();		
		createPooledActorsPage();		
		createHandlerConfigurationPage();
	}
	
	private void createHandlerConfigurationPage() {
		Composite handlerConfigurationPage = assignmentInfoPageBook.createPage("Handler");
		handlerConfigurationPage.setLayout(new FormLayout());
		delegationConfigurationComposite = DelegationConfigurationComposite.create(widgetFactory, handlerConfigurationPage);
		delegationConfigurationComposite.setChooseDelegationClassDialog(createChooseAssignmentHandlerDialog());
	}
	
	private ChooseDelegationClassDialog createChooseAssignmentHandlerDialog() {
		return new ChooseDelegationClassDialog(
				null, 
				"org.jbpm.taskmgmt.def.AssignmentHandler",
				"Choose Assignment Handler",
				"Choose an assignment handler from the list");
	}
	
	private void createPooledActorsPage() {
		Composite pooledActorsPage = assignmentInfoPageBook.createPage("Pooled Actors");
		pooledActorsPage.setLayout(new FormLayout());
		pooledActorsLabel = widgetFactory.createLabel(pooledActorsPage, "Pooled Actors");
		pooledActorsText = widgetFactory.createText(pooledActorsPage, "");
		pooledActorsLabel.setLayoutData(createPooledActorsLabelLayoutData());
		pooledActorsText.setLayoutData(createPooledActorsTextLayoutData());
	}

	private FormData createPooledActorsLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 10);
		return data;
	}
	
	private FormData createPooledActorsTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(pooledActorsLabel, 5);
		data.top = new FormAttachment(0, 10);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private void createActorPage() {
		Composite actorPage = assignmentInfoPageBook.createPage("Actor");
		actorPage.setLayout(new FormLayout());
		actorLabel = widgetFactory.createLabel(actorPage, "Actor");
		actorText = widgetFactory.createText(actorPage, "");
		actorLabel.setLayoutData(createActorLabelLayoutData());
		actorText.setLayoutData(createActorTextLayoutData());
	}

	private FormData createActorLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 10);
		return data;
	}
	
	private FormData createActorTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(actorLabel, 5);
		data.top = new FormAttachment(0, 10);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private void createExpressionPage() {
		Composite expressionPage = assignmentInfoPageBook.createPage("Expression");
		expressionPage.setLayout(new FormLayout());
		expressionLabel = widgetFactory.createLabel(expressionPage, "Expression");
		expressionText = widgetFactory.createText(expressionPage, "");
		expressionLabel.setLayoutData(createExpressionLabelLayoutData());
		expressionText.setLayoutData(createExpressionTextLayoutData());
	}

	private FormData createExpressionLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 10);
		return data;
	}
	
	private FormData createExpressionTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(expressionLabel, 5);
		data.top = new FormAttachment(0, 10);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createAssignmentInfoPageBookLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.top = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.bottom = new FormAttachment(100, 0);
		return data;
	}
	
	public void showEmptyPage() {
		assignmentInfoPageBook.showEmptyPage();
	}
	
	public void showPage(Object key) {
		assignmentInfoPageBook.showPage(key);
	}
	
	public void clear() {
		showEmptyPage();
	}
	
	public void setAssignment(Assignment newAssignment) {
		pooledActorsText.removeModifyListener(this);
		actorText.removeModifyListener(this);
		expressionText.removeModifyListener(this);
		if (assignment != null) {
			assignment.removePropertyChangeListener(this);
		}
		assignment = newAssignment;
		delegationConfigurationComposite.setDelegation(newAssignment);
		updatePages();
		if (assignment != null) {
			assignment.addPropertyChangeListener(this);
		}
		pooledActorsText.addModifyListener(this);
		actorText.addModifyListener(this);
		expressionText.addModifyListener(this);
	}
	
	private void updatePages() {
		if (assignment == null) {
			expressionText.setText("");
			actorText.setText("");
			pooledActorsText.setText("");
			showEmptyPage();
		} else if (assignment.getExpression() != null) {			
			expressionText.setText(assignment.getExpression());
			actorText.setText("");
			pooledActorsText.setText("");
			showPage("Expression");
		} else if (assignment.getActorId() != null) {
			expressionText.setText("");
			actorText.setText(assignment.getActorId());
			pooledActorsText.setText("");
			showPage("Actor");
		} else if (assignment.getPooledActors() != null) {
			expressionText.setText("");
			actorText.setText("");
			pooledActorsText.setText(assignment.getPooledActors());
			showPage("Pooled Actors");
		} else if (assignment.getClassName() != null) {
			expressionText.setText("");
			actorText.setText("");
			pooledActorsText.setText("");
			showPage("Handler");
		}
	}
	
	String selectedKey = "";
	
	public void updateAssignmentInfo(String key) {
		if (selectedKey.equals(key)) return;
		removeAssignmentInfo();
		if ("".equals(key)) {
			selectedKey = "";
			showEmptyPage();
		} else {
			if ("Expression".equals(key)) {
				selectedKey = "Expression";
				assignment.setExpression(expressionText.getText());
			} else if ("Actor".equals(key)) {
				selectedKey = "Actor";
				assignment.setActorId(actorText.getText());
			} else if ("Pooled Actors".equals(key)) {
				selectedKey = "Pooled Actors";
				assignment.setPooledActors(pooledActorsText.getText());
			} else if ("Handler".equals(key)) {
				selectedKey = "Handler";
				delegationConfigurationComposite.updateDelegationInfo(assignment);
			}
			showPage(key);
		}
	}
	
	private void removeAssignmentInfo() {
		if (assignment == null) return;
		if (assignment.getActorId() != null) {
			assignment.setActorId(null);
		} else if (assignment.getExpression() != null) {
			assignment.setExpression(null);
		} else if (assignment.getPooledActors() != null) {
			assignment.setPooledActors(null);
		} else if (assignment.getClassName() != null) {
			assignment.setClassName(null);
			assignment.setConfigInfoString(null);
			assignment.setConfigType(null);
			ConfigInfoElement[] configInfoElements = assignment.getConfigInfoElements();
			for (int i = 0; i < configInfoElements.length; i++) {
				assignment.removeConfigInfoElement(configInfoElements[i]);
			}
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		// TODO Auto-generated method stub
		
	}

	public void modifyText(ModifyEvent e) {
		if (assignment == null) return;
		if (e.widget == expressionText) {
			assignment.setExpression(expressionText.getText());
		} else if (e.widget == actorText) {
			assignment.setActorId(actorText.getText());
		} else if (e.widget == pooledActorsText) {
			assignment.setPooledActors(pooledActorsText.getText());
		}
	}
	
	public void setVisible(boolean visible) {
		assignmentInfoPageBook.setVisible(visible);
	}
	
}
