package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Script;

public class CreateTimerConfigurationComposite implements SelectionListener, FocusListener {
	
	public static CreateTimerConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		CreateTimerConfigurationComposite result = new CreateTimerConfigurationComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}
	
	private TabbedPropertySheetWidgetFactory widgetFactory;
	private Composite parent;
	
	private Group createTimerInfoGroup;
	private Label nameLabel;
	private Text nameText;
	private Label transitionLabel;
	private Text transitionText;
	private Label actionTypeLabel;
	private CCombo actionTypeCombo;
	private Label dueDateLabel;
	private Text dueDateText;
	private Label repeatLabel;
	private Text repeatText;
	private Composite actionComposite;
	private Composite scriptComposite;
	private ActionConfigurationComposite actionConfigurationComposite;
	private ScriptConfigurationComposite scriptConfigurationComposite;
	
	private CreateTimer createTimer;
	
	private CreateTimerConfigurationComposite() {}
	
	public void setCreateTimer(CreateTimer createTimer) {
		if (this.createTimer == createTimer) return;
		unhookListeners();
		this.createTimer = createTimer;
		if (createTimer == null) {
			clearControls();
		} else {
			updateControls();
			hookListeners();
		}
	}
	
	private void hookListeners() {
		nameText.addSelectionListener(this);
		transitionText.addSelectionListener(this);
		dueDateText.addSelectionListener(this);
		repeatText.addSelectionListener(this);
		actionTypeCombo.addSelectionListener(this);
		nameText.addFocusListener(this);
		transitionText.addFocusListener(this);
		dueDateText.addFocusListener(this);
		repeatText.addFocusListener(this);
	}
	
	private void unhookListeners() {
		nameText.removeSelectionListener(this);
		transitionText.removeSelectionListener(this);
		dueDateText.removeSelectionListener(this);
		repeatText.removeSelectionListener(this);
		actionTypeCombo.removeSelectionListener(this);
		nameText.removeFocusListener(this);
		transitionText.removeFocusListener(this);
		dueDateText.removeFocusListener(this);
		repeatText.removeFocusListener(this);
	}
	
	private void clearControls() {
		nameText.setText("");
		transitionText.setText("");
		actionTypeCombo.setText("None");
		dueDateText.setText("");
		repeatText.setText("");
		actionComposite.setVisible(false);
		actionConfigurationComposite.setAction(null);
		scriptComposite.setVisible(false);
		scriptConfigurationComposite.setScript(null);
	}
	
	private void updateControls() {
		nameText.setText(createTimer.getName() == null ? "" : createTimer.getName());
		transitionText.setText(createTimer.getTransition() == null ? "" : createTimer.getTransition());
		if (createTimer.getScript() != null) {
			actionTypeCombo.setText("Script");
			scriptConfigurationComposite.setScript(createTimer.getScript());
			scriptComposite.setVisible(true);
		} else if (createTimer.getAction() != null) {
			actionTypeCombo.setText("Action");
			actionConfigurationComposite.setAction(createTimer.getAction());
			actionComposite.setVisible(true);
		} else {
			actionTypeCombo.setText("None");
		}
		dueDateText.setText(createTimer.getDueDate() == null ? "" : createTimer.getDueDate());
		repeatText.setText(createTimer.getRepeat() == null ? "" : createTimer.getRepeat());
	}
	
	private void create() {
		createTimerInfoGroup = widgetFactory.createGroup(parent, "Create Timer Info");
		createTimerInfoGroup.setLayout(new FormLayout());
		createTimerInfoGroup.setLayoutData(createCreateTimerInfoGroupLayoutData());
		nameLabel = widgetFactory.createLabel(createTimerInfoGroup, "Name");
		nameText = widgetFactory.createText(createTimerInfoGroup, "");
		transitionLabel = widgetFactory.createLabel(createTimerInfoGroup, "Transition");
		transitionText = widgetFactory.createText(createTimerInfoGroup, "");
		actionTypeLabel = widgetFactory.createLabel(createTimerInfoGroup, "Action Type");
		actionTypeCombo = widgetFactory.createCCombo(createTimerInfoGroup, SWT.BORDER);
		actionTypeCombo.setItems( new String[] {"None", "Action", "Script"});
		actionTypeCombo.addSelectionListener(this);
		dueDateLabel = widgetFactory.createLabel(createTimerInfoGroup, "Due Date");
		dueDateText = widgetFactory.createText(createTimerInfoGroup, "");
		repeatLabel = widgetFactory.createLabel(createTimerInfoGroup, "Repeat");
		repeatText = widgetFactory.createText(createTimerInfoGroup, "");
		actionComposite = widgetFactory.createComposite(parent);
		actionComposite.setLayout(new FormLayout());
		actionConfigurationComposite = ActionConfigurationComposite.create(widgetFactory, actionComposite);
		actionComposite.setVisible(false);
		scriptComposite = widgetFactory.createComposite(parent);
		scriptComposite.setLayout(new FormLayout());
		scriptConfigurationComposite = ScriptConfigurationComposite.create(widgetFactory, scriptComposite);
		scriptComposite.setVisible(false);
		nameLabel.setLayoutData(createNameLabelLayoutData());
		nameText.setLayoutData(createNameTextLayoutData());
		transitionLabel.setLayoutData(createTransitionLabelLayoutData());
		transitionText.setLayoutData(createTransitionTextLayoutData());
		actionTypeLabel.setLayoutData(createActionTypeLabelLayoutData());
		actionTypeCombo.setLayoutData(createActionTypeComboLayoutData());
		dueDateLabel.setLayoutData(createDueDateLabelLayoutData());
		dueDateText.setLayoutData(createDueDateTextLayoutData());
		repeatLabel.setLayoutData(createRepeatLabelLayoutData());
		repeatText.setLayoutData(createRepeatTextLayoutData());
		actionComposite.setLayoutData(createActionCompositeLayoutData());
		scriptComposite.setLayoutData(createActionCompositeLayoutData());
	}
	
	private FormData createActionCompositeLayoutData() {
		FormData data = new FormData();
		data.top = new FormAttachment(createTimerInfoGroup, 0);
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.bottom = new FormAttachment(100, 0);
		return data;
	}
	
	private FormData createRepeatTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(repeatLabel, 5);
		data.top = new FormAttachment(nameText, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createRepeatLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(70, 5);
		data.top = new FormAttachment(nameText, 5);
		return data;
	}
	
	private FormData createDueDateTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(transitionText, 0);
		data.left.alignment = SWT.LEFT;
		data.top = new FormAttachment(nameText, 5);
		data.right = new FormAttachment(70, 0);
		return data;
	}
	
	private FormData createDueDateLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(40, 5);
		data.top = new FormAttachment(nameText, 5);
		return data;
	}
	
	private FormData createActionTypeComboLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(actionTypeLabel, 5);
		data.top = new FormAttachment(nameText, 5);
		data.right = new FormAttachment(40, 0);
		data.bottom = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createActionTypeLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(nameText, 5);
		return data;
	}
	
	private FormData createNameLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	
	private FormData createNameTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(actionTypeCombo, 0);
		data.left.alignment = SWT.LEFT;
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(40, 0);
		return data;
	}
	
	private FormData createTransitionLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(40, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	
	private FormData createTransitionTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(transitionLabel, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createCreateTimerInfoGroupLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		if (e.widget == nameText) {
			createTimer.setName(nameText.getText());
		} else if (e.widget == transitionText) {
			createTimer.setTransition(transitionText.getText());
		} else if (e.widget == dueDateText) {
			createTimer.setDueDate(dueDateText.getText());
		} else if (e.widget == repeatText) {
			createTimer.setRepeat(repeatText.getText());
		}
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == actionTypeCombo) {
			handleActionTypeComboSelected();
		}
	}
	
	private void handleActionTypeComboSelected() {
		if ("None".equals(actionTypeCombo.getText())) {
			if (createTimer.getAction() != null) {
				createTimer.setAction(null);
			} else if (createTimer.getScript() != null) {
				createTimer.setScript(null);
			}
		} else if ("Action".equals(actionTypeCombo.getText())) {
			if (actionConfigurationComposite.getAction() == null) {
				actionConfigurationComposite.setAction(
						(Action)JpdlElementFactory.INSTANCE.createById("org.jbpm.gd.jpdl.core.action"));
			}
			createTimer.setScript(null);
			createTimer.setAction(actionConfigurationComposite.getAction());
		} else if ("Script".equals(actionTypeCombo.getText())) {
			if (scriptConfigurationComposite.getScript() == null) {
				scriptConfigurationComposite.setScript(
						(Script)JpdlElementFactory.INSTANCE.createById("org.jbpm.gd.jpdl.core.script"));
			}
			createTimer.setAction(null);
			createTimer.setScript(scriptConfigurationComposite.getScript());
		}
		actionComposite.setVisible("Action".equals(actionTypeCombo.getText()));
		scriptComposite.setVisible("Script".equals(actionTypeCombo.getText()));
	}

	public void focusGained(FocusEvent e) {
	}

	public void focusLost(FocusEvent e) {
		if (e.widget == nameText) {
			createTimer.setName(nameText.getText());
		} else if (e.widget == transitionText) {
			createTimer.setTransition(transitionText.getText());
		} else if (e.widget == dueDateText) {
			createTimer.setDueDate(dueDateText.getText());
		} else if (e.widget == repeatText) {
			createTimer.setRepeat(repeatText.getText());
		}
	}
	
}
